/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * The device spec used to generate a system APK.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeviceSpec extends com.google.api.client.json.GenericJson {

  /**
   * Screen dpi.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long screenDensity;

  /**
   * Supported ABI architectures in the order of preference. The values should be the string as
   * reported by the platform, e.g. "armeabi-v7a", "x86_64".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> supportedAbis;

  /**
   * All installed locales represented as BCP-47 strings, e.g. "en-US".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> supportedLocales;

  /**
   * Screen dpi.
   * @return value or {@code null} for none
   */
  public java.lang.Long getScreenDensity() {
    return screenDensity;
  }

  /**
   * Screen dpi.
   * @param screenDensity screenDensity or {@code null} for none
   */
  public DeviceSpec setScreenDensity(java.lang.Long screenDensity) {
    this.screenDensity = screenDensity;
    return this;
  }

  /**
   * Supported ABI architectures in the order of preference. The values should be the string as
   * reported by the platform, e.g. "armeabi-v7a", "x86_64".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSupportedAbis() {
    return supportedAbis;
  }

  /**
   * Supported ABI architectures in the order of preference. The values should be the string as
   * reported by the platform, e.g. "armeabi-v7a", "x86_64".
   * @param supportedAbis supportedAbis or {@code null} for none
   */
  public DeviceSpec setSupportedAbis(java.util.List<java.lang.String> supportedAbis) {
    this.supportedAbis = supportedAbis;
    return this;
  }

  /**
   * All installed locales represented as BCP-47 strings, e.g. "en-US".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSupportedLocales() {
    return supportedLocales;
  }

  /**
   * All installed locales represented as BCP-47 strings, e.g. "en-US".
   * @param supportedLocales supportedLocales or {@code null} for none
   */
  public DeviceSpec setSupportedLocales(java.util.List<java.lang.String> supportedLocales) {
    this.supportedLocales = supportedLocales;
    return this;
  }

  @Override
  public DeviceSpec set(String fieldName, Object value) {
    return (DeviceSpec) super.set(fieldName, value);
  }

  @Override
  public DeviceSpec clone() {
    return (DeviceSpec) super.clone();
  }

}
