/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * LINT.IfChange Configuration describing device targeting criteria for the content of an app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeviceTierConfig extends com.google.api.client.json.GenericJson {

  /**
   * Definition of device groups for the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DeviceGroup> deviceGroups;

  static {
    // hack to force ProGuard to consider DeviceGroup used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DeviceGroup.class);
  }

  /**
   * Output only. The device tier config ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long deviceTierConfigId;

  /**
   * Definition of the set of device tiers for the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeviceTierSet deviceTierSet;

  /**
   * Definition of device groups for the app.
   * @return value or {@code null} for none
   */
  public java.util.List<DeviceGroup> getDeviceGroups() {
    return deviceGroups;
  }

  /**
   * Definition of device groups for the app.
   * @param deviceGroups deviceGroups or {@code null} for none
   */
  public DeviceTierConfig setDeviceGroups(java.util.List<DeviceGroup> deviceGroups) {
    this.deviceGroups = deviceGroups;
    return this;
  }

  /**
   * Output only. The device tier config ID.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDeviceTierConfigId() {
    return deviceTierConfigId;
  }

  /**
   * Output only. The device tier config ID.
   * @param deviceTierConfigId deviceTierConfigId or {@code null} for none
   */
  public DeviceTierConfig setDeviceTierConfigId(java.lang.Long deviceTierConfigId) {
    this.deviceTierConfigId = deviceTierConfigId;
    return this;
  }

  /**
   * Definition of the set of device tiers for the app.
   * @return value or {@code null} for none
   */
  public DeviceTierSet getDeviceTierSet() {
    return deviceTierSet;
  }

  /**
   * Definition of the set of device tiers for the app.
   * @param deviceTierSet deviceTierSet or {@code null} for none
   */
  public DeviceTierConfig setDeviceTierSet(DeviceTierSet deviceTierSet) {
    this.deviceTierSet = deviceTierSet;
    return this;
  }

  @Override
  public DeviceTierConfig set(String fieldName, Object value) {
    return (DeviceTierConfig) super.set(fieldName, value);
  }

  @Override
  public DeviceTierConfig clone() {
    return (DeviceTierConfig) super.clone();
  }

}
