/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.event;

import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.event.MailEvent;
import javax.mail.event.MessageCountListener;

public class MessageCountEvent
extends MailEvent {
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    protected transient Message[] msgs;
    protected int type;
    protected boolean removed;

    public MessageCountEvent(Folder folder, int type, boolean removed, Message[] messages) {
        super(folder);
        this.msgs = messages;
        this.type = type;
        this.removed = removed;
    }

    public int getType() {
        return this.type;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public Message[] getMessages() {
        return this.msgs;
    }

    @Override
    public void dispatch(Object listener) {
        MessageCountListener l = (MessageCountListener)listener;
        switch (this.type) {
            case 1: {
                l.messagesAdded(this);
                break;
            }
            case 2: {
                l.messagesRemoved(this);
                break;
            }
            default: {
                int n = this.type;
                throw new IllegalArgumentException(new StringBuilder(24).append("Invalid type ").append(n).toString());
            }
        }
    }
}

