/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.ChannelLogger;
import io.grpc.ExperimentalApi;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.Internal;
import io.grpc.ManagedChannelBuilder;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AtomicBackoff;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.KeepAliveManager;
import io.grpc.internal.ManagedChannelImplBuilder;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.internal.TransportTracer;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyClientTransport;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.ProtocolNegotiators;
import io.grpc.netty.Utils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1784")
@CanIgnoreReturnValue
public final class NettyChannelBuilder
extends AbstractManagedChannelImplBuilder<NettyChannelBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    private static final boolean DEFAULT_AUTO_FLOW_CONTROL;
    private static final long AS_LARGE_AS_INFINITE;
    private static final ChannelFactory<? extends Channel> DEFAULT_CHANNEL_FACTORY;
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_EVENT_LOOP_GROUP_POOL;
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    private final Map<ChannelOption<?>, Object> channelOptions = new HashMap();
    private ChannelFactory<? extends Channel> channelFactory = DEFAULT_CHANNEL_FACTORY;
    private ObjectPool<? extends EventLoopGroup> eventLoopGroupPool = DEFAULT_EVENT_LOOP_GROUP_POOL;
    private boolean autoFlowControl = DEFAULT_AUTO_FLOW_CONTROL;
    private int flowControlWindow = 0x100000;
    private int maxInboundMessageSize = 0x400000;
    private int maxHeaderListSize = 8192;
    private long keepAliveTimeNanos = Long.MAX_VALUE;
    private long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    private boolean keepAliveWithoutCalls;
    private ProtocolNegotiator.ClientFactory protocolNegotiatorFactory = new DefaultProtocolNegotiator();
    private final boolean freezeProtocolNegotiatorFactory;
    private LocalSocketPicker localSocketPicker;
    private final boolean useGetForSafeMethods = false;

    @CheckReturnValue
    public static NettyChannelBuilder forAddress(SocketAddress serverAddress) {
        return new NettyChannelBuilder(serverAddress);
    }

    @CheckReturnValue
    public static NettyChannelBuilder forAddress(String host, int port) {
        return NettyChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    @CheckReturnValue
    public static NettyChannelBuilder forAddress(String host, int port, ChannelCredentials creds) {
        return NettyChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(host, port), creds);
    }

    @CheckReturnValue
    public static NettyChannelBuilder forTarget(String target) {
        return new NettyChannelBuilder(target);
    }

    @CheckReturnValue
    public static NettyChannelBuilder forTarget(String target, ChannelCredentials creds) {
        ProtocolNegotiators.FromChannelCredentialsResult result = ProtocolNegotiators.from(creds);
        if (result.error != null) {
            throw new IllegalArgumentException(result.error);
        }
        return new NettyChannelBuilder(target, creds, result.callCredentials, result.negotiator);
    }

    @CheckReturnValue
    NettyChannelBuilder(String target) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(target, new NettyChannelTransportFactoryBuilder(), new NettyChannelDefaultPortProvider());
        this.freezeProtocolNegotiatorFactory = false;
    }

    NettyChannelBuilder(String target, ChannelCredentials channelCreds, CallCredentials callCreds, ProtocolNegotiator.ClientFactory negotiator) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(target, channelCreds, callCreds, new NettyChannelTransportFactoryBuilder(), new NettyChannelDefaultPortProvider());
        this.protocolNegotiatorFactory = (ProtocolNegotiator.ClientFactory)Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        this.freezeProtocolNegotiatorFactory = true;
    }

    @CheckReturnValue
    NettyChannelBuilder(SocketAddress address) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(address, NettyChannelBuilder.getAuthorityFromAddress(address), new NettyChannelTransportFactoryBuilder(), new NettyChannelDefaultPortProvider());
        this.freezeProtocolNegotiatorFactory = false;
    }

    @Override
    @Internal
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    @CheckReturnValue
    private static String getAuthorityFromAddress(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            return GrpcUtil.authorityFromHostAndPort(inetAddress.getHostString(), inetAddress.getPort());
        }
        return address.toString();
    }

    public NettyChannelBuilder channelType(Class<? extends Channel> channelType) {
        Preconditions.checkNotNull(channelType, (Object)"channelType");
        return this.channelFactory((ChannelFactory<? extends Channel>)new ReflectiveChannelFactory(channelType));
    }

    public NettyChannelBuilder channelFactory(ChannelFactory<? extends Channel> channelFactory) {
        this.channelFactory = (ChannelFactory)Preconditions.checkNotNull(channelFactory, (Object)"channelFactory");
        return this;
    }

    public <T> NettyChannelBuilder withOption(ChannelOption<T> option, T value) {
        this.channelOptions.put(option, value);
        return this;
    }

    public NettyChannelBuilder negotiationType(NegotiationType type) {
        Preconditions.checkState((!this.freezeProtocolNegotiatorFactory ? 1 : 0) != 0, (Object)"Cannot change security when using ChannelCredentials");
        if (!(this.protocolNegotiatorFactory instanceof DefaultProtocolNegotiator)) {
            return this;
        }
        ((DefaultProtocolNegotiator)this.protocolNegotiatorFactory).negotiationType = type;
        return this;
    }

    public NettyChannelBuilder eventLoopGroup(@Nullable EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup != null) {
            return this.eventLoopGroupPool(new FixedObjectPool<EventLoopGroup>(eventLoopGroup));
        }
        return this.eventLoopGroupPool(DEFAULT_EVENT_LOOP_GROUP_POOL);
    }

    NettyChannelBuilder eventLoopGroupPool(ObjectPool<? extends EventLoopGroup> eventLoopGroupPool) {
        this.eventLoopGroupPool = (ObjectPool)Preconditions.checkNotNull(eventLoopGroupPool, (Object)"eventLoopGroupPool");
        return this;
    }

    public NettyChannelBuilder sslContext(SslContext sslContext) {
        Preconditions.checkState((!this.freezeProtocolNegotiatorFactory ? 1 : 0) != 0, (Object)"Cannot change security when using ChannelCredentials");
        if (sslContext != null) {
            Preconditions.checkArgument((boolean)sslContext.isClient(), (Object)"Server SSL context can not be used for client channel");
            GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        }
        if (!(this.protocolNegotiatorFactory instanceof DefaultProtocolNegotiator)) {
            return this;
        }
        ((DefaultProtocolNegotiator)this.protocolNegotiatorFactory).sslContext = sslContext;
        return this;
    }

    public NettyChannelBuilder initialFlowControlWindow(int initialFlowControlWindow) {
        Preconditions.checkArgument((initialFlowControlWindow > 0 ? 1 : 0) != 0, (Object)"initialFlowControlWindow must be positive");
        this.flowControlWindow = initialFlowControlWindow;
        this.autoFlowControl = true;
        return this;
    }

    public NettyChannelBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        this.autoFlowControl = false;
        return this;
    }

    @Deprecated
    public NettyChannelBuilder maxHeaderListSize(int maxHeaderListSize) {
        return this.maxInboundMetadataSize(maxHeaderListSize);
    }

    @Override
    public NettyChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMetadataSize must be > 0");
        this.maxHeaderListSize = bytes;
        return this;
    }

    @Override
    public NettyChannelBuilder usePlaintext() {
        this.negotiationType(NegotiationType.PLAINTEXT);
        return this;
    }

    @Override
    public NettyChannelBuilder useTransportSecurity() {
        this.negotiationType(NegotiationType.TLS);
        return this;
    }

    @Override
    public NettyChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTime > 0L ? 1 : 0) != 0, (Object)"keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    @Override
    public NettyChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTimeout > 0L ? 1 : 0) != 0, (Object)"keepalive timeout must be positive");
        this.keepAliveTimeoutNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos(this.keepAliveTimeoutNanos);
        return this;
    }

    @Override
    public NettyChannelBuilder keepAliveWithoutCalls(boolean enable) {
        this.keepAliveWithoutCalls = enable;
        return this;
    }

    public NettyChannelBuilder localSocketPicker(@Nullable LocalSocketPicker localSocketPicker) {
        this.localSocketPicker = localSocketPicker;
        return this;
    }

    @Override
    public NettyChannelBuilder maxInboundMessageSize(int max) {
        Preconditions.checkArgument((max >= 0 ? 1 : 0) != 0, (Object)"negative max");
        this.maxInboundMessageSize = max;
        return this;
    }

    @CheckReturnValue
    ClientTransportFactory buildTransportFactory() {
        this.assertEventLoopAndChannelType();
        ProtocolNegotiator negotiator = this.protocolNegotiatorFactory.newNegotiator();
        return new NettyTransportFactory(negotiator, this.channelFactory, this.channelOptions, this.eventLoopGroupPool, this.autoFlowControl, this.flowControlWindow, this.maxInboundMessageSize, this.maxHeaderListSize, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, this.transportTracerFactory, this.localSocketPicker, false);
    }

    @VisibleForTesting
    void assertEventLoopAndChannelType() {
        boolean bothProvided = this.channelFactory != DEFAULT_CHANNEL_FACTORY && this.eventLoopGroupPool != DEFAULT_EVENT_LOOP_GROUP_POOL;
        boolean nonProvided = this.channelFactory == DEFAULT_CHANNEL_FACTORY && this.eventLoopGroupPool == DEFAULT_EVENT_LOOP_GROUP_POOL;
        Preconditions.checkState((bothProvided || nonProvided ? 1 : 0) != 0, (Object)"Both EventLoopGroup and ChannelType should be provided or neither should be");
    }

    @CheckReturnValue
    int getDefaultPort() {
        return this.protocolNegotiatorFactory.getDefaultPort();
    }

    @CheckReturnValue
    @VisibleForTesting
    static ProtocolNegotiator createProtocolNegotiatorByType(NegotiationType negotiationType, SslContext sslContext, ObjectPool<? extends Executor> executorPool) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return ProtocolNegotiators.plaintext();
            }
            case PLAINTEXT_UPGRADE: {
                return ProtocolNegotiators.plaintextUpgrade();
            }
            case TLS: {
                return ProtocolNegotiators.tls(sslContext, executorPool);
            }
        }
        throw new IllegalArgumentException("Unsupported negotiationType: " + (Object)((Object)negotiationType));
    }

    NettyChannelBuilder disableCheckAuthority() {
        this.managedChannelImplBuilder.disableCheckAuthority();
        return this;
    }

    NettyChannelBuilder enableCheckAuthority() {
        this.managedChannelImplBuilder.enableCheckAuthority();
        return this;
    }

    void protocolNegotiatorFactory(ProtocolNegotiator.ClientFactory protocolNegotiatorFactory) {
        Preconditions.checkState((!this.freezeProtocolNegotiatorFactory ? 1 : 0) != 0, (Object)"Cannot change security when using ChannelCredentials");
        this.protocolNegotiatorFactory = (ProtocolNegotiator.ClientFactory)Preconditions.checkNotNull((Object)protocolNegotiatorFactory, (Object)"protocolNegotiatorFactory");
    }

    void setTracingEnabled(boolean value) {
        this.managedChannelImplBuilder.setTracingEnabled(value);
    }

    void setStatsEnabled(boolean value) {
        this.managedChannelImplBuilder.setStatsEnabled(value);
    }

    void setStatsRecordStartedRpcs(boolean value) {
        this.managedChannelImplBuilder.setStatsRecordStartedRpcs(value);
    }

    void setStatsRecordFinishedRpcs(boolean value) {
        this.managedChannelImplBuilder.setStatsRecordFinishedRpcs(value);
    }

    void setStatsRecordRealTimeMetrics(boolean value) {
        this.managedChannelImplBuilder.setStatsRecordRealTimeMetrics(value);
    }

    @VisibleForTesting
    NettyChannelBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    static {
        AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
        DEFAULT_CHANNEL_FACTORY = new ReflectiveChannelFactory(Utils.DEFAULT_CLIENT_CHANNEL_TYPE);
        DEFAULT_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP);
        String autoFlowControl = System.getenv("GRPC_EXPERIMENTAL_AUTOFLOWCONTROL");
        if (autoFlowControl == null) {
            autoFlowControl = "true";
        }
        DEFAULT_AUTO_FLOW_CONTROL = Boolean.parseBoolean(autoFlowControl);
    }

    @CheckReturnValue
    private static final class NettyTransportFactory
    implements ClientTransportFactory {
        private final ProtocolNegotiator protocolNegotiator;
        private final ChannelFactory<? extends Channel> channelFactory;
        private final Map<ChannelOption<?>, ?> channelOptions;
        private final ObjectPool<? extends EventLoopGroup> groupPool;
        private final EventLoopGroup group;
        private final boolean autoFlowControl;
        private final int flowControlWindow;
        private final int maxMessageSize;
        private final int maxHeaderListSize;
        private final long keepAliveTimeNanos;
        private final AtomicBackoff keepAliveBackoff;
        private final long keepAliveTimeoutNanos;
        private final boolean keepAliveWithoutCalls;
        private final TransportTracer.Factory transportTracerFactory;
        private final LocalSocketPicker localSocketPicker;
        private final boolean useGetForSafeMethods;
        private boolean closed;

        NettyTransportFactory(ProtocolNegotiator protocolNegotiator, ChannelFactory<? extends Channel> channelFactory, Map<ChannelOption<?>, ?> channelOptions, ObjectPool<? extends EventLoopGroup> groupPool, boolean autoFlowControl, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeNanos, long keepAliveTimeoutNanos, boolean keepAliveWithoutCalls, TransportTracer.Factory transportTracerFactory, LocalSocketPicker localSocketPicker, boolean useGetForSafeMethods) {
            this.protocolNegotiator = (ProtocolNegotiator)Preconditions.checkNotNull((Object)protocolNegotiator, (Object)"protocolNegotiator");
            this.channelFactory = channelFactory;
            this.channelOptions = new HashMap(channelOptions);
            this.groupPool = groupPool;
            this.group = groupPool.getObject();
            this.autoFlowControl = autoFlowControl;
            this.flowControlWindow = flowControlWindow;
            this.maxMessageSize = maxMessageSize;
            this.maxHeaderListSize = maxHeaderListSize;
            this.keepAliveTimeNanos = keepAliveTimeNanos;
            this.keepAliveBackoff = new AtomicBackoff("keepalive time nanos", keepAliveTimeNanos);
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            this.transportTracerFactory = transportTracerFactory;
            this.localSocketPicker = localSocketPicker != null ? localSocketPicker : new LocalSocketPicker();
            this.useGetForSafeMethods = useGetForSafeMethods;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"The transport factory is closed.");
            ProtocolNegotiator localNegotiator = this.protocolNegotiator;
            HttpConnectProxiedSocketAddress proxiedAddr = options.getHttpConnectProxiedSocketAddress();
            if (proxiedAddr != null) {
                serverAddress = proxiedAddr.getTargetAddress();
                localNegotiator = ProtocolNegotiators.httpProxy(proxiedAddr.getProxyAddress(), proxiedAddr.getUsername(), proxiedAddr.getPassword(), this.protocolNegotiator);
            }
            final AtomicBackoff.State keepAliveTimeNanosState = this.keepAliveBackoff.getState();
            Runnable tooManyPingsRunnable = new Runnable(){

                @Override
                public void run() {
                    keepAliveTimeNanosState.backoff();
                }
            };
            NettyClientTransport transport = new NettyClientTransport(serverAddress, this.channelFactory, this.channelOptions, this.group, localNegotiator, this.autoFlowControl, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, keepAliveTimeNanosState.get(), this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, options.getAuthority(), options.getUserAgent(), tooManyPingsRunnable, this.transportTracerFactory.create(), options.getEagAttributes(), this.localSocketPicker, channelLogger, this.useGetForSafeMethods);
            return transport;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.group;
        }

        @Override
        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            Preconditions.checkNotNull((Object)channelCreds, (Object)"channelCreds");
            ProtocolNegotiators.FromChannelCredentialsResult result = ProtocolNegotiators.from(channelCreds);
            if (result.error != null) {
                return null;
            }
            NettyTransportFactory factory = new NettyTransportFactory(result.negotiator.newNegotiator(), this.channelFactory, this.channelOptions, this.groupPool, this.autoFlowControl, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, this.transportTracerFactory, this.localSocketPicker, this.useGetForSafeMethods);
            return new ClientTransportFactory.SwapChannelCredentialsResult(factory, result.callCredentials);
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.protocolNegotiator.close();
            this.groupPool.returnObject(this.group);
        }
    }

    private final class DefaultProtocolNegotiator
    implements ProtocolNegotiator.ClientFactory {
        private NegotiationType negotiationType = NegotiationType.TLS;
        private SslContext sslContext;

        private DefaultProtocolNegotiator() {
        }

        @Override
        public ProtocolNegotiator newNegotiator() {
            SslContext localSslContext = this.sslContext;
            if (this.negotiationType == NegotiationType.TLS && localSslContext == null) {
                try {
                    localSslContext = GrpcSslContexts.forClient().build();
                }
                catch (SSLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return NettyChannelBuilder.createProtocolNegotiatorByType(this.negotiationType, localSslContext, NettyChannelBuilder.this.managedChannelImplBuilder.getOffloadExecutorPool());
        }

        @Override
        public int getDefaultPort() {
            switch (this.negotiationType) {
                case PLAINTEXT: 
                case PLAINTEXT_UPGRADE: {
                    return 80;
                }
                case TLS: {
                    return 443;
                }
            }
            throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4917")
    public static class LocalSocketPicker {
        @Nullable
        public SocketAddress createSocketAddress(SocketAddress remoteAddress, Attributes attrs) {
            return null;
        }
    }

    private final class NettyChannelDefaultPortProvider
    implements ManagedChannelImplBuilder.ChannelBuilderDefaultPortProvider {
        private NettyChannelDefaultPortProvider() {
        }

        @Override
        public int getDefaultPort() {
            return NettyChannelBuilder.this.protocolNegotiatorFactory.getDefaultPort();
        }
    }

    private final class NettyChannelTransportFactoryBuilder
    implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
        private NettyChannelTransportFactoryBuilder() {
        }

        @Override
        public ClientTransportFactory buildClientTransportFactory() {
            return NettyChannelBuilder.this.buildTransportFactory();
        }
    }
}

