/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.Impl;
import io.perfmark.Link;
import io.perfmark.StringFunction;
import io.perfmark.Tag;
import io.perfmark.impl.Generator;
import io.perfmark.impl.NoopGenerator;
import io.perfmark.impl.Storage;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class SecretPerfMarkImpl {
    SecretPerfMarkImpl() {
    }

    public static final class PerfMarkImpl
    extends Impl {
        private static final Tag NO_TAG = PerfMarkImpl.packTag("", Long.MIN_VALUE);
        private static final Link NO_LINK = PerfMarkImpl.packLink(Long.MIN_VALUE);
        private static final long INCREMENT = 256L;
        private static final String START_ENABLED_PROPERTY = "io.perfmark.PerfMark.startEnabled";
        private static final AtomicLong linkIdAlloc = new AtomicLong(1L);
        private static final Generator generator;
        private static final Logger logger;
        private static long actualGeneration;

        public PerfMarkImpl(Tag key) {
            super(key);
        }

        @Override
        protected synchronized void setEnabled(boolean value) {
            PerfMarkImpl.logEnabledChange(value, PerfMarkImpl.setEnabledQuiet(value));
        }

        private static synchronized void logEnabledChange(boolean value, boolean success) {
            if (success && logger.isLoggable(Level.FINE)) {
                logger.fine((value ? "Enabling" : "Disabling") + " PerfMark recorder");
            }
        }

        private static synchronized boolean setEnabledQuiet(boolean value) {
            if (PerfMarkImpl.isEnabled(actualGeneration) == value) {
                return false;
            }
            if (actualGeneration == -512L) {
                return false;
            }
            generator.setGeneration(actualGeneration += 256L);
            return true;
        }

        @Override
        protected void startTask(String taskName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyways(gen, taskName, PerfMarkImpl.unpackTagName(tag), PerfMarkImpl.unpackTagId(tag));
        }

        @Override
        protected void startTask(String taskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyways(gen, taskName);
        }

        @Override
        protected void startTask(String taskName, String subTaskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyways(gen, taskName, subTaskName);
        }

        @Override
        protected <T> void startTask(T taskNameObject, StringFunction<? super T> stringFunction) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            String taskName = PerfMarkImpl.deriveTaskValue(taskNameObject, stringFunction);
            Storage.startAnyways(gen, taskName);
        }

        @Override
        protected void stopTask() {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyways(gen);
        }

        @Override
        protected void stopTask(String taskName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyways(gen, taskName, PerfMarkImpl.unpackTagName(tag), PerfMarkImpl.unpackTagId(tag));
        }

        @Override
        protected void stopTask(String taskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyways(gen, taskName);
        }

        @Override
        protected void stopTask(String taskName, String subTaskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyways(gen, taskName, subTaskName);
        }

        @Override
        protected void event(String eventName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyways(gen, eventName, PerfMarkImpl.unpackTagName(tag), PerfMarkImpl.unpackTagId(tag));
        }

        @Override
        protected void event(String eventName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyways(gen, eventName);
        }

        @Override
        protected void event(String eventName, String subEventName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyways(gen, eventName, subEventName);
        }

        @Override
        protected void attachTag(Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.attachTagAnyways(gen, PerfMarkImpl.unpackTagName(tag), PerfMarkImpl.unpackTagId(tag));
        }

        @Override
        protected void attachTag(String tagName, String tagValue) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.attachKeyedTagAnyways(gen, tagName, tagValue);
        }

        @Override
        protected <T> void attachTag(String tagName, T tagObject, StringFunction<? super T> stringFunction) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            String tagValue = PerfMarkImpl.deriveTagValue(tagName, tagObject, stringFunction);
            Storage.attachKeyedTagAnyways(gen, tagName, tagValue);
        }

        static <T> String deriveTagValue(String tagName, T tagObject, StringFunction<? super T> stringFunction) {
            try {
                return stringFunction.apply(tagObject);
            }
            catch (Throwable t) {
                PerfMarkImpl.handleTagValueFailure(tagName, tagObject, stringFunction, t);
                return "PerfMarkTagError:" + t.getClass().getName();
            }
        }

        static <T> String deriveTaskValue(T taskNameObject, StringFunction<? super T> stringFunction) {
            try {
                return stringFunction.apply(taskNameObject);
            }
            catch (Throwable t) {
                PerfMarkImpl.handleTaskNameFailure(taskNameObject, stringFunction, t);
                return "PerfMarkTaskError:" + t.getClass().getName();
            }
        }

        static <T> void handleTagValueFailure(String tagName, T tagObject, StringFunction<? super T> stringFunction, Throwable cause) {
            try {
                if (logger.isLoggable(Level.WARNING)) {
                    LogRecord lr = new LogRecord(Level.WARNING, "PerfMark.attachTag failed: tagName={0}, tagObject={1}, stringFunction={2}");
                    lr.setParameters(new Object[]{tagName, tagObject, stringFunction});
                    lr.setThrown(cause);
                    logger.log(lr);
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "PerfMark.attachTag failed for {0}: {1}", new Object[]{tagName, t.getClass()});
            }
        }

        static <T> void handleTaskNameFailure(T taskNameObject, StringFunction<? super T> stringFunction, Throwable cause) {
            try {
                if (logger.isLoggable(Level.WARNING)) {
                    LogRecord lr = new LogRecord(Level.WARNING, "PerfMark.startTask failed: taskObject={0}, stringFunction={1}");
                    lr.setParameters(new Object[]{taskNameObject, stringFunction});
                    lr.setThrown(cause);
                    logger.log(lr);
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "PerfMark.startTask failed for {0}", new Object[]{t.getClass()});
            }
        }

        @Override
        protected void attachTag(String tagName, long tagValue) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.attachKeyedTagAnyways(gen, tagName, tagValue);
        }

        @Override
        protected void attachTag(String tagName, long tagValue0, long tagValue1) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.attachKeyedTagAnyways(gen, tagName, tagValue0, tagValue1);
        }

        @Override
        protected Tag createTag(@Nullable String tagName, long tagId) {
            if (!PerfMarkImpl.isEnabled(PerfMarkImpl.getGen())) {
                return NO_TAG;
            }
            return PerfMarkImpl.packTag(tagName, tagId);
        }

        @Override
        protected Link linkOut() {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return NO_LINK;
            }
            long linkId = linkIdAlloc.getAndIncrement();
            Storage.linkAnyways(gen, linkId);
            return PerfMarkImpl.packLink(linkId);
        }

        @Override
        protected void linkIn(Link link) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.linkAnyways(gen, -PerfMarkImpl.unpackLinkId(link));
        }

        private static long getGen() {
            return generator.getGeneration();
        }

        private static boolean isEnabled(long gen) {
            return (gen >>> 8 & 1L) != 0L;
        }

        static {
            ArrayList<Generator> generators = new ArrayList<Generator>();
            ArrayList<ClassNotFoundException> fines = new ArrayList<ClassNotFoundException>();
            ArrayList<Throwable> warnings = new ArrayList<Throwable>();
            Class<?> clz = null;
            try {
                clz = Class.forName("io.perfmark.java7.SecretMethodHandleGenerator$MethodHandleGenerator");
            }
            catch (ClassNotFoundException e) {
                fines.add(e);
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            if (clz != null) {
                try {
                    generators.add(clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    warnings.add(t);
                }
                clz = null;
            }
            try {
                clz = Class.forName("io.perfmark.java9.SecretVarHandleGenerator$VarHandleGenerator");
            }
            catch (ClassNotFoundException e) {
                fines.add(e);
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            if (clz != null) {
                try {
                    generators.add(clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    warnings.add(t);
                }
                clz = null;
            }
            try {
                clz = Class.forName("io.perfmark.java6.SecretVolatileGenerator$VolatileGenerator");
            }
            catch (ClassNotFoundException e) {
                fines.add(e);
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            if (clz != null) {
                try {
                    generators.add(clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    warnings.add(t);
                }
                clz = null;
            }
            generator = !generators.isEmpty() ? (Generator)generators.get(0) : new NoopGenerator();
            boolean startEnabled = false;
            try {
                startEnabled = Boolean.parseBoolean(System.getProperty(START_ENABLED_PROPERTY, "false"));
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            boolean success = PerfMarkImpl.setEnabledQuiet(startEnabled);
            logger = Logger.getLogger(PerfMarkImpl.class.getName());
            logger.log(Level.FINE, "Using {0}", new Object[]{generator.getClass().getName()});
            for (Throwable throwable : warnings) {
                logger.log(Level.WARNING, "Error loading MarkHolderProvider", throwable);
            }
            for (Throwable throwable : fines) {
                logger.log(Level.FINE, "Error loading MarkHolderProvider", throwable);
            }
            PerfMarkImpl.logEnabledChange(startEnabled, success);
        }
    }
}

