/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.AssertingLeafReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.TestUtil;

public final class AssertingPostingsFormat
extends PostingsFormat {
    private final PostingsFormat in = TestUtil.getDefaultPostingsFormat();

    public AssertingPostingsFormat() {
        super("Asserting");
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new AssertingFieldsConsumer(state, this.in.fieldsConsumer(state));
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new AssertingFieldsProducer(this.in.fieldsProducer(state));
    }

    static class AssertingFieldsConsumer
    extends FieldsConsumer {
        private final FieldsConsumer in;
        private final SegmentWriteState writeState;

        AssertingFieldsConsumer(SegmentWriteState writeState, FieldsConsumer in) {
            this.writeState = writeState;
            this.in = in;
        }

        public void write(Fields fields) throws IOException {
            this.in.write(fields);
            String lastField = null;
            for (String field : fields) {
                BytesRef term;
                FieldInfo fieldInfo = this.writeState.fieldInfos.fieldInfo(field);
                assert (fieldInfo != null);
                assert (lastField == null || lastField.compareTo(field) < 0);
                lastField = field;
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                assert (terms != null);
                TermsEnum termsEnum = terms.iterator();
                BytesRefBuilder lastTerm = null;
                PostingsEnum postingsEnum = null;
                boolean hasFreqs = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
                boolean hasPositions = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                boolean hasOffsets = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                boolean hasPayloads = terms.hasPayloads();
                assert (hasPositions == terms.hasPositions());
                assert (hasOffsets == terms.hasOffsets());
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    assert (lastTerm == null || lastTerm.get().compareTo(term) < 0);
                    if (lastTerm == null) {
                        lastTerm = new BytesRefBuilder();
                        lastTerm.append(term);
                    } else {
                        lastTerm.copyBytes(term);
                    }
                    int flags = 0;
                    if (!hasPositions) {
                        if (hasFreqs) {
                            flags |= 8;
                        }
                        postingsEnum = termsEnum.postings(postingsEnum, flags);
                    } else {
                        flags = 24;
                        if (hasPayloads) {
                            flags |= 0x58;
                        }
                        if (hasOffsets) {
                            flags |= 0x38;
                        }
                        postingsEnum = termsEnum.postings(postingsEnum, flags);
                    }
                    assert (postingsEnum != null) : "termsEnum=" + termsEnum + " hasPositions=" + hasPositions;
                    int lastDocID = -1;
                    while ((docID = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        assert (docID > lastDocID);
                        lastDocID = docID;
                        if (!hasFreqs) continue;
                        int freq = postingsEnum.freq();
                        assert (freq > 0);
                        if (!hasPositions) continue;
                        int lastPos = -1;
                        int lastStartOffset = -1;
                        for (int i = 0; i < freq; ++i) {
                            int pos = postingsEnum.nextPosition();
                            assert (pos >= lastPos) : "pos=" + pos + " vs lastPos=" + lastPos + " i=" + i + " freq=" + freq;
                            assert (pos <= 0x7FFFFF7F) : "pos=" + pos + " is > IndexWriter.MAX_POSITION=" + 0x7FFFFF7F;
                            lastPos = pos;
                            if (!hasOffsets) continue;
                            int startOffset = postingsEnum.startOffset();
                            int endOffset = postingsEnum.endOffset();
                            assert (endOffset >= startOffset);
                            assert (startOffset >= lastStartOffset);
                            lastStartOffset = startOffset;
                        }
                    }
                }
            }
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }
    }

    static class AssertingFieldsProducer
    extends FieldsProducer {
        private final FieldsProducer in;

        AssertingFieldsProducer(FieldsProducer in) {
            this.in = in;
            assert (this.toString() != null);
            assert (this.ramBytesUsed() >= 0L);
            assert (this.getChildResources() != null);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public Iterator<String> iterator() {
            Iterator iterator = this.in.iterator();
            assert (iterator != null);
            return iterator;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            return terms == null ? null : new AssertingLeafReader.AssertingTerms(terms);
        }

        public int size() {
            return this.in.size();
        }

        public long ramBytesUsed() {
            long v = this.in.ramBytesUsed();
            assert (v >= 0L);
            return v;
        }

        public Collection<Accountable> getChildResources() {
            Collection res = this.in.getChildResources();
            TestUtil.checkReadOnly(res);
            return res;
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public FieldsProducer getMergeInstance() throws IOException {
            return new AssertingFieldsProducer(this.in.getMergeInstance());
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.in.toString() + ")";
        }
    }
}

