/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.JUnit4MethodProvider;
import com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.randomizedtesting.MixWithSuiteName;
import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Listeners;
import com.carrotsearch.randomizedtesting.annotations.SeedDecorators;
import com.carrotsearch.randomizedtesting.annotations.TestGroup;
import com.carrotsearch.randomizedtesting.annotations.TestMethodProviders;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakAction;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakGroup;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakZombies;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.rules.NoClassHooksShadowingRule;
import com.carrotsearch.randomizedtesting.rules.NoInstanceHooksOverridesRule;
import com.carrotsearch.randomizedtesting.rules.StaticFieldsInvariantRule;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import junit.framework.AssertionFailedError;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.AlcoholicMergePolicy;
import org.apache.lucene.index.AssertingDirectoryReader;
import org.apache.lucene.index.AssertingLeafReader;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldFilterLeafReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexWriterMaxDocsChanger;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MismatchedDirectoryReader;
import org.apache.lucene.index.MismatchedLeafReader;
import org.apache.lucene.index.MockRandomMergePolicy;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ParallelCompositeReader;
import org.apache.lucene.index.ParallelLeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.SimpleMergedSegmentWarmer;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.mockfile.FilterPath;
import org.apache.lucene.mockfile.VirusCheckingFS;
import org.apache.lucene.search.AssertingIndexSearcher;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.QueryUtils;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.RawDirectoryWrapper;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableDirectory;
import org.apache.lucene.util.CommandLineUtil;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.FailureMarker;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneJUnit3MethodProvider;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.QuickPatchThreadsFilter;
import org.apache.lucene.util.Rethrow;
import org.apache.lucene.util.RunListenerPrintReproduceInfo;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.TestRuleAssertionsRequired;
import org.apache.lucene.util.TestRuleDelegate;
import org.apache.lucene.util.TestRuleIgnoreAfterMaxFailures;
import org.apache.lucene.util.TestRuleIgnoreTestSuites;
import org.apache.lucene.util.TestRuleLimitSysouts;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.apache.lucene.util.TestRuleRestoreSystemProperties;
import org.apache.lucene.util.TestRuleSetupAndRestoreClassEnv;
import org.apache.lucene.util.TestRuleSetupAndRestoreInstanceEnv;
import org.apache.lucene.util.TestRuleSetupTeardownChained;
import org.apache.lucene.util.TestRuleStoreClassName;
import org.apache.lucene.util.TestRuleTemporaryFilesCleanup;
import org.apache.lucene.util.TestRuleThreadAndTestName;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.automaton.AutomatonTestUtil;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.RegExp;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=RandomizedRunner.class)
@TestMethodProviders(value={LuceneJUnit3MethodProvider.class, JUnit4MethodProvider.class})
@Listeners(value={RunListenerPrintReproduceInfo.class, FailureMarker.class})
@SeedDecorators(value={MixWithSuiteName.class})
@ThreadLeakScope(value=ThreadLeakScope.Scope.SUITE)
@ThreadLeakGroup(value=ThreadLeakGroup.Group.MAIN)
@ThreadLeakAction(value={ThreadLeakAction.Action.WARN, ThreadLeakAction.Action.INTERRUPT})
@ThreadLeakLingering(linger=20000)
@ThreadLeakZombies(value=ThreadLeakZombies.Consequence.IGNORE_REMAINING_TESTS)
@TimeoutSuite(millis=0x6DDD00)
@ThreadLeakFilters(defaultFilters=true, filters={QuickPatchThreadsFilter.class})
@TestRuleLimitSysouts.Limit(bytes=8192)
public abstract class LuceneTestCase
extends Assert {
    public static final String SYSPROP_NIGHTLY = "tests.nightly";
    public static final String SYSPROP_WEEKLY = "tests.weekly";
    public static final String SYSPROP_MONSTER = "tests.monster";
    public static final String SYSPROP_AWAITSFIX = "tests.awaitsfix";
    public static final String SYSPROP_SLOW = "tests.slow";
    public static final String SYSPROP_BADAPPLES = "tests.badapples";
    public static final String SYSPROP_MAXFAILURES = "tests.maxfailures";
    public static final String SYSPROP_FAILFAST = "tests.failfast";
    public static final boolean VERBOSE = RandomizedTest.systemPropertyAsBoolean((String)"tests.verbose", (boolean)false);
    public static final boolean INFOSTREAM = RandomizedTest.systemPropertyAsBoolean((String)"tests.infostream", (boolean)VERBOSE);
    public static final int RANDOM_MULTIPLIER = RandomizedTest.systemPropertyAsInt((String)"tests.multiplier", (int)1);
    public static final boolean TEST_ASSERTS_ENABLED = RandomizedTest.systemPropertyAsBoolean((String)"tests.asserts", (boolean)true);
    public static final String DEFAULT_LINE_DOCS_FILE = "europarl.lines.txt.gz";
    public static final String JENKINS_LARGE_LINE_DOCS_FILE = "enwiki.random.lines.txt";
    public static final String TEST_CODEC = System.getProperty("tests.codec", "random");
    public static final String TEST_POSTINGSFORMAT = System.getProperty("tests.postingsformat", "random");
    public static final String TEST_DOCVALUESFORMAT = System.getProperty("tests.docvaluesformat", "random");
    public static final String TEST_DIRECTORY = System.getProperty("tests.directory", "random");
    public static final String TEST_LINE_DOCS_FILE = System.getProperty("tests.linedocsfile", "europarl.lines.txt.gz");
    public static final boolean TEST_NIGHTLY = RandomizedTest.systemPropertyAsBoolean((String)"tests.nightly", (boolean)false);
    public static final boolean TEST_WEEKLY = RandomizedTest.systemPropertyAsBoolean((String)"tests.weekly", (boolean)false);
    public static final boolean TEST_AWAITSFIX = RandomizedTest.systemPropertyAsBoolean((String)"tests.awaitsfix", (boolean)false);
    public static final boolean TEST_SLOW = RandomizedTest.systemPropertyAsBoolean((String)"tests.slow", (boolean)false);
    public static final MockDirectoryWrapper.Throttling TEST_THROTTLING = TEST_NIGHTLY ? MockDirectoryWrapper.Throttling.SOMETIMES : MockDirectoryWrapper.Throttling.NEVER;
    public static final boolean LEAVE_TEMPORARY;
    private static final List<String> FS_DIRECTORIES;
    private static final List<String> CORE_DIRECTORIES;
    public static final QueryCachingPolicy MAYBE_CACHE_POLICY;
    private static final TestRuleStoreClassName classNameRule;
    static final TestRuleSetupAndRestoreClassEnv classEnvRule;
    protected static TestRuleMarkFailure suiteFailureMarker;
    private static TestRuleTemporaryFilesCleanup tempFilesCleanupRule;
    private static final AtomicReference<TestRuleIgnoreAfterMaxFailures> ignoreAfterMaxFailuresDelegate;
    private static final TestRule ignoreAfterMaxFailures;
    private static final long STATIC_LEAK_THRESHOLD = 0xA00000L;
    private static final Set<String> STATIC_LEAK_IGNORED_TYPES;
    @ClassRule
    public static TestRule classRules;
    private TestRuleSetupTeardownChained parentChainCallRule = new TestRuleSetupTeardownChained();
    private TestRuleThreadAndTestName threadAndTestNameRule = new TestRuleThreadAndTestName();
    private TestRuleMarkFailure testFailureMarker = new TestRuleMarkFailure(suiteFailureMarker);
    @Rule
    public final TestRule ruleChain = RuleChain.outerRule((TestRule)this.testFailureMarker).around(ignoreAfterMaxFailures).around((TestRule)this.threadAndTestNameRule).around((TestRule)new TestRuleSetupAndRestoreInstanceEnv()).around((TestRule)this.parentChainCallRule);
    private static final Map<String, FieldType> fieldToType;
    static LiveIWCFlushMode liveIWCFlushMode;
    private static final String[] availableLanguageTags;
    private static final QueryCache DEFAULT_QUERY_CACHE;
    private static final QueryCachingPolicy DEFAULT_CACHING_POLICY;
    public static final boolean assertsAreEnabled;

    public static boolean hasWorkingMMapOnWindows() {
        return !Constants.WINDOWS || MMapDirectory.UNMAP_SUPPORTED;
    }

    public static void assumeWorkingMMapOnWindows() {
        LuceneTestCase.assumeTrue(MMapDirectory.UNMAP_NOT_SUPPORTED_REASON, LuceneTestCase.hasWorkingMMapOnWindows());
    }

    public static TestRuleIgnoreAfterMaxFailures replaceMaxFailureRule(TestRuleIgnoreAfterMaxFailures newValue) {
        return ignoreAfterMaxFailuresDelegate.getAndSet(newValue);
    }

    static void setLiveIWCFlushMode(LiveIWCFlushMode flushMode) {
        liveIWCFlushMode = flushMode;
    }

    @Before
    public void setUp() throws Exception {
        this.parentChainCallRule.setupCalled = true;
    }

    @After
    public void tearDown() throws Exception {
        this.parentChainCallRule.teardownCalled = true;
        fieldToType.clear();
        this.restoreIndexWriterMaxDocs();
    }

    public void setIndexWriterMaxDocs(int limit) {
        IndexWriterMaxDocsChanger.setMaxDocs(limit);
    }

    public void restoreIndexWriterMaxDocs() {
        IndexWriterMaxDocsChanger.restoreMaxDocs();
    }

    public static Random random() {
        return RandomizedContext.current().getRandom();
    }

    public <T extends Closeable> T closeAfterTest(T resource) {
        return (T)RandomizedContext.current().closeAtEnd(resource, LifecycleScope.TEST);
    }

    public static <T extends Closeable> T closeAfterSuite(T resource) {
        return (T)RandomizedContext.current().closeAtEnd(resource, LifecycleScope.SUITE);
    }

    public static Class<?> getTestClass() {
        return classNameRule.getTestClass();
    }

    public String getTestName() {
        return this.threadAndTestNameRule.testMethodName;
    }

    public static LeafReader getOnlyLeafReader(IndexReader reader) {
        List subReaders = reader.leaves();
        if (subReaders.size() != 1) {
            throw new IllegalArgumentException(reader + " has " + subReaders.size() + " segments instead of exactly one");
        }
        return ((LeafReaderContext)subReaders.get(0)).reader();
    }

    protected boolean isTestThread() {
        LuceneTestCase.assertNotNull((String)"Test case thread not set?", (Object)this.threadAndTestNameRule.testCaseThread);
        return Thread.currentThread() == this.threadAndTestNameRule.testCaseThread;
    }

    public static int atLeast(Random random, int i) {
        int min = (TEST_NIGHTLY ? 2 * i : i) * RANDOM_MULTIPLIER;
        int max = min + min / 2;
        return TestUtil.nextInt(random, min, max);
    }

    public static int atLeast(int i) {
        return LuceneTestCase.atLeast(LuceneTestCase.random(), i);
    }

    public static boolean rarely(Random random) {
        int p = TEST_NIGHTLY ? 10 : 1;
        p = (int)((double)p + (double)p * Math.log(RANDOM_MULTIPLIER));
        int min = 100 - Math.min(p, 50);
        return random.nextInt(100) >= min;
    }

    public static boolean rarely() {
        return LuceneTestCase.rarely(LuceneTestCase.random());
    }

    public static boolean usually(Random random) {
        return !LuceneTestCase.rarely(random);
    }

    public static boolean usually() {
        return LuceneTestCase.usually(LuceneTestCase.random());
    }

    public static void assumeTrue(String msg, boolean condition) {
        RandomizedTest.assumeTrue((String)msg, (boolean)condition);
    }

    public static void assumeFalse(String msg, boolean condition) {
        RandomizedTest.assumeFalse((String)msg, (boolean)condition);
    }

    public static void assumeNoException(String msg, Exception e) {
        RandomizedTest.assumeNoException((String)msg, (Throwable)e);
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... args) {
        return new HashSet<T>(Arrays.asList(args));
    }

    public static void dumpIterator(String label, Iterator<?> iter, PrintStream stream) {
        stream.println("*** BEGIN " + label + " ***");
        if (null == iter) {
            stream.println(" ... NULL ...");
        } else {
            while (iter.hasNext()) {
                stream.println(iter.next().toString());
            }
        }
        stream.println("*** END " + label + " ***");
    }

    public static void dumpArray(String label, Object[] objs, PrintStream stream) {
        Iterator<Object> iter = null == objs ? null : Arrays.asList(objs).iterator();
        LuceneTestCase.dumpIterator(label, iter, stream);
    }

    public static IndexWriterConfig newIndexWriterConfig() {
        return LuceneTestCase.newIndexWriterConfig(new MockAnalyzer(LuceneTestCase.random()));
    }

    public static IndexWriterConfig newIndexWriterConfig(Analyzer a) {
        return LuceneTestCase.newIndexWriterConfig(LuceneTestCase.random(), a);
    }

    public static IndexWriterConfig newIndexWriterConfig(Random r, Analyzer a) {
        IndexWriterConfig c = new IndexWriterConfig(a);
        c.setSimilarity(LuceneTestCase.classEnvRule.similarity);
        if (VERBOSE) {
            c.setInfoStream((InfoStream)new TestRuleSetupAndRestoreClassEnv.ThreadNameFixingPrintStreamInfoStream(System.out));
        }
        if (r.nextBoolean()) {
            c.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        } else if (LuceneTestCase.rarely(r)) {
            ConcurrentMergeScheduler cms = r.nextBoolean() ? new ConcurrentMergeScheduler() : new ConcurrentMergeScheduler(){

                protected synchronized boolean maybeStall(IndexWriter writer) {
                    return true;
                }
            };
            int maxThreadCount = TestUtil.nextInt(r, 1, 4);
            int maxMergeCount = TestUtil.nextInt(r, maxThreadCount, maxThreadCount + 4);
            cms.setMaxMergesAndThreads(maxMergeCount, maxThreadCount);
            if (LuceneTestCase.random().nextBoolean()) {
                cms.disableAutoIOThrottle();
                LuceneTestCase.assertFalse((boolean)cms.getAutoIOThrottle());
            }
            cms.setForceMergeMBPerSec(10.0 + 10.0 * LuceneTestCase.random().nextDouble());
            c.setMergeScheduler((MergeScheduler)cms);
        } else {
            ConcurrentMergeScheduler cms = new ConcurrentMergeScheduler();
            cms.setMaxMergesAndThreads(3, 1);
            c.setMergeScheduler((MergeScheduler)cms);
        }
        if (r.nextBoolean()) {
            if (LuceneTestCase.rarely(r)) {
                c.setMaxBufferedDocs(TestUtil.nextInt(r, 2, 15));
            } else {
                c.setMaxBufferedDocs(TestUtil.nextInt(r, 16, 1000));
            }
        }
        c.setMergePolicy(LuceneTestCase.newMergePolicy(r));
        LuceneTestCase.avoidPathologicalMerging(c);
        if (LuceneTestCase.rarely(r)) {
            c.setMergedSegmentWarmer((IndexWriter.IndexReaderWarmer)new SimpleMergedSegmentWarmer(c.getInfoStream()));
        }
        c.setUseCompoundFile(r.nextBoolean());
        c.setReaderPooling(r.nextBoolean());
        return c;
    }

    private static void avoidPathologicalMerging(IndexWriterConfig iwc) {
        long estFlushSizeBytes = Long.MAX_VALUE;
        if (iwc.getMaxBufferedDocs() != -1) {
            estFlushSizeBytes = Math.min(estFlushSizeBytes, (long)(iwc.getMaxBufferedDocs() * 1024));
        }
        if (iwc.getRAMBufferSizeMB() != -1.0) {
            estFlushSizeBytes = Math.min(estFlushSizeBytes, (long)(iwc.getRAMBufferSizeMB() * 1024.0 * 1024.0));
        }
        assert (estFlushSizeBytes > 0L);
        MergePolicy mp = iwc.getMergePolicy();
        if (mp instanceof TieredMergePolicy) {
            TieredMergePolicy tmp = (TieredMergePolicy)mp;
            long floorSegBytes = (long)(tmp.getFloorSegmentMB() * 1024.0 * 1024.0);
            if (floorSegBytes / estFlushSizeBytes > 10L) {
                double newValue = (double)estFlushSizeBytes * 10.0 / 1024.0 / 1024.0;
                if (VERBOSE) {
                    System.out.println("NOTE: LuceneTestCase: changing TieredMergePolicy.floorSegmentMB from " + tmp.getFloorSegmentMB() + " to " + newValue + " to avoid pathological merging");
                }
                tmp.setFloorSegmentMB(newValue);
            }
        } else if (mp instanceof LogByteSizeMergePolicy) {
            LogByteSizeMergePolicy lmp = (LogByteSizeMergePolicy)mp;
            if (lmp.getMinMergeMB() * 1024.0 * 1024.0 / (double)estFlushSizeBytes > 10.0) {
                double newValue = (double)estFlushSizeBytes * 10.0 / 1024.0 / 1024.0;
                if (VERBOSE) {
                    System.out.println("NOTE: LuceneTestCase: changing LogByteSizeMergePolicy.minMergeMB from " + lmp.getMinMergeMB() + " to " + newValue + " to avoid pathological merging");
                }
                lmp.setMinMergeMB(newValue);
            }
        } else if (mp instanceof LogDocMergePolicy) {
            LogDocMergePolicy lmp = (LogDocMergePolicy)mp;
            assert (estFlushSizeBytes / 1024L < 0xCCCCCCCL);
            int estFlushDocs = Math.max(1, (int)(estFlushSizeBytes / 1024L));
            if (lmp.getMinMergeDocs() / estFlushDocs > 10) {
                int newValue = estFlushDocs * 10;
                if (VERBOSE) {
                    System.out.println("NOTE: LuceneTestCase: changing LogDocMergePolicy.minMergeDocs from " + lmp.getMinMergeDocs() + " to " + newValue + " to avoid pathological merging");
                }
                lmp.setMinMergeDocs(newValue);
            }
        }
    }

    public static MergePolicy newMergePolicy(Random r) {
        if (LuceneTestCase.rarely(r)) {
            return new MockRandomMergePolicy(r);
        }
        if (r.nextBoolean()) {
            return LuceneTestCase.newTieredMergePolicy(r);
        }
        if (r.nextInt(5) == 0) {
            return LuceneTestCase.newAlcoholicMergePolicy(r, LuceneTestCase.classEnvRule.timeZone);
        }
        return LuceneTestCase.newLogMergePolicy(r);
    }

    public static MergePolicy newMergePolicy() {
        return LuceneTestCase.newMergePolicy(LuceneTestCase.random());
    }

    public static LogMergePolicy newLogMergePolicy() {
        return LuceneTestCase.newLogMergePolicy(LuceneTestCase.random());
    }

    public static TieredMergePolicy newTieredMergePolicy() {
        return LuceneTestCase.newTieredMergePolicy(LuceneTestCase.random());
    }

    public static AlcoholicMergePolicy newAlcoholicMergePolicy() {
        return LuceneTestCase.newAlcoholicMergePolicy(LuceneTestCase.random(), LuceneTestCase.classEnvRule.timeZone);
    }

    public static AlcoholicMergePolicy newAlcoholicMergePolicy(Random r, TimeZone tz) {
        return new AlcoholicMergePolicy(tz, new Random(r.nextLong()));
    }

    public static LogMergePolicy newLogMergePolicy(Random r) {
        LogDocMergePolicy logmp = r.nextBoolean() ? new LogDocMergePolicy() : new LogByteSizeMergePolicy();
        logmp.setCalibrateSizeByDeletes(r.nextBoolean());
        if (LuceneTestCase.rarely(r)) {
            logmp.setMergeFactor(TestUtil.nextInt(r, 2, 9));
        } else {
            logmp.setMergeFactor(TestUtil.nextInt(r, 10, 50));
        }
        LuceneTestCase.configureRandom(r, (MergePolicy)logmp);
        return logmp;
    }

    private static void configureRandom(Random r, MergePolicy mergePolicy) {
        if (r.nextBoolean()) {
            mergePolicy.setNoCFSRatio(0.1 + r.nextDouble() * 0.8);
        } else {
            mergePolicy.setNoCFSRatio(r.nextBoolean() ? 1.0 : 0.0);
        }
        if (LuceneTestCase.rarely(r)) {
            mergePolicy.setMaxCFSSegmentSizeMB(0.2 + r.nextDouble() * 2.0);
        } else {
            mergePolicy.setMaxCFSSegmentSizeMB(Double.POSITIVE_INFINITY);
        }
    }

    public static TieredMergePolicy newTieredMergePolicy(Random r) {
        TieredMergePolicy tmp = new TieredMergePolicy();
        if (LuceneTestCase.rarely(r)) {
            tmp.setMaxMergeAtOnce(TestUtil.nextInt(r, 2, 9));
            tmp.setMaxMergeAtOnceExplicit(TestUtil.nextInt(r, 2, 9));
        } else {
            tmp.setMaxMergeAtOnce(TestUtil.nextInt(r, 10, 50));
            tmp.setMaxMergeAtOnceExplicit(TestUtil.nextInt(r, 10, 50));
        }
        if (LuceneTestCase.rarely(r)) {
            tmp.setMaxMergedSegmentMB(0.2 + r.nextDouble() * 2.0);
        } else {
            tmp.setMaxMergedSegmentMB(r.nextDouble() * 100.0);
        }
        tmp.setFloorSegmentMB(0.2 + r.nextDouble() * 2.0);
        tmp.setForceMergeDeletesPctAllowed(0.0 + r.nextDouble() * 30.0);
        if (LuceneTestCase.rarely(r)) {
            tmp.setSegmentsPerTier((double)TestUtil.nextInt(r, 2, 20));
        } else {
            tmp.setSegmentsPerTier((double)TestUtil.nextInt(r, 10, 50));
        }
        LuceneTestCase.configureRandom(r, (MergePolicy)tmp);
        tmp.setReclaimDeletesWeight(r.nextDouble() * 4.0);
        return tmp;
    }

    public static MergePolicy newLogMergePolicy(boolean useCFS) {
        LogMergePolicy logmp = LuceneTestCase.newLogMergePolicy();
        logmp.setNoCFSRatio(useCFS ? 1.0 : 0.0);
        return logmp;
    }

    public static MergePolicy newLogMergePolicy(boolean useCFS, int mergeFactor) {
        LogMergePolicy logmp = LuceneTestCase.newLogMergePolicy();
        logmp.setNoCFSRatio(useCFS ? 1.0 : 0.0);
        logmp.setMergeFactor(mergeFactor);
        return logmp;
    }

    public static MergePolicy newLogMergePolicy(int mergeFactor) {
        LogMergePolicy logmp = LuceneTestCase.newLogMergePolicy();
        logmp.setMergeFactor(mergeFactor);
        return logmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void maybeChangeLiveIndexWriterConfig(Random r, LiveIndexWriterConfig c) {
        MergeScheduler ms;
        boolean didChange = false;
        String previous = c.toString();
        if (LuceneTestCase.rarely(r)) {
            LiveIndexWriterConfig liveIndexWriterConfig = c;
            synchronized (liveIndexWriterConfig) {
                boolean flushByRAM;
                switch (liveIWCFlushMode) {
                    case BY_RAM: {
                        flushByRAM = true;
                        break;
                    }
                    case BY_DOCS: {
                        flushByRAM = false;
                        break;
                    }
                    case EITHER: {
                        flushByRAM = r.nextBoolean();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (flushByRAM) {
                    c.setRAMBufferSizeMB((double)TestUtil.nextInt(r, 1, 10));
                    c.setMaxBufferedDocs(-1);
                } else {
                    if (LuceneTestCase.rarely(r)) {
                        c.setMaxBufferedDocs(TestUtil.nextInt(r, 2, 15));
                    } else {
                        c.setMaxBufferedDocs(TestUtil.nextInt(r, 16, 1000));
                    }
                    c.setRAMBufferSizeMB(-1.0);
                }
            }
            didChange = true;
        }
        if (LuceneTestCase.rarely(r)) {
            boolean limitBufferedDeletes = r.nextBoolean();
            if (limitBufferedDeletes) {
                c.setMaxBufferedDeleteTerms(TestUtil.nextInt(r, 1, 1000));
            } else {
                c.setMaxBufferedDeleteTerms(-1);
            }
            didChange = true;
        }
        if (LuceneTestCase.rarely(r)) {
            IndexWriter.IndexReaderWarmer curWarmer = c.getMergedSegmentWarmer();
            if (curWarmer == null || curWarmer instanceof SimpleMergedSegmentWarmer) {
                if (r.nextBoolean()) {
                    c.setMergedSegmentWarmer((IndexWriter.IndexReaderWarmer)new SimpleMergedSegmentWarmer(c.getInfoStream()));
                } else {
                    c.setMergedSegmentWarmer(null);
                }
            }
            didChange = true;
        }
        if (LuceneTestCase.rarely(r)) {
            c.setUseCompoundFile(r.nextBoolean());
            didChange = true;
        }
        if (LuceneTestCase.rarely(r) && (ms = c.getMergeScheduler()) instanceof ConcurrentMergeScheduler) {
            ConcurrentMergeScheduler cms = (ConcurrentMergeScheduler)ms;
            int maxThreadCount = TestUtil.nextInt(r, 1, 4);
            int maxMergeCount = TestUtil.nextInt(r, maxThreadCount, maxThreadCount + 4);
            boolean enableAutoIOThrottle = LuceneTestCase.random().nextBoolean();
            if (enableAutoIOThrottle) {
                cms.enableAutoIOThrottle();
            } else {
                cms.disableAutoIOThrottle();
            }
            cms.setMaxMergesAndThreads(maxMergeCount, maxThreadCount);
            didChange = true;
        }
        if (LuceneTestCase.rarely(r)) {
            MergePolicy mp = c.getMergePolicy();
            LuceneTestCase.configureRandom(r, mp);
            if (mp instanceof LogMergePolicy) {
                LogMergePolicy logmp = (LogMergePolicy)mp;
                logmp.setCalibrateSizeByDeletes(r.nextBoolean());
                if (LuceneTestCase.rarely(r)) {
                    logmp.setMergeFactor(TestUtil.nextInt(r, 2, 9));
                } else {
                    logmp.setMergeFactor(TestUtil.nextInt(r, 10, 50));
                }
            } else if (mp instanceof TieredMergePolicy) {
                TieredMergePolicy tmp = (TieredMergePolicy)mp;
                if (LuceneTestCase.rarely(r)) {
                    tmp.setMaxMergeAtOnce(TestUtil.nextInt(r, 2, 9));
                    tmp.setMaxMergeAtOnceExplicit(TestUtil.nextInt(r, 2, 9));
                } else {
                    tmp.setMaxMergeAtOnce(TestUtil.nextInt(r, 10, 50));
                    tmp.setMaxMergeAtOnceExplicit(TestUtil.nextInt(r, 10, 50));
                }
                if (LuceneTestCase.rarely(r)) {
                    tmp.setMaxMergedSegmentMB(0.2 + r.nextDouble() * 2.0);
                } else {
                    tmp.setMaxMergedSegmentMB(r.nextDouble() * 100.0);
                }
                tmp.setFloorSegmentMB(0.2 + r.nextDouble() * 2.0);
                tmp.setForceMergeDeletesPctAllowed(0.0 + r.nextDouble() * 30.0);
                if (LuceneTestCase.rarely(r)) {
                    tmp.setSegmentsPerTier((double)TestUtil.nextInt(r, 2, 20));
                } else {
                    tmp.setSegmentsPerTier((double)TestUtil.nextInt(r, 10, 50));
                }
                LuceneTestCase.configureRandom(r, (MergePolicy)tmp);
                tmp.setReclaimDeletesWeight(r.nextDouble() * 4.0);
            }
            didChange = true;
        }
        if (VERBOSE && didChange) {
            String current = c.toString();
            String[] previousLines = previous.split("\n");
            String[] currentLines = current.split("\n");
            StringBuilder diff = new StringBuilder();
            if (previousLines.length == currentLines.length) {
                for (int i = 0; i < previousLines.length; ++i) {
                    if (previousLines[i].equals(currentLines[i])) continue;
                    diff.append("- " + previousLines[i] + "\n");
                    diff.append("+ " + currentLines[i] + "\n");
                }
            } else {
                diff.append(current.toString());
            }
            if (diff.length() > 0) {
                System.out.println("NOTE: LuceneTestCase: randomly changed IWC's live settings:");
                System.out.println(diff);
            }
        }
    }

    public static BaseDirectoryWrapper newDirectory() {
        return LuceneTestCase.newDirectory(LuceneTestCase.random());
    }

    public static BaseDirectoryWrapper newMaybeVirusCheckingDirectory() {
        if (LuceneTestCase.random().nextInt(5) == 4) {
            Path path = LuceneTestCase.addVirusChecker(LuceneTestCase.createTempDir());
            return LuceneTestCase.newFSDirectory(path);
        }
        return LuceneTestCase.newDirectory(LuceneTestCase.random());
    }

    public static BaseDirectoryWrapper newDirectory(Random r) {
        return LuceneTestCase.wrapDirectory(r, LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY), LuceneTestCase.rarely(r));
    }

    public static BaseDirectoryWrapper newDirectory(Random r, LockFactory lf) {
        return LuceneTestCase.wrapDirectory(r, LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY, lf), LuceneTestCase.rarely(r));
    }

    public static MockDirectoryWrapper newMockDirectory() {
        return LuceneTestCase.newMockDirectory(LuceneTestCase.random());
    }

    public static MockDirectoryWrapper newMockDirectory(Random r) {
        return (MockDirectoryWrapper)LuceneTestCase.wrapDirectory(r, LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY), false);
    }

    public static MockDirectoryWrapper newMockDirectory(Random r, LockFactory lf) {
        return (MockDirectoryWrapper)LuceneTestCase.wrapDirectory(r, LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY, lf), false);
    }

    public static MockDirectoryWrapper newMockFSDirectory(Path f) {
        return (MockDirectoryWrapper)LuceneTestCase.newFSDirectory(f, (LockFactory)FSLockFactory.getDefault(), false);
    }

    public static MockDirectoryWrapper newMockFSDirectory(Path f, LockFactory lf) {
        return (MockDirectoryWrapper)LuceneTestCase.newFSDirectory(f, lf, false);
    }

    public static Path addVirusChecker(Path path) {
        if (!TestUtil.hasVirusChecker(path)) {
            VirusCheckingFS fs = new VirusCheckingFS(path.getFileSystem(), LuceneTestCase.random().nextLong());
            FileSystem filesystem = fs.getFileSystem(URI.create("file:///"));
            path = new FilterPath(path, filesystem);
        }
        return path;
    }

    public static BaseDirectoryWrapper newDirectory(Directory d) throws IOException {
        return LuceneTestCase.newDirectory(LuceneTestCase.random(), d);
    }

    public static BaseDirectoryWrapper newFSDirectory(Path f) {
        return LuceneTestCase.newFSDirectory(f, (LockFactory)FSLockFactory.getDefault());
    }

    public static BaseDirectoryWrapper newMaybeVirusCheckingFSDirectory(Path f) {
        if (LuceneTestCase.random().nextInt(5) == 4) {
            f = LuceneTestCase.addVirusChecker(f);
        }
        return LuceneTestCase.newFSDirectory(f, (LockFactory)FSLockFactory.getDefault());
    }

    public static BaseDirectoryWrapper newFSDirectory(Path f, LockFactory lf) {
        return LuceneTestCase.newFSDirectory(f, lf, LuceneTestCase.rarely());
    }

    private static BaseDirectoryWrapper newFSDirectory(Path f, LockFactory lf, boolean bare) {
        String fsdirClass = TEST_DIRECTORY;
        if (fsdirClass.equals("random")) {
            fsdirClass = (String)RandomPicks.randomFrom((Random)LuceneTestCase.random(), FS_DIRECTORIES);
        }
        try {
            Class clazz;
            try {
                clazz = CommandLineUtil.loadFSDirectoryClass((String)fsdirClass);
            }
            catch (ClassCastException e) {
                fsdirClass = (String)RandomPicks.randomFrom((Random)LuceneTestCase.random(), FS_DIRECTORIES);
                clazz = CommandLineUtil.loadFSDirectoryClass((String)fsdirClass);
            }
            Directory fsdir = LuceneTestCase.newFSDirectoryImpl(clazz, f, lf);
            BaseDirectoryWrapper wrapped = LuceneTestCase.wrapDirectory(LuceneTestCase.random(), fsdir, bare);
            return wrapped;
        }
        catch (Exception e) {
            Rethrow.rethrow(e);
            throw null;
        }
    }

    public static BaseDirectoryWrapper newDirectory(Random r, Directory d) throws IOException {
        Directory impl = LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY);
        for (String file : d.listAll()) {
            if (!file.startsWith("segments") && !IndexFileNames.CODEC_FILE_PATTERN.matcher(file).matches()) continue;
            impl.copyFrom(d, file, file, LuceneTestCase.newIOContext(r));
        }
        return LuceneTestCase.wrapDirectory(r, impl, LuceneTestCase.rarely(r));
    }

    private static BaseDirectoryWrapper wrapDirectory(Random random, Directory directory, boolean bare) {
        if (LuceneTestCase.rarely(random) && !bare) {
            directory = new NRTCachingDirectory(directory, random.nextDouble(), random.nextDouble());
        }
        if (bare) {
            RawDirectoryWrapper base = new RawDirectoryWrapper(directory);
            LuceneTestCase.closeAfterSuite(new CloseableDirectory(base, suiteFailureMarker));
            return base;
        }
        MockDirectoryWrapper mock = new MockDirectoryWrapper(random, directory);
        mock.setThrottling(TEST_THROTTLING);
        LuceneTestCase.closeAfterSuite(new CloseableDirectory(mock, suiteFailureMarker));
        return mock;
    }

    public static org.apache.lucene.document.Field newStringField(String name, String value, Field.Store stored) {
        return LuceneTestCase.newField(LuceneTestCase.random(), name, value, stored == Field.Store.YES ? StringField.TYPE_STORED : StringField.TYPE_NOT_STORED);
    }

    public static org.apache.lucene.document.Field newStringField(String name, BytesRef value, Field.Store stored) {
        return LuceneTestCase.newField(LuceneTestCase.random(), name, value, stored == Field.Store.YES ? StringField.TYPE_STORED : StringField.TYPE_NOT_STORED);
    }

    public static org.apache.lucene.document.Field newTextField(String name, String value, Field.Store stored) {
        return LuceneTestCase.newField(LuceneTestCase.random(), name, value, stored == Field.Store.YES ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED);
    }

    public static org.apache.lucene.document.Field newStringField(Random random, String name, String value, Field.Store stored) {
        return LuceneTestCase.newField(random, name, value, stored == Field.Store.YES ? StringField.TYPE_STORED : StringField.TYPE_NOT_STORED);
    }

    public static org.apache.lucene.document.Field newStringField(Random random, String name, BytesRef value, Field.Store stored) {
        return LuceneTestCase.newField(random, name, value, stored == Field.Store.YES ? StringField.TYPE_STORED : StringField.TYPE_NOT_STORED);
    }

    public static org.apache.lucene.document.Field newTextField(Random random, String name, String value, Field.Store stored) {
        return LuceneTestCase.newField(random, name, value, stored == Field.Store.YES ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED);
    }

    public static org.apache.lucene.document.Field newField(String name, String value, FieldType type) {
        return LuceneTestCase.newField(LuceneTestCase.random(), name, value, type);
    }

    private static FieldType mergeTermVectorOptions(FieldType newType, FieldType oldType) {
        if (newType.indexOptions() != IndexOptions.NONE && oldType.storeTermVectors() && !newType.storeTermVectors()) {
            newType = new FieldType(newType);
            newType.setStoreTermVectors(oldType.storeTermVectors());
            newType.setStoreTermVectorPositions(oldType.storeTermVectorPositions());
            newType.setStoreTermVectorOffsets(oldType.storeTermVectorOffsets());
            newType.setStoreTermVectorPayloads(oldType.storeTermVectorPayloads());
            newType.freeze();
        }
        return newType;
    }

    public static synchronized org.apache.lucene.document.Field newField(Random random, String name, Object value, FieldType type) {
        name = new String(name);
        FieldType prevType = fieldToType.get(name);
        if (LuceneTestCase.usually(random) || type.indexOptions() == IndexOptions.NONE || prevType != null) {
            if (prevType == null) {
                fieldToType.put(name, new FieldType(type));
            } else {
                type = LuceneTestCase.mergeTermVectorOptions(type, prevType);
            }
            return LuceneTestCase.createField(name, value, type);
        }
        FieldType newType = new FieldType(type);
        if (!newType.stored() && random.nextBoolean()) {
            newType.setStored(true);
        }
        if (!newType.storeTermVectors() && random.nextBoolean()) {
            newType.setStoreTermVectors(true);
            if (!newType.storeTermVectorPositions()) {
                newType.setStoreTermVectorPositions(random.nextBoolean());
                if (newType.storeTermVectorPositions() && !newType.storeTermVectorPayloads()) {
                    newType.setStoreTermVectorPayloads(random.nextBoolean());
                }
            }
            if (!newType.storeTermVectorOffsets()) {
                newType.setStoreTermVectorOffsets(random.nextBoolean());
            }
            if (VERBOSE) {
                System.out.println("NOTE: LuceneTestCase: upgrade name=" + name + " type=" + newType);
            }
        }
        newType.freeze();
        fieldToType.put(name, newType);
        return LuceneTestCase.createField(name, value, newType);
    }

    private static org.apache.lucene.document.Field createField(String name, Object value, FieldType fieldType) {
        if (value instanceof String) {
            return new org.apache.lucene.document.Field(name, (String)value, fieldType);
        }
        if (value instanceof BytesRef) {
            return new org.apache.lucene.document.Field(name, (BytesRef)value, fieldType);
        }
        throw new IllegalArgumentException("value must be String or BytesRef");
    }

    public static Locale randomLocale(Random random) {
        return LuceneTestCase.localeForLanguageTag(availableLanguageTags[random.nextInt(availableLanguageTags.length)]);
    }

    public static TimeZone randomTimeZone(Random random) {
        String[] tzIds = TimeZone.getAvailableIDs();
        return TimeZone.getTimeZone(tzIds[random.nextInt(tzIds.length)]);
    }

    public static Locale localeForLanguageTag(String languageTag) {
        return new Locale.Builder().setLanguageTag(languageTag).build();
    }

    private static Directory newFSDirectoryImpl(Class<? extends FSDirectory> clazz, Path path, LockFactory lf) throws IOException {
        FSDirectory d = null;
        try {
            d = CommandLineUtil.newFSDirectory(clazz, (Path)path, (LockFactory)lf);
        }
        catch (ReflectiveOperationException e) {
            Rethrow.rethrow(e);
        }
        return d;
    }

    static Directory newDirectoryImpl(Random random, String clazzName) {
        return LuceneTestCase.newDirectoryImpl(random, clazzName, (LockFactory)FSLockFactory.getDefault());
    }

    static Directory newDirectoryImpl(Random random, String clazzName, LockFactory lf) {
        if (clazzName.equals("random")) {
            clazzName = LuceneTestCase.rarely(random) ? (String)RandomPicks.randomFrom((Random)random, CORE_DIRECTORIES) : "RAMDirectory";
        }
        try {
            Class clazz = CommandLineUtil.loadDirectoryClass((String)clazzName);
            if (FSDirectory.class.isAssignableFrom(clazz)) {
                Path dir = LuceneTestCase.createTempDir("index-" + clazzName);
                return LuceneTestCase.newFSDirectoryImpl(clazz.asSubclass(FSDirectory.class), dir, lf);
            }
            try {
                Constructor pathCtor = clazz.getConstructor(Path.class, LockFactory.class);
                Path dir = LuceneTestCase.createTempDir("index");
                return (Directory)pathCtor.newInstance(dir, lf);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!(lf instanceof FSLockFactory)) {
                    try {
                        return (Directory)clazz.getConstructor(LockFactory.class).newInstance(lf);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                }
                return (Directory)clazz.newInstance();
            }
        }
        catch (Exception e) {
            Rethrow.rethrow(e);
            throw null;
        }
    }

    public static IndexReader wrapReader(IndexReader r) throws IOException {
        Random random = LuceneTestCase.random();
        int c = random.nextInt(6) + 1;
        block7: for (int i = 0; i < c; ++i) {
            switch (random.nextInt(5)) {
                case 0: {
                    if (VERBOSE) {
                        System.out.println("NOTE: LuceneTestCase.wrapReader: wrapping previous reader=" + r + " with ParallelLeaf/CompositeReader");
                    }
                    r = r instanceof LeafReader ? new ParallelLeafReader(new LeafReader[]{(LeafReader)r}) : new ParallelCompositeReader(new CompositeReader[]{(CompositeReader)r});
                    continue block7;
                }
                case 1: {
                    if (VERBOSE) {
                        System.out.println("NOTE: LuceneTestCase.wrapReader: wrapping previous reader=" + r + " with FCInvisibleMultiReader");
                    }
                    r = new QueryUtils.FCInvisibleMultiReader(new IndexReader[]{r});
                    continue block7;
                }
                case 2: {
                    if (!(r instanceof LeafReader)) continue block7;
                    LeafReader ar = (LeafReader)r;
                    ArrayList<String> allFields = new ArrayList<String>();
                    for (FieldInfo fi : ar.getFieldInfos()) {
                        allFields.add(fi.name);
                    }
                    Collections.shuffle(allFields, random);
                    int end = allFields.isEmpty() ? 0 : random.nextInt(allFields.size());
                    HashSet<String> fields = new HashSet<String>(allFields.subList(0, end));
                    if (VERBOSE) {
                        System.out.println("NOTE: LuceneTestCase.wrapReader: wrapping previous reader=" + r + " with ParallelLeafReader");
                    }
                    r = new ParallelLeafReader(new LeafReader[]{new FieldFilterLeafReader(ar, fields, false), new FieldFilterLeafReader(ar, fields, true)});
                    continue block7;
                }
                case 3: {
                    if (VERBOSE) {
                        System.out.println("NOTE: LuceneTestCase.wrapReader: wrapping previous reader=" + r + " with AssertingLeaf/DirectoryReader");
                    }
                    if (r instanceof LeafReader) {
                        r = new AssertingLeafReader((LeafReader)r);
                        continue block7;
                    }
                    if (!(r instanceof DirectoryReader)) continue block7;
                    r = new AssertingDirectoryReader((DirectoryReader)r);
                    continue block7;
                }
                case 4: {
                    if (VERBOSE) {
                        System.out.println("NOTE: LuceneTestCase.wrapReader: wrapping previous reader=" + r + " with MismatchedLeaf/DirectoryReader");
                    }
                    if (r instanceof LeafReader) {
                        r = new MismatchedLeafReader((LeafReader)r, random);
                        continue block7;
                    }
                    if (!(r instanceof DirectoryReader)) continue block7;
                    r = new MismatchedDirectoryReader((DirectoryReader)r, random);
                    continue block7;
                }
                default: {
                    LuceneTestCase.fail((String)"should not get here");
                }
            }
        }
        if (r instanceof CompositeReader && !(r instanceof QueryUtils.FCInvisibleMultiReader)) {
            r = new QueryUtils.FCInvisibleMultiReader(new IndexReader[]{r});
        }
        if (VERBOSE) {
            System.out.println("wrapReader wrapped: " + r);
        }
        return r;
    }

    public static IndexReader maybeWrapReader(IndexReader r) throws IOException {
        if (LuceneTestCase.rarely()) {
            r = LuceneTestCase.wrapReader(r);
        }
        return r;
    }

    public static IOContext newIOContext(Random random) {
        return LuceneTestCase.newIOContext(random, IOContext.DEFAULT);
    }

    public static IOContext newIOContext(Random random, IOContext oldContext) {
        IOContext context;
        int randomNumDocs = random.nextInt(4192);
        int size = random.nextInt(512) * randomNumDocs;
        if (oldContext.flushInfo != null) {
            return new IOContext(new FlushInfo(randomNumDocs, Math.max(oldContext.flushInfo.estimatedSegmentSize, (long)size)));
        }
        if (oldContext.mergeInfo != null) {
            return new IOContext(new MergeInfo(randomNumDocs, Math.max(oldContext.mergeInfo.estimatedMergeBytes, (long)size), random.nextBoolean(), TestUtil.nextInt(random, 1, 100)));
        }
        switch (random.nextInt(5)) {
            case 0: {
                context = IOContext.DEFAULT;
                break;
            }
            case 1: {
                context = IOContext.READ;
                break;
            }
            case 2: {
                context = IOContext.READONCE;
                break;
            }
            case 3: {
                context = new IOContext(new MergeInfo(randomNumDocs, (long)size, true, -1));
                break;
            }
            case 4: {
                context = new IOContext(new FlushInfo(randomNumDocs, (long)size));
                break;
            }
            default: {
                context = IOContext.DEFAULT;
            }
        }
        return context;
    }

    @Before
    public void overrideTestDefaultQueryCache() {
        LuceneTestCase.overrideDefaultQueryCache();
    }

    @BeforeClass
    public static void overrideDefaultQueryCache() {
        IndexSearcher.setDefaultQueryCache((QueryCache)new LRUQueryCache(10000, 0x2000000L, context -> true));
        IndexSearcher.setDefaultQueryCachingPolicy((QueryCachingPolicy)MAYBE_CACHE_POLICY);
    }

    @AfterClass
    public static void resetDefaultQueryCache() {
        IndexSearcher.setDefaultQueryCache((QueryCache)DEFAULT_QUERY_CACHE);
        IndexSearcher.setDefaultQueryCachingPolicy((QueryCachingPolicy)DEFAULT_CACHING_POLICY);
    }

    @BeforeClass
    public static void setupCPUCoreCount() {
        int numCores = TestUtil.nextInt(LuceneTestCase.random(), 1, 4);
        System.setProperty("lucene.cms.override_core_count", Integer.toString(numCores));
    }

    @AfterClass
    public static void restoreCPUCoreCount() {
        System.clearProperty("lucene.cms.override_core_count");
    }

    @BeforeClass
    public static void setupSpins() {
        boolean spins = LuceneTestCase.random().nextBoolean();
        System.setProperty("lucene.cms.override_spins", Boolean.toString(spins));
    }

    @AfterClass
    public static void restoreSpins() {
        System.clearProperty("lucene.cms.override_spins");
    }

    public static IndexSearcher newSearcher(IndexReader r) {
        return LuceneTestCase.newSearcher(r, true);
    }

    public static IndexSearcher newSearcher(IndexReader r, boolean maybeWrap) {
        return LuceneTestCase.newSearcher(r, maybeWrap, true);
    }

    public static IndexSearcher newSearcher(IndexReader r, boolean maybeWrap, boolean wrapWithAssertions) {
        ThreadPoolExecutor ex;
        Random random = LuceneTestCase.random();
        if (LuceneTestCase.usually()) {
            if (maybeWrap) {
                try {
                    r = LuceneTestCase.maybeWrapReader(r);
                }
                catch (IOException e) {
                    Rethrow.rethrow(e);
                }
            }
            if (random.nextInt(500) == 0 && r instanceof LeafReader) {
                try {
                    TestUtil.checkReader(r);
                }
                catch (IOException e) {
                    Rethrow.rethrow(e);
                }
            }
            IndexSearcher ret = wrapWithAssertions ? (random.nextBoolean() ? new AssertingIndexSearcher(random, r) : new AssertingIndexSearcher(random, r.getContext())) : (random.nextBoolean() ? new IndexSearcher(r) : new IndexSearcher(r.getContext()));
            ret.setSimilarity(LuceneTestCase.classEnvRule.similarity);
            return ret;
        }
        int threads = 0;
        if (random.nextBoolean()) {
            ex = null;
        } else {
            threads = TestUtil.nextInt(random, 1, 8);
            ex = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("LuceneTestCase"));
        }
        if (ex != null) {
            if (VERBOSE) {
                System.out.println("NOTE: newSearcher using ExecutorService with " + threads + " threads");
            }
            r.addReaderClosedListener(new IndexReader.ReaderClosedListener(){

                public void onClose(IndexReader reader) {
                    TestUtil.shutdownExecutorService(ex);
                }
            });
        }
        IndexSearcher ret = wrapWithAssertions ? (random.nextBoolean() ? new AssertingIndexSearcher(random, r, ex) : new AssertingIndexSearcher(random, r.getContext(), ex)) : (random.nextBoolean() ? new IndexSearcher(r, ex) : new IndexSearcher(r.getContext(), ex));
        ret.setSimilarity(LuceneTestCase.classEnvRule.similarity);
        ret.setQueryCachingPolicy(MAYBE_CACHE_POLICY);
        return ret;
    }

    protected Path getDataPath(String name) throws IOException {
        try {
            return Paths.get(((Object)((Object)this)).getClass().getResource(name).toURI());
        }
        catch (Exception e) {
            throw new IOException("Cannot find resource: " + name);
        }
    }

    protected InputStream getDataInputStream(String name) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (in == null) {
            throw new IOException("Cannot find resource: " + name);
        }
        return in;
    }

    public void assertReaderEquals(String info, IndexReader leftReader, IndexReader rightReader) throws IOException {
        this.assertReaderStatisticsEquals(info, leftReader, rightReader);
        this.assertFieldsEquals(info, leftReader, MultiFields.getFields((IndexReader)leftReader), MultiFields.getFields((IndexReader)rightReader), true);
        this.assertNormsEquals(info, leftReader, rightReader);
        this.assertStoredFieldsEquals(info, leftReader, rightReader);
        this.assertTermVectorsEquals(info, leftReader, rightReader);
        this.assertDocValuesEquals(info, leftReader, rightReader);
        this.assertDeletedDocsEquals(info, leftReader, rightReader);
        this.assertFieldInfosEquals(info, leftReader, rightReader);
        this.assertPointsEquals(info, leftReader, rightReader);
    }

    public void assertReaderStatisticsEquals(String info, IndexReader leftReader, IndexReader rightReader) throws IOException {
        LuceneTestCase.assertEquals((String)info, (long)leftReader.maxDoc(), (long)rightReader.maxDoc());
        LuceneTestCase.assertEquals((String)info, (long)leftReader.numDocs(), (long)rightReader.numDocs());
        LuceneTestCase.assertEquals((String)info, (long)leftReader.numDeletedDocs(), (long)rightReader.numDeletedDocs());
        LuceneTestCase.assertEquals((String)info, (Object)leftReader.hasDeletions(), (Object)rightReader.hasDeletions());
    }

    public void assertFieldsEquals(String info, IndexReader leftReader, Fields leftFields, Fields rightFields, boolean deep) throws IOException {
        if (leftFields == null || rightFields == null) {
            LuceneTestCase.assertNull((String)info, (Object)leftFields);
            LuceneTestCase.assertNull((String)info, (Object)rightFields);
            return;
        }
        this.assertFieldStatisticsEquals(info, leftFields, rightFields);
        Iterator leftEnum = leftFields.iterator();
        Iterator rightEnum = rightFields.iterator();
        while (leftEnum.hasNext()) {
            String field = (String)leftEnum.next();
            LuceneTestCase.assertEquals((String)info, (Object)field, rightEnum.next());
            this.assertTermsEquals(info, leftReader, leftFields.terms(field), rightFields.terms(field), deep);
        }
        LuceneTestCase.assertFalse((boolean)rightEnum.hasNext());
    }

    public void assertFieldStatisticsEquals(String info, Fields leftFields, Fields rightFields) throws IOException {
        if (leftFields.size() != -1 && rightFields.size() != -1) {
            LuceneTestCase.assertEquals((String)info, (long)leftFields.size(), (long)rightFields.size());
        }
    }

    public void assertTermsEquals(String info, IndexReader leftReader, Terms leftTerms, Terms rightTerms, boolean deep) throws IOException {
        if (leftTerms == null || rightTerms == null) {
            LuceneTestCase.assertNull((String)info, (Object)leftTerms);
            LuceneTestCase.assertNull((String)info, (Object)rightTerms);
            return;
        }
        this.assertTermsStatisticsEquals(info, leftTerms, rightTerms);
        LuceneTestCase.assertEquals((String)"hasOffsets", (Object)leftTerms.hasOffsets(), (Object)rightTerms.hasOffsets());
        LuceneTestCase.assertEquals((String)"hasPositions", (Object)leftTerms.hasPositions(), (Object)rightTerms.hasPositions());
        LuceneTestCase.assertEquals((String)"hasPayloads", (Object)leftTerms.hasPayloads(), (Object)rightTerms.hasPayloads());
        TermsEnum leftTermsEnum = leftTerms.iterator();
        TermsEnum rightTermsEnum = rightTerms.iterator();
        this.assertTermsEnumEquals(info, leftReader, leftTermsEnum, rightTermsEnum, true);
        this.assertTermsSeekingEquals(info, leftTerms, rightTerms);
        if (deep) {
            int numIntersections = LuceneTestCase.atLeast(3);
            for (int i = 0; i < numIntersections; ++i) {
                String re = AutomatonTestUtil.randomRegexp(LuceneTestCase.random());
                CompiledAutomaton automaton = new CompiledAutomaton(new RegExp(re, 0).toAutomaton());
                if (automaton.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) continue;
                TermsEnum leftIntersection = leftTerms.intersect(automaton, null);
                TermsEnum rightIntersection = rightTerms.intersect(automaton, null);
                this.assertTermsEnumEquals(info, leftReader, leftIntersection, rightIntersection, LuceneTestCase.rarely());
            }
        }
    }

    public void assertTermsStatisticsEquals(String info, Terms leftTerms, Terms rightTerms) throws IOException {
        if (leftTerms.getDocCount() != -1 && rightTerms.getDocCount() != -1) {
            LuceneTestCase.assertEquals((String)info, (long)leftTerms.getDocCount(), (long)rightTerms.getDocCount());
        }
        if (leftTerms.getSumDocFreq() != -1L && rightTerms.getSumDocFreq() != -1L) {
            LuceneTestCase.assertEquals((String)info, (long)leftTerms.getSumDocFreq(), (long)rightTerms.getSumDocFreq());
        }
        if (leftTerms.getSumTotalTermFreq() != -1L && rightTerms.getSumTotalTermFreq() != -1L) {
            LuceneTestCase.assertEquals((String)info, (long)leftTerms.getSumTotalTermFreq(), (long)rightTerms.getSumTotalTermFreq());
        }
        if (leftTerms.size() != -1L && rightTerms.size() != -1L) {
            LuceneTestCase.assertEquals((String)info, (long)leftTerms.size(), (long)rightTerms.size());
        }
    }

    public void assertTermsEnumEquals(String info, IndexReader leftReader, TermsEnum leftTermsEnum, TermsEnum rightTermsEnum, boolean deep) throws IOException {
        BytesRef term;
        PostingsEnum leftPositions = null;
        PostingsEnum rightPositions = null;
        PostingsEnum leftDocs = null;
        PostingsEnum rightDocs = null;
        while ((term = leftTermsEnum.next()) != null) {
            LuceneTestCase.assertEquals((String)info, (Object)term, (Object)rightTermsEnum.next());
            this.assertTermStatsEquals(info, leftTermsEnum, rightTermsEnum);
            if (!deep) continue;
            leftPositions = leftTermsEnum.postings(leftPositions, 120);
            rightPositions = rightTermsEnum.postings(rightPositions, 120);
            this.assertDocsAndPositionsEnumEquals(info, leftPositions, rightPositions);
            leftPositions = leftTermsEnum.postings(leftPositions, 120);
            rightPositions = rightTermsEnum.postings(rightPositions, 120);
            this.assertPositionsSkippingEquals(info, leftReader, leftTermsEnum.docFreq(), leftPositions, rightPositions);
            leftDocs = leftTermsEnum.postings(leftDocs);
            rightDocs = rightTermsEnum.postings(rightDocs);
            this.assertDocsEnumEquals(info, leftDocs, rightDocs, true);
            leftDocs = leftTermsEnum.postings(leftDocs, 0);
            rightDocs = rightTermsEnum.postings(rightDocs, 0);
            this.assertDocsEnumEquals(info, leftDocs, rightDocs, false);
            leftDocs = leftTermsEnum.postings(leftDocs);
            rightDocs = rightTermsEnum.postings(rightDocs);
            this.assertDocsSkippingEquals(info, leftReader, leftTermsEnum.docFreq(), leftDocs, rightDocs, true);
            leftDocs = leftTermsEnum.postings(leftDocs, 0);
            rightDocs = rightTermsEnum.postings(rightDocs, 0);
            this.assertDocsSkippingEquals(info, leftReader, leftTermsEnum.docFreq(), leftDocs, rightDocs, false);
        }
        LuceneTestCase.assertNull((String)info, (Object)rightTermsEnum.next());
    }

    public void assertDocsAndPositionsEnumEquals(String info, PostingsEnum leftDocs, PostingsEnum rightDocs) throws IOException {
        int docid;
        LuceneTestCase.assertNotNull((Object)leftDocs);
        LuceneTestCase.assertNotNull((Object)rightDocs);
        LuceneTestCase.assertEquals((String)info, (long)-1L, (long)leftDocs.docID());
        LuceneTestCase.assertEquals((String)info, (long)-1L, (long)rightDocs.docID());
        while ((docid = leftDocs.nextDoc()) != Integer.MAX_VALUE) {
            LuceneTestCase.assertEquals((String)info, (long)docid, (long)rightDocs.nextDoc());
            int freq = leftDocs.freq();
            LuceneTestCase.assertEquals((String)info, (long)freq, (long)rightDocs.freq());
            for (int i = 0; i < freq; ++i) {
                LuceneTestCase.assertEquals((String)info, (long)leftDocs.nextPosition(), (long)rightDocs.nextPosition());
                LuceneTestCase.assertEquals((String)info, (Object)leftDocs.getPayload(), (Object)rightDocs.getPayload());
                LuceneTestCase.assertEquals((String)info, (long)leftDocs.startOffset(), (long)rightDocs.startOffset());
                LuceneTestCase.assertEquals((String)info, (long)leftDocs.endOffset(), (long)rightDocs.endOffset());
            }
        }
        LuceneTestCase.assertEquals((String)info, (long)Integer.MAX_VALUE, (long)rightDocs.nextDoc());
    }

    public void assertDocsEnumEquals(String info, PostingsEnum leftDocs, PostingsEnum rightDocs, boolean hasFreqs) throws IOException {
        int docid;
        if (leftDocs == null) {
            LuceneTestCase.assertNull((Object)rightDocs);
            return;
        }
        LuceneTestCase.assertEquals((String)info, (long)-1L, (long)leftDocs.docID());
        LuceneTestCase.assertEquals((String)info, (long)-1L, (long)rightDocs.docID());
        while ((docid = leftDocs.nextDoc()) != Integer.MAX_VALUE) {
            LuceneTestCase.assertEquals((String)info, (long)docid, (long)rightDocs.nextDoc());
            if (!hasFreqs) continue;
            LuceneTestCase.assertEquals((String)info, (long)leftDocs.freq(), (long)rightDocs.freq());
        }
        LuceneTestCase.assertEquals((String)info, (long)Integer.MAX_VALUE, (long)rightDocs.nextDoc());
    }

    public void assertDocsSkippingEquals(String info, IndexReader leftReader, int docFreq, PostingsEnum leftDocs, PostingsEnum rightDocs, boolean hasFreqs) throws IOException {
        if (leftDocs == null) {
            LuceneTestCase.assertNull((Object)rightDocs);
            return;
        }
        int docid = -1;
        int averageGap = leftReader.maxDoc() / (1 + docFreq);
        int skipInterval = 16;
        while (true) {
            if (LuceneTestCase.random().nextBoolean()) {
                docid = leftDocs.nextDoc();
                LuceneTestCase.assertEquals((String)info, (long)docid, (long)rightDocs.nextDoc());
            } else {
                int skip = docid + (int)Math.ceil(Math.abs((double)skipInterval + LuceneTestCase.random().nextGaussian() * (double)averageGap));
                docid = leftDocs.advance(skip);
                LuceneTestCase.assertEquals((String)info, (long)docid, (long)rightDocs.advance(skip));
            }
            if (docid == Integer.MAX_VALUE) {
                return;
            }
            if (!hasFreqs) continue;
            LuceneTestCase.assertEquals((String)info, (long)leftDocs.freq(), (long)rightDocs.freq());
        }
    }

    public void assertPositionsSkippingEquals(String info, IndexReader leftReader, int docFreq, PostingsEnum leftDocs, PostingsEnum rightDocs) throws IOException {
        if (leftDocs == null || rightDocs == null) {
            LuceneTestCase.assertNull((Object)leftDocs);
            LuceneTestCase.assertNull((Object)rightDocs);
            return;
        }
        int docid = -1;
        int averageGap = leftReader.maxDoc() / (1 + docFreq);
        int skipInterval = 16;
        block0: while (true) {
            if (LuceneTestCase.random().nextBoolean()) {
                docid = leftDocs.nextDoc();
                LuceneTestCase.assertEquals((String)info, (long)docid, (long)rightDocs.nextDoc());
            } else {
                int skip = docid + (int)Math.ceil(Math.abs((double)skipInterval + LuceneTestCase.random().nextGaussian() * (double)averageGap));
                docid = leftDocs.advance(skip);
                LuceneTestCase.assertEquals((String)info, (long)docid, (long)rightDocs.advance(skip));
            }
            if (docid == Integer.MAX_VALUE) {
                return;
            }
            int freq = leftDocs.freq();
            LuceneTestCase.assertEquals((String)info, (long)freq, (long)rightDocs.freq());
            int i = 0;
            while (true) {
                if (i >= freq) continue block0;
                LuceneTestCase.assertEquals((String)info, (long)leftDocs.nextPosition(), (long)rightDocs.nextPosition());
                LuceneTestCase.assertEquals((String)info, (Object)leftDocs.getPayload(), (Object)rightDocs.getPayload());
                ++i;
            }
            break;
        }
    }

    private void assertTermsSeekingEquals(String info, Terms leftTerms, Terms rightTerms) throws IOException {
        int numTests = LuceneTestCase.atLeast(20);
        Random random = LuceneTestCase.random();
        TermsEnum leftEnum = null;
        HashSet<BytesRef> tests = new HashSet<BytesRef>();
        for (int numPasses = 0; numPasses < 10 && tests.size() < numTests; ++numPasses) {
            leftEnum = leftTerms.iterator();
            BytesRef term = null;
            block6: while ((term = leftEnum.next()) != null) {
                int code = random.nextInt(10);
                if (code == 0) {
                    tests.add(BytesRef.deepCopyOf((BytesRef)term));
                    continue;
                }
                if (code == 1) {
                    term = BytesRef.deepCopyOf((BytesRef)term);
                    if (term.length <= 0) continue;
                    term.length = random.nextInt(term.length);
                    continue;
                }
                if (code == 2) {
                    byte[] newbytes = new byte[term.length + 5];
                    System.arraycopy(term.bytes, term.offset, newbytes, 5, term.length);
                    tests.add(new BytesRef(newbytes, 5, term.length));
                    continue;
                }
                if (code != 3) continue;
                switch (LuceneTestCase.random().nextInt(3)) {
                    case 0: {
                        tests.add(new BytesRef());
                        continue block6;
                    }
                    case 1: {
                        tests.add(new BytesRef(new byte[]{-1, -1}));
                        continue block6;
                    }
                    case 2: {
                        tests.add(new BytesRef((CharSequence)TestUtil.randomSimpleString(LuceneTestCase.random())));
                        continue block6;
                    }
                }
                throw new AssertionError();
            }
        }
        TermsEnum rightEnum = rightTerms.iterator();
        ArrayList shuffledTests = new ArrayList(tests);
        Collections.shuffle(shuffledTests, random);
        for (BytesRef b : shuffledTests) {
            boolean seekExact;
            if (LuceneTestCase.rarely()) {
                leftEnum = leftTerms.iterator();
                rightEnum = rightTerms.iterator();
            }
            if (seekExact = LuceneTestCase.random().nextBoolean()) {
                LuceneTestCase.assertEquals((String)info, (Object)leftEnum.seekExact(b), (Object)rightEnum.seekExact(b));
                continue;
            }
            TermsEnum.SeekStatus leftStatus = leftEnum.seekCeil(b);
            TermsEnum.SeekStatus rightStatus = rightEnum.seekCeil(b);
            LuceneTestCase.assertEquals((String)info, (Object)leftStatus, (Object)rightStatus);
            if (leftStatus == TermsEnum.SeekStatus.END) continue;
            LuceneTestCase.assertEquals((String)info, (Object)leftEnum.term(), (Object)rightEnum.term());
            this.assertTermStatsEquals(info, leftEnum, rightEnum);
        }
    }

    public void assertTermStatsEquals(String info, TermsEnum leftTermsEnum, TermsEnum rightTermsEnum) throws IOException {
        LuceneTestCase.assertEquals((String)info, (long)leftTermsEnum.docFreq(), (long)rightTermsEnum.docFreq());
        if (leftTermsEnum.totalTermFreq() != -1L && rightTermsEnum.totalTermFreq() != -1L) {
            LuceneTestCase.assertEquals((String)info, (long)leftTermsEnum.totalTermFreq(), (long)rightTermsEnum.totalTermFreq());
        }
    }

    public void assertNormsEquals(String info, IndexReader leftReader, IndexReader rightReader) throws IOException {
        Fields leftFields = MultiFields.getFields((IndexReader)leftReader);
        Fields rightFields = MultiFields.getFields((IndexReader)rightReader);
        if (leftFields == null || rightFields == null) {
            LuceneTestCase.assertNull((String)info, (Object)leftFields);
            LuceneTestCase.assertNull((String)info, (Object)rightFields);
            return;
        }
        for (String field : leftFields) {
            NumericDocValues leftNorms = MultiDocValues.getNormValues((IndexReader)leftReader, (String)field);
            NumericDocValues rightNorms = MultiDocValues.getNormValues((IndexReader)rightReader, (String)field);
            if (leftNorms != null && rightNorms != null) {
                this.assertDocValuesEquals(info, leftReader.maxDoc(), leftNorms, rightNorms);
                continue;
            }
            LuceneTestCase.assertNull((String)info, (Object)leftNorms);
            LuceneTestCase.assertNull((String)info, (Object)rightNorms);
        }
    }

    public void assertStoredFieldsEquals(String info, IndexReader leftReader, IndexReader rightReader) throws IOException {
        assert (leftReader.maxDoc() == rightReader.maxDoc());
        for (int i = 0; i < leftReader.maxDoc(); ++i) {
            Document leftDoc = leftReader.document(i);
            Document rightDoc = rightReader.document(i);
            Comparator<IndexableField> comp = new Comparator<IndexableField>(){

                @Override
                public int compare(IndexableField arg0, IndexableField arg1) {
                    return arg0.name().compareTo(arg1.name());
                }
            };
            ArrayList leftFields = new ArrayList(leftDoc.getFields());
            ArrayList rightFields = new ArrayList(rightDoc.getFields());
            Collections.sort(leftFields, comp);
            Collections.sort(rightFields, comp);
            Iterator leftIterator = leftFields.iterator();
            Iterator rightIterator = rightFields.iterator();
            while (leftIterator.hasNext()) {
                LuceneTestCase.assertTrue((String)info, (boolean)rightIterator.hasNext());
                this.assertStoredFieldEquals(info, (IndexableField)leftIterator.next(), (IndexableField)rightIterator.next());
            }
            LuceneTestCase.assertFalse((String)info, (boolean)rightIterator.hasNext());
        }
    }

    public void assertStoredFieldEquals(String info, IndexableField leftField, IndexableField rightField) {
        LuceneTestCase.assertEquals((String)info, (Object)leftField.name(), (Object)rightField.name());
        LuceneTestCase.assertEquals((String)info, (Object)leftField.binaryValue(), (Object)rightField.binaryValue());
        LuceneTestCase.assertEquals((String)info, (Object)leftField.stringValue(), (Object)rightField.stringValue());
        LuceneTestCase.assertEquals((String)info, (Object)leftField.numericValue(), (Object)rightField.numericValue());
    }

    public void assertTermVectorsEquals(String info, IndexReader leftReader, IndexReader rightReader) throws IOException {
        assert (leftReader.maxDoc() == rightReader.maxDoc());
        for (int i = 0; i < leftReader.maxDoc(); ++i) {
            Fields leftFields = leftReader.getTermVectors(i);
            Fields rightFields = rightReader.getTermVectors(i);
            this.assertFieldsEquals(info, leftReader, leftFields, rightFields, LuceneTestCase.rarely());
        }
    }

    private static Set<String> getDVFields(IndexReader reader) {
        HashSet<String> fields = new HashSet<String>();
        for (FieldInfo fi : MultiFields.getMergedFieldInfos((IndexReader)reader)) {
            if (fi.getDocValuesType() == DocValuesType.NONE) continue;
            fields.add(fi.name);
        }
        return fields;
    }

    public void assertDocValuesEquals(String info, IndexReader leftReader, IndexReader rightReader) throws IOException {
        Set<String> leftFields = LuceneTestCase.getDVFields(leftReader);
        Set<String> rightFields = LuceneTestCase.getDVFields(rightReader);
        LuceneTestCase.assertEquals((String)info, leftFields, rightFields);
        for (String field : leftFields) {
            int i;
            BytesRef right;
            BytesRef left;
            int docID;
            NumericDocValues leftValues = MultiDocValues.getNumericValues((IndexReader)leftReader, (String)field);
            NumericDocValues rightValues = MultiDocValues.getNumericValues((IndexReader)rightReader, (String)field);
            if (leftValues != null && rightValues != null) {
                this.assertDocValuesEquals(info, leftReader.maxDoc(), leftValues, rightValues);
            } else {
                LuceneTestCase.assertNull((String)info, (Object)leftValues);
                LuceneTestCase.assertNull((String)info, (Object)rightValues);
            }
            leftValues = MultiDocValues.getBinaryValues((IndexReader)leftReader, (String)field);
            rightValues = MultiDocValues.getBinaryValues((IndexReader)rightReader, (String)field);
            if (leftValues != null && rightValues != null) {
                for (docID = 0; docID < leftReader.maxDoc(); ++docID) {
                    left = BytesRef.deepCopyOf((BytesRef)leftValues.get(docID));
                    right = rightValues.get(docID);
                    LuceneTestCase.assertEquals((String)info, (Object)left, (Object)right);
                }
            } else {
                LuceneTestCase.assertNull((String)info, (Object)leftValues);
                LuceneTestCase.assertNull((String)info, (Object)rightValues);
            }
            leftValues = MultiDocValues.getSortedValues((IndexReader)leftReader, (String)field);
            rightValues = MultiDocValues.getSortedValues((IndexReader)rightReader, (String)field);
            if (leftValues != null && rightValues != null) {
                LuceneTestCase.assertEquals((String)info, (long)leftValues.getValueCount(), (long)rightValues.getValueCount());
                for (i = 0; i < leftValues.getValueCount(); ++i) {
                    left = BytesRef.deepCopyOf((BytesRef)leftValues.lookupOrd(i));
                    right = rightValues.lookupOrd(i);
                    LuceneTestCase.assertEquals((String)info, (Object)left, (Object)right);
                }
                for (docID = 0; docID < leftReader.maxDoc(); ++docID) {
                    left = BytesRef.deepCopyOf((BytesRef)leftValues.get(docID));
                    right = rightValues.get(docID);
                    LuceneTestCase.assertEquals((String)info, (Object)left, (Object)right);
                }
            } else {
                LuceneTestCase.assertNull((String)info, (Object)leftValues);
                LuceneTestCase.assertNull((String)info, (Object)rightValues);
            }
            leftValues = MultiDocValues.getSortedSetValues((IndexReader)leftReader, (String)field);
            rightValues = MultiDocValues.getSortedSetValues((IndexReader)rightReader, (String)field);
            if (leftValues != null && rightValues != null) {
                LuceneTestCase.assertEquals((String)info, (long)leftValues.getValueCount(), (long)rightValues.getValueCount());
                i = 0;
                while ((long)i < leftValues.getValueCount()) {
                    left = BytesRef.deepCopyOf((BytesRef)leftValues.lookupOrd((long)i));
                    right = rightValues.lookupOrd((long)i);
                    LuceneTestCase.assertEquals((String)info, (Object)left, (Object)right);
                    ++i;
                }
                for (docID = 0; docID < leftReader.maxDoc(); ++docID) {
                    long ord;
                    leftValues.setDocument(docID);
                    rightValues.setDocument(docID);
                    while ((ord = leftValues.nextOrd()) != -1L) {
                        LuceneTestCase.assertEquals((String)info, (long)ord, (long)rightValues.nextOrd());
                    }
                    LuceneTestCase.assertEquals((String)info, (long)-1L, (long)rightValues.nextOrd());
                }
            } else {
                LuceneTestCase.assertNull((String)info, (Object)leftValues);
                LuceneTestCase.assertNull((String)info, (Object)rightValues);
            }
            leftValues = MultiDocValues.getSortedNumericValues((IndexReader)leftReader, (String)field);
            rightValues = MultiDocValues.getSortedNumericValues((IndexReader)rightReader, (String)field);
            if (leftValues != null && rightValues != null) {
                for (i = 0; i < leftReader.maxDoc(); ++i) {
                    int j;
                    leftValues.setDocument(i);
                    long[] expected = new long[leftValues.count()];
                    for (j = 0; j < expected.length; ++j) {
                        expected[j] = leftValues.valueAt(j);
                    }
                    rightValues.setDocument(i);
                    for (j = 0; j < expected.length; ++j) {
                        LuceneTestCase.assertEquals((String)info, (long)expected[j], (long)rightValues.valueAt(j));
                    }
                    LuceneTestCase.assertEquals((String)info, (long)expected.length, (long)rightValues.count());
                }
            } else {
                LuceneTestCase.assertNull((String)info, (Object)leftValues);
                LuceneTestCase.assertNull((String)info, (Object)rightValues);
            }
            Bits leftBits = MultiDocValues.getDocsWithField((IndexReader)leftReader, (String)field);
            Bits rightBits = MultiDocValues.getDocsWithField((IndexReader)rightReader, (String)field);
            if (leftBits != null && rightBits != null) {
                LuceneTestCase.assertEquals((String)info, (long)leftBits.length(), (long)rightBits.length());
                for (i = 0; i < leftBits.length(); ++i) {
                    LuceneTestCase.assertEquals((String)info, (Object)leftBits.get(i), (Object)rightBits.get(i));
                }
                continue;
            }
            LuceneTestCase.assertNull((String)info, (Object)leftBits);
            LuceneTestCase.assertNull((String)info, (Object)rightBits);
        }
    }

    public void assertDocValuesEquals(String info, int num, NumericDocValues leftDocValues, NumericDocValues rightDocValues) throws IOException {
        LuceneTestCase.assertNotNull((String)info, (Object)leftDocValues);
        LuceneTestCase.assertNotNull((String)info, (Object)rightDocValues);
        for (int docID = 0; docID < num; ++docID) {
            LuceneTestCase.assertEquals((long)leftDocValues.get(docID), (long)rightDocValues.get(docID));
        }
    }

    public void assertDeletedDocsEquals(String info, IndexReader leftReader, IndexReader rightReader) throws IOException {
        assert (leftReader.numDeletedDocs() == rightReader.numDeletedDocs());
        Bits leftBits = MultiFields.getLiveDocs((IndexReader)leftReader);
        Bits rightBits = MultiFields.getLiveDocs((IndexReader)rightReader);
        if (leftBits == null || rightBits == null) {
            LuceneTestCase.assertNull((String)info, (Object)leftBits);
            LuceneTestCase.assertNull((String)info, (Object)rightBits);
            return;
        }
        assert (leftReader.maxDoc() == rightReader.maxDoc());
        LuceneTestCase.assertEquals((String)info, (long)leftBits.length(), (long)rightBits.length());
        for (int i = 0; i < leftReader.maxDoc(); ++i) {
            LuceneTestCase.assertEquals((String)info, (Object)leftBits.get(i), (Object)rightBits.get(i));
        }
    }

    public void assertFieldInfosEquals(String info, IndexReader leftReader, IndexReader rightReader) throws IOException {
        FieldInfos leftInfos = MultiFields.getMergedFieldInfos((IndexReader)leftReader);
        FieldInfos rightInfos = MultiFields.getMergedFieldInfos((IndexReader)rightReader);
        TreeSet<String> left = new TreeSet<String>();
        TreeSet<String> right = new TreeSet<String>();
        for (FieldInfo fi : leftInfos) {
            left.add(fi.name);
        }
        for (FieldInfo fi : rightInfos) {
            right.add(fi.name);
        }
        LuceneTestCase.assertEquals((String)info, left, right);
    }

    private Map<Integer, Set<BytesRef>> uninvert(String fieldName, IndexReader reader) throws IOException {
        final HashMap<Integer, Set<BytesRef>> docValues = new HashMap<Integer, Set<BytesRef>>();
        for (final LeafReaderContext ctx : reader.leaves()) {
            PointValues points = ctx.reader().getPointValues();
            if (points == null) continue;
            points.intersect(fieldName, new PointValues.IntersectVisitor(){

                public void visit(int docID) {
                    throw new UnsupportedOperationException();
                }

                public void visit(int docID, byte[] packedValue) throws IOException {
                    int topDocID = ctx.docBase + docID;
                    if (!docValues.containsKey(topDocID)) {
                        docValues.put(topDocID, new HashSet());
                    }
                    ((Set)docValues.get(topDocID)).add(new BytesRef((byte[])packedValue.clone()));
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
        }
        return docValues;
    }

    public void assertPointsEquals(String info, IndexReader leftReader, IndexReader rightReader) throws IOException {
        FieldInfos fieldInfos1 = MultiFields.getMergedFieldInfos((IndexReader)leftReader);
        FieldInfos fieldInfos2 = MultiFields.getMergedFieldInfos((IndexReader)rightReader);
        for (FieldInfo fieldInfo1 : fieldInfos1) {
            if (fieldInfo1.getPointDimensionCount() == 0) continue;
            FieldInfo fieldInfo2 = fieldInfos2.fieldInfo(fieldInfo1.name);
            LuceneTestCase.assertEquals((String)info, (long)fieldInfo2.getPointDimensionCount(), (long)fieldInfo2.getPointDimensionCount());
            LuceneTestCase.assertEquals((String)info, (long)fieldInfo2.getPointNumBytes(), (long)fieldInfo2.getPointNumBytes());
            LuceneTestCase.assertEquals((String)(info + " field=" + fieldInfo1.name), this.uninvert(fieldInfo1.name, leftReader), this.uninvert(fieldInfo1.name, rightReader));
        }
        for (FieldInfo fieldInfo2 : fieldInfos2) {
            if (fieldInfo2.getPointDimensionCount() == 0) continue;
            FieldInfo fieldInfo1 = fieldInfos1.fieldInfo(fieldInfo2.name);
            LuceneTestCase.assertEquals((String)info, (long)fieldInfo2.getPointDimensionCount(), (long)fieldInfo1.getPointDimensionCount());
            LuceneTestCase.assertEquals((String)info, (long)fieldInfo2.getPointNumBytes(), (long)fieldInfo1.getPointNumBytes());
        }
    }

    public static <T extends Throwable> T expectThrows(Class<T> expectedType, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            if (expectedType.isInstance(e)) {
                return (T)((Throwable)expectedType.cast(e));
            }
            AssertionFailedError assertion = new AssertionFailedError("Unexpected exception type, expected " + expectedType.getSimpleName());
            assertion.initCause(e);
            throw assertion;
        }
        throw new AssertionFailedError("Expected exception " + expectedType.getSimpleName());
    }

    public static <TO extends Throwable, TW extends Throwable> TW expectThrows(Class<TO> expectedOuterType, Class<TW> expectedWrappedType, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            if (expectedOuterType.isInstance(e)) {
                Throwable cause = e.getCause();
                if (expectedWrappedType.isInstance(cause)) {
                    return (TW)((Throwable)expectedWrappedType.cast(cause));
                }
                AssertionFailedError assertion = new AssertionFailedError("Unexpected wrapped exception type, expected " + expectedWrappedType.getSimpleName());
                assertion.initCause(e);
                throw assertion;
            }
            AssertionFailedError assertion = new AssertionFailedError("Unexpected outer exception type, expected " + expectedOuterType.getSimpleName());
            assertion.initCause(e);
            throw assertion;
        }
        throw new AssertionFailedError("Expected outer exception " + expectedOuterType.getSimpleName());
    }

    public static boolean slowFileExists(Directory dir, String fileName) throws IOException {
        try {
            dir.openInput(fileName, IOContext.DEFAULT).close();
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
    }

    @Deprecated
    public static Path getBaseTempDirForTestClass() {
        return tempFilesCleanupRule.getPerTestClassTempDir();
    }

    public static Path createTempDir() {
        return LuceneTestCase.createTempDir("tempDir");
    }

    public static Path createTempDir(String prefix) {
        return tempFilesCleanupRule.createTempDir(prefix);
    }

    public static Path createTempFile(String prefix, String suffix) throws IOException {
        return tempFilesCleanupRule.createTempFile(prefix, suffix);
    }

    public static Path createTempFile() throws IOException {
        return LuceneTestCase.createTempFile("tempFile", ".tmp");
    }

    public static <T> T runWithRestrictedPermissions(PrivilegedExceptionAction<T> action, Permission ... permissions) throws Exception {
        LuceneTestCase.assumeTrue("runWithRestrictedPermissions requires a SecurityManager enabled", System.getSecurityManager() != null);
        AccessController.checkPermission(new SecurityPermission("createAccessControlContext"));
        Permissions perms = new Permissions();
        Arrays.stream(permissions).forEach(perms::add);
        AccessControlContext ctx = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        try {
            return AccessController.doPrivileged(action, ctx);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @SuppressForbidden(reason="dodges JDK-8071862")
    public static int collate(Collator collator, String s1, String s2) {
        int v1 = collator.compare(s1, s2);
        int v2 = collator.getCollationKey(s1).compareTo(collator.getCollationKey(s2));
        LuceneTestCase.assumeTrue("hit JDK collator bug", Integer.signum(v1) == Integer.signum(v2));
        return v1;
    }

    static {
        boolean defaultValue = false;
        for (String property : Arrays.asList("tests.leaveTemporary", "tests.leavetemporary", "tests.leavetmpdir", "solr.test.leavetmpdir")) {
            defaultValue |= RandomizedTest.systemPropertyAsBoolean((String)property, (boolean)false);
        }
        LEAVE_TEMPORARY = defaultValue;
        FS_DIRECTORIES = Arrays.asList("SimpleFSDirectory", "NIOFSDirectory", LuceneTestCase.hasWorkingMMapOnWindows() ? "MMapDirectory" : "SimpleFSDirectory");
        CORE_DIRECTORIES = new ArrayList<String>(FS_DIRECTORIES);
        CORE_DIRECTORIES.add("RAMDirectory");
        MAYBE_CACHE_POLICY = new QueryCachingPolicy(){

            public void onUse(Query query) {
            }

            public boolean shouldCache(Query query) throws IOException {
                return LuceneTestCase.random().nextBoolean();
            }
        };
        int maxFailures = RandomizedTest.systemPropertyAsInt((String)SYSPROP_MAXFAILURES, (int)Integer.MAX_VALUE);
        boolean failFast = RandomizedTest.systemPropertyAsBoolean((String)SYSPROP_FAILFAST, (boolean)false);
        if (failFast) {
            if (maxFailures == Integer.MAX_VALUE) {
                maxFailures = 1;
            } else {
                Logger.getLogger(LuceneTestCase.class.getSimpleName()).warning("Property 'tests.maxfailures'=" + maxFailures + ", 'failfast' is ignored.");
            }
        }
        ignoreAfterMaxFailuresDelegate = new AtomicReference<TestRuleIgnoreAfterMaxFailures>(new TestRuleIgnoreAfterMaxFailures(maxFailures));
        ignoreAfterMaxFailures = TestRuleDelegate.of(ignoreAfterMaxFailuresDelegate);
        TestRuleLimitSysouts.checkCaptureStreams();
        Logger.getGlobal().getHandlers();
        STATIC_LEAK_IGNORED_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.slf4j.Logger", "org.apache.solr.SolrLogFormatter", "java.io.File", Path.class.getName(), Class.class.getName(), EnumSet.class.getName())));
        suiteFailureMarker = new TestRuleMarkFailure(new TestRuleMarkFailure[0]);
        tempFilesCleanupRule = new TestRuleTemporaryFilesCleanup(suiteFailureMarker);
        RuleChain r = RuleChain.outerRule((TestRule)new TestRuleIgnoreTestSuites()).around(ignoreAfterMaxFailures).around((TestRule)suiteFailureMarker).around((TestRule)new TestRuleAssertionsRequired()).around((TestRule)new TestRuleLimitSysouts(suiteFailureMarker)).around((TestRule)tempFilesCleanupRule);
        if (!Constants.JRE_IS_MINIMUM_JAVA9) {
            r = r.around((TestRule)new StaticFieldsInvariantRule(0xA00000L, true){

                protected boolean accept(Field field) {
                    if (STATIC_LEAK_IGNORED_TYPES.contains(field.getType().getName())) {
                        return false;
                    }
                    if (field.getDeclaringClass() == LuceneTestCase.class) {
                        return false;
                    }
                    return super.accept(field);
                }
            });
        }
        classNameRule = new TestRuleStoreClassName();
        classEnvRule = new TestRuleSetupAndRestoreClassEnv();
        classRules = r.around((TestRule)new NoClassHooksShadowingRule()).around((TestRule)new NoInstanceHooksOverridesRule(){

            protected boolean verify(Method key) {
                String name = key.getName();
                return !name.equals("setUp") && !name.equals("tearDown");
            }
        }).around((TestRule)classNameRule).around((TestRule)new TestRuleRestoreSystemProperties("user.language", "user.timezone", "solr.directoryFactory", "solr.solr.home", "solr.data.dir")).around((TestRule)classEnvRule);
        fieldToType = new HashMap<String, FieldType>();
        availableLanguageTags = (String[])Arrays.stream(Locale.getAvailableLocales()).map(Locale::toLanguageTag).sorted().distinct().toArray(String[]::new);
        DEFAULT_QUERY_CACHE = IndexSearcher.getDefaultQueryCache();
        DEFAULT_CACHING_POLICY = IndexSearcher.getDefaultQueryCachingPolicy();
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        assertsAreEnabled = enabled;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }

    private static class RandomBits
    implements Bits {
        FixedBitSet bits;

        RandomBits(int maxDoc, double pctLive, Random random) {
            this.bits = new FixedBitSet(maxDoc);
            for (int i = 0; i < maxDoc; ++i) {
                if (!(random.nextDouble() <= pctLive)) continue;
                this.bits.set(i);
            }
        }

        public boolean get(int index) {
            return this.bits.get(index);
        }

        public int length() {
            return this.bits.length();
        }
    }

    static enum LiveIWCFlushMode {
        BY_RAM,
        BY_DOCS,
        EITHER;

    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressReproduceLine {
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressSysoutChecks {
        public String bugUrl();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressTempFileChecks {
        public String bugUrl() default "None";
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressFsync {
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressFileSystems {
        public String[] value();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressCodecs {
        public String[] value();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=false, sysProperty="tests.badapples")
    public static @interface BadApple {
        public String bugUrl();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=true, sysProperty="tests.slow")
    public static @interface Slow {
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=false, sysProperty="tests.awaitsfix")
    public static @interface AwaitsFix {
        public String bugUrl();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=false, sysProperty="tests.monster")
    public static @interface Monster {
        public String value();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=false, sysProperty="tests.weekly")
    public static @interface Weekly {
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=false, sysProperty="tests.nightly")
    public static @interface Nightly {
    }
}

