/**
 * Copyright (c) 2012 - 2019 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package de.dim.trafficos.simulator.api;

/**
 * 
 * @author ilenia
 * @since Jun 19, 2019
 */
public interface SignalPlanConstants {
	
	/** MIN_RELEASE_TIME: the minimum time (in sec) for the green light*/
	public static int MIN_RELEASE_TIME = 10;
	
	public static int MEAN_RELEASE_TIME = 30; //max release - min release - ped clear
	
	/** MAX_RELEASE_TIME: the maximum time (in sec) for the green light */
	public static int MAX_RELEASE_TIME = 50;
	
	/** MIN_STOP_TIME the minimum time (in sec) for the red light*/
	public static int MIN_STOP_TIME = 40;
	
	/** MAX_STOP_TIME the maximum time (in sec) for the red light */
	public static int MAX_STOP_TIME = 60;
	
	/** RELEASE_STOP_TRANS_TIME the time (in sec) for the transition light between a green and a red */
	public static int RELEASE_STOP_TRANS_TIME = 3;
	
	/** STOP_RELEASE_TRANS_TIME the time (in sec) for the transition light between a red and a green */
	public static int STOP_RELEASE_TRANS_TIME = 1;
	
	/** PED_CLEAR_TIME the time (in sec) for clearing the pedestrian lane after the red starts */
	public static int PED_CLEAR_TIME = 10;
	
	public static int MAIN_CLEAR_TIME = 6;
	
	public static int SEC_CLEAR_TIME = 4;
	
	public static String RELEASE_STATUS = "G";
	
	public static String STOP_STATUS = "R";
	
	public static String RELEASE_STOP_TRANS_STATUS = "A";
	
	public static String STOP_RELEASE_TRANS_STATUS = "RA";
	
	public static String ALL_PHASES = "all.phases";
	
	public static String PHASES_WITHOUT_PEDESTRIAN = "phases.without.pedestrian"; 
	
	public static String PHASES_NOT_ONLY_PEDESTRIAN = "phases.not.only.pedestrian"; 
}
