/**
 * Copyright (c) 2012 - 2019 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package de.dim.trafficos.simulator.api;

import java.util.List;

import de.dim.trafficos.model.device.Intersection;
import de.dim.trafficos.model.device.Position;

/**
 * An interface to compute the area surrounding each SignalGroup of an Intersection, in order to determine the possible
 * conflicts when approaching a certain point in the Intersection.
 * 
 * @author ilenia
 * @since Jul 29, 2019
 */
public interface ConflictingAreaService {
	
	public List<Position> computeConflictingAreas(Intersection intersection);

}
