/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package de.dim.trafficos.simulator.api;

import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

import de.dim.trafficos.model.device.Intersection;

/**
 * Interface to create an Intersection simulation
 * 
 * @author ilenia
 * @since Jun 12, 2019
 */
@ProviderType
public interface IntersectionService {

//	public static String ALL_SEPARATE_LANES = "sepatate.lanes";
//	public static String MERGE_STRAIGHT_TURN_RIGHT = "merge.straight.right";
//	public static String MERGE_STRAIGHT_TURN_LEFT = "merge.straight.left";
//	public static String MERGE_STRAIGHT_ALL_TURNS = "merge.straight.turns";
//	public static String MERGE_TURNS = "merge.turns";
//	public static String MAIN_ALL_SEPARATE_LANES = "main.sepatate.lanes";
//	public static String MAIN_MERGE_STRAIGHT_TURN_RIGHT = "main.merge.straight.right";
//	public static String MAIN_MERGE_STRAIGHT_TURN_LEFT = "main.merge.straight.left";
//	public static String MAIN_MERGE_STRAIGHT_ALL_TURNS = "main.merge.straight.turns";
//	public static String MAIN_MERGE_TURNS = "main.merge.turns";
	
	
	/**
	 * Creates an Intersection EObject provided an optionsMap which contains as keys the road number (from 0 to n), 
	 * and as values String Object which indicates the options for such road in terms of lanes controlled by 
	 * single SignalGroup. The valid options are the one defined in this interface.
	 * 
	 * @param optionsMap
	 * @return the Intersection object or null, if an error occurred.
	 */
	public Intersection createIntersection(Map<Integer, String> optionsMap);
	
	

}
