/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package de.dim.trafficos.simulator.tests;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.gecko.core.tests.AbstractOSGiTest;
import org.gecko.core.tests.ServiceChecker;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.osgi.framework.FrameworkUtil;

import de.dim.trafficos.model.device.Intersection;
import de.dim.trafficos.model.device.Output;
import de.dim.trafficos.model.device.Position;
import de.dim.trafficos.model.device.TOSDeviceFactory;
import de.dim.trafficos.simulator.api.ConflictingAreaService;


/**
 *Tests the implementation of the IntersectionService
 * @since 1.0
 */
@RunWith(MockitoJUnitRunner.class)
public class ConflictAreaServiceIntegrationTest extends AbstractOSGiTest {
	
	private ConflictingAreaService service;
	
	/**
	 * Creates a new instance.
	 * @param bundleContext
	 */
	public ConflictAreaServiceIntegrationTest() {
		super(FrameworkUtil.getBundle(ConflictAreaServiceIntegrationTest.class).getBundleContext());
	}

	/**
	 * Here you can put everything you want to be executed before every test
	 */
	public void doBefore() {
		
	}
	
	/**
	 * Here you can put everything you want to be executed after every test
	 */
	public void doAfter() {
		
	}
	
	@Test
	public void testDummy() {		
	}
	/**
	 * Tests that the Service is created
	 */
//	@Test
	public void testServiceCreation() {		
		setupService();
	}
	
//	@Test
	public void testNullIntersection() {
		
		setupService();
		List<Position> vertices = service.computeConflictingAreas(null);
		assertNotNull(vertices);
		assertTrue(vertices.isEmpty());
	}
	
//	@Test
	public void testNoOutput() {
		
		setupService();
		Intersection intersection = TOSDeviceFactory.eINSTANCE.createIntersection();
		List<Position> vertices = service.computeConflictingAreas(intersection);
		assertNotNull(vertices);
		assertTrue(vertices.isEmpty());
	}
	
//	@Test
	public void testNoPosition() {
		
		setupService();
		Intersection intersection = TOSDeviceFactory.eINSTANCE.createIntersection();
		Output out = TOSDeviceFactory.eINSTANCE.createOutput();
		out.setId("test");
		intersection.getOutput().add(out);
		List<Position> vertices = service.computeConflictingAreas(intersection);
		assertNotNull(vertices);
		assertTrue(vertices.isEmpty());		
	}
	
	
//	@Test
	public void testConflAreas() {
		
		setupService();
		Intersection intersection = createSampleIntersection();
		List<Position> vertices = service.computeConflictingAreas(intersection);
		assertNotNull(vertices);
		assertFalse(vertices.isEmpty());
		for(Position p : vertices) {
			System.out.println(p.getLatitude() + "," + p.getLongitude());
		}
		
	}
	
	/**
	 * @return
	 */
	private Intersection createSampleIntersection() {
		Intersection intersection = TOSDeviceFactory.eINSTANCE.createIntersection();
		Output out = TOSDeviceFactory.eINSTANCE.createOutput();
		out.setId("test");
		Position pos = TOSDeviceFactory.eINSTANCE.createPosition();
		pos.setLatitude(50.9271);
		pos.setLongitude(11.5892);
		pos.setBearing(30);
		out.getLocation().add(pos);
		intersection.getOutput().add(out);
		return intersection;
	}

	private void setupService() {
		ServiceChecker<ConflictingAreaService> checker = createCheckerTrackedForCleanUp(ConflictingAreaService.class);
		checker.start();
		assertNotNull(checker);
		assertEquals(1, checker.getCurrentCreateCount(true));
		
		service = getService(ConflictingAreaService.class);
		assertNotNull(service);
	}
	
}
