/*
 */
package de.jena.udp.model.sensinact.generic.message.impl;

import de.jena.udp.model.sensinact.generic.message.ListValueUpdate;
import de.jena.udp.model.sensinact.generic.message.MessagePackage;

import java.time.Instant;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>List Value Update</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.sensinact.generic.message.impl.ListValueUpdateImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link de.jena.udp.model.sensinact.generic.message.impl.ListValueUpdateImpl#getResource <em>Resource</em>}</li>
 *   <li>{@link de.jena.udp.model.sensinact.generic.message.impl.ListValueUpdateImpl#getOldValue <em>Old Value</em>}</li>
 *   <li>{@link de.jena.udp.model.sensinact.generic.message.impl.ListValueUpdateImpl#getNewValue <em>New Value</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ListValueUpdateImpl extends MinimalEObjectImpl.Container implements ListValueUpdate {
	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final Instant TIMESTAMP_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected Instant timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * The default value of the '{@link #getResource() <em>Resource</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResource()
	 * @generated
	 * @ordered
	 */
	protected static final String RESOURCE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getResource() <em>Resource</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResource()
	 * @generated
	 * @ordered
	 */
	protected String resource = RESOURCE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOldValue() <em>Old Value</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOldValue()
	 * @generated
	 * @ordered
	 */
	protected EList<Object> oldValue;

	/**
	 * The cached value of the '{@link #getNewValue() <em>New Value</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNewValue()
	 * @generated
	 * @ordered
	 */
	protected EList<Object> newValue;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListValueUpdateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MessagePackage.Literals.LIST_VALUE_UPDATE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Instant getTimestamp() {
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimestamp(Instant newTimestamp) {
		Instant oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MessagePackage.LIST_VALUE_UPDATE__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getResource() {
		return resource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setResource(String newResource) {
		String oldResource = resource;
		resource = newResource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MessagePackage.LIST_VALUE_UPDATE__RESOURCE, oldResource, resource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Object> getOldValue() {
		if (oldValue == null) {
			oldValue = new EDataTypeUniqueEList<Object>(Object.class, this, MessagePackage.LIST_VALUE_UPDATE__OLD_VALUE);
		}
		return oldValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Object> getNewValue() {
		if (newValue == null) {
			newValue = new EDataTypeUniqueEList<Object>(Object.class, this, MessagePackage.LIST_VALUE_UPDATE__NEW_VALUE);
		}
		return newValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MessagePackage.LIST_VALUE_UPDATE__TIMESTAMP:
				return getTimestamp();
			case MessagePackage.LIST_VALUE_UPDATE__RESOURCE:
				return getResource();
			case MessagePackage.LIST_VALUE_UPDATE__OLD_VALUE:
				return getOldValue();
			case MessagePackage.LIST_VALUE_UPDATE__NEW_VALUE:
				return getNewValue();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MessagePackage.LIST_VALUE_UPDATE__TIMESTAMP:
				setTimestamp((Instant)newValue);
				return;
			case MessagePackage.LIST_VALUE_UPDATE__RESOURCE:
				setResource((String)newValue);
				return;
			case MessagePackage.LIST_VALUE_UPDATE__OLD_VALUE:
				getOldValue().clear();
				getOldValue().addAll((Collection<? extends Object>)newValue);
				return;
			case MessagePackage.LIST_VALUE_UPDATE__NEW_VALUE:
				getNewValue().clear();
				getNewValue().addAll((Collection<? extends Object>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MessagePackage.LIST_VALUE_UPDATE__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
			case MessagePackage.LIST_VALUE_UPDATE__RESOURCE:
				setResource(RESOURCE_EDEFAULT);
				return;
			case MessagePackage.LIST_VALUE_UPDATE__OLD_VALUE:
				getOldValue().clear();
				return;
			case MessagePackage.LIST_VALUE_UPDATE__NEW_VALUE:
				getNewValue().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MessagePackage.LIST_VALUE_UPDATE__TIMESTAMP:
				return TIMESTAMP_EDEFAULT == null ? timestamp != null : !TIMESTAMP_EDEFAULT.equals(timestamp);
			case MessagePackage.LIST_VALUE_UPDATE__RESOURCE:
				return RESOURCE_EDEFAULT == null ? resource != null : !RESOURCE_EDEFAULT.equals(resource);
			case MessagePackage.LIST_VALUE_UPDATE__OLD_VALUE:
				return oldValue != null && !oldValue.isEmpty();
			case MessagePackage.LIST_VALUE_UPDATE__NEW_VALUE:
				return newValue != null && !newValue.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (timestamp: ");
		result.append(timestamp);
		result.append(", resource: ");
		result.append(resource);
		result.append(", oldValue: ");
		result.append(oldValue);
		result.append(", newValue: ");
		result.append(newValue);
		result.append(')');
		return result.toString();
	}

} //ListValueUpdateImpl
