/*
 */
package de.jena.udp.model.trafficos.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Schedule Frequency Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see de.jena.udp.model.trafficos.common.TOSCommonPackage#getScheduleFrequencyType()
 * @model
 * @generated
 */
@ProviderType
public enum ScheduleFrequencyType implements Enumerator {
	/**
	 * The '<em><b>EVERY DAY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EVERY_DAY_VALUE
	 * @generated
	 * @ordered
	 */
	EVERY_DAY(0, "EVERY_DAY", "EVERY_DAY"),

	/**
	 * The '<em><b>WEEKEND</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WEEKEND_VALUE
	 * @generated
	 * @ordered
	 */
	WEEKEND(1, "WEEKEND", "WEEKEND"),

	/**
	 * The '<em><b>WORKING DAY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WORKING_DAY_VALUE
	 * @generated
	 * @ordered
	 */
	WORKING_DAY(2, "WORKING_DAY", "WORKING_DAY"),

	/**
	 * The '<em><b>SCHOOL YEAR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCHOOL_YEAR_VALUE
	 * @generated
	 * @ordered
	 */
	SCHOOL_YEAR(3, "SCHOOL_YEAR", "SCHOOL_YEAR"),

	/**
	 * The '<em><b>PUBLIC HOLIDAY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PUBLIC_HOLIDAY_VALUE
	 * @generated
	 * @ordered
	 */
	PUBLIC_HOLIDAY(4, "PUBLIC_HOLIDAY", "PUBLIC_HOLIDAY"),

	/**
	 * The '<em><b>SATURDAY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SATURDAY_VALUE
	 * @generated
	 * @ordered
	 */
	SATURDAY(5, "SATURDAY", "SATURDAY"),

	/**
	 * The '<em><b>SUNDAY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SUNDAY_VALUE
	 * @generated
	 * @ordered
	 */
	SUNDAY(6, "SUNDAY", "SUNDAY"),

	/**
	 * The '<em><b>OTHER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OTHER_VALUE
	 * @generated
	 * @ordered
	 */
	OTHER(7, "OTHER", "OTHER");

	/**
	 * The '<em><b>EVERY DAY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EVERY_DAY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EVERY_DAY_VALUE = 0;

	/**
	 * The '<em><b>WEEKEND</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WEEKEND
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WEEKEND_VALUE = 1;

	/**
	 * The '<em><b>WORKING DAY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WORKING_DAY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WORKING_DAY_VALUE = 2;

	/**
	 * The '<em><b>SCHOOL YEAR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCHOOL_YEAR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCHOOL_YEAR_VALUE = 3;

	/**
	 * The '<em><b>PUBLIC HOLIDAY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PUBLIC_HOLIDAY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PUBLIC_HOLIDAY_VALUE = 4;

	/**
	 * The '<em><b>SATURDAY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SATURDAY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SATURDAY_VALUE = 5;

	/**
	 * The '<em><b>SUNDAY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SUNDAY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SUNDAY_VALUE = 6;

	/**
	 * The '<em><b>OTHER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OTHER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OTHER_VALUE = 7;

	/**
	 * An array of all the '<em><b>Schedule Frequency Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ScheduleFrequencyType[] VALUES_ARRAY =
		new ScheduleFrequencyType[] {
			EVERY_DAY,
			WEEKEND,
			WORKING_DAY,
			SCHOOL_YEAR,
			PUBLIC_HOLIDAY,
			SATURDAY,
			SUNDAY,
			OTHER,
		};

	/**
	 * A public read-only list of all the '<em><b>Schedule Frequency Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ScheduleFrequencyType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Schedule Frequency Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ScheduleFrequencyType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ScheduleFrequencyType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Schedule Frequency Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ScheduleFrequencyType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ScheduleFrequencyType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Schedule Frequency Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ScheduleFrequencyType get(int value) {
		switch (value) {
			case EVERY_DAY_VALUE: return EVERY_DAY;
			case WEEKEND_VALUE: return WEEKEND;
			case WORKING_DAY_VALUE: return WORKING_DAY;
			case SCHOOL_YEAR_VALUE: return SCHOOL_YEAR;
			case PUBLIC_HOLIDAY_VALUE: return PUBLIC_HOLIDAY;
			case SATURDAY_VALUE: return SATURDAY;
			case SUNDAY_VALUE: return SUNDAY;
			case OTHER_VALUE: return OTHER;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ScheduleFrequencyType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ScheduleFrequencyType
