/**
 */
package de.jena.udp.model.trafficos.common.impl;

import de.jena.udp.model.trafficos.common.*;

import java.time.LocalDate;
import java.time.LocalTime;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class TOSCommonFactoryImpl extends EFactoryImpl implements TOSCommonFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TOSCommonFactory init() {
		try {
			TOSCommonFactory theTOSCommonFactory = (TOSCommonFactory)EPackage.Registry.INSTANCE.getEFactory(TOSCommonPackage.eNS_URI);
			if (theTOSCommonFactory != null) {
				return theTOSCommonFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new TOSCommonFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TOSCommonFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case TOSCommonPackage.ID_ELEMENT: return createIdElement();
			case TOSCommonPackage.ID_NAME_ELEMENT: return createIdNameElement();
			case TOSCommonPackage.ABSTRACT_DATA_ENTRY: return createAbstractDataEntry();
			case TOSCommonPackage.ABSTRACT_TIMETABLE_ENTRY: return createAbstractTimetableEntry();
			case TOSCommonPackage.LOCALIZABLE: return createLocalizable();
			case TOSCommonPackage.LOCATION: return createLocation();
			case TOSCommonPackage.NETWORK_LOCATION: return createNetworkLocation();
			case TOSCommonPackage.POSITION: return createPosition();
			case TOSCommonPackage.ADDRESS_LOCATION: return createAddressLocation();
			case TOSCommonPackage.DATA_ENTRY: return createDataEntry();
			case TOSCommonPackage.DATA_VALUE: return createDataValue();
			case TOSCommonPackage.OUTPUT: return createOutput();
			case TOSCommonPackage.PARAMETER: return createParameter();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case TOSCommonPackage.PARAMETER_DATA_TYPE:
				return createParameterDataTypeFromString(eDataType, initialValue);
			case TOSCommonPackage.DIRECTION_TYPE:
				return createDirectionTypeFromString(eDataType, initialValue);
			case TOSCommonPackage.SCHEDULE_FREQUENCY_TYPE:
				return createScheduleFrequencyTypeFromString(eDataType, initialValue);
			case TOSCommonPackage.ELOCAL_TIME:
				return createELocalTimeFromString(eDataType, initialValue);
			case TOSCommonPackage.ELOCAL_DATE:
				return createELocalDateFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case TOSCommonPackage.PARAMETER_DATA_TYPE:
				return convertParameterDataTypeToString(eDataType, instanceValue);
			case TOSCommonPackage.DIRECTION_TYPE:
				return convertDirectionTypeToString(eDataType, instanceValue);
			case TOSCommonPackage.SCHEDULE_FREQUENCY_TYPE:
				return convertScheduleFrequencyTypeToString(eDataType, instanceValue);
			case TOSCommonPackage.ELOCAL_TIME:
				return convertELocalTimeToString(eDataType, instanceValue);
			case TOSCommonPackage.ELOCAL_DATE:
				return convertELocalDateToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public IdElement createIdElement() {
		IdElementImpl idElement = new IdElementImpl();
		return idElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public IdNameElement createIdNameElement() {
		IdNameElementImpl idNameElement = new IdNameElementImpl();
		return idNameElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AbstractDataEntry createAbstractDataEntry() {
		AbstractDataEntryImpl abstractDataEntry = new AbstractDataEntryImpl();
		return abstractDataEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AbstractTimetableEntry createAbstractTimetableEntry() {
		AbstractTimetableEntryImpl abstractTimetableEntry = new AbstractTimetableEntryImpl();
		return abstractTimetableEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Localizable createLocalizable() {
		LocalizableImpl localizable = new LocalizableImpl();
		return localizable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Location createLocation() {
		LocationImpl location = new LocationImpl();
		return location;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NetworkLocation createNetworkLocation() {
		NetworkLocationImpl networkLocation = new NetworkLocationImpl();
		return networkLocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Position createPosition() {
		PositionImpl position = new PositionImpl();
		return position;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AddressLocation createAddressLocation() {
		AddressLocationImpl addressLocation = new AddressLocationImpl();
		return addressLocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataEntry createDataEntry() {
		DataEntryImpl dataEntry = new DataEntryImpl();
		return dataEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataValue createDataValue() {
		DataValueImpl dataValue = new DataValueImpl();
		return dataValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Output createOutput() {
		OutputImpl output = new OutputImpl();
		return output;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Parameter createParameter() {
		ParameterImpl parameter = new ParameterImpl();
		return parameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParameterDataType createParameterDataTypeFromString(EDataType eDataType, String initialValue) {
		ParameterDataType result = ParameterDataType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertParameterDataTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DirectionType createDirectionTypeFromString(EDataType eDataType, String initialValue) {
		DirectionType result = DirectionType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDirectionTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ScheduleFrequencyType createScheduleFrequencyTypeFromString(EDataType eDataType, String initialValue) {
		ScheduleFrequencyType result = ScheduleFrequencyType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertScheduleFrequencyTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LocalTime createELocalTime(final String it) {
		return LocalTime.parse(it, java.time.format.DateTimeFormatter.ofPattern("HH:mm"));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LocalTime createELocalTimeFromString(EDataType eDataType, String initialValue) {
		return createELocalTime(initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertELocalTime(final LocalTime it) {
		return ((LocalTime) it).format(java.time.format.DateTimeFormatter.ofPattern("HH:mm"));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertELocalTimeToString(EDataType eDataType, Object instanceValue) {
		return convertELocalTime((LocalTime)instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LocalDate createELocalDate(final String it) {
		return LocalDate.parse(it, java.time.format.DateTimeFormatter.ofPattern("yyyyMMdd"));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LocalDate createELocalDateFromString(EDataType eDataType, String initialValue) {
		return createELocalDate(initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertELocalDate(final LocalDate it) {
		return ((LocalDate) it).format(java.time.format.DateTimeFormatter.ofPattern("yyyyMMdd"));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertELocalDateToString(EDataType eDataType, Object instanceValue) {
		return convertELocalDate((LocalDate)instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TOSCommonPackage getTOSCommonPackage() {
		return (TOSCommonPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static TOSCommonPackage getPackage() {
		return TOSCommonPackage.eINSTANCE;
	}

} //TOSCommonFactoryImpl
