/*
 */
package de.jena.udp.model.trafficos.intersection.impl;

import de.jena.udp.model.trafficos.common.Output;
import de.jena.udp.model.trafficos.common.Parameter;

import de.jena.udp.model.trafficos.intersection.Intersection;
import de.jena.udp.model.trafficos.intersection.IntersectionStateType;
import de.jena.udp.model.trafficos.intersection.Link;
import de.jena.udp.model.trafficos.intersection.Phase;
import de.jena.udp.model.trafficos.intersection.PhaseGroup;
import de.jena.udp.model.trafficos.intersection.Program;
import de.jena.udp.model.trafficos.intersection.Road;
import de.jena.udp.model.trafficos.intersection.TOSIntersectionPackage;
import de.jena.udp.model.trafficos.intersection.Timetable;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Intersection</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getId <em>Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getRoad <em>Road</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getLink <em>Link</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getPhase <em>Phase</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getPhaseGroup <em>Phase Group</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getTimeTable <em>Time Table</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getOutput <em>Output</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getProgram <em>Program</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getParameter <em>Parameter</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getState <em>State</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getName <em>Name</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.intersection.impl.IntersectionImpl#getDescription <em>Description</em>}</li>
 * </ul>
 *
 * @generated
 */
public class IntersectionImpl extends MinimalEObjectImpl.Container implements Intersection {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRoad() <em>Road</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRoad()
	 * @generated
	 * @ordered
	 */
	protected EList<Road> road;

	/**
	 * The cached value of the '{@link #getLink() <em>Link</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLink()
	 * @generated
	 * @ordered
	 */
	protected EList<Link> link;

	/**
	 * The cached value of the '{@link #getPhase() <em>Phase</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPhase()
	 * @generated
	 * @ordered
	 */
	protected EList<Phase> phase;

	/**
	 * The cached value of the '{@link #getPhaseGroup() <em>Phase Group</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPhaseGroup()
	 * @generated
	 * @ordered
	 */
	protected EList<PhaseGroup> phaseGroup;

	/**
	 * The cached value of the '{@link #getTimeTable() <em>Time Table</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeTable()
	 * @generated
	 * @ordered
	 */
	protected Timetable timeTable;

	/**
	 * The cached value of the '{@link #getOutput() <em>Output</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutput()
	 * @generated
	 * @ordered
	 */
	protected EList<Output> output;

	/**
	 * The cached value of the '{@link #getProgram() <em>Program</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProgram()
	 * @generated
	 * @ordered
	 */
	protected EList<Program> program;

	/**
	 * The cached value of the '{@link #getParameter() <em>Parameter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameter()
	 * @generated
	 * @ordered
	 */
	protected EList<Parameter> parameter;

	/**
	 * The default value of the '{@link #getState() <em>State</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getState()
	 * @generated
	 * @ordered
	 */
	protected static final IntersectionStateType STATE_EDEFAULT = IntersectionStateType.UNKNOWN;

	/**
	 * The cached value of the '{@link #getState() <em>State</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getState()
	 * @generated
	 * @ordered
	 */
	protected IntersectionStateType state = STATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntersectionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TOSIntersectionPackage.eINSTANCE.getIntersection();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSIntersectionPackage.INTERSECTION__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Road> getRoad() {
		if (road == null) {
			road = new EObjectContainmentEList<Road>(Road.class, this, TOSIntersectionPackage.INTERSECTION__ROAD);
		}
		return road;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Link> getLink() {
		if (link == null) {
			link = new EObjectContainmentEList<Link>(Link.class, this, TOSIntersectionPackage.INTERSECTION__LINK);
		}
		return link;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Phase> getPhase() {
		if (phase == null) {
			phase = new EObjectContainmentEList<Phase>(Phase.class, this, TOSIntersectionPackage.INTERSECTION__PHASE);
		}
		return phase;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PhaseGroup> getPhaseGroup() {
		if (phaseGroup == null) {
			phaseGroup = new EObjectContainmentEList<PhaseGroup>(PhaseGroup.class, this, TOSIntersectionPackage.INTERSECTION__PHASE_GROUP);
		}
		return phaseGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Timetable getTimeTable() {
		return timeTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTimeTable(Timetable newTimeTable, NotificationChain msgs) {
		Timetable oldTimeTable = timeTable;
		timeTable = newTimeTable;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TOSIntersectionPackage.INTERSECTION__TIME_TABLE, oldTimeTable, newTimeTable);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTimeTable(Timetable newTimeTable) {
		if (newTimeTable != timeTable) {
			NotificationChain msgs = null;
			if (timeTable != null)
				msgs = ((InternalEObject)timeTable).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TOSIntersectionPackage.INTERSECTION__TIME_TABLE, null, msgs);
			if (newTimeTable != null)
				msgs = ((InternalEObject)newTimeTable).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TOSIntersectionPackage.INTERSECTION__TIME_TABLE, null, msgs);
			msgs = basicSetTimeTable(newTimeTable, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSIntersectionPackage.INTERSECTION__TIME_TABLE, newTimeTable, newTimeTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Output> getOutput() {
		if (output == null) {
			output = new EObjectContainmentEList<Output>(Output.class, this, TOSIntersectionPackage.INTERSECTION__OUTPUT);
		}
		return output;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Program> getProgram() {
		if (program == null) {
			program = new EObjectContainmentEList<Program>(Program.class, this, TOSIntersectionPackage.INTERSECTION__PROGRAM);
		}
		return program;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Parameter> getParameter() {
		if (parameter == null) {
			parameter = new EObjectContainmentEList<Parameter>(Parameter.class, this, TOSIntersectionPackage.INTERSECTION__PARAMETER);
		}
		return parameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public IntersectionStateType getState() {
		return state;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setState(IntersectionStateType newState) {
		IntersectionStateType oldState = state;
		state = newState == null ? STATE_EDEFAULT : newState;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSIntersectionPackage.INTERSECTION__STATE, oldState, state));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSIntersectionPackage.INTERSECTION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSIntersectionPackage.INTERSECTION__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TOSIntersectionPackage.INTERSECTION__ROAD:
				return ((InternalEList<?>)getRoad()).basicRemove(otherEnd, msgs);
			case TOSIntersectionPackage.INTERSECTION__LINK:
				return ((InternalEList<?>)getLink()).basicRemove(otherEnd, msgs);
			case TOSIntersectionPackage.INTERSECTION__PHASE:
				return ((InternalEList<?>)getPhase()).basicRemove(otherEnd, msgs);
			case TOSIntersectionPackage.INTERSECTION__PHASE_GROUP:
				return ((InternalEList<?>)getPhaseGroup()).basicRemove(otherEnd, msgs);
			case TOSIntersectionPackage.INTERSECTION__TIME_TABLE:
				return basicSetTimeTable(null, msgs);
			case TOSIntersectionPackage.INTERSECTION__OUTPUT:
				return ((InternalEList<?>)getOutput()).basicRemove(otherEnd, msgs);
			case TOSIntersectionPackage.INTERSECTION__PROGRAM:
				return ((InternalEList<?>)getProgram()).basicRemove(otherEnd, msgs);
			case TOSIntersectionPackage.INTERSECTION__PARAMETER:
				return ((InternalEList<?>)getParameter()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TOSIntersectionPackage.INTERSECTION__ID:
				return getId();
			case TOSIntersectionPackage.INTERSECTION__ROAD:
				return getRoad();
			case TOSIntersectionPackage.INTERSECTION__LINK:
				return getLink();
			case TOSIntersectionPackage.INTERSECTION__PHASE:
				return getPhase();
			case TOSIntersectionPackage.INTERSECTION__PHASE_GROUP:
				return getPhaseGroup();
			case TOSIntersectionPackage.INTERSECTION__TIME_TABLE:
				return getTimeTable();
			case TOSIntersectionPackage.INTERSECTION__OUTPUT:
				return getOutput();
			case TOSIntersectionPackage.INTERSECTION__PROGRAM:
				return getProgram();
			case TOSIntersectionPackage.INTERSECTION__PARAMETER:
				return getParameter();
			case TOSIntersectionPackage.INTERSECTION__STATE:
				return getState();
			case TOSIntersectionPackage.INTERSECTION__NAME:
				return getName();
			case TOSIntersectionPackage.INTERSECTION__DESCRIPTION:
				return getDescription();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TOSIntersectionPackage.INTERSECTION__ID:
				setId((String)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__ROAD:
				getRoad().clear();
				getRoad().addAll((Collection<? extends Road>)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__LINK:
				getLink().clear();
				getLink().addAll((Collection<? extends Link>)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__PHASE:
				getPhase().clear();
				getPhase().addAll((Collection<? extends Phase>)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__PHASE_GROUP:
				getPhaseGroup().clear();
				getPhaseGroup().addAll((Collection<? extends PhaseGroup>)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__TIME_TABLE:
				setTimeTable((Timetable)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__OUTPUT:
				getOutput().clear();
				getOutput().addAll((Collection<? extends Output>)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__PROGRAM:
				getProgram().clear();
				getProgram().addAll((Collection<? extends Program>)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__PARAMETER:
				getParameter().clear();
				getParameter().addAll((Collection<? extends Parameter>)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__STATE:
				setState((IntersectionStateType)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__NAME:
				setName((String)newValue);
				return;
			case TOSIntersectionPackage.INTERSECTION__DESCRIPTION:
				setDescription((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TOSIntersectionPackage.INTERSECTION__ID:
				setId(ID_EDEFAULT);
				return;
			case TOSIntersectionPackage.INTERSECTION__ROAD:
				getRoad().clear();
				return;
			case TOSIntersectionPackage.INTERSECTION__LINK:
				getLink().clear();
				return;
			case TOSIntersectionPackage.INTERSECTION__PHASE:
				getPhase().clear();
				return;
			case TOSIntersectionPackage.INTERSECTION__PHASE_GROUP:
				getPhaseGroup().clear();
				return;
			case TOSIntersectionPackage.INTERSECTION__TIME_TABLE:
				setTimeTable((Timetable)null);
				return;
			case TOSIntersectionPackage.INTERSECTION__OUTPUT:
				getOutput().clear();
				return;
			case TOSIntersectionPackage.INTERSECTION__PROGRAM:
				getProgram().clear();
				return;
			case TOSIntersectionPackage.INTERSECTION__PARAMETER:
				getParameter().clear();
				return;
			case TOSIntersectionPackage.INTERSECTION__STATE:
				setState(STATE_EDEFAULT);
				return;
			case TOSIntersectionPackage.INTERSECTION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TOSIntersectionPackage.INTERSECTION__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TOSIntersectionPackage.INTERSECTION__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case TOSIntersectionPackage.INTERSECTION__ROAD:
				return road != null && !road.isEmpty();
			case TOSIntersectionPackage.INTERSECTION__LINK:
				return link != null && !link.isEmpty();
			case TOSIntersectionPackage.INTERSECTION__PHASE:
				return phase != null && !phase.isEmpty();
			case TOSIntersectionPackage.INTERSECTION__PHASE_GROUP:
				return phaseGroup != null && !phaseGroup.isEmpty();
			case TOSIntersectionPackage.INTERSECTION__TIME_TABLE:
				return timeTable != null;
			case TOSIntersectionPackage.INTERSECTION__OUTPUT:
				return output != null && !output.isEmpty();
			case TOSIntersectionPackage.INTERSECTION__PROGRAM:
				return program != null && !program.isEmpty();
			case TOSIntersectionPackage.INTERSECTION__PARAMETER:
				return parameter != null && !parameter.isEmpty();
			case TOSIntersectionPackage.INTERSECTION__STATE:
				return state != STATE_EDEFAULT;
			case TOSIntersectionPackage.INTERSECTION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TOSIntersectionPackage.INTERSECTION__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", state: ");
		result.append(state);
		result.append(", name: ");
		result.append(name);
		result.append(", description: ");
		result.append(description);
		result.append(')');
		return result.toString();
	}

} //IntersectionImpl
