/*
 */
package de.jena.udp.model.trafficos.publictransport_api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Pick Up Drop Off Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getPickUpDropOffType()
 * @model
 * @generated
 */
@ProviderType
public enum PickUpDropOffType implements Enumerator {
	/**
	 * The '<em><b>REGULARLY SCHEDULED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REGULARLY_SCHEDULED_VALUE
	 * @generated
	 * @ordered
	 */
	REGULARLY_SCHEDULED(0, "REGULARLY_SCHEDULED", "REGULARLY_SCHEDULED"),

	/**
	 * The '<em><b>NOT AVAILABLE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOT_AVAILABLE_VALUE
	 * @generated
	 * @ordered
	 */
	NOT_AVAILABLE(1, "NOT_AVAILABLE", "NOT_AVAILABLE"),

	/**
	 * The '<em><b>PHONE TO ARRANGE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PHONE_TO_ARRANGE_VALUE
	 * @generated
	 * @ordered
	 */
	PHONE_TO_ARRANGE(2, "PHONE_TO_ARRANGE", "PHONE_TO_ARRANGE"),

	/**
	 * The '<em><b>COORDINATE WITH DRIVER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COORDINATE_WITH_DRIVER_VALUE
	 * @generated
	 * @ordered
	 */
	COORDINATE_WITH_DRIVER(3, "COORDINATE_WITH_DRIVER", "COORDINATE_WITH_DRIVER");

	/**
	 * The '<em><b>REGULARLY SCHEDULED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REGULARLY_SCHEDULED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int REGULARLY_SCHEDULED_VALUE = 0;

	/**
	 * The '<em><b>NOT AVAILABLE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOT_AVAILABLE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NOT_AVAILABLE_VALUE = 1;

	/**
	 * The '<em><b>PHONE TO ARRANGE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PHONE_TO_ARRANGE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PHONE_TO_ARRANGE_VALUE = 2;

	/**
	 * The '<em><b>COORDINATE WITH DRIVER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COORDINATE_WITH_DRIVER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COORDINATE_WITH_DRIVER_VALUE = 3;

	/**
	 * An array of all the '<em><b>Pick Up Drop Off Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final PickUpDropOffType[] VALUES_ARRAY =
		new PickUpDropOffType[] {
			REGULARLY_SCHEDULED,
			NOT_AVAILABLE,
			PHONE_TO_ARRANGE,
			COORDINATE_WITH_DRIVER,
		};

	/**
	 * A public read-only list of all the '<em><b>Pick Up Drop Off Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<PickUpDropOffType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Pick Up Drop Off Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static PickUpDropOffType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			PickUpDropOffType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Pick Up Drop Off Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static PickUpDropOffType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			PickUpDropOffType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Pick Up Drop Off Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static PickUpDropOffType get(int value) {
		switch (value) {
			case REGULARLY_SCHEDULED_VALUE: return REGULARLY_SCHEDULED;
			case NOT_AVAILABLE_VALUE: return NOT_AVAILABLE;
			case PHONE_TO_ARRANGE_VALUE: return PHONE_TO_ARRANGE;
			case COORDINATE_WITH_DRIVER_VALUE: return COORDINATE_WITH_DRIVER;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private PickUpDropOffType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //PickUpDropOffType
