/*
 */
package de.jena.udp.model.trafficos.publictransport_api;

import java.time.LocalDate;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Schedule</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getScheduleId <em>Schedule Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getRefRouteId <em>Ref Route Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getRefRouteNumber <em>Ref Route Number</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getRouteDirection <em>Route Direction</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getScheduleEntry <em>Schedule Entry</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getStartDate <em>Start Date</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getEndDate <em>End Date</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getIncludedDate <em>Included Date</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getExcludedDate <em>Excluded Date</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getFrequencyDays <em>Frequency Days</em>}</li>
 * </ul>
 *
 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule()
 * @model
 * @generated
 */
@ProviderType
public interface Schedule extends EObject {
	/**
	 * Returns the value of the '<em><b>Schedule Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Schedule Id</em>' attribute.
	 * @see #setScheduleId(String)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_ScheduleId()
	 * @model required="true"
	 * @generated
	 */
	String getScheduleId();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getScheduleId <em>Schedule Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Schedule Id</em>' attribute.
	 * @see #getScheduleId()
	 * @generated
	 */
	void setScheduleId(String value);

	/**
	 * Returns the value of the '<em><b>Ref Route Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ref Route Id</em>' attribute.
	 * @see #setRefRouteId(String)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_RefRouteId()
	 * @model
	 * @generated
	 */
	String getRefRouteId();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getRefRouteId <em>Ref Route Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ref Route Id</em>' attribute.
	 * @see #getRefRouteId()
	 * @generated
	 */
	void setRefRouteId(String value);

	/**
	 * Returns the value of the '<em><b>Ref Route Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ref Route Number</em>' attribute.
	 * @see #setRefRouteNumber(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_RefRouteNumber()
	 * @model
	 * @generated
	 */
	int getRefRouteNumber();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getRefRouteNumber <em>Ref Route Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ref Route Number</em>' attribute.
	 * @see #getRefRouteNumber()
	 * @generated
	 */
	void setRefRouteNumber(int value);

	/**
	 * Returns the value of the '<em><b>Route Direction</b></em>' attribute.
	 * The literals are from the enumeration {@link de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Route Direction</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType
	 * @see #setRouteDirection(RouteDirectionType)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_RouteDirection()
	 * @model
	 * @generated
	 */
	RouteDirectionType getRouteDirection();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getRouteDirection <em>Route Direction</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Route Direction</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType
	 * @see #getRouteDirection()
	 * @generated
	 */
	void setRouteDirection(RouteDirectionType value);

	/**
	 * Returns the value of the '<em><b>Schedule Entry</b></em>' containment reference list.
	 * The list contents are of type {@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Schedule Entry</em>' containment reference list.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_ScheduleEntry()
	 * @model containment="true"
	 * @generated
	 */
	EList<ScheduleEntry> getScheduleEntry();

	/**
	 * Returns the value of the '<em><b>Start Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Start Date</em>' attribute.
	 * @see #setStartDate(LocalDate)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_StartDate()
	 * @model dataType="de.jena.udp.model.trafficos.common.ELocalDate"
	 * @generated
	 */
	LocalDate getStartDate();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getStartDate <em>Start Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Date</em>' attribute.
	 * @see #getStartDate()
	 * @generated
	 */
	void setStartDate(LocalDate value);

	/**
	 * Returns the value of the '<em><b>End Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>End Date</em>' attribute.
	 * @see #setEndDate(LocalDate)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_EndDate()
	 * @model dataType="de.jena.udp.model.trafficos.common.ELocalDate"
	 * @generated
	 */
	LocalDate getEndDate();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getEndDate <em>End Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>End Date</em>' attribute.
	 * @see #getEndDate()
	 * @generated
	 */
	void setEndDate(LocalDate value);

	/**
	 * Returns the value of the '<em><b>Included Date</b></em>' attribute list.
	 * The list contents are of type {@link java.time.LocalDate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Included Date</em>' attribute list.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_IncludedDate()
	 * @model dataType="de.jena.udp.model.trafficos.common.ELocalDate"
	 * @generated
	 */
	EList<LocalDate> getIncludedDate();

	/**
	 * Returns the value of the '<em><b>Excluded Date</b></em>' attribute list.
	 * The list contents are of type {@link java.time.LocalDate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Excluded Date</em>' attribute list.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_ExcludedDate()
	 * @model dataType="de.jena.udp.model.trafficos.common.ELocalDate"
	 * @generated
	 */
	EList<LocalDate> getExcludedDate();

	/**
	 * Returns the value of the '<em><b>Frequency Days</b></em>' attribute list.
	 * The list contents are of type {@link de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType}.
	 * The literals are from the enumeration {@link de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Frequency Days</em>' attribute list.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getSchedule_FrequencyDays()
	 * @model
	 * @generated
	 */
	EList<ScheduleFrequencyDayType> getFrequencyDays();

} // Schedule
