/*
 */
package de.jena.udp.model.trafficos.publictransport_api;

import java.time.LocalTime;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Schedule Entry</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefScheduleId <em>Ref Schedule Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getEntryIndex <em>Entry Index</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getArrivalScheduled <em>Arrival Scheduled</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDepartureScheduled <em>Departure Scheduled</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getArrivalDayAfterScheduleStart <em>Arrival Day After Schedule Start</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDepartureDayAfterScheduleStart <em>Departure Day After Schedule Start</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDwellTime <em>Dwell Time</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getEntryType <em>Entry Type</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getPickUpType <em>Pick Up Type</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDropOffType <em>Drop Off Type</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefStop <em>Ref Stop</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefStopId <em>Ref Stop Id</em>}</li>
 * </ul>
 *
 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry()
 * @model
 * @generated
 */
@ProviderType
public interface ScheduleEntry extends EObject {
	/**
	 * Returns the value of the '<em><b>Ref Schedule Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ref Schedule Id</em>' attribute.
	 * @see #setRefScheduleId(String)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_RefScheduleId()
	 * @model
	 * @generated
	 */
	String getRefScheduleId();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefScheduleId <em>Ref Schedule Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ref Schedule Id</em>' attribute.
	 * @see #getRefScheduleId()
	 * @generated
	 */
	void setRefScheduleId(String value);

	/**
	 * Returns the value of the '<em><b>Entry Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Entry Index</em>' attribute.
	 * @see #setEntryIndex(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_EntryIndex()
	 * @model
	 * @generated
	 */
	int getEntryIndex();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getEntryIndex <em>Entry Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Entry Index</em>' attribute.
	 * @see #getEntryIndex()
	 * @generated
	 */
	void setEntryIndex(int value);

	/**
	 * Returns the value of the '<em><b>Arrival Scheduled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Arrival Scheduled</em>' attribute.
	 * @see #setArrivalScheduled(LocalTime)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_ArrivalScheduled()
	 * @model dataType="de.jena.udp.model.trafficos.common.ELocalTime"
	 * @generated
	 */
	LocalTime getArrivalScheduled();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getArrivalScheduled <em>Arrival Scheduled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Arrival Scheduled</em>' attribute.
	 * @see #getArrivalScheduled()
	 * @generated
	 */
	void setArrivalScheduled(LocalTime value);

	/**
	 * Returns the value of the '<em><b>Departure Scheduled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Departure Scheduled</em>' attribute.
	 * @see #setDepartureScheduled(LocalTime)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_DepartureScheduled()
	 * @model dataType="de.jena.udp.model.trafficos.common.ELocalTime"
	 * @generated
	 */
	LocalTime getDepartureScheduled();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDepartureScheduled <em>Departure Scheduled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Departure Scheduled</em>' attribute.
	 * @see #getDepartureScheduled()
	 * @generated
	 */
	void setDepartureScheduled(LocalTime value);

	/**
	 * Returns the value of the '<em><b>Arrival Day After Schedule Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Some time table entries can reference to times which are a day (or two) after the trip is started. So this attribute will take that into account.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Arrival Day After Schedule Start</em>' attribute.
	 * @see #setArrivalDayAfterScheduleStart(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_ArrivalDayAfterScheduleStart()
	 * @model
	 * @generated
	 */
	int getArrivalDayAfterScheduleStart();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getArrivalDayAfterScheduleStart <em>Arrival Day After Schedule Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Arrival Day After Schedule Start</em>' attribute.
	 * @see #getArrivalDayAfterScheduleStart()
	 * @generated
	 */
	void setArrivalDayAfterScheduleStart(int value);

	/**
	 * Returns the value of the '<em><b>Departure Day After Schedule Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Some time table entries can reference to times which are a day (or two) after the trip is started. So this attribute will take that into account.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Departure Day After Schedule Start</em>' attribute.
	 * @see #setDepartureDayAfterScheduleStart(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_DepartureDayAfterScheduleStart()
	 * @model
	 * @generated
	 */
	int getDepartureDayAfterScheduleStart();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDepartureDayAfterScheduleStart <em>Departure Day After Schedule Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Departure Day After Schedule Start</em>' attribute.
	 * @see #getDepartureDayAfterScheduleStart()
	 * @generated
	 */
	void setDepartureDayAfterScheduleStart(int value);

	/**
	 * Returns the value of the '<em><b>Dwell Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Dwell Time</em>' attribute.
	 * @see #setDwellTime(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_DwellTime()
	 * @model
	 * @generated
	 */
	int getDwellTime();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDwellTime <em>Dwell Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Dwell Time</em>' attribute.
	 * @see #getDwellTime()
	 * @generated
	 */
	void setDwellTime(int value);

	/**
	 * Returns the value of the '<em><b>Entry Type</b></em>' attribute.
	 * The literals are from the enumeration {@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Entry Type</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType
	 * @see #setEntryType(ScheduleEntryType)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_EntryType()
	 * @model
	 * @generated
	 */
	ScheduleEntryType getEntryType();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getEntryType <em>Entry Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Entry Type</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType
	 * @see #getEntryType()
	 * @generated
	 */
	void setEntryType(ScheduleEntryType value);

	/**
	 * Returns the value of the '<em><b>Pick Up Type</b></em>' attribute.
	 * The literals are from the enumeration {@link de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pick Up Type</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType
	 * @see #setPickUpType(PickUpDropOffType)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_PickUpType()
	 * @model
	 * @generated
	 */
	PickUpDropOffType getPickUpType();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getPickUpType <em>Pick Up Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pick Up Type</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType
	 * @see #getPickUpType()
	 * @generated
	 */
	void setPickUpType(PickUpDropOffType value);

	/**
	 * Returns the value of the '<em><b>Drop Off Type</b></em>' attribute.
	 * The literals are from the enumeration {@link de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Drop Off Type</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType
	 * @see #setDropOffType(PickUpDropOffType)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_DropOffType()
	 * @model
	 * @generated
	 */
	PickUpDropOffType getDropOffType();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDropOffType <em>Drop Off Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Drop Off Type</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType
	 * @see #getDropOffType()
	 * @generated
	 */
	void setDropOffType(PickUpDropOffType value);

	/**
	 * Returns the value of the '<em><b>Ref Stop</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ref Stop</em>' containment reference.
	 * @see #setRefStop(StopInformation)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_RefStop()
	 * @model containment="true"
	 * @generated
	 */
	StopInformation getRefStop();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefStop <em>Ref Stop</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ref Stop</em>' containment reference.
	 * @see #getRefStop()
	 * @generated
	 */
	void setRefStop(StopInformation value);

	/**
	 * Returns the value of the '<em><b>Ref Stop Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ref Stop Id</em>' attribute.
	 * @see #setRefStopId(String)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getScheduleEntry_RefStopId()
	 * @model
	 * @generated
	 */
	String getRefStopId();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefStopId <em>Ref Stop Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ref Stop Id</em>' attribute.
	 * @see #getRefStopId()
	 * @generated
	 */
	void setRefStopId(String value);

} // ScheduleEntry
