/*
 */
package de.jena.udp.model.trafficos.publictransport_api.impl;

import de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType;
import de.jena.udp.model.trafficos.publictransport_api.Schedule;
import de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry;
import de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType;
import de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage;

import java.time.LocalDate;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Schedule</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getScheduleId <em>Schedule Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getRefRouteId <em>Ref Route Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getRefRouteNumber <em>Ref Route Number</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getRouteDirection <em>Route Direction</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getScheduleEntry <em>Schedule Entry</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getStartDate <em>Start Date</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getEndDate <em>End Date</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getIncludedDate <em>Included Date</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getExcludedDate <em>Excluded Date</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl#getFrequencyDays <em>Frequency Days</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ScheduleImpl extends MinimalEObjectImpl.Container implements Schedule {
	/**
	 * The default value of the '{@link #getScheduleId() <em>Schedule Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScheduleId()
	 * @generated
	 * @ordered
	 */
	protected static final String SCHEDULE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getScheduleId() <em>Schedule Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScheduleId()
	 * @generated
	 * @ordered
	 */
	protected String scheduleId = SCHEDULE_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getRefRouteId() <em>Ref Route Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefRouteId()
	 * @generated
	 * @ordered
	 */
	protected static final String REF_ROUTE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRefRouteId() <em>Ref Route Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefRouteId()
	 * @generated
	 * @ordered
	 */
	protected String refRouteId = REF_ROUTE_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getRefRouteNumber() <em>Ref Route Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefRouteNumber()
	 * @generated
	 * @ordered
	 */
	protected static final int REF_ROUTE_NUMBER_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRefRouteNumber() <em>Ref Route Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefRouteNumber()
	 * @generated
	 * @ordered
	 */
	protected int refRouteNumber = REF_ROUTE_NUMBER_EDEFAULT;

	/**
	 * The default value of the '{@link #getRouteDirection() <em>Route Direction</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRouteDirection()
	 * @generated
	 * @ordered
	 */
	protected static final RouteDirectionType ROUTE_DIRECTION_EDEFAULT = RouteDirectionType.FORWARD;

	/**
	 * The cached value of the '{@link #getRouteDirection() <em>Route Direction</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRouteDirection()
	 * @generated
	 * @ordered
	 */
	protected RouteDirectionType routeDirection = ROUTE_DIRECTION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getScheduleEntry() <em>Schedule Entry</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScheduleEntry()
	 * @generated
	 * @ordered
	 */
	protected EList<ScheduleEntry> scheduleEntry;

	/**
	 * The default value of the '{@link #getStartDate() <em>Start Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartDate()
	 * @generated
	 * @ordered
	 */
	protected static final LocalDate START_DATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStartDate() <em>Start Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartDate()
	 * @generated
	 * @ordered
	 */
	protected LocalDate startDate = START_DATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getEndDate() <em>End Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndDate()
	 * @generated
	 * @ordered
	 */
	protected static final LocalDate END_DATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEndDate() <em>End Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndDate()
	 * @generated
	 * @ordered
	 */
	protected LocalDate endDate = END_DATE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getIncludedDate() <em>Included Date</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIncludedDate()
	 * @generated
	 * @ordered
	 */
	protected EList<LocalDate> includedDate;

	/**
	 * The cached value of the '{@link #getExcludedDate() <em>Excluded Date</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExcludedDate()
	 * @generated
	 * @ordered
	 */
	protected EList<LocalDate> excludedDate;

	/**
	 * The cached value of the '{@link #getFrequencyDays() <em>Frequency Days</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFrequencyDays()
	 * @generated
	 * @ordered
	 */
	protected EList<ScheduleFrequencyDayType> frequencyDays;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ScheduleImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TOSPublicTransportApiPackage.Literals.SCHEDULE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getScheduleId() {
		return scheduleId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setScheduleId(String newScheduleId) {
		String oldScheduleId = scheduleId;
		scheduleId = newScheduleId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ID, oldScheduleId, scheduleId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRefRouteId() {
		return refRouteId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRefRouteId(String newRefRouteId) {
		String oldRefRouteId = refRouteId;
		refRouteId = newRefRouteId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_ID, oldRefRouteId, refRouteId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getRefRouteNumber() {
		return refRouteNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRefRouteNumber(int newRefRouteNumber) {
		int oldRefRouteNumber = refRouteNumber;
		refRouteNumber = newRefRouteNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_NUMBER, oldRefRouteNumber, refRouteNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RouteDirectionType getRouteDirection() {
		return routeDirection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRouteDirection(RouteDirectionType newRouteDirection) {
		RouteDirectionType oldRouteDirection = routeDirection;
		routeDirection = newRouteDirection == null ? ROUTE_DIRECTION_EDEFAULT : newRouteDirection;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE__ROUTE_DIRECTION, oldRouteDirection, routeDirection));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ScheduleEntry> getScheduleEntry() {
		if (scheduleEntry == null) {
			scheduleEntry = new EObjectContainmentEList<ScheduleEntry>(ScheduleEntry.class, this, TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ENTRY);
		}
		return scheduleEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LocalDate getStartDate() {
		return startDate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStartDate(LocalDate newStartDate) {
		LocalDate oldStartDate = startDate;
		startDate = newStartDate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE__START_DATE, oldStartDate, startDate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LocalDate getEndDate() {
		return endDate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEndDate(LocalDate newEndDate) {
		LocalDate oldEndDate = endDate;
		endDate = newEndDate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE__END_DATE, oldEndDate, endDate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<LocalDate> getIncludedDate() {
		if (includedDate == null) {
			includedDate = new EDataTypeUniqueEList<LocalDate>(LocalDate.class, this, TOSPublicTransportApiPackage.SCHEDULE__INCLUDED_DATE);
		}
		return includedDate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<LocalDate> getExcludedDate() {
		if (excludedDate == null) {
			excludedDate = new EDataTypeUniqueEList<LocalDate>(LocalDate.class, this, TOSPublicTransportApiPackage.SCHEDULE__EXCLUDED_DATE);
		}
		return excludedDate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ScheduleFrequencyDayType> getFrequencyDays() {
		if (frequencyDays == null) {
			frequencyDays = new EDataTypeUniqueEList<ScheduleFrequencyDayType>(ScheduleFrequencyDayType.class, this, TOSPublicTransportApiPackage.SCHEDULE__FREQUENCY_DAYS);
		}
		return frequencyDays;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ENTRY:
				return ((InternalEList<?>)getScheduleEntry()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ID:
				return getScheduleId();
			case TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_ID:
				return getRefRouteId();
			case TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_NUMBER:
				return getRefRouteNumber();
			case TOSPublicTransportApiPackage.SCHEDULE__ROUTE_DIRECTION:
				return getRouteDirection();
			case TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ENTRY:
				return getScheduleEntry();
			case TOSPublicTransportApiPackage.SCHEDULE__START_DATE:
				return getStartDate();
			case TOSPublicTransportApiPackage.SCHEDULE__END_DATE:
				return getEndDate();
			case TOSPublicTransportApiPackage.SCHEDULE__INCLUDED_DATE:
				return getIncludedDate();
			case TOSPublicTransportApiPackage.SCHEDULE__EXCLUDED_DATE:
				return getExcludedDate();
			case TOSPublicTransportApiPackage.SCHEDULE__FREQUENCY_DAYS:
				return getFrequencyDays();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ID:
				setScheduleId((String)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_ID:
				setRefRouteId((String)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_NUMBER:
				setRefRouteNumber((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__ROUTE_DIRECTION:
				setRouteDirection((RouteDirectionType)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ENTRY:
				getScheduleEntry().clear();
				getScheduleEntry().addAll((Collection<? extends ScheduleEntry>)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__START_DATE:
				setStartDate((LocalDate)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__END_DATE:
				setEndDate((LocalDate)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__INCLUDED_DATE:
				getIncludedDate().clear();
				getIncludedDate().addAll((Collection<? extends LocalDate>)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__EXCLUDED_DATE:
				getExcludedDate().clear();
				getExcludedDate().addAll((Collection<? extends LocalDate>)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__FREQUENCY_DAYS:
				getFrequencyDays().clear();
				getFrequencyDays().addAll((Collection<? extends ScheduleFrequencyDayType>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ID:
				setScheduleId(SCHEDULE_ID_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_ID:
				setRefRouteId(REF_ROUTE_ID_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_NUMBER:
				setRefRouteNumber(REF_ROUTE_NUMBER_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__ROUTE_DIRECTION:
				setRouteDirection(ROUTE_DIRECTION_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ENTRY:
				getScheduleEntry().clear();
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__START_DATE:
				setStartDate(START_DATE_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__END_DATE:
				setEndDate(END_DATE_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__INCLUDED_DATE:
				getIncludedDate().clear();
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__EXCLUDED_DATE:
				getExcludedDate().clear();
				return;
			case TOSPublicTransportApiPackage.SCHEDULE__FREQUENCY_DAYS:
				getFrequencyDays().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ID:
				return SCHEDULE_ID_EDEFAULT == null ? scheduleId != null : !SCHEDULE_ID_EDEFAULT.equals(scheduleId);
			case TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_ID:
				return REF_ROUTE_ID_EDEFAULT == null ? refRouteId != null : !REF_ROUTE_ID_EDEFAULT.equals(refRouteId);
			case TOSPublicTransportApiPackage.SCHEDULE__REF_ROUTE_NUMBER:
				return refRouteNumber != REF_ROUTE_NUMBER_EDEFAULT;
			case TOSPublicTransportApiPackage.SCHEDULE__ROUTE_DIRECTION:
				return routeDirection != ROUTE_DIRECTION_EDEFAULT;
			case TOSPublicTransportApiPackage.SCHEDULE__SCHEDULE_ENTRY:
				return scheduleEntry != null && !scheduleEntry.isEmpty();
			case TOSPublicTransportApiPackage.SCHEDULE__START_DATE:
				return START_DATE_EDEFAULT == null ? startDate != null : !START_DATE_EDEFAULT.equals(startDate);
			case TOSPublicTransportApiPackage.SCHEDULE__END_DATE:
				return END_DATE_EDEFAULT == null ? endDate != null : !END_DATE_EDEFAULT.equals(endDate);
			case TOSPublicTransportApiPackage.SCHEDULE__INCLUDED_DATE:
				return includedDate != null && !includedDate.isEmpty();
			case TOSPublicTransportApiPackage.SCHEDULE__EXCLUDED_DATE:
				return excludedDate != null && !excludedDate.isEmpty();
			case TOSPublicTransportApiPackage.SCHEDULE__FREQUENCY_DAYS:
				return frequencyDays != null && !frequencyDays.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (scheduleId: ");
		result.append(scheduleId);
		result.append(", refRouteId: ");
		result.append(refRouteId);
		result.append(", refRouteNumber: ");
		result.append(refRouteNumber);
		result.append(", routeDirection: ");
		result.append(routeDirection);
		result.append(", startDate: ");
		result.append(startDate);
		result.append(", endDate: ");
		result.append(endDate);
		result.append(", includedDate: ");
		result.append(includedDate);
		result.append(", excludedDate: ");
		result.append(excludedDate);
		result.append(", frequencyDays: ");
		result.append(frequencyDays);
		result.append(')');
		return result.toString();
	}

} //ScheduleImpl
