/*
 */
package de.jena.udp.model.trafficos.publictransport_api.impl;

import de.jena.udp.model.trafficos.publictransport_api.StopUpdate;
import de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage;

import java.time.LocalTime;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Stop Update</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl#getRefStopId <em>Ref Stop Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl#getRefScheduleEntryIndex <em>Ref Schedule Entry Index</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl#getArrivalExpected <em>Arrival Expected</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl#getDepartureExpected <em>Departure Expected</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl#getRecordedArrivalTime <em>Recorded Arrival Time</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl#getDistanceFromNextStop <em>Distance From Next Stop</em>}</li>
 * </ul>
 *
 * @generated
 */
public class StopUpdateImpl extends MinimalEObjectImpl.Container implements StopUpdate {
	/**
	 * The default value of the '{@link #getRefStopId() <em>Ref Stop Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefStopId()
	 * @generated
	 * @ordered
	 */
	protected static final String REF_STOP_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRefStopId() <em>Ref Stop Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefStopId()
	 * @generated
	 * @ordered
	 */
	protected String refStopId = REF_STOP_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getRefScheduleEntryIndex() <em>Ref Schedule Entry Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefScheduleEntryIndex()
	 * @generated
	 * @ordered
	 */
	protected static final int REF_SCHEDULE_ENTRY_INDEX_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRefScheduleEntryIndex() <em>Ref Schedule Entry Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefScheduleEntryIndex()
	 * @generated
	 * @ordered
	 */
	protected int refScheduleEntryIndex = REF_SCHEDULE_ENTRY_INDEX_EDEFAULT;

	/**
	 * The default value of the '{@link #getArrivalExpected() <em>Arrival Expected</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArrivalExpected()
	 * @generated
	 * @ordered
	 */
	protected static final LocalTime ARRIVAL_EXPECTED_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getArrivalExpected() <em>Arrival Expected</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArrivalExpected()
	 * @generated
	 * @ordered
	 */
	protected LocalTime arrivalExpected = ARRIVAL_EXPECTED_EDEFAULT;

	/**
	 * The default value of the '{@link #getDepartureExpected() <em>Departure Expected</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDepartureExpected()
	 * @generated
	 * @ordered
	 */
	protected static final LocalTime DEPARTURE_EXPECTED_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDepartureExpected() <em>Departure Expected</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDepartureExpected()
	 * @generated
	 * @ordered
	 */
	protected LocalTime departureExpected = DEPARTURE_EXPECTED_EDEFAULT;

	/**
	 * The default value of the '{@link #getRecordedArrivalTime() <em>Recorded Arrival Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecordedArrivalTime()
	 * @generated
	 * @ordered
	 */
	protected static final LocalTime RECORDED_ARRIVAL_TIME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRecordedArrivalTime() <em>Recorded Arrival Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecordedArrivalTime()
	 * @generated
	 * @ordered
	 */
	protected LocalTime recordedArrivalTime = RECORDED_ARRIVAL_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDistanceFromNextStop() <em>Distance From Next Stop</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDistanceFromNextStop()
	 * @generated
	 * @ordered
	 */
	protected static final int DISTANCE_FROM_NEXT_STOP_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getDistanceFromNextStop() <em>Distance From Next Stop</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDistanceFromNextStop()
	 * @generated
	 * @ordered
	 */
	protected int distanceFromNextStop = DISTANCE_FROM_NEXT_STOP_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StopUpdateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TOSPublicTransportApiPackage.Literals.STOP_UPDATE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRefStopId() {
		return refStopId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRefStopId(String newRefStopId) {
		String oldRefStopId = refStopId;
		refStopId = newRefStopId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.STOP_UPDATE__REF_STOP_ID, oldRefStopId, refStopId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getRefScheduleEntryIndex() {
		return refScheduleEntryIndex;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRefScheduleEntryIndex(int newRefScheduleEntryIndex) {
		int oldRefScheduleEntryIndex = refScheduleEntryIndex;
		refScheduleEntryIndex = newRefScheduleEntryIndex;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.STOP_UPDATE__REF_SCHEDULE_ENTRY_INDEX, oldRefScheduleEntryIndex, refScheduleEntryIndex));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LocalTime getArrivalExpected() {
		return arrivalExpected;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setArrivalExpected(LocalTime newArrivalExpected) {
		LocalTime oldArrivalExpected = arrivalExpected;
		arrivalExpected = newArrivalExpected;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.STOP_UPDATE__ARRIVAL_EXPECTED, oldArrivalExpected, arrivalExpected));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LocalTime getDepartureExpected() {
		return departureExpected;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDepartureExpected(LocalTime newDepartureExpected) {
		LocalTime oldDepartureExpected = departureExpected;
		departureExpected = newDepartureExpected;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.STOP_UPDATE__DEPARTURE_EXPECTED, oldDepartureExpected, departureExpected));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LocalTime getRecordedArrivalTime() {
		return recordedArrivalTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRecordedArrivalTime(LocalTime newRecordedArrivalTime) {
		LocalTime oldRecordedArrivalTime = recordedArrivalTime;
		recordedArrivalTime = newRecordedArrivalTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.STOP_UPDATE__RECORDED_ARRIVAL_TIME, oldRecordedArrivalTime, recordedArrivalTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getDistanceFromNextStop() {
		return distanceFromNextStop;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDistanceFromNextStop(int newDistanceFromNextStop) {
		int oldDistanceFromNextStop = distanceFromNextStop;
		distanceFromNextStop = newDistanceFromNextStop;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.STOP_UPDATE__DISTANCE_FROM_NEXT_STOP, oldDistanceFromNextStop, distanceFromNextStop));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.STOP_UPDATE__REF_STOP_ID:
				return getRefStopId();
			case TOSPublicTransportApiPackage.STOP_UPDATE__REF_SCHEDULE_ENTRY_INDEX:
				return getRefScheduleEntryIndex();
			case TOSPublicTransportApiPackage.STOP_UPDATE__ARRIVAL_EXPECTED:
				return getArrivalExpected();
			case TOSPublicTransportApiPackage.STOP_UPDATE__DEPARTURE_EXPECTED:
				return getDepartureExpected();
			case TOSPublicTransportApiPackage.STOP_UPDATE__RECORDED_ARRIVAL_TIME:
				return getRecordedArrivalTime();
			case TOSPublicTransportApiPackage.STOP_UPDATE__DISTANCE_FROM_NEXT_STOP:
				return getDistanceFromNextStop();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.STOP_UPDATE__REF_STOP_ID:
				setRefStopId((String)newValue);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__REF_SCHEDULE_ENTRY_INDEX:
				setRefScheduleEntryIndex((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__ARRIVAL_EXPECTED:
				setArrivalExpected((LocalTime)newValue);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__DEPARTURE_EXPECTED:
				setDepartureExpected((LocalTime)newValue);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__RECORDED_ARRIVAL_TIME:
				setRecordedArrivalTime((LocalTime)newValue);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__DISTANCE_FROM_NEXT_STOP:
				setDistanceFromNextStop((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.STOP_UPDATE__REF_STOP_ID:
				setRefStopId(REF_STOP_ID_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__REF_SCHEDULE_ENTRY_INDEX:
				setRefScheduleEntryIndex(REF_SCHEDULE_ENTRY_INDEX_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__ARRIVAL_EXPECTED:
				setArrivalExpected(ARRIVAL_EXPECTED_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__DEPARTURE_EXPECTED:
				setDepartureExpected(DEPARTURE_EXPECTED_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__RECORDED_ARRIVAL_TIME:
				setRecordedArrivalTime(RECORDED_ARRIVAL_TIME_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.STOP_UPDATE__DISTANCE_FROM_NEXT_STOP:
				setDistanceFromNextStop(DISTANCE_FROM_NEXT_STOP_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.STOP_UPDATE__REF_STOP_ID:
				return REF_STOP_ID_EDEFAULT == null ? refStopId != null : !REF_STOP_ID_EDEFAULT.equals(refStopId);
			case TOSPublicTransportApiPackage.STOP_UPDATE__REF_SCHEDULE_ENTRY_INDEX:
				return refScheduleEntryIndex != REF_SCHEDULE_ENTRY_INDEX_EDEFAULT;
			case TOSPublicTransportApiPackage.STOP_UPDATE__ARRIVAL_EXPECTED:
				return ARRIVAL_EXPECTED_EDEFAULT == null ? arrivalExpected != null : !ARRIVAL_EXPECTED_EDEFAULT.equals(arrivalExpected);
			case TOSPublicTransportApiPackage.STOP_UPDATE__DEPARTURE_EXPECTED:
				return DEPARTURE_EXPECTED_EDEFAULT == null ? departureExpected != null : !DEPARTURE_EXPECTED_EDEFAULT.equals(departureExpected);
			case TOSPublicTransportApiPackage.STOP_UPDATE__RECORDED_ARRIVAL_TIME:
				return RECORDED_ARRIVAL_TIME_EDEFAULT == null ? recordedArrivalTime != null : !RECORDED_ARRIVAL_TIME_EDEFAULT.equals(recordedArrivalTime);
			case TOSPublicTransportApiPackage.STOP_UPDATE__DISTANCE_FROM_NEXT_STOP:
				return distanceFromNextStop != DISTANCE_FROM_NEXT_STOP_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (refStopId: ");
		result.append(refStopId);
		result.append(", refScheduleEntryIndex: ");
		result.append(refScheduleEntryIndex);
		result.append(", arrivalExpected: ");
		result.append(arrivalExpected);
		result.append(", departureExpected: ");
		result.append(departureExpected);
		result.append(", recordedArrivalTime: ");
		result.append(recordedArrivalTime);
		result.append(", distanceFromNextStop: ");
		result.append(distanceFromNextStop);
		result.append(')');
		return result.toString();
	}

} //StopUpdateImpl
