/**
 */
package de.jena.udp.model.trafficos.publictransport_api.impl;

import de.jena.udp.model.trafficos.publictransport_api.*;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class TOSPublicTransportApiFactoryImpl extends EFactoryImpl implements TOSPublicTransportApiFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TOSPublicTransportApiFactory init() {
		try {
			TOSPublicTransportApiFactory theTOSPublicTransportApiFactory = (TOSPublicTransportApiFactory)EPackage.Registry.INSTANCE.getEFactory(TOSPublicTransportApiPackage.eNS_URI);
			if (theTOSPublicTransportApiFactory != null) {
				return theTOSPublicTransportApiFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new TOSPublicTransportApiFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TOSPublicTransportApiFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case TOSPublicTransportApiPackage.RESPONSE: return createResponse();
			case TOSPublicTransportApiPackage.ONLINE_DEVICE: return createOnlineDevice();
			case TOSPublicTransportApiPackage.SCHEDULE: return createSchedule();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY: return createScheduleEntry();
			case TOSPublicTransportApiPackage.STOP_INFORMATION: return createStopInformation();
			case TOSPublicTransportApiPackage.POSITION: return createPosition();
			case TOSPublicTransportApiPackage.UPDATE: return createUpdate();
			case TOSPublicTransportApiPackage.POSITION_UPDATE: return createPositionUpdate();
			case TOSPublicTransportApiPackage.TRIP_UPDATE: return createTripUpdate();
			case TOSPublicTransportApiPackage.STOP_UPDATE: return createStopUpdate();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case TOSPublicTransportApiPackage.DEVICE_TYPE:
				return createDeviceTypeFromString(eDataType, initialValue);
			case TOSPublicTransportApiPackage.LOCATION_STATE_TYPE:
				return createLocationStateTypeFromString(eDataType, initialValue);
			case TOSPublicTransportApiPackage.ROUTE_DIRECTION_TYPE:
				return createRouteDirectionTypeFromString(eDataType, initialValue);
			case TOSPublicTransportApiPackage.SCHEDULE_FREQUENCY_DAY_TYPE:
				return createScheduleFrequencyDayTypeFromString(eDataType, initialValue);
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY_TYPE:
				return createScheduleEntryTypeFromString(eDataType, initialValue);
			case TOSPublicTransportApiPackage.PICK_UP_DROP_OFF_TYPE:
				return createPickUpDropOffTypeFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case TOSPublicTransportApiPackage.DEVICE_TYPE:
				return convertDeviceTypeToString(eDataType, instanceValue);
			case TOSPublicTransportApiPackage.LOCATION_STATE_TYPE:
				return convertLocationStateTypeToString(eDataType, instanceValue);
			case TOSPublicTransportApiPackage.ROUTE_DIRECTION_TYPE:
				return convertRouteDirectionTypeToString(eDataType, instanceValue);
			case TOSPublicTransportApiPackage.SCHEDULE_FREQUENCY_DAY_TYPE:
				return convertScheduleFrequencyDayTypeToString(eDataType, instanceValue);
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY_TYPE:
				return convertScheduleEntryTypeToString(eDataType, instanceValue);
			case TOSPublicTransportApiPackage.PICK_UP_DROP_OFF_TYPE:
				return convertPickUpDropOffTypeToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Response createResponse() {
		ResponseImpl response = new ResponseImpl();
		return response;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OnlineDevice createOnlineDevice() {
		OnlineDeviceImpl onlineDevice = new OnlineDeviceImpl();
		return onlineDevice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Schedule createSchedule() {
		ScheduleImpl schedule = new ScheduleImpl();
		return schedule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ScheduleEntry createScheduleEntry() {
		ScheduleEntryImpl scheduleEntry = new ScheduleEntryImpl();
		return scheduleEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StopInformation createStopInformation() {
		StopInformationImpl stopInformation = new StopInformationImpl();
		return stopInformation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Position createPosition() {
		PositionImpl position = new PositionImpl();
		return position;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Update createUpdate() {
		UpdateImpl update = new UpdateImpl();
		return update;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PositionUpdate createPositionUpdate() {
		PositionUpdateImpl positionUpdate = new PositionUpdateImpl();
		return positionUpdate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TripUpdate createTripUpdate() {
		TripUpdateImpl tripUpdate = new TripUpdateImpl();
		return tripUpdate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StopUpdate createStopUpdate() {
		StopUpdateImpl stopUpdate = new StopUpdateImpl();
		return stopUpdate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceType createDeviceTypeFromString(EDataType eDataType, String initialValue) {
		DeviceType result = DeviceType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDeviceTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LocationStateType createLocationStateTypeFromString(EDataType eDataType, String initialValue) {
		LocationStateType result = LocationStateType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertLocationStateTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RouteDirectionType createRouteDirectionTypeFromString(EDataType eDataType, String initialValue) {
		RouteDirectionType result = RouteDirectionType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertRouteDirectionTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ScheduleFrequencyDayType createScheduleFrequencyDayTypeFromString(EDataType eDataType, String initialValue) {
		ScheduleFrequencyDayType result = ScheduleFrequencyDayType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertScheduleFrequencyDayTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ScheduleEntryType createScheduleEntryTypeFromString(EDataType eDataType, String initialValue) {
		ScheduleEntryType result = ScheduleEntryType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertScheduleEntryTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PickUpDropOffType createPickUpDropOffTypeFromString(EDataType eDataType, String initialValue) {
		PickUpDropOffType result = PickUpDropOffType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertPickUpDropOffTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TOSPublicTransportApiPackage getTOSPublicTransportApiPackage() {
		return (TOSPublicTransportApiPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static TOSPublicTransportApiPackage getPackage() {
		return TOSPublicTransportApiPackage.eINSTANCE;
	}

} //TOSPublicTransportApiFactoryImpl
