/**
 */
package de.jena.udp.model.trafficos.publictransport_api.impl;

import de.jena.udp.model.trafficos.common.TOSCommonPackage;

import de.jena.udp.model.trafficos.publictransport_api.DeviceType;
import de.jena.udp.model.trafficos.publictransport_api.LocationStateType;
import de.jena.udp.model.trafficos.publictransport_api.OnlineDevice;
import de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType;
import de.jena.udp.model.trafficos.publictransport_api.Position;
import de.jena.udp.model.trafficos.publictransport_api.PositionUpdate;
import de.jena.udp.model.trafficos.publictransport_api.Response;
import de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType;
import de.jena.udp.model.trafficos.publictransport_api.Schedule;
import de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry;
import de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType;
import de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType;
import de.jena.udp.model.trafficos.publictransport_api.StopInformation;
import de.jena.udp.model.trafficos.publictransport_api.StopUpdate;
import de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiFactory;
import de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage;
import de.jena.udp.model.trafficos.publictransport_api.TripUpdate;
import de.jena.udp.model.trafficos.publictransport_api.Update;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class TOSPublicTransportApiPackageImpl extends EPackageImpl implements TOSPublicTransportApiPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass responseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass onlineDeviceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass scheduleEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass scheduleEntryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stopInformationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass positionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass updateEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass positionUpdateEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass tripUpdateEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stopUpdateEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum deviceTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum locationStateTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum routeDirectionTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum scheduleFrequencyDayTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum scheduleEntryTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum pickUpDropOffTypeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private TOSPublicTransportApiPackageImpl() {
		super(eNS_URI, TOSPublicTransportApiFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link TOSPublicTransportApiPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static TOSPublicTransportApiPackage init() {
		if (isInited) return (TOSPublicTransportApiPackage)EPackage.Registry.INSTANCE.getEPackage(TOSPublicTransportApiPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredTOSPublicTransportApiPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		TOSPublicTransportApiPackageImpl theTOSPublicTransportApiPackage = registeredTOSPublicTransportApiPackage instanceof TOSPublicTransportApiPackageImpl ? (TOSPublicTransportApiPackageImpl)registeredTOSPublicTransportApiPackage : new TOSPublicTransportApiPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		TOSCommonPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theTOSPublicTransportApiPackage.createPackageContents();

		// Initialize created meta-data
		theTOSPublicTransportApiPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theTOSPublicTransportApiPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(TOSPublicTransportApiPackage.eNS_URI, theTOSPublicTransportApiPackage);
		return theTOSPublicTransportApiPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getResponse() {
		return responseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getResponse_Data() {
		return (EReference)responseEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getOnlineDevice() {
		return onlineDeviceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getOnlineDevice_Id() {
		return (EAttribute)onlineDeviceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getOnlineDevice_Type() {
		return (EAttribute)onlineDeviceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSchedule() {
		return scheduleEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchedule_ScheduleId() {
		return (EAttribute)scheduleEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchedule_RefRouteId() {
		return (EAttribute)scheduleEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchedule_RefRouteNumber() {
		return (EAttribute)scheduleEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchedule_RouteDirection() {
		return (EAttribute)scheduleEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getSchedule_ScheduleEntry() {
		return (EReference)scheduleEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchedule_StartDate() {
		return (EAttribute)scheduleEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchedule_EndDate() {
		return (EAttribute)scheduleEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchedule_IncludedDate() {
		return (EAttribute)scheduleEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchedule_ExcludedDate() {
		return (EAttribute)scheduleEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchedule_FrequencyDays() {
		return (EAttribute)scheduleEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getScheduleEntry() {
		return scheduleEntryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_RefScheduleId() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_EntryIndex() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_ArrivalScheduled() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_DepartureScheduled() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_ArrivalDayAfterScheduleStart() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_DepartureDayAfterScheduleStart() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_DwellTime() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_EntryType() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_PickUpType() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_DropOffType() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getScheduleEntry_RefStop() {
		return (EReference)scheduleEntryEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScheduleEntry_RefStopId() {
		return (EAttribute)scheduleEntryEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getStopInformation() {
		return stopInformationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopInformation_StopId() {
		return (EAttribute)stopInformationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopInformation_DHID() {
		return (EAttribute)stopInformationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopInformation_StopName() {
		return (EAttribute)stopInformationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopInformation_DistanceToNextStop() {
		return (EAttribute)stopInformationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getStopInformation_Position() {
		return (EReference)stopInformationEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPosition() {
		return positionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPosition_Latitude() {
		return (EAttribute)positionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPosition_Longitude() {
		return (EAttribute)positionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getUpdate() {
		return updateEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUpdate_RefVehicleId() {
		return (EAttribute)updateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUpdate_Timestamp() {
		return (EAttribute)updateEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPositionUpdate() {
		return positionUpdateEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPositionUpdate_Position() {
		return (EReference)positionUpdateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTripUpdate() {
		return tripUpdateEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTripUpdate_LocationState() {
		return (EAttribute)tripUpdateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTripUpdate_ScheduleDelay() {
		return (EAttribute)tripUpdateEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTripUpdate_CurrentStopIndex() {
		return (EAttribute)tripUpdateEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTripUpdate_CurrentSchedule() {
		return (EReference)tripUpdateEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTripUpdate_StopUpdate() {
		return (EReference)tripUpdateEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTripUpdate_RunNumber() {
		return (EAttribute)tripUpdateEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTripUpdate_PatternNumber() {
		return (EAttribute)tripUpdateEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTripUpdate_PathDestinationNumber() {
		return (EAttribute)tripUpdateEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getStopUpdate() {
		return stopUpdateEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopUpdate_RefStopId() {
		return (EAttribute)stopUpdateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopUpdate_RefScheduleEntryIndex() {
		return (EAttribute)stopUpdateEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopUpdate_ArrivalExpected() {
		return (EAttribute)stopUpdateEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopUpdate_DepartureExpected() {
		return (EAttribute)stopUpdateEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopUpdate_RecordedArrivalTime() {
		return (EAttribute)stopUpdateEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStopUpdate_DistanceFromNextStop() {
		return (EAttribute)stopUpdateEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getDeviceType() {
		return deviceTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getLocationStateType() {
		return locationStateTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getRouteDirectionType() {
		return routeDirectionTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getScheduleFrequencyDayType() {
		return scheduleFrequencyDayTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getScheduleEntryType() {
		return scheduleEntryTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getPickUpDropOffType() {
		return pickUpDropOffTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TOSPublicTransportApiFactory getTOSPublicTransportApiFactory() {
		return (TOSPublicTransportApiFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		responseEClass = createEClass(RESPONSE);
		createEReference(responseEClass, RESPONSE__DATA);

		onlineDeviceEClass = createEClass(ONLINE_DEVICE);
		createEAttribute(onlineDeviceEClass, ONLINE_DEVICE__ID);
		createEAttribute(onlineDeviceEClass, ONLINE_DEVICE__TYPE);

		scheduleEClass = createEClass(SCHEDULE);
		createEAttribute(scheduleEClass, SCHEDULE__SCHEDULE_ID);
		createEAttribute(scheduleEClass, SCHEDULE__REF_ROUTE_ID);
		createEAttribute(scheduleEClass, SCHEDULE__REF_ROUTE_NUMBER);
		createEAttribute(scheduleEClass, SCHEDULE__ROUTE_DIRECTION);
		createEReference(scheduleEClass, SCHEDULE__SCHEDULE_ENTRY);
		createEAttribute(scheduleEClass, SCHEDULE__START_DATE);
		createEAttribute(scheduleEClass, SCHEDULE__END_DATE);
		createEAttribute(scheduleEClass, SCHEDULE__INCLUDED_DATE);
		createEAttribute(scheduleEClass, SCHEDULE__EXCLUDED_DATE);
		createEAttribute(scheduleEClass, SCHEDULE__FREQUENCY_DAYS);

		scheduleEntryEClass = createEClass(SCHEDULE_ENTRY);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__REF_SCHEDULE_ID);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__ENTRY_INDEX);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__ARRIVAL_SCHEDULED);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__DEPARTURE_SCHEDULED);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__ARRIVAL_DAY_AFTER_SCHEDULE_START);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__DEPARTURE_DAY_AFTER_SCHEDULE_START);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__DWELL_TIME);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__ENTRY_TYPE);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__PICK_UP_TYPE);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__DROP_OFF_TYPE);
		createEReference(scheduleEntryEClass, SCHEDULE_ENTRY__REF_STOP);
		createEAttribute(scheduleEntryEClass, SCHEDULE_ENTRY__REF_STOP_ID);

		stopInformationEClass = createEClass(STOP_INFORMATION);
		createEAttribute(stopInformationEClass, STOP_INFORMATION__STOP_ID);
		createEAttribute(stopInformationEClass, STOP_INFORMATION__DHID);
		createEAttribute(stopInformationEClass, STOP_INFORMATION__STOP_NAME);
		createEAttribute(stopInformationEClass, STOP_INFORMATION__DISTANCE_TO_NEXT_STOP);
		createEReference(stopInformationEClass, STOP_INFORMATION__POSITION);

		positionEClass = createEClass(POSITION);
		createEAttribute(positionEClass, POSITION__LATITUDE);
		createEAttribute(positionEClass, POSITION__LONGITUDE);

		updateEClass = createEClass(UPDATE);
		createEAttribute(updateEClass, UPDATE__REF_VEHICLE_ID);
		createEAttribute(updateEClass, UPDATE__TIMESTAMP);

		positionUpdateEClass = createEClass(POSITION_UPDATE);
		createEReference(positionUpdateEClass, POSITION_UPDATE__POSITION);

		tripUpdateEClass = createEClass(TRIP_UPDATE);
		createEAttribute(tripUpdateEClass, TRIP_UPDATE__LOCATION_STATE);
		createEAttribute(tripUpdateEClass, TRIP_UPDATE__SCHEDULE_DELAY);
		createEAttribute(tripUpdateEClass, TRIP_UPDATE__CURRENT_STOP_INDEX);
		createEReference(tripUpdateEClass, TRIP_UPDATE__CURRENT_SCHEDULE);
		createEReference(tripUpdateEClass, TRIP_UPDATE__STOP_UPDATE);
		createEAttribute(tripUpdateEClass, TRIP_UPDATE__RUN_NUMBER);
		createEAttribute(tripUpdateEClass, TRIP_UPDATE__PATTERN_NUMBER);
		createEAttribute(tripUpdateEClass, TRIP_UPDATE__PATH_DESTINATION_NUMBER);

		stopUpdateEClass = createEClass(STOP_UPDATE);
		createEAttribute(stopUpdateEClass, STOP_UPDATE__REF_STOP_ID);
		createEAttribute(stopUpdateEClass, STOP_UPDATE__REF_SCHEDULE_ENTRY_INDEX);
		createEAttribute(stopUpdateEClass, STOP_UPDATE__ARRIVAL_EXPECTED);
		createEAttribute(stopUpdateEClass, STOP_UPDATE__DEPARTURE_EXPECTED);
		createEAttribute(stopUpdateEClass, STOP_UPDATE__RECORDED_ARRIVAL_TIME);
		createEAttribute(stopUpdateEClass, STOP_UPDATE__DISTANCE_FROM_NEXT_STOP);

		// Create enums
		deviceTypeEEnum = createEEnum(DEVICE_TYPE);
		locationStateTypeEEnum = createEEnum(LOCATION_STATE_TYPE);
		routeDirectionTypeEEnum = createEEnum(ROUTE_DIRECTION_TYPE);
		scheduleFrequencyDayTypeEEnum = createEEnum(SCHEDULE_FREQUENCY_DAY_TYPE);
		scheduleEntryTypeEEnum = createEEnum(SCHEDULE_ENTRY_TYPE);
		pickUpDropOffTypeEEnum = createEEnum(PICK_UP_DROP_OFF_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		TOSCommonPackage theTOSCommonPackage = (TOSCommonPackage)EPackage.Registry.INSTANCE.getEPackage(TOSCommonPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		positionUpdateEClass.getESuperTypes().add(this.getUpdate());
		tripUpdateEClass.getESuperTypes().add(this.getUpdate());

		// Initialize classes, features, and operations; add parameters
		initEClass(responseEClass, Response.class, "Response", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getResponse_Data(), ecorePackage.getEObject(), null, "data", null, 0, -1, Response.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(onlineDeviceEClass, OnlineDevice.class, "OnlineDevice", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getOnlineDevice_Id(), ecorePackage.getEString(), "id", null, 1, 1, OnlineDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOnlineDevice_Type(), this.getDeviceType(), "type", null, 0, 1, OnlineDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(scheduleEClass, Schedule.class, "Schedule", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSchedule_ScheduleId(), ecorePackage.getEString(), "scheduleId", null, 1, 1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSchedule_RefRouteId(), ecorePackage.getEString(), "refRouteId", null, 0, 1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSchedule_RefRouteNumber(), ecorePackage.getEInt(), "refRouteNumber", null, 0, 1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSchedule_RouteDirection(), this.getRouteDirectionType(), "routeDirection", null, 0, 1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSchedule_ScheduleEntry(), this.getScheduleEntry(), null, "scheduleEntry", null, 0, -1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSchedule_StartDate(), theTOSCommonPackage.getELocalDate(), "startDate", null, 0, 1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSchedule_EndDate(), theTOSCommonPackage.getELocalDate(), "endDate", null, 0, 1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSchedule_IncludedDate(), theTOSCommonPackage.getELocalDate(), "includedDate", null, 0, -1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSchedule_ExcludedDate(), theTOSCommonPackage.getELocalDate(), "excludedDate", null, 0, -1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSchedule_FrequencyDays(), this.getScheduleFrequencyDayType(), "frequencyDays", null, 0, -1, Schedule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(scheduleEntryEClass, ScheduleEntry.class, "ScheduleEntry", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getScheduleEntry_RefScheduleId(), ecorePackage.getEString(), "refScheduleId", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_EntryIndex(), ecorePackage.getEInt(), "entryIndex", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_ArrivalScheduled(), theTOSCommonPackage.getELocalTime(), "arrivalScheduled", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_DepartureScheduled(), theTOSCommonPackage.getELocalTime(), "departureScheduled", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_ArrivalDayAfterScheduleStart(), ecorePackage.getEInt(), "arrivalDayAfterScheduleStart", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_DepartureDayAfterScheduleStart(), ecorePackage.getEInt(), "departureDayAfterScheduleStart", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_DwellTime(), ecorePackage.getEInt(), "dwellTime", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_EntryType(), this.getScheduleEntryType(), "entryType", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_PickUpType(), this.getPickUpDropOffType(), "pickUpType", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_DropOffType(), this.getPickUpDropOffType(), "dropOffType", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getScheduleEntry_RefStop(), this.getStopInformation(), null, "refStop", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScheduleEntry_RefStopId(), ecorePackage.getEString(), "refStopId", null, 0, 1, ScheduleEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(stopInformationEClass, StopInformation.class, "StopInformation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStopInformation_StopId(), ecorePackage.getEString(), "stopId", null, 1, 1, StopInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStopInformation_DHID(), ecorePackage.getEString(), "DHID", null, 1, 1, StopInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStopInformation_StopName(), ecorePackage.getEString(), "stopName", null, 1, -1, StopInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStopInformation_DistanceToNextStop(), ecorePackage.getEInt(), "distanceToNextStop", null, 0, 1, StopInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getStopInformation_Position(), this.getPosition(), null, "position", null, 0, 1, StopInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(positionEClass, Position.class, "Position", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPosition_Latitude(), ecorePackage.getEDouble(), "latitude", null, 1, 1, Position.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPosition_Longitude(), ecorePackage.getEDouble(), "longitude", null, 1, 1, Position.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(updateEClass, Update.class, "Update", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getUpdate_RefVehicleId(), ecorePackage.getEString(), "refVehicleId", null, 1, 1, Update.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getUpdate_Timestamp(), ecorePackage.getELong(), "timestamp", null, 1, 1, Update.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(positionUpdateEClass, PositionUpdate.class, "PositionUpdate", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPositionUpdate_Position(), this.getPosition(), null, "position", null, 0, 1, PositionUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(tripUpdateEClass, TripUpdate.class, "TripUpdate", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTripUpdate_LocationState(), this.getLocationStateType(), "locationState", null, 0, 1, TripUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTripUpdate_ScheduleDelay(), ecorePackage.getEInt(), "scheduleDelay", null, 0, 1, TripUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTripUpdate_CurrentStopIndex(), ecorePackage.getEInt(), "currentStopIndex", null, 0, 1, TripUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTripUpdate_CurrentSchedule(), this.getSchedule(), null, "currentSchedule", null, 0, 1, TripUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTripUpdate_StopUpdate(), this.getStopUpdate(), null, "stopUpdate", null, 0, -1, TripUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTripUpdate_RunNumber(), ecorePackage.getEInt(), "runNumber", null, 0, 1, TripUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTripUpdate_PatternNumber(), ecorePackage.getEInt(), "patternNumber", null, 0, 1, TripUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTripUpdate_PathDestinationNumber(), ecorePackage.getEInt(), "pathDestinationNumber", null, 0, 1, TripUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(stopUpdateEClass, StopUpdate.class, "StopUpdate", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStopUpdate_RefStopId(), ecorePackage.getEString(), "refStopId", null, 1, 1, StopUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStopUpdate_RefScheduleEntryIndex(), ecorePackage.getEInt(), "refScheduleEntryIndex", null, 1, 1, StopUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStopUpdate_ArrivalExpected(), theTOSCommonPackage.getELocalTime(), "arrivalExpected", null, 0, 1, StopUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStopUpdate_DepartureExpected(), theTOSCommonPackage.getELocalTime(), "departureExpected", null, 0, 1, StopUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStopUpdate_RecordedArrivalTime(), theTOSCommonPackage.getELocalTime(), "recordedArrivalTime", null, 0, 1, StopUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStopUpdate_DistanceFromNextStop(), ecorePackage.getEInt(), "distanceFromNextStop", null, 0, 1, StopUpdate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(deviceTypeEEnum, DeviceType.class, "DeviceType");
		addEEnumLiteral(deviceTypeEEnum, DeviceType.BUS);
		addEEnumLiteral(deviceTypeEEnum, DeviceType.EBUS);
		addEEnumLiteral(deviceTypeEEnum, DeviceType.TRAM);
		addEEnumLiteral(deviceTypeEEnum, DeviceType.TRAIN);

		initEEnum(locationStateTypeEEnum, LocationStateType.class, "LocationStateType");
		addEEnumLiteral(locationStateTypeEEnum, LocationStateType.AFTER_STOP);
		addEEnumLiteral(locationStateTypeEEnum, LocationStateType.AT_STOP);
		addEEnumLiteral(locationStateTypeEEnum, LocationStateType.BEFORE_STOP);
		addEEnumLiteral(locationStateTypeEEnum, LocationStateType.BETWEEN_STOP);

		initEEnum(routeDirectionTypeEEnum, RouteDirectionType.class, "RouteDirectionType");
		addEEnumLiteral(routeDirectionTypeEEnum, RouteDirectionType.FORWARD);
		addEEnumLiteral(routeDirectionTypeEEnum, RouteDirectionType.BACKWARD);
		addEEnumLiteral(routeDirectionTypeEEnum, RouteDirectionType.CLOCKWISE);
		addEEnumLiteral(routeDirectionTypeEEnum, RouteDirectionType.COUNTERCLOCKWISE);
		addEEnumLiteral(routeDirectionTypeEEnum, RouteDirectionType.OTHER);

		initEEnum(scheduleFrequencyDayTypeEEnum, ScheduleFrequencyDayType.class, "ScheduleFrequencyDayType");
		addEEnumLiteral(scheduleFrequencyDayTypeEEnum, ScheduleFrequencyDayType.MONDAY);
		addEEnumLiteral(scheduleFrequencyDayTypeEEnum, ScheduleFrequencyDayType.TUESDAY);
		addEEnumLiteral(scheduleFrequencyDayTypeEEnum, ScheduleFrequencyDayType.WEDNESDAY);
		addEEnumLiteral(scheduleFrequencyDayTypeEEnum, ScheduleFrequencyDayType.THURSDAY);
		addEEnumLiteral(scheduleFrequencyDayTypeEEnum, ScheduleFrequencyDayType.FRIDAY);
		addEEnumLiteral(scheduleFrequencyDayTypeEEnum, ScheduleFrequencyDayType.SATURDAY);
		addEEnumLiteral(scheduleFrequencyDayTypeEEnum, ScheduleFrequencyDayType.SUNDAY);

		initEEnum(scheduleEntryTypeEEnum, ScheduleEntryType.class, "ScheduleEntryType");
		addEEnumLiteral(scheduleEntryTypeEEnum, ScheduleEntryType.START);
		addEEnumLiteral(scheduleEntryTypeEEnum, ScheduleEntryType.END);
		addEEnumLiteral(scheduleEntryTypeEEnum, ScheduleEntryType.TRANSIT);

		initEEnum(pickUpDropOffTypeEEnum, PickUpDropOffType.class, "PickUpDropOffType");
		addEEnumLiteral(pickUpDropOffTypeEEnum, PickUpDropOffType.REGULARLY_SCHEDULED);
		addEEnumLiteral(pickUpDropOffTypeEEnum, PickUpDropOffType.NOT_AVAILABLE);
		addEEnumLiteral(pickUpDropOffTypeEEnum, PickUpDropOffType.PHONE_TO_ARRANGE);
		addEEnumLiteral(pickUpDropOffTypeEEnum, PickUpDropOffType.COORDINATE_WITH_DRIVER);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (getScheduleEntry_ArrivalDayAfterScheduleStart(),
		   source,
		   new String[] {
			   "documentation", "Some time table entries can reference to times which are a day (or two) after the trip is started. So this attribute will take that into account."
		   });
		addAnnotation
		  (getScheduleEntry_DepartureDayAfterScheduleStart(),
		   source,
		   new String[] {
			   "documentation", "Some time table entries can reference to times which are a day (or two) after the trip is started. So this attribute will take that into account."
		   });
		addAnnotation
		  (getTripUpdate_ScheduleDelay(),
		   source,
		   new String[] {
			   "documentation", "Delay in seconds. Early times are shown as negative values."
		   });
	}

} //TOSPublicTransportApiPackageImpl
