/*
 */
package de.jena.udp.model.trafficos.publictransport_api.impl;

import de.jena.udp.model.trafficos.publictransport_api.LocationStateType;
import de.jena.udp.model.trafficos.publictransport_api.Schedule;
import de.jena.udp.model.trafficos.publictransport_api.StopUpdate;
import de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage;
import de.jena.udp.model.trafficos.publictransport_api.TripUpdate;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Trip Update</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl#getLocationState <em>Location State</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl#getScheduleDelay <em>Schedule Delay</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl#getCurrentStopIndex <em>Current Stop Index</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl#getCurrentSchedule <em>Current Schedule</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl#getStopUpdate <em>Stop Update</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl#getRunNumber <em>Run Number</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl#getPatternNumber <em>Pattern Number</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl#getPathDestinationNumber <em>Path Destination Number</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TripUpdateImpl extends UpdateImpl implements TripUpdate {
	/**
	 * The default value of the '{@link #getLocationState() <em>Location State</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocationState()
	 * @generated
	 * @ordered
	 */
	protected static final LocationStateType LOCATION_STATE_EDEFAULT = LocationStateType.AFTER_STOP;

	/**
	 * The cached value of the '{@link #getLocationState() <em>Location State</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocationState()
	 * @generated
	 * @ordered
	 */
	protected LocationStateType locationState = LOCATION_STATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getScheduleDelay() <em>Schedule Delay</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScheduleDelay()
	 * @generated
	 * @ordered
	 */
	protected static final int SCHEDULE_DELAY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getScheduleDelay() <em>Schedule Delay</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScheduleDelay()
	 * @generated
	 * @ordered
	 */
	protected int scheduleDelay = SCHEDULE_DELAY_EDEFAULT;

	/**
	 * The default value of the '{@link #getCurrentStopIndex() <em>Current Stop Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCurrentStopIndex()
	 * @generated
	 * @ordered
	 */
	protected static final int CURRENT_STOP_INDEX_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCurrentStopIndex() <em>Current Stop Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCurrentStopIndex()
	 * @generated
	 * @ordered
	 */
	protected int currentStopIndex = CURRENT_STOP_INDEX_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCurrentSchedule() <em>Current Schedule</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCurrentSchedule()
	 * @generated
	 * @ordered
	 */
	protected Schedule currentSchedule;

	/**
	 * The cached value of the '{@link #getStopUpdate() <em>Stop Update</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopUpdate()
	 * @generated
	 * @ordered
	 */
	protected EList<StopUpdate> stopUpdate;

	/**
	 * The default value of the '{@link #getRunNumber() <em>Run Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRunNumber()
	 * @generated
	 * @ordered
	 */
	protected static final int RUN_NUMBER_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRunNumber() <em>Run Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRunNumber()
	 * @generated
	 * @ordered
	 */
	protected int runNumber = RUN_NUMBER_EDEFAULT;

	/**
	 * The default value of the '{@link #getPatternNumber() <em>Pattern Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPatternNumber()
	 * @generated
	 * @ordered
	 */
	protected static final int PATTERN_NUMBER_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPatternNumber() <em>Pattern Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPatternNumber()
	 * @generated
	 * @ordered
	 */
	protected int patternNumber = PATTERN_NUMBER_EDEFAULT;

	/**
	 * The default value of the '{@link #getPathDestinationNumber() <em>Path Destination Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPathDestinationNumber()
	 * @generated
	 * @ordered
	 */
	protected static final int PATH_DESTINATION_NUMBER_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPathDestinationNumber() <em>Path Destination Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPathDestinationNumber()
	 * @generated
	 * @ordered
	 */
	protected int pathDestinationNumber = PATH_DESTINATION_NUMBER_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TripUpdateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TOSPublicTransportApiPackage.Literals.TRIP_UPDATE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LocationStateType getLocationState() {
		return locationState;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLocationState(LocationStateType newLocationState) {
		LocationStateType oldLocationState = locationState;
		locationState = newLocationState == null ? LOCATION_STATE_EDEFAULT : newLocationState;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.TRIP_UPDATE__LOCATION_STATE, oldLocationState, locationState));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getScheduleDelay() {
		return scheduleDelay;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setScheduleDelay(int newScheduleDelay) {
		int oldScheduleDelay = scheduleDelay;
		scheduleDelay = newScheduleDelay;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.TRIP_UPDATE__SCHEDULE_DELAY, oldScheduleDelay, scheduleDelay));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getCurrentStopIndex() {
		return currentStopIndex;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCurrentStopIndex(int newCurrentStopIndex) {
		int oldCurrentStopIndex = currentStopIndex;
		currentStopIndex = newCurrentStopIndex;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_STOP_INDEX, oldCurrentStopIndex, currentStopIndex));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Schedule getCurrentSchedule() {
		return currentSchedule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCurrentSchedule(Schedule newCurrentSchedule, NotificationChain msgs) {
		Schedule oldCurrentSchedule = currentSchedule;
		currentSchedule = newCurrentSchedule;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_SCHEDULE, oldCurrentSchedule, newCurrentSchedule);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCurrentSchedule(Schedule newCurrentSchedule) {
		if (newCurrentSchedule != currentSchedule) {
			NotificationChain msgs = null;
			if (currentSchedule != null)
				msgs = ((InternalEObject)currentSchedule).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_SCHEDULE, null, msgs);
			if (newCurrentSchedule != null)
				msgs = ((InternalEObject)newCurrentSchedule).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_SCHEDULE, null, msgs);
			msgs = basicSetCurrentSchedule(newCurrentSchedule, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_SCHEDULE, newCurrentSchedule, newCurrentSchedule));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<StopUpdate> getStopUpdate() {
		if (stopUpdate == null) {
			stopUpdate = new EObjectContainmentEList<StopUpdate>(StopUpdate.class, this, TOSPublicTransportApiPackage.TRIP_UPDATE__STOP_UPDATE);
		}
		return stopUpdate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getRunNumber() {
		return runNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRunNumber(int newRunNumber) {
		int oldRunNumber = runNumber;
		runNumber = newRunNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.TRIP_UPDATE__RUN_NUMBER, oldRunNumber, runNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPatternNumber() {
		return patternNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPatternNumber(int newPatternNumber) {
		int oldPatternNumber = patternNumber;
		patternNumber = newPatternNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.TRIP_UPDATE__PATTERN_NUMBER, oldPatternNumber, patternNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPathDestinationNumber() {
		return pathDestinationNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPathDestinationNumber(int newPathDestinationNumber) {
		int oldPathDestinationNumber = pathDestinationNumber;
		pathDestinationNumber = newPathDestinationNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.TRIP_UPDATE__PATH_DESTINATION_NUMBER, oldPathDestinationNumber, pathDestinationNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_SCHEDULE:
				return basicSetCurrentSchedule(null, msgs);
			case TOSPublicTransportApiPackage.TRIP_UPDATE__STOP_UPDATE:
				return ((InternalEList<?>)getStopUpdate()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.TRIP_UPDATE__LOCATION_STATE:
				return getLocationState();
			case TOSPublicTransportApiPackage.TRIP_UPDATE__SCHEDULE_DELAY:
				return getScheduleDelay();
			case TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_STOP_INDEX:
				return getCurrentStopIndex();
			case TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_SCHEDULE:
				return getCurrentSchedule();
			case TOSPublicTransportApiPackage.TRIP_UPDATE__STOP_UPDATE:
				return getStopUpdate();
			case TOSPublicTransportApiPackage.TRIP_UPDATE__RUN_NUMBER:
				return getRunNumber();
			case TOSPublicTransportApiPackage.TRIP_UPDATE__PATTERN_NUMBER:
				return getPatternNumber();
			case TOSPublicTransportApiPackage.TRIP_UPDATE__PATH_DESTINATION_NUMBER:
				return getPathDestinationNumber();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.TRIP_UPDATE__LOCATION_STATE:
				setLocationState((LocationStateType)newValue);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__SCHEDULE_DELAY:
				setScheduleDelay((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_STOP_INDEX:
				setCurrentStopIndex((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_SCHEDULE:
				setCurrentSchedule((Schedule)newValue);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__STOP_UPDATE:
				getStopUpdate().clear();
				getStopUpdate().addAll((Collection<? extends StopUpdate>)newValue);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__RUN_NUMBER:
				setRunNumber((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__PATTERN_NUMBER:
				setPatternNumber((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__PATH_DESTINATION_NUMBER:
				setPathDestinationNumber((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.TRIP_UPDATE__LOCATION_STATE:
				setLocationState(LOCATION_STATE_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__SCHEDULE_DELAY:
				setScheduleDelay(SCHEDULE_DELAY_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_STOP_INDEX:
				setCurrentStopIndex(CURRENT_STOP_INDEX_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_SCHEDULE:
				setCurrentSchedule((Schedule)null);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__STOP_UPDATE:
				getStopUpdate().clear();
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__RUN_NUMBER:
				setRunNumber(RUN_NUMBER_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__PATTERN_NUMBER:
				setPatternNumber(PATTERN_NUMBER_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__PATH_DESTINATION_NUMBER:
				setPathDestinationNumber(PATH_DESTINATION_NUMBER_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.TRIP_UPDATE__LOCATION_STATE:
				return locationState != LOCATION_STATE_EDEFAULT;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__SCHEDULE_DELAY:
				return scheduleDelay != SCHEDULE_DELAY_EDEFAULT;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_STOP_INDEX:
				return currentStopIndex != CURRENT_STOP_INDEX_EDEFAULT;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__CURRENT_SCHEDULE:
				return currentSchedule != null;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__STOP_UPDATE:
				return stopUpdate != null && !stopUpdate.isEmpty();
			case TOSPublicTransportApiPackage.TRIP_UPDATE__RUN_NUMBER:
				return runNumber != RUN_NUMBER_EDEFAULT;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__PATTERN_NUMBER:
				return patternNumber != PATTERN_NUMBER_EDEFAULT;
			case TOSPublicTransportApiPackage.TRIP_UPDATE__PATH_DESTINATION_NUMBER:
				return pathDestinationNumber != PATH_DESTINATION_NUMBER_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (locationState: ");
		result.append(locationState);
		result.append(", scheduleDelay: ");
		result.append(scheduleDelay);
		result.append(", currentStopIndex: ");
		result.append(currentStopIndex);
		result.append(", runNumber: ");
		result.append(runNumber);
		result.append(", patternNumber: ");
		result.append(patternNumber);
		result.append(", pathDestinationNumber: ");
		result.append(pathDestinationNumber);
		result.append(')');
		return result.toString();
	}

} //TripUpdateImpl
