/*
 */
package de.jena.udp.model.trafficos.publictransport_api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Location State Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getLocationStateType()
 * @model
 * @generated
 */
@ProviderType
public enum LocationStateType implements Enumerator {
	/**
	 * The '<em><b>AFTER STOP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AFTER_STOP_VALUE
	 * @generated
	 * @ordered
	 */
	AFTER_STOP(0, "AFTER_STOP", "AFTER_STOP"),

	/**
	 * The '<em><b>AT STOP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AT_STOP_VALUE
	 * @generated
	 * @ordered
	 */
	AT_STOP(1, "AT_STOP", "AT_STOP"),

	/**
	 * The '<em><b>BEFORE STOP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BEFORE_STOP_VALUE
	 * @generated
	 * @ordered
	 */
	BEFORE_STOP(2, "BEFORE_STOP", "BEFORE_STOP"),

	/**
	 * The '<em><b>BETWEEN STOP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BETWEEN_STOP_VALUE
	 * @generated
	 * @ordered
	 */
	BETWEEN_STOP(3, "BETWEEN_STOP", "BETWEEN_STOP");

	/**
	 * The '<em><b>AFTER STOP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AFTER_STOP
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int AFTER_STOP_VALUE = 0;

	/**
	 * The '<em><b>AT STOP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AT_STOP
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int AT_STOP_VALUE = 1;

	/**
	 * The '<em><b>BEFORE STOP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BEFORE_STOP
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BEFORE_STOP_VALUE = 2;

	/**
	 * The '<em><b>BETWEEN STOP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BETWEEN_STOP
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BETWEEN_STOP_VALUE = 3;

	/**
	 * An array of all the '<em><b>Location State Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final LocationStateType[] VALUES_ARRAY =
		new LocationStateType[] {
			AFTER_STOP,
			AT_STOP,
			BEFORE_STOP,
			BETWEEN_STOP,
		};

	/**
	 * A public read-only list of all the '<em><b>Location State Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<LocationStateType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Location State Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LocationStateType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LocationStateType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Location State Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LocationStateType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LocationStateType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Location State Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LocationStateType get(int value) {
		switch (value) {
			case AFTER_STOP_VALUE: return AFTER_STOP;
			case AT_STOP_VALUE: return AT_STOP;
			case BEFORE_STOP_VALUE: return BEFORE_STOP;
			case BETWEEN_STOP_VALUE: return BETWEEN_STOP;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private LocationStateType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //LocationStateType
