/*
 */
package de.jena.udp.model.trafficos.publictransport_api;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiFactory
 * @model kind="package"
 * @generated
 */
@ProviderType
@EPackage(uri = TOSPublicTransportApiPackage.eNS_URI, genModel = "/model/tos-publictransport-api.genmodel")
public interface TOSPublicTransportApiPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "publictransport_api";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://jena.de/udp/trafficos/publictransport-api/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "publictransport_api";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	TOSPublicTransportApiPackage eINSTANCE = de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.ResponseImpl <em>Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.ResponseImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getResponse()
	 * @generated
	 */
	int RESPONSE = 0;

	/**
	 * The feature id for the '<em><b>Data</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE__DATA = 0;

	/**
	 * The number of structural features of the '<em>Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.OnlineDeviceImpl <em>Online Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.OnlineDeviceImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getOnlineDevice()
	 * @generated
	 */
	int ONLINE_DEVICE = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONLINE_DEVICE__ID = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONLINE_DEVICE__TYPE = 1;

	/**
	 * The number of structural features of the '<em>Online Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONLINE_DEVICE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Online Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONLINE_DEVICE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl <em>Schedule</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getSchedule()
	 * @generated
	 */
	int SCHEDULE = 2;

	/**
	 * The feature id for the '<em><b>Schedule Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__SCHEDULE_ID = 0;

	/**
	 * The feature id for the '<em><b>Ref Route Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__REF_ROUTE_ID = 1;

	/**
	 * The feature id for the '<em><b>Ref Route Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__REF_ROUTE_NUMBER = 2;

	/**
	 * The feature id for the '<em><b>Route Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__ROUTE_DIRECTION = 3;

	/**
	 * The feature id for the '<em><b>Schedule Entry</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__SCHEDULE_ENTRY = 4;

	/**
	 * The feature id for the '<em><b>Start Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__START_DATE = 5;

	/**
	 * The feature id for the '<em><b>End Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__END_DATE = 6;

	/**
	 * The feature id for the '<em><b>Included Date</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__INCLUDED_DATE = 7;

	/**
	 * The feature id for the '<em><b>Excluded Date</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__EXCLUDED_DATE = 8;

	/**
	 * The feature id for the '<em><b>Frequency Days</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE__FREQUENCY_DAYS = 9;

	/**
	 * The number of structural features of the '<em>Schedule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Schedule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl <em>Schedule Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getScheduleEntry()
	 * @generated
	 */
	int SCHEDULE_ENTRY = 3;

	/**
	 * The feature id for the '<em><b>Ref Schedule Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__REF_SCHEDULE_ID = 0;

	/**
	 * The feature id for the '<em><b>Entry Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__ENTRY_INDEX = 1;

	/**
	 * The feature id for the '<em><b>Arrival Scheduled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__ARRIVAL_SCHEDULED = 2;

	/**
	 * The feature id for the '<em><b>Departure Scheduled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__DEPARTURE_SCHEDULED = 3;

	/**
	 * The feature id for the '<em><b>Arrival Day After Schedule Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__ARRIVAL_DAY_AFTER_SCHEDULE_START = 4;

	/**
	 * The feature id for the '<em><b>Departure Day After Schedule Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__DEPARTURE_DAY_AFTER_SCHEDULE_START = 5;

	/**
	 * The feature id for the '<em><b>Dwell Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__DWELL_TIME = 6;

	/**
	 * The feature id for the '<em><b>Entry Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__ENTRY_TYPE = 7;

	/**
	 * The feature id for the '<em><b>Pick Up Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__PICK_UP_TYPE = 8;

	/**
	 * The feature id for the '<em><b>Drop Off Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__DROP_OFF_TYPE = 9;

	/**
	 * The feature id for the '<em><b>Ref Stop</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__REF_STOP = 10;

	/**
	 * The feature id for the '<em><b>Ref Stop Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY__REF_STOP_ID = 11;

	/**
	 * The number of structural features of the '<em>Schedule Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Schedule Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopInformationImpl <em>Stop Information</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.StopInformationImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getStopInformation()
	 * @generated
	 */
	int STOP_INFORMATION = 4;

	/**
	 * The feature id for the '<em><b>Stop Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_INFORMATION__STOP_ID = 0;

	/**
	 * The feature id for the '<em><b>DHID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_INFORMATION__DHID = 1;

	/**
	 * The feature id for the '<em><b>Stop Name</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_INFORMATION__STOP_NAME = 2;

	/**
	 * The feature id for the '<em><b>Distance To Next Stop</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_INFORMATION__DISTANCE_TO_NEXT_STOP = 3;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_INFORMATION__POSITION = 4;

	/**
	 * The number of structural features of the '<em>Stop Information</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_INFORMATION_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Stop Information</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_INFORMATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.PositionImpl <em>Position</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.PositionImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getPosition()
	 * @generated
	 */
	int POSITION = 5;

	/**
	 * The feature id for the '<em><b>Latitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION__LATITUDE = 0;

	/**
	 * The feature id for the '<em><b>Longitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION__LONGITUDE = 1;

	/**
	 * The number of structural features of the '<em>Position</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Position</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.UpdateImpl <em>Update</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.UpdateImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getUpdate()
	 * @generated
	 */
	int UPDATE = 6;

	/**
	 * The feature id for the '<em><b>Ref Vehicle Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE__REF_VEHICLE_ID = 0;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE__TIMESTAMP = 1;

	/**
	 * The number of structural features of the '<em>Update</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Update</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPDATE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.PositionUpdateImpl <em>Position Update</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.PositionUpdateImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getPositionUpdate()
	 * @generated
	 */
	int POSITION_UPDATE = 7;

	/**
	 * The feature id for the '<em><b>Ref Vehicle Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION_UPDATE__REF_VEHICLE_ID = UPDATE__REF_VEHICLE_ID;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION_UPDATE__TIMESTAMP = UPDATE__TIMESTAMP;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION_UPDATE__POSITION = UPDATE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Position Update</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION_UPDATE_FEATURE_COUNT = UPDATE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Position Update</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITION_UPDATE_OPERATION_COUNT = UPDATE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl <em>Trip Update</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getTripUpdate()
	 * @generated
	 */
	int TRIP_UPDATE = 8;

	/**
	 * The feature id for the '<em><b>Ref Vehicle Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__REF_VEHICLE_ID = UPDATE__REF_VEHICLE_ID;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__TIMESTAMP = UPDATE__TIMESTAMP;

	/**
	 * The feature id for the '<em><b>Location State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__LOCATION_STATE = UPDATE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Schedule Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__SCHEDULE_DELAY = UPDATE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Current Stop Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__CURRENT_STOP_INDEX = UPDATE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Current Schedule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__CURRENT_SCHEDULE = UPDATE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Stop Update</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__STOP_UPDATE = UPDATE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Run Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__RUN_NUMBER = UPDATE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Pattern Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__PATTERN_NUMBER = UPDATE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Path Destination Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE__PATH_DESTINATION_NUMBER = UPDATE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Trip Update</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE_FEATURE_COUNT = UPDATE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Trip Update</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIP_UPDATE_OPERATION_COUNT = UPDATE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl <em>Stop Update</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getStopUpdate()
	 * @generated
	 */
	int STOP_UPDATE = 9;

	/**
	 * The feature id for the '<em><b>Ref Stop Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_UPDATE__REF_STOP_ID = 0;

	/**
	 * The feature id for the '<em><b>Ref Schedule Entry Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_UPDATE__REF_SCHEDULE_ENTRY_INDEX = 1;

	/**
	 * The feature id for the '<em><b>Arrival Expected</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_UPDATE__ARRIVAL_EXPECTED = 2;

	/**
	 * The feature id for the '<em><b>Departure Expected</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_UPDATE__DEPARTURE_EXPECTED = 3;

	/**
	 * The feature id for the '<em><b>Recorded Arrival Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_UPDATE__RECORDED_ARRIVAL_TIME = 4;

	/**
	 * The feature id for the '<em><b>Distance From Next Stop</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_UPDATE__DISTANCE_FROM_NEXT_STOP = 5;

	/**
	 * The number of structural features of the '<em>Stop Update</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_UPDATE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Stop Update</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STOP_UPDATE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.DeviceType <em>Device Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.DeviceType
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getDeviceType()
	 * @generated
	 */
	int DEVICE_TYPE = 10;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.LocationStateType <em>Location State Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.LocationStateType
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getLocationStateType()
	 * @generated
	 */
	int LOCATION_STATE_TYPE = 11;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType <em>Route Direction Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getRouteDirectionType()
	 * @generated
	 */
	int ROUTE_DIRECTION_TYPE = 12;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType <em>Schedule Frequency Day Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getScheduleFrequencyDayType()
	 * @generated
	 */
	int SCHEDULE_FREQUENCY_DAY_TYPE = 13;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType <em>Schedule Entry Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getScheduleEntryType()
	 * @generated
	 */
	int SCHEDULE_ENTRY_TYPE = 14;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType <em>Pick Up Drop Off Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType
	 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getPickUpDropOffType()
	 * @generated
	 */
	int PICK_UP_DROP_OFF_TYPE = 15;


	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.Response <em>Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Response</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Response
	 * @generated
	 */
	EClass getResponse();

	/**
	 * Returns the meta object for the containment reference list '{@link de.jena.udp.model.trafficos.publictransport_api.Response#getData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Data</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Response#getData()
	 * @see #getResponse()
	 * @generated
	 */
	EReference getResponse_Data();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.OnlineDevice <em>Online Device</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Online Device</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.OnlineDevice
	 * @generated
	 */
	EClass getOnlineDevice();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.OnlineDevice#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.OnlineDevice#getId()
	 * @see #getOnlineDevice()
	 * @generated
	 */
	EAttribute getOnlineDevice_Id();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.OnlineDevice#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.OnlineDevice#getType()
	 * @see #getOnlineDevice()
	 * @generated
	 */
	EAttribute getOnlineDevice_Type();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule <em>Schedule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Schedule</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule
	 * @generated
	 */
	EClass getSchedule();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getScheduleId <em>Schedule Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Schedule Id</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getScheduleId()
	 * @see #getSchedule()
	 * @generated
	 */
	EAttribute getSchedule_ScheduleId();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getRefRouteId <em>Ref Route Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ref Route Id</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getRefRouteId()
	 * @see #getSchedule()
	 * @generated
	 */
	EAttribute getSchedule_RefRouteId();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getRefRouteNumber <em>Ref Route Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ref Route Number</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getRefRouteNumber()
	 * @see #getSchedule()
	 * @generated
	 */
	EAttribute getSchedule_RefRouteNumber();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getRouteDirection <em>Route Direction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Route Direction</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getRouteDirection()
	 * @see #getSchedule()
	 * @generated
	 */
	EAttribute getSchedule_RouteDirection();

	/**
	 * Returns the meta object for the containment reference list '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getScheduleEntry <em>Schedule Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Schedule Entry</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getScheduleEntry()
	 * @see #getSchedule()
	 * @generated
	 */
	EReference getSchedule_ScheduleEntry();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getStartDate <em>Start Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Date</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getStartDate()
	 * @see #getSchedule()
	 * @generated
	 */
	EAttribute getSchedule_StartDate();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getEndDate <em>End Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Date</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getEndDate()
	 * @see #getSchedule()
	 * @generated
	 */
	EAttribute getSchedule_EndDate();

	/**
	 * Returns the meta object for the attribute list '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getIncludedDate <em>Included Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Included Date</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getIncludedDate()
	 * @see #getSchedule()
	 * @generated
	 */
	EAttribute getSchedule_IncludedDate();

	/**
	 * Returns the meta object for the attribute list '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getExcludedDate <em>Excluded Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Excluded Date</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getExcludedDate()
	 * @see #getSchedule()
	 * @generated
	 */
	EAttribute getSchedule_ExcludedDate();

	/**
	 * Returns the meta object for the attribute list '{@link de.jena.udp.model.trafficos.publictransport_api.Schedule#getFrequencyDays <em>Frequency Days</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Frequency Days</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Schedule#getFrequencyDays()
	 * @see #getSchedule()
	 * @generated
	 */
	EAttribute getSchedule_FrequencyDays();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry <em>Schedule Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Schedule Entry</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry
	 * @generated
	 */
	EClass getScheduleEntry();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefScheduleId <em>Ref Schedule Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ref Schedule Id</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefScheduleId()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_RefScheduleId();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getEntryIndex <em>Entry Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Entry Index</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getEntryIndex()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_EntryIndex();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getArrivalScheduled <em>Arrival Scheduled</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arrival Scheduled</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getArrivalScheduled()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_ArrivalScheduled();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDepartureScheduled <em>Departure Scheduled</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Departure Scheduled</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDepartureScheduled()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_DepartureScheduled();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getArrivalDayAfterScheduleStart <em>Arrival Day After Schedule Start</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arrival Day After Schedule Start</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getArrivalDayAfterScheduleStart()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_ArrivalDayAfterScheduleStart();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDepartureDayAfterScheduleStart <em>Departure Day After Schedule Start</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Departure Day After Schedule Start</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDepartureDayAfterScheduleStart()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_DepartureDayAfterScheduleStart();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDwellTime <em>Dwell Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Dwell Time</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDwellTime()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_DwellTime();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getEntryType <em>Entry Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Entry Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getEntryType()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_EntryType();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getPickUpType <em>Pick Up Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pick Up Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getPickUpType()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_PickUpType();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDropOffType <em>Drop Off Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Drop Off Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getDropOffType()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_DropOffType();

	/**
	 * Returns the meta object for the containment reference '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefStop <em>Ref Stop</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Ref Stop</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefStop()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EReference getScheduleEntry_RefStop();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefStopId <em>Ref Stop Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ref Stop Id</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry#getRefStopId()
	 * @see #getScheduleEntry()
	 * @generated
	 */
	EAttribute getScheduleEntry_RefStopId();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.StopInformation <em>Stop Information</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Stop Information</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopInformation
	 * @generated
	 */
	EClass getStopInformation();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.StopInformation#getStopId <em>Stop Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stop Id</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopInformation#getStopId()
	 * @see #getStopInformation()
	 * @generated
	 */
	EAttribute getStopInformation_StopId();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.StopInformation#getDHID <em>DHID</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>DHID</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopInformation#getDHID()
	 * @see #getStopInformation()
	 * @generated
	 */
	EAttribute getStopInformation_DHID();

	/**
	 * Returns the meta object for the attribute list '{@link de.jena.udp.model.trafficos.publictransport_api.StopInformation#getStopName <em>Stop Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Stop Name</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopInformation#getStopName()
	 * @see #getStopInformation()
	 * @generated
	 */
	EAttribute getStopInformation_StopName();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.StopInformation#getDistanceToNextStop <em>Distance To Next Stop</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Distance To Next Stop</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopInformation#getDistanceToNextStop()
	 * @see #getStopInformation()
	 * @generated
	 */
	EAttribute getStopInformation_DistanceToNextStop();

	/**
	 * Returns the meta object for the containment reference '{@link de.jena.udp.model.trafficos.publictransport_api.StopInformation#getPosition <em>Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Position</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopInformation#getPosition()
	 * @see #getStopInformation()
	 * @generated
	 */
	EReference getStopInformation_Position();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.Position <em>Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Position</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Position
	 * @generated
	 */
	EClass getPosition();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Position#getLatitude <em>Latitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Latitude</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Position#getLatitude()
	 * @see #getPosition()
	 * @generated
	 */
	EAttribute getPosition_Latitude();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Position#getLongitude <em>Longitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Longitude</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Position#getLongitude()
	 * @see #getPosition()
	 * @generated
	 */
	EAttribute getPosition_Longitude();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.Update <em>Update</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Update</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Update
	 * @generated
	 */
	EClass getUpdate();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Update#getRefVehicleId <em>Ref Vehicle Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ref Vehicle Id</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Update#getRefVehicleId()
	 * @see #getUpdate()
	 * @generated
	 */
	EAttribute getUpdate_RefVehicleId();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.Update#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.Update#getTimestamp()
	 * @see #getUpdate()
	 * @generated
	 */
	EAttribute getUpdate_Timestamp();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.PositionUpdate <em>Position Update</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Position Update</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.PositionUpdate
	 * @generated
	 */
	EClass getPositionUpdate();

	/**
	 * Returns the meta object for the containment reference '{@link de.jena.udp.model.trafficos.publictransport_api.PositionUpdate#getPosition <em>Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Position</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.PositionUpdate#getPosition()
	 * @see #getPositionUpdate()
	 * @generated
	 */
	EReference getPositionUpdate_Position();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate <em>Trip Update</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Trip Update</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TripUpdate
	 * @generated
	 */
	EClass getTripUpdate();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getLocationState <em>Location State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Location State</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getLocationState()
	 * @see #getTripUpdate()
	 * @generated
	 */
	EAttribute getTripUpdate_LocationState();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getScheduleDelay <em>Schedule Delay</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Schedule Delay</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getScheduleDelay()
	 * @see #getTripUpdate()
	 * @generated
	 */
	EAttribute getTripUpdate_ScheduleDelay();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getCurrentStopIndex <em>Current Stop Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Current Stop Index</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getCurrentStopIndex()
	 * @see #getTripUpdate()
	 * @generated
	 */
	EAttribute getTripUpdate_CurrentStopIndex();

	/**
	 * Returns the meta object for the containment reference '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getCurrentSchedule <em>Current Schedule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Current Schedule</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getCurrentSchedule()
	 * @see #getTripUpdate()
	 * @generated
	 */
	EReference getTripUpdate_CurrentSchedule();

	/**
	 * Returns the meta object for the containment reference list '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getStopUpdate <em>Stop Update</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Stop Update</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getStopUpdate()
	 * @see #getTripUpdate()
	 * @generated
	 */
	EReference getTripUpdate_StopUpdate();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getRunNumber <em>Run Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Run Number</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getRunNumber()
	 * @see #getTripUpdate()
	 * @generated
	 */
	EAttribute getTripUpdate_RunNumber();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getPatternNumber <em>Pattern Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pattern Number</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getPatternNumber()
	 * @see #getTripUpdate()
	 * @generated
	 */
	EAttribute getTripUpdate_PatternNumber();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getPathDestinationNumber <em>Path Destination Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Path Destination Number</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getPathDestinationNumber()
	 * @see #getTripUpdate()
	 * @generated
	 */
	EAttribute getTripUpdate_PathDestinationNumber();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.publictransport_api.StopUpdate <em>Stop Update</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Stop Update</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopUpdate
	 * @generated
	 */
	EClass getStopUpdate();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getRefStopId <em>Ref Stop Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ref Stop Id</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getRefStopId()
	 * @see #getStopUpdate()
	 * @generated
	 */
	EAttribute getStopUpdate_RefStopId();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getRefScheduleEntryIndex <em>Ref Schedule Entry Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ref Schedule Entry Index</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getRefScheduleEntryIndex()
	 * @see #getStopUpdate()
	 * @generated
	 */
	EAttribute getStopUpdate_RefScheduleEntryIndex();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getArrivalExpected <em>Arrival Expected</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arrival Expected</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getArrivalExpected()
	 * @see #getStopUpdate()
	 * @generated
	 */
	EAttribute getStopUpdate_ArrivalExpected();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getDepartureExpected <em>Departure Expected</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Departure Expected</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getDepartureExpected()
	 * @see #getStopUpdate()
	 * @generated
	 */
	EAttribute getStopUpdate_DepartureExpected();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getRecordedArrivalTime <em>Recorded Arrival Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Recorded Arrival Time</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getRecordedArrivalTime()
	 * @see #getStopUpdate()
	 * @generated
	 */
	EAttribute getStopUpdate_RecordedArrivalTime();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getDistanceFromNextStop <em>Distance From Next Stop</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Distance From Next Stop</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.StopUpdate#getDistanceFromNextStop()
	 * @see #getStopUpdate()
	 * @generated
	 */
	EAttribute getStopUpdate_DistanceFromNextStop();

	/**
	 * Returns the meta object for enum '{@link de.jena.udp.model.trafficos.publictransport_api.DeviceType <em>Device Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Device Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.DeviceType
	 * @generated
	 */
	EEnum getDeviceType();

	/**
	 * Returns the meta object for enum '{@link de.jena.udp.model.trafficos.publictransport_api.LocationStateType <em>Location State Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Location State Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.LocationStateType
	 * @generated
	 */
	EEnum getLocationStateType();

	/**
	 * Returns the meta object for enum '{@link de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType <em>Route Direction Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Route Direction Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType
	 * @generated
	 */
	EEnum getRouteDirectionType();

	/**
	 * Returns the meta object for enum '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType <em>Schedule Frequency Day Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Schedule Frequency Day Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType
	 * @generated
	 */
	EEnum getScheduleFrequencyDayType();

	/**
	 * Returns the meta object for enum '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType <em>Schedule Entry Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Schedule Entry Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType
	 * @generated
	 */
	EEnum getScheduleEntryType();

	/**
	 * Returns the meta object for enum '{@link de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType <em>Pick Up Drop Off Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Pick Up Drop Off Type</em>'.
	 * @see de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType
	 * @generated
	 */
	EEnum getPickUpDropOffType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	TOSPublicTransportApiFactory getTOSPublicTransportApiFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.ResponseImpl <em>Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.ResponseImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getResponse()
		 * @generated
		 */
		EClass RESPONSE = eINSTANCE.getResponse();

		/**
		 * The meta object literal for the '<em><b>Data</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RESPONSE__DATA = eINSTANCE.getResponse_Data();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.OnlineDeviceImpl <em>Online Device</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.OnlineDeviceImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getOnlineDevice()
		 * @generated
		 */
		EClass ONLINE_DEVICE = eINSTANCE.getOnlineDevice();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ONLINE_DEVICE__ID = eINSTANCE.getOnlineDevice_Id();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ONLINE_DEVICE__TYPE = eINSTANCE.getOnlineDevice_Type();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl <em>Schedule</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getSchedule()
		 * @generated
		 */
		EClass SCHEDULE = eINSTANCE.getSchedule();

		/**
		 * The meta object literal for the '<em><b>Schedule Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE__SCHEDULE_ID = eINSTANCE.getSchedule_ScheduleId();

		/**
		 * The meta object literal for the '<em><b>Ref Route Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE__REF_ROUTE_ID = eINSTANCE.getSchedule_RefRouteId();

		/**
		 * The meta object literal for the '<em><b>Ref Route Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE__REF_ROUTE_NUMBER = eINSTANCE.getSchedule_RefRouteNumber();

		/**
		 * The meta object literal for the '<em><b>Route Direction</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE__ROUTE_DIRECTION = eINSTANCE.getSchedule_RouteDirection();

		/**
		 * The meta object literal for the '<em><b>Schedule Entry</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCHEDULE__SCHEDULE_ENTRY = eINSTANCE.getSchedule_ScheduleEntry();

		/**
		 * The meta object literal for the '<em><b>Start Date</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE__START_DATE = eINSTANCE.getSchedule_StartDate();

		/**
		 * The meta object literal for the '<em><b>End Date</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE__END_DATE = eINSTANCE.getSchedule_EndDate();

		/**
		 * The meta object literal for the '<em><b>Included Date</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE__INCLUDED_DATE = eINSTANCE.getSchedule_IncludedDate();

		/**
		 * The meta object literal for the '<em><b>Excluded Date</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE__EXCLUDED_DATE = eINSTANCE.getSchedule_ExcludedDate();

		/**
		 * The meta object literal for the '<em><b>Frequency Days</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE__FREQUENCY_DAYS = eINSTANCE.getSchedule_FrequencyDays();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl <em>Schedule Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getScheduleEntry()
		 * @generated
		 */
		EClass SCHEDULE_ENTRY = eINSTANCE.getScheduleEntry();

		/**
		 * The meta object literal for the '<em><b>Ref Schedule Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__REF_SCHEDULE_ID = eINSTANCE.getScheduleEntry_RefScheduleId();

		/**
		 * The meta object literal for the '<em><b>Entry Index</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__ENTRY_INDEX = eINSTANCE.getScheduleEntry_EntryIndex();

		/**
		 * The meta object literal for the '<em><b>Arrival Scheduled</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__ARRIVAL_SCHEDULED = eINSTANCE.getScheduleEntry_ArrivalScheduled();

		/**
		 * The meta object literal for the '<em><b>Departure Scheduled</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__DEPARTURE_SCHEDULED = eINSTANCE.getScheduleEntry_DepartureScheduled();

		/**
		 * The meta object literal for the '<em><b>Arrival Day After Schedule Start</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__ARRIVAL_DAY_AFTER_SCHEDULE_START = eINSTANCE.getScheduleEntry_ArrivalDayAfterScheduleStart();

		/**
		 * The meta object literal for the '<em><b>Departure Day After Schedule Start</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__DEPARTURE_DAY_AFTER_SCHEDULE_START = eINSTANCE.getScheduleEntry_DepartureDayAfterScheduleStart();

		/**
		 * The meta object literal for the '<em><b>Dwell Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__DWELL_TIME = eINSTANCE.getScheduleEntry_DwellTime();

		/**
		 * The meta object literal for the '<em><b>Entry Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__ENTRY_TYPE = eINSTANCE.getScheduleEntry_EntryType();

		/**
		 * The meta object literal for the '<em><b>Pick Up Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__PICK_UP_TYPE = eINSTANCE.getScheduleEntry_PickUpType();

		/**
		 * The meta object literal for the '<em><b>Drop Off Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__DROP_OFF_TYPE = eINSTANCE.getScheduleEntry_DropOffType();

		/**
		 * The meta object literal for the '<em><b>Ref Stop</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCHEDULE_ENTRY__REF_STOP = eINSTANCE.getScheduleEntry_RefStop();

		/**
		 * The meta object literal for the '<em><b>Ref Stop Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEDULE_ENTRY__REF_STOP_ID = eINSTANCE.getScheduleEntry_RefStopId();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopInformationImpl <em>Stop Information</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.StopInformationImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getStopInformation()
		 * @generated
		 */
		EClass STOP_INFORMATION = eINSTANCE.getStopInformation();

		/**
		 * The meta object literal for the '<em><b>Stop Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_INFORMATION__STOP_ID = eINSTANCE.getStopInformation_StopId();

		/**
		 * The meta object literal for the '<em><b>DHID</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_INFORMATION__DHID = eINSTANCE.getStopInformation_DHID();

		/**
		 * The meta object literal for the '<em><b>Stop Name</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_INFORMATION__STOP_NAME = eINSTANCE.getStopInformation_StopName();

		/**
		 * The meta object literal for the '<em><b>Distance To Next Stop</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_INFORMATION__DISTANCE_TO_NEXT_STOP = eINSTANCE.getStopInformation_DistanceToNextStop();

		/**
		 * The meta object literal for the '<em><b>Position</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STOP_INFORMATION__POSITION = eINSTANCE.getStopInformation_Position();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.PositionImpl <em>Position</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.PositionImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getPosition()
		 * @generated
		 */
		EClass POSITION = eINSTANCE.getPosition();

		/**
		 * The meta object literal for the '<em><b>Latitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POSITION__LATITUDE = eINSTANCE.getPosition_Latitude();

		/**
		 * The meta object literal for the '<em><b>Longitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POSITION__LONGITUDE = eINSTANCE.getPosition_Longitude();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.UpdateImpl <em>Update</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.UpdateImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getUpdate()
		 * @generated
		 */
		EClass UPDATE = eINSTANCE.getUpdate();

		/**
		 * The meta object literal for the '<em><b>Ref Vehicle Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UPDATE__REF_VEHICLE_ID = eINSTANCE.getUpdate_RefVehicleId();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UPDATE__TIMESTAMP = eINSTANCE.getUpdate_Timestamp();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.PositionUpdateImpl <em>Position Update</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.PositionUpdateImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getPositionUpdate()
		 * @generated
		 */
		EClass POSITION_UPDATE = eINSTANCE.getPositionUpdate();

		/**
		 * The meta object literal for the '<em><b>Position</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POSITION_UPDATE__POSITION = eINSTANCE.getPositionUpdate_Position();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl <em>Trip Update</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TripUpdateImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getTripUpdate()
		 * @generated
		 */
		EClass TRIP_UPDATE = eINSTANCE.getTripUpdate();

		/**
		 * The meta object literal for the '<em><b>Location State</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRIP_UPDATE__LOCATION_STATE = eINSTANCE.getTripUpdate_LocationState();

		/**
		 * The meta object literal for the '<em><b>Schedule Delay</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRIP_UPDATE__SCHEDULE_DELAY = eINSTANCE.getTripUpdate_ScheduleDelay();

		/**
		 * The meta object literal for the '<em><b>Current Stop Index</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRIP_UPDATE__CURRENT_STOP_INDEX = eINSTANCE.getTripUpdate_CurrentStopIndex();

		/**
		 * The meta object literal for the '<em><b>Current Schedule</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRIP_UPDATE__CURRENT_SCHEDULE = eINSTANCE.getTripUpdate_CurrentSchedule();

		/**
		 * The meta object literal for the '<em><b>Stop Update</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRIP_UPDATE__STOP_UPDATE = eINSTANCE.getTripUpdate_StopUpdate();

		/**
		 * The meta object literal for the '<em><b>Run Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRIP_UPDATE__RUN_NUMBER = eINSTANCE.getTripUpdate_RunNumber();

		/**
		 * The meta object literal for the '<em><b>Pattern Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRIP_UPDATE__PATTERN_NUMBER = eINSTANCE.getTripUpdate_PatternNumber();

		/**
		 * The meta object literal for the '<em><b>Path Destination Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRIP_UPDATE__PATH_DESTINATION_NUMBER = eINSTANCE.getTripUpdate_PathDestinationNumber();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl <em>Stop Update</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.StopUpdateImpl
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getStopUpdate()
		 * @generated
		 */
		EClass STOP_UPDATE = eINSTANCE.getStopUpdate();

		/**
		 * The meta object literal for the '<em><b>Ref Stop Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_UPDATE__REF_STOP_ID = eINSTANCE.getStopUpdate_RefStopId();

		/**
		 * The meta object literal for the '<em><b>Ref Schedule Entry Index</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_UPDATE__REF_SCHEDULE_ENTRY_INDEX = eINSTANCE.getStopUpdate_RefScheduleEntryIndex();

		/**
		 * The meta object literal for the '<em><b>Arrival Expected</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_UPDATE__ARRIVAL_EXPECTED = eINSTANCE.getStopUpdate_ArrivalExpected();

		/**
		 * The meta object literal for the '<em><b>Departure Expected</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_UPDATE__DEPARTURE_EXPECTED = eINSTANCE.getStopUpdate_DepartureExpected();

		/**
		 * The meta object literal for the '<em><b>Recorded Arrival Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_UPDATE__RECORDED_ARRIVAL_TIME = eINSTANCE.getStopUpdate_RecordedArrivalTime();

		/**
		 * The meta object literal for the '<em><b>Distance From Next Stop</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STOP_UPDATE__DISTANCE_FROM_NEXT_STOP = eINSTANCE.getStopUpdate_DistanceFromNextStop();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.DeviceType <em>Device Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.DeviceType
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getDeviceType()
		 * @generated
		 */
		EEnum DEVICE_TYPE = eINSTANCE.getDeviceType();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.LocationStateType <em>Location State Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.LocationStateType
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getLocationStateType()
		 * @generated
		 */
		EEnum LOCATION_STATE_TYPE = eINSTANCE.getLocationStateType();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType <em>Route Direction Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.RouteDirectionType
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getRouteDirectionType()
		 * @generated
		 */
		EEnum ROUTE_DIRECTION_TYPE = eINSTANCE.getRouteDirectionType();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType <em>Schedule Frequency Day Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleFrequencyDayType
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getScheduleFrequencyDayType()
		 * @generated
		 */
		EEnum SCHEDULE_FREQUENCY_DAY_TYPE = eINSTANCE.getScheduleFrequencyDayType();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType <em>Schedule Entry Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getScheduleEntryType()
		 * @generated
		 */
		EEnum SCHEDULE_ENTRY_TYPE = eINSTANCE.getScheduleEntryType();

		/**
		 * The meta object literal for the '{@link de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType <em>Pick Up Drop Off Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType
		 * @see de.jena.udp.model.trafficos.publictransport_api.impl.TOSPublicTransportApiPackageImpl#getPickUpDropOffType()
		 * @generated
		 */
		EEnum PICK_UP_DROP_OFF_TYPE = eINSTANCE.getPickUpDropOffType();

	}

} //TOSPublicTransportApiPackage
