/*
 */
package de.jena.udp.model.trafficos.publictransport_api;

import org.eclipse.emf.common.util.EList;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Trip Update</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getLocationState <em>Location State</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getScheduleDelay <em>Schedule Delay</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getCurrentStopIndex <em>Current Stop Index</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getCurrentSchedule <em>Current Schedule</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getStopUpdate <em>Stop Update</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getRunNumber <em>Run Number</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getPatternNumber <em>Pattern Number</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getPathDestinationNumber <em>Path Destination Number</em>}</li>
 * </ul>
 *
 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getTripUpdate()
 * @model
 * @generated
 */
@ProviderType
public interface TripUpdate extends Update {
	/**
	 * Returns the value of the '<em><b>Location State</b></em>' attribute.
	 * The literals are from the enumeration {@link de.jena.udp.model.trafficos.publictransport_api.LocationStateType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Location State</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.LocationStateType
	 * @see #setLocationState(LocationStateType)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getTripUpdate_LocationState()
	 * @model
	 * @generated
	 */
	LocationStateType getLocationState();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getLocationState <em>Location State</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Location State</em>' attribute.
	 * @see de.jena.udp.model.trafficos.publictransport_api.LocationStateType
	 * @see #getLocationState()
	 * @generated
	 */
	void setLocationState(LocationStateType value);

	/**
	 * Returns the value of the '<em><b>Schedule Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Delay in seconds. Early times are shown as negative values.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Schedule Delay</em>' attribute.
	 * @see #setScheduleDelay(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getTripUpdate_ScheduleDelay()
	 * @model
	 * @generated
	 */
	int getScheduleDelay();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getScheduleDelay <em>Schedule Delay</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Schedule Delay</em>' attribute.
	 * @see #getScheduleDelay()
	 * @generated
	 */
	void setScheduleDelay(int value);

	/**
	 * Returns the value of the '<em><b>Current Stop Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Current Stop Index</em>' attribute.
	 * @see #setCurrentStopIndex(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getTripUpdate_CurrentStopIndex()
	 * @model
	 * @generated
	 */
	int getCurrentStopIndex();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getCurrentStopIndex <em>Current Stop Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Current Stop Index</em>' attribute.
	 * @see #getCurrentStopIndex()
	 * @generated
	 */
	void setCurrentStopIndex(int value);

	/**
	 * Returns the value of the '<em><b>Current Schedule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Current Schedule</em>' containment reference.
	 * @see #setCurrentSchedule(Schedule)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getTripUpdate_CurrentSchedule()
	 * @model containment="true"
	 * @generated
	 */
	Schedule getCurrentSchedule();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getCurrentSchedule <em>Current Schedule</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Current Schedule</em>' containment reference.
	 * @see #getCurrentSchedule()
	 * @generated
	 */
	void setCurrentSchedule(Schedule value);

	/**
	 * Returns the value of the '<em><b>Stop Update</b></em>' containment reference list.
	 * The list contents are of type {@link de.jena.udp.model.trafficos.publictransport_api.StopUpdate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Stop Update</em>' containment reference list.
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getTripUpdate_StopUpdate()
	 * @model containment="true"
	 * @generated
	 */
	EList<StopUpdate> getStopUpdate();

	/**
	 * Returns the value of the '<em><b>Run Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Run Number</em>' attribute.
	 * @see #setRunNumber(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getTripUpdate_RunNumber()
	 * @model
	 * @generated
	 */
	int getRunNumber();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getRunNumber <em>Run Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Run Number</em>' attribute.
	 * @see #getRunNumber()
	 * @generated
	 */
	void setRunNumber(int value);

	/**
	 * Returns the value of the '<em><b>Pattern Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pattern Number</em>' attribute.
	 * @see #setPatternNumber(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getTripUpdate_PatternNumber()
	 * @model
	 * @generated
	 */
	int getPatternNumber();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getPatternNumber <em>Pattern Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pattern Number</em>' attribute.
	 * @see #getPatternNumber()
	 * @generated
	 */
	void setPatternNumber(int value);

	/**
	 * Returns the value of the '<em><b>Path Destination Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Path Destination Number</em>' attribute.
	 * @see #setPathDestinationNumber(int)
	 * @see de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage#getTripUpdate_PathDestinationNumber()
	 * @model
	 * @generated
	 */
	int getPathDestinationNumber();

	/**
	 * Sets the value of the '{@link de.jena.udp.model.trafficos.publictransport_api.TripUpdate#getPathDestinationNumber <em>Path Destination Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Path Destination Number</em>' attribute.
	 * @see #getPathDestinationNumber()
	 * @generated
	 */
	void setPathDestinationNumber(int value);

} // TripUpdate
