/*
 */
package de.jena.udp.model.trafficos.publictransport_api.impl;

import de.jena.udp.model.trafficos.publictransport_api.PickUpDropOffType;
import de.jena.udp.model.trafficos.publictransport_api.ScheduleEntry;
import de.jena.udp.model.trafficos.publictransport_api.ScheduleEntryType;
import de.jena.udp.model.trafficos.publictransport_api.StopInformation;
import de.jena.udp.model.trafficos.publictransport_api.TOSPublicTransportApiPackage;

import java.time.LocalTime;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Schedule Entry</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getRefScheduleId <em>Ref Schedule Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getEntryIndex <em>Entry Index</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getArrivalScheduled <em>Arrival Scheduled</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getDepartureScheduled <em>Departure Scheduled</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getArrivalDayAfterScheduleStart <em>Arrival Day After Schedule Start</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getDepartureDayAfterScheduleStart <em>Departure Day After Schedule Start</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getDwellTime <em>Dwell Time</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getEntryType <em>Entry Type</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getPickUpType <em>Pick Up Type</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getDropOffType <em>Drop Off Type</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getRefStop <em>Ref Stop</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.publictransport_api.impl.ScheduleEntryImpl#getRefStopId <em>Ref Stop Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ScheduleEntryImpl extends MinimalEObjectImpl.Container implements ScheduleEntry {
	/**
	 * The default value of the '{@link #getRefScheduleId() <em>Ref Schedule Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefScheduleId()
	 * @generated
	 * @ordered
	 */
	protected static final String REF_SCHEDULE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRefScheduleId() <em>Ref Schedule Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefScheduleId()
	 * @generated
	 * @ordered
	 */
	protected String refScheduleId = REF_SCHEDULE_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getEntryIndex() <em>Entry Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryIndex()
	 * @generated
	 * @ordered
	 */
	protected static final int ENTRY_INDEX_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getEntryIndex() <em>Entry Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryIndex()
	 * @generated
	 * @ordered
	 */
	protected int entryIndex = ENTRY_INDEX_EDEFAULT;

	/**
	 * The default value of the '{@link #getArrivalScheduled() <em>Arrival Scheduled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArrivalScheduled()
	 * @generated
	 * @ordered
	 */
	protected static final LocalTime ARRIVAL_SCHEDULED_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getArrivalScheduled() <em>Arrival Scheduled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArrivalScheduled()
	 * @generated
	 * @ordered
	 */
	protected LocalTime arrivalScheduled = ARRIVAL_SCHEDULED_EDEFAULT;

	/**
	 * The default value of the '{@link #getDepartureScheduled() <em>Departure Scheduled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDepartureScheduled()
	 * @generated
	 * @ordered
	 */
	protected static final LocalTime DEPARTURE_SCHEDULED_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDepartureScheduled() <em>Departure Scheduled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDepartureScheduled()
	 * @generated
	 * @ordered
	 */
	protected LocalTime departureScheduled = DEPARTURE_SCHEDULED_EDEFAULT;

	/**
	 * The default value of the '{@link #getArrivalDayAfterScheduleStart() <em>Arrival Day After Schedule Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArrivalDayAfterScheduleStart()
	 * @generated
	 * @ordered
	 */
	protected static final int ARRIVAL_DAY_AFTER_SCHEDULE_START_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getArrivalDayAfterScheduleStart() <em>Arrival Day After Schedule Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArrivalDayAfterScheduleStart()
	 * @generated
	 * @ordered
	 */
	protected int arrivalDayAfterScheduleStart = ARRIVAL_DAY_AFTER_SCHEDULE_START_EDEFAULT;

	/**
	 * The default value of the '{@link #getDepartureDayAfterScheduleStart() <em>Departure Day After Schedule Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDepartureDayAfterScheduleStart()
	 * @generated
	 * @ordered
	 */
	protected static final int DEPARTURE_DAY_AFTER_SCHEDULE_START_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getDepartureDayAfterScheduleStart() <em>Departure Day After Schedule Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDepartureDayAfterScheduleStart()
	 * @generated
	 * @ordered
	 */
	protected int departureDayAfterScheduleStart = DEPARTURE_DAY_AFTER_SCHEDULE_START_EDEFAULT;

	/**
	 * The default value of the '{@link #getDwellTime() <em>Dwell Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDwellTime()
	 * @generated
	 * @ordered
	 */
	protected static final int DWELL_TIME_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getDwellTime() <em>Dwell Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDwellTime()
	 * @generated
	 * @ordered
	 */
	protected int dwellTime = DWELL_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getEntryType() <em>Entry Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryType()
	 * @generated
	 * @ordered
	 */
	protected static final ScheduleEntryType ENTRY_TYPE_EDEFAULT = ScheduleEntryType.START;

	/**
	 * The cached value of the '{@link #getEntryType() <em>Entry Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryType()
	 * @generated
	 * @ordered
	 */
	protected ScheduleEntryType entryType = ENTRY_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPickUpType() <em>Pick Up Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPickUpType()
	 * @generated
	 * @ordered
	 */
	protected static final PickUpDropOffType PICK_UP_TYPE_EDEFAULT = PickUpDropOffType.REGULARLY_SCHEDULED;

	/**
	 * The cached value of the '{@link #getPickUpType() <em>Pick Up Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPickUpType()
	 * @generated
	 * @ordered
	 */
	protected PickUpDropOffType pickUpType = PICK_UP_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getDropOffType() <em>Drop Off Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDropOffType()
	 * @generated
	 * @ordered
	 */
	protected static final PickUpDropOffType DROP_OFF_TYPE_EDEFAULT = PickUpDropOffType.REGULARLY_SCHEDULED;

	/**
	 * The cached value of the '{@link #getDropOffType() <em>Drop Off Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDropOffType()
	 * @generated
	 * @ordered
	 */
	protected PickUpDropOffType dropOffType = DROP_OFF_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRefStop() <em>Ref Stop</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefStop()
	 * @generated
	 * @ordered
	 */
	protected StopInformation refStop;

	/**
	 * The default value of the '{@link #getRefStopId() <em>Ref Stop Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefStopId()
	 * @generated
	 * @ordered
	 */
	protected static final String REF_STOP_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRefStopId() <em>Ref Stop Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefStopId()
	 * @generated
	 * @ordered
	 */
	protected String refStopId = REF_STOP_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ScheduleEntryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TOSPublicTransportApiPackage.Literals.SCHEDULE_ENTRY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRefScheduleId() {
		return refScheduleId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRefScheduleId(String newRefScheduleId) {
		String oldRefScheduleId = refScheduleId;
		refScheduleId = newRefScheduleId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_SCHEDULE_ID, oldRefScheduleId, refScheduleId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getEntryIndex() {
		return entryIndex;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEntryIndex(int newEntryIndex) {
		int oldEntryIndex = entryIndex;
		entryIndex = newEntryIndex;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_INDEX, oldEntryIndex, entryIndex));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LocalTime getArrivalScheduled() {
		return arrivalScheduled;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setArrivalScheduled(LocalTime newArrivalScheduled) {
		LocalTime oldArrivalScheduled = arrivalScheduled;
		arrivalScheduled = newArrivalScheduled;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_SCHEDULED, oldArrivalScheduled, arrivalScheduled));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LocalTime getDepartureScheduled() {
		return departureScheduled;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDepartureScheduled(LocalTime newDepartureScheduled) {
		LocalTime oldDepartureScheduled = departureScheduled;
		departureScheduled = newDepartureScheduled;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_SCHEDULED, oldDepartureScheduled, departureScheduled));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getArrivalDayAfterScheduleStart() {
		return arrivalDayAfterScheduleStart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setArrivalDayAfterScheduleStart(int newArrivalDayAfterScheduleStart) {
		int oldArrivalDayAfterScheduleStart = arrivalDayAfterScheduleStart;
		arrivalDayAfterScheduleStart = newArrivalDayAfterScheduleStart;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_DAY_AFTER_SCHEDULE_START, oldArrivalDayAfterScheduleStart, arrivalDayAfterScheduleStart));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getDepartureDayAfterScheduleStart() {
		return departureDayAfterScheduleStart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDepartureDayAfterScheduleStart(int newDepartureDayAfterScheduleStart) {
		int oldDepartureDayAfterScheduleStart = departureDayAfterScheduleStart;
		departureDayAfterScheduleStart = newDepartureDayAfterScheduleStart;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_DAY_AFTER_SCHEDULE_START, oldDepartureDayAfterScheduleStart, departureDayAfterScheduleStart));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getDwellTime() {
		return dwellTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDwellTime(int newDwellTime) {
		int oldDwellTime = dwellTime;
		dwellTime = newDwellTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DWELL_TIME, oldDwellTime, dwellTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ScheduleEntryType getEntryType() {
		return entryType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEntryType(ScheduleEntryType newEntryType) {
		ScheduleEntryType oldEntryType = entryType;
		entryType = newEntryType == null ? ENTRY_TYPE_EDEFAULT : newEntryType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_TYPE, oldEntryType, entryType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PickUpDropOffType getPickUpType() {
		return pickUpType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPickUpType(PickUpDropOffType newPickUpType) {
		PickUpDropOffType oldPickUpType = pickUpType;
		pickUpType = newPickUpType == null ? PICK_UP_TYPE_EDEFAULT : newPickUpType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__PICK_UP_TYPE, oldPickUpType, pickUpType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PickUpDropOffType getDropOffType() {
		return dropOffType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDropOffType(PickUpDropOffType newDropOffType) {
		PickUpDropOffType oldDropOffType = dropOffType;
		dropOffType = newDropOffType == null ? DROP_OFF_TYPE_EDEFAULT : newDropOffType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DROP_OFF_TYPE, oldDropOffType, dropOffType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StopInformation getRefStop() {
		return refStop;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRefStop(StopInformation newRefStop, NotificationChain msgs) {
		StopInformation oldRefStop = refStop;
		refStop = newRefStop;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP, oldRefStop, newRefStop);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRefStop(StopInformation newRefStop) {
		if (newRefStop != refStop) {
			NotificationChain msgs = null;
			if (refStop != null)
				msgs = ((InternalEObject)refStop).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP, null, msgs);
			if (newRefStop != null)
				msgs = ((InternalEObject)newRefStop).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP, null, msgs);
			msgs = basicSetRefStop(newRefStop, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP, newRefStop, newRefStop));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRefStopId() {
		return refStopId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRefStopId(String newRefStopId) {
		String oldRefStopId = refStopId;
		refStopId = newRefStopId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP_ID, oldRefStopId, refStopId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP:
				return basicSetRefStop(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_SCHEDULE_ID:
				return getRefScheduleId();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_INDEX:
				return getEntryIndex();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_SCHEDULED:
				return getArrivalScheduled();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_SCHEDULED:
				return getDepartureScheduled();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_DAY_AFTER_SCHEDULE_START:
				return getArrivalDayAfterScheduleStart();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_DAY_AFTER_SCHEDULE_START:
				return getDepartureDayAfterScheduleStart();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DWELL_TIME:
				return getDwellTime();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_TYPE:
				return getEntryType();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__PICK_UP_TYPE:
				return getPickUpType();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DROP_OFF_TYPE:
				return getDropOffType();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP:
				return getRefStop();
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP_ID:
				return getRefStopId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_SCHEDULE_ID:
				setRefScheduleId((String)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_INDEX:
				setEntryIndex((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_SCHEDULED:
				setArrivalScheduled((LocalTime)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_SCHEDULED:
				setDepartureScheduled((LocalTime)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_DAY_AFTER_SCHEDULE_START:
				setArrivalDayAfterScheduleStart((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_DAY_AFTER_SCHEDULE_START:
				setDepartureDayAfterScheduleStart((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DWELL_TIME:
				setDwellTime((Integer)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_TYPE:
				setEntryType((ScheduleEntryType)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__PICK_UP_TYPE:
				setPickUpType((PickUpDropOffType)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DROP_OFF_TYPE:
				setDropOffType((PickUpDropOffType)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP:
				setRefStop((StopInformation)newValue);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP_ID:
				setRefStopId((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_SCHEDULE_ID:
				setRefScheduleId(REF_SCHEDULE_ID_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_INDEX:
				setEntryIndex(ENTRY_INDEX_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_SCHEDULED:
				setArrivalScheduled(ARRIVAL_SCHEDULED_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_SCHEDULED:
				setDepartureScheduled(DEPARTURE_SCHEDULED_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_DAY_AFTER_SCHEDULE_START:
				setArrivalDayAfterScheduleStart(ARRIVAL_DAY_AFTER_SCHEDULE_START_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_DAY_AFTER_SCHEDULE_START:
				setDepartureDayAfterScheduleStart(DEPARTURE_DAY_AFTER_SCHEDULE_START_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DWELL_TIME:
				setDwellTime(DWELL_TIME_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_TYPE:
				setEntryType(ENTRY_TYPE_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__PICK_UP_TYPE:
				setPickUpType(PICK_UP_TYPE_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DROP_OFF_TYPE:
				setDropOffType(DROP_OFF_TYPE_EDEFAULT);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP:
				setRefStop((StopInformation)null);
				return;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP_ID:
				setRefStopId(REF_STOP_ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_SCHEDULE_ID:
				return REF_SCHEDULE_ID_EDEFAULT == null ? refScheduleId != null : !REF_SCHEDULE_ID_EDEFAULT.equals(refScheduleId);
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_INDEX:
				return entryIndex != ENTRY_INDEX_EDEFAULT;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_SCHEDULED:
				return ARRIVAL_SCHEDULED_EDEFAULT == null ? arrivalScheduled != null : !ARRIVAL_SCHEDULED_EDEFAULT.equals(arrivalScheduled);
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_SCHEDULED:
				return DEPARTURE_SCHEDULED_EDEFAULT == null ? departureScheduled != null : !DEPARTURE_SCHEDULED_EDEFAULT.equals(departureScheduled);
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ARRIVAL_DAY_AFTER_SCHEDULE_START:
				return arrivalDayAfterScheduleStart != ARRIVAL_DAY_AFTER_SCHEDULE_START_EDEFAULT;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DEPARTURE_DAY_AFTER_SCHEDULE_START:
				return departureDayAfterScheduleStart != DEPARTURE_DAY_AFTER_SCHEDULE_START_EDEFAULT;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DWELL_TIME:
				return dwellTime != DWELL_TIME_EDEFAULT;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__ENTRY_TYPE:
				return entryType != ENTRY_TYPE_EDEFAULT;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__PICK_UP_TYPE:
				return pickUpType != PICK_UP_TYPE_EDEFAULT;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__DROP_OFF_TYPE:
				return dropOffType != DROP_OFF_TYPE_EDEFAULT;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP:
				return refStop != null;
			case TOSPublicTransportApiPackage.SCHEDULE_ENTRY__REF_STOP_ID:
				return REF_STOP_ID_EDEFAULT == null ? refStopId != null : !REF_STOP_ID_EDEFAULT.equals(refStopId);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (refScheduleId: ");
		result.append(refScheduleId);
		result.append(", entryIndex: ");
		result.append(entryIndex);
		result.append(", arrivalScheduled: ");
		result.append(arrivalScheduled);
		result.append(", departureScheduled: ");
		result.append(departureScheduled);
		result.append(", arrivalDayAfterScheduleStart: ");
		result.append(arrivalDayAfterScheduleStart);
		result.append(", departureDayAfterScheduleStart: ");
		result.append(departureDayAfterScheduleStart);
		result.append(", dwellTime: ");
		result.append(dwellTime);
		result.append(", entryType: ");
		result.append(entryType);
		result.append(", pickUpType: ");
		result.append(pickUpType);
		result.append(", dropOffType: ");
		result.append(dropOffType);
		result.append(", refStopId: ");
		result.append(refStopId);
		result.append(')');
		return result.toString();
	}

} //ScheduleEntryImpl
