/*
 */
package de.jena.udp.model.trafficos.trafficlight;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Signal Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Different typs of traffic light signals
 * <!-- end-model-doc -->
 * @see de.jena.udp.model.trafficos.trafficlight.TOSTrafficLightPackage#getSignalType()
 * @model
 * @generated
 */
@ProviderType
public enum SignalType implements Enumerator {
	/**
	 * The '<em><b>RED AMBER GREEN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RED_AMBER_GREEN_VALUE
	 * @generated
	 * @ordered
	 */
	RED_AMBER_GREEN(0, "RED_AMBER_GREEN", "RED_AMBER_GREEN"),

	/**
	 * The '<em><b>RED GREEN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RED_GREEN_VALUE
	 * @generated
	 * @ordered
	 */
	RED_GREEN(1, "RED_GREEN", "RED_GREEN"),

	/**
	 * The '<em><b>JUMPING</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JUMPING_VALUE
	 * @generated
	 * @ordered
	 */
	JUMPING(2, "JUMPING", "JUMPING"),

	/**
	 * The '<em><b>SIGNAL IS COMING</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGNAL_IS_COMING_VALUE
	 * @generated
	 * @ordered
	 */
	SIGNAL_IS_COMING(3, "SIGNAL_IS_COMING", "SIGNAL_IS_COMING"),

	/**
	 * The '<em><b>ORIENTATION SOUND</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ORIENTATION_SOUND_VALUE
	 * @generated
	 * @ordered
	 */
	ORIENTATION_SOUND(4, "ORIENTATION_SOUND", "ORIENTATION_SOUND"),

	/**
	 * The '<em><b>BLINKING</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BLINKING_VALUE
	 * @generated
	 * @ordered
	 */
	BLINKING(5, "BLINKING", "BLINKING"),

	/**
	 * The '<em><b>BUTTON</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BUTTON_VALUE
	 * @generated
	 * @ordered
	 */
	BUTTON(6, "BUTTON", "BUTTON"),

	/**
	 * The '<em><b>BLIND BUTTON</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BLIND_BUTTON_VALUE
	 * @generated
	 * @ordered
	 */
	BLIND_BUTTON(7, "BLIND_BUTTON", "BLIND_BUTTON");

	/**
	 * The '<em><b>RED AMBER GREEN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RED_AMBER_GREEN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RED_AMBER_GREEN_VALUE = 0;

	/**
	 * The '<em><b>RED GREEN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RED_GREEN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RED_GREEN_VALUE = 1;

	/**
	 * The '<em><b>JUMPING</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JUMPING
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JUMPING_VALUE = 2;

	/**
	 * The '<em><b>SIGNAL IS COMING</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGNAL_IS_COMING
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL_IS_COMING_VALUE = 3;

	/**
	 * The '<em><b>ORIENTATION SOUND</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ORIENTATION_SOUND
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ORIENTATION_SOUND_VALUE = 4;

	/**
	 * The '<em><b>BLINKING</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BLINKING
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BLINKING_VALUE = 5;

	/**
	 * The '<em><b>BUTTON</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BUTTON
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BUTTON_VALUE = 6;

	/**
	 * The '<em><b>BLIND BUTTON</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BLIND_BUTTON
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BLIND_BUTTON_VALUE = 7;

	/**
	 * An array of all the '<em><b>Signal Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final SignalType[] VALUES_ARRAY =
		new SignalType[] {
			RED_AMBER_GREEN,
			RED_GREEN,
			JUMPING,
			SIGNAL_IS_COMING,
			ORIENTATION_SOUND,
			BLINKING,
			BUTTON,
			BLIND_BUTTON,
		};

	/**
	 * A public read-only list of all the '<em><b>Signal Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<SignalType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Signal Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static SignalType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			SignalType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Signal Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static SignalType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			SignalType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Signal Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static SignalType get(int value) {
		switch (value) {
			case RED_AMBER_GREEN_VALUE: return RED_AMBER_GREEN;
			case RED_GREEN_VALUE: return RED_GREEN;
			case JUMPING_VALUE: return JUMPING;
			case SIGNAL_IS_COMING_VALUE: return SIGNAL_IS_COMING;
			case ORIENTATION_SOUND_VALUE: return ORIENTATION_SOUND;
			case BLINKING_VALUE: return BLINKING;
			case BUTTON_VALUE: return BUTTON;
			case BLIND_BUTTON_VALUE: return BLIND_BUTTON;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private SignalType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //SignalType
