/*
 */
package de.jena.udp.model.trafficos.trafficlight.impl;

import de.jena.udp.model.trafficos.common.impl.OutputImpl;

import de.jena.udp.model.trafficos.trafficlight.SignalType;
import de.jena.udp.model.trafficos.trafficlight.TLSignal;
import de.jena.udp.model.trafficos.trafficlight.TLSignalGroup;
import de.jena.udp.model.trafficos.trafficlight.TOSTrafficLightPackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TL Signal</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalImpl#getChannel <em>Channel</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalImpl#getSignalGroup <em>Signal Group</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalImpl#getSignalType <em>Signal Type</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalImpl#getPositions <em>Positions</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TLSignalImpl extends OutputImpl implements TLSignal {
	/**
	 * The default value of the '{@link #getChannel() <em>Channel</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChannel()
	 * @generated
	 * @ordered
	 */
	protected static final String CHANNEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getChannel() <em>Channel</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChannel()
	 * @generated
	 * @ordered
	 */
	protected String channel = CHANNEL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSignalGroup() <em>Signal Group</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignalGroup()
	 * @generated
	 * @ordered
	 */
	protected TLSignalGroup signalGroup;

	/**
	 * The default value of the '{@link #getSignalType() <em>Signal Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignalType()
	 * @generated
	 * @ordered
	 */
	protected static final SignalType SIGNAL_TYPE_EDEFAULT = SignalType.RED_AMBER_GREEN;

	/**
	 * The cached value of the '{@link #getSignalType() <em>Signal Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignalType()
	 * @generated
	 * @ordered
	 */
	protected SignalType signalType = SIGNAL_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPositions() <em>Positions</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPositions()
	 * @generated
	 * @ordered
	 */
	protected EList<Integer> positions;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TLSignalImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TOSTrafficLightPackage.eINSTANCE.getTLSignal();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getChannel() {
		return channel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setChannel(String newChannel) {
		String oldChannel = channel;
		channel = newChannel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL__CHANNEL, oldChannel, channel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TLSignalGroup getSignalGroup() {
		return signalGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSignalGroup(TLSignalGroup newSignalGroup, NotificationChain msgs) {
		TLSignalGroup oldSignalGroup = signalGroup;
		signalGroup = newSignalGroup;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_GROUP, oldSignalGroup, newSignalGroup);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSignalGroup(TLSignalGroup newSignalGroup) {
		if (newSignalGroup != signalGroup) {
			NotificationChain msgs = null;
			if (signalGroup != null)
				msgs = ((InternalEObject)signalGroup).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_GROUP, null, msgs);
			if (newSignalGroup != null)
				msgs = ((InternalEObject)newSignalGroup).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_GROUP, null, msgs);
			msgs = basicSetSignalGroup(newSignalGroup, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_GROUP, newSignalGroup, newSignalGroup));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SignalType getSignalType() {
		return signalType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSignalType(SignalType newSignalType) {
		SignalType oldSignalType = signalType;
		signalType = newSignalType == null ? SIGNAL_TYPE_EDEFAULT : newSignalType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_TYPE, oldSignalType, signalType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Integer> getPositions() {
		if (positions == null) {
			positions = new EDataTypeUniqueEList<Integer>(Integer.class, this, TOSTrafficLightPackage.TL_SIGNAL__POSITIONS);
		}
		return positions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_GROUP:
				return basicSetSignalGroup(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL__CHANNEL:
				return getChannel();
			case TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_GROUP:
				return getSignalGroup();
			case TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_TYPE:
				return getSignalType();
			case TOSTrafficLightPackage.TL_SIGNAL__POSITIONS:
				return getPositions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL__CHANNEL:
				setChannel((String)newValue);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_GROUP:
				setSignalGroup((TLSignalGroup)newValue);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_TYPE:
				setSignalType((SignalType)newValue);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL__POSITIONS:
				getPositions().clear();
				getPositions().addAll((Collection<? extends Integer>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL__CHANNEL:
				setChannel(CHANNEL_EDEFAULT);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_GROUP:
				setSignalGroup((TLSignalGroup)null);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_TYPE:
				setSignalType(SIGNAL_TYPE_EDEFAULT);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL__POSITIONS:
				getPositions().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL__CHANNEL:
				return CHANNEL_EDEFAULT == null ? channel != null : !CHANNEL_EDEFAULT.equals(channel);
			case TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_GROUP:
				return signalGroup != null;
			case TOSTrafficLightPackage.TL_SIGNAL__SIGNAL_TYPE:
				return signalType != SIGNAL_TYPE_EDEFAULT;
			case TOSTrafficLightPackage.TL_SIGNAL__POSITIONS:
				return positions != null && !positions.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (channel: ");
		result.append(channel);
		result.append(", signalType: ");
		result.append(signalType);
		result.append(", positions: ");
		result.append(positions);
		result.append(')');
		return result.toString();
	}

} //TLSignalImpl
