/*
 */
package de.jena.udp.model.trafficos.trafficlight.impl;

import de.jena.udp.model.trafficos.trafficlight.SignalType;
import de.jena.udp.model.trafficos.trafficlight.TLSignalGroup;
import de.jena.udp.model.trafficos.trafficlight.TLSignalState;
import de.jena.udp.model.trafficos.trafficlight.TOSTrafficLightPackage;

import java.util.Collection;
import java.util.Date;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TL Signal State</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalStateImpl#getId <em>Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalStateImpl#getSignalGroup <em>Signal Group</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalStateImpl#getSignalType <em>Signal Type</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalStateImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalStateImpl#getState <em>State</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalStateImpl#getValues <em>Values</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TLSignalStateImpl extends MinimalEObjectImpl.Container implements TLSignalState {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSignalGroup() <em>Signal Group</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignalGroup()
	 * @generated
	 * @ordered
	 */
	protected TLSignalGroup signalGroup;

	/**
	 * The default value of the '{@link #getSignalType() <em>Signal Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignalType()
	 * @generated
	 * @ordered
	 */
	protected static final SignalType SIGNAL_TYPE_EDEFAULT = SignalType.RED_AMBER_GREEN;

	/**
	 * The cached value of the '{@link #getSignalType() <em>Signal Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignalType()
	 * @generated
	 * @ordered
	 */
	protected SignalType signalType = SIGNAL_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final Date TIMESTAMP_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected Date timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * The default value of the '{@link #getState() <em>State</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getState()
	 * @generated
	 * @ordered
	 */
	protected static final String STATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getState() <em>State</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getState()
	 * @generated
	 * @ordered
	 */
	protected String state = STATE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getValues() <em>Values</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValues()
	 * @generated
	 * @ordered
	 */
	protected EList<Boolean> values;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TLSignalStateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TOSTrafficLightPackage.eINSTANCE.getTLSignalState();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL_STATE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TLSignalGroup getSignalGroup() {
		return signalGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSignalGroup(TLSignalGroup newSignalGroup, NotificationChain msgs) {
		TLSignalGroup oldSignalGroup = signalGroup;
		signalGroup = newSignalGroup;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_GROUP, oldSignalGroup, newSignalGroup);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSignalGroup(TLSignalGroup newSignalGroup) {
		if (newSignalGroup != signalGroup) {
			NotificationChain msgs = null;
			if (signalGroup != null)
				msgs = ((InternalEObject)signalGroup).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_GROUP, null, msgs);
			if (newSignalGroup != null)
				msgs = ((InternalEObject)newSignalGroup).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_GROUP, null, msgs);
			msgs = basicSetSignalGroup(newSignalGroup, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_GROUP, newSignalGroup, newSignalGroup));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SignalType getSignalType() {
		return signalType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSignalType(SignalType newSignalType) {
		SignalType oldSignalType = signalType;
		signalType = newSignalType == null ? SIGNAL_TYPE_EDEFAULT : newSignalType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_TYPE, oldSignalType, signalType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Date getTimestamp() {
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTimestamp(Date newTimestamp) {
		Date oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL_STATE__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getState() {
		return state;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setState(String newState) {
		String oldState = state;
		state = newState;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_SIGNAL_STATE__STATE, oldState, state));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Boolean> getValues() {
		if (values == null) {
			values = new EDataTypeEList<Boolean>(Boolean.class, this, TOSTrafficLightPackage.TL_SIGNAL_STATE__VALUES);
		}
		return values;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_GROUP:
				return basicSetSignalGroup(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__ID:
				return getId();
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_GROUP:
				return getSignalGroup();
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_TYPE:
				return getSignalType();
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__TIMESTAMP:
				return getTimestamp();
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__STATE:
				return getState();
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__VALUES:
				return getValues();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__ID:
				setId((String)newValue);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_GROUP:
				setSignalGroup((TLSignalGroup)newValue);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_TYPE:
				setSignalType((SignalType)newValue);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__TIMESTAMP:
				setTimestamp((Date)newValue);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__STATE:
				setState((String)newValue);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__VALUES:
				getValues().clear();
				getValues().addAll((Collection<? extends Boolean>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__ID:
				setId(ID_EDEFAULT);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_GROUP:
				setSignalGroup((TLSignalGroup)null);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_TYPE:
				setSignalType(SIGNAL_TYPE_EDEFAULT);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__STATE:
				setState(STATE_EDEFAULT);
				return;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__VALUES:
				getValues().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_GROUP:
				return signalGroup != null;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__SIGNAL_TYPE:
				return signalType != SIGNAL_TYPE_EDEFAULT;
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__TIMESTAMP:
				return TIMESTAMP_EDEFAULT == null ? timestamp != null : !TIMESTAMP_EDEFAULT.equals(timestamp);
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__STATE:
				return STATE_EDEFAULT == null ? state != null : !STATE_EDEFAULT.equals(state);
			case TOSTrafficLightPackage.TL_SIGNAL_STATE__VALUES:
				return values != null && !values.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", signalType: ");
		result.append(signalType);
		result.append(", timestamp: ");
		result.append(timestamp);
		result.append(", state: ");
		result.append(state);
		result.append(", values: ");
		result.append(values);
		result.append(')');
		return result.toString();
	}

} //TLSignalStateImpl
