/**
 */
package de.jena.udp.model.trafficos.trafficlight.impl;

import de.jena.udp.model.trafficos.trafficlight.*;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class TOSTrafficLightFactoryImpl extends EFactoryImpl implements TOSTrafficLightFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TOSTrafficLightFactory init() {
		try {
			TOSTrafficLightFactory theTOSTrafficLightFactory = (TOSTrafficLightFactory)EPackage.Registry.INSTANCE.getEFactory(TOSTrafficLightPackage.eNS_URI);
			if (theTOSTrafficLightFactory != null) {
				return theTOSTrafficLightFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new TOSTrafficLightFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TOSTrafficLightFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case TOSTrafficLightPackage.TL_MODULE: return createTLModule();
			case TOSTrafficLightPackage.TL_SIGNAL_GROUP: return createTLSignalGroup();
			case TOSTrafficLightPackage.TL_SIGNAL: return createTLSignal();
			case TOSTrafficLightPackage.TL_SIGNAL_STATE: return createTLSignalState();
			case TOSTrafficLightPackage.TL_CONFIGURATION: return createTLConfiguration();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case TOSTrafficLightPackage.TL_MODULE_TYPE:
				return createTLModuleTypeFromString(eDataType, initialValue);
			case TOSTrafficLightPackage.SIGNAL_TYPE:
				return createSignalTypeFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case TOSTrafficLightPackage.TL_MODULE_TYPE:
				return convertTLModuleTypeToString(eDataType, instanceValue);
			case TOSTrafficLightPackage.SIGNAL_TYPE:
				return convertSignalTypeToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TLModule createTLModule() {
		TLModuleImpl tlModule = new TLModuleImpl();
		return tlModule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TLSignalGroup createTLSignalGroup() {
		TLSignalGroupImpl tlSignalGroup = new TLSignalGroupImpl();
		return tlSignalGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TLSignal createTLSignal() {
		TLSignalImpl tlSignal = new TLSignalImpl();
		return tlSignal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TLSignalState createTLSignalState() {
		TLSignalStateImpl tlSignalState = new TLSignalStateImpl();
		return tlSignalState;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TLConfiguration createTLConfiguration() {
		TLConfigurationImpl tlConfiguration = new TLConfigurationImpl();
		return tlConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TLModuleType createTLModuleTypeFromString(EDataType eDataType, String initialValue) {
		TLModuleType result = TLModuleType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTLModuleTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalType createSignalTypeFromString(EDataType eDataType, String initialValue) {
		SignalType result = SignalType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertSignalTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TOSTrafficLightPackage getTOSTrafficLightPackage() {
		return (TOSTrafficLightPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static TOSTrafficLightPackage getPackage() {
		return TOSTrafficLightPackage.eINSTANCE;
	}

} //TOSTrafficLightFactoryImpl
