/*
 */
package de.jena.udp.model.trafficos.trafficlight;

import de.jena.udp.model.trafficos.common.TOSCommonPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.jena.udp.model.trafficos.trafficlight.TOSTrafficLightFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/OCL/Import common='platform:/resource/de.jena.udp.trafficos.common.model/model/tos-common.ecore#/' ecore='http://www.eclipse.org/emf/2002/Ecore'"
 * @generated
 */
@ProviderType
@EPackage(uri = TOSTrafficLightPackage.eNS_URI, genModel = "/model/tos-trafficlight.genmodel")
public interface TOSTrafficLightPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "trafficlight";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://jena.de/udp/trafficos/trafficlight/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "trafficlight";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	TOSTrafficLightPackage eINSTANCE = de.jena.udp.model.trafficos.trafficlight.impl.TOSTrafficLightPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.trafficlight.impl.TLModuleImpl <em>TL Module</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TLModuleImpl
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TOSTrafficLightPackageImpl#getTLModule()
	 * @generated
	 */
	int TL_MODULE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_MODULE__ID = 0;

	/**
	 * The feature id for the '<em><b>Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_MODULE__ADDRESS = 1;

	/**
	 * The feature id for the '<em><b>Module Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_MODULE__MODULE_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Signals</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_MODULE__SIGNALS = 3;

	/**
	 * The number of structural features of the '<em>TL Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_MODULE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>TL Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_MODULE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalGroupImpl <em>TL Signal Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TLSignalGroupImpl
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TOSTrafficLightPackageImpl#getTLSignalGroup()
	 * @generated
	 */
	int TL_SIGNAL_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_GROUP__ID = 0;

	/**
	 * The number of structural features of the '<em>TL Signal Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_GROUP_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>TL Signal Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalImpl <em>TL Signal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TLSignalImpl
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TOSTrafficLightPackageImpl#getTLSignal()
	 * @generated
	 */
	int TL_SIGNAL = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__ID = TOSCommonPackage.OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__NAME = TOSCommonPackage.OUTPUT__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__LOCATION = TOSCommonPackage.OUTPUT__LOCATION;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__DESCRIPTION = TOSCommonPackage.OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__TYPE = TOSCommonPackage.OUTPUT__TYPE;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__DEFAULT_VALUE = TOSCommonPackage.OUTPUT__DEFAULT_VALUE;

	/**
	 * The feature id for the '<em><b>Channel</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__CHANNEL = TOSCommonPackage.OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Signal Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__SIGNAL_GROUP = TOSCommonPackage.OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Signal Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__SIGNAL_TYPE = TOSCommonPackage.OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Positions</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL__POSITIONS = TOSCommonPackage.OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>TL Signal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_FEATURE_COUNT = TOSCommonPackage.OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>TL Signal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_OPERATION_COUNT = TOSCommonPackage.OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.trafficlight.impl.TLSignalStateImpl <em>TL Signal State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TLSignalStateImpl
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TOSTrafficLightPackageImpl#getTLSignalState()
	 * @generated
	 */
	int TL_SIGNAL_STATE = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_STATE__ID = 0;

	/**
	 * The feature id for the '<em><b>Signal Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_STATE__SIGNAL_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Signal Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_STATE__SIGNAL_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_STATE__TIMESTAMP = 3;

	/**
	 * The feature id for the '<em><b>State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_STATE__STATE = 4;

	/**
	 * The feature id for the '<em><b>Values</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_STATE__VALUES = 5;

	/**
	 * The number of structural features of the '<em>TL Signal State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_STATE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>TL Signal State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_SIGNAL_STATE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.trafficlight.impl.TLConfigurationImpl <em>TL Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TLConfigurationImpl
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TOSTrafficLightPackageImpl#getTLConfiguration()
	 * @generated
	 */
	int TL_CONFIGURATION = 4;

	/**
	 * The feature id for the '<em><b>Intersection Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_CONFIGURATION__INTERSECTION_ID = 0;

	/**
	 * The feature id for the '<em><b>Intersection Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_CONFIGURATION__INTERSECTION_NAME = 1;

	/**
	 * The feature id for the '<em><b>Modules</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_CONFIGURATION__MODULES = 2;

	/**
	 * The feature id for the '<em><b>Signal Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_CONFIGURATION__SIGNAL_GROUPS = 3;

	/**
	 * The number of structural features of the '<em>TL Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_CONFIGURATION_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>TL Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TL_CONFIGURATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.trafficlight.TLModuleType <em>TL Module Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.trafficlight.TLModuleType
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TOSTrafficLightPackageImpl#getTLModuleType()
	 * @generated
	 */
	int TL_MODULE_TYPE = 5;

	/**
	 * The meta object id for the '{@link de.jena.udp.model.trafficos.trafficlight.SignalType <em>Signal Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.jena.udp.model.trafficos.trafficlight.SignalType
	 * @see de.jena.udp.model.trafficos.trafficlight.impl.TOSTrafficLightPackageImpl#getSignalType()
	 * @generated
	 */
	int SIGNAL_TYPE = 6;


	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.trafficlight.TLModule <em>TL Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TL Module</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLModule
	 * @generated
	 */
	EClass getTLModule();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLModule#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLModule#getId()
	 * @see #getTLModule()
	 * @generated
	 */
	EAttribute getTLModule_Id();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLModule#getAddress <em>Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLModule#getAddress()
	 * @see #getTLModule()
	 * @generated
	 */
	EAttribute getTLModule_Address();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLModule#getModuleType <em>Module Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Module Type</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLModule#getModuleType()
	 * @see #getTLModule()
	 * @generated
	 */
	EAttribute getTLModule_ModuleType();

	/**
	 * Returns the meta object for the containment reference list '{@link de.jena.udp.model.trafficos.trafficlight.TLModule#getSignals <em>Signals</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Signals</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLModule#getSignals()
	 * @see #getTLModule()
	 * @generated
	 */
	EReference getTLModule_Signals();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.trafficlight.TLSignalGroup <em>TL Signal Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TL Signal Group</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignalGroup
	 * @generated
	 */
	EClass getTLSignalGroup();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLSignalGroup#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignalGroup#getId()
	 * @see #getTLSignalGroup()
	 * @generated
	 */
	EAttribute getTLSignalGroup_Id();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.trafficlight.TLSignal <em>TL Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TL Signal</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignal
	 * @generated
	 */
	EClass getTLSignal();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLSignal#getChannel <em>Channel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Channel</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignal#getChannel()
	 * @see #getTLSignal()
	 * @generated
	 */
	EAttribute getTLSignal_Channel();

	/**
	 * Returns the meta object for the containment reference '{@link de.jena.udp.model.trafficos.trafficlight.TLSignal#getSignalGroup <em>Signal Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Signal Group</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignal#getSignalGroup()
	 * @see #getTLSignal()
	 * @generated
	 */
	EReference getTLSignal_SignalGroup();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLSignal#getSignalType <em>Signal Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Signal Type</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignal#getSignalType()
	 * @see #getTLSignal()
	 * @generated
	 */
	EAttribute getTLSignal_SignalType();

	/**
	 * Returns the meta object for the attribute list '{@link de.jena.udp.model.trafficos.trafficlight.TLSignal#getPositions <em>Positions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Positions</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignal#getPositions()
	 * @see #getTLSignal()
	 * @generated
	 */
	EAttribute getTLSignal_Positions();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.trafficlight.TLSignalState <em>TL Signal State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TL Signal State</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignalState
	 * @generated
	 */
	EClass getTLSignalState();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLSignalState#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignalState#getId()
	 * @see #getTLSignalState()
	 * @generated
	 */
	EAttribute getTLSignalState_Id();

	/**
	 * Returns the meta object for the containment reference '{@link de.jena.udp.model.trafficos.trafficlight.TLSignalState#getSignalGroup <em>Signal Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Signal Group</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignalState#getSignalGroup()
	 * @see #getTLSignalState()
	 * @generated
	 */
	EReference getTLSignalState_SignalGroup();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLSignalState#getSignalType <em>Signal Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Signal Type</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignalState#getSignalType()
	 * @see #getTLSignalState()
	 * @generated
	 */
	EAttribute getTLSignalState_SignalType();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLSignalState#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignalState#getTimestamp()
	 * @see #getTLSignalState()
	 * @generated
	 */
	EAttribute getTLSignalState_Timestamp();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLSignalState#getState <em>State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignalState#getState()
	 * @see #getTLSignalState()
	 * @generated
	 */
	EAttribute getTLSignalState_State();

	/**
	 * Returns the meta object for the attribute list '{@link de.jena.udp.model.trafficos.trafficlight.TLSignalState#getValues <em>Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Values</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLSignalState#getValues()
	 * @see #getTLSignalState()
	 * @generated
	 */
	EAttribute getTLSignalState_Values();

	/**
	 * Returns the meta object for class '{@link de.jena.udp.model.trafficos.trafficlight.TLConfiguration <em>TL Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TL Configuration</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLConfiguration
	 * @generated
	 */
	EClass getTLConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLConfiguration#getIntersectionId <em>Intersection Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Intersection Id</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLConfiguration#getIntersectionId()
	 * @see #getTLConfiguration()
	 * @generated
	 */
	EAttribute getTLConfiguration_IntersectionId();

	/**
	 * Returns the meta object for the attribute '{@link de.jena.udp.model.trafficos.trafficlight.TLConfiguration#getIntersectionName <em>Intersection Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Intersection Name</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLConfiguration#getIntersectionName()
	 * @see #getTLConfiguration()
	 * @generated
	 */
	EAttribute getTLConfiguration_IntersectionName();

	/**
	 * Returns the meta object for the containment reference list '{@link de.jena.udp.model.trafficos.trafficlight.TLConfiguration#getModules <em>Modules</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Modules</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLConfiguration#getModules()
	 * @see #getTLConfiguration()
	 * @generated
	 */
	EReference getTLConfiguration_Modules();

	/**
	 * Returns the meta object for the containment reference list '{@link de.jena.udp.model.trafficos.trafficlight.TLConfiguration#getSignalGroups <em>Signal Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Signal Groups</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLConfiguration#getSignalGroups()
	 * @see #getTLConfiguration()
	 * @generated
	 */
	EReference getTLConfiguration_SignalGroups();

	/**
	 * Returns the meta object for enum '{@link de.jena.udp.model.trafficos.trafficlight.TLModuleType <em>TL Module Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>TL Module Type</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.TLModuleType
	 * @generated
	 */
	EEnum getTLModuleType();

	/**
	 * Returns the meta object for enum '{@link de.jena.udp.model.trafficos.trafficlight.SignalType <em>Signal Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Signal Type</em>'.
	 * @see de.jena.udp.model.trafficos.trafficlight.SignalType
	 * @generated
	 */
	EEnum getSignalType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	TOSTrafficLightFactory getTOSTrafficLightFactory();

} //TOSTrafficLightPackage
