/*
 */
package de.jena.udp.model.trafficos.trafficlight.impl;

import de.jena.udp.model.trafficos.trafficlight.TLConfiguration;
import de.jena.udp.model.trafficos.trafficlight.TLModule;
import de.jena.udp.model.trafficos.trafficlight.TLSignalGroup;
import de.jena.udp.model.trafficos.trafficlight.TOSTrafficLightPackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TL Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLConfigurationImpl#getIntersectionId <em>Intersection Id</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLConfigurationImpl#getIntersectionName <em>Intersection Name</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLConfigurationImpl#getModules <em>Modules</em>}</li>
 *   <li>{@link de.jena.udp.model.trafficos.trafficlight.impl.TLConfigurationImpl#getSignalGroups <em>Signal Groups</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TLConfigurationImpl extends MinimalEObjectImpl.Container implements TLConfiguration {
	/**
	 * The default value of the '{@link #getIntersectionId() <em>Intersection Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIntersectionId()
	 * @generated
	 * @ordered
	 */
	protected static final String INTERSECTION_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIntersectionId() <em>Intersection Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIntersectionId()
	 * @generated
	 * @ordered
	 */
	protected String intersectionId = INTERSECTION_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getIntersectionName() <em>Intersection Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIntersectionName()
	 * @generated
	 * @ordered
	 */
	protected static final String INTERSECTION_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIntersectionName() <em>Intersection Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIntersectionName()
	 * @generated
	 * @ordered
	 */
	protected String intersectionName = INTERSECTION_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getModules() <em>Modules</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModules()
	 * @generated
	 * @ordered
	 */
	protected EList<TLModule> modules;

	/**
	 * The cached value of the '{@link #getSignalGroups() <em>Signal Groups</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignalGroups()
	 * @generated
	 * @ordered
	 */
	protected EList<TLSignalGroup> signalGroups;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TLConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TOSTrafficLightPackage.eINSTANCE.getTLConfiguration();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getIntersectionId() {
		return intersectionId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIntersectionId(String newIntersectionId) {
		String oldIntersectionId = intersectionId;
		intersectionId = newIntersectionId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_ID, oldIntersectionId, intersectionId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getIntersectionName() {
		return intersectionName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIntersectionName(String newIntersectionName) {
		String oldIntersectionName = intersectionName;
		intersectionName = newIntersectionName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_NAME, oldIntersectionName, intersectionName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TLModule> getModules() {
		if (modules == null) {
			modules = new EObjectContainmentEList<TLModule>(TLModule.class, this, TOSTrafficLightPackage.TL_CONFIGURATION__MODULES);
		}
		return modules;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TLSignalGroup> getSignalGroups() {
		if (signalGroups == null) {
			signalGroups = new EObjectContainmentEList<TLSignalGroup>(TLSignalGroup.class, this, TOSTrafficLightPackage.TL_CONFIGURATION__SIGNAL_GROUPS);
		}
		return signalGroups;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_CONFIGURATION__MODULES:
				return ((InternalEList<?>)getModules()).basicRemove(otherEnd, msgs);
			case TOSTrafficLightPackage.TL_CONFIGURATION__SIGNAL_GROUPS:
				return ((InternalEList<?>)getSignalGroups()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_ID:
				return getIntersectionId();
			case TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_NAME:
				return getIntersectionName();
			case TOSTrafficLightPackage.TL_CONFIGURATION__MODULES:
				return getModules();
			case TOSTrafficLightPackage.TL_CONFIGURATION__SIGNAL_GROUPS:
				return getSignalGroups();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_ID:
				setIntersectionId((String)newValue);
				return;
			case TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_NAME:
				setIntersectionName((String)newValue);
				return;
			case TOSTrafficLightPackage.TL_CONFIGURATION__MODULES:
				getModules().clear();
				getModules().addAll((Collection<? extends TLModule>)newValue);
				return;
			case TOSTrafficLightPackage.TL_CONFIGURATION__SIGNAL_GROUPS:
				getSignalGroups().clear();
				getSignalGroups().addAll((Collection<? extends TLSignalGroup>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_ID:
				setIntersectionId(INTERSECTION_ID_EDEFAULT);
				return;
			case TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_NAME:
				setIntersectionName(INTERSECTION_NAME_EDEFAULT);
				return;
			case TOSTrafficLightPackage.TL_CONFIGURATION__MODULES:
				getModules().clear();
				return;
			case TOSTrafficLightPackage.TL_CONFIGURATION__SIGNAL_GROUPS:
				getSignalGroups().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_ID:
				return INTERSECTION_ID_EDEFAULT == null ? intersectionId != null : !INTERSECTION_ID_EDEFAULT.equals(intersectionId);
			case TOSTrafficLightPackage.TL_CONFIGURATION__INTERSECTION_NAME:
				return INTERSECTION_NAME_EDEFAULT == null ? intersectionName != null : !INTERSECTION_NAME_EDEFAULT.equals(intersectionName);
			case TOSTrafficLightPackage.TL_CONFIGURATION__MODULES:
				return modules != null && !modules.isEmpty();
			case TOSTrafficLightPackage.TL_CONFIGURATION__SIGNAL_GROUPS:
				return signalGroups != null && !signalGroups.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (intersectionId: ");
		result.append(intersectionId);
		result.append(", intersectionName: ");
		result.append(intersectionName);
		result.append(')');
		return result.toString();
	}

} //TLConfigurationImpl
