/**
 */
package de.jena.udp.model.trafficos.trafficlight.impl;

import de.jena.udp.model.trafficos.common.TOSCommonPackage;

import de.jena.udp.model.trafficos.trafficlight.SignalType;
import de.jena.udp.model.trafficos.trafficlight.TLConfiguration;
import de.jena.udp.model.trafficos.trafficlight.TLModule;
import de.jena.udp.model.trafficos.trafficlight.TLModuleType;
import de.jena.udp.model.trafficos.trafficlight.TLSignal;
import de.jena.udp.model.trafficos.trafficlight.TLSignalGroup;
import de.jena.udp.model.trafficos.trafficlight.TLSignalState;
import de.jena.udp.model.trafficos.trafficlight.TOSTrafficLightFactory;
import de.jena.udp.model.trafficos.trafficlight.TOSTrafficLightPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class TOSTrafficLightPackageImpl extends EPackageImpl implements TOSTrafficLightPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass tlModuleEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass tlSignalGroupEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass tlSignalEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass tlSignalStateEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass tlConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum tlModuleTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum signalTypeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.jena.udp.model.trafficos.trafficlight.TOSTrafficLightPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private TOSTrafficLightPackageImpl() {
		super(eNS_URI, TOSTrafficLightFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link TOSTrafficLightPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static TOSTrafficLightPackage init() {
		if (isInited) return (TOSTrafficLightPackage)EPackage.Registry.INSTANCE.getEPackage(TOSTrafficLightPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredTOSTrafficLightPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		TOSTrafficLightPackageImpl theTOSTrafficLightPackage = registeredTOSTrafficLightPackage instanceof TOSTrafficLightPackageImpl ? (TOSTrafficLightPackageImpl)registeredTOSTrafficLightPackage : new TOSTrafficLightPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		TOSCommonPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theTOSTrafficLightPackage.createPackageContents();

		// Initialize created meta-data
		theTOSTrafficLightPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theTOSTrafficLightPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(TOSTrafficLightPackage.eNS_URI, theTOSTrafficLightPackage);
		return theTOSTrafficLightPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTLModule() {
		return tlModuleEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLModule_Id() {
		return (EAttribute)tlModuleEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLModule_Address() {
		return (EAttribute)tlModuleEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLModule_ModuleType() {
		return (EAttribute)tlModuleEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTLModule_Signals() {
		return (EReference)tlModuleEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTLSignalGroup() {
		return tlSignalGroupEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLSignalGroup_Id() {
		return (EAttribute)tlSignalGroupEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTLSignal() {
		return tlSignalEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLSignal_Channel() {
		return (EAttribute)tlSignalEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTLSignal_SignalGroup() {
		return (EReference)tlSignalEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLSignal_SignalType() {
		return (EAttribute)tlSignalEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLSignal_Positions() {
		return (EAttribute)tlSignalEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTLSignalState() {
		return tlSignalStateEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLSignalState_Id() {
		return (EAttribute)tlSignalStateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTLSignalState_SignalGroup() {
		return (EReference)tlSignalStateEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLSignalState_SignalType() {
		return (EAttribute)tlSignalStateEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLSignalState_Timestamp() {
		return (EAttribute)tlSignalStateEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLSignalState_State() {
		return (EAttribute)tlSignalStateEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLSignalState_Values() {
		return (EAttribute)tlSignalStateEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTLConfiguration() {
		return tlConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLConfiguration_IntersectionId() {
		return (EAttribute)tlConfigurationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTLConfiguration_IntersectionName() {
		return (EAttribute)tlConfigurationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTLConfiguration_Modules() {
		return (EReference)tlConfigurationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTLConfiguration_SignalGroups() {
		return (EReference)tlConfigurationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getTLModuleType() {
		return tlModuleTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getSignalType() {
		return signalTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TOSTrafficLightFactory getTOSTrafficLightFactory() {
		return (TOSTrafficLightFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		tlModuleEClass = createEClass(TL_MODULE);
		createEAttribute(tlModuleEClass, TL_MODULE__ID);
		createEAttribute(tlModuleEClass, TL_MODULE__ADDRESS);
		createEAttribute(tlModuleEClass, TL_MODULE__MODULE_TYPE);
		createEReference(tlModuleEClass, TL_MODULE__SIGNALS);

		tlSignalGroupEClass = createEClass(TL_SIGNAL_GROUP);
		createEAttribute(tlSignalGroupEClass, TL_SIGNAL_GROUP__ID);

		tlSignalEClass = createEClass(TL_SIGNAL);
		createEAttribute(tlSignalEClass, TL_SIGNAL__CHANNEL);
		createEReference(tlSignalEClass, TL_SIGNAL__SIGNAL_GROUP);
		createEAttribute(tlSignalEClass, TL_SIGNAL__SIGNAL_TYPE);
		createEAttribute(tlSignalEClass, TL_SIGNAL__POSITIONS);

		tlSignalStateEClass = createEClass(TL_SIGNAL_STATE);
		createEAttribute(tlSignalStateEClass, TL_SIGNAL_STATE__ID);
		createEReference(tlSignalStateEClass, TL_SIGNAL_STATE__SIGNAL_GROUP);
		createEAttribute(tlSignalStateEClass, TL_SIGNAL_STATE__SIGNAL_TYPE);
		createEAttribute(tlSignalStateEClass, TL_SIGNAL_STATE__TIMESTAMP);
		createEAttribute(tlSignalStateEClass, TL_SIGNAL_STATE__STATE);
		createEAttribute(tlSignalStateEClass, TL_SIGNAL_STATE__VALUES);

		tlConfigurationEClass = createEClass(TL_CONFIGURATION);
		createEAttribute(tlConfigurationEClass, TL_CONFIGURATION__INTERSECTION_ID);
		createEAttribute(tlConfigurationEClass, TL_CONFIGURATION__INTERSECTION_NAME);
		createEReference(tlConfigurationEClass, TL_CONFIGURATION__MODULES);
		createEReference(tlConfigurationEClass, TL_CONFIGURATION__SIGNAL_GROUPS);

		// Create enums
		tlModuleTypeEEnum = createEEnum(TL_MODULE_TYPE);
		signalTypeEEnum = createEEnum(SIGNAL_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		TOSCommonPackage theTOSCommonPackage = (TOSCommonPackage)EPackage.Registry.INSTANCE.getEPackage(TOSCommonPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		tlSignalEClass.getESuperTypes().add(theTOSCommonPackage.getOutput());

		// Initialize classes, features, and operations; add parameters
		initEClass(tlModuleEClass, TLModule.class, "TLModule", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTLModule_Id(), ecorePackage.getEString(), "id", null, 1, 1, TLModule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTLModule_Address(), ecorePackage.getEInt(), "address", null, 1, 1, TLModule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTLModule_ModuleType(), this.getTLModuleType(), "moduleType", null, 0, 1, TLModule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTLModule_Signals(), this.getTLSignal(), null, "signals", null, 0, -1, TLModule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(tlSignalGroupEClass, TLSignalGroup.class, "TLSignalGroup", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTLSignalGroup_Id(), ecorePackage.getEString(), "id", null, 1, 1, TLSignalGroup.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(tlSignalEClass, TLSignal.class, "TLSignal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTLSignal_Channel(), ecorePackage.getEString(), "channel", null, 0, 1, TLSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTLSignal_SignalGroup(), this.getTLSignalGroup(), null, "signalGroup", null, 0, 1, TLSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTLSignal_SignalType(), this.getSignalType(), "signalType", null, 0, 1, TLSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTLSignal_Positions(), ecorePackage.getEInt(), "positions", null, 0, 3, TLSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(tlSignalStateEClass, TLSignalState.class, "TLSignalState", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTLSignalState_Id(), ecorePackage.getEString(), "id", null, 0, 1, TLSignalState.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTLSignalState_SignalGroup(), this.getTLSignalGroup(), null, "signalGroup", null, 0, 1, TLSignalState.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTLSignalState_SignalType(), this.getSignalType(), "signalType", null, 0, 1, TLSignalState.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTLSignalState_Timestamp(), ecorePackage.getEDate(), "timestamp", null, 0, 1, TLSignalState.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTLSignalState_State(), ecorePackage.getEString(), "state", null, 0, 1, TLSignalState.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTLSignalState_Values(), ecorePackage.getEBoolean(), "values", null, 1, 3, TLSignalState.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(tlConfigurationEClass, TLConfiguration.class, "TLConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTLConfiguration_IntersectionId(), ecorePackage.getEString(), "intersectionId", null, 1, 1, TLConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTLConfiguration_IntersectionName(), ecorePackage.getEString(), "intersectionName", null, 0, 1, TLConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTLConfiguration_Modules(), this.getTLModule(), null, "modules", null, 0, -1, TLConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTLConfiguration_SignalGroups(), this.getTLSignalGroup(), null, "signalGroups", null, 0, -1, TLConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(tlModuleTypeEEnum, TLModuleType.class, "TLModuleType");
		addEEnumLiteral(tlModuleTypeEEnum, TLModuleType.LML);
		addEEnumLiteral(tlModuleTypeEEnum, TLModuleType.FDL);

		initEEnum(signalTypeEEnum, SignalType.class, "SignalType");
		addEEnumLiteral(signalTypeEEnum, SignalType.RED_AMBER_GREEN);
		addEEnumLiteral(signalTypeEEnum, SignalType.RED_GREEN);
		addEEnumLiteral(signalTypeEEnum, SignalType.JUMPING);
		addEEnumLiteral(signalTypeEEnum, SignalType.SIGNAL_IS_COMING);
		addEEnumLiteral(signalTypeEEnum, SignalType.ORIENTATION_SOUND);
		addEEnumLiteral(signalTypeEEnum, SignalType.BLINKING);
		addEEnumLiteral(signalTypeEEnum, SignalType.BUTTON);
		addEEnumLiteral(signalTypeEEnum, SignalType.BLIND_BUTTON);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/OCL/Import
		createImportAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/OCL/Import</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createImportAnnotations() {
		String source = "http://www.eclipse.org/OCL/Import";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "common", "platform:/resource/de.jena.udp.trafficos.common.model/model/tos-common.ecore#/",
			   "ecore", "http://www.eclipse.org/emf/2002/Ecore"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (signalTypeEEnum,
		   source,
		   new String[] {
			   "documentation", "Different typs of traffic light signals"
		   });
	}

} //TOSTrafficLightPackageImpl
