/*
 */
package de.jena.vdv454_2017c;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Besetztgrad Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getBesetztgradType()
 * @model extendedMetaData="name='BesetztgradType'"
 * @generated
 */
@ProviderType
public enum BesetztgradType implements Enumerator {
	/**
	 * The '<em><b>Schwach Besetzt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCHWACH_BESETZT_VALUE
	 * @generated
	 * @ordered
	 */
	SCHWACH_BESETZT(0, "SchwachBesetzt", "Schwach besetzt"),

	/**
	 * The '<em><b>Stark Besetzt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STARK_BESETZT_VALUE
	 * @generated
	 * @ordered
	 */
	STARK_BESETZT(1, "StarkBesetzt", "Stark besetzt"),

	/**
	 * The '<em><b>Überfüllt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ÜBERFÜLLT_VALUE
	 * @generated
	 * @ordered
	 */
	ÜBERFÜLLT(2, "Überfüllt", "\u00dcberf\u00fcllt"),

	/**
	 * The '<em><b>Unbekannt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNBEKANNT_VALUE
	 * @generated
	 * @ordered
	 */
	UNBEKANNT(3, "Unbekannt", "Unbekannt");

	/**
	 * The '<em><b>Schwach Besetzt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCHWACH_BESETZT
	 * @model name="SchwachBesetzt" literal="Schwach besetzt"
	 * @generated
	 * @ordered
	 */
	public static final int SCHWACH_BESETZT_VALUE = 0;

	/**
	 * The '<em><b>Stark Besetzt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STARK_BESETZT
	 * @model name="StarkBesetzt" literal="Stark besetzt"
	 * @generated
	 * @ordered
	 */
	public static final int STARK_BESETZT_VALUE = 1;

	/**
	 * The '<em><b>Überfüllt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ÜBERFÜLLT
	 * @model name="Überfüllt"
	 * @generated
	 * @ordered
	 */
	public static final int ÜBERFÜLLT_VALUE = 2;

	/**
	 * The '<em><b>Unbekannt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNBEKANNT
	 * @model name="Unbekannt"
	 * @generated
	 * @ordered
	 */
	public static final int UNBEKANNT_VALUE = 3;

	/**
	 * An array of all the '<em><b>Besetztgrad Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final BesetztgradType[] VALUES_ARRAY =
		new BesetztgradType[] {
			SCHWACH_BESETZT,
			STARK_BESETZT,
			ÜBERFÜLLT,
			UNBEKANNT,
		};

	/**
	 * A public read-only list of all the '<em><b>Besetztgrad Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<BesetztgradType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Besetztgrad Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static BesetztgradType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			BesetztgradType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Besetztgrad Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static BesetztgradType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			BesetztgradType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Besetztgrad Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static BesetztgradType get(int value) {
		switch (value) {
			case SCHWACH_BESETZT_VALUE: return SCHWACH_BESETZT;
			case STARK_BESETZT_VALUE: return STARK_BESETZT;
			case ÜBERFÜLLT_VALUE: return ÜBERFÜLLT;
			case UNBEKANNT_VALUE: return UNBEKANNT;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private BesetztgradType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //BesetztgradType
