/*
 */
package de.jena.vdv454_2017c;

import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Ist Halt Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getHaltID <em>Halt ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getHaltestellenName <em>Haltestellen Name</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getAbfahrtszeit <em>Abfahrtszeit</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getAnkunftszeit <em>Ankunftszeit</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtPrognose <em>Ist Abfahrt Prognose</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftPrognose <em>Ist Ankunft Prognose</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtPrognoseStatus <em>Ist Abfahrt Prognose Status</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftPrognoseStatus <em>Ist Ankunft Prognose Status</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtPrognoseQualitaet <em>Ist Abfahrt Prognose Qualitaet</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftPrognoseQualitaet <em>Ist Ankunft Prognose Qualitaet</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtDisposition <em>Ist Abfahrt Disposition</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftDisposition <em>Ist Ankunft Disposition</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getPrognoseUngenau <em>Prognose Ungenau</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getAbfahrtssteigText <em>Abfahrtssteig Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getAnkunftssteigText <em>Ankunftssteig Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getAbfahrtsSektorenText <em>Abfahrts Sektoren Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getAnkunftsSektorenText <em>Ankunfts Sektoren Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#isEinsteigeverbot <em>Einsteigeverbot</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#isAussteigeverbot <em>Aussteigeverbot</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#isDurchfahrt <em>Durchfahrt</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#isZusatzhalt <em>Zusatzhalt</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getRichtungsText <em>Richtungs Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getVonRichtungsText <em>Von Richtungs Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getHinweisText <em>Hinweis Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getLinienfahrwegID <em>Linienfahrweg ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getStoerungsInfo <em>Stoerungs Info</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.IstHaltType#getBesetztgrad <em>Besetztgrad</em>}</li>
 * </ul>
 *
 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType()
 * @model extendedMetaData="name='IstHaltType' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface IstHaltType extends EObject {
	/**
	 * Returns the value of the '<em><b>Halt ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Halt ID</em>' attribute.
	 * @see #setHaltID(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_HaltID()
	 * @model dataType="de.jena.vdv454_2017c.HaltIDType" required="true"
	 *        extendedMetaData="kind='element' name='HaltID' namespace='##targetNamespace'"
	 * @generated
	 */
	String getHaltID();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getHaltID <em>Halt ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Halt ID</em>' attribute.
	 * @see #getHaltID()
	 * @generated
	 */
	void setHaltID(String value);

	/**
	 * Returns the value of the '<em><b>Haltestellen Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Haltestellen Name</em>' attribute.
	 * @see #setHaltestellenName(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_HaltestellenName()
	 * @model dataType="de.jena.vdv454_2017c.HstLangType"
	 *        extendedMetaData="kind='element' name='HaltestellenName' namespace='##targetNamespace'"
	 * @generated
	 */
	String getHaltestellenName();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getHaltestellenName <em>Haltestellen Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Haltestellen Name</em>' attribute.
	 * @see #getHaltestellenName()
	 * @generated
	 */
	void setHaltestellenName(String value);

	/**
	 * Returns the value of the '<em><b>Abfahrtszeit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Abfahrtszeit</em>' attribute.
	 * @see #setAbfahrtszeit(XMLGregorianCalendar)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_Abfahrtszeit()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.DateTime"
	 *        extendedMetaData="kind='element' name='Abfahrtszeit' namespace='##targetNamespace'"
	 * @generated
	 */
	XMLGregorianCalendar getAbfahrtszeit();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getAbfahrtszeit <em>Abfahrtszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Abfahrtszeit</em>' attribute.
	 * @see #getAbfahrtszeit()
	 * @generated
	 */
	void setAbfahrtszeit(XMLGregorianCalendar value);

	/**
	 * Returns the value of the '<em><b>Ankunftszeit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ankunftszeit</em>' attribute.
	 * @see #setAnkunftszeit(XMLGregorianCalendar)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_Ankunftszeit()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.DateTime"
	 *        extendedMetaData="kind='element' name='Ankunftszeit' namespace='##targetNamespace'"
	 * @generated
	 */
	XMLGregorianCalendar getAnkunftszeit();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getAnkunftszeit <em>Ankunftszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ankunftszeit</em>' attribute.
	 * @see #getAnkunftszeit()
	 * @generated
	 */
	void setAnkunftszeit(XMLGregorianCalendar value);

	/**
	 * Returns the value of the '<em><b>Ist Abfahrt Prognose</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ist Abfahrt Prognose</em>' attribute.
	 * @see #setIstAbfahrtPrognose(XMLGregorianCalendar)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_IstAbfahrtPrognose()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.DateTime"
	 *        extendedMetaData="kind='element' name='IstAbfahrtPrognose' namespace='##targetNamespace'"
	 * @generated
	 */
	XMLGregorianCalendar getIstAbfahrtPrognose();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtPrognose <em>Ist Abfahrt Prognose</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ist Abfahrt Prognose</em>' attribute.
	 * @see #getIstAbfahrtPrognose()
	 * @generated
	 */
	void setIstAbfahrtPrognose(XMLGregorianCalendar value);

	/**
	 * Returns the value of the '<em><b>Ist Ankunft Prognose</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ist Ankunft Prognose</em>' attribute.
	 * @see #setIstAnkunftPrognose(XMLGregorianCalendar)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_IstAnkunftPrognose()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.DateTime"
	 *        extendedMetaData="kind='element' name='IstAnkunftPrognose' namespace='##targetNamespace'"
	 * @generated
	 */
	XMLGregorianCalendar getIstAnkunftPrognose();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftPrognose <em>Ist Ankunft Prognose</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ist Ankunft Prognose</em>' attribute.
	 * @see #getIstAnkunftPrognose()
	 * @generated
	 */
	void setIstAnkunftPrognose(XMLGregorianCalendar value);

	/**
	 * Returns the value of the '<em><b>Ist Abfahrt Prognose Status</b></em>' attribute.
	 * The literals are from the enumeration {@link de.jena.vdv454_2017c.PrognoseStatusType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ist Abfahrt Prognose Status</em>' attribute.
	 * @see de.jena.vdv454_2017c.PrognoseStatusType
	 * @see #isSetIstAbfahrtPrognoseStatus()
	 * @see #unsetIstAbfahrtPrognoseStatus()
	 * @see #setIstAbfahrtPrognoseStatus(PrognoseStatusType)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_IstAbfahrtPrognoseStatus()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='element' name='IstAbfahrtPrognoseStatus' namespace='##targetNamespace'"
	 * @generated
	 */
	PrognoseStatusType getIstAbfahrtPrognoseStatus();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtPrognoseStatus <em>Ist Abfahrt Prognose Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ist Abfahrt Prognose Status</em>' attribute.
	 * @see de.jena.vdv454_2017c.PrognoseStatusType
	 * @see #isSetIstAbfahrtPrognoseStatus()
	 * @see #unsetIstAbfahrtPrognoseStatus()
	 * @see #getIstAbfahrtPrognoseStatus()
	 * @generated
	 */
	void setIstAbfahrtPrognoseStatus(PrognoseStatusType value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtPrognoseStatus <em>Ist Abfahrt Prognose Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetIstAbfahrtPrognoseStatus()
	 * @see #getIstAbfahrtPrognoseStatus()
	 * @see #setIstAbfahrtPrognoseStatus(PrognoseStatusType)
	 * @generated
	 */
	void unsetIstAbfahrtPrognoseStatus();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtPrognoseStatus <em>Ist Abfahrt Prognose Status</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Ist Abfahrt Prognose Status</em>' attribute is set.
	 * @see #unsetIstAbfahrtPrognoseStatus()
	 * @see #getIstAbfahrtPrognoseStatus()
	 * @see #setIstAbfahrtPrognoseStatus(PrognoseStatusType)
	 * @generated
	 */
	boolean isSetIstAbfahrtPrognoseStatus();

	/**
	 * Returns the value of the '<em><b>Ist Ankunft Prognose Status</b></em>' attribute.
	 * The literals are from the enumeration {@link de.jena.vdv454_2017c.PrognoseStatusType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ist Ankunft Prognose Status</em>' attribute.
	 * @see de.jena.vdv454_2017c.PrognoseStatusType
	 * @see #isSetIstAnkunftPrognoseStatus()
	 * @see #unsetIstAnkunftPrognoseStatus()
	 * @see #setIstAnkunftPrognoseStatus(PrognoseStatusType)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_IstAnkunftPrognoseStatus()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='element' name='IstAnkunftPrognoseStatus' namespace='##targetNamespace'"
	 * @generated
	 */
	PrognoseStatusType getIstAnkunftPrognoseStatus();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftPrognoseStatus <em>Ist Ankunft Prognose Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ist Ankunft Prognose Status</em>' attribute.
	 * @see de.jena.vdv454_2017c.PrognoseStatusType
	 * @see #isSetIstAnkunftPrognoseStatus()
	 * @see #unsetIstAnkunftPrognoseStatus()
	 * @see #getIstAnkunftPrognoseStatus()
	 * @generated
	 */
	void setIstAnkunftPrognoseStatus(PrognoseStatusType value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftPrognoseStatus <em>Ist Ankunft Prognose Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetIstAnkunftPrognoseStatus()
	 * @see #getIstAnkunftPrognoseStatus()
	 * @see #setIstAnkunftPrognoseStatus(PrognoseStatusType)
	 * @generated
	 */
	void unsetIstAnkunftPrognoseStatus();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftPrognoseStatus <em>Ist Ankunft Prognose Status</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Ist Ankunft Prognose Status</em>' attribute is set.
	 * @see #unsetIstAnkunftPrognoseStatus()
	 * @see #getIstAnkunftPrognoseStatus()
	 * @see #setIstAnkunftPrognoseStatus(PrognoseStatusType)
	 * @generated
	 */
	boolean isSetIstAnkunftPrognoseStatus();

	/**
	 * Returns the value of the '<em><b>Ist Abfahrt Prognose Qualitaet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ist Abfahrt Prognose Qualitaet</em>' containment reference.
	 * @see #setIstAbfahrtPrognoseQualitaet(ZeitQualitaetType)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_IstAbfahrtPrognoseQualitaet()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='IstAbfahrtPrognoseQualitaet' namespace='##targetNamespace'"
	 * @generated
	 */
	ZeitQualitaetType getIstAbfahrtPrognoseQualitaet();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtPrognoseQualitaet <em>Ist Abfahrt Prognose Qualitaet</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ist Abfahrt Prognose Qualitaet</em>' containment reference.
	 * @see #getIstAbfahrtPrognoseQualitaet()
	 * @generated
	 */
	void setIstAbfahrtPrognoseQualitaet(ZeitQualitaetType value);

	/**
	 * Returns the value of the '<em><b>Ist Ankunft Prognose Qualitaet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ist Ankunft Prognose Qualitaet</em>' containment reference.
	 * @see #setIstAnkunftPrognoseQualitaet(ZeitQualitaetType)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_IstAnkunftPrognoseQualitaet()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='IstAnkunftPrognoseQualitaet' namespace='##targetNamespace'"
	 * @generated
	 */
	ZeitQualitaetType getIstAnkunftPrognoseQualitaet();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftPrognoseQualitaet <em>Ist Ankunft Prognose Qualitaet</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ist Ankunft Prognose Qualitaet</em>' containment reference.
	 * @see #getIstAnkunftPrognoseQualitaet()
	 * @generated
	 */
	void setIstAnkunftPrognoseQualitaet(ZeitQualitaetType value);

	/**
	 * Returns the value of the '<em><b>Ist Abfahrt Disposition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ist Abfahrt Disposition</em>' attribute.
	 * @see #setIstAbfahrtDisposition(XMLGregorianCalendar)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_IstAbfahrtDisposition()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.DateTime"
	 *        extendedMetaData="kind='element' name='IstAbfahrtDisposition' namespace='##targetNamespace'"
	 * @generated
	 */
	XMLGregorianCalendar getIstAbfahrtDisposition();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAbfahrtDisposition <em>Ist Abfahrt Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ist Abfahrt Disposition</em>' attribute.
	 * @see #getIstAbfahrtDisposition()
	 * @generated
	 */
	void setIstAbfahrtDisposition(XMLGregorianCalendar value);

	/**
	 * Returns the value of the '<em><b>Ist Ankunft Disposition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ist Ankunft Disposition</em>' attribute.
	 * @see #setIstAnkunftDisposition(XMLGregorianCalendar)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_IstAnkunftDisposition()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.DateTime"
	 *        extendedMetaData="kind='element' name='IstAnkunftDisposition' namespace='##targetNamespace'"
	 * @generated
	 */
	XMLGregorianCalendar getIstAnkunftDisposition();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getIstAnkunftDisposition <em>Ist Ankunft Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ist Ankunft Disposition</em>' attribute.
	 * @see #getIstAnkunftDisposition()
	 * @generated
	 */
	void setIstAnkunftDisposition(XMLGregorianCalendar value);

	/**
	 * Returns the value of the '<em><b>Prognose Ungenau</b></em>' attribute.
	 * The literals are from the enumeration {@link de.jena.vdv454_2017c.PrognoseUngenauType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Prognose Ungenau</em>' attribute.
	 * @see de.jena.vdv454_2017c.PrognoseUngenauType
	 * @see #isSetPrognoseUngenau()
	 * @see #unsetPrognoseUngenau()
	 * @see #setPrognoseUngenau(PrognoseUngenauType)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_PrognoseUngenau()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='element' name='PrognoseUngenau' namespace='##targetNamespace'"
	 * @generated
	 */
	PrognoseUngenauType getPrognoseUngenau();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getPrognoseUngenau <em>Prognose Ungenau</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Prognose Ungenau</em>' attribute.
	 * @see de.jena.vdv454_2017c.PrognoseUngenauType
	 * @see #isSetPrognoseUngenau()
	 * @see #unsetPrognoseUngenau()
	 * @see #getPrognoseUngenau()
	 * @generated
	 */
	void setPrognoseUngenau(PrognoseUngenauType value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getPrognoseUngenau <em>Prognose Ungenau</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetPrognoseUngenau()
	 * @see #getPrognoseUngenau()
	 * @see #setPrognoseUngenau(PrognoseUngenauType)
	 * @generated
	 */
	void unsetPrognoseUngenau();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getPrognoseUngenau <em>Prognose Ungenau</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Prognose Ungenau</em>' attribute is set.
	 * @see #unsetPrognoseUngenau()
	 * @see #getPrognoseUngenau()
	 * @see #setPrognoseUngenau(PrognoseUngenauType)
	 * @generated
	 */
	boolean isSetPrognoseUngenau();

	/**
	 * Returns the value of the '<em><b>Abfahrtssteig Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Abfahrtssteig Text</em>' attribute.
	 * @see #setAbfahrtssteigText(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_AbfahrtssteigText()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='AbfahrtssteigText' namespace='##targetNamespace'"
	 * @generated
	 */
	String getAbfahrtssteigText();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getAbfahrtssteigText <em>Abfahrtssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Abfahrtssteig Text</em>' attribute.
	 * @see #getAbfahrtssteigText()
	 * @generated
	 */
	void setAbfahrtssteigText(String value);

	/**
	 * Returns the value of the '<em><b>Ankunftssteig Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ankunftssteig Text</em>' attribute.
	 * @see #setAnkunftssteigText(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_AnkunftssteigText()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='AnkunftssteigText' namespace='##targetNamespace'"
	 * @generated
	 */
	String getAnkunftssteigText();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getAnkunftssteigText <em>Ankunftssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ankunftssteig Text</em>' attribute.
	 * @see #getAnkunftssteigText()
	 * @generated
	 */
	void setAnkunftssteigText(String value);

	/**
	 * Returns the value of the '<em><b>Abfahrts Sektoren Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Abfahrts Sektoren Text</em>' attribute.
	 * @see #setAbfahrtsSektorenText(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_AbfahrtsSektorenText()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='AbfahrtsSektorenText' namespace='##targetNamespace'"
	 * @generated
	 */
	String getAbfahrtsSektorenText();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getAbfahrtsSektorenText <em>Abfahrts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Abfahrts Sektoren Text</em>' attribute.
	 * @see #getAbfahrtsSektorenText()
	 * @generated
	 */
	void setAbfahrtsSektorenText(String value);

	/**
	 * Returns the value of the '<em><b>Ankunfts Sektoren Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ankunfts Sektoren Text</em>' attribute.
	 * @see #setAnkunftsSektorenText(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_AnkunftsSektorenText()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='AnkunftsSektorenText' namespace='##targetNamespace'"
	 * @generated
	 */
	String getAnkunftsSektorenText();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getAnkunftsSektorenText <em>Ankunfts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ankunfts Sektoren Text</em>' attribute.
	 * @see #getAnkunftsSektorenText()
	 * @generated
	 */
	void setAnkunftsSektorenText(String value);

	/**
	 * Returns the value of the '<em><b>Einsteigeverbot</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Einsteigeverbot</em>' attribute.
	 * @see #isSetEinsteigeverbot()
	 * @see #unsetEinsteigeverbot()
	 * @see #setEinsteigeverbot(boolean)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_Einsteigeverbot()
	 * @model unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
	 *        extendedMetaData="kind='element' name='Einsteigeverbot' namespace='##targetNamespace'"
	 * @generated
	 */
	boolean isEinsteigeverbot();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isEinsteigeverbot <em>Einsteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Einsteigeverbot</em>' attribute.
	 * @see #isSetEinsteigeverbot()
	 * @see #unsetEinsteigeverbot()
	 * @see #isEinsteigeverbot()
	 * @generated
	 */
	void setEinsteigeverbot(boolean value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isEinsteigeverbot <em>Einsteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetEinsteigeverbot()
	 * @see #isEinsteigeverbot()
	 * @see #setEinsteigeverbot(boolean)
	 * @generated
	 */
	void unsetEinsteigeverbot();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isEinsteigeverbot <em>Einsteigeverbot</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Einsteigeverbot</em>' attribute is set.
	 * @see #unsetEinsteigeverbot()
	 * @see #isEinsteigeverbot()
	 * @see #setEinsteigeverbot(boolean)
	 * @generated
	 */
	boolean isSetEinsteigeverbot();

	/**
	 * Returns the value of the '<em><b>Aussteigeverbot</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Aussteigeverbot</em>' attribute.
	 * @see #isSetAussteigeverbot()
	 * @see #unsetAussteigeverbot()
	 * @see #setAussteigeverbot(boolean)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_Aussteigeverbot()
	 * @model unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
	 *        extendedMetaData="kind='element' name='Aussteigeverbot' namespace='##targetNamespace'"
	 * @generated
	 */
	boolean isAussteigeverbot();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isAussteigeverbot <em>Aussteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Aussteigeverbot</em>' attribute.
	 * @see #isSetAussteigeverbot()
	 * @see #unsetAussteigeverbot()
	 * @see #isAussteigeverbot()
	 * @generated
	 */
	void setAussteigeverbot(boolean value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isAussteigeverbot <em>Aussteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetAussteigeverbot()
	 * @see #isAussteigeverbot()
	 * @see #setAussteigeverbot(boolean)
	 * @generated
	 */
	void unsetAussteigeverbot();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isAussteigeverbot <em>Aussteigeverbot</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Aussteigeverbot</em>' attribute is set.
	 * @see #unsetAussteigeverbot()
	 * @see #isAussteigeverbot()
	 * @see #setAussteigeverbot(boolean)
	 * @generated
	 */
	boolean isSetAussteigeverbot();

	/**
	 * Returns the value of the '<em><b>Durchfahrt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Durchfahrt</em>' attribute.
	 * @see #isSetDurchfahrt()
	 * @see #unsetDurchfahrt()
	 * @see #setDurchfahrt(boolean)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_Durchfahrt()
	 * @model unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
	 *        extendedMetaData="kind='element' name='Durchfahrt' namespace='##targetNamespace'"
	 * @generated
	 */
	boolean isDurchfahrt();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isDurchfahrt <em>Durchfahrt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Durchfahrt</em>' attribute.
	 * @see #isSetDurchfahrt()
	 * @see #unsetDurchfahrt()
	 * @see #isDurchfahrt()
	 * @generated
	 */
	void setDurchfahrt(boolean value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isDurchfahrt <em>Durchfahrt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetDurchfahrt()
	 * @see #isDurchfahrt()
	 * @see #setDurchfahrt(boolean)
	 * @generated
	 */
	void unsetDurchfahrt();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isDurchfahrt <em>Durchfahrt</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Durchfahrt</em>' attribute is set.
	 * @see #unsetDurchfahrt()
	 * @see #isDurchfahrt()
	 * @see #setDurchfahrt(boolean)
	 * @generated
	 */
	boolean isSetDurchfahrt();

	/**
	 * Returns the value of the '<em><b>Zusatzhalt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Zusatzhalt</em>' attribute.
	 * @see #isSetZusatzhalt()
	 * @see #unsetZusatzhalt()
	 * @see #setZusatzhalt(boolean)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_Zusatzhalt()
	 * @model unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
	 *        extendedMetaData="kind='element' name='Zusatzhalt' namespace='##targetNamespace'"
	 * @generated
	 */
	boolean isZusatzhalt();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isZusatzhalt <em>Zusatzhalt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Zusatzhalt</em>' attribute.
	 * @see #isSetZusatzhalt()
	 * @see #unsetZusatzhalt()
	 * @see #isZusatzhalt()
	 * @generated
	 */
	void setZusatzhalt(boolean value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isZusatzhalt <em>Zusatzhalt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetZusatzhalt()
	 * @see #isZusatzhalt()
	 * @see #setZusatzhalt(boolean)
	 * @generated
	 */
	void unsetZusatzhalt();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.IstHaltType#isZusatzhalt <em>Zusatzhalt</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Zusatzhalt</em>' attribute is set.
	 * @see #unsetZusatzhalt()
	 * @see #isZusatzhalt()
	 * @see #setZusatzhalt(boolean)
	 * @generated
	 */
	boolean isSetZusatzhalt();

	/**
	 * Returns the value of the '<em><b>Richtungs Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Richtungs Text</em>' attribute.
	 * @see #setRichtungsText(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_RichtungsText()
	 * @model dataType="de.jena.vdv454_2017c.RichtungsTextType"
	 *        extendedMetaData="kind='element' name='RichtungsText' namespace='##targetNamespace'"
	 * @generated
	 */
	String getRichtungsText();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getRichtungsText <em>Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Richtungs Text</em>' attribute.
	 * @see #getRichtungsText()
	 * @generated
	 */
	void setRichtungsText(String value);

	/**
	 * Returns the value of the '<em><b>Von Richtungs Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Von Richtungs Text</em>' attribute.
	 * @see #setVonRichtungsText(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_VonRichtungsText()
	 * @model dataType="de.jena.vdv454_2017c.RichtungsTextType"
	 *        extendedMetaData="kind='element' name='VonRichtungsText' namespace='##targetNamespace'"
	 * @generated
	 */
	String getVonRichtungsText();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getVonRichtungsText <em>Von Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Von Richtungs Text</em>' attribute.
	 * @see #getVonRichtungsText()
	 * @generated
	 */
	void setVonRichtungsText(String value);

	/**
	 * Returns the value of the '<em><b>Hinweis Text</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Hinweis Text</em>' attribute list.
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_HinweisText()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='HinweisText' namespace='##targetNamespace'"
	 * @generated
	 */
	EList<String> getHinweisText();

	/**
	 * Returns the value of the '<em><b>Linienfahrweg ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Linienfahrweg ID</em>' attribute.
	 * @see #setLinienfahrwegID(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_LinienfahrwegID()
	 * @model dataType="de.jena.vdv454_2017c.LinienfahrwegIDType"
	 *        extendedMetaData="kind='element' name='LinienfahrwegID' namespace='##targetNamespace'"
	 * @generated
	 */
	String getLinienfahrwegID();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getLinienfahrwegID <em>Linienfahrweg ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Linienfahrweg ID</em>' attribute.
	 * @see #getLinienfahrwegID()
	 * @generated
	 */
	void setLinienfahrwegID(String value);

	/**
	 * Returns the value of the '<em><b>Stoerungs Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Stoerungs Info</em>' containment reference.
	 * @see #setStoerungsInfo(StoerungsInfoType)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_StoerungsInfo()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='StoerungsInfo' namespace='##targetNamespace'"
	 * @generated
	 */
	StoerungsInfoType getStoerungsInfo();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getStoerungsInfo <em>Stoerungs Info</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Stoerungs Info</em>' containment reference.
	 * @see #getStoerungsInfo()
	 * @generated
	 */
	void setStoerungsInfo(StoerungsInfoType value);

	/**
	 * Returns the value of the '<em><b>Besetztgrad</b></em>' attribute.
	 * The literals are from the enumeration {@link de.jena.vdv454_2017c.BesetztgradType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Besetztgrad</em>' attribute.
	 * @see de.jena.vdv454_2017c.BesetztgradType
	 * @see #isSetBesetztgrad()
	 * @see #unsetBesetztgrad()
	 * @see #setBesetztgrad(BesetztgradType)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getIstHaltType_Besetztgrad()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='element' name='Besetztgrad' namespace='##targetNamespace'"
	 * @generated
	 */
	BesetztgradType getBesetztgrad();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getBesetztgrad <em>Besetztgrad</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Besetztgrad</em>' attribute.
	 * @see de.jena.vdv454_2017c.BesetztgradType
	 * @see #isSetBesetztgrad()
	 * @see #unsetBesetztgrad()
	 * @see #getBesetztgrad()
	 * @generated
	 */
	void setBesetztgrad(BesetztgradType value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getBesetztgrad <em>Besetztgrad</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetBesetztgrad()
	 * @see #getBesetztgrad()
	 * @see #setBesetztgrad(BesetztgradType)
	 * @generated
	 */
	void unsetBesetztgrad();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.IstHaltType#getBesetztgrad <em>Besetztgrad</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Besetztgrad</em>' attribute is set.
	 * @see #unsetBesetztgrad()
	 * @see #getBesetztgrad()
	 * @see #setBesetztgrad(BesetztgradType)
	 * @generated
	 */
	boolean isSetBesetztgrad();

} // IstHaltType
