/*
 */
package de.jena.vdv454_2017c;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

import siri.CountryRefStructure;
import siri.EntryQualifierStructure;
import siri.EnvironmentReasonEnumeration;
import siri.EquipmentReasonEnumeration;
import siri.MiscellaneousReasonEnumeration;
import siri.ParticipantRefStructure;
import siri.PersonnelReasonEnumeration;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Stoerungs Info Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getUrsache <em>Ursache</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getUnknownReason <em>Unknown Reason</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getMiscellaneousReason <em>Miscellaneous Reason</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getPersonnelReason <em>Personnel Reason</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getEquipmentReason <em>Equipment Reason</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getEnvironmentReason <em>Environment Reason</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getUndefinedReason <em>Undefined Reason</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getCountryRef <em>Country Ref</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getParticipantRef <em>Participant Ref</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.StoerungsInfoType#getSituationNumber <em>Situation Number</em>}</li>
 * </ul>
 *
 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType()
 * @model extendedMetaData="name='StoerungsInfoType' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface StoerungsInfoType extends EObject {
	/**
	 * Returns the value of the '<em><b>Ursache</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ursache</em>' attribute.
	 * @see #setUrsache(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_Ursache()
	 * @model dataType="de.jena.vdv454_2017c.UrsacheType"
	 *        extendedMetaData="kind='element' name='Ursache' namespace='##targetNamespace'"
	 * @generated
	 */
	String getUrsache();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getUrsache <em>Ursache</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ursache</em>' attribute.
	 * @see #getUrsache()
	 * @generated
	 */
	void setUrsache(String value);

	/**
	 * Returns the value of the '<em><b>Unknown Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_0/TPEG unknown event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Unknown Reason</em>' attribute.
	 * @see #setUnknownReason(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_UnknownReason()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='UnknownReason' namespace='http://www.siri.org.uk/siri'"
	 * @generated
	 */
	String getUnknownReason();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getUnknownReason <em>Unknown Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Unknown Reason</em>' attribute.
	 * @see #getUnknownReason()
	 * @generated
	 */
	void setUnknownReason(String value);

	/**
	 * Returns the value of the '<em><b>Miscellaneous Reason</b></em>' attribute.
	 * The literals are from the enumeration {@link siri.MiscellaneousReasonEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_1/TPEG Pti_19 miscellaneous event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Miscellaneous Reason</em>' attribute.
	 * @see siri.MiscellaneousReasonEnumeration
	 * @see #isSetMiscellaneousReason()
	 * @see #unsetMiscellaneousReason()
	 * @see #setMiscellaneousReason(MiscellaneousReasonEnumeration)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_MiscellaneousReason()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='element' name='MiscellaneousReason' namespace='http://www.siri.org.uk/siri'"
	 * @generated
	 */
	MiscellaneousReasonEnumeration getMiscellaneousReason();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getMiscellaneousReason <em>Miscellaneous Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Miscellaneous Reason</em>' attribute.
	 * @see siri.MiscellaneousReasonEnumeration
	 * @see #isSetMiscellaneousReason()
	 * @see #unsetMiscellaneousReason()
	 * @see #getMiscellaneousReason()
	 * @generated
	 */
	void setMiscellaneousReason(MiscellaneousReasonEnumeration value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getMiscellaneousReason <em>Miscellaneous Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetMiscellaneousReason()
	 * @see #getMiscellaneousReason()
	 * @see #setMiscellaneousReason(MiscellaneousReasonEnumeration)
	 * @generated
	 */
	void unsetMiscellaneousReason();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getMiscellaneousReason <em>Miscellaneous Reason</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Miscellaneous Reason</em>' attribute is set.
	 * @see #unsetMiscellaneousReason()
	 * @see #getMiscellaneousReason()
	 * @see #setMiscellaneousReason(MiscellaneousReasonEnumeration)
	 * @generated
	 */
	boolean isSetMiscellaneousReason();

	/**
	 * Returns the value of the '<em><b>Personnel Reason</b></em>' attribute.
	 * The literals are from the enumeration {@link siri.PersonnelReasonEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Personnel reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Personnel Reason</em>' attribute.
	 * @see siri.PersonnelReasonEnumeration
	 * @see #isSetPersonnelReason()
	 * @see #unsetPersonnelReason()
	 * @see #setPersonnelReason(PersonnelReasonEnumeration)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_PersonnelReason()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='element' name='PersonnelReason' namespace='http://www.siri.org.uk/siri'"
	 * @generated
	 */
	PersonnelReasonEnumeration getPersonnelReason();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getPersonnelReason <em>Personnel Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Personnel Reason</em>' attribute.
	 * @see siri.PersonnelReasonEnumeration
	 * @see #isSetPersonnelReason()
	 * @see #unsetPersonnelReason()
	 * @see #getPersonnelReason()
	 * @generated
	 */
	void setPersonnelReason(PersonnelReasonEnumeration value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getPersonnelReason <em>Personnel Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetPersonnelReason()
	 * @see #getPersonnelReason()
	 * @see #setPersonnelReason(PersonnelReasonEnumeration)
	 * @generated
	 */
	void unsetPersonnelReason();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getPersonnelReason <em>Personnel Reason</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Personnel Reason</em>' attribute is set.
	 * @see #unsetPersonnelReason()
	 * @see #getPersonnelReason()
	 * @see #setPersonnelReason(PersonnelReasonEnumeration)
	 * @generated
	 */
	boolean isSetPersonnelReason();

	/**
	 * Returns the value of the '<em><b>Equipment Reason</b></em>' attribute.
	 * The literals are from the enumeration {@link siri.EquipmentReasonEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_3/TPEG Pti_21 equipment event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Equipment Reason</em>' attribute.
	 * @see siri.EquipmentReasonEnumeration
	 * @see #isSetEquipmentReason()
	 * @see #unsetEquipmentReason()
	 * @see #setEquipmentReason(EquipmentReasonEnumeration)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_EquipmentReason()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='element' name='EquipmentReason' namespace='http://www.siri.org.uk/siri'"
	 * @generated
	 */
	EquipmentReasonEnumeration getEquipmentReason();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getEquipmentReason <em>Equipment Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Equipment Reason</em>' attribute.
	 * @see siri.EquipmentReasonEnumeration
	 * @see #isSetEquipmentReason()
	 * @see #unsetEquipmentReason()
	 * @see #getEquipmentReason()
	 * @generated
	 */
	void setEquipmentReason(EquipmentReasonEnumeration value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getEquipmentReason <em>Equipment Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetEquipmentReason()
	 * @see #getEquipmentReason()
	 * @see #setEquipmentReason(EquipmentReasonEnumeration)
	 * @generated
	 */
	void unsetEquipmentReason();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getEquipmentReason <em>Equipment Reason</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Equipment Reason</em>' attribute is set.
	 * @see #unsetEquipmentReason()
	 * @see #getEquipmentReason()
	 * @see #setEquipmentReason(EquipmentReasonEnumeration)
	 * @generated
	 */
	boolean isSetEquipmentReason();

	/**
	 * Returns the value of the '<em><b>Environment Reason</b></em>' attribute.
	 * The literals are from the enumeration {@link siri.EnvironmentReasonEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Environment reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Environment Reason</em>' attribute.
	 * @see siri.EnvironmentReasonEnumeration
	 * @see #isSetEnvironmentReason()
	 * @see #unsetEnvironmentReason()
	 * @see #setEnvironmentReason(EnvironmentReasonEnumeration)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_EnvironmentReason()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='element' name='EnvironmentReason' namespace='http://www.siri.org.uk/siri'"
	 * @generated
	 */
	EnvironmentReasonEnumeration getEnvironmentReason();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getEnvironmentReason <em>Environment Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Environment Reason</em>' attribute.
	 * @see siri.EnvironmentReasonEnumeration
	 * @see #isSetEnvironmentReason()
	 * @see #unsetEnvironmentReason()
	 * @see #getEnvironmentReason()
	 * @generated
	 */
	void setEnvironmentReason(EnvironmentReasonEnumeration value);

	/**
	 * Unsets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getEnvironmentReason <em>Environment Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetEnvironmentReason()
	 * @see #getEnvironmentReason()
	 * @see #setEnvironmentReason(EnvironmentReasonEnumeration)
	 * @generated
	 */
	void unsetEnvironmentReason();

	/**
	 * Returns whether the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getEnvironmentReason <em>Environment Reason</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Environment Reason</em>' attribute is set.
	 * @see #unsetEnvironmentReason()
	 * @see #getEnvironmentReason()
	 * @see #setEnvironmentReason(EnvironmentReasonEnumeration)
	 * @generated
	 */
	boolean isSetEnvironmentReason();

	/**
	 * Returns the value of the '<em><b>Undefined Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_255/TPEG Pti_22 undefined event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Undefined Reason</em>' attribute.
	 * @see #setUndefinedReason(String)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_UndefinedReason()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='UndefinedReason' namespace='http://www.siri.org.uk/siri'"
	 * @generated
	 */
	String getUndefinedReason();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getUndefinedReason <em>Undefined Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Undefined Reason</em>' attribute.
	 * @see #getUndefinedReason()
	 * @generated
	 */
	void setUndefinedReason(String value);

	/**
	 * Returns the value of the '<em><b>Country Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unique identifier of a Country of a Participant who created SITUATION. Provides namespace for Participant If absent proided from context.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Country Ref</em>' containment reference.
	 * @see #setCountryRef(CountryRefStructure)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_CountryRef()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='CountryRef' namespace='http://www.siri.org.uk/siri'"
	 * @generated
	 */
	CountryRefStructure getCountryRef();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getCountryRef <em>Country Ref</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Country Ref</em>' containment reference.
	 * @see #getCountryRef()
	 * @generated
	 */
	void setCountryRef(CountryRefStructure value);

	/**
	 * Returns the value of the '<em><b>Participant Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unique identifier of a Participant. Provides namespace for SITUATION. If absent provdied from context.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Participant Ref</em>' containment reference.
	 * @see #setParticipantRef(ParticipantRefStructure)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_ParticipantRef()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='ParticipantRef' namespace='http://www.siri.org.uk/siri'"
	 * @generated
	 */
	ParticipantRefStructure getParticipantRef();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getParticipantRef <em>Participant Ref</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Participant Ref</em>' containment reference.
	 * @see #getParticipantRef()
	 * @generated
	 */
	void setParticipantRef(ParticipantRefStructure value);

	/**
	 * Returns the value of the '<em><b>Situation Number</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unique identifier of SITUATION within a Participant. Excludes any version number.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Situation Number</em>' containment reference.
	 * @see #setSituationNumber(EntryQualifierStructure)
	 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage#getStoerungsInfoType_SituationNumber()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='SituationNumber' namespace='http://www.siri.org.uk/siri'"
	 * @generated
	 */
	EntryQualifierStructure getSituationNumber();

	/**
	 * Sets the value of the '{@link de.jena.vdv454_2017c.StoerungsInfoType#getSituationNumber <em>Situation Number</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Situation Number</em>' containment reference.
	 * @see #getSituationNumber()
	 * @generated
	 */
	void setSituationNumber(EntryQualifierStructure value);

} // StoerungsInfoType
