/*
 */
package de.jena.vdv454_2017c.impl;

import de.jena.vdv454_2017c.AboAUSRefType;
import de.jena.vdv454_2017c.BetreiberFilterType;
import de.jena.vdv454_2017c.HaltFilterType;
import de.jena.vdv454_2017c.LinienFilterType;
import de.jena.vdv454_2017c.ProduktFilterType;
import de.jena.vdv454_2017c.UmlaufFilterType;
import de.jena.vdv454_2017c.VDV453Incl454V2017cPackage;
import de.jena.vdv454_2017c.VerkehrsmittelTextFilterType;
import de.jena.vdv454_2017c.ZeitfensterType;

import java.math.BigInteger;

import java.util.Collection;

import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abo AUS Ref Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getZeitfenster <em>Zeitfenster</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getLinienFilter <em>Linien Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getBetreiberFilter <em>Betreiber Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getProduktFilter <em>Produkt Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getVerkehrsmittelTextFilter <em>Verkehrsmittel Text Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getHaltFilter <em>Halt Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getUmlaufFilter <em>Umlauf Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getUmlaufID <em>Umlauf ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getFahrplanVersionID <em>Fahrplan Version ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getDatenVorhandenBis <em>Daten Vorhanden Bis</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#isMitGesAnschluss <em>Mit Ges Anschluss</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#isMitBereitsAktivenFahrten <em>Mit Bereits Aktiven Fahrten</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#isMitFormation <em>Mit Formation</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getAboID <em>Abo ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSRefTypeImpl#getVerfallZst <em>Verfall Zst</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AboAUSRefTypeImpl extends MinimalEObjectImpl.Container implements AboAUSRefType {
	/**
	 * The cached value of the '{@link #getZeitfenster() <em>Zeitfenster</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZeitfenster()
	 * @generated
	 * @ordered
	 */
	protected ZeitfensterType zeitfenster;

	/**
	 * The cached value of the '{@link #getLinienFilter() <em>Linien Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<LinienFilterType> linienFilter;

	/**
	 * The cached value of the '{@link #getBetreiberFilter() <em>Betreiber Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBetreiberFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<BetreiberFilterType> betreiberFilter;

	/**
	 * The cached value of the '{@link #getProduktFilter() <em>Produkt Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProduktFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<ProduktFilterType> produktFilter;

	/**
	 * The cached value of the '{@link #getVerkehrsmittelTextFilter() <em>Verkehrsmittel Text Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerkehrsmittelTextFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<VerkehrsmittelTextFilterType> verkehrsmittelTextFilter;

	/**
	 * The cached value of the '{@link #getHaltFilter() <em>Halt Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<HaltFilterType> haltFilter;

	/**
	 * The cached value of the '{@link #getUmlaufFilter() <em>Umlauf Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUmlaufFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<UmlaufFilterType> umlaufFilter;

	/**
	 * The cached value of the '{@link #getUmlaufID() <em>Umlauf ID</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUmlaufID()
	 * @generated
	 * @ordered
	 */
	protected EList<String> umlaufID;

	/**
	 * The default value of the '{@link #getFahrplanVersionID() <em>Fahrplan Version ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFahrplanVersionID()
	 * @generated
	 * @ordered
	 */
	protected static final String FAHRPLAN_VERSION_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFahrplanVersionID() <em>Fahrplan Version ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFahrplanVersionID()
	 * @generated
	 * @ordered
	 */
	protected String fahrplanVersionID = FAHRPLAN_VERSION_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getDatenVorhandenBis() <em>Daten Vorhanden Bis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatenVorhandenBis()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar DATEN_VORHANDEN_BIS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDatenVorhandenBis() <em>Daten Vorhanden Bis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatenVorhandenBis()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar datenVorhandenBis = DATEN_VORHANDEN_BIS_EDEFAULT;

	/**
	 * The default value of the '{@link #isMitGesAnschluss() <em>Mit Ges Anschluss</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitGesAnschluss()
	 * @generated
	 * @ordered
	 */
	protected static final boolean MIT_GES_ANSCHLUSS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isMitGesAnschluss() <em>Mit Ges Anschluss</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitGesAnschluss()
	 * @generated
	 * @ordered
	 */
	protected boolean mitGesAnschluss = MIT_GES_ANSCHLUSS_EDEFAULT;

	/**
	 * This is true if the Mit Ges Anschluss attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean mitGesAnschlussESet;

	/**
	 * The default value of the '{@link #isMitBereitsAktivenFahrten() <em>Mit Bereits Aktiven Fahrten</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitBereitsAktivenFahrten()
	 * @generated
	 * @ordered
	 */
	protected static final boolean MIT_BEREITS_AKTIVEN_FAHRTEN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isMitBereitsAktivenFahrten() <em>Mit Bereits Aktiven Fahrten</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitBereitsAktivenFahrten()
	 * @generated
	 * @ordered
	 */
	protected boolean mitBereitsAktivenFahrten = MIT_BEREITS_AKTIVEN_FAHRTEN_EDEFAULT;

	/**
	 * This is true if the Mit Bereits Aktiven Fahrten attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean mitBereitsAktivenFahrtenESet;

	/**
	 * The default value of the '{@link #isMitFormation() <em>Mit Formation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitFormation()
	 * @generated
	 * @ordered
	 */
	protected static final boolean MIT_FORMATION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isMitFormation() <em>Mit Formation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitFormation()
	 * @generated
	 * @ordered
	 */
	protected boolean mitFormation = MIT_FORMATION_EDEFAULT;

	/**
	 * This is true if the Mit Formation attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean mitFormationESet;

	/**
	 * The default value of the '{@link #getAboID() <em>Abo ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAboID()
	 * @generated
	 * @ordered
	 */
	protected static final BigInteger ABO_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAboID() <em>Abo ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAboID()
	 * @generated
	 * @ordered
	 */
	protected BigInteger aboID = ABO_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getVerfallZst() <em>Verfall Zst</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerfallZst()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar VERFALL_ZST_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVerfallZst() <em>Verfall Zst</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerfallZst()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar verfallZst = VERFALL_ZST_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AboAUSRefTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return VDV453Incl454V2017cPackage.eINSTANCE.getAboAUSRefType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZeitfensterType getZeitfenster() {
		return zeitfenster;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetZeitfenster(ZeitfensterType newZeitfenster, NotificationChain msgs) {
		ZeitfensterType oldZeitfenster = zeitfenster;
		zeitfenster = newZeitfenster;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ZEITFENSTER, oldZeitfenster, newZeitfenster);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZeitfenster(ZeitfensterType newZeitfenster) {
		if (newZeitfenster != zeitfenster) {
			NotificationChain msgs = null;
			if (zeitfenster != null)
				msgs = ((InternalEObject)zeitfenster).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ZEITFENSTER, null, msgs);
			if (newZeitfenster != null)
				msgs = ((InternalEObject)newZeitfenster).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ZEITFENSTER, null, msgs);
			msgs = basicSetZeitfenster(newZeitfenster, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ZEITFENSTER, newZeitfenster, newZeitfenster));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<LinienFilterType> getLinienFilter() {
		if (linienFilter == null) {
			linienFilter = new EObjectContainmentEList<LinienFilterType>(LinienFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__LINIEN_FILTER);
		}
		return linienFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<BetreiberFilterType> getBetreiberFilter() {
		if (betreiberFilter == null) {
			betreiberFilter = new EObjectContainmentEList<BetreiberFilterType>(BetreiberFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__BETREIBER_FILTER);
		}
		return betreiberFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ProduktFilterType> getProduktFilter() {
		if (produktFilter == null) {
			produktFilter = new EObjectContainmentEList<ProduktFilterType>(ProduktFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__PRODUKT_FILTER);
		}
		return produktFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<VerkehrsmittelTextFilterType> getVerkehrsmittelTextFilter() {
		if (verkehrsmittelTextFilter == null) {
			verkehrsmittelTextFilter = new EObjectContainmentEList<VerkehrsmittelTextFilterType>(VerkehrsmittelTextFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERKEHRSMITTEL_TEXT_FILTER);
		}
		return verkehrsmittelTextFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<HaltFilterType> getHaltFilter() {
		if (haltFilter == null) {
			haltFilter = new EObjectContainmentEList<HaltFilterType>(HaltFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__HALT_FILTER);
		}
		return haltFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<UmlaufFilterType> getUmlaufFilter() {
		if (umlaufFilter == null) {
			umlaufFilter = new EObjectContainmentEList<UmlaufFilterType>(UmlaufFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_FILTER);
		}
		return umlaufFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getUmlaufID() {
		if (umlaufID == null) {
			umlaufID = new EDataTypeEList<String>(String.class, this, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_ID);
		}
		return umlaufID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getFahrplanVersionID() {
		return fahrplanVersionID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFahrplanVersionID(String newFahrplanVersionID) {
		String oldFahrplanVersionID = fahrplanVersionID;
		fahrplanVersionID = newFahrplanVersionID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__FAHRPLAN_VERSION_ID, oldFahrplanVersionID, fahrplanVersionID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getDatenVorhandenBis() {
		return datenVorhandenBis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDatenVorhandenBis(XMLGregorianCalendar newDatenVorhandenBis) {
		XMLGregorianCalendar oldDatenVorhandenBis = datenVorhandenBis;
		datenVorhandenBis = newDatenVorhandenBis;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__DATEN_VORHANDEN_BIS, oldDatenVorhandenBis, datenVorhandenBis));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isMitGesAnschluss() {
		return mitGesAnschluss;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMitGesAnschluss(boolean newMitGesAnschluss) {
		boolean oldMitGesAnschluss = mitGesAnschluss;
		mitGesAnschluss = newMitGesAnschluss;
		boolean oldMitGesAnschlussESet = mitGesAnschlussESet;
		mitGesAnschlussESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_GES_ANSCHLUSS, oldMitGesAnschluss, mitGesAnschluss, !oldMitGesAnschlussESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetMitGesAnschluss() {
		boolean oldMitGesAnschluss = mitGesAnschluss;
		boolean oldMitGesAnschlussESet = mitGesAnschlussESet;
		mitGesAnschluss = MIT_GES_ANSCHLUSS_EDEFAULT;
		mitGesAnschlussESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_GES_ANSCHLUSS, oldMitGesAnschluss, MIT_GES_ANSCHLUSS_EDEFAULT, oldMitGesAnschlussESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetMitGesAnschluss() {
		return mitGesAnschlussESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isMitBereitsAktivenFahrten() {
		return mitBereitsAktivenFahrten;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMitBereitsAktivenFahrten(boolean newMitBereitsAktivenFahrten) {
		boolean oldMitBereitsAktivenFahrten = mitBereitsAktivenFahrten;
		mitBereitsAktivenFahrten = newMitBereitsAktivenFahrten;
		boolean oldMitBereitsAktivenFahrtenESet = mitBereitsAktivenFahrtenESet;
		mitBereitsAktivenFahrtenESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_BEREITS_AKTIVEN_FAHRTEN, oldMitBereitsAktivenFahrten, mitBereitsAktivenFahrten, !oldMitBereitsAktivenFahrtenESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetMitBereitsAktivenFahrten() {
		boolean oldMitBereitsAktivenFahrten = mitBereitsAktivenFahrten;
		boolean oldMitBereitsAktivenFahrtenESet = mitBereitsAktivenFahrtenESet;
		mitBereitsAktivenFahrten = MIT_BEREITS_AKTIVEN_FAHRTEN_EDEFAULT;
		mitBereitsAktivenFahrtenESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_BEREITS_AKTIVEN_FAHRTEN, oldMitBereitsAktivenFahrten, MIT_BEREITS_AKTIVEN_FAHRTEN_EDEFAULT, oldMitBereitsAktivenFahrtenESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetMitBereitsAktivenFahrten() {
		return mitBereitsAktivenFahrtenESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isMitFormation() {
		return mitFormation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMitFormation(boolean newMitFormation) {
		boolean oldMitFormation = mitFormation;
		mitFormation = newMitFormation;
		boolean oldMitFormationESet = mitFormationESet;
		mitFormationESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_FORMATION, oldMitFormation, mitFormation, !oldMitFormationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetMitFormation() {
		boolean oldMitFormation = mitFormation;
		boolean oldMitFormationESet = mitFormationESet;
		mitFormation = MIT_FORMATION_EDEFAULT;
		mitFormationESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_FORMATION, oldMitFormation, MIT_FORMATION_EDEFAULT, oldMitFormationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetMitFormation() {
		return mitFormationESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BigInteger getAboID() {
		return aboID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAboID(BigInteger newAboID) {
		BigInteger oldAboID = aboID;
		aboID = newAboID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ABO_ID, oldAboID, aboID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getVerfallZst() {
		return verfallZst;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVerfallZst(XMLGregorianCalendar newVerfallZst) {
		XMLGregorianCalendar oldVerfallZst = verfallZst;
		verfallZst = newVerfallZst;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERFALL_ZST, oldVerfallZst, verfallZst));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ZEITFENSTER:
				return basicSetZeitfenster(null, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__LINIEN_FILTER:
				return ((InternalEList<?>)getLinienFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__BETREIBER_FILTER:
				return ((InternalEList<?>)getBetreiberFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__PRODUKT_FILTER:
				return ((InternalEList<?>)getProduktFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				return ((InternalEList<?>)getVerkehrsmittelTextFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__HALT_FILTER:
				return ((InternalEList<?>)getHaltFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_FILTER:
				return ((InternalEList<?>)getUmlaufFilter()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ZEITFENSTER:
				return getZeitfenster();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__LINIEN_FILTER:
				return getLinienFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__BETREIBER_FILTER:
				return getBetreiberFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__PRODUKT_FILTER:
				return getProduktFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				return getVerkehrsmittelTextFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__HALT_FILTER:
				return getHaltFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_FILTER:
				return getUmlaufFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_ID:
				return getUmlaufID();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__FAHRPLAN_VERSION_ID:
				return getFahrplanVersionID();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__DATEN_VORHANDEN_BIS:
				return getDatenVorhandenBis();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_GES_ANSCHLUSS:
				return isMitGesAnschluss();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_BEREITS_AKTIVEN_FAHRTEN:
				return isMitBereitsAktivenFahrten();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_FORMATION:
				return isMitFormation();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ABO_ID:
				return getAboID();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERFALL_ZST:
				return getVerfallZst();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ZEITFENSTER:
				setZeitfenster((ZeitfensterType)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__LINIEN_FILTER:
				getLinienFilter().clear();
				getLinienFilter().addAll((Collection<? extends LinienFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__BETREIBER_FILTER:
				getBetreiberFilter().clear();
				getBetreiberFilter().addAll((Collection<? extends BetreiberFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__PRODUKT_FILTER:
				getProduktFilter().clear();
				getProduktFilter().addAll((Collection<? extends ProduktFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				getVerkehrsmittelTextFilter().clear();
				getVerkehrsmittelTextFilter().addAll((Collection<? extends VerkehrsmittelTextFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__HALT_FILTER:
				getHaltFilter().clear();
				getHaltFilter().addAll((Collection<? extends HaltFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_FILTER:
				getUmlaufFilter().clear();
				getUmlaufFilter().addAll((Collection<? extends UmlaufFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_ID:
				getUmlaufID().clear();
				getUmlaufID().addAll((Collection<? extends String>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__FAHRPLAN_VERSION_ID:
				setFahrplanVersionID((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__DATEN_VORHANDEN_BIS:
				setDatenVorhandenBis((XMLGregorianCalendar)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_GES_ANSCHLUSS:
				setMitGesAnschluss((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_BEREITS_AKTIVEN_FAHRTEN:
				setMitBereitsAktivenFahrten((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_FORMATION:
				setMitFormation((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ABO_ID:
				setAboID((BigInteger)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERFALL_ZST:
				setVerfallZst((XMLGregorianCalendar)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ZEITFENSTER:
				setZeitfenster((ZeitfensterType)null);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__LINIEN_FILTER:
				getLinienFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__BETREIBER_FILTER:
				getBetreiberFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__PRODUKT_FILTER:
				getProduktFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				getVerkehrsmittelTextFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__HALT_FILTER:
				getHaltFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_FILTER:
				getUmlaufFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_ID:
				getUmlaufID().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__FAHRPLAN_VERSION_ID:
				setFahrplanVersionID(FAHRPLAN_VERSION_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__DATEN_VORHANDEN_BIS:
				setDatenVorhandenBis(DATEN_VORHANDEN_BIS_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_GES_ANSCHLUSS:
				unsetMitGesAnschluss();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_BEREITS_AKTIVEN_FAHRTEN:
				unsetMitBereitsAktivenFahrten();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_FORMATION:
				unsetMitFormation();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ABO_ID:
				setAboID(ABO_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERFALL_ZST:
				setVerfallZst(VERFALL_ZST_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ZEITFENSTER:
				return zeitfenster != null;
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__LINIEN_FILTER:
				return linienFilter != null && !linienFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__BETREIBER_FILTER:
				return betreiberFilter != null && !betreiberFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__PRODUKT_FILTER:
				return produktFilter != null && !produktFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				return verkehrsmittelTextFilter != null && !verkehrsmittelTextFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__HALT_FILTER:
				return haltFilter != null && !haltFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_FILTER:
				return umlaufFilter != null && !umlaufFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__UMLAUF_ID:
				return umlaufID != null && !umlaufID.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__FAHRPLAN_VERSION_ID:
				return FAHRPLAN_VERSION_ID_EDEFAULT == null ? fahrplanVersionID != null : !FAHRPLAN_VERSION_ID_EDEFAULT.equals(fahrplanVersionID);
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__DATEN_VORHANDEN_BIS:
				return DATEN_VORHANDEN_BIS_EDEFAULT == null ? datenVorhandenBis != null : !DATEN_VORHANDEN_BIS_EDEFAULT.equals(datenVorhandenBis);
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_GES_ANSCHLUSS:
				return isSetMitGesAnschluss();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_BEREITS_AKTIVEN_FAHRTEN:
				return isSetMitBereitsAktivenFahrten();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__MIT_FORMATION:
				return isSetMitFormation();
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__ABO_ID:
				return ABO_ID_EDEFAULT == null ? aboID != null : !ABO_ID_EDEFAULT.equals(aboID);
			case VDV453Incl454V2017cPackage.ABO_AUS_REF_TYPE__VERFALL_ZST:
				return VERFALL_ZST_EDEFAULT == null ? verfallZst != null : !VERFALL_ZST_EDEFAULT.equals(verfallZst);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (umlaufID: ");
		result.append(umlaufID);
		result.append(", fahrplanVersionID: ");
		result.append(fahrplanVersionID);
		result.append(", datenVorhandenBis: ");
		result.append(datenVorhandenBis);
		result.append(", mitGesAnschluss: ");
		if (mitGesAnschlussESet) result.append(mitGesAnschluss); else result.append("<unset>");
		result.append(", mitBereitsAktivenFahrten: ");
		if (mitBereitsAktivenFahrtenESet) result.append(mitBereitsAktivenFahrten); else result.append("<unset>");
		result.append(", mitFormation: ");
		if (mitFormationESet) result.append(mitFormation); else result.append("<unset>");
		result.append(", aboID: ");
		result.append(aboID);
		result.append(", verfallZst: ");
		result.append(verfallZst);
		result.append(')');
		return result.toString();
	}

} //AboAUSRefTypeImpl
