/*
 */
package de.jena.vdv454_2017c.impl;

import de.jena.vdv454_2017c.AboAUSType;
import de.jena.vdv454_2017c.BetreiberFilterType;
import de.jena.vdv454_2017c.HaltFilterType;
import de.jena.vdv454_2017c.LinienFilterType;
import de.jena.vdv454_2017c.ProduktFilterType;
import de.jena.vdv454_2017c.UmlaufFilterType;
import de.jena.vdv454_2017c.VDV453Incl454V2017cPackage;
import de.jena.vdv454_2017c.VerkehrsmittelTextFilterType;

import java.math.BigInteger;

import java.util.Collection;

import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abo AUS Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getLinienFilter <em>Linien Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getBetreiberFilter <em>Betreiber Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getProduktFilter <em>Produkt Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getVerkehrsmittelTextFilter <em>Verkehrsmittel Text Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getHaltFilter <em>Halt Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getUmlaufFilter <em>Umlauf Filter</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getUmlaufID <em>Umlauf ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getHysterese <em>Hysterese</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getVorschauzeit <em>Vorschauzeit</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#isMitGesAnschluss <em>Mit Ges Anschluss</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#isMitRealZeiten <em>Mit Real Zeiten</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#isMitFormation <em>Mit Formation</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#isNurAktualisierung <em>Nur Aktualisierung</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getAboID <em>Abo ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.AboAUSTypeImpl#getVerfallZst <em>Verfall Zst</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AboAUSTypeImpl extends MinimalEObjectImpl.Container implements AboAUSType {
	/**
	 * The cached value of the '{@link #getLinienFilter() <em>Linien Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<LinienFilterType> linienFilter;

	/**
	 * The cached value of the '{@link #getBetreiberFilter() <em>Betreiber Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBetreiberFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<BetreiberFilterType> betreiberFilter;

	/**
	 * The cached value of the '{@link #getProduktFilter() <em>Produkt Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProduktFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<ProduktFilterType> produktFilter;

	/**
	 * The cached value of the '{@link #getVerkehrsmittelTextFilter() <em>Verkehrsmittel Text Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerkehrsmittelTextFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<VerkehrsmittelTextFilterType> verkehrsmittelTextFilter;

	/**
	 * The cached value of the '{@link #getHaltFilter() <em>Halt Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<HaltFilterType> haltFilter;

	/**
	 * The cached value of the '{@link #getUmlaufFilter() <em>Umlauf Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUmlaufFilter()
	 * @generated
	 * @ordered
	 */
	protected EList<UmlaufFilterType> umlaufFilter;

	/**
	 * The cached value of the '{@link #getUmlaufID() <em>Umlauf ID</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUmlaufID()
	 * @generated
	 * @ordered
	 */
	protected EList<String> umlaufID;

	/**
	 * The default value of the '{@link #getHysterese() <em>Hysterese</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHysterese()
	 * @generated
	 * @ordered
	 */
	protected static final BigInteger HYSTERESE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHysterese() <em>Hysterese</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHysterese()
	 * @generated
	 * @ordered
	 */
	protected BigInteger hysterese = HYSTERESE_EDEFAULT;

	/**
	 * The default value of the '{@link #getVorschauzeit() <em>Vorschauzeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVorschauzeit()
	 * @generated
	 * @ordered
	 */
	protected static final BigInteger VORSCHAUZEIT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVorschauzeit() <em>Vorschauzeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVorschauzeit()
	 * @generated
	 * @ordered
	 */
	protected BigInteger vorschauzeit = VORSCHAUZEIT_EDEFAULT;

	/**
	 * The default value of the '{@link #isMitGesAnschluss() <em>Mit Ges Anschluss</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitGesAnschluss()
	 * @generated
	 * @ordered
	 */
	protected static final boolean MIT_GES_ANSCHLUSS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isMitGesAnschluss() <em>Mit Ges Anschluss</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitGesAnschluss()
	 * @generated
	 * @ordered
	 */
	protected boolean mitGesAnschluss = MIT_GES_ANSCHLUSS_EDEFAULT;

	/**
	 * This is true if the Mit Ges Anschluss attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean mitGesAnschlussESet;

	/**
	 * The default value of the '{@link #isMitRealZeiten() <em>Mit Real Zeiten</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitRealZeiten()
	 * @generated
	 * @ordered
	 */
	protected static final boolean MIT_REAL_ZEITEN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isMitRealZeiten() <em>Mit Real Zeiten</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitRealZeiten()
	 * @generated
	 * @ordered
	 */
	protected boolean mitRealZeiten = MIT_REAL_ZEITEN_EDEFAULT;

	/**
	 * This is true if the Mit Real Zeiten attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean mitRealZeitenESet;

	/**
	 * The default value of the '{@link #isMitFormation() <em>Mit Formation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitFormation()
	 * @generated
	 * @ordered
	 */
	protected static final boolean MIT_FORMATION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isMitFormation() <em>Mit Formation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMitFormation()
	 * @generated
	 * @ordered
	 */
	protected boolean mitFormation = MIT_FORMATION_EDEFAULT;

	/**
	 * This is true if the Mit Formation attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean mitFormationESet;

	/**
	 * The default value of the '{@link #isNurAktualisierung() <em>Nur Aktualisierung</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isNurAktualisierung()
	 * @generated
	 * @ordered
	 */
	protected static final boolean NUR_AKTUALISIERUNG_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isNurAktualisierung() <em>Nur Aktualisierung</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isNurAktualisierung()
	 * @generated
	 * @ordered
	 */
	protected boolean nurAktualisierung = NUR_AKTUALISIERUNG_EDEFAULT;

	/**
	 * This is true if the Nur Aktualisierung attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean nurAktualisierungESet;

	/**
	 * The default value of the '{@link #getAboID() <em>Abo ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAboID()
	 * @generated
	 * @ordered
	 */
	protected static final BigInteger ABO_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAboID() <em>Abo ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAboID()
	 * @generated
	 * @ordered
	 */
	protected BigInteger aboID = ABO_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getVerfallZst() <em>Verfall Zst</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerfallZst()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar VERFALL_ZST_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVerfallZst() <em>Verfall Zst</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerfallZst()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar verfallZst = VERFALL_ZST_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AboAUSTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return VDV453Incl454V2017cPackage.eINSTANCE.getAboAUSType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<LinienFilterType> getLinienFilter() {
		if (linienFilter == null) {
			linienFilter = new EObjectContainmentEList<LinienFilterType>(LinienFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__LINIEN_FILTER);
		}
		return linienFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<BetreiberFilterType> getBetreiberFilter() {
		if (betreiberFilter == null) {
			betreiberFilter = new EObjectContainmentEList<BetreiberFilterType>(BetreiberFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__BETREIBER_FILTER);
		}
		return betreiberFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ProduktFilterType> getProduktFilter() {
		if (produktFilter == null) {
			produktFilter = new EObjectContainmentEList<ProduktFilterType>(ProduktFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__PRODUKT_FILTER);
		}
		return produktFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<VerkehrsmittelTextFilterType> getVerkehrsmittelTextFilter() {
		if (verkehrsmittelTextFilter == null) {
			verkehrsmittelTextFilter = new EObjectContainmentEList<VerkehrsmittelTextFilterType>(VerkehrsmittelTextFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERKEHRSMITTEL_TEXT_FILTER);
		}
		return verkehrsmittelTextFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<HaltFilterType> getHaltFilter() {
		if (haltFilter == null) {
			haltFilter = new EObjectContainmentEList<HaltFilterType>(HaltFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HALT_FILTER);
		}
		return haltFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<UmlaufFilterType> getUmlaufFilter() {
		if (umlaufFilter == null) {
			umlaufFilter = new EObjectContainmentEList<UmlaufFilterType>(UmlaufFilterType.class, this, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_FILTER);
		}
		return umlaufFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getUmlaufID() {
		if (umlaufID == null) {
			umlaufID = new EDataTypeEList<String>(String.class, this, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_ID);
		}
		return umlaufID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BigInteger getHysterese() {
		return hysterese;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHysterese(BigInteger newHysterese) {
		BigInteger oldHysterese = hysterese;
		hysterese = newHysterese;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HYSTERESE, oldHysterese, hysterese));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BigInteger getVorschauzeit() {
		return vorschauzeit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVorschauzeit(BigInteger newVorschauzeit) {
		BigInteger oldVorschauzeit = vorschauzeit;
		vorschauzeit = newVorschauzeit;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VORSCHAUZEIT, oldVorschauzeit, vorschauzeit));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isMitGesAnschluss() {
		return mitGesAnschluss;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMitGesAnschluss(boolean newMitGesAnschluss) {
		boolean oldMitGesAnschluss = mitGesAnschluss;
		mitGesAnschluss = newMitGesAnschluss;
		boolean oldMitGesAnschlussESet = mitGesAnschlussESet;
		mitGesAnschlussESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_GES_ANSCHLUSS, oldMitGesAnschluss, mitGesAnschluss, !oldMitGesAnschlussESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetMitGesAnschluss() {
		boolean oldMitGesAnschluss = mitGesAnschluss;
		boolean oldMitGesAnschlussESet = mitGesAnschlussESet;
		mitGesAnschluss = MIT_GES_ANSCHLUSS_EDEFAULT;
		mitGesAnschlussESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_GES_ANSCHLUSS, oldMitGesAnschluss, MIT_GES_ANSCHLUSS_EDEFAULT, oldMitGesAnschlussESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetMitGesAnschluss() {
		return mitGesAnschlussESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isMitRealZeiten() {
		return mitRealZeiten;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMitRealZeiten(boolean newMitRealZeiten) {
		boolean oldMitRealZeiten = mitRealZeiten;
		mitRealZeiten = newMitRealZeiten;
		boolean oldMitRealZeitenESet = mitRealZeitenESet;
		mitRealZeitenESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_REAL_ZEITEN, oldMitRealZeiten, mitRealZeiten, !oldMitRealZeitenESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetMitRealZeiten() {
		boolean oldMitRealZeiten = mitRealZeiten;
		boolean oldMitRealZeitenESet = mitRealZeitenESet;
		mitRealZeiten = MIT_REAL_ZEITEN_EDEFAULT;
		mitRealZeitenESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_REAL_ZEITEN, oldMitRealZeiten, MIT_REAL_ZEITEN_EDEFAULT, oldMitRealZeitenESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetMitRealZeiten() {
		return mitRealZeitenESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isMitFormation() {
		return mitFormation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMitFormation(boolean newMitFormation) {
		boolean oldMitFormation = mitFormation;
		mitFormation = newMitFormation;
		boolean oldMitFormationESet = mitFormationESet;
		mitFormationESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_FORMATION, oldMitFormation, mitFormation, !oldMitFormationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetMitFormation() {
		boolean oldMitFormation = mitFormation;
		boolean oldMitFormationESet = mitFormationESet;
		mitFormation = MIT_FORMATION_EDEFAULT;
		mitFormationESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_FORMATION, oldMitFormation, MIT_FORMATION_EDEFAULT, oldMitFormationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetMitFormation() {
		return mitFormationESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isNurAktualisierung() {
		return nurAktualisierung;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setNurAktualisierung(boolean newNurAktualisierung) {
		boolean oldNurAktualisierung = nurAktualisierung;
		nurAktualisierung = newNurAktualisierung;
		boolean oldNurAktualisierungESet = nurAktualisierungESet;
		nurAktualisierungESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__NUR_AKTUALISIERUNG, oldNurAktualisierung, nurAktualisierung, !oldNurAktualisierungESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetNurAktualisierung() {
		boolean oldNurAktualisierung = nurAktualisierung;
		boolean oldNurAktualisierungESet = nurAktualisierungESet;
		nurAktualisierung = NUR_AKTUALISIERUNG_EDEFAULT;
		nurAktualisierungESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__NUR_AKTUALISIERUNG, oldNurAktualisierung, NUR_AKTUALISIERUNG_EDEFAULT, oldNurAktualisierungESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetNurAktualisierung() {
		return nurAktualisierungESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BigInteger getAboID() {
		return aboID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAboID(BigInteger newAboID) {
		BigInteger oldAboID = aboID;
		aboID = newAboID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__ABO_ID, oldAboID, aboID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getVerfallZst() {
		return verfallZst;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVerfallZst(XMLGregorianCalendar newVerfallZst) {
		XMLGregorianCalendar oldVerfallZst = verfallZst;
		verfallZst = newVerfallZst;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERFALL_ZST, oldVerfallZst, verfallZst));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__LINIEN_FILTER:
				return ((InternalEList<?>)getLinienFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__BETREIBER_FILTER:
				return ((InternalEList<?>)getBetreiberFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__PRODUKT_FILTER:
				return ((InternalEList<?>)getProduktFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				return ((InternalEList<?>)getVerkehrsmittelTextFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HALT_FILTER:
				return ((InternalEList<?>)getHaltFilter()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_FILTER:
				return ((InternalEList<?>)getUmlaufFilter()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__LINIEN_FILTER:
				return getLinienFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__BETREIBER_FILTER:
				return getBetreiberFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__PRODUKT_FILTER:
				return getProduktFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				return getVerkehrsmittelTextFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HALT_FILTER:
				return getHaltFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_FILTER:
				return getUmlaufFilter();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_ID:
				return getUmlaufID();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HYSTERESE:
				return getHysterese();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VORSCHAUZEIT:
				return getVorschauzeit();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_GES_ANSCHLUSS:
				return isMitGesAnschluss();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_REAL_ZEITEN:
				return isMitRealZeiten();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_FORMATION:
				return isMitFormation();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__NUR_AKTUALISIERUNG:
				return isNurAktualisierung();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__ABO_ID:
				return getAboID();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERFALL_ZST:
				return getVerfallZst();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__LINIEN_FILTER:
				getLinienFilter().clear();
				getLinienFilter().addAll((Collection<? extends LinienFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__BETREIBER_FILTER:
				getBetreiberFilter().clear();
				getBetreiberFilter().addAll((Collection<? extends BetreiberFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__PRODUKT_FILTER:
				getProduktFilter().clear();
				getProduktFilter().addAll((Collection<? extends ProduktFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				getVerkehrsmittelTextFilter().clear();
				getVerkehrsmittelTextFilter().addAll((Collection<? extends VerkehrsmittelTextFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HALT_FILTER:
				getHaltFilter().clear();
				getHaltFilter().addAll((Collection<? extends HaltFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_FILTER:
				getUmlaufFilter().clear();
				getUmlaufFilter().addAll((Collection<? extends UmlaufFilterType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_ID:
				getUmlaufID().clear();
				getUmlaufID().addAll((Collection<? extends String>)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HYSTERESE:
				setHysterese((BigInteger)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VORSCHAUZEIT:
				setVorschauzeit((BigInteger)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_GES_ANSCHLUSS:
				setMitGesAnschluss((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_REAL_ZEITEN:
				setMitRealZeiten((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_FORMATION:
				setMitFormation((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__NUR_AKTUALISIERUNG:
				setNurAktualisierung((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__ABO_ID:
				setAboID((BigInteger)newValue);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERFALL_ZST:
				setVerfallZst((XMLGregorianCalendar)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__LINIEN_FILTER:
				getLinienFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__BETREIBER_FILTER:
				getBetreiberFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__PRODUKT_FILTER:
				getProduktFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				getVerkehrsmittelTextFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HALT_FILTER:
				getHaltFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_FILTER:
				getUmlaufFilter().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_ID:
				getUmlaufID().clear();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HYSTERESE:
				setHysterese(HYSTERESE_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VORSCHAUZEIT:
				setVorschauzeit(VORSCHAUZEIT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_GES_ANSCHLUSS:
				unsetMitGesAnschluss();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_REAL_ZEITEN:
				unsetMitRealZeiten();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_FORMATION:
				unsetMitFormation();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__NUR_AKTUALISIERUNG:
				unsetNurAktualisierung();
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__ABO_ID:
				setAboID(ABO_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERFALL_ZST:
				setVerfallZst(VERFALL_ZST_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__LINIEN_FILTER:
				return linienFilter != null && !linienFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__BETREIBER_FILTER:
				return betreiberFilter != null && !betreiberFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__PRODUKT_FILTER:
				return produktFilter != null && !produktFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERKEHRSMITTEL_TEXT_FILTER:
				return verkehrsmittelTextFilter != null && !verkehrsmittelTextFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HALT_FILTER:
				return haltFilter != null && !haltFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_FILTER:
				return umlaufFilter != null && !umlaufFilter.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__UMLAUF_ID:
				return umlaufID != null && !umlaufID.isEmpty();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__HYSTERESE:
				return HYSTERESE_EDEFAULT == null ? hysterese != null : !HYSTERESE_EDEFAULT.equals(hysterese);
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VORSCHAUZEIT:
				return VORSCHAUZEIT_EDEFAULT == null ? vorschauzeit != null : !VORSCHAUZEIT_EDEFAULT.equals(vorschauzeit);
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_GES_ANSCHLUSS:
				return isSetMitGesAnschluss();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_REAL_ZEITEN:
				return isSetMitRealZeiten();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__MIT_FORMATION:
				return isSetMitFormation();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__NUR_AKTUALISIERUNG:
				return isSetNurAktualisierung();
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__ABO_ID:
				return ABO_ID_EDEFAULT == null ? aboID != null : !ABO_ID_EDEFAULT.equals(aboID);
			case VDV453Incl454V2017cPackage.ABO_AUS_TYPE__VERFALL_ZST:
				return VERFALL_ZST_EDEFAULT == null ? verfallZst != null : !VERFALL_ZST_EDEFAULT.equals(verfallZst);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (umlaufID: ");
		result.append(umlaufID);
		result.append(", hysterese: ");
		result.append(hysterese);
		result.append(", vorschauzeit: ");
		result.append(vorschauzeit);
		result.append(", mitGesAnschluss: ");
		if (mitGesAnschlussESet) result.append(mitGesAnschluss); else result.append("<unset>");
		result.append(", mitRealZeiten: ");
		if (mitRealZeitenESet) result.append(mitRealZeiten); else result.append("<unset>");
		result.append(", mitFormation: ");
		if (mitFormationESet) result.append(mitFormation); else result.append("<unset>");
		result.append(", nurAktualisierung: ");
		if (nurAktualisierungESet) result.append(nurAktualisierung); else result.append("<unset>");
		result.append(", aboID: ");
		result.append(aboID);
		result.append(", verfallZst: ");
		result.append(verfallZst);
		result.append(')');
		return result.toString();
	}

} //AboAUSTypeImpl
