/*
 */
package de.jena.vdv454_2017c.impl;

import de.jena.vdv454_2017c.BesetztgradType;
import de.jena.vdv454_2017c.IstHaltType;
import de.jena.vdv454_2017c.PrognoseStatusType;
import de.jena.vdv454_2017c.PrognoseUngenauType;
import de.jena.vdv454_2017c.StoerungsInfoType;
import de.jena.vdv454_2017c.VDV453Incl454V2017cPackage;
import de.jena.vdv454_2017c.ZeitQualitaetType;

import java.util.Collection;

import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Ist Halt Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getHaltID <em>Halt ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getHaltestellenName <em>Haltestellen Name</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getAbfahrtszeit <em>Abfahrtszeit</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getAnkunftszeit <em>Ankunftszeit</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getIstAbfahrtPrognose <em>Ist Abfahrt Prognose</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getIstAnkunftPrognose <em>Ist Ankunft Prognose</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getIstAbfahrtPrognoseStatus <em>Ist Abfahrt Prognose Status</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getIstAnkunftPrognoseStatus <em>Ist Ankunft Prognose Status</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getIstAbfahrtPrognoseQualitaet <em>Ist Abfahrt Prognose Qualitaet</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getIstAnkunftPrognoseQualitaet <em>Ist Ankunft Prognose Qualitaet</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getIstAbfahrtDisposition <em>Ist Abfahrt Disposition</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getIstAnkunftDisposition <em>Ist Ankunft Disposition</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getPrognoseUngenau <em>Prognose Ungenau</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getAbfahrtssteigText <em>Abfahrtssteig Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getAnkunftssteigText <em>Ankunftssteig Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getAbfahrtsSektorenText <em>Abfahrts Sektoren Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getAnkunftsSektorenText <em>Ankunfts Sektoren Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#isEinsteigeverbot <em>Einsteigeverbot</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#isAussteigeverbot <em>Aussteigeverbot</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#isDurchfahrt <em>Durchfahrt</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#isZusatzhalt <em>Zusatzhalt</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getRichtungsText <em>Richtungs Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getVonRichtungsText <em>Von Richtungs Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getHinweisText <em>Hinweis Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getLinienfahrwegID <em>Linienfahrweg ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getStoerungsInfo <em>Stoerungs Info</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.IstHaltTypeImpl#getBesetztgrad <em>Besetztgrad</em>}</li>
 * </ul>
 *
 * @generated
 */
public class IstHaltTypeImpl extends MinimalEObjectImpl.Container implements IstHaltType {
	/**
	 * The default value of the '{@link #getHaltID() <em>Halt ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltID()
	 * @generated
	 * @ordered
	 */
	protected static final String HALT_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHaltID() <em>Halt ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltID()
	 * @generated
	 * @ordered
	 */
	protected String haltID = HALT_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getHaltestellenName() <em>Haltestellen Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltestellenName()
	 * @generated
	 * @ordered
	 */
	protected static final String HALTESTELLEN_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHaltestellenName() <em>Haltestellen Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltestellenName()
	 * @generated
	 * @ordered
	 */
	protected String haltestellenName = HALTESTELLEN_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getAbfahrtszeit() <em>Abfahrtszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtszeit()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar ABFAHRTSZEIT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAbfahrtszeit() <em>Abfahrtszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtszeit()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar abfahrtszeit = ABFAHRTSZEIT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAnkunftszeit() <em>Ankunftszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftszeit()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar ANKUNFTSZEIT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAnkunftszeit() <em>Ankunftszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftszeit()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar ankunftszeit = ANKUNFTSZEIT_EDEFAULT;

	/**
	 * The default value of the '{@link #getIstAbfahrtPrognose() <em>Ist Abfahrt Prognose</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAbfahrtPrognose()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar IST_ABFAHRT_PROGNOSE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIstAbfahrtPrognose() <em>Ist Abfahrt Prognose</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAbfahrtPrognose()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar istAbfahrtPrognose = IST_ABFAHRT_PROGNOSE_EDEFAULT;

	/**
	 * The default value of the '{@link #getIstAnkunftPrognose() <em>Ist Ankunft Prognose</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAnkunftPrognose()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar IST_ANKUNFT_PROGNOSE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIstAnkunftPrognose() <em>Ist Ankunft Prognose</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAnkunftPrognose()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar istAnkunftPrognose = IST_ANKUNFT_PROGNOSE_EDEFAULT;

	/**
	 * The default value of the '{@link #getIstAbfahrtPrognoseStatus() <em>Ist Abfahrt Prognose Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAbfahrtPrognoseStatus()
	 * @generated
	 * @ordered
	 */
	protected static final PrognoseStatusType IST_ABFAHRT_PROGNOSE_STATUS_EDEFAULT = PrognoseStatusType.PROGNOSE;

	/**
	 * The cached value of the '{@link #getIstAbfahrtPrognoseStatus() <em>Ist Abfahrt Prognose Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAbfahrtPrognoseStatus()
	 * @generated
	 * @ordered
	 */
	protected PrognoseStatusType istAbfahrtPrognoseStatus = IST_ABFAHRT_PROGNOSE_STATUS_EDEFAULT;

	/**
	 * This is true if the Ist Abfahrt Prognose Status attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean istAbfahrtPrognoseStatusESet;

	/**
	 * The default value of the '{@link #getIstAnkunftPrognoseStatus() <em>Ist Ankunft Prognose Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAnkunftPrognoseStatus()
	 * @generated
	 * @ordered
	 */
	protected static final PrognoseStatusType IST_ANKUNFT_PROGNOSE_STATUS_EDEFAULT = PrognoseStatusType.PROGNOSE;

	/**
	 * The cached value of the '{@link #getIstAnkunftPrognoseStatus() <em>Ist Ankunft Prognose Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAnkunftPrognoseStatus()
	 * @generated
	 * @ordered
	 */
	protected PrognoseStatusType istAnkunftPrognoseStatus = IST_ANKUNFT_PROGNOSE_STATUS_EDEFAULT;

	/**
	 * This is true if the Ist Ankunft Prognose Status attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean istAnkunftPrognoseStatusESet;

	/**
	 * The cached value of the '{@link #getIstAbfahrtPrognoseQualitaet() <em>Ist Abfahrt Prognose Qualitaet</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAbfahrtPrognoseQualitaet()
	 * @generated
	 * @ordered
	 */
	protected ZeitQualitaetType istAbfahrtPrognoseQualitaet;

	/**
	 * The cached value of the '{@link #getIstAnkunftPrognoseQualitaet() <em>Ist Ankunft Prognose Qualitaet</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAnkunftPrognoseQualitaet()
	 * @generated
	 * @ordered
	 */
	protected ZeitQualitaetType istAnkunftPrognoseQualitaet;

	/**
	 * The default value of the '{@link #getIstAbfahrtDisposition() <em>Ist Abfahrt Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAbfahrtDisposition()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar IST_ABFAHRT_DISPOSITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIstAbfahrtDisposition() <em>Ist Abfahrt Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAbfahrtDisposition()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar istAbfahrtDisposition = IST_ABFAHRT_DISPOSITION_EDEFAULT;

	/**
	 * The default value of the '{@link #getIstAnkunftDisposition() <em>Ist Ankunft Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAnkunftDisposition()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar IST_ANKUNFT_DISPOSITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIstAnkunftDisposition() <em>Ist Ankunft Disposition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIstAnkunftDisposition()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar istAnkunftDisposition = IST_ANKUNFT_DISPOSITION_EDEFAULT;

	/**
	 * The default value of the '{@link #getPrognoseUngenau() <em>Prognose Ungenau</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrognoseUngenau()
	 * @generated
	 * @ordered
	 */
	protected static final PrognoseUngenauType PROGNOSE_UNGENAU_EDEFAULT = PrognoseUngenauType.FAHRZEUG_IM_STAU;

	/**
	 * The cached value of the '{@link #getPrognoseUngenau() <em>Prognose Ungenau</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrognoseUngenau()
	 * @generated
	 * @ordered
	 */
	protected PrognoseUngenauType prognoseUngenau = PROGNOSE_UNGENAU_EDEFAULT;

	/**
	 * This is true if the Prognose Ungenau attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean prognoseUngenauESet;

	/**
	 * The default value of the '{@link #getAbfahrtssteigText() <em>Abfahrtssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtssteigText()
	 * @generated
	 * @ordered
	 */
	protected static final String ABFAHRTSSTEIG_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAbfahrtssteigText() <em>Abfahrtssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtssteigText()
	 * @generated
	 * @ordered
	 */
	protected String abfahrtssteigText = ABFAHRTSSTEIG_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAnkunftssteigText() <em>Ankunftssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftssteigText()
	 * @generated
	 * @ordered
	 */
	protected static final String ANKUNFTSSTEIG_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAnkunftssteigText() <em>Ankunftssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftssteigText()
	 * @generated
	 * @ordered
	 */
	protected String ankunftssteigText = ANKUNFTSSTEIG_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAbfahrtsSektorenText() <em>Abfahrts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtsSektorenText()
	 * @generated
	 * @ordered
	 */
	protected static final String ABFAHRTS_SEKTOREN_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAbfahrtsSektorenText() <em>Abfahrts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtsSektorenText()
	 * @generated
	 * @ordered
	 */
	protected String abfahrtsSektorenText = ABFAHRTS_SEKTOREN_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAnkunftsSektorenText() <em>Ankunfts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftsSektorenText()
	 * @generated
	 * @ordered
	 */
	protected static final String ANKUNFTS_SEKTOREN_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAnkunftsSektorenText() <em>Ankunfts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftsSektorenText()
	 * @generated
	 * @ordered
	 */
	protected String ankunftsSektorenText = ANKUNFTS_SEKTOREN_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #isEinsteigeverbot() <em>Einsteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEinsteigeverbot()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EINSTEIGEVERBOT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEinsteigeverbot() <em>Einsteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEinsteigeverbot()
	 * @generated
	 * @ordered
	 */
	protected boolean einsteigeverbot = EINSTEIGEVERBOT_EDEFAULT;

	/**
	 * This is true if the Einsteigeverbot attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean einsteigeverbotESet;

	/**
	 * The default value of the '{@link #isAussteigeverbot() <em>Aussteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAussteigeverbot()
	 * @generated
	 * @ordered
	 */
	protected static final boolean AUSSTEIGEVERBOT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAussteigeverbot() <em>Aussteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAussteigeverbot()
	 * @generated
	 * @ordered
	 */
	protected boolean aussteigeverbot = AUSSTEIGEVERBOT_EDEFAULT;

	/**
	 * This is true if the Aussteigeverbot attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean aussteigeverbotESet;

	/**
	 * The default value of the '{@link #isDurchfahrt() <em>Durchfahrt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDurchfahrt()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DURCHFAHRT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDurchfahrt() <em>Durchfahrt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDurchfahrt()
	 * @generated
	 * @ordered
	 */
	protected boolean durchfahrt = DURCHFAHRT_EDEFAULT;

	/**
	 * This is true if the Durchfahrt attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean durchfahrtESet;

	/**
	 * The default value of the '{@link #isZusatzhalt() <em>Zusatzhalt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isZusatzhalt()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ZUSATZHALT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isZusatzhalt() <em>Zusatzhalt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isZusatzhalt()
	 * @generated
	 * @ordered
	 */
	protected boolean zusatzhalt = ZUSATZHALT_EDEFAULT;

	/**
	 * This is true if the Zusatzhalt attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean zusatzhaltESet;

	/**
	 * The default value of the '{@link #getRichtungsText() <em>Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected static final String RICHTUNGS_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRichtungsText() <em>Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected String richtungsText = RICHTUNGS_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getVonRichtungsText() <em>Von Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVonRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected static final String VON_RICHTUNGS_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVonRichtungsText() <em>Von Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVonRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected String vonRichtungsText = VON_RICHTUNGS_TEXT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getHinweisText() <em>Hinweis Text</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHinweisText()
	 * @generated
	 * @ordered
	 */
	protected EList<String> hinweisText;

	/**
	 * The default value of the '{@link #getLinienfahrwegID() <em>Linienfahrweg ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienfahrwegID()
	 * @generated
	 * @ordered
	 */
	protected static final String LINIENFAHRWEG_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLinienfahrwegID() <em>Linienfahrweg ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienfahrwegID()
	 * @generated
	 * @ordered
	 */
	protected String linienfahrwegID = LINIENFAHRWEG_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getStoerungsInfo() <em>Stoerungs Info</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStoerungsInfo()
	 * @generated
	 * @ordered
	 */
	protected StoerungsInfoType stoerungsInfo;

	/**
	 * The default value of the '{@link #getBesetztgrad() <em>Besetztgrad</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBesetztgrad()
	 * @generated
	 * @ordered
	 */
	protected static final BesetztgradType BESETZTGRAD_EDEFAULT = BesetztgradType.SCHWACH_BESETZT;

	/**
	 * The cached value of the '{@link #getBesetztgrad() <em>Besetztgrad</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBesetztgrad()
	 * @generated
	 * @ordered
	 */
	protected BesetztgradType besetztgrad = BESETZTGRAD_EDEFAULT;

	/**
	 * This is true if the Besetztgrad attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean besetztgradESet;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IstHaltTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return VDV453Incl454V2017cPackage.eINSTANCE.getIstHaltType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getHaltID() {
		return haltID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHaltID(String newHaltID) {
		String oldHaltID = haltID;
		haltID = newHaltID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALT_ID, oldHaltID, haltID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getHaltestellenName() {
		return haltestellenName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHaltestellenName(String newHaltestellenName) {
		String oldHaltestellenName = haltestellenName;
		haltestellenName = newHaltestellenName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALTESTELLEN_NAME, oldHaltestellenName, haltestellenName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getAbfahrtszeit() {
		return abfahrtszeit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAbfahrtszeit(XMLGregorianCalendar newAbfahrtszeit) {
		XMLGregorianCalendar oldAbfahrtszeit = abfahrtszeit;
		abfahrtszeit = newAbfahrtszeit;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSZEIT, oldAbfahrtszeit, abfahrtszeit));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getAnkunftszeit() {
		return ankunftszeit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAnkunftszeit(XMLGregorianCalendar newAnkunftszeit) {
		XMLGregorianCalendar oldAnkunftszeit = ankunftszeit;
		ankunftszeit = newAnkunftszeit;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSZEIT, oldAnkunftszeit, ankunftszeit));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getIstAbfahrtPrognose() {
		return istAbfahrtPrognose;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIstAbfahrtPrognose(XMLGregorianCalendar newIstAbfahrtPrognose) {
		XMLGregorianCalendar oldIstAbfahrtPrognose = istAbfahrtPrognose;
		istAbfahrtPrognose = newIstAbfahrtPrognose;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE, oldIstAbfahrtPrognose, istAbfahrtPrognose));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getIstAnkunftPrognose() {
		return istAnkunftPrognose;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIstAnkunftPrognose(XMLGregorianCalendar newIstAnkunftPrognose) {
		XMLGregorianCalendar oldIstAnkunftPrognose = istAnkunftPrognose;
		istAnkunftPrognose = newIstAnkunftPrognose;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE, oldIstAnkunftPrognose, istAnkunftPrognose));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PrognoseStatusType getIstAbfahrtPrognoseStatus() {
		return istAbfahrtPrognoseStatus;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIstAbfahrtPrognoseStatus(PrognoseStatusType newIstAbfahrtPrognoseStatus) {
		PrognoseStatusType oldIstAbfahrtPrognoseStatus = istAbfahrtPrognoseStatus;
		istAbfahrtPrognoseStatus = newIstAbfahrtPrognoseStatus == null ? IST_ABFAHRT_PROGNOSE_STATUS_EDEFAULT : newIstAbfahrtPrognoseStatus;
		boolean oldIstAbfahrtPrognoseStatusESet = istAbfahrtPrognoseStatusESet;
		istAbfahrtPrognoseStatusESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_STATUS, oldIstAbfahrtPrognoseStatus, istAbfahrtPrognoseStatus, !oldIstAbfahrtPrognoseStatusESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetIstAbfahrtPrognoseStatus() {
		PrognoseStatusType oldIstAbfahrtPrognoseStatus = istAbfahrtPrognoseStatus;
		boolean oldIstAbfahrtPrognoseStatusESet = istAbfahrtPrognoseStatusESet;
		istAbfahrtPrognoseStatus = IST_ABFAHRT_PROGNOSE_STATUS_EDEFAULT;
		istAbfahrtPrognoseStatusESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_STATUS, oldIstAbfahrtPrognoseStatus, IST_ABFAHRT_PROGNOSE_STATUS_EDEFAULT, oldIstAbfahrtPrognoseStatusESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetIstAbfahrtPrognoseStatus() {
		return istAbfahrtPrognoseStatusESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PrognoseStatusType getIstAnkunftPrognoseStatus() {
		return istAnkunftPrognoseStatus;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIstAnkunftPrognoseStatus(PrognoseStatusType newIstAnkunftPrognoseStatus) {
		PrognoseStatusType oldIstAnkunftPrognoseStatus = istAnkunftPrognoseStatus;
		istAnkunftPrognoseStatus = newIstAnkunftPrognoseStatus == null ? IST_ANKUNFT_PROGNOSE_STATUS_EDEFAULT : newIstAnkunftPrognoseStatus;
		boolean oldIstAnkunftPrognoseStatusESet = istAnkunftPrognoseStatusESet;
		istAnkunftPrognoseStatusESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_STATUS, oldIstAnkunftPrognoseStatus, istAnkunftPrognoseStatus, !oldIstAnkunftPrognoseStatusESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetIstAnkunftPrognoseStatus() {
		PrognoseStatusType oldIstAnkunftPrognoseStatus = istAnkunftPrognoseStatus;
		boolean oldIstAnkunftPrognoseStatusESet = istAnkunftPrognoseStatusESet;
		istAnkunftPrognoseStatus = IST_ANKUNFT_PROGNOSE_STATUS_EDEFAULT;
		istAnkunftPrognoseStatusESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_STATUS, oldIstAnkunftPrognoseStatus, IST_ANKUNFT_PROGNOSE_STATUS_EDEFAULT, oldIstAnkunftPrognoseStatusESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetIstAnkunftPrognoseStatus() {
		return istAnkunftPrognoseStatusESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZeitQualitaetType getIstAbfahrtPrognoseQualitaet() {
		return istAbfahrtPrognoseQualitaet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIstAbfahrtPrognoseQualitaet(ZeitQualitaetType newIstAbfahrtPrognoseQualitaet, NotificationChain msgs) {
		ZeitQualitaetType oldIstAbfahrtPrognoseQualitaet = istAbfahrtPrognoseQualitaet;
		istAbfahrtPrognoseQualitaet = newIstAbfahrtPrognoseQualitaet;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_QUALITAET, oldIstAbfahrtPrognoseQualitaet, newIstAbfahrtPrognoseQualitaet);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIstAbfahrtPrognoseQualitaet(ZeitQualitaetType newIstAbfahrtPrognoseQualitaet) {
		if (newIstAbfahrtPrognoseQualitaet != istAbfahrtPrognoseQualitaet) {
			NotificationChain msgs = null;
			if (istAbfahrtPrognoseQualitaet != null)
				msgs = ((InternalEObject)istAbfahrtPrognoseQualitaet).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_QUALITAET, null, msgs);
			if (newIstAbfahrtPrognoseQualitaet != null)
				msgs = ((InternalEObject)newIstAbfahrtPrognoseQualitaet).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_QUALITAET, null, msgs);
			msgs = basicSetIstAbfahrtPrognoseQualitaet(newIstAbfahrtPrognoseQualitaet, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_QUALITAET, newIstAbfahrtPrognoseQualitaet, newIstAbfahrtPrognoseQualitaet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZeitQualitaetType getIstAnkunftPrognoseQualitaet() {
		return istAnkunftPrognoseQualitaet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIstAnkunftPrognoseQualitaet(ZeitQualitaetType newIstAnkunftPrognoseQualitaet, NotificationChain msgs) {
		ZeitQualitaetType oldIstAnkunftPrognoseQualitaet = istAnkunftPrognoseQualitaet;
		istAnkunftPrognoseQualitaet = newIstAnkunftPrognoseQualitaet;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_QUALITAET, oldIstAnkunftPrognoseQualitaet, newIstAnkunftPrognoseQualitaet);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIstAnkunftPrognoseQualitaet(ZeitQualitaetType newIstAnkunftPrognoseQualitaet) {
		if (newIstAnkunftPrognoseQualitaet != istAnkunftPrognoseQualitaet) {
			NotificationChain msgs = null;
			if (istAnkunftPrognoseQualitaet != null)
				msgs = ((InternalEObject)istAnkunftPrognoseQualitaet).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_QUALITAET, null, msgs);
			if (newIstAnkunftPrognoseQualitaet != null)
				msgs = ((InternalEObject)newIstAnkunftPrognoseQualitaet).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_QUALITAET, null, msgs);
			msgs = basicSetIstAnkunftPrognoseQualitaet(newIstAnkunftPrognoseQualitaet, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_QUALITAET, newIstAnkunftPrognoseQualitaet, newIstAnkunftPrognoseQualitaet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getIstAbfahrtDisposition() {
		return istAbfahrtDisposition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIstAbfahrtDisposition(XMLGregorianCalendar newIstAbfahrtDisposition) {
		XMLGregorianCalendar oldIstAbfahrtDisposition = istAbfahrtDisposition;
		istAbfahrtDisposition = newIstAbfahrtDisposition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_DISPOSITION, oldIstAbfahrtDisposition, istAbfahrtDisposition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getIstAnkunftDisposition() {
		return istAnkunftDisposition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIstAnkunftDisposition(XMLGregorianCalendar newIstAnkunftDisposition) {
		XMLGregorianCalendar oldIstAnkunftDisposition = istAnkunftDisposition;
		istAnkunftDisposition = newIstAnkunftDisposition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_DISPOSITION, oldIstAnkunftDisposition, istAnkunftDisposition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PrognoseUngenauType getPrognoseUngenau() {
		return prognoseUngenau;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPrognoseUngenau(PrognoseUngenauType newPrognoseUngenau) {
		PrognoseUngenauType oldPrognoseUngenau = prognoseUngenau;
		prognoseUngenau = newPrognoseUngenau == null ? PROGNOSE_UNGENAU_EDEFAULT : newPrognoseUngenau;
		boolean oldPrognoseUngenauESet = prognoseUngenauESet;
		prognoseUngenauESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__PROGNOSE_UNGENAU, oldPrognoseUngenau, prognoseUngenau, !oldPrognoseUngenauESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetPrognoseUngenau() {
		PrognoseUngenauType oldPrognoseUngenau = prognoseUngenau;
		boolean oldPrognoseUngenauESet = prognoseUngenauESet;
		prognoseUngenau = PROGNOSE_UNGENAU_EDEFAULT;
		prognoseUngenauESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__PROGNOSE_UNGENAU, oldPrognoseUngenau, PROGNOSE_UNGENAU_EDEFAULT, oldPrognoseUngenauESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetPrognoseUngenau() {
		return prognoseUngenauESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAbfahrtssteigText() {
		return abfahrtssteigText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAbfahrtssteigText(String newAbfahrtssteigText) {
		String oldAbfahrtssteigText = abfahrtssteigText;
		abfahrtssteigText = newAbfahrtssteigText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSSTEIG_TEXT, oldAbfahrtssteigText, abfahrtssteigText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAnkunftssteigText() {
		return ankunftssteigText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAnkunftssteigText(String newAnkunftssteigText) {
		String oldAnkunftssteigText = ankunftssteigText;
		ankunftssteigText = newAnkunftssteigText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSSTEIG_TEXT, oldAnkunftssteigText, ankunftssteigText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAbfahrtsSektorenText() {
		return abfahrtsSektorenText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAbfahrtsSektorenText(String newAbfahrtsSektorenText) {
		String oldAbfahrtsSektorenText = abfahrtsSektorenText;
		abfahrtsSektorenText = newAbfahrtsSektorenText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT, oldAbfahrtsSektorenText, abfahrtsSektorenText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAnkunftsSektorenText() {
		return ankunftsSektorenText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAnkunftsSektorenText(String newAnkunftsSektorenText) {
		String oldAnkunftsSektorenText = ankunftsSektorenText;
		ankunftsSektorenText = newAnkunftsSektorenText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT, oldAnkunftsSektorenText, ankunftsSektorenText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isEinsteigeverbot() {
		return einsteigeverbot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEinsteigeverbot(boolean newEinsteigeverbot) {
		boolean oldEinsteigeverbot = einsteigeverbot;
		einsteigeverbot = newEinsteigeverbot;
		boolean oldEinsteigeverbotESet = einsteigeverbotESet;
		einsteigeverbotESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__EINSTEIGEVERBOT, oldEinsteigeverbot, einsteigeverbot, !oldEinsteigeverbotESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetEinsteigeverbot() {
		boolean oldEinsteigeverbot = einsteigeverbot;
		boolean oldEinsteigeverbotESet = einsteigeverbotESet;
		einsteigeverbot = EINSTEIGEVERBOT_EDEFAULT;
		einsteigeverbotESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__EINSTEIGEVERBOT, oldEinsteigeverbot, EINSTEIGEVERBOT_EDEFAULT, oldEinsteigeverbotESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetEinsteigeverbot() {
		return einsteigeverbotESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isAussteigeverbot() {
		return aussteigeverbot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAussteigeverbot(boolean newAussteigeverbot) {
		boolean oldAussteigeverbot = aussteigeverbot;
		aussteigeverbot = newAussteigeverbot;
		boolean oldAussteigeverbotESet = aussteigeverbotESet;
		aussteigeverbotESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__AUSSTEIGEVERBOT, oldAussteigeverbot, aussteigeverbot, !oldAussteigeverbotESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetAussteigeverbot() {
		boolean oldAussteigeverbot = aussteigeverbot;
		boolean oldAussteigeverbotESet = aussteigeverbotESet;
		aussteigeverbot = AUSSTEIGEVERBOT_EDEFAULT;
		aussteigeverbotESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__AUSSTEIGEVERBOT, oldAussteigeverbot, AUSSTEIGEVERBOT_EDEFAULT, oldAussteigeverbotESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetAussteigeverbot() {
		return aussteigeverbotESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isDurchfahrt() {
		return durchfahrt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDurchfahrt(boolean newDurchfahrt) {
		boolean oldDurchfahrt = durchfahrt;
		durchfahrt = newDurchfahrt;
		boolean oldDurchfahrtESet = durchfahrtESet;
		durchfahrtESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__DURCHFAHRT, oldDurchfahrt, durchfahrt, !oldDurchfahrtESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetDurchfahrt() {
		boolean oldDurchfahrt = durchfahrt;
		boolean oldDurchfahrtESet = durchfahrtESet;
		durchfahrt = DURCHFAHRT_EDEFAULT;
		durchfahrtESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__DURCHFAHRT, oldDurchfahrt, DURCHFAHRT_EDEFAULT, oldDurchfahrtESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetDurchfahrt() {
		return durchfahrtESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isZusatzhalt() {
		return zusatzhalt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZusatzhalt(boolean newZusatzhalt) {
		boolean oldZusatzhalt = zusatzhalt;
		zusatzhalt = newZusatzhalt;
		boolean oldZusatzhaltESet = zusatzhaltESet;
		zusatzhaltESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__ZUSATZHALT, oldZusatzhalt, zusatzhalt, !oldZusatzhaltESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetZusatzhalt() {
		boolean oldZusatzhalt = zusatzhalt;
		boolean oldZusatzhaltESet = zusatzhaltESet;
		zusatzhalt = ZUSATZHALT_EDEFAULT;
		zusatzhaltESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__ZUSATZHALT, oldZusatzhalt, ZUSATZHALT_EDEFAULT, oldZusatzhaltESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetZusatzhalt() {
		return zusatzhaltESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRichtungsText() {
		return richtungsText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRichtungsText(String newRichtungsText) {
		String oldRichtungsText = richtungsText;
		richtungsText = newRichtungsText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__RICHTUNGS_TEXT, oldRichtungsText, richtungsText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getVonRichtungsText() {
		return vonRichtungsText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVonRichtungsText(String newVonRichtungsText) {
		String oldVonRichtungsText = vonRichtungsText;
		vonRichtungsText = newVonRichtungsText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__VON_RICHTUNGS_TEXT, oldVonRichtungsText, vonRichtungsText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getHinweisText() {
		if (hinweisText == null) {
			hinweisText = new EDataTypeEList<String>(String.class, this, VDV453Incl454V2017cPackage.IST_HALT_TYPE__HINWEIS_TEXT);
		}
		return hinweisText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLinienfahrwegID() {
		return linienfahrwegID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLinienfahrwegID(String newLinienfahrwegID) {
		String oldLinienfahrwegID = linienfahrwegID;
		linienfahrwegID = newLinienfahrwegID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__LINIENFAHRWEG_ID, oldLinienfahrwegID, linienfahrwegID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StoerungsInfoType getStoerungsInfo() {
		return stoerungsInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStoerungsInfo(StoerungsInfoType newStoerungsInfo, NotificationChain msgs) {
		StoerungsInfoType oldStoerungsInfo = stoerungsInfo;
		stoerungsInfo = newStoerungsInfo;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__STOERUNGS_INFO, oldStoerungsInfo, newStoerungsInfo);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStoerungsInfo(StoerungsInfoType newStoerungsInfo) {
		if (newStoerungsInfo != stoerungsInfo) {
			NotificationChain msgs = null;
			if (stoerungsInfo != null)
				msgs = ((InternalEObject)stoerungsInfo).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.IST_HALT_TYPE__STOERUNGS_INFO, null, msgs);
			if (newStoerungsInfo != null)
				msgs = ((InternalEObject)newStoerungsInfo).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.IST_HALT_TYPE__STOERUNGS_INFO, null, msgs);
			msgs = basicSetStoerungsInfo(newStoerungsInfo, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__STOERUNGS_INFO, newStoerungsInfo, newStoerungsInfo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BesetztgradType getBesetztgrad() {
		return besetztgrad;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBesetztgrad(BesetztgradType newBesetztgrad) {
		BesetztgradType oldBesetztgrad = besetztgrad;
		besetztgrad = newBesetztgrad == null ? BESETZTGRAD_EDEFAULT : newBesetztgrad;
		boolean oldBesetztgradESet = besetztgradESet;
		besetztgradESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__BESETZTGRAD, oldBesetztgrad, besetztgrad, !oldBesetztgradESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetBesetztgrad() {
		BesetztgradType oldBesetztgrad = besetztgrad;
		boolean oldBesetztgradESet = besetztgradESet;
		besetztgrad = BESETZTGRAD_EDEFAULT;
		besetztgradESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.IST_HALT_TYPE__BESETZTGRAD, oldBesetztgrad, BESETZTGRAD_EDEFAULT, oldBesetztgradESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetBesetztgrad() {
		return besetztgradESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_QUALITAET:
				return basicSetIstAbfahrtPrognoseQualitaet(null, msgs);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_QUALITAET:
				return basicSetIstAnkunftPrognoseQualitaet(null, msgs);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__STOERUNGS_INFO:
				return basicSetStoerungsInfo(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALT_ID:
				return getHaltID();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALTESTELLEN_NAME:
				return getHaltestellenName();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSZEIT:
				return getAbfahrtszeit();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSZEIT:
				return getAnkunftszeit();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE:
				return getIstAbfahrtPrognose();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE:
				return getIstAnkunftPrognose();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_STATUS:
				return getIstAbfahrtPrognoseStatus();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_STATUS:
				return getIstAnkunftPrognoseStatus();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_QUALITAET:
				return getIstAbfahrtPrognoseQualitaet();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_QUALITAET:
				return getIstAnkunftPrognoseQualitaet();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_DISPOSITION:
				return getIstAbfahrtDisposition();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_DISPOSITION:
				return getIstAnkunftDisposition();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__PROGNOSE_UNGENAU:
				return getPrognoseUngenau();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSSTEIG_TEXT:
				return getAbfahrtssteigText();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSSTEIG_TEXT:
				return getAnkunftssteigText();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT:
				return getAbfahrtsSektorenText();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT:
				return getAnkunftsSektorenText();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__EINSTEIGEVERBOT:
				return isEinsteigeverbot();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__AUSSTEIGEVERBOT:
				return isAussteigeverbot();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__DURCHFAHRT:
				return isDurchfahrt();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ZUSATZHALT:
				return isZusatzhalt();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__RICHTUNGS_TEXT:
				return getRichtungsText();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__VON_RICHTUNGS_TEXT:
				return getVonRichtungsText();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HINWEIS_TEXT:
				return getHinweisText();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__LINIENFAHRWEG_ID:
				return getLinienfahrwegID();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__STOERUNGS_INFO:
				return getStoerungsInfo();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__BESETZTGRAD:
				return getBesetztgrad();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALT_ID:
				setHaltID((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALTESTELLEN_NAME:
				setHaltestellenName((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSZEIT:
				setAbfahrtszeit((XMLGregorianCalendar)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSZEIT:
				setAnkunftszeit((XMLGregorianCalendar)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE:
				setIstAbfahrtPrognose((XMLGregorianCalendar)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE:
				setIstAnkunftPrognose((XMLGregorianCalendar)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_STATUS:
				setIstAbfahrtPrognoseStatus((PrognoseStatusType)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_STATUS:
				setIstAnkunftPrognoseStatus((PrognoseStatusType)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_QUALITAET:
				setIstAbfahrtPrognoseQualitaet((ZeitQualitaetType)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_QUALITAET:
				setIstAnkunftPrognoseQualitaet((ZeitQualitaetType)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_DISPOSITION:
				setIstAbfahrtDisposition((XMLGregorianCalendar)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_DISPOSITION:
				setIstAnkunftDisposition((XMLGregorianCalendar)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__PROGNOSE_UNGENAU:
				setPrognoseUngenau((PrognoseUngenauType)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSSTEIG_TEXT:
				setAbfahrtssteigText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSSTEIG_TEXT:
				setAnkunftssteigText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT:
				setAbfahrtsSektorenText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT:
				setAnkunftsSektorenText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__EINSTEIGEVERBOT:
				setEinsteigeverbot((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__AUSSTEIGEVERBOT:
				setAussteigeverbot((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__DURCHFAHRT:
				setDurchfahrt((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ZUSATZHALT:
				setZusatzhalt((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__RICHTUNGS_TEXT:
				setRichtungsText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__VON_RICHTUNGS_TEXT:
				setVonRichtungsText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HINWEIS_TEXT:
				getHinweisText().clear();
				getHinweisText().addAll((Collection<? extends String>)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__LINIENFAHRWEG_ID:
				setLinienfahrwegID((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__STOERUNGS_INFO:
				setStoerungsInfo((StoerungsInfoType)newValue);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__BESETZTGRAD:
				setBesetztgrad((BesetztgradType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALT_ID:
				setHaltID(HALT_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALTESTELLEN_NAME:
				setHaltestellenName(HALTESTELLEN_NAME_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSZEIT:
				setAbfahrtszeit(ABFAHRTSZEIT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSZEIT:
				setAnkunftszeit(ANKUNFTSZEIT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE:
				setIstAbfahrtPrognose(IST_ABFAHRT_PROGNOSE_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE:
				setIstAnkunftPrognose(IST_ANKUNFT_PROGNOSE_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_STATUS:
				unsetIstAbfahrtPrognoseStatus();
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_STATUS:
				unsetIstAnkunftPrognoseStatus();
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_QUALITAET:
				setIstAbfahrtPrognoseQualitaet((ZeitQualitaetType)null);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_QUALITAET:
				setIstAnkunftPrognoseQualitaet((ZeitQualitaetType)null);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_DISPOSITION:
				setIstAbfahrtDisposition(IST_ABFAHRT_DISPOSITION_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_DISPOSITION:
				setIstAnkunftDisposition(IST_ANKUNFT_DISPOSITION_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__PROGNOSE_UNGENAU:
				unsetPrognoseUngenau();
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSSTEIG_TEXT:
				setAbfahrtssteigText(ABFAHRTSSTEIG_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSSTEIG_TEXT:
				setAnkunftssteigText(ANKUNFTSSTEIG_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT:
				setAbfahrtsSektorenText(ABFAHRTS_SEKTOREN_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT:
				setAnkunftsSektorenText(ANKUNFTS_SEKTOREN_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__EINSTEIGEVERBOT:
				unsetEinsteigeverbot();
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__AUSSTEIGEVERBOT:
				unsetAussteigeverbot();
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__DURCHFAHRT:
				unsetDurchfahrt();
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ZUSATZHALT:
				unsetZusatzhalt();
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__RICHTUNGS_TEXT:
				setRichtungsText(RICHTUNGS_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__VON_RICHTUNGS_TEXT:
				setVonRichtungsText(VON_RICHTUNGS_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HINWEIS_TEXT:
				getHinweisText().clear();
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__LINIENFAHRWEG_ID:
				setLinienfahrwegID(LINIENFAHRWEG_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__STOERUNGS_INFO:
				setStoerungsInfo((StoerungsInfoType)null);
				return;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__BESETZTGRAD:
				unsetBesetztgrad();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALT_ID:
				return HALT_ID_EDEFAULT == null ? haltID != null : !HALT_ID_EDEFAULT.equals(haltID);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HALTESTELLEN_NAME:
				return HALTESTELLEN_NAME_EDEFAULT == null ? haltestellenName != null : !HALTESTELLEN_NAME_EDEFAULT.equals(haltestellenName);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSZEIT:
				return ABFAHRTSZEIT_EDEFAULT == null ? abfahrtszeit != null : !ABFAHRTSZEIT_EDEFAULT.equals(abfahrtszeit);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSZEIT:
				return ANKUNFTSZEIT_EDEFAULT == null ? ankunftszeit != null : !ANKUNFTSZEIT_EDEFAULT.equals(ankunftszeit);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE:
				return IST_ABFAHRT_PROGNOSE_EDEFAULT == null ? istAbfahrtPrognose != null : !IST_ABFAHRT_PROGNOSE_EDEFAULT.equals(istAbfahrtPrognose);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE:
				return IST_ANKUNFT_PROGNOSE_EDEFAULT == null ? istAnkunftPrognose != null : !IST_ANKUNFT_PROGNOSE_EDEFAULT.equals(istAnkunftPrognose);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_STATUS:
				return isSetIstAbfahrtPrognoseStatus();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_STATUS:
				return isSetIstAnkunftPrognoseStatus();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_PROGNOSE_QUALITAET:
				return istAbfahrtPrognoseQualitaet != null;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_PROGNOSE_QUALITAET:
				return istAnkunftPrognoseQualitaet != null;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ABFAHRT_DISPOSITION:
				return IST_ABFAHRT_DISPOSITION_EDEFAULT == null ? istAbfahrtDisposition != null : !IST_ABFAHRT_DISPOSITION_EDEFAULT.equals(istAbfahrtDisposition);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__IST_ANKUNFT_DISPOSITION:
				return IST_ANKUNFT_DISPOSITION_EDEFAULT == null ? istAnkunftDisposition != null : !IST_ANKUNFT_DISPOSITION_EDEFAULT.equals(istAnkunftDisposition);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__PROGNOSE_UNGENAU:
				return isSetPrognoseUngenau();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTSSTEIG_TEXT:
				return ABFAHRTSSTEIG_TEXT_EDEFAULT == null ? abfahrtssteigText != null : !ABFAHRTSSTEIG_TEXT_EDEFAULT.equals(abfahrtssteigText);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTSSTEIG_TEXT:
				return ANKUNFTSSTEIG_TEXT_EDEFAULT == null ? ankunftssteigText != null : !ANKUNFTSSTEIG_TEXT_EDEFAULT.equals(ankunftssteigText);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT:
				return ABFAHRTS_SEKTOREN_TEXT_EDEFAULT == null ? abfahrtsSektorenText != null : !ABFAHRTS_SEKTOREN_TEXT_EDEFAULT.equals(abfahrtsSektorenText);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT:
				return ANKUNFTS_SEKTOREN_TEXT_EDEFAULT == null ? ankunftsSektorenText != null : !ANKUNFTS_SEKTOREN_TEXT_EDEFAULT.equals(ankunftsSektorenText);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__EINSTEIGEVERBOT:
				return isSetEinsteigeverbot();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__AUSSTEIGEVERBOT:
				return isSetAussteigeverbot();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__DURCHFAHRT:
				return isSetDurchfahrt();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__ZUSATZHALT:
				return isSetZusatzhalt();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__RICHTUNGS_TEXT:
				return RICHTUNGS_TEXT_EDEFAULT == null ? richtungsText != null : !RICHTUNGS_TEXT_EDEFAULT.equals(richtungsText);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__VON_RICHTUNGS_TEXT:
				return VON_RICHTUNGS_TEXT_EDEFAULT == null ? vonRichtungsText != null : !VON_RICHTUNGS_TEXT_EDEFAULT.equals(vonRichtungsText);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__HINWEIS_TEXT:
				return hinweisText != null && !hinweisText.isEmpty();
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__LINIENFAHRWEG_ID:
				return LINIENFAHRWEG_ID_EDEFAULT == null ? linienfahrwegID != null : !LINIENFAHRWEG_ID_EDEFAULT.equals(linienfahrwegID);
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__STOERUNGS_INFO:
				return stoerungsInfo != null;
			case VDV453Incl454V2017cPackage.IST_HALT_TYPE__BESETZTGRAD:
				return isSetBesetztgrad();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (haltID: ");
		result.append(haltID);
		result.append(", haltestellenName: ");
		result.append(haltestellenName);
		result.append(", abfahrtszeit: ");
		result.append(abfahrtszeit);
		result.append(", ankunftszeit: ");
		result.append(ankunftszeit);
		result.append(", istAbfahrtPrognose: ");
		result.append(istAbfahrtPrognose);
		result.append(", istAnkunftPrognose: ");
		result.append(istAnkunftPrognose);
		result.append(", istAbfahrtPrognoseStatus: ");
		if (istAbfahrtPrognoseStatusESet) result.append(istAbfahrtPrognoseStatus); else result.append("<unset>");
		result.append(", istAnkunftPrognoseStatus: ");
		if (istAnkunftPrognoseStatusESet) result.append(istAnkunftPrognoseStatus); else result.append("<unset>");
		result.append(", istAbfahrtDisposition: ");
		result.append(istAbfahrtDisposition);
		result.append(", istAnkunftDisposition: ");
		result.append(istAnkunftDisposition);
		result.append(", prognoseUngenau: ");
		if (prognoseUngenauESet) result.append(prognoseUngenau); else result.append("<unset>");
		result.append(", abfahrtssteigText: ");
		result.append(abfahrtssteigText);
		result.append(", ankunftssteigText: ");
		result.append(ankunftssteigText);
		result.append(", abfahrtsSektorenText: ");
		result.append(abfahrtsSektorenText);
		result.append(", ankunftsSektorenText: ");
		result.append(ankunftsSektorenText);
		result.append(", einsteigeverbot: ");
		if (einsteigeverbotESet) result.append(einsteigeverbot); else result.append("<unset>");
		result.append(", aussteigeverbot: ");
		if (aussteigeverbotESet) result.append(aussteigeverbot); else result.append("<unset>");
		result.append(", durchfahrt: ");
		if (durchfahrtESet) result.append(durchfahrt); else result.append("<unset>");
		result.append(", zusatzhalt: ");
		if (zusatzhaltESet) result.append(zusatzhalt); else result.append("<unset>");
		result.append(", richtungsText: ");
		result.append(richtungsText);
		result.append(", vonRichtungsText: ");
		result.append(vonRichtungsText);
		result.append(", hinweisText: ");
		result.append(hinweisText);
		result.append(", linienfahrwegID: ");
		result.append(linienfahrwegID);
		result.append(", besetztgrad: ");
		if (besetztgradESet) result.append(besetztgrad); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //IstHaltTypeImpl
