/*
 */
package de.jena.vdv454_2017c.impl;

import de.jena.vdv454_2017c.BeziehungType;
import de.jena.vdv454_2017c.FahrtIDType;
import de.jena.vdv454_2017c.FormationType;
import de.jena.vdv454_2017c.ServiceAttributType;
import de.jena.vdv454_2017c.SollFahrtType;
import de.jena.vdv454_2017c.SollHaltType;
import de.jena.vdv454_2017c.VDV453Incl454V2017cPackage;

import java.math.BigInteger;

import java.util.Collection;

import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Soll Fahrt Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getFahrtID <em>Fahrt ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getSollHalt <em>Soll Halt</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getUmlaufID <em>Umlauf ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getKursNr <em>Kurs Nr</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getFahrtBezeichnerText <em>Fahrt Bezeichner Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getVerkehrsmittelNummer <em>Verkehrsmittel Nummer</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getLinienText <em>Linien Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getProduktID <em>Produkt ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getRichtungsText <em>Richtungs Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getVonRichtungsText <em>Von Richtungs Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getHinweisText <em>Hinweis Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getLinienfahrwegID <em>Linienfahrweg ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getZugname <em>Zugname</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getVerkehrsmittelText <em>Verkehrsmittel Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#isZusatzfahrt <em>Zusatzfahrt</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#isFaelltAus <em>Faellt Aus</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#isFahrradMitnahme <em>Fahrrad Mitnahme</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getFahrzeugTypID <em>Fahrzeug Typ ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getServiceAttribut <em>Service Attribut</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getSollFormation <em>Soll Formation</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getFahrtBeziehung <em>Fahrt Beziehung</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollFahrtTypeImpl#getZst <em>Zst</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SollFahrtTypeImpl extends MinimalEObjectImpl.Container implements SollFahrtType {
	/**
	 * The cached value of the '{@link #getFahrtID() <em>Fahrt ID</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFahrtID()
	 * @generated
	 * @ordered
	 */
	protected FahrtIDType fahrtID;

	/**
	 * The cached value of the '{@link #getSollHalt() <em>Soll Halt</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSollHalt()
	 * @generated
	 * @ordered
	 */
	protected EList<SollHaltType> sollHalt;

	/**
	 * The default value of the '{@link #getUmlaufID() <em>Umlauf ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUmlaufID()
	 * @generated
	 * @ordered
	 */
	protected static final String UMLAUF_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUmlaufID() <em>Umlauf ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUmlaufID()
	 * @generated
	 * @ordered
	 */
	protected String umlaufID = UMLAUF_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getKursNr() <em>Kurs Nr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKursNr()
	 * @generated
	 * @ordered
	 */
	protected static final BigInteger KURS_NR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getKursNr() <em>Kurs Nr</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKursNr()
	 * @generated
	 * @ordered
	 */
	protected BigInteger kursNr = KURS_NR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getFahrtBezeichnerText() <em>Fahrt Bezeichner Text</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFahrtBezeichnerText()
	 * @generated
	 * @ordered
	 */
	protected EList<String> fahrtBezeichnerText;

	/**
	 * The default value of the '{@link #getVerkehrsmittelNummer() <em>Verkehrsmittel Nummer</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerkehrsmittelNummer()
	 * @generated
	 * @ordered
	 */
	protected static final String VERKEHRSMITTEL_NUMMER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVerkehrsmittelNummer() <em>Verkehrsmittel Nummer</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerkehrsmittelNummer()
	 * @generated
	 * @ordered
	 */
	protected String verkehrsmittelNummer = VERKEHRSMITTEL_NUMMER_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinienText() <em>Linien Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienText()
	 * @generated
	 * @ordered
	 */
	protected static final String LINIEN_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLinienText() <em>Linien Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienText()
	 * @generated
	 * @ordered
	 */
	protected String linienText = LINIEN_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getProduktID() <em>Produkt ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProduktID()
	 * @generated
	 * @ordered
	 */
	protected static final String PRODUKT_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProduktID() <em>Produkt ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProduktID()
	 * @generated
	 * @ordered
	 */
	protected String produktID = PRODUKT_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getRichtungsText() <em>Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected static final String RICHTUNGS_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRichtungsText() <em>Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected String richtungsText = RICHTUNGS_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getVonRichtungsText() <em>Von Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVonRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected static final String VON_RICHTUNGS_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVonRichtungsText() <em>Von Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVonRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected String vonRichtungsText = VON_RICHTUNGS_TEXT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getHinweisText() <em>Hinweis Text</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHinweisText()
	 * @generated
	 * @ordered
	 */
	protected EList<String> hinweisText;

	/**
	 * The default value of the '{@link #getLinienfahrwegID() <em>Linienfahrweg ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienfahrwegID()
	 * @generated
	 * @ordered
	 */
	protected static final String LINIENFAHRWEG_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLinienfahrwegID() <em>Linienfahrweg ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienfahrwegID()
	 * @generated
	 * @ordered
	 */
	protected String linienfahrwegID = LINIENFAHRWEG_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getZugname() <em>Zugname</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZugname()
	 * @generated
	 * @ordered
	 */
	protected static final String ZUGNAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getZugname() <em>Zugname</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZugname()
	 * @generated
	 * @ordered
	 */
	protected String zugname = ZUGNAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getVerkehrsmittelText() <em>Verkehrsmittel Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerkehrsmittelText()
	 * @generated
	 * @ordered
	 */
	protected static final String VERKEHRSMITTEL_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVerkehrsmittelText() <em>Verkehrsmittel Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerkehrsmittelText()
	 * @generated
	 * @ordered
	 */
	protected String verkehrsmittelText = VERKEHRSMITTEL_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #isZusatzfahrt() <em>Zusatzfahrt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isZusatzfahrt()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ZUSATZFAHRT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isZusatzfahrt() <em>Zusatzfahrt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isZusatzfahrt()
	 * @generated
	 * @ordered
	 */
	protected boolean zusatzfahrt = ZUSATZFAHRT_EDEFAULT;

	/**
	 * This is true if the Zusatzfahrt attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean zusatzfahrtESet;

	/**
	 * The default value of the '{@link #isFaelltAus() <em>Faellt Aus</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFaelltAus()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FAELLT_AUS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isFaelltAus() <em>Faellt Aus</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFaelltAus()
	 * @generated
	 * @ordered
	 */
	protected boolean faelltAus = FAELLT_AUS_EDEFAULT;

	/**
	 * This is true if the Faellt Aus attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean faelltAusESet;

	/**
	 * The default value of the '{@link #isFahrradMitnahme() <em>Fahrrad Mitnahme</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFahrradMitnahme()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FAHRRAD_MITNAHME_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isFahrradMitnahme() <em>Fahrrad Mitnahme</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFahrradMitnahme()
	 * @generated
	 * @ordered
	 */
	protected boolean fahrradMitnahme = FAHRRAD_MITNAHME_EDEFAULT;

	/**
	 * This is true if the Fahrrad Mitnahme attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean fahrradMitnahmeESet;

	/**
	 * The default value of the '{@link #getFahrzeugTypID() <em>Fahrzeug Typ ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFahrzeugTypID()
	 * @generated
	 * @ordered
	 */
	protected static final String FAHRZEUG_TYP_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFahrzeugTypID() <em>Fahrzeug Typ ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFahrzeugTypID()
	 * @generated
	 * @ordered
	 */
	protected String fahrzeugTypID = FAHRZEUG_TYP_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getServiceAttribut() <em>Service Attribut</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServiceAttribut()
	 * @generated
	 * @ordered
	 */
	protected EList<ServiceAttributType> serviceAttribut;

	/**
	 * The cached value of the '{@link #getSollFormation() <em>Soll Formation</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSollFormation()
	 * @generated
	 * @ordered
	 */
	protected FormationType sollFormation;

	/**
	 * The cached value of the '{@link #getFahrtBeziehung() <em>Fahrt Beziehung</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFahrtBeziehung()
	 * @generated
	 * @ordered
	 */
	protected EList<BeziehungType> fahrtBeziehung;

	/**
	 * The default value of the '{@link #getZst() <em>Zst</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZst()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar ZST_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getZst() <em>Zst</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZst()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar zst = ZST_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SollFahrtTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return VDV453Incl454V2017cPackage.eINSTANCE.getSollFahrtType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FahrtIDType getFahrtID() {
		return fahrtID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFahrtID(FahrtIDType newFahrtID, NotificationChain msgs) {
		FahrtIDType oldFahrtID = fahrtID;
		fahrtID = newFahrtID;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_ID, oldFahrtID, newFahrtID);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFahrtID(FahrtIDType newFahrtID) {
		if (newFahrtID != fahrtID) {
			NotificationChain msgs = null;
			if (fahrtID != null)
				msgs = ((InternalEObject)fahrtID).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_ID, null, msgs);
			if (newFahrtID != null)
				msgs = ((InternalEObject)newFahrtID).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_ID, null, msgs);
			msgs = basicSetFahrtID(newFahrtID, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_ID, newFahrtID, newFahrtID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SollHaltType> getSollHalt() {
		if (sollHalt == null) {
			sollHalt = new EObjectContainmentEList<SollHaltType>(SollHaltType.class, this, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_HALT);
		}
		return sollHalt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUmlaufID() {
		return umlaufID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUmlaufID(String newUmlaufID) {
		String oldUmlaufID = umlaufID;
		umlaufID = newUmlaufID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__UMLAUF_ID, oldUmlaufID, umlaufID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BigInteger getKursNr() {
		return kursNr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKursNr(BigInteger newKursNr) {
		BigInteger oldKursNr = kursNr;
		kursNr = newKursNr;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__KURS_NR, oldKursNr, kursNr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getFahrtBezeichnerText() {
		if (fahrtBezeichnerText == null) {
			fahrtBezeichnerText = new EDataTypeEList<String>(String.class, this, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZEICHNER_TEXT);
		}
		return fahrtBezeichnerText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getVerkehrsmittelNummer() {
		return verkehrsmittelNummer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVerkehrsmittelNummer(String newVerkehrsmittelNummer) {
		String oldVerkehrsmittelNummer = verkehrsmittelNummer;
		verkehrsmittelNummer = newVerkehrsmittelNummer;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_NUMMER, oldVerkehrsmittelNummer, verkehrsmittelNummer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLinienText() {
		return linienText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLinienText(String newLinienText) {
		String oldLinienText = linienText;
		linienText = newLinienText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIEN_TEXT, oldLinienText, linienText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getProduktID() {
		return produktID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setProduktID(String newProduktID) {
		String oldProduktID = produktID;
		produktID = newProduktID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__PRODUKT_ID, oldProduktID, produktID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRichtungsText() {
		return richtungsText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRichtungsText(String newRichtungsText) {
		String oldRichtungsText = richtungsText;
		richtungsText = newRichtungsText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__RICHTUNGS_TEXT, oldRichtungsText, richtungsText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getVonRichtungsText() {
		return vonRichtungsText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVonRichtungsText(String newVonRichtungsText) {
		String oldVonRichtungsText = vonRichtungsText;
		vonRichtungsText = newVonRichtungsText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VON_RICHTUNGS_TEXT, oldVonRichtungsText, vonRichtungsText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getHinweisText() {
		if (hinweisText == null) {
			hinweisText = new EDataTypeEList<String>(String.class, this, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__HINWEIS_TEXT);
		}
		return hinweisText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLinienfahrwegID() {
		return linienfahrwegID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLinienfahrwegID(String newLinienfahrwegID) {
		String oldLinienfahrwegID = linienfahrwegID;
		linienfahrwegID = newLinienfahrwegID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIENFAHRWEG_ID, oldLinienfahrwegID, linienfahrwegID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getZugname() {
		return zugname;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZugname(String newZugname) {
		String oldZugname = zugname;
		zugname = newZugname;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUGNAME, oldZugname, zugname));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getVerkehrsmittelText() {
		return verkehrsmittelText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVerkehrsmittelText(String newVerkehrsmittelText) {
		String oldVerkehrsmittelText = verkehrsmittelText;
		verkehrsmittelText = newVerkehrsmittelText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_TEXT, oldVerkehrsmittelText, verkehrsmittelText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isZusatzfahrt() {
		return zusatzfahrt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZusatzfahrt(boolean newZusatzfahrt) {
		boolean oldZusatzfahrt = zusatzfahrt;
		zusatzfahrt = newZusatzfahrt;
		boolean oldZusatzfahrtESet = zusatzfahrtESet;
		zusatzfahrtESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUSATZFAHRT, oldZusatzfahrt, zusatzfahrt, !oldZusatzfahrtESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetZusatzfahrt() {
		boolean oldZusatzfahrt = zusatzfahrt;
		boolean oldZusatzfahrtESet = zusatzfahrtESet;
		zusatzfahrt = ZUSATZFAHRT_EDEFAULT;
		zusatzfahrtESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUSATZFAHRT, oldZusatzfahrt, ZUSATZFAHRT_EDEFAULT, oldZusatzfahrtESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetZusatzfahrt() {
		return zusatzfahrtESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFaelltAus() {
		return faelltAus;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFaelltAus(boolean newFaelltAus) {
		boolean oldFaelltAus = faelltAus;
		faelltAus = newFaelltAus;
		boolean oldFaelltAusESet = faelltAusESet;
		faelltAusESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAELLT_AUS, oldFaelltAus, faelltAus, !oldFaelltAusESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetFaelltAus() {
		boolean oldFaelltAus = faelltAus;
		boolean oldFaelltAusESet = faelltAusESet;
		faelltAus = FAELLT_AUS_EDEFAULT;
		faelltAusESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAELLT_AUS, oldFaelltAus, FAELLT_AUS_EDEFAULT, oldFaelltAusESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetFaelltAus() {
		return faelltAusESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFahrradMitnahme() {
		return fahrradMitnahme;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFahrradMitnahme(boolean newFahrradMitnahme) {
		boolean oldFahrradMitnahme = fahrradMitnahme;
		fahrradMitnahme = newFahrradMitnahme;
		boolean oldFahrradMitnahmeESet = fahrradMitnahmeESet;
		fahrradMitnahmeESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRRAD_MITNAHME, oldFahrradMitnahme, fahrradMitnahme, !oldFahrradMitnahmeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetFahrradMitnahme() {
		boolean oldFahrradMitnahme = fahrradMitnahme;
		boolean oldFahrradMitnahmeESet = fahrradMitnahmeESet;
		fahrradMitnahme = FAHRRAD_MITNAHME_EDEFAULT;
		fahrradMitnahmeESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRRAD_MITNAHME, oldFahrradMitnahme, FAHRRAD_MITNAHME_EDEFAULT, oldFahrradMitnahmeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetFahrradMitnahme() {
		return fahrradMitnahmeESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getFahrzeugTypID() {
		return fahrzeugTypID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFahrzeugTypID(String newFahrzeugTypID) {
		String oldFahrzeugTypID = fahrzeugTypID;
		fahrzeugTypID = newFahrzeugTypID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRZEUG_TYP_ID, oldFahrzeugTypID, fahrzeugTypID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ServiceAttributType> getServiceAttribut() {
		if (serviceAttribut == null) {
			serviceAttribut = new EObjectContainmentEList<ServiceAttributType>(ServiceAttributType.class, this, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SERVICE_ATTRIBUT);
		}
		return serviceAttribut;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FormationType getSollFormation() {
		return sollFormation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSollFormation(FormationType newSollFormation, NotificationChain msgs) {
		FormationType oldSollFormation = sollFormation;
		sollFormation = newSollFormation;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_FORMATION, oldSollFormation, newSollFormation);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSollFormation(FormationType newSollFormation) {
		if (newSollFormation != sollFormation) {
			NotificationChain msgs = null;
			if (sollFormation != null)
				msgs = ((InternalEObject)sollFormation).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_FORMATION, null, msgs);
			if (newSollFormation != null)
				msgs = ((InternalEObject)newSollFormation).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_FORMATION, null, msgs);
			msgs = basicSetSollFormation(newSollFormation, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_FORMATION, newSollFormation, newSollFormation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<BeziehungType> getFahrtBeziehung() {
		if (fahrtBeziehung == null) {
			fahrtBeziehung = new EObjectContainmentEList<BeziehungType>(BeziehungType.class, this, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZIEHUNG);
		}
		return fahrtBeziehung;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getZst() {
		return zst;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZst(XMLGregorianCalendar newZst) {
		XMLGregorianCalendar oldZst = zst;
		zst = newZst;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZST, oldZst, zst));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_ID:
				return basicSetFahrtID(null, msgs);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_HALT:
				return ((InternalEList<?>)getSollHalt()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SERVICE_ATTRIBUT:
				return ((InternalEList<?>)getServiceAttribut()).basicRemove(otherEnd, msgs);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_FORMATION:
				return basicSetSollFormation(null, msgs);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZIEHUNG:
				return ((InternalEList<?>)getFahrtBeziehung()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_ID:
				return getFahrtID();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_HALT:
				return getSollHalt();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__UMLAUF_ID:
				return getUmlaufID();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__KURS_NR:
				return getKursNr();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZEICHNER_TEXT:
				return getFahrtBezeichnerText();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_NUMMER:
				return getVerkehrsmittelNummer();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIEN_TEXT:
				return getLinienText();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__PRODUKT_ID:
				return getProduktID();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__RICHTUNGS_TEXT:
				return getRichtungsText();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VON_RICHTUNGS_TEXT:
				return getVonRichtungsText();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__HINWEIS_TEXT:
				return getHinweisText();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIENFAHRWEG_ID:
				return getLinienfahrwegID();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUGNAME:
				return getZugname();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_TEXT:
				return getVerkehrsmittelText();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUSATZFAHRT:
				return isZusatzfahrt();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAELLT_AUS:
				return isFaelltAus();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRRAD_MITNAHME:
				return isFahrradMitnahme();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRZEUG_TYP_ID:
				return getFahrzeugTypID();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SERVICE_ATTRIBUT:
				return getServiceAttribut();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_FORMATION:
				return getSollFormation();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZIEHUNG:
				return getFahrtBeziehung();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZST:
				return getZst();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_ID:
				setFahrtID((FahrtIDType)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_HALT:
				getSollHalt().clear();
				getSollHalt().addAll((Collection<? extends SollHaltType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__UMLAUF_ID:
				setUmlaufID((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__KURS_NR:
				setKursNr((BigInteger)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZEICHNER_TEXT:
				getFahrtBezeichnerText().clear();
				getFahrtBezeichnerText().addAll((Collection<? extends String>)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_NUMMER:
				setVerkehrsmittelNummer((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIEN_TEXT:
				setLinienText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__PRODUKT_ID:
				setProduktID((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__RICHTUNGS_TEXT:
				setRichtungsText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VON_RICHTUNGS_TEXT:
				setVonRichtungsText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__HINWEIS_TEXT:
				getHinweisText().clear();
				getHinweisText().addAll((Collection<? extends String>)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIENFAHRWEG_ID:
				setLinienfahrwegID((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUGNAME:
				setZugname((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_TEXT:
				setVerkehrsmittelText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUSATZFAHRT:
				setZusatzfahrt((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAELLT_AUS:
				setFaelltAus((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRRAD_MITNAHME:
				setFahrradMitnahme((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRZEUG_TYP_ID:
				setFahrzeugTypID((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SERVICE_ATTRIBUT:
				getServiceAttribut().clear();
				getServiceAttribut().addAll((Collection<? extends ServiceAttributType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_FORMATION:
				setSollFormation((FormationType)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZIEHUNG:
				getFahrtBeziehung().clear();
				getFahrtBeziehung().addAll((Collection<? extends BeziehungType>)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZST:
				setZst((XMLGregorianCalendar)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_ID:
				setFahrtID((FahrtIDType)null);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_HALT:
				getSollHalt().clear();
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__UMLAUF_ID:
				setUmlaufID(UMLAUF_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__KURS_NR:
				setKursNr(KURS_NR_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZEICHNER_TEXT:
				getFahrtBezeichnerText().clear();
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_NUMMER:
				setVerkehrsmittelNummer(VERKEHRSMITTEL_NUMMER_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIEN_TEXT:
				setLinienText(LINIEN_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__PRODUKT_ID:
				setProduktID(PRODUKT_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__RICHTUNGS_TEXT:
				setRichtungsText(RICHTUNGS_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VON_RICHTUNGS_TEXT:
				setVonRichtungsText(VON_RICHTUNGS_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__HINWEIS_TEXT:
				getHinweisText().clear();
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIENFAHRWEG_ID:
				setLinienfahrwegID(LINIENFAHRWEG_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUGNAME:
				setZugname(ZUGNAME_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_TEXT:
				setVerkehrsmittelText(VERKEHRSMITTEL_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUSATZFAHRT:
				unsetZusatzfahrt();
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAELLT_AUS:
				unsetFaelltAus();
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRRAD_MITNAHME:
				unsetFahrradMitnahme();
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRZEUG_TYP_ID:
				setFahrzeugTypID(FAHRZEUG_TYP_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SERVICE_ATTRIBUT:
				getServiceAttribut().clear();
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_FORMATION:
				setSollFormation((FormationType)null);
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZIEHUNG:
				getFahrtBeziehung().clear();
				return;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZST:
				setZst(ZST_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_ID:
				return fahrtID != null;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_HALT:
				return sollHalt != null && !sollHalt.isEmpty();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__UMLAUF_ID:
				return UMLAUF_ID_EDEFAULT == null ? umlaufID != null : !UMLAUF_ID_EDEFAULT.equals(umlaufID);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__KURS_NR:
				return KURS_NR_EDEFAULT == null ? kursNr != null : !KURS_NR_EDEFAULT.equals(kursNr);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZEICHNER_TEXT:
				return fahrtBezeichnerText != null && !fahrtBezeichnerText.isEmpty();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_NUMMER:
				return VERKEHRSMITTEL_NUMMER_EDEFAULT == null ? verkehrsmittelNummer != null : !VERKEHRSMITTEL_NUMMER_EDEFAULT.equals(verkehrsmittelNummer);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIEN_TEXT:
				return LINIEN_TEXT_EDEFAULT == null ? linienText != null : !LINIEN_TEXT_EDEFAULT.equals(linienText);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__PRODUKT_ID:
				return PRODUKT_ID_EDEFAULT == null ? produktID != null : !PRODUKT_ID_EDEFAULT.equals(produktID);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__RICHTUNGS_TEXT:
				return RICHTUNGS_TEXT_EDEFAULT == null ? richtungsText != null : !RICHTUNGS_TEXT_EDEFAULT.equals(richtungsText);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VON_RICHTUNGS_TEXT:
				return VON_RICHTUNGS_TEXT_EDEFAULT == null ? vonRichtungsText != null : !VON_RICHTUNGS_TEXT_EDEFAULT.equals(vonRichtungsText);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__HINWEIS_TEXT:
				return hinweisText != null && !hinweisText.isEmpty();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__LINIENFAHRWEG_ID:
				return LINIENFAHRWEG_ID_EDEFAULT == null ? linienfahrwegID != null : !LINIENFAHRWEG_ID_EDEFAULT.equals(linienfahrwegID);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUGNAME:
				return ZUGNAME_EDEFAULT == null ? zugname != null : !ZUGNAME_EDEFAULT.equals(zugname);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__VERKEHRSMITTEL_TEXT:
				return VERKEHRSMITTEL_TEXT_EDEFAULT == null ? verkehrsmittelText != null : !VERKEHRSMITTEL_TEXT_EDEFAULT.equals(verkehrsmittelText);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZUSATZFAHRT:
				return isSetZusatzfahrt();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAELLT_AUS:
				return isSetFaelltAus();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRRAD_MITNAHME:
				return isSetFahrradMitnahme();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRZEUG_TYP_ID:
				return FAHRZEUG_TYP_ID_EDEFAULT == null ? fahrzeugTypID != null : !FAHRZEUG_TYP_ID_EDEFAULT.equals(fahrzeugTypID);
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SERVICE_ATTRIBUT:
				return serviceAttribut != null && !serviceAttribut.isEmpty();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__SOLL_FORMATION:
				return sollFormation != null;
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__FAHRT_BEZIEHUNG:
				return fahrtBeziehung != null && !fahrtBeziehung.isEmpty();
			case VDV453Incl454V2017cPackage.SOLL_FAHRT_TYPE__ZST:
				return ZST_EDEFAULT == null ? zst != null : !ZST_EDEFAULT.equals(zst);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (umlaufID: ");
		result.append(umlaufID);
		result.append(", kursNr: ");
		result.append(kursNr);
		result.append(", fahrtBezeichnerText: ");
		result.append(fahrtBezeichnerText);
		result.append(", verkehrsmittelNummer: ");
		result.append(verkehrsmittelNummer);
		result.append(", linienText: ");
		result.append(linienText);
		result.append(", produktID: ");
		result.append(produktID);
		result.append(", richtungsText: ");
		result.append(richtungsText);
		result.append(", vonRichtungsText: ");
		result.append(vonRichtungsText);
		result.append(", hinweisText: ");
		result.append(hinweisText);
		result.append(", linienfahrwegID: ");
		result.append(linienfahrwegID);
		result.append(", zugname: ");
		result.append(zugname);
		result.append(", verkehrsmittelText: ");
		result.append(verkehrsmittelText);
		result.append(", zusatzfahrt: ");
		if (zusatzfahrtESet) result.append(zusatzfahrt); else result.append("<unset>");
		result.append(", faelltAus: ");
		if (faelltAusESet) result.append(faelltAus); else result.append("<unset>");
		result.append(", fahrradMitnahme: ");
		if (fahrradMitnahmeESet) result.append(fahrradMitnahme); else result.append("<unset>");
		result.append(", fahrzeugTypID: ");
		result.append(fahrzeugTypID);
		result.append(", zst: ");
		result.append(zst);
		result.append(')');
		return result.toString();
	}

} //SollFahrtTypeImpl
