/*
 */
package de.jena.vdv454_2017c.impl;

import de.jena.vdv454_2017c.SollAnschlussType;
import de.jena.vdv454_2017c.SollHaltType;
import de.jena.vdv454_2017c.VDV453Incl454V2017cPackage;

import java.util.Collection;

import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Soll Halt Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getHaltID <em>Halt ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getHaltestellenName <em>Haltestellen Name</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getAbfahrtszeit <em>Abfahrtszeit</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getAnkunftszeit <em>Ankunftszeit</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getAbfahrtssteigText <em>Abfahrtssteig Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getAnkunftssteigText <em>Ankunftssteig Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getAbfahrtsSektorenText <em>Abfahrts Sektoren Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getAnkunftsSektorenText <em>Ankunfts Sektoren Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#isEinsteigeverbot <em>Einsteigeverbot</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#isAussteigeverbot <em>Aussteigeverbot</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#isDurchfahrt <em>Durchfahrt</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getRichtungsText <em>Richtungs Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getVonRichtungsText <em>Von Richtungs Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getHinweisText <em>Hinweis Text</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getLinienfahrwegID <em>Linienfahrweg ID</em>}</li>
 *   <li>{@link de.jena.vdv454_2017c.impl.SollHaltTypeImpl#getSollAnschluss <em>Soll Anschluss</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SollHaltTypeImpl extends MinimalEObjectImpl.Container implements SollHaltType {
	/**
	 * The default value of the '{@link #getHaltID() <em>Halt ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltID()
	 * @generated
	 * @ordered
	 */
	protected static final String HALT_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHaltID() <em>Halt ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltID()
	 * @generated
	 * @ordered
	 */
	protected String haltID = HALT_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getHaltestellenName() <em>Haltestellen Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltestellenName()
	 * @generated
	 * @ordered
	 */
	protected static final String HALTESTELLEN_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHaltestellenName() <em>Haltestellen Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaltestellenName()
	 * @generated
	 * @ordered
	 */
	protected String haltestellenName = HALTESTELLEN_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getAbfahrtszeit() <em>Abfahrtszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtszeit()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar ABFAHRTSZEIT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAbfahrtszeit() <em>Abfahrtszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtszeit()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar abfahrtszeit = ABFAHRTSZEIT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAnkunftszeit() <em>Ankunftszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftszeit()
	 * @generated
	 * @ordered
	 */
	protected static final XMLGregorianCalendar ANKUNFTSZEIT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAnkunftszeit() <em>Ankunftszeit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftszeit()
	 * @generated
	 * @ordered
	 */
	protected XMLGregorianCalendar ankunftszeit = ANKUNFTSZEIT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAbfahrtssteigText() <em>Abfahrtssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtssteigText()
	 * @generated
	 * @ordered
	 */
	protected static final String ABFAHRTSSTEIG_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAbfahrtssteigText() <em>Abfahrtssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtssteigText()
	 * @generated
	 * @ordered
	 */
	protected String abfahrtssteigText = ABFAHRTSSTEIG_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAnkunftssteigText() <em>Ankunftssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftssteigText()
	 * @generated
	 * @ordered
	 */
	protected static final String ANKUNFTSSTEIG_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAnkunftssteigText() <em>Ankunftssteig Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftssteigText()
	 * @generated
	 * @ordered
	 */
	protected String ankunftssteigText = ANKUNFTSSTEIG_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAbfahrtsSektorenText() <em>Abfahrts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtsSektorenText()
	 * @generated
	 * @ordered
	 */
	protected static final String ABFAHRTS_SEKTOREN_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAbfahrtsSektorenText() <em>Abfahrts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbfahrtsSektorenText()
	 * @generated
	 * @ordered
	 */
	protected String abfahrtsSektorenText = ABFAHRTS_SEKTOREN_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAnkunftsSektorenText() <em>Ankunfts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftsSektorenText()
	 * @generated
	 * @ordered
	 */
	protected static final String ANKUNFTS_SEKTOREN_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAnkunftsSektorenText() <em>Ankunfts Sektoren Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnkunftsSektorenText()
	 * @generated
	 * @ordered
	 */
	protected String ankunftsSektorenText = ANKUNFTS_SEKTOREN_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #isEinsteigeverbot() <em>Einsteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEinsteigeverbot()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EINSTEIGEVERBOT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEinsteigeverbot() <em>Einsteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEinsteigeverbot()
	 * @generated
	 * @ordered
	 */
	protected boolean einsteigeverbot = EINSTEIGEVERBOT_EDEFAULT;

	/**
	 * This is true if the Einsteigeverbot attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean einsteigeverbotESet;

	/**
	 * The default value of the '{@link #isAussteigeverbot() <em>Aussteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAussteigeverbot()
	 * @generated
	 * @ordered
	 */
	protected static final boolean AUSSTEIGEVERBOT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAussteigeverbot() <em>Aussteigeverbot</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAussteigeverbot()
	 * @generated
	 * @ordered
	 */
	protected boolean aussteigeverbot = AUSSTEIGEVERBOT_EDEFAULT;

	/**
	 * This is true if the Aussteigeverbot attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean aussteigeverbotESet;

	/**
	 * The default value of the '{@link #isDurchfahrt() <em>Durchfahrt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDurchfahrt()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DURCHFAHRT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDurchfahrt() <em>Durchfahrt</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDurchfahrt()
	 * @generated
	 * @ordered
	 */
	protected boolean durchfahrt = DURCHFAHRT_EDEFAULT;

	/**
	 * This is true if the Durchfahrt attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean durchfahrtESet;

	/**
	 * The default value of the '{@link #getRichtungsText() <em>Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected static final String RICHTUNGS_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRichtungsText() <em>Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected String richtungsText = RICHTUNGS_TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getVonRichtungsText() <em>Von Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVonRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected static final String VON_RICHTUNGS_TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVonRichtungsText() <em>Von Richtungs Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVonRichtungsText()
	 * @generated
	 * @ordered
	 */
	protected String vonRichtungsText = VON_RICHTUNGS_TEXT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getHinweisText() <em>Hinweis Text</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHinweisText()
	 * @generated
	 * @ordered
	 */
	protected EList<String> hinweisText;

	/**
	 * The default value of the '{@link #getLinienfahrwegID() <em>Linienfahrweg ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienfahrwegID()
	 * @generated
	 * @ordered
	 */
	protected static final String LINIENFAHRWEG_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLinienfahrwegID() <em>Linienfahrweg ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinienfahrwegID()
	 * @generated
	 * @ordered
	 */
	protected String linienfahrwegID = LINIENFAHRWEG_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSollAnschluss() <em>Soll Anschluss</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSollAnschluss()
	 * @generated
	 * @ordered
	 */
	protected EList<SollAnschlussType> sollAnschluss;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SollHaltTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return VDV453Incl454V2017cPackage.eINSTANCE.getSollHaltType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getHaltID() {
		return haltID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHaltID(String newHaltID) {
		String oldHaltID = haltID;
		haltID = newHaltID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALT_ID, oldHaltID, haltID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getHaltestellenName() {
		return haltestellenName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHaltestellenName(String newHaltestellenName) {
		String oldHaltestellenName = haltestellenName;
		haltestellenName = newHaltestellenName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALTESTELLEN_NAME, oldHaltestellenName, haltestellenName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getAbfahrtszeit() {
		return abfahrtszeit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAbfahrtszeit(XMLGregorianCalendar newAbfahrtszeit) {
		XMLGregorianCalendar oldAbfahrtszeit = abfahrtszeit;
		abfahrtszeit = newAbfahrtszeit;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSZEIT, oldAbfahrtszeit, abfahrtszeit));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XMLGregorianCalendar getAnkunftszeit() {
		return ankunftszeit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAnkunftszeit(XMLGregorianCalendar newAnkunftszeit) {
		XMLGregorianCalendar oldAnkunftszeit = ankunftszeit;
		ankunftszeit = newAnkunftszeit;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSZEIT, oldAnkunftszeit, ankunftszeit));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAbfahrtssteigText() {
		return abfahrtssteigText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAbfahrtssteigText(String newAbfahrtssteigText) {
		String oldAbfahrtssteigText = abfahrtssteigText;
		abfahrtssteigText = newAbfahrtssteigText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSSTEIG_TEXT, oldAbfahrtssteigText, abfahrtssteigText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAnkunftssteigText() {
		return ankunftssteigText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAnkunftssteigText(String newAnkunftssteigText) {
		String oldAnkunftssteigText = ankunftssteigText;
		ankunftssteigText = newAnkunftssteigText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSSTEIG_TEXT, oldAnkunftssteigText, ankunftssteigText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAbfahrtsSektorenText() {
		return abfahrtsSektorenText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAbfahrtsSektorenText(String newAbfahrtsSektorenText) {
		String oldAbfahrtsSektorenText = abfahrtsSektorenText;
		abfahrtsSektorenText = newAbfahrtsSektorenText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT, oldAbfahrtsSektorenText, abfahrtsSektorenText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAnkunftsSektorenText() {
		return ankunftsSektorenText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAnkunftsSektorenText(String newAnkunftsSektorenText) {
		String oldAnkunftsSektorenText = ankunftsSektorenText;
		ankunftsSektorenText = newAnkunftsSektorenText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT, oldAnkunftsSektorenText, ankunftsSektorenText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isEinsteigeverbot() {
		return einsteigeverbot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEinsteigeverbot(boolean newEinsteigeverbot) {
		boolean oldEinsteigeverbot = einsteigeverbot;
		einsteigeverbot = newEinsteigeverbot;
		boolean oldEinsteigeverbotESet = einsteigeverbotESet;
		einsteigeverbotESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__EINSTEIGEVERBOT, oldEinsteigeverbot, einsteigeverbot, !oldEinsteigeverbotESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetEinsteigeverbot() {
		boolean oldEinsteigeverbot = einsteigeverbot;
		boolean oldEinsteigeverbotESet = einsteigeverbotESet;
		einsteigeverbot = EINSTEIGEVERBOT_EDEFAULT;
		einsteigeverbotESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__EINSTEIGEVERBOT, oldEinsteigeverbot, EINSTEIGEVERBOT_EDEFAULT, oldEinsteigeverbotESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetEinsteigeverbot() {
		return einsteigeverbotESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isAussteigeverbot() {
		return aussteigeverbot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAussteigeverbot(boolean newAussteigeverbot) {
		boolean oldAussteigeverbot = aussteigeverbot;
		aussteigeverbot = newAussteigeverbot;
		boolean oldAussteigeverbotESet = aussteigeverbotESet;
		aussteigeverbotESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__AUSSTEIGEVERBOT, oldAussteigeverbot, aussteigeverbot, !oldAussteigeverbotESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetAussteigeverbot() {
		boolean oldAussteigeverbot = aussteigeverbot;
		boolean oldAussteigeverbotESet = aussteigeverbotESet;
		aussteigeverbot = AUSSTEIGEVERBOT_EDEFAULT;
		aussteigeverbotESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__AUSSTEIGEVERBOT, oldAussteigeverbot, AUSSTEIGEVERBOT_EDEFAULT, oldAussteigeverbotESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetAussteigeverbot() {
		return aussteigeverbotESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isDurchfahrt() {
		return durchfahrt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDurchfahrt(boolean newDurchfahrt) {
		boolean oldDurchfahrt = durchfahrt;
		durchfahrt = newDurchfahrt;
		boolean oldDurchfahrtESet = durchfahrtESet;
		durchfahrtESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__DURCHFAHRT, oldDurchfahrt, durchfahrt, !oldDurchfahrtESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetDurchfahrt() {
		boolean oldDurchfahrt = durchfahrt;
		boolean oldDurchfahrtESet = durchfahrtESet;
		durchfahrt = DURCHFAHRT_EDEFAULT;
		durchfahrtESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__DURCHFAHRT, oldDurchfahrt, DURCHFAHRT_EDEFAULT, oldDurchfahrtESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetDurchfahrt() {
		return durchfahrtESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRichtungsText() {
		return richtungsText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRichtungsText(String newRichtungsText) {
		String oldRichtungsText = richtungsText;
		richtungsText = newRichtungsText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__RICHTUNGS_TEXT, oldRichtungsText, richtungsText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getVonRichtungsText() {
		return vonRichtungsText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVonRichtungsText(String newVonRichtungsText) {
		String oldVonRichtungsText = vonRichtungsText;
		vonRichtungsText = newVonRichtungsText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__VON_RICHTUNGS_TEXT, oldVonRichtungsText, vonRichtungsText));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getHinweisText() {
		if (hinweisText == null) {
			hinweisText = new EDataTypeEList<String>(String.class, this, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HINWEIS_TEXT);
		}
		return hinweisText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLinienfahrwegID() {
		return linienfahrwegID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLinienfahrwegID(String newLinienfahrwegID) {
		String oldLinienfahrwegID = linienfahrwegID;
		linienfahrwegID = newLinienfahrwegID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__LINIENFAHRWEG_ID, oldLinienfahrwegID, linienfahrwegID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SollAnschlussType> getSollAnschluss() {
		if (sollAnschluss == null) {
			sollAnschluss = new EObjectContainmentEList<SollAnschlussType>(SollAnschlussType.class, this, VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__SOLL_ANSCHLUSS);
		}
		return sollAnschluss;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__SOLL_ANSCHLUSS:
				return ((InternalEList<?>)getSollAnschluss()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALT_ID:
				return getHaltID();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALTESTELLEN_NAME:
				return getHaltestellenName();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSZEIT:
				return getAbfahrtszeit();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSZEIT:
				return getAnkunftszeit();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSSTEIG_TEXT:
				return getAbfahrtssteigText();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSSTEIG_TEXT:
				return getAnkunftssteigText();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT:
				return getAbfahrtsSektorenText();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT:
				return getAnkunftsSektorenText();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__EINSTEIGEVERBOT:
				return isEinsteigeverbot();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__AUSSTEIGEVERBOT:
				return isAussteigeverbot();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__DURCHFAHRT:
				return isDurchfahrt();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__RICHTUNGS_TEXT:
				return getRichtungsText();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__VON_RICHTUNGS_TEXT:
				return getVonRichtungsText();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HINWEIS_TEXT:
				return getHinweisText();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__LINIENFAHRWEG_ID:
				return getLinienfahrwegID();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__SOLL_ANSCHLUSS:
				return getSollAnschluss();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALT_ID:
				setHaltID((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALTESTELLEN_NAME:
				setHaltestellenName((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSZEIT:
				setAbfahrtszeit((XMLGregorianCalendar)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSZEIT:
				setAnkunftszeit((XMLGregorianCalendar)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSSTEIG_TEXT:
				setAbfahrtssteigText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSSTEIG_TEXT:
				setAnkunftssteigText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT:
				setAbfahrtsSektorenText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT:
				setAnkunftsSektorenText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__EINSTEIGEVERBOT:
				setEinsteigeverbot((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__AUSSTEIGEVERBOT:
				setAussteigeverbot((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__DURCHFAHRT:
				setDurchfahrt((Boolean)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__RICHTUNGS_TEXT:
				setRichtungsText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__VON_RICHTUNGS_TEXT:
				setVonRichtungsText((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HINWEIS_TEXT:
				getHinweisText().clear();
				getHinweisText().addAll((Collection<? extends String>)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__LINIENFAHRWEG_ID:
				setLinienfahrwegID((String)newValue);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__SOLL_ANSCHLUSS:
				getSollAnschluss().clear();
				getSollAnschluss().addAll((Collection<? extends SollAnschlussType>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALT_ID:
				setHaltID(HALT_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALTESTELLEN_NAME:
				setHaltestellenName(HALTESTELLEN_NAME_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSZEIT:
				setAbfahrtszeit(ABFAHRTSZEIT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSZEIT:
				setAnkunftszeit(ANKUNFTSZEIT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSSTEIG_TEXT:
				setAbfahrtssteigText(ABFAHRTSSTEIG_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSSTEIG_TEXT:
				setAnkunftssteigText(ANKUNFTSSTEIG_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT:
				setAbfahrtsSektorenText(ABFAHRTS_SEKTOREN_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT:
				setAnkunftsSektorenText(ANKUNFTS_SEKTOREN_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__EINSTEIGEVERBOT:
				unsetEinsteigeverbot();
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__AUSSTEIGEVERBOT:
				unsetAussteigeverbot();
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__DURCHFAHRT:
				unsetDurchfahrt();
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__RICHTUNGS_TEXT:
				setRichtungsText(RICHTUNGS_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__VON_RICHTUNGS_TEXT:
				setVonRichtungsText(VON_RICHTUNGS_TEXT_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HINWEIS_TEXT:
				getHinweisText().clear();
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__LINIENFAHRWEG_ID:
				setLinienfahrwegID(LINIENFAHRWEG_ID_EDEFAULT);
				return;
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__SOLL_ANSCHLUSS:
				getSollAnschluss().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALT_ID:
				return HALT_ID_EDEFAULT == null ? haltID != null : !HALT_ID_EDEFAULT.equals(haltID);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HALTESTELLEN_NAME:
				return HALTESTELLEN_NAME_EDEFAULT == null ? haltestellenName != null : !HALTESTELLEN_NAME_EDEFAULT.equals(haltestellenName);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSZEIT:
				return ABFAHRTSZEIT_EDEFAULT == null ? abfahrtszeit != null : !ABFAHRTSZEIT_EDEFAULT.equals(abfahrtszeit);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSZEIT:
				return ANKUNFTSZEIT_EDEFAULT == null ? ankunftszeit != null : !ANKUNFTSZEIT_EDEFAULT.equals(ankunftszeit);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTSSTEIG_TEXT:
				return ABFAHRTSSTEIG_TEXT_EDEFAULT == null ? abfahrtssteigText != null : !ABFAHRTSSTEIG_TEXT_EDEFAULT.equals(abfahrtssteigText);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTSSTEIG_TEXT:
				return ANKUNFTSSTEIG_TEXT_EDEFAULT == null ? ankunftssteigText != null : !ANKUNFTSSTEIG_TEXT_EDEFAULT.equals(ankunftssteigText);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ABFAHRTS_SEKTOREN_TEXT:
				return ABFAHRTS_SEKTOREN_TEXT_EDEFAULT == null ? abfahrtsSektorenText != null : !ABFAHRTS_SEKTOREN_TEXT_EDEFAULT.equals(abfahrtsSektorenText);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__ANKUNFTS_SEKTOREN_TEXT:
				return ANKUNFTS_SEKTOREN_TEXT_EDEFAULT == null ? ankunftsSektorenText != null : !ANKUNFTS_SEKTOREN_TEXT_EDEFAULT.equals(ankunftsSektorenText);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__EINSTEIGEVERBOT:
				return isSetEinsteigeverbot();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__AUSSTEIGEVERBOT:
				return isSetAussteigeverbot();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__DURCHFAHRT:
				return isSetDurchfahrt();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__RICHTUNGS_TEXT:
				return RICHTUNGS_TEXT_EDEFAULT == null ? richtungsText != null : !RICHTUNGS_TEXT_EDEFAULT.equals(richtungsText);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__VON_RICHTUNGS_TEXT:
				return VON_RICHTUNGS_TEXT_EDEFAULT == null ? vonRichtungsText != null : !VON_RICHTUNGS_TEXT_EDEFAULT.equals(vonRichtungsText);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__HINWEIS_TEXT:
				return hinweisText != null && !hinweisText.isEmpty();
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__LINIENFAHRWEG_ID:
				return LINIENFAHRWEG_ID_EDEFAULT == null ? linienfahrwegID != null : !LINIENFAHRWEG_ID_EDEFAULT.equals(linienfahrwegID);
			case VDV453Incl454V2017cPackage.SOLL_HALT_TYPE__SOLL_ANSCHLUSS:
				return sollAnschluss != null && !sollAnschluss.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (haltID: ");
		result.append(haltID);
		result.append(", haltestellenName: ");
		result.append(haltestellenName);
		result.append(", abfahrtszeit: ");
		result.append(abfahrtszeit);
		result.append(", ankunftszeit: ");
		result.append(ankunftszeit);
		result.append(", abfahrtssteigText: ");
		result.append(abfahrtssteigText);
		result.append(", ankunftssteigText: ");
		result.append(ankunftssteigText);
		result.append(", abfahrtsSektorenText: ");
		result.append(abfahrtsSektorenText);
		result.append(", ankunftsSektorenText: ");
		result.append(ankunftsSektorenText);
		result.append(", einsteigeverbot: ");
		if (einsteigeverbotESet) result.append(einsteigeverbot); else result.append("<unset>");
		result.append(", aussteigeverbot: ");
		if (aussteigeverbotESet) result.append(aussteigeverbot); else result.append("<unset>");
		result.append(", durchfahrt: ");
		if (durchfahrtESet) result.append(durchfahrt); else result.append("<unset>");
		result.append(", richtungsText: ");
		result.append(richtungsText);
		result.append(", vonRichtungsText: ");
		result.append(vonRichtungsText);
		result.append(", hinweisText: ");
		result.append(hinweisText);
		result.append(", linienfahrwegID: ");
		result.append(linienfahrwegID);
		result.append(')');
		return result.toString();
	}

} //SollHaltTypeImpl
