/**
 */
package de.jena.vdv454_2017c.util;

import de.jena.vdv454_2017c.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.xml.type.AnyType;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see de.jena.vdv454_2017c.VDV453Incl454V2017cPackage
 * @generated
 */
public class VDV453Incl454V2017cAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static VDV453Incl454V2017cPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VDV453Incl454V2017cAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = VDV453Incl454V2017cPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VDV453Incl454V2017cSwitch<Adapter> modelSwitch =
		new VDV453Incl454V2017cSwitch<Adapter>() {
			@Override
			public Adapter caseAbbringerFahrtLoeschenType(AbbringerFahrtLoeschenType object) {
				return createAbbringerFahrtLoeschenTypeAdapter();
			}
			@Override
			public Adapter caseAbbringerInfoType(AbbringerInfoType object) {
				return createAbbringerInfoTypeAdapter();
			}
			@Override
			public Adapter caseAbbringernachrichtType(AbbringernachrichtType object) {
				return createAbbringernachrichtTypeAdapter();
			}
			@Override
			public Adapter caseAboANDType(AboANDType object) {
				return createAboANDTypeAdapter();
			}
			@Override
			public Adapter caseAboAnfrageType(AboAnfrageType object) {
				return createAboAnfrageTypeAdapter();
			}
			@Override
			public Adapter caseAboAntwortType(AboAntwortType object) {
				return createAboAntwortTypeAdapter();
			}
			@Override
			public Adapter caseAboASBRefType(AboASBRefType object) {
				return createAboASBRefTypeAdapter();
			}
			@Override
			public Adapter caseAboASBType(AboASBType object) {
				return createAboASBTypeAdapter();
			}
			@Override
			public Adapter caseAboAUSRefType(AboAUSRefType object) {
				return createAboAUSRefTypeAdapter();
			}
			@Override
			public Adapter caseAboAUSType(AboAUSType object) {
				return createAboAUSTypeAdapter();
			}
			@Override
			public Adapter caseAboAZBRefType(AboAZBRefType object) {
				return createAboAZBRefTypeAdapter();
			}
			@Override
			public Adapter caseAboAZBType(AboAZBType object) {
				return createAboAZBTypeAdapter();
			}
			@Override
			public Adapter caseAboVISType(AboVISType object) {
				return createAboVISTypeAdapter();
			}
			@Override
			public Adapter caseAktiveAbosType(AktiveAbosType object) {
				return createAktiveAbosTypeAdapter();
			}
			@Override
			public Adapter caseANDMeldungLoeschenType(ANDMeldungLoeschenType object) {
				return createANDMeldungLoeschenTypeAdapter();
			}
			@Override
			public Adapter caseANDMeldungType(ANDMeldungType object) {
				return createANDMeldungTypeAdapter();
			}
			@Override
			public Adapter caseANDNachrichtType(ANDNachrichtType object) {
				return createANDNachrichtTypeAdapter();
			}
			@Override
			public Adapter caseAnschlussPlanType(AnschlussPlanType object) {
				return createAnschlussPlanTypeAdapter();
			}
			@Override
			public Adapter caseAnschlussStatusType(AnschlussStatusType object) {
				return createAnschlussStatusTypeAdapter();
			}
			@Override
			public Adapter caseASBFahrplanlageType(ASBFahrplanlageType object) {
				return createASBFahrplanlageTypeAdapter();
			}
			@Override
			public Adapter caseASBFahrplanType(ASBFahrplanType object) {
				return createASBFahrplanTypeAdapter();
			}
			@Override
			public Adapter caseASBFahrtLoeschenType(ASBFahrtLoeschenType object) {
				return createASBFahrtLoeschenTypeAdapter();
			}
			@Override
			public Adapter caseAUSNachrichtType(AUSNachrichtType object) {
				return createAUSNachrichtTypeAdapter();
			}
			@Override
			public Adapter caseAZBFahrplanlageType(AZBFahrplanlageType object) {
				return createAZBFahrplanlageTypeAdapter();
			}
			@Override
			public Adapter caseAZBFahrplanType(AZBFahrplanType object) {
				return createAZBFahrplanTypeAdapter();
			}
			@Override
			public Adapter caseAZBFahrtLoeschenType(AZBFahrtLoeschenType object) {
				return createAZBFahrtLoeschenTypeAdapter();
			}
			@Override
			public Adapter caseAZBLinienspezialtextLoeschenType(AZBLinienspezialtextLoeschenType object) {
				return createAZBLinienspezialtextLoeschenTypeAdapter();
			}
			@Override
			public Adapter caseAZBLinienspezialtextType(AZBLinienspezialtextType object) {
				return createAZBLinienspezialtextTypeAdapter();
			}
			@Override
			public Adapter caseAZBNachrichtType(AZBNachrichtType object) {
				return createAZBNachrichtTypeAdapter();
			}
			@Override
			public Adapter caseAZBSondertextLoeschenType(AZBSondertextLoeschenType object) {
				return createAZBSondertextLoeschenTypeAdapter();
			}
			@Override
			public Adapter caseAZBSondertextType(AZBSondertextType object) {
				return createAZBSondertextTypeAdapter();
			}
			@Override
			public Adapter caseBestaetigungMitAboIDType(BestaetigungMitAboIDType object) {
				return createBestaetigungMitAboIDTypeAdapter();
			}
			@Override
			public Adapter caseBestaetigungType(BestaetigungType object) {
				return createBestaetigungTypeAdapter();
			}
			@Override
			public Adapter caseBetreiberFilterType(BetreiberFilterType object) {
				return createBetreiberFilterTypeAdapter();
			}
			@Override
			public Adapter caseBeziehungType(BeziehungType object) {
				return createBeziehungTypeAdapter();
			}
			@Override
			public Adapter caseBeziehungZuFahrtType(BeziehungZuFahrtType object) {
				return createBeziehungZuFahrtTypeAdapter();
			}
			@Override
			public Adapter caseClientStatusAnfrageType(ClientStatusAnfrageType object) {
				return createClientStatusAnfrageTypeAdapter();
			}
			@Override
			public Adapter caseClientStatusAntwortType(ClientStatusAntwortType object) {
				return createClientStatusAntwortTypeAdapter();
			}
			@Override
			public Adapter caseDatenAbrufenAnfrageType(DatenAbrufenAnfrageType object) {
				return createDatenAbrufenAnfrageTypeAdapter();
			}
			@Override
			public Adapter caseDatenAbrufenAntwortType(DatenAbrufenAntwortType object) {
				return createDatenAbrufenAntwortTypeAdapter();
			}
			@Override
			public Adapter caseDatenBereitAnfrageType(DatenBereitAnfrageType object) {
				return createDatenBereitAnfrageTypeAdapter();
			}
			@Override
			public Adapter caseDatenBereitAntwortType(DatenBereitAntwortType object) {
				return createDatenBereitAntwortTypeAdapter();
			}
			@Override
			public Adapter caseDirektrufType(DirektrufType object) {
				return createDirektrufTypeAdapter();
			}
			@Override
			public Adapter caseDocumentRoot(DocumentRoot object) {
				return createDocumentRootAdapter();
			}
			@Override
			public Adapter caseErweiterungType(ErweiterungType object) {
				return createErweiterungTypeAdapter();
			}
			@Override
			public Adapter caseFahrtFilterType(FahrtFilterType object) {
				return createFahrtFilterTypeAdapter();
			}
			@Override
			public Adapter caseFahrtIDAusGlobalType(FahrtIDAusGlobalType object) {
				return createFahrtIDAusGlobalTypeAdapter();
			}
			@Override
			public Adapter caseFahrtIDExtType(FahrtIDExtType object) {
				return createFahrtIDExtTypeAdapter();
			}
			@Override
			public Adapter caseFahrtIDGlobalType(FahrtIDGlobalType object) {
				return createFahrtIDGlobalTypeAdapter();
			}
			@Override
			public Adapter caseFahrtIDType(FahrtIDType object) {
				return createFahrtIDTypeAdapter();
			}
			@Override
			public Adapter caseFahrtInAbschnittType(FahrtInAbschnittType object) {
				return createFahrtInAbschnittTypeAdapter();
			}
			@Override
			public Adapter caseFahrtInfoType(FahrtInfoType object) {
				return createFahrtInfoTypeAdapter();
			}
			@Override
			public Adapter caseFahrtRefType(FahrtRefType object) {
				return createFahrtRefTypeAdapter();
			}
			@Override
			public Adapter caseFahrtStartEndeType(FahrtStartEndeType object) {
				return createFahrtStartEndeTypeAdapter();
			}
			@Override
			public Adapter caseFahrtVerbandsAbschnittType(FahrtVerbandsAbschnittType object) {
				return createFahrtVerbandsAbschnittTypeAdapter();
			}
			@Override
			public Adapter caseFahrtVerbandType(FahrtVerbandType object) {
				return createFahrtVerbandTypeAdapter();
			}
			@Override
			public Adapter caseFoAenderungAmHaltType(FoAenderungAmHaltType object) {
				return createFoAenderungAmHaltTypeAdapter();
			}
			@Override
			public Adapter caseFoAenderungenType(FoAenderungenType object) {
				return createFoAenderungenTypeAdapter();
			}
			@Override
			public Adapter caseFoAenderungenType1(FoAenderungenType1 object) {
				return createFoAenderungenType1Adapter();
			}
			@Override
			public Adapter caseFoAenderungsTexteType(FoAenderungsTexteType object) {
				return createFoAenderungsTexteTypeAdapter();
			}
			@Override
			public Adapter caseFoAnkunftAbfahrtType(FoAnkunftAbfahrtType object) {
				return createFoAnkunftAbfahrtTypeAdapter();
			}
			@Override
			public Adapter caseFoDurchgaengeType(FoDurchgaengeType object) {
				return createFoDurchgaengeTypeAdapter();
			}
			@Override
			public Adapter caseFoDurchgangType(FoDurchgangType object) {
				return createFoDurchgangTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrtAbschnittFahrzeugGruppenType(FoFahrtAbschnittFahrzeugGruppenType object) {
				return createFoFahrtAbschnittFahrzeugGruppenTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrtAbschnittFahrzeugGruppeType(FoFahrtAbschnittFahrzeugGruppeType object) {
				return createFoFahrtAbschnittFahrzeugGruppeTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugAmHaltType(FoFahrzeugAmHaltType object) {
				return createFoFahrzeugAmHaltTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugAusstattungenType(FoFahrzeugAusstattungenType object) {
				return createFoFahrzeugAusstattungenTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugAusstattungenZustaendeType(FoFahrzeugAusstattungenZustaendeType object) {
				return createFoFahrzeugAusstattungenZustaendeTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugAusstattungFahrtAbschnitteType(FoFahrzeugAusstattungFahrtAbschnitteType object) {
				return createFoFahrzeugAusstattungFahrtAbschnitteTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugAusstattungFahrtAbschnittType(FoFahrzeugAusstattungFahrtAbschnittType object) {
				return createFoFahrzeugAusstattungFahrtAbschnittTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugAusstattungType(FoFahrzeugAusstattungType object) {
				return createFoFahrzeugAusstattungTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugAusstattungZustandType(FoFahrzeugAusstattungZustandType object) {
				return createFoFahrzeugAusstattungZustandTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugBelegungFahrtAbschnitteType(FoFahrzeugBelegungFahrtAbschnitteType object) {
				return createFoFahrzeugBelegungFahrtAbschnitteTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugBelegungFahrtAbschnittType(FoFahrzeugBelegungFahrtAbschnittType object) {
				return createFoFahrzeugBelegungFahrtAbschnittTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugBelegungType(FoFahrzeugBelegungType object) {
				return createFoFahrzeugBelegungTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugeAmHaltType(FoFahrzeugeAmHaltType object) {
				return createFoFahrzeugeAmHaltTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugeBelegungenType(FoFahrzeugeBelegungenType object) {
				return createFoFahrzeugeBelegungenTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugePositionenType(FoFahrzeugePositionenType object) {
				return createFoFahrzeugePositionenTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugeType(FoFahrzeugeType object) {
				return createFoFahrzeugeTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugeZustaendeType(FoFahrzeugeZustaendeType object) {
				return createFoFahrzeugeZustaendeTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugGruppenFahrtAbschnitteType(FoFahrzeugGruppenFahrtAbschnitteType object) {
				return createFoFahrzeugGruppenFahrtAbschnitteTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugGruppenFahrtAbschnittType(FoFahrzeugGruppenFahrtAbschnittType object) {
				return createFoFahrzeugGruppenFahrtAbschnittTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugGruppenType(FoFahrzeugGruppenType object) {
				return createFoFahrzeugGruppenTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugGruppeType(FoFahrzeugGruppeType object) {
				return createFoFahrzeugGruppeTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugPositionType(FoFahrzeugPositionType object) {
				return createFoFahrzeugPositionTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugType(FoFahrzeugType object) {
				return createFoFahrzeugTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugZustandFahrtAbschnitteType(FoFahrzeugZustandFahrtAbschnitteType object) {
				return createFoFahrzeugZustandFahrtAbschnitteTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugZustandFahrtAbschnittType(FoFahrzeugZustandFahrtAbschnittType object) {
				return createFoFahrzeugZustandFahrtAbschnittTypeAdapter();
			}
			@Override
			public Adapter caseFoFahrzeugZustandType(FoFahrzeugZustandType object) {
				return createFoFahrzeugZustandTypeAdapter();
			}
			@Override
			public Adapter caseFoFormationAenderungType(FoFormationAenderungType object) {
				return createFoFormationAenderungTypeAdapter();
			}
			@Override
			public Adapter caseFoFremdFahrzeugeType(FoFremdFahrzeugeType object) {
				return createFoFremdFahrzeugeTypeAdapter();
			}
			@Override
			public Adapter caseFoHalteType(FoHalteType object) {
				return createFoHalteTypeAdapter();
			}
			@Override
			public Adapter caseFoHaltPositionType(FoHaltPositionType object) {
				return createFoHaltPositionTypeAdapter();
			}
			@Override
			public Adapter caseFoHaltType(FoHaltType object) {
				return createFoHaltTypeAdapter();
			}
			@Override
			public Adapter caseFoReisegruppenNamenType(FoReisegruppenNamenType object) {
				return createFoReisegruppenNamenTypeAdapter();
			}
			@Override
			public Adapter caseFoReisegruppenNameType(FoReisegruppenNameType object) {
				return createFoReisegruppenNameTypeAdapter();
			}
			@Override
			public Adapter caseFoReisegruppenType(FoReisegruppenType object) {
				return createFoReisegruppenTypeAdapter();
			}
			@Override
			public Adapter caseFormationType(FormationType object) {
				return createFormationTypeAdapter();
			}
			@Override
			public Adapter caseFoSektorHaltPositionType(FoSektorHaltPositionType object) {
				return createFoSektorHaltPositionTypeAdapter();
			}
			@Override
			public Adapter caseFoSektorPositionenType(FoSektorPositionenType object) {
				return createFoSektorPositionenTypeAdapter();
			}
			@Override
			public Adapter caseFoTechnischeAttributeType(FoTechnischeAttributeType object) {
				return createFoTechnischeAttributeTypeAdapter();
			}
			@Override
			public Adapter caseFoTechnischesAttributType(FoTechnischesAttributType object) {
				return createFoTechnischesAttributTypeAdapter();
			}
			@Override
			public Adapter caseFoZustandType(FoZustandType object) {
				return createFoZustandTypeAdapter();
			}
			@Override
			public Adapter caseGesAnschlussType(GesAnschlussType object) {
				return createGesAnschlussTypeAdapter();
			}
			@Override
			public Adapter caseHaltepositionsAenderungType(HaltepositionsAenderungType object) {
				return createHaltepositionsAenderungTypeAdapter();
			}
			@Override
			public Adapter caseHaltExtendedType(HaltExtendedType object) {
				return createHaltExtendedTypeAdapter();
			}
			@Override
			public Adapter caseHaltFilterType(HaltFilterType object) {
				return createHaltFilterTypeAdapter();
			}
			@Override
			public Adapter caseIstFahrtType(IstFahrtType object) {
				return createIstFahrtTypeAdapter();
			}
			@Override
			public Adapter caseIstHaltType(IstHaltType object) {
				return createIstHaltTypeAdapter();
			}
			@Override
			public Adapter caseIstUmlaufFahrtType(IstUmlaufFahrtType object) {
				return createIstUmlaufFahrtTypeAdapter();
			}
			@Override
			public Adapter caseIstUmlaufType(IstUmlaufType object) {
				return createIstUmlaufTypeAdapter();
			}
			@Override
			public Adapter caseLinienFahrplanType(LinienFahrplanType object) {
				return createLinienFahrplanTypeAdapter();
			}
			@Override
			public Adapter caseLinienFilterType(LinienFilterType object) {
				return createLinienFilterTypeAdapter();
			}
			@Override
			public Adapter caseMessageXMLType(MessageXMLType object) {
				return createMessageXMLTypeAdapter();
			}
			@Override
			public Adapter caseProduktFilterType(ProduktFilterType object) {
				return createProduktFilterTypeAdapter();
			}
			@Override
			public Adapter caseProtokolleintragType(ProtokolleintragType object) {
				return createProtokolleintragTypeAdapter();
			}
			@Override
			public Adapter caseServiceAttributType(ServiceAttributType object) {
				return createServiceAttributTypeAdapter();
			}
			@Override
			public Adapter caseSollAnschlussType(SollAnschlussType object) {
				return createSollAnschlussTypeAdapter();
			}
			@Override
			public Adapter caseSollFahrtType(SollFahrtType object) {
				return createSollFahrtTypeAdapter();
			}
			@Override
			public Adapter caseSollHaltType(SollHaltType object) {
				return createSollHaltTypeAdapter();
			}
			@Override
			public Adapter caseSollUmlaufFahrtType(SollUmlaufFahrtType object) {
				return createSollUmlaufFahrtTypeAdapter();
			}
			@Override
			public Adapter caseSollUmlaufType(SollUmlaufType object) {
				return createSollUmlaufTypeAdapter();
			}
			@Override
			public Adapter caseStatusAnfrageType(StatusAnfrageType object) {
				return createStatusAnfrageTypeAdapter();
			}
			@Override
			public Adapter caseStatusAntwortType(StatusAntwortType object) {
				return createStatusAntwortTypeAdapter();
			}
			@Override
			public Adapter caseStatusType(StatusType object) {
				return createStatusTypeAdapter();
			}
			@Override
			public Adapter caseStoerungsInfoType(StoerungsInfoType object) {
				return createStoerungsInfoTypeAdapter();
			}
			@Override
			public Adapter caseStreckenBezugType(StreckenBezugType object) {
				return createStreckenBezugTypeAdapter();
			}
			@Override
			public Adapter caseTextMitSprachCodeType(TextMitSprachCodeType object) {
				return createTextMitSprachCodeTypeAdapter();
			}
			@Override
			public Adapter caseTraktionsType(TraktionsType object) {
				return createTraktionsTypeAdapter();
			}
			@Override
			public Adapter caseUmlaufFilterType(UmlaufFilterType object) {
				return createUmlaufFilterTypeAdapter();
			}
			@Override
			public Adapter caseVerkehrsmittelTextFilterType(VerkehrsmittelTextFilterType object) {
				return createVerkehrsmittelTextFilterTypeAdapter();
			}
			@Override
			public Adapter caseViaType(ViaType object) {
				return createViaTypeAdapter();
			}
			@Override
			public Adapter caseVISFahrplanlageType(VISFahrplanlageType object) {
				return createVISFahrplanlageTypeAdapter();
			}
			@Override
			public Adapter caseVISFahrtLoeschenType(VISFahrtLoeschenType object) {
				return createVISFahrtLoeschenTypeAdapter();
			}
			@Override
			public Adapter caseVISNachrichtType(VISNachrichtType object) {
				return createVISNachrichtTypeAdapter();
			}
			@Override
			public Adapter caseWarteInfoType(WarteInfoType object) {
				return createWarteInfoTypeAdapter();
			}
			@Override
			public Adapter caseWartetBisType(WartetBisType object) {
				return createWartetBisTypeAdapter();
			}
			@Override
			public Adapter caseZeitfensterType(ZeitfensterType object) {
				return createZeitfensterTypeAdapter();
			}
			@Override
			public Adapter caseZeitFilterType(ZeitFilterType object) {
				return createZeitFilterTypeAdapter();
			}
			@Override
			public Adapter caseZeitQualitaetType(ZeitQualitaetType object) {
				return createZeitQualitaetTypeAdapter();
			}
			@Override
			public Adapter caseZubringernachrichtType(ZubringernachrichtType object) {
				return createZubringernachrichtTypeAdapter();
			}
			@Override
			public Adapter caseZurueckhaltungBisType(ZurueckhaltungBisType object) {
				return createZurueckhaltungBisTypeAdapter();
			}
			@Override
			public Adapter caseAnyType(AnyType object) {
				return createAnyTypeAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AbbringerFahrtLoeschenType <em>Abbringer Fahrt Loeschen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AbbringerFahrtLoeschenType
	 * @generated
	 */
	public Adapter createAbbringerFahrtLoeschenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AbbringerInfoType <em>Abbringer Info Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AbbringerInfoType
	 * @generated
	 */
	public Adapter createAbbringerInfoTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AbbringernachrichtType <em>Abbringernachricht Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AbbringernachrichtType
	 * @generated
	 */
	public Adapter createAbbringernachrichtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboANDType <em>Abo AND Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboANDType
	 * @generated
	 */
	public Adapter createAboANDTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboAnfrageType <em>Abo Anfrage Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboAnfrageType
	 * @generated
	 */
	public Adapter createAboAnfrageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboAntwortType <em>Abo Antwort Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboAntwortType
	 * @generated
	 */
	public Adapter createAboAntwortTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboASBRefType <em>Abo ASB Ref Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboASBRefType
	 * @generated
	 */
	public Adapter createAboASBRefTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboASBType <em>Abo ASB Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboASBType
	 * @generated
	 */
	public Adapter createAboASBTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboAUSRefType <em>Abo AUS Ref Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboAUSRefType
	 * @generated
	 */
	public Adapter createAboAUSRefTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboAUSType <em>Abo AUS Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboAUSType
	 * @generated
	 */
	public Adapter createAboAUSTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboAZBRefType <em>Abo AZB Ref Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboAZBRefType
	 * @generated
	 */
	public Adapter createAboAZBRefTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboAZBType <em>Abo AZB Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboAZBType
	 * @generated
	 */
	public Adapter createAboAZBTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AboVISType <em>Abo VIS Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AboVISType
	 * @generated
	 */
	public Adapter createAboVISTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AktiveAbosType <em>Aktive Abos Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AktiveAbosType
	 * @generated
	 */
	public Adapter createAktiveAbosTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ANDMeldungLoeschenType <em>AND Meldung Loeschen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ANDMeldungLoeschenType
	 * @generated
	 */
	public Adapter createANDMeldungLoeschenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ANDMeldungType <em>AND Meldung Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ANDMeldungType
	 * @generated
	 */
	public Adapter createANDMeldungTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ANDNachrichtType <em>AND Nachricht Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ANDNachrichtType
	 * @generated
	 */
	public Adapter createANDNachrichtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AnschlussPlanType <em>Anschluss Plan Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AnschlussPlanType
	 * @generated
	 */
	public Adapter createAnschlussPlanTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AnschlussStatusType <em>Anschluss Status Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AnschlussStatusType
	 * @generated
	 */
	public Adapter createAnschlussStatusTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ASBFahrplanlageType <em>ASB Fahrplanlage Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ASBFahrplanlageType
	 * @generated
	 */
	public Adapter createASBFahrplanlageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ASBFahrplanType <em>ASB Fahrplan Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ASBFahrplanType
	 * @generated
	 */
	public Adapter createASBFahrplanTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ASBFahrtLoeschenType <em>ASB Fahrt Loeschen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ASBFahrtLoeschenType
	 * @generated
	 */
	public Adapter createASBFahrtLoeschenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AUSNachrichtType <em>AUS Nachricht Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AUSNachrichtType
	 * @generated
	 */
	public Adapter createAUSNachrichtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AZBFahrplanlageType <em>AZB Fahrplanlage Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AZBFahrplanlageType
	 * @generated
	 */
	public Adapter createAZBFahrplanlageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AZBFahrplanType <em>AZB Fahrplan Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AZBFahrplanType
	 * @generated
	 */
	public Adapter createAZBFahrplanTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AZBFahrtLoeschenType <em>AZB Fahrt Loeschen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AZBFahrtLoeschenType
	 * @generated
	 */
	public Adapter createAZBFahrtLoeschenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AZBLinienspezialtextLoeschenType <em>AZB Linienspezialtext Loeschen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AZBLinienspezialtextLoeschenType
	 * @generated
	 */
	public Adapter createAZBLinienspezialtextLoeschenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AZBLinienspezialtextType <em>AZB Linienspezialtext Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AZBLinienspezialtextType
	 * @generated
	 */
	public Adapter createAZBLinienspezialtextTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AZBNachrichtType <em>AZB Nachricht Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AZBNachrichtType
	 * @generated
	 */
	public Adapter createAZBNachrichtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AZBSondertextLoeschenType <em>AZB Sondertext Loeschen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AZBSondertextLoeschenType
	 * @generated
	 */
	public Adapter createAZBSondertextLoeschenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.AZBSondertextType <em>AZB Sondertext Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.AZBSondertextType
	 * @generated
	 */
	public Adapter createAZBSondertextTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.BestaetigungMitAboIDType <em>Bestaetigung Mit Abo ID Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.BestaetigungMitAboIDType
	 * @generated
	 */
	public Adapter createBestaetigungMitAboIDTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.BestaetigungType <em>Bestaetigung Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.BestaetigungType
	 * @generated
	 */
	public Adapter createBestaetigungTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.BetreiberFilterType <em>Betreiber Filter Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.BetreiberFilterType
	 * @generated
	 */
	public Adapter createBetreiberFilterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.BeziehungType <em>Beziehung Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.BeziehungType
	 * @generated
	 */
	public Adapter createBeziehungTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.BeziehungZuFahrtType <em>Beziehung Zu Fahrt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.BeziehungZuFahrtType
	 * @generated
	 */
	public Adapter createBeziehungZuFahrtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ClientStatusAnfrageType <em>Client Status Anfrage Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ClientStatusAnfrageType
	 * @generated
	 */
	public Adapter createClientStatusAnfrageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ClientStatusAntwortType <em>Client Status Antwort Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ClientStatusAntwortType
	 * @generated
	 */
	public Adapter createClientStatusAntwortTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.DatenAbrufenAnfrageType <em>Daten Abrufen Anfrage Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.DatenAbrufenAnfrageType
	 * @generated
	 */
	public Adapter createDatenAbrufenAnfrageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.DatenAbrufenAntwortType <em>Daten Abrufen Antwort Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.DatenAbrufenAntwortType
	 * @generated
	 */
	public Adapter createDatenAbrufenAntwortTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.DatenBereitAnfrageType <em>Daten Bereit Anfrage Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.DatenBereitAnfrageType
	 * @generated
	 */
	public Adapter createDatenBereitAnfrageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.DatenBereitAntwortType <em>Daten Bereit Antwort Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.DatenBereitAntwortType
	 * @generated
	 */
	public Adapter createDatenBereitAntwortTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.DirektrufType <em>Direktruf Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.DirektrufType
	 * @generated
	 */
	public Adapter createDirektrufTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.DocumentRoot <em>Document Root</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.DocumentRoot
	 * @generated
	 */
	public Adapter createDocumentRootAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ErweiterungType <em>Erweiterung Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ErweiterungType
	 * @generated
	 */
	public Adapter createErweiterungTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtFilterType <em>Fahrt Filter Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtFilterType
	 * @generated
	 */
	public Adapter createFahrtFilterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtIDAusGlobalType <em>Fahrt ID Aus Global Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtIDAusGlobalType
	 * @generated
	 */
	public Adapter createFahrtIDAusGlobalTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtIDExtType <em>Fahrt ID Ext Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtIDExtType
	 * @generated
	 */
	public Adapter createFahrtIDExtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtIDGlobalType <em>Fahrt ID Global Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtIDGlobalType
	 * @generated
	 */
	public Adapter createFahrtIDGlobalTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtIDType <em>Fahrt ID Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtIDType
	 * @generated
	 */
	public Adapter createFahrtIDTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtInAbschnittType <em>Fahrt In Abschnitt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtInAbschnittType
	 * @generated
	 */
	public Adapter createFahrtInAbschnittTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtInfoType <em>Fahrt Info Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtInfoType
	 * @generated
	 */
	public Adapter createFahrtInfoTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtRefType <em>Fahrt Ref Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtRefType
	 * @generated
	 */
	public Adapter createFahrtRefTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtStartEndeType <em>Fahrt Start Ende Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtStartEndeType
	 * @generated
	 */
	public Adapter createFahrtStartEndeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtVerbandsAbschnittType <em>Fahrt Verbands Abschnitt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtVerbandsAbschnittType
	 * @generated
	 */
	public Adapter createFahrtVerbandsAbschnittTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FahrtVerbandType <em>Fahrt Verband Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FahrtVerbandType
	 * @generated
	 */
	public Adapter createFahrtVerbandTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoAenderungAmHaltType <em>Fo Aenderung Am Halt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoAenderungAmHaltType
	 * @generated
	 */
	public Adapter createFoAenderungAmHaltTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoAenderungenType <em>Fo Aenderungen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoAenderungenType
	 * @generated
	 */
	public Adapter createFoAenderungenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoAenderungenType1 <em>Fo Aenderungen Type1</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoAenderungenType1
	 * @generated
	 */
	public Adapter createFoAenderungenType1Adapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoAenderungsTexteType <em>Fo Aenderungs Texte Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoAenderungsTexteType
	 * @generated
	 */
	public Adapter createFoAenderungsTexteTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoAnkunftAbfahrtType <em>Fo Ankunft Abfahrt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoAnkunftAbfahrtType
	 * @generated
	 */
	public Adapter createFoAnkunftAbfahrtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoDurchgaengeType <em>Fo Durchgaenge Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoDurchgaengeType
	 * @generated
	 */
	public Adapter createFoDurchgaengeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoDurchgangType <em>Fo Durchgang Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoDurchgangType
	 * @generated
	 */
	public Adapter createFoDurchgangTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrtAbschnittFahrzeugGruppenType <em>Fo Fahrt Abschnitt Fahrzeug Gruppen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrtAbschnittFahrzeugGruppenType
	 * @generated
	 */
	public Adapter createFoFahrtAbschnittFahrzeugGruppenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrtAbschnittFahrzeugGruppeType <em>Fo Fahrt Abschnitt Fahrzeug Gruppe Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrtAbschnittFahrzeugGruppeType
	 * @generated
	 */
	public Adapter createFoFahrtAbschnittFahrzeugGruppeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugAmHaltType <em>Fo Fahrzeug Am Halt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugAmHaltType
	 * @generated
	 */
	public Adapter createFoFahrzeugAmHaltTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugAusstattungenType <em>Fo Fahrzeug Ausstattungen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugAusstattungenType
	 * @generated
	 */
	public Adapter createFoFahrzeugAusstattungenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugAusstattungenZustaendeType <em>Fo Fahrzeug Ausstattungen Zustaende Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugAusstattungenZustaendeType
	 * @generated
	 */
	public Adapter createFoFahrzeugAusstattungenZustaendeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugAusstattungFahrtAbschnitteType <em>Fo Fahrzeug Ausstattung Fahrt Abschnitte Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugAusstattungFahrtAbschnitteType
	 * @generated
	 */
	public Adapter createFoFahrzeugAusstattungFahrtAbschnitteTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugAusstattungFahrtAbschnittType <em>Fo Fahrzeug Ausstattung Fahrt Abschnitt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugAusstattungFahrtAbschnittType
	 * @generated
	 */
	public Adapter createFoFahrzeugAusstattungFahrtAbschnittTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugAusstattungType <em>Fo Fahrzeug Ausstattung Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugAusstattungType
	 * @generated
	 */
	public Adapter createFoFahrzeugAusstattungTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugAusstattungZustandType <em>Fo Fahrzeug Ausstattung Zustand Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugAusstattungZustandType
	 * @generated
	 */
	public Adapter createFoFahrzeugAusstattungZustandTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugBelegungFahrtAbschnitteType <em>Fo Fahrzeug Belegung Fahrt Abschnitte Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugBelegungFahrtAbschnitteType
	 * @generated
	 */
	public Adapter createFoFahrzeugBelegungFahrtAbschnitteTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugBelegungFahrtAbschnittType <em>Fo Fahrzeug Belegung Fahrt Abschnitt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugBelegungFahrtAbschnittType
	 * @generated
	 */
	public Adapter createFoFahrzeugBelegungFahrtAbschnittTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugBelegungType <em>Fo Fahrzeug Belegung Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugBelegungType
	 * @generated
	 */
	public Adapter createFoFahrzeugBelegungTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugeAmHaltType <em>Fo Fahrzeuge Am Halt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugeAmHaltType
	 * @generated
	 */
	public Adapter createFoFahrzeugeAmHaltTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugeBelegungenType <em>Fo Fahrzeuge Belegungen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugeBelegungenType
	 * @generated
	 */
	public Adapter createFoFahrzeugeBelegungenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugePositionenType <em>Fo Fahrzeuge Positionen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugePositionenType
	 * @generated
	 */
	public Adapter createFoFahrzeugePositionenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugeType <em>Fo Fahrzeuge Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugeType
	 * @generated
	 */
	public Adapter createFoFahrzeugeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugeZustaendeType <em>Fo Fahrzeuge Zustaende Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugeZustaendeType
	 * @generated
	 */
	public Adapter createFoFahrzeugeZustaendeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugGruppenFahrtAbschnitteType <em>Fo Fahrzeug Gruppen Fahrt Abschnitte Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugGruppenFahrtAbschnitteType
	 * @generated
	 */
	public Adapter createFoFahrzeugGruppenFahrtAbschnitteTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugGruppenFahrtAbschnittType <em>Fo Fahrzeug Gruppen Fahrt Abschnitt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugGruppenFahrtAbschnittType
	 * @generated
	 */
	public Adapter createFoFahrzeugGruppenFahrtAbschnittTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugGruppenType <em>Fo Fahrzeug Gruppen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugGruppenType
	 * @generated
	 */
	public Adapter createFoFahrzeugGruppenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugGruppeType <em>Fo Fahrzeug Gruppe Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugGruppeType
	 * @generated
	 */
	public Adapter createFoFahrzeugGruppeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugPositionType <em>Fo Fahrzeug Position Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugPositionType
	 * @generated
	 */
	public Adapter createFoFahrzeugPositionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugType <em>Fo Fahrzeug Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugType
	 * @generated
	 */
	public Adapter createFoFahrzeugTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugZustandFahrtAbschnitteType <em>Fo Fahrzeug Zustand Fahrt Abschnitte Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugZustandFahrtAbschnitteType
	 * @generated
	 */
	public Adapter createFoFahrzeugZustandFahrtAbschnitteTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugZustandFahrtAbschnittType <em>Fo Fahrzeug Zustand Fahrt Abschnitt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugZustandFahrtAbschnittType
	 * @generated
	 */
	public Adapter createFoFahrzeugZustandFahrtAbschnittTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFahrzeugZustandType <em>Fo Fahrzeug Zustand Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFahrzeugZustandType
	 * @generated
	 */
	public Adapter createFoFahrzeugZustandTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFormationAenderungType <em>Fo Formation Aenderung Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFormationAenderungType
	 * @generated
	 */
	public Adapter createFoFormationAenderungTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoFremdFahrzeugeType <em>Fo Fremd Fahrzeuge Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoFremdFahrzeugeType
	 * @generated
	 */
	public Adapter createFoFremdFahrzeugeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoHalteType <em>Fo Halte Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoHalteType
	 * @generated
	 */
	public Adapter createFoHalteTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoHaltPositionType <em>Fo Halt Position Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoHaltPositionType
	 * @generated
	 */
	public Adapter createFoHaltPositionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoHaltType <em>Fo Halt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoHaltType
	 * @generated
	 */
	public Adapter createFoHaltTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoReisegruppenNamenType <em>Fo Reisegruppen Namen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoReisegruppenNamenType
	 * @generated
	 */
	public Adapter createFoReisegruppenNamenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoReisegruppenNameType <em>Fo Reisegruppen Name Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoReisegruppenNameType
	 * @generated
	 */
	public Adapter createFoReisegruppenNameTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoReisegruppenType <em>Fo Reisegruppen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoReisegruppenType
	 * @generated
	 */
	public Adapter createFoReisegruppenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FormationType <em>Formation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FormationType
	 * @generated
	 */
	public Adapter createFormationTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoSektorHaltPositionType <em>Fo Sektor Halt Position Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoSektorHaltPositionType
	 * @generated
	 */
	public Adapter createFoSektorHaltPositionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoSektorPositionenType <em>Fo Sektor Positionen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoSektorPositionenType
	 * @generated
	 */
	public Adapter createFoSektorPositionenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoTechnischeAttributeType <em>Fo Technische Attribute Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoTechnischeAttributeType
	 * @generated
	 */
	public Adapter createFoTechnischeAttributeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoTechnischesAttributType <em>Fo Technisches Attribut Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoTechnischesAttributType
	 * @generated
	 */
	public Adapter createFoTechnischesAttributTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.FoZustandType <em>Fo Zustand Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.FoZustandType
	 * @generated
	 */
	public Adapter createFoZustandTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.GesAnschlussType <em>Ges Anschluss Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.GesAnschlussType
	 * @generated
	 */
	public Adapter createGesAnschlussTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.HaltepositionsAenderungType <em>Haltepositions Aenderung Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.HaltepositionsAenderungType
	 * @generated
	 */
	public Adapter createHaltepositionsAenderungTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.HaltExtendedType <em>Halt Extended Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.HaltExtendedType
	 * @generated
	 */
	public Adapter createHaltExtendedTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.HaltFilterType <em>Halt Filter Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.HaltFilterType
	 * @generated
	 */
	public Adapter createHaltFilterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.IstFahrtType <em>Ist Fahrt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.IstFahrtType
	 * @generated
	 */
	public Adapter createIstFahrtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.IstHaltType <em>Ist Halt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.IstHaltType
	 * @generated
	 */
	public Adapter createIstHaltTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.IstUmlaufFahrtType <em>Ist Umlauf Fahrt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.IstUmlaufFahrtType
	 * @generated
	 */
	public Adapter createIstUmlaufFahrtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.IstUmlaufType <em>Ist Umlauf Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.IstUmlaufType
	 * @generated
	 */
	public Adapter createIstUmlaufTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.LinienFahrplanType <em>Linien Fahrplan Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.LinienFahrplanType
	 * @generated
	 */
	public Adapter createLinienFahrplanTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.LinienFilterType <em>Linien Filter Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.LinienFilterType
	 * @generated
	 */
	public Adapter createLinienFilterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.MessageXMLType <em>Message XML Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.MessageXMLType
	 * @generated
	 */
	public Adapter createMessageXMLTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ProduktFilterType <em>Produkt Filter Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ProduktFilterType
	 * @generated
	 */
	public Adapter createProduktFilterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ProtokolleintragType <em>Protokolleintrag Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ProtokolleintragType
	 * @generated
	 */
	public Adapter createProtokolleintragTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ServiceAttributType <em>Service Attribut Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ServiceAttributType
	 * @generated
	 */
	public Adapter createServiceAttributTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.SollAnschlussType <em>Soll Anschluss Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.SollAnschlussType
	 * @generated
	 */
	public Adapter createSollAnschlussTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.SollFahrtType <em>Soll Fahrt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.SollFahrtType
	 * @generated
	 */
	public Adapter createSollFahrtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.SollHaltType <em>Soll Halt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.SollHaltType
	 * @generated
	 */
	public Adapter createSollHaltTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.SollUmlaufFahrtType <em>Soll Umlauf Fahrt Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.SollUmlaufFahrtType
	 * @generated
	 */
	public Adapter createSollUmlaufFahrtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.SollUmlaufType <em>Soll Umlauf Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.SollUmlaufType
	 * @generated
	 */
	public Adapter createSollUmlaufTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.StatusAnfrageType <em>Status Anfrage Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.StatusAnfrageType
	 * @generated
	 */
	public Adapter createStatusAnfrageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.StatusAntwortType <em>Status Antwort Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.StatusAntwortType
	 * @generated
	 */
	public Adapter createStatusAntwortTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.StatusType <em>Status Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.StatusType
	 * @generated
	 */
	public Adapter createStatusTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.StoerungsInfoType <em>Stoerungs Info Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.StoerungsInfoType
	 * @generated
	 */
	public Adapter createStoerungsInfoTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.StreckenBezugType <em>Strecken Bezug Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.StreckenBezugType
	 * @generated
	 */
	public Adapter createStreckenBezugTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.TextMitSprachCodeType <em>Text Mit Sprach Code Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.TextMitSprachCodeType
	 * @generated
	 */
	public Adapter createTextMitSprachCodeTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.TraktionsType <em>Traktions Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.TraktionsType
	 * @generated
	 */
	public Adapter createTraktionsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.UmlaufFilterType <em>Umlauf Filter Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.UmlaufFilterType
	 * @generated
	 */
	public Adapter createUmlaufFilterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.VerkehrsmittelTextFilterType <em>Verkehrsmittel Text Filter Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.VerkehrsmittelTextFilterType
	 * @generated
	 */
	public Adapter createVerkehrsmittelTextFilterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ViaType <em>Via Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ViaType
	 * @generated
	 */
	public Adapter createViaTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.VISFahrplanlageType <em>VIS Fahrplanlage Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.VISFahrplanlageType
	 * @generated
	 */
	public Adapter createVISFahrplanlageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.VISFahrtLoeschenType <em>VIS Fahrt Loeschen Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.VISFahrtLoeschenType
	 * @generated
	 */
	public Adapter createVISFahrtLoeschenTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.VISNachrichtType <em>VIS Nachricht Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.VISNachrichtType
	 * @generated
	 */
	public Adapter createVISNachrichtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.WarteInfoType <em>Warte Info Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.WarteInfoType
	 * @generated
	 */
	public Adapter createWarteInfoTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.WartetBisType <em>Wartet Bis Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.WartetBisType
	 * @generated
	 */
	public Adapter createWartetBisTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ZeitfensterType <em>Zeitfenster Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ZeitfensterType
	 * @generated
	 */
	public Adapter createZeitfensterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ZeitFilterType <em>Zeit Filter Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ZeitFilterType
	 * @generated
	 */
	public Adapter createZeitFilterTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ZeitQualitaetType <em>Zeit Qualitaet Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ZeitQualitaetType
	 * @generated
	 */
	public Adapter createZeitQualitaetTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ZubringernachrichtType <em>Zubringernachricht Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ZubringernachrichtType
	 * @generated
	 */
	public Adapter createZubringernachrichtTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.jena.vdv454_2017c.ZurueckhaltungBisType <em>Zurueckhaltung Bis Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.jena.vdv454_2017c.ZurueckhaltungBisType
	 * @generated
	 */
	public Adapter createZurueckhaltungBisTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.xml.type.AnyType <em>Any Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.ecore.xml.type.AnyType
	 * @generated
	 */
	public Adapter createAnyTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //VDV453Incl454V2017cAdapterFactory
