/*
 */
package siri;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.util.FeatureMap;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Document Root</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link siri.DocumentRoot#getMixed <em>Mixed</em>}</li>
 *   <li>{@link siri.DocumentRoot#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}</li>
 *   <li>{@link siri.DocumentRoot#getXSISchemaLocation <em>XSI Schema Location</em>}</li>
 *   <li>{@link siri.DocumentRoot#getEnvironmentReason <em>Environment Reason</em>}</li>
 *   <li>{@link siri.DocumentRoot#getEquipmentReason <em>Equipment Reason</em>}</li>
 *   <li>{@link siri.DocumentRoot#getMiscellaneousReason <em>Miscellaneous Reason</em>}</li>
 *   <li>{@link siri.DocumentRoot#getPersonnelReason <em>Personnel Reason</em>}</li>
 *   <li>{@link siri.DocumentRoot#getSituationNumber <em>Situation Number</em>}</li>
 *   <li>{@link siri.DocumentRoot#getUndefinedReason <em>Undefined Reason</em>}</li>
 *   <li>{@link siri.DocumentRoot#getUnknownReason <em>Unknown Reason</em>}</li>
 * </ul>
 *
 * @see siri.SiriPackage#getDocumentRoot()
 * @model extendedMetaData="name='' kind='mixed'"
 * @generated
 */
@ProviderType
public interface DocumentRoot extends EObject {
	/**
	 * Returns the value of the '<em><b>Mixed</b></em>' attribute list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mixed</em>' attribute list.
	 * @see siri.SiriPackage#getDocumentRoot_Mixed()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry" many="true"
	 *        extendedMetaData="kind='elementWildcard' name=':mixed'"
	 * @generated
	 */
	FeatureMap getMixed();

	/**
	 * Returns the value of the '<em><b>XMLNS Prefix Map</b></em>' map.
	 * The key is of type {@link java.lang.String},
	 * and the value is of type {@link java.lang.String},
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>XMLNS Prefix Map</em>' map.
	 * @see siri.SiriPackage#getDocumentRoot_XMLNSPrefixMap()
	 * @model mapType="org.eclipse.emf.ecore.EStringToStringMapEntry&lt;org.eclipse.emf.ecore.EString, org.eclipse.emf.ecore.EString&gt;" transient="true"
	 *        extendedMetaData="kind='attribute' name='xmlns:prefix'"
	 * @generated
	 */
	EMap<String, String> getXMLNSPrefixMap();

	/**
	 * Returns the value of the '<em><b>XSI Schema Location</b></em>' map.
	 * The key is of type {@link java.lang.String},
	 * and the value is of type {@link java.lang.String},
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>XSI Schema Location</em>' map.
	 * @see siri.SiriPackage#getDocumentRoot_XSISchemaLocation()
	 * @model mapType="org.eclipse.emf.ecore.EStringToStringMapEntry&lt;org.eclipse.emf.ecore.EString, org.eclipse.emf.ecore.EString&gt;" transient="true"
	 *        extendedMetaData="kind='attribute' name='xsi:schemaLocation'"
	 * @generated
	 */
	EMap<String, String> getXSISchemaLocation();

	/**
	 * Returns the value of the '<em><b>Environment Reason</b></em>' attribute.
	 * The literals are from the enumeration {@link siri.EnvironmentReasonEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_4/TPEG Pti_22 environment event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Environment Reason</em>' attribute.
	 * @see siri.EnvironmentReasonEnumeration
	 * @see #setEnvironmentReason(EnvironmentReasonEnumeration)
	 * @see siri.SiriPackage#getDocumentRoot_EnvironmentReason()
	 * @model unique="false" upper="-2" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='EnvironmentReason' namespace='##targetNamespace'"
	 * @generated
	 */
	EnvironmentReasonEnumeration getEnvironmentReason();

	/**
	 * Sets the value of the '{@link siri.DocumentRoot#getEnvironmentReason <em>Environment Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Environment Reason</em>' attribute.
	 * @see siri.EnvironmentReasonEnumeration
	 * @see #getEnvironmentReason()
	 * @generated
	 */
	void setEnvironmentReason(EnvironmentReasonEnumeration value);

	/**
	 * Returns the value of the '<em><b>Equipment Reason</b></em>' attribute.
	 * The literals are from the enumeration {@link siri.EquipmentReasonEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_3/TPEG Pti_21 equipment event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Equipment Reason</em>' attribute.
	 * @see siri.EquipmentReasonEnumeration
	 * @see #setEquipmentReason(EquipmentReasonEnumeration)
	 * @see siri.SiriPackage#getDocumentRoot_EquipmentReason()
	 * @model unique="false" upper="-2" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='EquipmentReason' namespace='##targetNamespace'"
	 * @generated
	 */
	EquipmentReasonEnumeration getEquipmentReason();

	/**
	 * Sets the value of the '{@link siri.DocumentRoot#getEquipmentReason <em>Equipment Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Equipment Reason</em>' attribute.
	 * @see siri.EquipmentReasonEnumeration
	 * @see #getEquipmentReason()
	 * @generated
	 */
	void setEquipmentReason(EquipmentReasonEnumeration value);

	/**
	 * Returns the value of the '<em><b>Miscellaneous Reason</b></em>' attribute.
	 * The literals are from the enumeration {@link siri.MiscellaneousReasonEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_1/TPEG Pti_19 miscellaneous event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Miscellaneous Reason</em>' attribute.
	 * @see siri.MiscellaneousReasonEnumeration
	 * @see #setMiscellaneousReason(MiscellaneousReasonEnumeration)
	 * @see siri.SiriPackage#getDocumentRoot_MiscellaneousReason()
	 * @model unique="false" upper="-2" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='MiscellaneousReason' namespace='##targetNamespace'"
	 * @generated
	 */
	MiscellaneousReasonEnumeration getMiscellaneousReason();

	/**
	 * Sets the value of the '{@link siri.DocumentRoot#getMiscellaneousReason <em>Miscellaneous Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Miscellaneous Reason</em>' attribute.
	 * @see siri.MiscellaneousReasonEnumeration
	 * @see #getMiscellaneousReason()
	 * @generated
	 */
	void setMiscellaneousReason(MiscellaneousReasonEnumeration value);

	/**
	 * Returns the value of the '<em><b>Personnel Reason</b></em>' attribute.
	 * The literals are from the enumeration {@link siri.PersonnelReasonEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_2/TPEG Pti_20 personnel event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Personnel Reason</em>' attribute.
	 * @see siri.PersonnelReasonEnumeration
	 * @see #setPersonnelReason(PersonnelReasonEnumeration)
	 * @see siri.SiriPackage#getDocumentRoot_PersonnelReason()
	 * @model unique="false" upper="-2" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='PersonnelReason' namespace='##targetNamespace'"
	 * @generated
	 */
	PersonnelReasonEnumeration getPersonnelReason();

	/**
	 * Sets the value of the '{@link siri.DocumentRoot#getPersonnelReason <em>Personnel Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Personnel Reason</em>' attribute.
	 * @see siri.PersonnelReasonEnumeration
	 * @see #getPersonnelReason()
	 * @generated
	 */
	void setPersonnelReason(PersonnelReasonEnumeration value);

	/**
	 * Returns the value of the '<em><b>Situation Number</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Identifier of SITUATION within a Participant. Excldue versionr.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Situation Number</em>' containment reference.
	 * @see #setSituationNumber(EntryQualifierStructure)
	 * @see siri.SiriPackage#getDocumentRoot_SituationNumber()
	 * @model containment="true" upper="-2" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='SituationNumber' namespace='##targetNamespace'"
	 * @generated
	 */
	EntryQualifierStructure getSituationNumber();

	/**
	 * Sets the value of the '{@link siri.DocumentRoot#getSituationNumber <em>Situation Number</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Situation Number</em>' containment reference.
	 * @see #getSituationNumber()
	 * @generated
	 */
	void setSituationNumber(EntryQualifierStructure value);

	/**
	 * Returns the value of the '<em><b>Undefined Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_255/TPEG Pti_22 undefined event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Undefined Reason</em>' attribute.
	 * @see #setUndefinedReason(String)
	 * @see siri.SiriPackage#getDocumentRoot_UndefinedReason()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" upper="-2" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='UndefinedReason' namespace='##targetNamespace'"
	 * @generated
	 */
	String getUndefinedReason();

	/**
	 * Sets the value of the '{@link siri.DocumentRoot#getUndefinedReason <em>Undefined Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Undefined Reason</em>' attribute.
	 * @see #getUndefinedReason()
	 * @generated
	 */
	void setUndefinedReason(String value);

	/**
	 * Returns the value of the '<em><b>Unknown Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti18_0/TPEG unknown event reason.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Unknown Reason</em>' attribute.
	 * @see #setUnknownReason(String)
	 * @see siri.SiriPackage#getDocumentRoot_UnknownReason()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" upper="-2" transient="true" volatile="true" derived="true"
	 *        extendedMetaData="kind='element' name='UnknownReason' namespace='##targetNamespace'"
	 * @generated
	 */
	String getUnknownReason();

	/**
	 * Sets the value of the '{@link siri.DocumentRoot#getUnknownReason <em>Unknown Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Unknown Reason</em>' attribute.
	 * @see #getUnknownReason()
	 * @generated
	 */
	void setUnknownReason(String value);

} // DocumentRoot
