/*
 */
package siri;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Equipment Reason Enumeration</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Values for Equipment incident reason types TPEG Pti18_3/TPEG Pti_21.
 * <!-- end-model-doc -->
 * @see siri.SiriPackage#getEquipmentReasonEnumeration()
 * @model extendedMetaData="name='EquipmentReasonEnumeration'"
 * @generated
 */
@ProviderType
public enum EquipmentReasonEnumeration implements Enumerator {
	/**
	 * The '<em><b>Pti210</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI210_VALUE
	 * @generated
	 * @ordered
	 */
	PTI210(0, "pti210", "pti21_0"),

	/**
	 * The '<em><b>Unknown</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_0 unknown.
	 * <!-- end-model-doc -->
	 * @see #UNKNOWN_VALUE
	 * @generated
	 * @ordered
	 */
	UNKNOWN(1, "unknown", "unknown"),

	/**
	 * The '<em><b>Pti211</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI211_VALUE
	 * @generated
	 * @ordered
	 */
	PTI211(2, "pti211", "pti21_1"),

	/**
	 * The '<em><b>Points Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_1 points problem.
	 * <!-- end-model-doc -->
	 * @see #POINTS_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	POINTS_PROBLEM(3, "pointsProblem", "pointsProblem"),

	/**
	 * The '<em><b>Pti212</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI212_VALUE
	 * @generated
	 * @ordered
	 */
	PTI212(4, "pti212", "pti21_2"),

	/**
	 * The '<em><b>Points Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_2 points failure.
	 * <!-- end-model-doc -->
	 * @see #POINTS_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	POINTS_FAILURE(5, "pointsFailure", "pointsFailure"),

	/**
	 * The '<em><b>Pti213</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI213_VALUE
	 * @generated
	 * @ordered
	 */
	PTI213(6, "pti213", "pti21_3"),

	/**
	 * The '<em><b>Signal Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_3 signal problem.
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	SIGNAL_PROBLEM(7, "signalProblem", "signalProblem"),

	/**
	 * The '<em><b>Pti213 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI213_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI213_ALIAS1(8, "pti213Alias1", "pti21_3_Alias_1"),

	/**
	 * The '<em><b>Train Warning System Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Train warning system eg TPWSAlias to TPEG Pti21_3 signal problem.
	 * <!-- end-model-doc -->
	 * @see #TRAIN_WARNING_SYSTEM_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	TRAIN_WARNING_SYSTEM_PROBLEM(9, "trainWarningSystemProblem", "trainWarningSystemProblem"),

	/**
	 * The '<em><b>Pti213 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI213_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI213_ALIAS2(10, "pti213Alias2", "pti21_3_Alias_2"),

	/**
	 * The '<em><b>Track Circuit Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Track circuit alias to TPEG Pti21_3 signal problem.
	 * <!-- end-model-doc -->
	 * @see #TRACK_CIRCUIT_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	TRACK_CIRCUIT_PROBLEM(11, "trackCircuitProblem", "trackCircuitProblem"),

	/**
	 * The '<em><b>Pti214</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI214_VALUE
	 * @generated
	 * @ordered
	 */
	PTI214(12, "pti214", "pti21_4"),

	/**
	 * The '<em><b>Signal Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_4 signal failure.
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	SIGNAL_FAILURE(13, "signalFailure", "signalFailure"),

	/**
	 * The '<em><b>Pti214 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI214_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI214_ALIAS1(14, "pti214Alias1", "pti21_4_Alias_1"),

	/**
	 * The '<em><b>Signal And Switch Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_4 signal failure.
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_AND_SWITCH_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	SIGNAL_AND_SWITCH_FAILURE(15, "signalAndSwitchFailure", "signalAndSwitchFailure"),

	/**
	 * The '<em><b>Pti215</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI215_VALUE
	 * @generated
	 * @ordered
	 */
	PTI215(16, "pti215", "pti21_5"),

	/**
	 * The '<em><b>Derailment</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_5 derailment.
	 * <!-- end-model-doc -->
	 * @see #DERAILMENT_VALUE
	 * @generated
	 * @ordered
	 */
	DERAILMENT(17, "derailment", "derailment"),

	/**
	 * The '<em><b>Pti216</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI216_VALUE
	 * @generated
	 * @ordered
	 */
	PTI216(18, "pti216", "pti21_6"),

	/**
	 * The '<em><b>Engine Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_6 engine failure.
	 * <!-- end-model-doc -->
	 * @see #ENGINE_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	ENGINE_FAILURE(19, "engineFailure", "engineFailure"),

	/**
	 * The '<em><b>Pti216 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI216_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI216_ALIAS1(20, "pti216Alias1", "pti21_6_Alias_1"),

	/**
	 * The '<em><b>Traction Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * traction failure alais to TPEG Pti21_6 engine failure.
	 * <!-- end-model-doc -->
	 * @see #TRACTION_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	TRACTION_FAILURE(21, "tractionFailure", "tractionFailure"),

	/**
	 * The '<em><b>Pti217</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI217_VALUE
	 * @generated
	 * @ordered
	 */
	PTI217(22, "pti217", "pti21_7"),

	/**
	 * The '<em><b>Break Down</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_7 break down.
	 * <!-- end-model-doc -->
	 * @see #BREAK_DOWN_VALUE
	 * @generated
	 * @ordered
	 */
	BREAK_DOWN(23, "breakDown", "breakDown"),

	/**
	 * The '<em><b>Pti218</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218(24, "pti218", "pti21_8"),

	/**
	 * The '<em><b>Technical Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #TECHNICAL_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	TECHNICAL_PROBLEM(25, "technicalProblem", "technicalProblem"),

	/**
	 * The '<em><b>Pti218 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS1(26, "pti218Alias1", "pti21_8_Alias_1"),

	/**
	 * The '<em><b>Broken Rail</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Broken rail - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #BROKEN_RAIL_VALUE
	 * @generated
	 * @ordered
	 */
	BROKEN_RAIL(27, "brokenRail", "brokenRail"),

	/**
	 * The '<em><b>Pti218 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS2(28, "pti218Alias2", "pti21_8_Alias_2"),

	/**
	 * The '<em><b>Poor Rail Conditions</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * poor rail conditions - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #POOR_RAIL_CONDITIONS_VALUE
	 * @generated
	 * @ordered
	 */
	POOR_RAIL_CONDITIONS(29, "poorRailConditions", "poorRailConditions"),

	/**
	 * The '<em><b>Pti218 Alias3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS3_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS3(30, "pti218Alias3", "pti21_8_Alias_3"),

	/**
	 * The '<em><b>Wheel Impact Load</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Wheel Impact Load detectedi by trackside equipment alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #WHEEL_IMPACT_LOAD_VALUE
	 * @generated
	 * @ordered
	 */
	WHEEL_IMPACT_LOAD(31, "wheelImpactLoad", "wheelImpactLoad"),

	/**
	 * The '<em><b>Pti218 Alias4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS4_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS4(32, "pti218Alias4", "pti21_8_Alias_4"),

	/**
	 * The '<em><b>Lack Of Operational Stock</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * late lack of operational stock - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #LACK_OF_OPERATIONAL_STOCK_VALUE
	 * @generated
	 * @ordered
	 */
	LACK_OF_OPERATIONAL_STOCK(33, "lackOfOperationalStock", "lackOfOperationalStock"),

	/**
	 * The '<em><b>Pti218 Alias5</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS5_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS5(34, "pti218Alias5", "pti21_8_Alias_5"),

	/**
	 * The '<em><b>Defective Fire Alarm Equipment</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * defective fire alarm equipment - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #DEFECTIVE_FIRE_ALARM_EQUIPMENT_VALUE
	 * @generated
	 * @ordered
	 */
	DEFECTIVE_FIRE_ALARM_EQUIPMENT(35, "defectiveFireAlarmEquipment", "defectiveFireAlarmEquipment"),

	/**
	 * The '<em><b>Pti218 Alias6</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS6_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS6(36, "pti218Alias6", "pti21_8_Alias_6"),

	/**
	 * The '<em><b>Defective Platform Edge Doors</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * defective PEDs (platform edge doors) - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #DEFECTIVE_PLATFORM_EDGE_DOORS_VALUE
	 * @generated
	 * @ordered
	 */
	DEFECTIVE_PLATFORM_EDGE_DOORS(37, "defectivePlatformEdgeDoors", "defectivePlatformEdgeDoors"),

	/**
	 * The '<em><b>Pti218 Alias7</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS7_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS7(38, "pti218Alias7", "pti21_8_Alias_7"),

	/**
	 * The '<em><b>Defective Cctv</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * defective CCTV - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #DEFECTIVE_CCTV_VALUE
	 * @generated
	 * @ordered
	 */
	DEFECTIVE_CCTV(39, "defectiveCctv", "defectiveCctv"),

	/**
	 * The '<em><b>Pti218 Alias8</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS8_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS8(40, "pti218Alias8", "pti21_8_Alias_8"),

	/**
	 * The '<em><b>Defective Public Announcement System</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * defective PA - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM_VALUE
	 * @generated
	 * @ordered
	 */
	DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM(41, "defectivePublicAnnouncementSystem", "defectivePublicAnnouncementSystem"),

	/**
	 * The '<em><b>Pti218 Alias9</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS9_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS9(42, "pti218Alias9", "pti21_8_Alias_9"),

	/**
	 * The '<em><b>Ticketing System Not Available</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * ticketing facility unavailable - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #TICKETING_SYSTEM_NOT_AVAILABLE_VALUE
	 * @generated
	 * @ordered
	 */
	TICKETING_SYSTEM_NOT_AVAILABLE(43, "ticketingSystemNotAvailable", "ticketingSystemNotAvailable"),

	/**
	 * The '<em><b>Pti218 Alias10</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS10_VALUE
	 * @generated
	 * @ordered
	 */
	PTI218_ALIAS10(44, "pti218Alias10", "pti21_8_Alias_10"),

	/**
	 * The '<em><b>Leve Crossing Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * ticketing facility unavailable - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #LEVE_CROSSING_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	LEVE_CROSSING_FAILURE(45, "leveCrossingFailure", "leveCrossingFailure"),

	/**
	 * The '<em><b>Pti219</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI219_VALUE
	 * @generated
	 * @ordered
	 */
	PTI219(46, "pti219", "pti21_9"),

	/**
	 * The '<em><b>Repair Work</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_9 repair work.
	 * <!-- end-model-doc -->
	 * @see #REPAIR_WORK_VALUE
	 * @generated
	 * @ordered
	 */
	REPAIR_WORK(47, "repairWork", "repairWork"),

	/**
	 * The '<em><b>Pti2110</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2110_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2110(48, "pti2110", "pti21_10"),

	/**
	 * The '<em><b>Construction Work</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_10 construction work.
	 * <!-- end-model-doc -->
	 * @see #CONSTRUCTION_WORK_VALUE
	 * @generated
	 * @ordered
	 */
	CONSTRUCTION_WORK(49, "constructionWork", "constructionWork"),

	/**
	 * The '<em><b>Pti2111</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2111_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2111(50, "pti2111", "pti21_11"),

	/**
	 * The '<em><b>Maintenance Work</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_11 maintenance work.
	 * <!-- end-model-doc -->
	 * @see #MAINTENANCE_WORK_VALUE
	 * @generated
	 * @ordered
	 */
	MAINTENANCE_WORK(51, "maintenanceWork", "maintenanceWork"),

	/**
	 * The '<em><b>Pti2111 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2111_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2111_ALIAS1(52, "pti2111Alias1", "pti21_11_Alias_1"),

	/**
	 * The '<em><b>Emergency Engineering Work</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * emergency engineering work - alias to TPEG Pti21_11 maintenance work.
	 * <!-- end-model-doc -->
	 * @see #EMERGENCY_ENGINEERING_WORK_VALUE
	 * @generated
	 * @ordered
	 */
	EMERGENCY_ENGINEERING_WORK(53, "emergencyEngineeringWork", "emergencyEngineeringWork"),

	/**
	 * The '<em><b>Pti2111 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2111_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2111_ALIAS2(54, "pti2111Alias2", "pti21_11_Alias_2"),

	/**
	 * The '<em><b>Late Finish To Engineering Work</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * late finish to engineering work - alias to TPEG Pti21_11 maintenance work.
	 * <!-- end-model-doc -->
	 * @see #LATE_FINISH_TO_ENGINEERING_WORK_VALUE
	 * @generated
	 * @ordered
	 */
	LATE_FINISH_TO_ENGINEERING_WORK(55, "lateFinishToEngineeringWork", "lateFinishToEngineeringWork"),

	/**
	 * The '<em><b>Pti2112</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2112_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2112(56, "pti2112", "pti21_12"),

	/**
	 * The '<em><b>Power Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_12 power problem.
	 * <!-- end-model-doc -->
	 * @see #POWER_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	POWER_PROBLEM(57, "powerProblem", "powerProblem"),

	/**
	 * The '<em><b>Pti2112 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2112_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2112_ALIAS1(58, "pti2112Alias1", "pti21_12_Alias_1"),

	/**
	 * The '<em><b>Ovehead Wire Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_12 power problem.
	 * <!-- end-model-doc -->
	 * @see #OVEHEAD_WIRE_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	OVEHEAD_WIRE_FAILURE(59, "oveheadWireFailure", "oveheadWireFailure"),

	/**
	 * The '<em><b>Pti2113</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2113_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2113(60, "pti2113", "pti21_13"),

	/**
	 * The '<em><b>Fuel Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_13 fuel problem.
	 * <!-- end-model-doc -->
	 * @see #FUEL_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	FUEL_PROBLEM(61, "fuelProblem", "fuelProblem"),

	/**
	 * The '<em><b>Pti2114</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2114_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2114(62, "pti2114", "pti21_14"),

	/**
	 * The '<em><b>Swing Bridge Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_14 swing bridge failure.
	 * <!-- end-model-doc -->
	 * @see #SWING_BRIDGE_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	SWING_BRIDGE_FAILURE(63, "swingBridgeFailure", "swingBridgeFailure"),

	/**
	 * The '<em><b>Pti2115</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2115_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2115(64, "pti2115", "pti21_15"),

	/**
	 * The '<em><b>Escalator Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_15 escalator failure.
	 * <!-- end-model-doc -->
	 * @see #ESCALATOR_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	ESCALATOR_FAILURE(65, "escalatorFailure", "escalatorFailure"),

	/**
	 * The '<em><b>Pti2116</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2116_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2116(66, "pti2116", "pti21_16"),

	/**
	 * The '<em><b>Lift Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_16 lift failure.
	 * <!-- end-model-doc -->
	 * @see #LIFT_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	LIFT_FAILURE(67, "liftFailure", "liftFailure"),

	/**
	 * The '<em><b>Pti2117</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2117_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2117(68, "pti2117", "pti21_17"),

	/**
	 * The '<em><b>Gangway Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_17 gangway problem.
	 * <!-- end-model-doc -->
	 * @see #GANGWAY_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	GANGWAY_PROBLEM(69, "gangwayProblem", "gangwayProblem"),

	/**
	 * The '<em><b>Pti2118</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2118_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2118(70, "pti2118", "pti21_18"),

	/**
	 * The '<em><b>Closed For Maintenance</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_18 closed for maintenance.
	 * <!-- end-model-doc -->
	 * @see #CLOSED_FOR_MAINTENANCE_VALUE
	 * @generated
	 * @ordered
	 */
	CLOSED_FOR_MAINTENANCE(71, "closedForMaintenance", "closedForMaintenance"),

	/**
	 * The '<em><b>Pti2119</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2119_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2119(72, "pti2119", "pti21_19"),

	/**
	 * The '<em><b>Fuel Shortage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_19 fuel shortage.
	 * <!-- end-model-doc -->
	 * @see #FUEL_SHORTAGE_VALUE
	 * @generated
	 * @ordered
	 */
	FUEL_SHORTAGE(73, "fuelShortage", "fuelShortage"),

	/**
	 * The '<em><b>Pti2120</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2120_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2120(74, "pti2120", "pti21_20"),

	/**
	 * The '<em><b>Deicing Work</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_20 de-icing work.
	 * <!-- end-model-doc -->
	 * @see #DEICING_WORK_VALUE
	 * @generated
	 * @ordered
	 */
	DEICING_WORK(75, "deicingWork", "deicingWork"),

	/**
	 * The '<em><b>Pti2121</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2121_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2121(76, "pti2121", "pti21_21"),

	/**
	 * The '<em><b>Wheel Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_21 wheel problem.
	 * <!-- end-model-doc -->
	 * @see #WHEEL_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	WHEEL_PROBLEM(77, "wheelProblem", "wheelProblem"),

	/**
	 * The '<em><b>Pti2121 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2121_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2121_ALIAS1(78, "pti2121Alias1", "pti21_21_Alias_1"),

	/**
	 * The '<em><b>Slippery Track</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_21 wheel problem.
	 * <!-- end-model-doc -->
	 * @see #SLIPPERY_TRACK_VALUE
	 * @generated
	 * @ordered
	 */
	SLIPPERY_TRACK(79, "slipperyTrack", "slipperyTrack"),

	/**
	 * The '<em><b>Pti2122</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2122_VALUE
	 * @generated
	 * @ordered
	 */
	PTI2122(80, "pti2122", "pti21_22"),

	/**
	 * The '<em><b>Luggage Carousel Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_22 luggage carousel problem.
	 * <!-- end-model-doc -->
	 * @see #LUGGAGE_CAROUSEL_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	LUGGAGE_CAROUSEL_PROBLEM(81, "luggageCarouselProblem", "luggageCarouselProblem"),

	/**
	 * The '<em><b>Pti21255</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI21255_VALUE
	 * @generated
	 * @ordered
	 */
	PTI21255(82, "pti21255", "pti21_255"),

	/**
	 * The '<em><b>Undefined Equipment Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_255 undefined equipment problem.
	 * <!-- end-model-doc -->
	 * @see #UNDEFINED_EQUIPMENT_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	UNDEFINED_EQUIPMENT_PROBLEM(83, "undefinedEquipmentProblem", "undefinedEquipmentProblem");

	/**
	 * The '<em><b>Pti210</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI210
	 * @model name="pti210" literal="pti21_0"
	 * @generated
	 * @ordered
	 */
	public static final int PTI210_VALUE = 0;

	/**
	 * The '<em><b>Unknown</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_0 unknown.
	 * <!-- end-model-doc -->
	 * @see #UNKNOWN
	 * @model name="unknown"
	 * @generated
	 * @ordered
	 */
	public static final int UNKNOWN_VALUE = 1;

	/**
	 * The '<em><b>Pti211</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI211
	 * @model name="pti211" literal="pti21_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI211_VALUE = 2;

	/**
	 * The '<em><b>Points Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_1 points problem.
	 * <!-- end-model-doc -->
	 * @see #POINTS_PROBLEM
	 * @model name="pointsProblem"
	 * @generated
	 * @ordered
	 */
	public static final int POINTS_PROBLEM_VALUE = 3;

	/**
	 * The '<em><b>Pti212</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI212
	 * @model name="pti212" literal="pti21_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI212_VALUE = 4;

	/**
	 * The '<em><b>Points Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_2 points failure.
	 * <!-- end-model-doc -->
	 * @see #POINTS_FAILURE
	 * @model name="pointsFailure"
	 * @generated
	 * @ordered
	 */
	public static final int POINTS_FAILURE_VALUE = 5;

	/**
	 * The '<em><b>Pti213</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI213
	 * @model name="pti213" literal="pti21_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI213_VALUE = 6;

	/**
	 * The '<em><b>Signal Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_3 signal problem.
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_PROBLEM
	 * @model name="signalProblem"
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL_PROBLEM_VALUE = 7;

	/**
	 * The '<em><b>Pti213 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI213_ALIAS1
	 * @model name="pti213Alias1" literal="pti21_3_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI213_ALIAS1_VALUE = 8;

	/**
	 * The '<em><b>Train Warning System Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Train warning system eg TPWSAlias to TPEG Pti21_3 signal problem.
	 * <!-- end-model-doc -->
	 * @see #TRAIN_WARNING_SYSTEM_PROBLEM
	 * @model name="trainWarningSystemProblem"
	 * @generated
	 * @ordered
	 */
	public static final int TRAIN_WARNING_SYSTEM_PROBLEM_VALUE = 9;

	/**
	 * The '<em><b>Pti213 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI213_ALIAS2
	 * @model name="pti213Alias2" literal="pti21_3_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI213_ALIAS2_VALUE = 10;

	/**
	 * The '<em><b>Track Circuit Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Track circuit alias to TPEG Pti21_3 signal problem.
	 * <!-- end-model-doc -->
	 * @see #TRACK_CIRCUIT_PROBLEM
	 * @model name="trackCircuitProblem"
	 * @generated
	 * @ordered
	 */
	public static final int TRACK_CIRCUIT_PROBLEM_VALUE = 11;

	/**
	 * The '<em><b>Pti214</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI214
	 * @model name="pti214" literal="pti21_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI214_VALUE = 12;

	/**
	 * The '<em><b>Signal Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_4 signal failure.
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_FAILURE
	 * @model name="signalFailure"
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL_FAILURE_VALUE = 13;

	/**
	 * The '<em><b>Pti214 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI214_ALIAS1
	 * @model name="pti214Alias1" literal="pti21_4_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI214_ALIAS1_VALUE = 14;

	/**
	 * The '<em><b>Signal And Switch Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_4 signal failure.
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_AND_SWITCH_FAILURE
	 * @model name="signalAndSwitchFailure"
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL_AND_SWITCH_FAILURE_VALUE = 15;

	/**
	 * The '<em><b>Pti215</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI215
	 * @model name="pti215" literal="pti21_5"
	 * @generated
	 * @ordered
	 */
	public static final int PTI215_VALUE = 16;

	/**
	 * The '<em><b>Derailment</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_5 derailment.
	 * <!-- end-model-doc -->
	 * @see #DERAILMENT
	 * @model name="derailment"
	 * @generated
	 * @ordered
	 */
	public static final int DERAILMENT_VALUE = 17;

	/**
	 * The '<em><b>Pti216</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI216
	 * @model name="pti216" literal="pti21_6"
	 * @generated
	 * @ordered
	 */
	public static final int PTI216_VALUE = 18;

	/**
	 * The '<em><b>Engine Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_6 engine failure.
	 * <!-- end-model-doc -->
	 * @see #ENGINE_FAILURE
	 * @model name="engineFailure"
	 * @generated
	 * @ordered
	 */
	public static final int ENGINE_FAILURE_VALUE = 19;

	/**
	 * The '<em><b>Pti216 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI216_ALIAS1
	 * @model name="pti216Alias1" literal="pti21_6_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI216_ALIAS1_VALUE = 20;

	/**
	 * The '<em><b>Traction Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * traction failure alais to TPEG Pti21_6 engine failure.
	 * <!-- end-model-doc -->
	 * @see #TRACTION_FAILURE
	 * @model name="tractionFailure"
	 * @generated
	 * @ordered
	 */
	public static final int TRACTION_FAILURE_VALUE = 21;

	/**
	 * The '<em><b>Pti217</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI217
	 * @model name="pti217" literal="pti21_7"
	 * @generated
	 * @ordered
	 */
	public static final int PTI217_VALUE = 22;

	/**
	 * The '<em><b>Break Down</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_7 break down.
	 * <!-- end-model-doc -->
	 * @see #BREAK_DOWN
	 * @model name="breakDown"
	 * @generated
	 * @ordered
	 */
	public static final int BREAK_DOWN_VALUE = 23;

	/**
	 * The '<em><b>Pti218</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218
	 * @model name="pti218" literal="pti21_8"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_VALUE = 24;

	/**
	 * The '<em><b>Technical Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #TECHNICAL_PROBLEM
	 * @model name="technicalProblem"
	 * @generated
	 * @ordered
	 */
	public static final int TECHNICAL_PROBLEM_VALUE = 25;

	/**
	 * The '<em><b>Pti218 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS1
	 * @model name="pti218Alias1" literal="pti21_8_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS1_VALUE = 26;

	/**
	 * The '<em><b>Broken Rail</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Broken rail - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #BROKEN_RAIL
	 * @model name="brokenRail"
	 * @generated
	 * @ordered
	 */
	public static final int BROKEN_RAIL_VALUE = 27;

	/**
	 * The '<em><b>Pti218 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS2
	 * @model name="pti218Alias2" literal="pti21_8_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS2_VALUE = 28;

	/**
	 * The '<em><b>Poor Rail Conditions</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * poor rail conditions - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #POOR_RAIL_CONDITIONS
	 * @model name="poorRailConditions"
	 * @generated
	 * @ordered
	 */
	public static final int POOR_RAIL_CONDITIONS_VALUE = 29;

	/**
	 * The '<em><b>Pti218 Alias3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS3
	 * @model name="pti218Alias3" literal="pti21_8_Alias_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS3_VALUE = 30;

	/**
	 * The '<em><b>Wheel Impact Load</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Wheel Impact Load detectedi by trackside equipment alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #WHEEL_IMPACT_LOAD
	 * @model name="wheelImpactLoad"
	 * @generated
	 * @ordered
	 */
	public static final int WHEEL_IMPACT_LOAD_VALUE = 31;

	/**
	 * The '<em><b>Pti218 Alias4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS4
	 * @model name="pti218Alias4" literal="pti21_8_Alias_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS4_VALUE = 32;

	/**
	 * The '<em><b>Lack Of Operational Stock</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * late lack of operational stock - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #LACK_OF_OPERATIONAL_STOCK
	 * @model name="lackOfOperationalStock"
	 * @generated
	 * @ordered
	 */
	public static final int LACK_OF_OPERATIONAL_STOCK_VALUE = 33;

	/**
	 * The '<em><b>Pti218 Alias5</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS5
	 * @model name="pti218Alias5" literal="pti21_8_Alias_5"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS5_VALUE = 34;

	/**
	 * The '<em><b>Defective Fire Alarm Equipment</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * defective fire alarm equipment - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #DEFECTIVE_FIRE_ALARM_EQUIPMENT
	 * @model name="defectiveFireAlarmEquipment"
	 * @generated
	 * @ordered
	 */
	public static final int DEFECTIVE_FIRE_ALARM_EQUIPMENT_VALUE = 35;

	/**
	 * The '<em><b>Pti218 Alias6</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS6
	 * @model name="pti218Alias6" literal="pti21_8_Alias_6"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS6_VALUE = 36;

	/**
	 * The '<em><b>Defective Platform Edge Doors</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * defective PEDs (platform edge doors) - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #DEFECTIVE_PLATFORM_EDGE_DOORS
	 * @model name="defectivePlatformEdgeDoors"
	 * @generated
	 * @ordered
	 */
	public static final int DEFECTIVE_PLATFORM_EDGE_DOORS_VALUE = 37;

	/**
	 * The '<em><b>Pti218 Alias7</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS7
	 * @model name="pti218Alias7" literal="pti21_8_Alias_7"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS7_VALUE = 38;

	/**
	 * The '<em><b>Defective Cctv</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * defective CCTV - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #DEFECTIVE_CCTV
	 * @model name="defectiveCctv"
	 * @generated
	 * @ordered
	 */
	public static final int DEFECTIVE_CCTV_VALUE = 39;

	/**
	 * The '<em><b>Pti218 Alias8</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS8
	 * @model name="pti218Alias8" literal="pti21_8_Alias_8"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS8_VALUE = 40;

	/**
	 * The '<em><b>Defective Public Announcement System</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * defective PA - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM
	 * @model name="defectivePublicAnnouncementSystem"
	 * @generated
	 * @ordered
	 */
	public static final int DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM_VALUE = 41;

	/**
	 * The '<em><b>Pti218 Alias9</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS9
	 * @model name="pti218Alias9" literal="pti21_8_Alias_9"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS9_VALUE = 42;

	/**
	 * The '<em><b>Ticketing System Not Available</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * ticketing facility unavailable - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #TICKETING_SYSTEM_NOT_AVAILABLE
	 * @model name="ticketingSystemNotAvailable"
	 * @generated
	 * @ordered
	 */
	public static final int TICKETING_SYSTEM_NOT_AVAILABLE_VALUE = 43;

	/**
	 * The '<em><b>Pti218 Alias10</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI218_ALIAS10
	 * @model name="pti218Alias10" literal="pti21_8_Alias_10"
	 * @generated
	 * @ordered
	 */
	public static final int PTI218_ALIAS10_VALUE = 44;

	/**
	 * The '<em><b>Leve Crossing Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * ticketing facility unavailable - alias to TPEG Pti21_8 technical problem.
	 * <!-- end-model-doc -->
	 * @see #LEVE_CROSSING_FAILURE
	 * @model name="leveCrossingFailure"
	 * @generated
	 * @ordered
	 */
	public static final int LEVE_CROSSING_FAILURE_VALUE = 45;

	/**
	 * The '<em><b>Pti219</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI219
	 * @model name="pti219" literal="pti21_9"
	 * @generated
	 * @ordered
	 */
	public static final int PTI219_VALUE = 46;

	/**
	 * The '<em><b>Repair Work</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_9 repair work.
	 * <!-- end-model-doc -->
	 * @see #REPAIR_WORK
	 * @model name="repairWork"
	 * @generated
	 * @ordered
	 */
	public static final int REPAIR_WORK_VALUE = 47;

	/**
	 * The '<em><b>Pti2110</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2110
	 * @model name="pti2110" literal="pti21_10"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2110_VALUE = 48;

	/**
	 * The '<em><b>Construction Work</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_10 construction work.
	 * <!-- end-model-doc -->
	 * @see #CONSTRUCTION_WORK
	 * @model name="constructionWork"
	 * @generated
	 * @ordered
	 */
	public static final int CONSTRUCTION_WORK_VALUE = 49;

	/**
	 * The '<em><b>Pti2111</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2111
	 * @model name="pti2111" literal="pti21_11"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2111_VALUE = 50;

	/**
	 * The '<em><b>Maintenance Work</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_11 maintenance work.
	 * <!-- end-model-doc -->
	 * @see #MAINTENANCE_WORK
	 * @model name="maintenanceWork"
	 * @generated
	 * @ordered
	 */
	public static final int MAINTENANCE_WORK_VALUE = 51;

	/**
	 * The '<em><b>Pti2111 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2111_ALIAS1
	 * @model name="pti2111Alias1" literal="pti21_11_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2111_ALIAS1_VALUE = 52;

	/**
	 * The '<em><b>Emergency Engineering Work</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * emergency engineering work - alias to TPEG Pti21_11 maintenance work.
	 * <!-- end-model-doc -->
	 * @see #EMERGENCY_ENGINEERING_WORK
	 * @model name="emergencyEngineeringWork"
	 * @generated
	 * @ordered
	 */
	public static final int EMERGENCY_ENGINEERING_WORK_VALUE = 53;

	/**
	 * The '<em><b>Pti2111 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2111_ALIAS2
	 * @model name="pti2111Alias2" literal="pti21_11_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2111_ALIAS2_VALUE = 54;

	/**
	 * The '<em><b>Late Finish To Engineering Work</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * late finish to engineering work - alias to TPEG Pti21_11 maintenance work.
	 * <!-- end-model-doc -->
	 * @see #LATE_FINISH_TO_ENGINEERING_WORK
	 * @model name="lateFinishToEngineeringWork"
	 * @generated
	 * @ordered
	 */
	public static final int LATE_FINISH_TO_ENGINEERING_WORK_VALUE = 55;

	/**
	 * The '<em><b>Pti2112</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2112
	 * @model name="pti2112" literal="pti21_12"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2112_VALUE = 56;

	/**
	 * The '<em><b>Power Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_12 power problem.
	 * <!-- end-model-doc -->
	 * @see #POWER_PROBLEM
	 * @model name="powerProblem"
	 * @generated
	 * @ordered
	 */
	public static final int POWER_PROBLEM_VALUE = 57;

	/**
	 * The '<em><b>Pti2112 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2112_ALIAS1
	 * @model name="pti2112Alias1" literal="pti21_12_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2112_ALIAS1_VALUE = 58;

	/**
	 * The '<em><b>Ovehead Wire Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_12 power problem.
	 * <!-- end-model-doc -->
	 * @see #OVEHEAD_WIRE_FAILURE
	 * @model name="oveheadWireFailure"
	 * @generated
	 * @ordered
	 */
	public static final int OVEHEAD_WIRE_FAILURE_VALUE = 59;

	/**
	 * The '<em><b>Pti2113</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2113
	 * @model name="pti2113" literal="pti21_13"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2113_VALUE = 60;

	/**
	 * The '<em><b>Fuel Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_13 fuel problem.
	 * <!-- end-model-doc -->
	 * @see #FUEL_PROBLEM
	 * @model name="fuelProblem"
	 * @generated
	 * @ordered
	 */
	public static final int FUEL_PROBLEM_VALUE = 61;

	/**
	 * The '<em><b>Pti2114</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2114
	 * @model name="pti2114" literal="pti21_14"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2114_VALUE = 62;

	/**
	 * The '<em><b>Swing Bridge Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_14 swing bridge failure.
	 * <!-- end-model-doc -->
	 * @see #SWING_BRIDGE_FAILURE
	 * @model name="swingBridgeFailure"
	 * @generated
	 * @ordered
	 */
	public static final int SWING_BRIDGE_FAILURE_VALUE = 63;

	/**
	 * The '<em><b>Pti2115</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2115
	 * @model name="pti2115" literal="pti21_15"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2115_VALUE = 64;

	/**
	 * The '<em><b>Escalator Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_15 escalator failure.
	 * <!-- end-model-doc -->
	 * @see #ESCALATOR_FAILURE
	 * @model name="escalatorFailure"
	 * @generated
	 * @ordered
	 */
	public static final int ESCALATOR_FAILURE_VALUE = 65;

	/**
	 * The '<em><b>Pti2116</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2116
	 * @model name="pti2116" literal="pti21_16"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2116_VALUE = 66;

	/**
	 * The '<em><b>Lift Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_16 lift failure.
	 * <!-- end-model-doc -->
	 * @see #LIFT_FAILURE
	 * @model name="liftFailure"
	 * @generated
	 * @ordered
	 */
	public static final int LIFT_FAILURE_VALUE = 67;

	/**
	 * The '<em><b>Pti2117</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2117
	 * @model name="pti2117" literal="pti21_17"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2117_VALUE = 68;

	/**
	 * The '<em><b>Gangway Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_17 gangway problem.
	 * <!-- end-model-doc -->
	 * @see #GANGWAY_PROBLEM
	 * @model name="gangwayProblem"
	 * @generated
	 * @ordered
	 */
	public static final int GANGWAY_PROBLEM_VALUE = 69;

	/**
	 * The '<em><b>Pti2118</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2118
	 * @model name="pti2118" literal="pti21_18"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2118_VALUE = 70;

	/**
	 * The '<em><b>Closed For Maintenance</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_18 closed for maintenance.
	 * <!-- end-model-doc -->
	 * @see #CLOSED_FOR_MAINTENANCE
	 * @model name="closedForMaintenance"
	 * @generated
	 * @ordered
	 */
	public static final int CLOSED_FOR_MAINTENANCE_VALUE = 71;

	/**
	 * The '<em><b>Pti2119</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2119
	 * @model name="pti2119" literal="pti21_19"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2119_VALUE = 72;

	/**
	 * The '<em><b>Fuel Shortage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_19 fuel shortage.
	 * <!-- end-model-doc -->
	 * @see #FUEL_SHORTAGE
	 * @model name="fuelShortage"
	 * @generated
	 * @ordered
	 */
	public static final int FUEL_SHORTAGE_VALUE = 73;

	/**
	 * The '<em><b>Pti2120</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2120
	 * @model name="pti2120" literal="pti21_20"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2120_VALUE = 74;

	/**
	 * The '<em><b>Deicing Work</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_20 de-icing work.
	 * <!-- end-model-doc -->
	 * @see #DEICING_WORK
	 * @model name="deicingWork"
	 * @generated
	 * @ordered
	 */
	public static final int DEICING_WORK_VALUE = 75;

	/**
	 * The '<em><b>Pti2121</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2121
	 * @model name="pti2121" literal="pti21_21"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2121_VALUE = 76;

	/**
	 * The '<em><b>Wheel Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_21 wheel problem.
	 * <!-- end-model-doc -->
	 * @see #WHEEL_PROBLEM
	 * @model name="wheelProblem"
	 * @generated
	 * @ordered
	 */
	public static final int WHEEL_PROBLEM_VALUE = 77;

	/**
	 * The '<em><b>Pti2121 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2121_ALIAS1
	 * @model name="pti2121Alias1" literal="pti21_21_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2121_ALIAS1_VALUE = 78;

	/**
	 * The '<em><b>Slippery Track</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_21 wheel problem.
	 * <!-- end-model-doc -->
	 * @see #SLIPPERY_TRACK
	 * @model name="slipperyTrack"
	 * @generated
	 * @ordered
	 */
	public static final int SLIPPERY_TRACK_VALUE = 79;

	/**
	 * The '<em><b>Pti2122</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI2122
	 * @model name="pti2122" literal="pti21_22"
	 * @generated
	 * @ordered
	 */
	public static final int PTI2122_VALUE = 80;

	/**
	 * The '<em><b>Luggage Carousel Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_22 luggage carousel problem.
	 * <!-- end-model-doc -->
	 * @see #LUGGAGE_CAROUSEL_PROBLEM
	 * @model name="luggageCarouselProblem"
	 * @generated
	 * @ordered
	 */
	public static final int LUGGAGE_CAROUSEL_PROBLEM_VALUE = 81;

	/**
	 * The '<em><b>Pti21255</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI21255
	 * @model name="pti21255" literal="pti21_255"
	 * @generated
	 * @ordered
	 */
	public static final int PTI21255_VALUE = 82;

	/**
	 * The '<em><b>Undefined Equipment Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti21_255 undefined equipment problem.
	 * <!-- end-model-doc -->
	 * @see #UNDEFINED_EQUIPMENT_PROBLEM
	 * @model name="undefinedEquipmentProblem"
	 * @generated
	 * @ordered
	 */
	public static final int UNDEFINED_EQUIPMENT_PROBLEM_VALUE = 83;

	/**
	 * An array of all the '<em><b>Equipment Reason Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final EquipmentReasonEnumeration[] VALUES_ARRAY =
		new EquipmentReasonEnumeration[] {
			PTI210,
			UNKNOWN,
			PTI211,
			POINTS_PROBLEM,
			PTI212,
			POINTS_FAILURE,
			PTI213,
			SIGNAL_PROBLEM,
			PTI213_ALIAS1,
			TRAIN_WARNING_SYSTEM_PROBLEM,
			PTI213_ALIAS2,
			TRACK_CIRCUIT_PROBLEM,
			PTI214,
			SIGNAL_FAILURE,
			PTI214_ALIAS1,
			SIGNAL_AND_SWITCH_FAILURE,
			PTI215,
			DERAILMENT,
			PTI216,
			ENGINE_FAILURE,
			PTI216_ALIAS1,
			TRACTION_FAILURE,
			PTI217,
			BREAK_DOWN,
			PTI218,
			TECHNICAL_PROBLEM,
			PTI218_ALIAS1,
			BROKEN_RAIL,
			PTI218_ALIAS2,
			POOR_RAIL_CONDITIONS,
			PTI218_ALIAS3,
			WHEEL_IMPACT_LOAD,
			PTI218_ALIAS4,
			LACK_OF_OPERATIONAL_STOCK,
			PTI218_ALIAS5,
			DEFECTIVE_FIRE_ALARM_EQUIPMENT,
			PTI218_ALIAS6,
			DEFECTIVE_PLATFORM_EDGE_DOORS,
			PTI218_ALIAS7,
			DEFECTIVE_CCTV,
			PTI218_ALIAS8,
			DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM,
			PTI218_ALIAS9,
			TICKETING_SYSTEM_NOT_AVAILABLE,
			PTI218_ALIAS10,
			LEVE_CROSSING_FAILURE,
			PTI219,
			REPAIR_WORK,
			PTI2110,
			CONSTRUCTION_WORK,
			PTI2111,
			MAINTENANCE_WORK,
			PTI2111_ALIAS1,
			EMERGENCY_ENGINEERING_WORK,
			PTI2111_ALIAS2,
			LATE_FINISH_TO_ENGINEERING_WORK,
			PTI2112,
			POWER_PROBLEM,
			PTI2112_ALIAS1,
			OVEHEAD_WIRE_FAILURE,
			PTI2113,
			FUEL_PROBLEM,
			PTI2114,
			SWING_BRIDGE_FAILURE,
			PTI2115,
			ESCALATOR_FAILURE,
			PTI2116,
			LIFT_FAILURE,
			PTI2117,
			GANGWAY_PROBLEM,
			PTI2118,
			CLOSED_FOR_MAINTENANCE,
			PTI2119,
			FUEL_SHORTAGE,
			PTI2120,
			DEICING_WORK,
			PTI2121,
			WHEEL_PROBLEM,
			PTI2121_ALIAS1,
			SLIPPERY_TRACK,
			PTI2122,
			LUGGAGE_CAROUSEL_PROBLEM,
			PTI21255,
			UNDEFINED_EQUIPMENT_PROBLEM,
		};

	/**
	 * A public read-only list of all the '<em><b>Equipment Reason Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<EquipmentReasonEnumeration> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Equipment Reason Enumeration</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static EquipmentReasonEnumeration get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			EquipmentReasonEnumeration result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Equipment Reason Enumeration</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static EquipmentReasonEnumeration getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			EquipmentReasonEnumeration result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Equipment Reason Enumeration</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static EquipmentReasonEnumeration get(int value) {
		switch (value) {
			case PTI210_VALUE: return PTI210;
			case UNKNOWN_VALUE: return UNKNOWN;
			case PTI211_VALUE: return PTI211;
			case POINTS_PROBLEM_VALUE: return POINTS_PROBLEM;
			case PTI212_VALUE: return PTI212;
			case POINTS_FAILURE_VALUE: return POINTS_FAILURE;
			case PTI213_VALUE: return PTI213;
			case SIGNAL_PROBLEM_VALUE: return SIGNAL_PROBLEM;
			case PTI213_ALIAS1_VALUE: return PTI213_ALIAS1;
			case TRAIN_WARNING_SYSTEM_PROBLEM_VALUE: return TRAIN_WARNING_SYSTEM_PROBLEM;
			case PTI213_ALIAS2_VALUE: return PTI213_ALIAS2;
			case TRACK_CIRCUIT_PROBLEM_VALUE: return TRACK_CIRCUIT_PROBLEM;
			case PTI214_VALUE: return PTI214;
			case SIGNAL_FAILURE_VALUE: return SIGNAL_FAILURE;
			case PTI214_ALIAS1_VALUE: return PTI214_ALIAS1;
			case SIGNAL_AND_SWITCH_FAILURE_VALUE: return SIGNAL_AND_SWITCH_FAILURE;
			case PTI215_VALUE: return PTI215;
			case DERAILMENT_VALUE: return DERAILMENT;
			case PTI216_VALUE: return PTI216;
			case ENGINE_FAILURE_VALUE: return ENGINE_FAILURE;
			case PTI216_ALIAS1_VALUE: return PTI216_ALIAS1;
			case TRACTION_FAILURE_VALUE: return TRACTION_FAILURE;
			case PTI217_VALUE: return PTI217;
			case BREAK_DOWN_VALUE: return BREAK_DOWN;
			case PTI218_VALUE: return PTI218;
			case TECHNICAL_PROBLEM_VALUE: return TECHNICAL_PROBLEM;
			case PTI218_ALIAS1_VALUE: return PTI218_ALIAS1;
			case BROKEN_RAIL_VALUE: return BROKEN_RAIL;
			case PTI218_ALIAS2_VALUE: return PTI218_ALIAS2;
			case POOR_RAIL_CONDITIONS_VALUE: return POOR_RAIL_CONDITIONS;
			case PTI218_ALIAS3_VALUE: return PTI218_ALIAS3;
			case WHEEL_IMPACT_LOAD_VALUE: return WHEEL_IMPACT_LOAD;
			case PTI218_ALIAS4_VALUE: return PTI218_ALIAS4;
			case LACK_OF_OPERATIONAL_STOCK_VALUE: return LACK_OF_OPERATIONAL_STOCK;
			case PTI218_ALIAS5_VALUE: return PTI218_ALIAS5;
			case DEFECTIVE_FIRE_ALARM_EQUIPMENT_VALUE: return DEFECTIVE_FIRE_ALARM_EQUIPMENT;
			case PTI218_ALIAS6_VALUE: return PTI218_ALIAS6;
			case DEFECTIVE_PLATFORM_EDGE_DOORS_VALUE: return DEFECTIVE_PLATFORM_EDGE_DOORS;
			case PTI218_ALIAS7_VALUE: return PTI218_ALIAS7;
			case DEFECTIVE_CCTV_VALUE: return DEFECTIVE_CCTV;
			case PTI218_ALIAS8_VALUE: return PTI218_ALIAS8;
			case DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM_VALUE: return DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM;
			case PTI218_ALIAS9_VALUE: return PTI218_ALIAS9;
			case TICKETING_SYSTEM_NOT_AVAILABLE_VALUE: return TICKETING_SYSTEM_NOT_AVAILABLE;
			case PTI218_ALIAS10_VALUE: return PTI218_ALIAS10;
			case LEVE_CROSSING_FAILURE_VALUE: return LEVE_CROSSING_FAILURE;
			case PTI219_VALUE: return PTI219;
			case REPAIR_WORK_VALUE: return REPAIR_WORK;
			case PTI2110_VALUE: return PTI2110;
			case CONSTRUCTION_WORK_VALUE: return CONSTRUCTION_WORK;
			case PTI2111_VALUE: return PTI2111;
			case MAINTENANCE_WORK_VALUE: return MAINTENANCE_WORK;
			case PTI2111_ALIAS1_VALUE: return PTI2111_ALIAS1;
			case EMERGENCY_ENGINEERING_WORK_VALUE: return EMERGENCY_ENGINEERING_WORK;
			case PTI2111_ALIAS2_VALUE: return PTI2111_ALIAS2;
			case LATE_FINISH_TO_ENGINEERING_WORK_VALUE: return LATE_FINISH_TO_ENGINEERING_WORK;
			case PTI2112_VALUE: return PTI2112;
			case POWER_PROBLEM_VALUE: return POWER_PROBLEM;
			case PTI2112_ALIAS1_VALUE: return PTI2112_ALIAS1;
			case OVEHEAD_WIRE_FAILURE_VALUE: return OVEHEAD_WIRE_FAILURE;
			case PTI2113_VALUE: return PTI2113;
			case FUEL_PROBLEM_VALUE: return FUEL_PROBLEM;
			case PTI2114_VALUE: return PTI2114;
			case SWING_BRIDGE_FAILURE_VALUE: return SWING_BRIDGE_FAILURE;
			case PTI2115_VALUE: return PTI2115;
			case ESCALATOR_FAILURE_VALUE: return ESCALATOR_FAILURE;
			case PTI2116_VALUE: return PTI2116;
			case LIFT_FAILURE_VALUE: return LIFT_FAILURE;
			case PTI2117_VALUE: return PTI2117;
			case GANGWAY_PROBLEM_VALUE: return GANGWAY_PROBLEM;
			case PTI2118_VALUE: return PTI2118;
			case CLOSED_FOR_MAINTENANCE_VALUE: return CLOSED_FOR_MAINTENANCE;
			case PTI2119_VALUE: return PTI2119;
			case FUEL_SHORTAGE_VALUE: return FUEL_SHORTAGE;
			case PTI2120_VALUE: return PTI2120;
			case DEICING_WORK_VALUE: return DEICING_WORK;
			case PTI2121_VALUE: return PTI2121;
			case WHEEL_PROBLEM_VALUE: return WHEEL_PROBLEM;
			case PTI2121_ALIAS1_VALUE: return PTI2121_ALIAS1;
			case SLIPPERY_TRACK_VALUE: return SLIPPERY_TRACK;
			case PTI2122_VALUE: return PTI2122;
			case LUGGAGE_CAROUSEL_PROBLEM_VALUE: return LUGGAGE_CAROUSEL_PROBLEM;
			case PTI21255_VALUE: return PTI21255;
			case UNDEFINED_EQUIPMENT_PROBLEM_VALUE: return UNDEFINED_EQUIPMENT_PROBLEM;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EquipmentReasonEnumeration(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //EquipmentReasonEnumeration
