/*
 */
package siri;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Iana Country Tld Enumeration</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Allowed values for classifying NPTG Localities.
 * <!-- end-model-doc -->
 * @see siri.SiriPackage#getIanaCountryTldEnumeration()
 * @model extendedMetaData="name='IanaCountryTldEnumeration'"
 * @generated
 */
@ProviderType
public enum IanaCountryTldEnumeration implements Enumerator {
	/**
	 * The '<em><b>Ac</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ascension Island.
	 * <!-- end-model-doc -->
	 * @see #AC_VALUE
	 * @generated
	 * @ordered
	 */
	AC(0, "ac", "ac"),

	/**
	 * The '<em><b>Ad</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Andorra.
	 * <!-- end-model-doc -->
	 * @see #AD_VALUE
	 * @generated
	 * @ordered
	 */
	AD(1, "ad", "ad"),

	/**
	 * The '<em><b>Ae</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United Arab Emirates.
	 * <!-- end-model-doc -->
	 * @see #AE_VALUE
	 * @generated
	 * @ordered
	 */
	AE(2, "ae", "ae"),

	/**
	 * The '<em><b>Af</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Afghanistan.
	 * <!-- end-model-doc -->
	 * @see #AF_VALUE
	 * @generated
	 * @ordered
	 */
	AF(3, "af", "af"),

	/**
	 * The '<em><b>Ag</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Antigua and Barbuda.
	 * <!-- end-model-doc -->
	 * @see #AG_VALUE
	 * @generated
	 * @ordered
	 */
	AG(4, "ag", "ag"),

	/**
	 * The '<em><b>Ai</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Anguilla.
	 * <!-- end-model-doc -->
	 * @see #AI_VALUE
	 * @generated
	 * @ordered
	 */
	AI(5, "ai", "ai"),

	/**
	 * The '<em><b>Al</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Albania.
	 * <!-- end-model-doc -->
	 * @see #AL_VALUE
	 * @generated
	 * @ordered
	 */
	AL(6, "al", "al"),

	/**
	 * The '<em><b>Am</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Armenia.
	 * <!-- end-model-doc -->
	 * @see #AM_VALUE
	 * @generated
	 * @ordered
	 */
	AM(7, "am", "am"),

	/**
	 * The '<em><b>An</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Netherlands Antilles.
	 * <!-- end-model-doc -->
	 * @see #AN_VALUE
	 * @generated
	 * @ordered
	 */
	AN(8, "an", "an"),

	/**
	 * The '<em><b>Ao</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Angola.
	 * <!-- end-model-doc -->
	 * @see #AO_VALUE
	 * @generated
	 * @ordered
	 */
	AO(9, "ao", "ao"),

	/**
	 * The '<em><b>Aq</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Antarctica.
	 * <!-- end-model-doc -->
	 * @see #AQ_VALUE
	 * @generated
	 * @ordered
	 */
	AQ(10, "aq", "aq"),

	/**
	 * The '<em><b>Ar</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Argentina.
	 * <!-- end-model-doc -->
	 * @see #AR_VALUE
	 * @generated
	 * @ordered
	 */
	AR(11, "ar", "ar"),

	/**
	 * The '<em><b>As</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * American Samoa.
	 * <!-- end-model-doc -->
	 * @see #AS_VALUE
	 * @generated
	 * @ordered
	 */
	AS(12, "as", "as"),

	/**
	 * The '<em><b>At</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Austria.
	 * <!-- end-model-doc -->
	 * @see #AT_VALUE
	 * @generated
	 * @ordered
	 */
	AT(13, "at", "at"),

	/**
	 * The '<em><b>Au</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Australia.
	 * <!-- end-model-doc -->
	 * @see #AU_VALUE
	 * @generated
	 * @ordered
	 */
	AU(14, "au", "au"),

	/**
	 * The '<em><b>Aw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Aruba.
	 * <!-- end-model-doc -->
	 * @see #AW_VALUE
	 * @generated
	 * @ordered
	 */
	AW(15, "aw", "aw"),

	/**
	 * The '<em><b>Az</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Azerbaijan.
	 * <!-- end-model-doc -->
	 * @see #AZ_VALUE
	 * @generated
	 * @ordered
	 */
	AZ(16, "az", "az"),

	/**
	 * The '<em><b>Ax</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Aland Islands.
	 * <!-- end-model-doc -->
	 * @see #AX_VALUE
	 * @generated
	 * @ordered
	 */
	AX(17, "ax", "ax"),

	/**
	 * The '<em><b>Ba</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bosnia and Herzegovina.
	 * <!-- end-model-doc -->
	 * @see #BA_VALUE
	 * @generated
	 * @ordered
	 */
	BA(18, "ba", "ba"),

	/**
	 * The '<em><b>Bb</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Barbados.
	 * <!-- end-model-doc -->
	 * @see #BB_VALUE
	 * @generated
	 * @ordered
	 */
	BB(19, "bb", "bb"),

	/**
	 * The '<em><b>Bd</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bangladesh.
	 * <!-- end-model-doc -->
	 * @see #BD_VALUE
	 * @generated
	 * @ordered
	 */
	BD(20, "bd", "bd"),

	/**
	 * The '<em><b>Be</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Belgium.
	 * <!-- end-model-doc -->
	 * @see #BE_VALUE
	 * @generated
	 * @ordered
	 */
	BE(21, "be", "be"),

	/**
	 * The '<em><b>Bf</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Burkina Faso.
	 * <!-- end-model-doc -->
	 * @see #BF_VALUE
	 * @generated
	 * @ordered
	 */
	BF(22, "bf", "bf"),

	/**
	 * The '<em><b>Bg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bulgaria.
	 * <!-- end-model-doc -->
	 * @see #BG_VALUE
	 * @generated
	 * @ordered
	 */
	BG(23, "bg", "bg"),

	/**
	 * The '<em><b>Bh</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bahrain.
	 * <!-- end-model-doc -->
	 * @see #BH_VALUE
	 * @generated
	 * @ordered
	 */
	BH(24, "bh", "bh"),

	/**
	 * The '<em><b>Bi</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Burundi.
	 * <!-- end-model-doc -->
	 * @see #BI_VALUE
	 * @generated
	 * @ordered
	 */
	BI(25, "bi", "bi"),

	/**
	 * The '<em><b>Bj</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Benin.
	 * <!-- end-model-doc -->
	 * @see #BJ_VALUE
	 * @generated
	 * @ordered
	 */
	BJ(26, "bj", "bj"),

	/**
	 * The '<em><b>Bm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bermuda.
	 * <!-- end-model-doc -->
	 * @see #BM_VALUE
	 * @generated
	 * @ordered
	 */
	BM(27, "bm", "bm"),

	/**
	 * The '<em><b>Bn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Brunei Darussalam.
	 * <!-- end-model-doc -->
	 * @see #BN_VALUE
	 * @generated
	 * @ordered
	 */
	BN(28, "bn", "bn"),

	/**
	 * The '<em><b>Bo</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bolivia.
	 * <!-- end-model-doc -->
	 * @see #BO_VALUE
	 * @generated
	 * @ordered
	 */
	BO(29, "bo", "bo"),

	/**
	 * The '<em><b>Br</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Brazil.
	 * <!-- end-model-doc -->
	 * @see #BR_VALUE
	 * @generated
	 * @ordered
	 */
	BR(30, "br", "br"),

	/**
	 * The '<em><b>Bs</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bahamas.
	 * <!-- end-model-doc -->
	 * @see #BS_VALUE
	 * @generated
	 * @ordered
	 */
	BS(31, "bs", "bs"),

	/**
	 * The '<em><b>Bt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bhutan.
	 * <!-- end-model-doc -->
	 * @see #BT_VALUE
	 * @generated
	 * @ordered
	 */
	BT(32, "bt", "bt"),

	/**
	 * The '<em><b>Bv</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bouvet Island.
	 * <!-- end-model-doc -->
	 * @see #BV_VALUE
	 * @generated
	 * @ordered
	 */
	BV(33, "bv", "bv"),

	/**
	 * The '<em><b>Bw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Botswana.
	 * <!-- end-model-doc -->
	 * @see #BW_VALUE
	 * @generated
	 * @ordered
	 */
	BW(34, "bw", "bw"),

	/**
	 * The '<em><b>By</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Belarus.
	 * <!-- end-model-doc -->
	 * @see #BY_VALUE
	 * @generated
	 * @ordered
	 */
	BY(35, "by", "by"),

	/**
	 * The '<em><b>Bz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Belize.
	 * <!-- end-model-doc -->
	 * @see #BZ_VALUE
	 * @generated
	 * @ordered
	 */
	BZ(36, "bz", "bz"),

	/**
	 * The '<em><b>Ca</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Canada.
	 * <!-- end-model-doc -->
	 * @see #CA_VALUE
	 * @generated
	 * @ordered
	 */
	CA(37, "ca", "ca"),

	/**
	 * The '<em><b>Cc</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cocos (Keeling) Islands.
	 * <!-- end-model-doc -->
	 * @see #CC_VALUE
	 * @generated
	 * @ordered
	 */
	CC(38, "cc", "cc"),

	/**
	 * The '<em><b>Cd</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Congo, The Democratic Republic of the.
	 * <!-- end-model-doc -->
	 * @see #CD_VALUE
	 * @generated
	 * @ordered
	 */
	CD(39, "cd", "cd"),

	/**
	 * The '<em><b>Cf</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Central African Republic.
	 * <!-- end-model-doc -->
	 * @see #CF_VALUE
	 * @generated
	 * @ordered
	 */
	CF(40, "cf", "cf"),

	/**
	 * The '<em><b>Cg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Congo, Republic of.
	 * <!-- end-model-doc -->
	 * @see #CG_VALUE
	 * @generated
	 * @ordered
	 */
	CG(41, "cg", "cg"),

	/**
	 * The '<em><b>Ch</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Switzerland.
	 * <!-- end-model-doc -->
	 * @see #CH_VALUE
	 * @generated
	 * @ordered
	 */
	CH(42, "ch", "ch"),

	/**
	 * The '<em><b>Ci</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cote d'Ivoire.
	 * <!-- end-model-doc -->
	 * @see #CI_VALUE
	 * @generated
	 * @ordered
	 */
	CI(43, "ci", "ci"),

	/**
	 * The '<em><b>Ck</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cook Islands.
	 * <!-- end-model-doc -->
	 * @see #CK_VALUE
	 * @generated
	 * @ordered
	 */
	CK(44, "ck", "ck"),

	/**
	 * The '<em><b>Cl</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Chile.
	 * <!-- end-model-doc -->
	 * @see #CL_VALUE
	 * @generated
	 * @ordered
	 */
	CL(45, "cl", "cl"),

	/**
	 * The '<em><b>Cm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cameroon.
	 * <!-- end-model-doc -->
	 * @see #CM_VALUE
	 * @generated
	 * @ordered
	 */
	CM(46, "cm", "cm"),

	/**
	 * The '<em><b>Cn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * China.
	 * <!-- end-model-doc -->
	 * @see #CN_VALUE
	 * @generated
	 * @ordered
	 */
	CN(47, "cn", "cn"),

	/**
	 * The '<em><b>Co</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Colombia.
	 * <!-- end-model-doc -->
	 * @see #CO_VALUE
	 * @generated
	 * @ordered
	 */
	CO(48, "co", "co"),

	/**
	 * The '<em><b>Cr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Costa Rica.
	 * <!-- end-model-doc -->
	 * @see #CR_VALUE
	 * @generated
	 * @ordered
	 */
	CR(49, "cr", "cr"),

	/**
	 * The '<em><b>Cs</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Serbia and Montenegro.
	 * <!-- end-model-doc -->
	 * @see #CS_VALUE
	 * @generated
	 * @ordered
	 */
	CS(50, "cs", "cs"),

	/**
	 * The '<em><b>Cu</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cuba.
	 * <!-- end-model-doc -->
	 * @see #CU_VALUE
	 * @generated
	 * @ordered
	 */
	CU(51, "cu", "cu"),

	/**
	 * The '<em><b>Cv</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cape Verde.
	 * <!-- end-model-doc -->
	 * @see #CV_VALUE
	 * @generated
	 * @ordered
	 */
	CV(52, "cv", "cv"),

	/**
	 * The '<em><b>Cx</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Christmas Island.
	 * <!-- end-model-doc -->
	 * @see #CX_VALUE
	 * @generated
	 * @ordered
	 */
	CX(53, "cx", "cx"),

	/**
	 * The '<em><b>Cy</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cyprus.
	 * <!-- end-model-doc -->
	 * @see #CY_VALUE
	 * @generated
	 * @ordered
	 */
	CY(54, "cy", "cy"),

	/**
	 * The '<em><b>Cz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Czech Republic.
	 * <!-- end-model-doc -->
	 * @see #CZ_VALUE
	 * @generated
	 * @ordered
	 */
	CZ(55, "cz", "cz"),

	/**
	 * The '<em><b>De</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Germany.
	 * <!-- end-model-doc -->
	 * @see #DE_VALUE
	 * @generated
	 * @ordered
	 */
	DE(56, "de", "de"),

	/**
	 * The '<em><b>Dj</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Djibouti.
	 * <!-- end-model-doc -->
	 * @see #DJ_VALUE
	 * @generated
	 * @ordered
	 */
	DJ(57, "dj", "dj"),

	/**
	 * The '<em><b>Dk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Denmark.
	 * <!-- end-model-doc -->
	 * @see #DK_VALUE
	 * @generated
	 * @ordered
	 */
	DK(58, "dk", "dk"),

	/**
	 * The '<em><b>Dm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Dominica.
	 * <!-- end-model-doc -->
	 * @see #DM_VALUE
	 * @generated
	 * @ordered
	 */
	DM(59, "dm", "dm"),

	/**
	 * The '<em><b>Do</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Dominican Republic.
	 * <!-- end-model-doc -->
	 * @see #DO_VALUE
	 * @generated
	 * @ordered
	 */
	DO(60, "do", "do"),

	/**
	 * The '<em><b>Dz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Algeria.
	 * <!-- end-model-doc -->
	 * @see #DZ_VALUE
	 * @generated
	 * @ordered
	 */
	DZ(61, "dz", "dz"),

	/**
	 * The '<em><b>Ec</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ecuador.
	 * <!-- end-model-doc -->
	 * @see #EC_VALUE
	 * @generated
	 * @ordered
	 */
	EC(62, "ec", "ec"),

	/**
	 * The '<em><b>Ee</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Estonia.
	 * <!-- end-model-doc -->
	 * @see #EE_VALUE
	 * @generated
	 * @ordered
	 */
	EE(63, "ee", "ee"),

	/**
	 * The '<em><b>Eg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Egypt.
	 * <!-- end-model-doc -->
	 * @see #EG_VALUE
	 * @generated
	 * @ordered
	 */
	EG(64, "eg", "eg"),

	/**
	 * The '<em><b>Eh</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Western Sahara.
	 * <!-- end-model-doc -->
	 * @see #EH_VALUE
	 * @generated
	 * @ordered
	 */
	EH(65, "eh", "eh"),

	/**
	 * The '<em><b>Er</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Eritrea.
	 * <!-- end-model-doc -->
	 * @see #ER_VALUE
	 * @generated
	 * @ordered
	 */
	ER(66, "er", "er"),

	/**
	 * The '<em><b>Es</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Spain.
	 * <!-- end-model-doc -->
	 * @see #ES_VALUE
	 * @generated
	 * @ordered
	 */
	ES(67, "es", "es"),

	/**
	 * The '<em><b>Et</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ethiopia.
	 * <!-- end-model-doc -->
	 * @see #ET_VALUE
	 * @generated
	 * @ordered
	 */
	ET(68, "et", "et"),

	/**
	 * The '<em><b>Eu</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * European Union.
	 * <!-- end-model-doc -->
	 * @see #EU_VALUE
	 * @generated
	 * @ordered
	 */
	EU(69, "eu", "eu"),

	/**
	 * The '<em><b>Fi</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Finland.
	 * <!-- end-model-doc -->
	 * @see #FI_VALUE
	 * @generated
	 * @ordered
	 */
	FI(70, "fi", "fi"),

	/**
	 * The '<em><b>Fj</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Fiji.
	 * <!-- end-model-doc -->
	 * @see #FJ_VALUE
	 * @generated
	 * @ordered
	 */
	FJ(71, "fj", "fj"),

	/**
	 * The '<em><b>Fk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Falkland Islands (Malvinas)
	 * <!-- end-model-doc -->
	 * @see #FK_VALUE
	 * @generated
	 * @ordered
	 */
	FK(72, "fk", "fk"),

	/**
	 * The '<em><b>Fm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Micronesia, Federal State of.
	 * <!-- end-model-doc -->
	 * @see #FM_VALUE
	 * @generated
	 * @ordered
	 */
	FM(73, "fm", "fm"),

	/**
	 * The '<em><b>Fo</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Faroe Islands.
	 * <!-- end-model-doc -->
	 * @see #FO_VALUE
	 * @generated
	 * @ordered
	 */
	FO(74, "fo", "fo"),

	/**
	 * The '<em><b>Fr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * France.
	 * <!-- end-model-doc -->
	 * @see #FR_VALUE
	 * @generated
	 * @ordered
	 */
	FR(75, "fr", "fr"),

	/**
	 * The '<em><b>Ga</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Gabon.
	 * <!-- end-model-doc -->
	 * @see #GA_VALUE
	 * @generated
	 * @ordered
	 */
	GA(76, "ga", "ga"),

	/**
	 * The '<em><b>Gb</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United Kingdom.
	 * <!-- end-model-doc -->
	 * @see #GB_VALUE
	 * @generated
	 * @ordered
	 */
	GB(77, "gb", "gb"),

	/**
	 * The '<em><b>Gd</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Grenada.
	 * <!-- end-model-doc -->
	 * @see #GD_VALUE
	 * @generated
	 * @ordered
	 */
	GD(78, "gd", "gd"),

	/**
	 * The '<em><b>Ge</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Georgia.
	 * <!-- end-model-doc -->
	 * @see #GE_VALUE
	 * @generated
	 * @ordered
	 */
	GE(79, "ge", "ge"),

	/**
	 * The '<em><b>Gf</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * French Guiana.
	 * <!-- end-model-doc -->
	 * @see #GF_VALUE
	 * @generated
	 * @ordered
	 */
	GF(80, "gf", "gf"),

	/**
	 * The '<em><b>Gg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guernsey.
	 * <!-- end-model-doc -->
	 * @see #GG_VALUE
	 * @generated
	 * @ordered
	 */
	GG(81, "gg", "gg"),

	/**
	 * The '<em><b>Gh</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ghana.
	 * <!-- end-model-doc -->
	 * @see #GH_VALUE
	 * @generated
	 * @ordered
	 */
	GH(82, "gh", "gh"),

	/**
	 * The '<em><b>Gi</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Gibraltar.
	 * <!-- end-model-doc -->
	 * @see #GI_VALUE
	 * @generated
	 * @ordered
	 */
	GI(83, "gi", "gi"),

	/**
	 * The '<em><b>Gl</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Greenland.
	 * <!-- end-model-doc -->
	 * @see #GL_VALUE
	 * @generated
	 * @ordered
	 */
	GL(84, "gl", "gl"),

	/**
	 * The '<em><b>Gm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Gambia.
	 * <!-- end-model-doc -->
	 * @see #GM_VALUE
	 * @generated
	 * @ordered
	 */
	GM(85, "gm", "gm"),

	/**
	 * The '<em><b>Gn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guinea.
	 * <!-- end-model-doc -->
	 * @see #GN_VALUE
	 * @generated
	 * @ordered
	 */
	GN(86, "gn", "gn"),

	/**
	 * The '<em><b>Gp</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guadeloupe.
	 * <!-- end-model-doc -->
	 * @see #GP_VALUE
	 * @generated
	 * @ordered
	 */
	GP(87, "gp", "gp"),

	/**
	 * The '<em><b>Gq</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Equatorial Guinea.
	 * <!-- end-model-doc -->
	 * @see #GQ_VALUE
	 * @generated
	 * @ordered
	 */
	GQ(88, "gq", "gq"),

	/**
	 * The '<em><b>Gr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Greece.
	 * <!-- end-model-doc -->
	 * @see #GR_VALUE
	 * @generated
	 * @ordered
	 */
	GR(89, "gr", "gr"),

	/**
	 * The '<em><b>Gs</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * South Georgia and the South Sandwich Islands.
	 * <!-- end-model-doc -->
	 * @see #GS_VALUE
	 * @generated
	 * @ordered
	 */
	GS(90, "gs", "gs"),

	/**
	 * The '<em><b>Gt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guatemala.
	 * <!-- end-model-doc -->
	 * @see #GT_VALUE
	 * @generated
	 * @ordered
	 */
	GT(91, "gt", "gt"),

	/**
	 * The '<em><b>Gu</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guam.
	 * <!-- end-model-doc -->
	 * @see #GU_VALUE
	 * @generated
	 * @ordered
	 */
	GU(92, "gu", "gu"),

	/**
	 * The '<em><b>Gw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guinea-Bissau.
	 * <!-- end-model-doc -->
	 * @see #GW_VALUE
	 * @generated
	 * @ordered
	 */
	GW(93, "gw", "gw"),

	/**
	 * The '<em><b>Gy</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guyana.
	 * <!-- end-model-doc -->
	 * @see #GY_VALUE
	 * @generated
	 * @ordered
	 */
	GY(94, "gy", "gy"),

	/**
	 * The '<em><b>Hk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Hong Kong.
	 * <!-- end-model-doc -->
	 * @see #HK_VALUE
	 * @generated
	 * @ordered
	 */
	HK(95, "hk", "hk"),

	/**
	 * The '<em><b>Hm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Heard and McDonald Islands.
	 * <!-- end-model-doc -->
	 * @see #HM_VALUE
	 * @generated
	 * @ordered
	 */
	HM(96, "hm", "hm"),

	/**
	 * The '<em><b>Hn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Honduras.
	 * <!-- end-model-doc -->
	 * @see #HN_VALUE
	 * @generated
	 * @ordered
	 */
	HN(97, "hn", "hn"),

	/**
	 * The '<em><b>Hr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Croatia/Hrvatska.
	 * <!-- end-model-doc -->
	 * @see #HR_VALUE
	 * @generated
	 * @ordered
	 */
	HR(98, "hr", "hr"),

	/**
	 * The '<em><b>Ht</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Haiti.
	 * <!-- end-model-doc -->
	 * @see #HT_VALUE
	 * @generated
	 * @ordered
	 */
	HT(99, "ht", "ht"),

	/**
	 * The '<em><b>Hu</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Hungary.
	 * <!-- end-model-doc -->
	 * @see #HU_VALUE
	 * @generated
	 * @ordered
	 */
	HU(100, "hu", "hu"),

	/**
	 * The '<em><b>Id</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Indonesia.
	 * <!-- end-model-doc -->
	 * @see #ID_VALUE
	 * @generated
	 * @ordered
	 */
	ID(101, "id", "id"),

	/**
	 * The '<em><b>Ie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ireland.
	 * <!-- end-model-doc -->
	 * @see #IE_VALUE
	 * @generated
	 * @ordered
	 */
	IE(102, "ie", "ie"),

	/**
	 * The '<em><b>Il</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Israel.
	 * <!-- end-model-doc -->
	 * @see #IL_VALUE
	 * @generated
	 * @ordered
	 */
	IL(103, "il", "il"),

	/**
	 * The '<em><b>Im</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Isle of Man.
	 * <!-- end-model-doc -->
	 * @see #IM_VALUE
	 * @generated
	 * @ordered
	 */
	IM(104, "im", "im"),

	/**
	 * The '<em><b>In</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * India.
	 * <!-- end-model-doc -->
	 * @see #IN_VALUE
	 * @generated
	 * @ordered
	 */
	IN(105, "in", "in"),

	/**
	 * The '<em><b>Io</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * British Indian Ocean Territory.
	 * <!-- end-model-doc -->
	 * @see #IO_VALUE
	 * @generated
	 * @ordered
	 */
	IO(106, "io", "io"),

	/**
	 * The '<em><b>Iq</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Iraq
	 * <!-- end-model-doc -->
	 * @see #IQ_VALUE
	 * @generated
	 * @ordered
	 */
	IQ(107, "iq", "iq"),

	/**
	 * The '<em><b>Ir</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Iran, Islamic Republic of.
	 * <!-- end-model-doc -->
	 * @see #IR_VALUE
	 * @generated
	 * @ordered
	 */
	IR(108, "ir", "ir"),

	/**
	 * The '<em><b>Is</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Iceland.
	 * <!-- end-model-doc -->
	 * @see #IS_VALUE
	 * @generated
	 * @ordered
	 */
	IS(109, "is", "is"),

	/**
	 * The '<em><b>It</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Italy.
	 * <!-- end-model-doc -->
	 * @see #IT_VALUE
	 * @generated
	 * @ordered
	 */
	IT(110, "it", "it"),

	/**
	 * The '<em><b>Je</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Jersey.
	 * <!-- end-model-doc -->
	 * @see #JE_VALUE
	 * @generated
	 * @ordered
	 */
	JE(111, "je", "je"),

	/**
	 * The '<em><b>Jm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Jamaica.
	 * <!-- end-model-doc -->
	 * @see #JM_VALUE
	 * @generated
	 * @ordered
	 */
	JM(112, "jm", "jm"),

	/**
	 * The '<em><b>Jo</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Jordan.
	 * <!-- end-model-doc -->
	 * @see #JO_VALUE
	 * @generated
	 * @ordered
	 */
	JO(113, "jo", "jo"),

	/**
	 * The '<em><b>Jp</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Japan.
	 * <!-- end-model-doc -->
	 * @see #JP_VALUE
	 * @generated
	 * @ordered
	 */
	JP(114, "jp", "jp"),

	/**
	 * The '<em><b>Ke</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kenya.
	 * <!-- end-model-doc -->
	 * @see #KE_VALUE
	 * @generated
	 * @ordered
	 */
	KE(115, "ke", "ke"),

	/**
	 * The '<em><b>Kg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kyrgyzstan.
	 * <!-- end-model-doc -->
	 * @see #KG_VALUE
	 * @generated
	 * @ordered
	 */
	KG(116, "kg", "kg"),

	/**
	 * The '<em><b>Kh</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cambodia.
	 * <!-- end-model-doc -->
	 * @see #KH_VALUE
	 * @generated
	 * @ordered
	 */
	KH(117, "kh", "kh"),

	/**
	 * The '<em><b>Ki</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kiribati.
	 * <!-- end-model-doc -->
	 * @see #KI_VALUE
	 * @generated
	 * @ordered
	 */
	KI(118, "ki", "ki"),

	/**
	 * The '<em><b>Km</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Comoros.
	 * <!-- end-model-doc -->
	 * @see #KM_VALUE
	 * @generated
	 * @ordered
	 */
	KM(119, "km", "km"),

	/**
	 * The '<em><b>Kn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Kitts and Nevis.
	 * <!-- end-model-doc -->
	 * @see #KN_VALUE
	 * @generated
	 * @ordered
	 */
	KN(120, "kn", "kn"),

	/**
	 * The '<em><b>Kp</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Korea, Democratic People's Republic.
	 * <!-- end-model-doc -->
	 * @see #KP_VALUE
	 * @generated
	 * @ordered
	 */
	KP(121, "kp", "kp"),

	/**
	 * The '<em><b>Kr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Korea, Republic of.
	 * <!-- end-model-doc -->
	 * @see #KR_VALUE
	 * @generated
	 * @ordered
	 */
	KR(122, "kr", "kr"),

	/**
	 * The '<em><b>Kw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kuwait.
	 * <!-- end-model-doc -->
	 * @see #KW_VALUE
	 * @generated
	 * @ordered
	 */
	KW(123, "kw", "kw"),

	/**
	 * The '<em><b>Ky</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cayman Islands.
	 * <!-- end-model-doc -->
	 * @see #KY_VALUE
	 * @generated
	 * @ordered
	 */
	KY(124, "ky", "ky"),

	/**
	 * The '<em><b>Kz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kazakhstan.
	 * <!-- end-model-doc -->
	 * @see #KZ_VALUE
	 * @generated
	 * @ordered
	 */
	KZ(125, "kz", "kz"),

	/**
	 * The '<em><b>La</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lao People's Democratic Republic.
	 * <!-- end-model-doc -->
	 * @see #LA_VALUE
	 * @generated
	 * @ordered
	 */
	LA(126, "la", "la"),

	/**
	 * The '<em><b>Lb</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lebanon.
	 * <!-- end-model-doc -->
	 * @see #LB_VALUE
	 * @generated
	 * @ordered
	 */
	LB(127, "lb", "lb"),

	/**
	 * The '<em><b>Lc</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Lucia.
	 * <!-- end-model-doc -->
	 * @see #LC_VALUE
	 * @generated
	 * @ordered
	 */
	LC(128, "lc", "lc"),

	/**
	 * The '<em><b>Li</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Liechtenstein.
	 * <!-- end-model-doc -->
	 * @see #LI_VALUE
	 * @generated
	 * @ordered
	 */
	LI(129, "li", "li"),

	/**
	 * The '<em><b>Lk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sri Lanka.
	 * <!-- end-model-doc -->
	 * @see #LK_VALUE
	 * @generated
	 * @ordered
	 */
	LK(130, "lk", "lk"),

	/**
	 * The '<em><b>Lr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Liberia.
	 * <!-- end-model-doc -->
	 * @see #LR_VALUE
	 * @generated
	 * @ordered
	 */
	LR(131, "lr", "lr"),

	/**
	 * The '<em><b>Ls</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lesotho.
	 * <!-- end-model-doc -->
	 * @see #LS_VALUE
	 * @generated
	 * @ordered
	 */
	LS(132, "ls", "ls"),

	/**
	 * The '<em><b>Lt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lithuania.
	 * <!-- end-model-doc -->
	 * @see #LT_VALUE
	 * @generated
	 * @ordered
	 */
	LT(133, "lt", "lt"),

	/**
	 * The '<em><b>Lu</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Luxembourg.
	 * <!-- end-model-doc -->
	 * @see #LU_VALUE
	 * @generated
	 * @ordered
	 */
	LU(134, "lu", "lu"),

	/**
	 * The '<em><b>Lv</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Latvia.
	 * <!-- end-model-doc -->
	 * @see #LV_VALUE
	 * @generated
	 * @ordered
	 */
	LV(135, "lv", "lv"),

	/**
	 * The '<em><b>Ly</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Libyan Arab Jamahiriya.
	 * <!-- end-model-doc -->
	 * @see #LY_VALUE
	 * @generated
	 * @ordered
	 */
	LY(136, "ly", "ly"),

	/**
	 * The '<em><b>Ma</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Morocco.
	 * <!-- end-model-doc -->
	 * @see #MA_VALUE
	 * @generated
	 * @ordered
	 */
	MA(137, "ma", "ma"),

	/**
	 * The '<em><b>Mc</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Monaco.
	 * <!-- end-model-doc -->
	 * @see #MC_VALUE
	 * @generated
	 * @ordered
	 */
	MC(138, "mc", "mc"),

	/**
	 * The '<em><b>Md</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Moldova, Republic of.
	 * <!-- end-model-doc -->
	 * @see #MD_VALUE
	 * @generated
	 * @ordered
	 */
	MD(139, "md", "md"),

	/**
	 * The '<em><b>Mg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Madagascar.
	 * <!-- end-model-doc -->
	 * @see #MG_VALUE
	 * @generated
	 * @ordered
	 */
	MG(140, "mg", "mg"),

	/**
	 * The '<em><b>Mh</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Marshall Islands.
	 * <!-- end-model-doc -->
	 * @see #MH_VALUE
	 * @generated
	 * @ordered
	 */
	MH(141, "mh", "mh"),

	/**
	 * The '<em><b>Mk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Macedonia, The Former Yugoslav Republic of.
	 * <!-- end-model-doc -->
	 * @see #MK_VALUE
	 * @generated
	 * @ordered
	 */
	MK(142, "mk", "mk"),

	/**
	 * The '<em><b>Ml</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mali.
	 * <!-- end-model-doc -->
	 * @see #ML_VALUE
	 * @generated
	 * @ordered
	 */
	ML(143, "ml", "ml"),

	/**
	 * The '<em><b>Mm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Myanmar.
	 * <!-- end-model-doc -->
	 * @see #MM_VALUE
	 * @generated
	 * @ordered
	 */
	MM(144, "mm", "mm"),

	/**
	 * The '<em><b>Mn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mongolia.
	 * <!-- end-model-doc -->
	 * @see #MN_VALUE
	 * @generated
	 * @ordered
	 */
	MN(145, "mn", "mn"),

	/**
	 * The '<em><b>Mo</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Macau.
	 * <!-- end-model-doc -->
	 * @see #MO_VALUE
	 * @generated
	 * @ordered
	 */
	MO(146, "mo", "mo"),

	/**
	 * The '<em><b>Mp</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Northern Mariana Islands.
	 * <!-- end-model-doc -->
	 * @see #MP_VALUE
	 * @generated
	 * @ordered
	 */
	MP(147, "mp", "mp"),

	/**
	 * The '<em><b>Mq</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Martinique.
	 * <!-- end-model-doc -->
	 * @see #MQ_VALUE
	 * @generated
	 * @ordered
	 */
	MQ(148, "mq", "mq"),

	/**
	 * The '<em><b>Mr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mauritania.
	 * <!-- end-model-doc -->
	 * @see #MR_VALUE
	 * @generated
	 * @ordered
	 */
	MR(149, "mr", "mr"),

	/**
	 * The '<em><b>Ms</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Montserrat.
	 * <!-- end-model-doc -->
	 * @see #MS_VALUE
	 * @generated
	 * @ordered
	 */
	MS(150, "ms", "ms"),

	/**
	 * The '<em><b>Mt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Malta.
	 * <!-- end-model-doc -->
	 * @see #MT_VALUE
	 * @generated
	 * @ordered
	 */
	MT(151, "mt", "mt"),

	/**
	 * The '<em><b>Mu</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mauritius.
	 * <!-- end-model-doc -->
	 * @see #MU_VALUE
	 * @generated
	 * @ordered
	 */
	MU(152, "mu", "mu"),

	/**
	 * The '<em><b>Mv</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Maldives.
	 * <!-- end-model-doc -->
	 * @see #MV_VALUE
	 * @generated
	 * @ordered
	 */
	MV(153, "mv", "mv"),

	/**
	 * The '<em><b>Mw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Malawi.
	 * <!-- end-model-doc -->
	 * @see #MW_VALUE
	 * @generated
	 * @ordered
	 */
	MW(154, "mw", "mw"),

	/**
	 * The '<em><b>Mx</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mexico.
	 * <!-- end-model-doc -->
	 * @see #MX_VALUE
	 * @generated
	 * @ordered
	 */
	MX(155, "mx", "mx"),

	/**
	 * The '<em><b>My</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Malaysia.
	 * <!-- end-model-doc -->
	 * @see #MY_VALUE
	 * @generated
	 * @ordered
	 */
	MY(156, "my", "my"),

	/**
	 * The '<em><b>Mz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mozambique.
	 * <!-- end-model-doc -->
	 * @see #MZ_VALUE
	 * @generated
	 * @ordered
	 */
	MZ(157, "mz", "mz"),

	/**
	 * The '<em><b>Na</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Namibia.
	 * <!-- end-model-doc -->
	 * @see #NA_VALUE
	 * @generated
	 * @ordered
	 */
	NA(158, "na", "na"),

	/**
	 * The '<em><b>Nc</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * New Caledonia.
	 * <!-- end-model-doc -->
	 * @see #NC_VALUE
	 * @generated
	 * @ordered
	 */
	NC(159, "nc", "nc"),

	/**
	 * The '<em><b>Ne</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Niger.
	 * <!-- end-model-doc -->
	 * @see #NE_VALUE
	 * @generated
	 * @ordered
	 */
	NE(160, "ne", "ne"),

	/**
	 * The '<em><b>Nf</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Norfolk Island.
	 * <!-- end-model-doc -->
	 * @see #NF_VALUE
	 * @generated
	 * @ordered
	 */
	NF(161, "nf", "nf"),

	/**
	 * The '<em><b>Ng</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Nigeria.
	 * <!-- end-model-doc -->
	 * @see #NG_VALUE
	 * @generated
	 * @ordered
	 */
	NG(162, "ng", "ng"),

	/**
	 * The '<em><b>Ni</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Nicaragua.
	 * <!-- end-model-doc -->
	 * @see #NI_VALUE
	 * @generated
	 * @ordered
	 */
	NI(163, "ni", "ni"),

	/**
	 * The '<em><b>Nl</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Netherlands.
	 * <!-- end-model-doc -->
	 * @see #NL_VALUE
	 * @generated
	 * @ordered
	 */
	NL(164, "nl", "nl"),

	/**
	 * The '<em><b>No</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Norway.
	 * <!-- end-model-doc -->
	 * @see #NO_VALUE
	 * @generated
	 * @ordered
	 */
	NO(165, "no", "no"),

	/**
	 * The '<em><b>Np</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Nepal.
	 * <!-- end-model-doc -->
	 * @see #NP_VALUE
	 * @generated
	 * @ordered
	 */
	NP(166, "np", "np"),

	/**
	 * The '<em><b>Nr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Nauru.
	 * <!-- end-model-doc -->
	 * @see #NR_VALUE
	 * @generated
	 * @ordered
	 */
	NR(167, "nr", "nr"),

	/**
	 * The '<em><b>Nu</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Niue.
	 * <!-- end-model-doc -->
	 * @see #NU_VALUE
	 * @generated
	 * @ordered
	 */
	NU(168, "nu", "nu"),

	/**
	 * The '<em><b>Nz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * New Zealand.
	 * <!-- end-model-doc -->
	 * @see #NZ_VALUE
	 * @generated
	 * @ordered
	 */
	NZ(169, "nz", "nz"),

	/**
	 * The '<em><b>Om</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Oman.
	 * <!-- end-model-doc -->
	 * @see #OM_VALUE
	 * @generated
	 * @ordered
	 */
	OM(170, "om", "om"),

	/**
	 * The '<em><b>Pa</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Panama.
	 * <!-- end-model-doc -->
	 * @see #PA_VALUE
	 * @generated
	 * @ordered
	 */
	PA(171, "pa", "pa"),

	/**
	 * The '<em><b>Pe</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Peru.
	 * <!-- end-model-doc -->
	 * @see #PE_VALUE
	 * @generated
	 * @ordered
	 */
	PE(172, "pe", "pe"),

	/**
	 * The '<em><b>Pf</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * French Polynesia.
	 * <!-- end-model-doc -->
	 * @see #PF_VALUE
	 * @generated
	 * @ordered
	 */
	PF(173, "pf", "pf"),

	/**
	 * The '<em><b>Pg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Papua New Guinea.
	 * <!-- end-model-doc -->
	 * @see #PG_VALUE
	 * @generated
	 * @ordered
	 */
	PG(174, "pg", "pg"),

	/**
	 * The '<em><b>Ph</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Philippines.
	 * <!-- end-model-doc -->
	 * @see #PH_VALUE
	 * @generated
	 * @ordered
	 */
	PH(175, "ph", "ph"),

	/**
	 * The '<em><b>Pk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Pakistan.
	 * <!-- end-model-doc -->
	 * @see #PK_VALUE
	 * @generated
	 * @ordered
	 */
	PK(176, "pk", "pk"),

	/**
	 * The '<em><b>Pl</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Poland.
	 * <!-- end-model-doc -->
	 * @see #PL_VALUE
	 * @generated
	 * @ordered
	 */
	PL(177, "pl", "pl"),

	/**
	 * The '<em><b>Pm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Pierre and Miquelon.
	 * <!-- end-model-doc -->
	 * @see #PM_VALUE
	 * @generated
	 * @ordered
	 */
	PM(178, "pm", "pm"),

	/**
	 * The '<em><b>Pn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Pitcairn Island.
	 * <!-- end-model-doc -->
	 * @see #PN_VALUE
	 * @generated
	 * @ordered
	 */
	PN(179, "pn", "pn"),

	/**
	 * The '<em><b>Pr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Puerto Rico.
	 * <!-- end-model-doc -->
	 * @see #PR_VALUE
	 * @generated
	 * @ordered
	 */
	PR(180, "pr", "pr"),

	/**
	 * The '<em><b>Ps</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Palestinian Territories.
	 * <!-- end-model-doc -->
	 * @see #PS_VALUE
	 * @generated
	 * @ordered
	 */
	PS(181, "ps", "ps"),

	/**
	 * The '<em><b>Pt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Portugal.
	 * <!-- end-model-doc -->
	 * @see #PT_VALUE
	 * @generated
	 * @ordered
	 */
	PT(182, "pt", "pt"),

	/**
	 * The '<em><b>Pw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Palau.
	 * <!-- end-model-doc -->
	 * @see #PW_VALUE
	 * @generated
	 * @ordered
	 */
	PW(183, "pw", "pw"),

	/**
	 * The '<em><b>Py</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Paraguay.
	 * <!-- end-model-doc -->
	 * @see #PY_VALUE
	 * @generated
	 * @ordered
	 */
	PY(184, "py", "py"),

	/**
	 * The '<em><b>Qa</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Qatar.
	 * <!-- end-model-doc -->
	 * @see #QA_VALUE
	 * @generated
	 * @ordered
	 */
	QA(185, "qa", "qa"),

	/**
	 * The '<em><b>Re</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reunion Island.
	 * <!-- end-model-doc -->
	 * @see #RE_VALUE
	 * @generated
	 * @ordered
	 */
	RE(186, "re", "re"),

	/**
	 * The '<em><b>Ro</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Romania.
	 * <!-- end-model-doc -->
	 * @see #RO_VALUE
	 * @generated
	 * @ordered
	 */
	RO(187, "ro", "ro"),

	/**
	 * The '<em><b>Ru</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Russian Federation.
	 * <!-- end-model-doc -->
	 * @see #RU_VALUE
	 * @generated
	 * @ordered
	 */
	RU(188, "ru", "ru"),

	/**
	 * The '<em><b>Rw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Rwanda.
	 * <!-- end-model-doc -->
	 * @see #RW_VALUE
	 * @generated
	 * @ordered
	 */
	RW(189, "rw", "rw"),

	/**
	 * The '<em><b>Sa</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saudi Arabia.
	 * <!-- end-model-doc -->
	 * @see #SA_VALUE
	 * @generated
	 * @ordered
	 */
	SA(190, "sa", "sa"),

	/**
	 * The '<em><b>Sb</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Solomon Islands.
	 * <!-- end-model-doc -->
	 * @see #SB_VALUE
	 * @generated
	 * @ordered
	 */
	SB(191, "sb", "sb"),

	/**
	 * The '<em><b>Sc</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Seychelles.
	 * <!-- end-model-doc -->
	 * @see #SC_VALUE
	 * @generated
	 * @ordered
	 */
	SC(192, "sc", "sc"),

	/**
	 * The '<em><b>Sd</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sudan.
	 * <!-- end-model-doc -->
	 * @see #SD_VALUE
	 * @generated
	 * @ordered
	 */
	SD(193, "sd", "sd"),

	/**
	 * The '<em><b>Se</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sweden.
	 * <!-- end-model-doc -->
	 * @see #SE_VALUE
	 * @generated
	 * @ordered
	 */
	SE(194, "se", "se"),

	/**
	 * The '<em><b>Sg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Singapore.
	 * <!-- end-model-doc -->
	 * @see #SG_VALUE
	 * @generated
	 * @ordered
	 */
	SG(195, "sg", "sg"),

	/**
	 * The '<em><b>Sh</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Helena.
	 * <!-- end-model-doc -->
	 * @see #SH_VALUE
	 * @generated
	 * @ordered
	 */
	SH(196, "sh", "sh"),

	/**
	 * The '<em><b>Si</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Slovenia.
	 * <!-- end-model-doc -->
	 * @see #SI_VALUE
	 * @generated
	 * @ordered
	 */
	SI(197, "si", "si"),

	/**
	 * The '<em><b>Sj</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Svalbard and Jan Mayen Islands.
	 * <!-- end-model-doc -->
	 * @see #SJ_VALUE
	 * @generated
	 * @ordered
	 */
	SJ(198, "sj", "sj"),

	/**
	 * The '<em><b>Sk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Slovak Republic.
	 * <!-- end-model-doc -->
	 * @see #SK_VALUE
	 * @generated
	 * @ordered
	 */
	SK(199, "sk", "sk"),

	/**
	 * The '<em><b>Sl</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sierra Leone.
	 * <!-- end-model-doc -->
	 * @see #SL_VALUE
	 * @generated
	 * @ordered
	 */
	SL(200, "sl", "sl"),

	/**
	 * The '<em><b>Sm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * San Marino.
	 * <!-- end-model-doc -->
	 * @see #SM_VALUE
	 * @generated
	 * @ordered
	 */
	SM(201, "sm", "sm"),

	/**
	 * The '<em><b>Sn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Senegal.
	 * <!-- end-model-doc -->
	 * @see #SN_VALUE
	 * @generated
	 * @ordered
	 */
	SN(202, "sn", "sn"),

	/**
	 * The '<em><b>So</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Somalia.
	 * <!-- end-model-doc -->
	 * @see #SO_VALUE
	 * @generated
	 * @ordered
	 */
	SO(203, "so", "so"),

	/**
	 * The '<em><b>Sr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Suriname.
	 * <!-- end-model-doc -->
	 * @see #SR_VALUE
	 * @generated
	 * @ordered
	 */
	SR(204, "sr", "sr"),

	/**
	 * The '<em><b>St</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sao Tome and Principe.
	 * <!-- end-model-doc -->
	 * @see #ST_VALUE
	 * @generated
	 * @ordered
	 */
	ST(205, "st", "st"),

	/**
	 * The '<em><b>Sv</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * El Salvador.
	 * <!-- end-model-doc -->
	 * @see #SV_VALUE
	 * @generated
	 * @ordered
	 */
	SV(206, "sv", "sv"),

	/**
	 * The '<em><b>Sy</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Syrian Arab Republic.
	 * <!-- end-model-doc -->
	 * @see #SY_VALUE
	 * @generated
	 * @ordered
	 */
	SY(207, "sy", "sy"),

	/**
	 * The '<em><b>Sz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Swaziland.
	 * <!-- end-model-doc -->
	 * @see #SZ_VALUE
	 * @generated
	 * @ordered
	 */
	SZ(208, "sz", "sz"),

	/**
	 * The '<em><b>Tc</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Turks and Caicos Islands.
	 * <!-- end-model-doc -->
	 * @see #TC_VALUE
	 * @generated
	 * @ordered
	 */
	TC(209, "tc", "tc"),

	/**
	 * The '<em><b>Td</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Chad.
	 * <!-- end-model-doc -->
	 * @see #TD_VALUE
	 * @generated
	 * @ordered
	 */
	TD(210, "td", "td"),

	/**
	 * The '<em><b>Tf</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * French Southern Territories.
	 * <!-- end-model-doc -->
	 * @see #TF_VALUE
	 * @generated
	 * @ordered
	 */
	TF(211, "tf", "tf"),

	/**
	 * The '<em><b>Tg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Togo.
	 * <!-- end-model-doc -->
	 * @see #TG_VALUE
	 * @generated
	 * @ordered
	 */
	TG(212, "tg", "tg"),

	/**
	 * The '<em><b>Th</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Thailand.
	 * <!-- end-model-doc -->
	 * @see #TH_VALUE
	 * @generated
	 * @ordered
	 */
	TH(213, "th", "th"),

	/**
	 * The '<em><b>Tj</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tajikistan.
	 * <!-- end-model-doc -->
	 * @see #TJ_VALUE
	 * @generated
	 * @ordered
	 */
	TJ(214, "tj", "tj"),

	/**
	 * The '<em><b>Tk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tokelau.
	 * <!-- end-model-doc -->
	 * @see #TK_VALUE
	 * @generated
	 * @ordered
	 */
	TK(215, "tk", "tk"),

	/**
	 * The '<em><b>Tl</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Timor-Leste.
	 * <!-- end-model-doc -->
	 * @see #TL_VALUE
	 * @generated
	 * @ordered
	 */
	TL(216, "tl", "tl"),

	/**
	 * The '<em><b>Tm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Turkmenistan.
	 * <!-- end-model-doc -->
	 * @see #TM_VALUE
	 * @generated
	 * @ordered
	 */
	TM(217, "tm", "tm"),

	/**
	 * The '<em><b>Tn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tunisia.
	 * <!-- end-model-doc -->
	 * @see #TN_VALUE
	 * @generated
	 * @ordered
	 */
	TN(218, "tn", "tn"),

	/**
	 * The '<em><b>To</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tonga.
	 * <!-- end-model-doc -->
	 * @see #TO_VALUE
	 * @generated
	 * @ordered
	 */
	TO(219, "to", "to"),

	/**
	 * The '<em><b>Tp</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * East Timor.
	 * <!-- end-model-doc -->
	 * @see #TP_VALUE
	 * @generated
	 * @ordered
	 */
	TP(220, "tp", "tp"),

	/**
	 * The '<em><b>Tr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Turkey.
	 * <!-- end-model-doc -->
	 * @see #TR_VALUE
	 * @generated
	 * @ordered
	 */
	TR(221, "tr", "tr"),

	/**
	 * The '<em><b>Tt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Trinidad and Tobago.
	 * <!-- end-model-doc -->
	 * @see #TT_VALUE
	 * @generated
	 * @ordered
	 */
	TT(222, "tt", "tt"),

	/**
	 * The '<em><b>Tv</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tuvalu.
	 * <!-- end-model-doc -->
	 * @see #TV_VALUE
	 * @generated
	 * @ordered
	 */
	TV(223, "tv", "tv"),

	/**
	 * The '<em><b>Tw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Taiwan.
	 * <!-- end-model-doc -->
	 * @see #TW_VALUE
	 * @generated
	 * @ordered
	 */
	TW(224, "tw", "tw"),

	/**
	 * The '<em><b>Tz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tanzania.
	 * <!-- end-model-doc -->
	 * @see #TZ_VALUE
	 * @generated
	 * @ordered
	 */
	TZ(225, "tz", "tz"),

	/**
	 * The '<em><b>Ua</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ukraine.
	 * <!-- end-model-doc -->
	 * @see #UA_VALUE
	 * @generated
	 * @ordered
	 */
	UA(226, "ua", "ua"),

	/**
	 * The '<em><b>Ug</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Uganda.
	 * <!-- end-model-doc -->
	 * @see #UG_VALUE
	 * @generated
	 * @ordered
	 */
	UG(227, "ug", "ug"),

	/**
	 * The '<em><b>Uk</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United Kingdom.
	 * <!-- end-model-doc -->
	 * @see #UK_VALUE
	 * @generated
	 * @ordered
	 */
	UK(228, "uk", "uk"),

	/**
	 * The '<em><b>Um</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United States Minor Outlying Islands.
	 * <!-- end-model-doc -->
	 * @see #UM_VALUE
	 * @generated
	 * @ordered
	 */
	UM(229, "um", "um"),

	/**
	 * The '<em><b>Us</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United States.
	 * <!-- end-model-doc -->
	 * @see #US_VALUE
	 * @generated
	 * @ordered
	 */
	US(230, "us", "us"),

	/**
	 * The '<em><b>Uy</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Uruguay.
	 * <!-- end-model-doc -->
	 * @see #UY_VALUE
	 * @generated
	 * @ordered
	 */
	UY(231, "uy", "uy"),

	/**
	 * The '<em><b>Uz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Uzbekistan.
	 * <!-- end-model-doc -->
	 * @see #UZ_VALUE
	 * @generated
	 * @ordered
	 */
	UZ(232, "uz", "uz"),

	/**
	 * The '<em><b>Va</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Holy See (Vatican City State)
	 * <!-- end-model-doc -->
	 * @see #VA_VALUE
	 * @generated
	 * @ordered
	 */
	VA(233, "va", "va"),

	/**
	 * The '<em><b>Vc</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Vincent and the Grenadines.
	 * <!-- end-model-doc -->
	 * @see #VC_VALUE
	 * @generated
	 * @ordered
	 */
	VC(234, "vc", "vc"),

	/**
	 * The '<em><b>Ve</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Venezuela.
	 * <!-- end-model-doc -->
	 * @see #VE_VALUE
	 * @generated
	 * @ordered
	 */
	VE(235, "ve", "ve"),

	/**
	 * The '<em><b>Vg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Virgin Islands, British.
	 * <!-- end-model-doc -->
	 * @see #VG_VALUE
	 * @generated
	 * @ordered
	 */
	VG(236, "vg", "vg"),

	/**
	 * The '<em><b>Vi</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Virgin Islands, Us.
	 * <!-- end-model-doc -->
	 * @see #VI_VALUE
	 * @generated
	 * @ordered
	 */
	VI(237, "vi", "vi"),

	/**
	 * The '<em><b>Vn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Vietnam.
	 * <!-- end-model-doc -->
	 * @see #VN_VALUE
	 * @generated
	 * @ordered
	 */
	VN(238, "vn", "vn"),

	/**
	 * The '<em><b>Vu</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Vanuatu.
	 * <!-- end-model-doc -->
	 * @see #VU_VALUE
	 * @generated
	 * @ordered
	 */
	VU(239, "vu", "vu"),

	/**
	 * The '<em><b>Wf</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Wallis and Futuna Islands.
	 * <!-- end-model-doc -->
	 * @see #WF_VALUE
	 * @generated
	 * @ordered
	 */
	WF(240, "wf", "wf"),

	/**
	 * The '<em><b>Ws</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Samoa.
	 * <!-- end-model-doc -->
	 * @see #WS_VALUE
	 * @generated
	 * @ordered
	 */
	WS(241, "ws", "ws"),

	/**
	 * The '<em><b>Ye</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Yemen.
	 * <!-- end-model-doc -->
	 * @see #YE_VALUE
	 * @generated
	 * @ordered
	 */
	YE(242, "ye", "ye"),

	/**
	 * The '<em><b>Yt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mayotte.
	 * <!-- end-model-doc -->
	 * @see #YT_VALUE
	 * @generated
	 * @ordered
	 */
	YT(243, "yt", "yt"),

	/**
	 * The '<em><b>Yu</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Yugoslavia.
	 * <!-- end-model-doc -->
	 * @see #YU_VALUE
	 * @generated
	 * @ordered
	 */
	YU(244, "yu", "yu"),

	/**
	 * The '<em><b>Za</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * South Africa.
	 * <!-- end-model-doc -->
	 * @see #ZA_VALUE
	 * @generated
	 * @ordered
	 */
	ZA(245, "za", "za"),

	/**
	 * The '<em><b>Zm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Zambia.
	 * <!-- end-model-doc -->
	 * @see #ZM_VALUE
	 * @generated
	 * @ordered
	 */
	ZM(246, "zm", "zm"),

	/**
	 * The '<em><b>Zw</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Zimbabwe.
	 * <!-- end-model-doc -->
	 * @see #ZW_VALUE
	 * @generated
	 * @ordered
	 */
	ZW(247, "zw", "zw");

	/**
	 * The '<em><b>Ac</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ascension Island.
	 * <!-- end-model-doc -->
	 * @see #AC
	 * @model name="ac"
	 * @generated
	 * @ordered
	 */
	public static final int AC_VALUE = 0;

	/**
	 * The '<em><b>Ad</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Andorra.
	 * <!-- end-model-doc -->
	 * @see #AD
	 * @model name="ad"
	 * @generated
	 * @ordered
	 */
	public static final int AD_VALUE = 1;

	/**
	 * The '<em><b>Ae</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United Arab Emirates.
	 * <!-- end-model-doc -->
	 * @see #AE
	 * @model name="ae"
	 * @generated
	 * @ordered
	 */
	public static final int AE_VALUE = 2;

	/**
	 * The '<em><b>Af</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Afghanistan.
	 * <!-- end-model-doc -->
	 * @see #AF
	 * @model name="af"
	 * @generated
	 * @ordered
	 */
	public static final int AF_VALUE = 3;

	/**
	 * The '<em><b>Ag</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Antigua and Barbuda.
	 * <!-- end-model-doc -->
	 * @see #AG
	 * @model name="ag"
	 * @generated
	 * @ordered
	 */
	public static final int AG_VALUE = 4;

	/**
	 * The '<em><b>Ai</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Anguilla.
	 * <!-- end-model-doc -->
	 * @see #AI
	 * @model name="ai"
	 * @generated
	 * @ordered
	 */
	public static final int AI_VALUE = 5;

	/**
	 * The '<em><b>Al</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Albania.
	 * <!-- end-model-doc -->
	 * @see #AL
	 * @model name="al"
	 * @generated
	 * @ordered
	 */
	public static final int AL_VALUE = 6;

	/**
	 * The '<em><b>Am</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Armenia.
	 * <!-- end-model-doc -->
	 * @see #AM
	 * @model name="am"
	 * @generated
	 * @ordered
	 */
	public static final int AM_VALUE = 7;

	/**
	 * The '<em><b>An</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Netherlands Antilles.
	 * <!-- end-model-doc -->
	 * @see #AN
	 * @model name="an"
	 * @generated
	 * @ordered
	 */
	public static final int AN_VALUE = 8;

	/**
	 * The '<em><b>Ao</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Angola.
	 * <!-- end-model-doc -->
	 * @see #AO
	 * @model name="ao"
	 * @generated
	 * @ordered
	 */
	public static final int AO_VALUE = 9;

	/**
	 * The '<em><b>Aq</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Antarctica.
	 * <!-- end-model-doc -->
	 * @see #AQ
	 * @model name="aq"
	 * @generated
	 * @ordered
	 */
	public static final int AQ_VALUE = 10;

	/**
	 * The '<em><b>Ar</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Argentina.
	 * <!-- end-model-doc -->
	 * @see #AR
	 * @model name="ar"
	 * @generated
	 * @ordered
	 */
	public static final int AR_VALUE = 11;

	/**
	 * The '<em><b>As</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * American Samoa.
	 * <!-- end-model-doc -->
	 * @see #AS
	 * @model name="as"
	 * @generated
	 * @ordered
	 */
	public static final int AS_VALUE = 12;

	/**
	 * The '<em><b>At</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Austria.
	 * <!-- end-model-doc -->
	 * @see #AT
	 * @model name="at"
	 * @generated
	 * @ordered
	 */
	public static final int AT_VALUE = 13;

	/**
	 * The '<em><b>Au</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Australia.
	 * <!-- end-model-doc -->
	 * @see #AU
	 * @model name="au"
	 * @generated
	 * @ordered
	 */
	public static final int AU_VALUE = 14;

	/**
	 * The '<em><b>Aw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Aruba.
	 * <!-- end-model-doc -->
	 * @see #AW
	 * @model name="aw"
	 * @generated
	 * @ordered
	 */
	public static final int AW_VALUE = 15;

	/**
	 * The '<em><b>Az</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Azerbaijan.
	 * <!-- end-model-doc -->
	 * @see #AZ
	 * @model name="az"
	 * @generated
	 * @ordered
	 */
	public static final int AZ_VALUE = 16;

	/**
	 * The '<em><b>Ax</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Aland Islands.
	 * <!-- end-model-doc -->
	 * @see #AX
	 * @model name="ax"
	 * @generated
	 * @ordered
	 */
	public static final int AX_VALUE = 17;

	/**
	 * The '<em><b>Ba</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bosnia and Herzegovina.
	 * <!-- end-model-doc -->
	 * @see #BA
	 * @model name="ba"
	 * @generated
	 * @ordered
	 */
	public static final int BA_VALUE = 18;

	/**
	 * The '<em><b>Bb</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Barbados.
	 * <!-- end-model-doc -->
	 * @see #BB
	 * @model name="bb"
	 * @generated
	 * @ordered
	 */
	public static final int BB_VALUE = 19;

	/**
	 * The '<em><b>Bd</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bangladesh.
	 * <!-- end-model-doc -->
	 * @see #BD
	 * @model name="bd"
	 * @generated
	 * @ordered
	 */
	public static final int BD_VALUE = 20;

	/**
	 * The '<em><b>Be</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Belgium.
	 * <!-- end-model-doc -->
	 * @see #BE
	 * @model name="be"
	 * @generated
	 * @ordered
	 */
	public static final int BE_VALUE = 21;

	/**
	 * The '<em><b>Bf</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Burkina Faso.
	 * <!-- end-model-doc -->
	 * @see #BF
	 * @model name="bf"
	 * @generated
	 * @ordered
	 */
	public static final int BF_VALUE = 22;

	/**
	 * The '<em><b>Bg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bulgaria.
	 * <!-- end-model-doc -->
	 * @see #BG
	 * @model name="bg"
	 * @generated
	 * @ordered
	 */
	public static final int BG_VALUE = 23;

	/**
	 * The '<em><b>Bh</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bahrain.
	 * <!-- end-model-doc -->
	 * @see #BH
	 * @model name="bh"
	 * @generated
	 * @ordered
	 */
	public static final int BH_VALUE = 24;

	/**
	 * The '<em><b>Bi</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Burundi.
	 * <!-- end-model-doc -->
	 * @see #BI
	 * @model name="bi"
	 * @generated
	 * @ordered
	 */
	public static final int BI_VALUE = 25;

	/**
	 * The '<em><b>Bj</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Benin.
	 * <!-- end-model-doc -->
	 * @see #BJ
	 * @model name="bj"
	 * @generated
	 * @ordered
	 */
	public static final int BJ_VALUE = 26;

	/**
	 * The '<em><b>Bm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bermuda.
	 * <!-- end-model-doc -->
	 * @see #BM
	 * @model name="bm"
	 * @generated
	 * @ordered
	 */
	public static final int BM_VALUE = 27;

	/**
	 * The '<em><b>Bn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Brunei Darussalam.
	 * <!-- end-model-doc -->
	 * @see #BN
	 * @model name="bn"
	 * @generated
	 * @ordered
	 */
	public static final int BN_VALUE = 28;

	/**
	 * The '<em><b>Bo</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bolivia.
	 * <!-- end-model-doc -->
	 * @see #BO
	 * @model name="bo"
	 * @generated
	 * @ordered
	 */
	public static final int BO_VALUE = 29;

	/**
	 * The '<em><b>Br</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Brazil.
	 * <!-- end-model-doc -->
	 * @see #BR
	 * @model name="br"
	 * @generated
	 * @ordered
	 */
	public static final int BR_VALUE = 30;

	/**
	 * The '<em><b>Bs</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bahamas.
	 * <!-- end-model-doc -->
	 * @see #BS
	 * @model name="bs"
	 * @generated
	 * @ordered
	 */
	public static final int BS_VALUE = 31;

	/**
	 * The '<em><b>Bt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bhutan.
	 * <!-- end-model-doc -->
	 * @see #BT
	 * @model name="bt"
	 * @generated
	 * @ordered
	 */
	public static final int BT_VALUE = 32;

	/**
	 * The '<em><b>Bv</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bouvet Island.
	 * <!-- end-model-doc -->
	 * @see #BV
	 * @model name="bv"
	 * @generated
	 * @ordered
	 */
	public static final int BV_VALUE = 33;

	/**
	 * The '<em><b>Bw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Botswana.
	 * <!-- end-model-doc -->
	 * @see #BW
	 * @model name="bw"
	 * @generated
	 * @ordered
	 */
	public static final int BW_VALUE = 34;

	/**
	 * The '<em><b>By</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Belarus.
	 * <!-- end-model-doc -->
	 * @see #BY
	 * @model name="by"
	 * @generated
	 * @ordered
	 */
	public static final int BY_VALUE = 35;

	/**
	 * The '<em><b>Bz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Belize.
	 * <!-- end-model-doc -->
	 * @see #BZ
	 * @model name="bz"
	 * @generated
	 * @ordered
	 */
	public static final int BZ_VALUE = 36;

	/**
	 * The '<em><b>Ca</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Canada.
	 * <!-- end-model-doc -->
	 * @see #CA
	 * @model name="ca"
	 * @generated
	 * @ordered
	 */
	public static final int CA_VALUE = 37;

	/**
	 * The '<em><b>Cc</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cocos (Keeling) Islands.
	 * <!-- end-model-doc -->
	 * @see #CC
	 * @model name="cc"
	 * @generated
	 * @ordered
	 */
	public static final int CC_VALUE = 38;

	/**
	 * The '<em><b>Cd</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Congo, The Democratic Republic of the.
	 * <!-- end-model-doc -->
	 * @see #CD
	 * @model name="cd"
	 * @generated
	 * @ordered
	 */
	public static final int CD_VALUE = 39;

	/**
	 * The '<em><b>Cf</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Central African Republic.
	 * <!-- end-model-doc -->
	 * @see #CF
	 * @model name="cf"
	 * @generated
	 * @ordered
	 */
	public static final int CF_VALUE = 40;

	/**
	 * The '<em><b>Cg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Congo, Republic of.
	 * <!-- end-model-doc -->
	 * @see #CG
	 * @model name="cg"
	 * @generated
	 * @ordered
	 */
	public static final int CG_VALUE = 41;

	/**
	 * The '<em><b>Ch</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Switzerland.
	 * <!-- end-model-doc -->
	 * @see #CH
	 * @model name="ch"
	 * @generated
	 * @ordered
	 */
	public static final int CH_VALUE = 42;

	/**
	 * The '<em><b>Ci</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cote d'Ivoire.
	 * <!-- end-model-doc -->
	 * @see #CI
	 * @model name="ci"
	 * @generated
	 * @ordered
	 */
	public static final int CI_VALUE = 43;

	/**
	 * The '<em><b>Ck</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cook Islands.
	 * <!-- end-model-doc -->
	 * @see #CK
	 * @model name="ck"
	 * @generated
	 * @ordered
	 */
	public static final int CK_VALUE = 44;

	/**
	 * The '<em><b>Cl</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Chile.
	 * <!-- end-model-doc -->
	 * @see #CL
	 * @model name="cl"
	 * @generated
	 * @ordered
	 */
	public static final int CL_VALUE = 45;

	/**
	 * The '<em><b>Cm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cameroon.
	 * <!-- end-model-doc -->
	 * @see #CM
	 * @model name="cm"
	 * @generated
	 * @ordered
	 */
	public static final int CM_VALUE = 46;

	/**
	 * The '<em><b>Cn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * China.
	 * <!-- end-model-doc -->
	 * @see #CN
	 * @model name="cn"
	 * @generated
	 * @ordered
	 */
	public static final int CN_VALUE = 47;

	/**
	 * The '<em><b>Co</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Colombia.
	 * <!-- end-model-doc -->
	 * @see #CO
	 * @model name="co"
	 * @generated
	 * @ordered
	 */
	public static final int CO_VALUE = 48;

	/**
	 * The '<em><b>Cr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Costa Rica.
	 * <!-- end-model-doc -->
	 * @see #CR
	 * @model name="cr"
	 * @generated
	 * @ordered
	 */
	public static final int CR_VALUE = 49;

	/**
	 * The '<em><b>Cs</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Serbia and Montenegro.
	 * <!-- end-model-doc -->
	 * @see #CS
	 * @model name="cs"
	 * @generated
	 * @ordered
	 */
	public static final int CS_VALUE = 50;

	/**
	 * The '<em><b>Cu</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cuba.
	 * <!-- end-model-doc -->
	 * @see #CU
	 * @model name="cu"
	 * @generated
	 * @ordered
	 */
	public static final int CU_VALUE = 51;

	/**
	 * The '<em><b>Cv</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cape Verde.
	 * <!-- end-model-doc -->
	 * @see #CV
	 * @model name="cv"
	 * @generated
	 * @ordered
	 */
	public static final int CV_VALUE = 52;

	/**
	 * The '<em><b>Cx</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Christmas Island.
	 * <!-- end-model-doc -->
	 * @see #CX
	 * @model name="cx"
	 * @generated
	 * @ordered
	 */
	public static final int CX_VALUE = 53;

	/**
	 * The '<em><b>Cy</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cyprus.
	 * <!-- end-model-doc -->
	 * @see #CY
	 * @model name="cy"
	 * @generated
	 * @ordered
	 */
	public static final int CY_VALUE = 54;

	/**
	 * The '<em><b>Cz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Czech Republic.
	 * <!-- end-model-doc -->
	 * @see #CZ
	 * @model name="cz"
	 * @generated
	 * @ordered
	 */
	public static final int CZ_VALUE = 55;

	/**
	 * The '<em><b>De</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Germany.
	 * <!-- end-model-doc -->
	 * @see #DE
	 * @model name="de"
	 * @generated
	 * @ordered
	 */
	public static final int DE_VALUE = 56;

	/**
	 * The '<em><b>Dj</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Djibouti.
	 * <!-- end-model-doc -->
	 * @see #DJ
	 * @model name="dj"
	 * @generated
	 * @ordered
	 */
	public static final int DJ_VALUE = 57;

	/**
	 * The '<em><b>Dk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Denmark.
	 * <!-- end-model-doc -->
	 * @see #DK
	 * @model name="dk"
	 * @generated
	 * @ordered
	 */
	public static final int DK_VALUE = 58;

	/**
	 * The '<em><b>Dm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Dominica.
	 * <!-- end-model-doc -->
	 * @see #DM
	 * @model name="dm"
	 * @generated
	 * @ordered
	 */
	public static final int DM_VALUE = 59;

	/**
	 * The '<em><b>Do</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Dominican Republic.
	 * <!-- end-model-doc -->
	 * @see #DO
	 * @model name="do"
	 * @generated
	 * @ordered
	 */
	public static final int DO_VALUE = 60;

	/**
	 * The '<em><b>Dz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Algeria.
	 * <!-- end-model-doc -->
	 * @see #DZ
	 * @model name="dz"
	 * @generated
	 * @ordered
	 */
	public static final int DZ_VALUE = 61;

	/**
	 * The '<em><b>Ec</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ecuador.
	 * <!-- end-model-doc -->
	 * @see #EC
	 * @model name="ec"
	 * @generated
	 * @ordered
	 */
	public static final int EC_VALUE = 62;

	/**
	 * The '<em><b>Ee</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Estonia.
	 * <!-- end-model-doc -->
	 * @see #EE
	 * @model name="ee"
	 * @generated
	 * @ordered
	 */
	public static final int EE_VALUE = 63;

	/**
	 * The '<em><b>Eg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Egypt.
	 * <!-- end-model-doc -->
	 * @see #EG
	 * @model name="eg"
	 * @generated
	 * @ordered
	 */
	public static final int EG_VALUE = 64;

	/**
	 * The '<em><b>Eh</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Western Sahara.
	 * <!-- end-model-doc -->
	 * @see #EH
	 * @model name="eh"
	 * @generated
	 * @ordered
	 */
	public static final int EH_VALUE = 65;

	/**
	 * The '<em><b>Er</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Eritrea.
	 * <!-- end-model-doc -->
	 * @see #ER
	 * @model name="er"
	 * @generated
	 * @ordered
	 */
	public static final int ER_VALUE = 66;

	/**
	 * The '<em><b>Es</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Spain.
	 * <!-- end-model-doc -->
	 * @see #ES
	 * @model name="es"
	 * @generated
	 * @ordered
	 */
	public static final int ES_VALUE = 67;

	/**
	 * The '<em><b>Et</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ethiopia.
	 * <!-- end-model-doc -->
	 * @see #ET
	 * @model name="et"
	 * @generated
	 * @ordered
	 */
	public static final int ET_VALUE = 68;

	/**
	 * The '<em><b>Eu</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * European Union.
	 * <!-- end-model-doc -->
	 * @see #EU
	 * @model name="eu"
	 * @generated
	 * @ordered
	 */
	public static final int EU_VALUE = 69;

	/**
	 * The '<em><b>Fi</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Finland.
	 * <!-- end-model-doc -->
	 * @see #FI
	 * @model name="fi"
	 * @generated
	 * @ordered
	 */
	public static final int FI_VALUE = 70;

	/**
	 * The '<em><b>Fj</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Fiji.
	 * <!-- end-model-doc -->
	 * @see #FJ
	 * @model name="fj"
	 * @generated
	 * @ordered
	 */
	public static final int FJ_VALUE = 71;

	/**
	 * The '<em><b>Fk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Falkland Islands (Malvinas)
	 * <!-- end-model-doc -->
	 * @see #FK
	 * @model name="fk"
	 * @generated
	 * @ordered
	 */
	public static final int FK_VALUE = 72;

	/**
	 * The '<em><b>Fm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Micronesia, Federal State of.
	 * <!-- end-model-doc -->
	 * @see #FM
	 * @model name="fm"
	 * @generated
	 * @ordered
	 */
	public static final int FM_VALUE = 73;

	/**
	 * The '<em><b>Fo</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Faroe Islands.
	 * <!-- end-model-doc -->
	 * @see #FO
	 * @model name="fo"
	 * @generated
	 * @ordered
	 */
	public static final int FO_VALUE = 74;

	/**
	 * The '<em><b>Fr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * France.
	 * <!-- end-model-doc -->
	 * @see #FR
	 * @model name="fr"
	 * @generated
	 * @ordered
	 */
	public static final int FR_VALUE = 75;

	/**
	 * The '<em><b>Ga</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Gabon.
	 * <!-- end-model-doc -->
	 * @see #GA
	 * @model name="ga"
	 * @generated
	 * @ordered
	 */
	public static final int GA_VALUE = 76;

	/**
	 * The '<em><b>Gb</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United Kingdom.
	 * <!-- end-model-doc -->
	 * @see #GB
	 * @model name="gb"
	 * @generated
	 * @ordered
	 */
	public static final int GB_VALUE = 77;

	/**
	 * The '<em><b>Gd</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Grenada.
	 * <!-- end-model-doc -->
	 * @see #GD
	 * @model name="gd"
	 * @generated
	 * @ordered
	 */
	public static final int GD_VALUE = 78;

	/**
	 * The '<em><b>Ge</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Georgia.
	 * <!-- end-model-doc -->
	 * @see #GE
	 * @model name="ge"
	 * @generated
	 * @ordered
	 */
	public static final int GE_VALUE = 79;

	/**
	 * The '<em><b>Gf</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * French Guiana.
	 * <!-- end-model-doc -->
	 * @see #GF
	 * @model name="gf"
	 * @generated
	 * @ordered
	 */
	public static final int GF_VALUE = 80;

	/**
	 * The '<em><b>Gg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guernsey.
	 * <!-- end-model-doc -->
	 * @see #GG
	 * @model name="gg"
	 * @generated
	 * @ordered
	 */
	public static final int GG_VALUE = 81;

	/**
	 * The '<em><b>Gh</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ghana.
	 * <!-- end-model-doc -->
	 * @see #GH
	 * @model name="gh"
	 * @generated
	 * @ordered
	 */
	public static final int GH_VALUE = 82;

	/**
	 * The '<em><b>Gi</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Gibraltar.
	 * <!-- end-model-doc -->
	 * @see #GI
	 * @model name="gi"
	 * @generated
	 * @ordered
	 */
	public static final int GI_VALUE = 83;

	/**
	 * The '<em><b>Gl</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Greenland.
	 * <!-- end-model-doc -->
	 * @see #GL
	 * @model name="gl"
	 * @generated
	 * @ordered
	 */
	public static final int GL_VALUE = 84;

	/**
	 * The '<em><b>Gm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Gambia.
	 * <!-- end-model-doc -->
	 * @see #GM
	 * @model name="gm"
	 * @generated
	 * @ordered
	 */
	public static final int GM_VALUE = 85;

	/**
	 * The '<em><b>Gn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guinea.
	 * <!-- end-model-doc -->
	 * @see #GN
	 * @model name="gn"
	 * @generated
	 * @ordered
	 */
	public static final int GN_VALUE = 86;

	/**
	 * The '<em><b>Gp</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guadeloupe.
	 * <!-- end-model-doc -->
	 * @see #GP
	 * @model name="gp"
	 * @generated
	 * @ordered
	 */
	public static final int GP_VALUE = 87;

	/**
	 * The '<em><b>Gq</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Equatorial Guinea.
	 * <!-- end-model-doc -->
	 * @see #GQ
	 * @model name="gq"
	 * @generated
	 * @ordered
	 */
	public static final int GQ_VALUE = 88;

	/**
	 * The '<em><b>Gr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Greece.
	 * <!-- end-model-doc -->
	 * @see #GR
	 * @model name="gr"
	 * @generated
	 * @ordered
	 */
	public static final int GR_VALUE = 89;

	/**
	 * The '<em><b>Gs</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * South Georgia and the South Sandwich Islands.
	 * <!-- end-model-doc -->
	 * @see #GS
	 * @model name="gs"
	 * @generated
	 * @ordered
	 */
	public static final int GS_VALUE = 90;

	/**
	 * The '<em><b>Gt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guatemala.
	 * <!-- end-model-doc -->
	 * @see #GT
	 * @model name="gt"
	 * @generated
	 * @ordered
	 */
	public static final int GT_VALUE = 91;

	/**
	 * The '<em><b>Gu</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guam.
	 * <!-- end-model-doc -->
	 * @see #GU
	 * @model name="gu"
	 * @generated
	 * @ordered
	 */
	public static final int GU_VALUE = 92;

	/**
	 * The '<em><b>Gw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guinea-Bissau.
	 * <!-- end-model-doc -->
	 * @see #GW
	 * @model name="gw"
	 * @generated
	 * @ordered
	 */
	public static final int GW_VALUE = 93;

	/**
	 * The '<em><b>Gy</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Guyana.
	 * <!-- end-model-doc -->
	 * @see #GY
	 * @model name="gy"
	 * @generated
	 * @ordered
	 */
	public static final int GY_VALUE = 94;

	/**
	 * The '<em><b>Hk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Hong Kong.
	 * <!-- end-model-doc -->
	 * @see #HK
	 * @model name="hk"
	 * @generated
	 * @ordered
	 */
	public static final int HK_VALUE = 95;

	/**
	 * The '<em><b>Hm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Heard and McDonald Islands.
	 * <!-- end-model-doc -->
	 * @see #HM
	 * @model name="hm"
	 * @generated
	 * @ordered
	 */
	public static final int HM_VALUE = 96;

	/**
	 * The '<em><b>Hn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Honduras.
	 * <!-- end-model-doc -->
	 * @see #HN
	 * @model name="hn"
	 * @generated
	 * @ordered
	 */
	public static final int HN_VALUE = 97;

	/**
	 * The '<em><b>Hr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Croatia/Hrvatska.
	 * <!-- end-model-doc -->
	 * @see #HR
	 * @model name="hr"
	 * @generated
	 * @ordered
	 */
	public static final int HR_VALUE = 98;

	/**
	 * The '<em><b>Ht</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Haiti.
	 * <!-- end-model-doc -->
	 * @see #HT
	 * @model name="ht"
	 * @generated
	 * @ordered
	 */
	public static final int HT_VALUE = 99;

	/**
	 * The '<em><b>Hu</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Hungary.
	 * <!-- end-model-doc -->
	 * @see #HU
	 * @model name="hu"
	 * @generated
	 * @ordered
	 */
	public static final int HU_VALUE = 100;

	/**
	 * The '<em><b>Id</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Indonesia.
	 * <!-- end-model-doc -->
	 * @see #ID
	 * @model name="id"
	 * @generated
	 * @ordered
	 */
	public static final int ID_VALUE = 101;

	/**
	 * The '<em><b>Ie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ireland.
	 * <!-- end-model-doc -->
	 * @see #IE
	 * @model name="ie"
	 * @generated
	 * @ordered
	 */
	public static final int IE_VALUE = 102;

	/**
	 * The '<em><b>Il</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Israel.
	 * <!-- end-model-doc -->
	 * @see #IL
	 * @model name="il"
	 * @generated
	 * @ordered
	 */
	public static final int IL_VALUE = 103;

	/**
	 * The '<em><b>Im</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Isle of Man.
	 * <!-- end-model-doc -->
	 * @see #IM
	 * @model name="im"
	 * @generated
	 * @ordered
	 */
	public static final int IM_VALUE = 104;

	/**
	 * The '<em><b>In</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * India.
	 * <!-- end-model-doc -->
	 * @see #IN
	 * @model name="in"
	 * @generated
	 * @ordered
	 */
	public static final int IN_VALUE = 105;

	/**
	 * The '<em><b>Io</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * British Indian Ocean Territory.
	 * <!-- end-model-doc -->
	 * @see #IO
	 * @model name="io"
	 * @generated
	 * @ordered
	 */
	public static final int IO_VALUE = 106;

	/**
	 * The '<em><b>Iq</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Iraq
	 * <!-- end-model-doc -->
	 * @see #IQ
	 * @model name="iq"
	 * @generated
	 * @ordered
	 */
	public static final int IQ_VALUE = 107;

	/**
	 * The '<em><b>Ir</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Iran, Islamic Republic of.
	 * <!-- end-model-doc -->
	 * @see #IR
	 * @model name="ir"
	 * @generated
	 * @ordered
	 */
	public static final int IR_VALUE = 108;

	/**
	 * The '<em><b>Is</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Iceland.
	 * <!-- end-model-doc -->
	 * @see #IS
	 * @model name="is"
	 * @generated
	 * @ordered
	 */
	public static final int IS_VALUE = 109;

	/**
	 * The '<em><b>It</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Italy.
	 * <!-- end-model-doc -->
	 * @see #IT
	 * @model name="it"
	 * @generated
	 * @ordered
	 */
	public static final int IT_VALUE = 110;

	/**
	 * The '<em><b>Je</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Jersey.
	 * <!-- end-model-doc -->
	 * @see #JE
	 * @model name="je"
	 * @generated
	 * @ordered
	 */
	public static final int JE_VALUE = 111;

	/**
	 * The '<em><b>Jm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Jamaica.
	 * <!-- end-model-doc -->
	 * @see #JM
	 * @model name="jm"
	 * @generated
	 * @ordered
	 */
	public static final int JM_VALUE = 112;

	/**
	 * The '<em><b>Jo</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Jordan.
	 * <!-- end-model-doc -->
	 * @see #JO
	 * @model name="jo"
	 * @generated
	 * @ordered
	 */
	public static final int JO_VALUE = 113;

	/**
	 * The '<em><b>Jp</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Japan.
	 * <!-- end-model-doc -->
	 * @see #JP
	 * @model name="jp"
	 * @generated
	 * @ordered
	 */
	public static final int JP_VALUE = 114;

	/**
	 * The '<em><b>Ke</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kenya.
	 * <!-- end-model-doc -->
	 * @see #KE
	 * @model name="ke"
	 * @generated
	 * @ordered
	 */
	public static final int KE_VALUE = 115;

	/**
	 * The '<em><b>Kg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kyrgyzstan.
	 * <!-- end-model-doc -->
	 * @see #KG
	 * @model name="kg"
	 * @generated
	 * @ordered
	 */
	public static final int KG_VALUE = 116;

	/**
	 * The '<em><b>Kh</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cambodia.
	 * <!-- end-model-doc -->
	 * @see #KH
	 * @model name="kh"
	 * @generated
	 * @ordered
	 */
	public static final int KH_VALUE = 117;

	/**
	 * The '<em><b>Ki</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kiribati.
	 * <!-- end-model-doc -->
	 * @see #KI
	 * @model name="ki"
	 * @generated
	 * @ordered
	 */
	public static final int KI_VALUE = 118;

	/**
	 * The '<em><b>Km</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Comoros.
	 * <!-- end-model-doc -->
	 * @see #KM
	 * @model name="km"
	 * @generated
	 * @ordered
	 */
	public static final int KM_VALUE = 119;

	/**
	 * The '<em><b>Kn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Kitts and Nevis.
	 * <!-- end-model-doc -->
	 * @see #KN
	 * @model name="kn"
	 * @generated
	 * @ordered
	 */
	public static final int KN_VALUE = 120;

	/**
	 * The '<em><b>Kp</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Korea, Democratic People's Republic.
	 * <!-- end-model-doc -->
	 * @see #KP
	 * @model name="kp"
	 * @generated
	 * @ordered
	 */
	public static final int KP_VALUE = 121;

	/**
	 * The '<em><b>Kr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Korea, Republic of.
	 * <!-- end-model-doc -->
	 * @see #KR
	 * @model name="kr"
	 * @generated
	 * @ordered
	 */
	public static final int KR_VALUE = 122;

	/**
	 * The '<em><b>Kw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kuwait.
	 * <!-- end-model-doc -->
	 * @see #KW
	 * @model name="kw"
	 * @generated
	 * @ordered
	 */
	public static final int KW_VALUE = 123;

	/**
	 * The '<em><b>Ky</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cayman Islands.
	 * <!-- end-model-doc -->
	 * @see #KY
	 * @model name="ky"
	 * @generated
	 * @ordered
	 */
	public static final int KY_VALUE = 124;

	/**
	 * The '<em><b>Kz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kazakhstan.
	 * <!-- end-model-doc -->
	 * @see #KZ
	 * @model name="kz"
	 * @generated
	 * @ordered
	 */
	public static final int KZ_VALUE = 125;

	/**
	 * The '<em><b>La</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lao People's Democratic Republic.
	 * <!-- end-model-doc -->
	 * @see #LA
	 * @model name="la"
	 * @generated
	 * @ordered
	 */
	public static final int LA_VALUE = 126;

	/**
	 * The '<em><b>Lb</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lebanon.
	 * <!-- end-model-doc -->
	 * @see #LB
	 * @model name="lb"
	 * @generated
	 * @ordered
	 */
	public static final int LB_VALUE = 127;

	/**
	 * The '<em><b>Lc</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Lucia.
	 * <!-- end-model-doc -->
	 * @see #LC
	 * @model name="lc"
	 * @generated
	 * @ordered
	 */
	public static final int LC_VALUE = 128;

	/**
	 * The '<em><b>Li</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Liechtenstein.
	 * <!-- end-model-doc -->
	 * @see #LI
	 * @model name="li"
	 * @generated
	 * @ordered
	 */
	public static final int LI_VALUE = 129;

	/**
	 * The '<em><b>Lk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sri Lanka.
	 * <!-- end-model-doc -->
	 * @see #LK
	 * @model name="lk"
	 * @generated
	 * @ordered
	 */
	public static final int LK_VALUE = 130;

	/**
	 * The '<em><b>Lr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Liberia.
	 * <!-- end-model-doc -->
	 * @see #LR
	 * @model name="lr"
	 * @generated
	 * @ordered
	 */
	public static final int LR_VALUE = 131;

	/**
	 * The '<em><b>Ls</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lesotho.
	 * <!-- end-model-doc -->
	 * @see #LS
	 * @model name="ls"
	 * @generated
	 * @ordered
	 */
	public static final int LS_VALUE = 132;

	/**
	 * The '<em><b>Lt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lithuania.
	 * <!-- end-model-doc -->
	 * @see #LT
	 * @model name="lt"
	 * @generated
	 * @ordered
	 */
	public static final int LT_VALUE = 133;

	/**
	 * The '<em><b>Lu</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Luxembourg.
	 * <!-- end-model-doc -->
	 * @see #LU
	 * @model name="lu"
	 * @generated
	 * @ordered
	 */
	public static final int LU_VALUE = 134;

	/**
	 * The '<em><b>Lv</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Latvia.
	 * <!-- end-model-doc -->
	 * @see #LV
	 * @model name="lv"
	 * @generated
	 * @ordered
	 */
	public static final int LV_VALUE = 135;

	/**
	 * The '<em><b>Ly</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Libyan Arab Jamahiriya.
	 * <!-- end-model-doc -->
	 * @see #LY
	 * @model name="ly"
	 * @generated
	 * @ordered
	 */
	public static final int LY_VALUE = 136;

	/**
	 * The '<em><b>Ma</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Morocco.
	 * <!-- end-model-doc -->
	 * @see #MA
	 * @model name="ma"
	 * @generated
	 * @ordered
	 */
	public static final int MA_VALUE = 137;

	/**
	 * The '<em><b>Mc</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Monaco.
	 * <!-- end-model-doc -->
	 * @see #MC
	 * @model name="mc"
	 * @generated
	 * @ordered
	 */
	public static final int MC_VALUE = 138;

	/**
	 * The '<em><b>Md</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Moldova, Republic of.
	 * <!-- end-model-doc -->
	 * @see #MD
	 * @model name="md"
	 * @generated
	 * @ordered
	 */
	public static final int MD_VALUE = 139;

	/**
	 * The '<em><b>Mg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Madagascar.
	 * <!-- end-model-doc -->
	 * @see #MG
	 * @model name="mg"
	 * @generated
	 * @ordered
	 */
	public static final int MG_VALUE = 140;

	/**
	 * The '<em><b>Mh</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Marshall Islands.
	 * <!-- end-model-doc -->
	 * @see #MH
	 * @model name="mh"
	 * @generated
	 * @ordered
	 */
	public static final int MH_VALUE = 141;

	/**
	 * The '<em><b>Mk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Macedonia, The Former Yugoslav Republic of.
	 * <!-- end-model-doc -->
	 * @see #MK
	 * @model name="mk"
	 * @generated
	 * @ordered
	 */
	public static final int MK_VALUE = 142;

	/**
	 * The '<em><b>Ml</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mali.
	 * <!-- end-model-doc -->
	 * @see #ML
	 * @model name="ml"
	 * @generated
	 * @ordered
	 */
	public static final int ML_VALUE = 143;

	/**
	 * The '<em><b>Mm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Myanmar.
	 * <!-- end-model-doc -->
	 * @see #MM
	 * @model name="mm"
	 * @generated
	 * @ordered
	 */
	public static final int MM_VALUE = 144;

	/**
	 * The '<em><b>Mn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mongolia.
	 * <!-- end-model-doc -->
	 * @see #MN
	 * @model name="mn"
	 * @generated
	 * @ordered
	 */
	public static final int MN_VALUE = 145;

	/**
	 * The '<em><b>Mo</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Macau.
	 * <!-- end-model-doc -->
	 * @see #MO
	 * @model name="mo"
	 * @generated
	 * @ordered
	 */
	public static final int MO_VALUE = 146;

	/**
	 * The '<em><b>Mp</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Northern Mariana Islands.
	 * <!-- end-model-doc -->
	 * @see #MP
	 * @model name="mp"
	 * @generated
	 * @ordered
	 */
	public static final int MP_VALUE = 147;

	/**
	 * The '<em><b>Mq</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Martinique.
	 * <!-- end-model-doc -->
	 * @see #MQ
	 * @model name="mq"
	 * @generated
	 * @ordered
	 */
	public static final int MQ_VALUE = 148;

	/**
	 * The '<em><b>Mr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mauritania.
	 * <!-- end-model-doc -->
	 * @see #MR
	 * @model name="mr"
	 * @generated
	 * @ordered
	 */
	public static final int MR_VALUE = 149;

	/**
	 * The '<em><b>Ms</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Montserrat.
	 * <!-- end-model-doc -->
	 * @see #MS
	 * @model name="ms"
	 * @generated
	 * @ordered
	 */
	public static final int MS_VALUE = 150;

	/**
	 * The '<em><b>Mt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Malta.
	 * <!-- end-model-doc -->
	 * @see #MT
	 * @model name="mt"
	 * @generated
	 * @ordered
	 */
	public static final int MT_VALUE = 151;

	/**
	 * The '<em><b>Mu</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mauritius.
	 * <!-- end-model-doc -->
	 * @see #MU
	 * @model name="mu"
	 * @generated
	 * @ordered
	 */
	public static final int MU_VALUE = 152;

	/**
	 * The '<em><b>Mv</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Maldives.
	 * <!-- end-model-doc -->
	 * @see #MV
	 * @model name="mv"
	 * @generated
	 * @ordered
	 */
	public static final int MV_VALUE = 153;

	/**
	 * The '<em><b>Mw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Malawi.
	 * <!-- end-model-doc -->
	 * @see #MW
	 * @model name="mw"
	 * @generated
	 * @ordered
	 */
	public static final int MW_VALUE = 154;

	/**
	 * The '<em><b>Mx</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mexico.
	 * <!-- end-model-doc -->
	 * @see #MX
	 * @model name="mx"
	 * @generated
	 * @ordered
	 */
	public static final int MX_VALUE = 155;

	/**
	 * The '<em><b>My</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Malaysia.
	 * <!-- end-model-doc -->
	 * @see #MY
	 * @model name="my"
	 * @generated
	 * @ordered
	 */
	public static final int MY_VALUE = 156;

	/**
	 * The '<em><b>Mz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mozambique.
	 * <!-- end-model-doc -->
	 * @see #MZ
	 * @model name="mz"
	 * @generated
	 * @ordered
	 */
	public static final int MZ_VALUE = 157;

	/**
	 * The '<em><b>Na</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Namibia.
	 * <!-- end-model-doc -->
	 * @see #NA
	 * @model name="na"
	 * @generated
	 * @ordered
	 */
	public static final int NA_VALUE = 158;

	/**
	 * The '<em><b>Nc</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * New Caledonia.
	 * <!-- end-model-doc -->
	 * @see #NC
	 * @model name="nc"
	 * @generated
	 * @ordered
	 */
	public static final int NC_VALUE = 159;

	/**
	 * The '<em><b>Ne</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Niger.
	 * <!-- end-model-doc -->
	 * @see #NE
	 * @model name="ne"
	 * @generated
	 * @ordered
	 */
	public static final int NE_VALUE = 160;

	/**
	 * The '<em><b>Nf</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Norfolk Island.
	 * <!-- end-model-doc -->
	 * @see #NF
	 * @model name="nf"
	 * @generated
	 * @ordered
	 */
	public static final int NF_VALUE = 161;

	/**
	 * The '<em><b>Ng</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Nigeria.
	 * <!-- end-model-doc -->
	 * @see #NG
	 * @model name="ng"
	 * @generated
	 * @ordered
	 */
	public static final int NG_VALUE = 162;

	/**
	 * The '<em><b>Ni</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Nicaragua.
	 * <!-- end-model-doc -->
	 * @see #NI
	 * @model name="ni"
	 * @generated
	 * @ordered
	 */
	public static final int NI_VALUE = 163;

	/**
	 * The '<em><b>Nl</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Netherlands.
	 * <!-- end-model-doc -->
	 * @see #NL
	 * @model name="nl"
	 * @generated
	 * @ordered
	 */
	public static final int NL_VALUE = 164;

	/**
	 * The '<em><b>No</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Norway.
	 * <!-- end-model-doc -->
	 * @see #NO
	 * @model name="no"
	 * @generated
	 * @ordered
	 */
	public static final int NO_VALUE = 165;

	/**
	 * The '<em><b>Np</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Nepal.
	 * <!-- end-model-doc -->
	 * @see #NP
	 * @model name="np"
	 * @generated
	 * @ordered
	 */
	public static final int NP_VALUE = 166;

	/**
	 * The '<em><b>Nr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Nauru.
	 * <!-- end-model-doc -->
	 * @see #NR
	 * @model name="nr"
	 * @generated
	 * @ordered
	 */
	public static final int NR_VALUE = 167;

	/**
	 * The '<em><b>Nu</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Niue.
	 * <!-- end-model-doc -->
	 * @see #NU
	 * @model name="nu"
	 * @generated
	 * @ordered
	 */
	public static final int NU_VALUE = 168;

	/**
	 * The '<em><b>Nz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * New Zealand.
	 * <!-- end-model-doc -->
	 * @see #NZ
	 * @model name="nz"
	 * @generated
	 * @ordered
	 */
	public static final int NZ_VALUE = 169;

	/**
	 * The '<em><b>Om</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Oman.
	 * <!-- end-model-doc -->
	 * @see #OM
	 * @model name="om"
	 * @generated
	 * @ordered
	 */
	public static final int OM_VALUE = 170;

	/**
	 * The '<em><b>Pa</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Panama.
	 * <!-- end-model-doc -->
	 * @see #PA
	 * @model name="pa"
	 * @generated
	 * @ordered
	 */
	public static final int PA_VALUE = 171;

	/**
	 * The '<em><b>Pe</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Peru.
	 * <!-- end-model-doc -->
	 * @see #PE
	 * @model name="pe"
	 * @generated
	 * @ordered
	 */
	public static final int PE_VALUE = 172;

	/**
	 * The '<em><b>Pf</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * French Polynesia.
	 * <!-- end-model-doc -->
	 * @see #PF
	 * @model name="pf"
	 * @generated
	 * @ordered
	 */
	public static final int PF_VALUE = 173;

	/**
	 * The '<em><b>Pg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Papua New Guinea.
	 * <!-- end-model-doc -->
	 * @see #PG
	 * @model name="pg"
	 * @generated
	 * @ordered
	 */
	public static final int PG_VALUE = 174;

	/**
	 * The '<em><b>Ph</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Philippines.
	 * <!-- end-model-doc -->
	 * @see #PH
	 * @model name="ph"
	 * @generated
	 * @ordered
	 */
	public static final int PH_VALUE = 175;

	/**
	 * The '<em><b>Pk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Pakistan.
	 * <!-- end-model-doc -->
	 * @see #PK
	 * @model name="pk"
	 * @generated
	 * @ordered
	 */
	public static final int PK_VALUE = 176;

	/**
	 * The '<em><b>Pl</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Poland.
	 * <!-- end-model-doc -->
	 * @see #PL
	 * @model name="pl"
	 * @generated
	 * @ordered
	 */
	public static final int PL_VALUE = 177;

	/**
	 * The '<em><b>Pm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Pierre and Miquelon.
	 * <!-- end-model-doc -->
	 * @see #PM
	 * @model name="pm"
	 * @generated
	 * @ordered
	 */
	public static final int PM_VALUE = 178;

	/**
	 * The '<em><b>Pn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Pitcairn Island.
	 * <!-- end-model-doc -->
	 * @see #PN
	 * @model name="pn"
	 * @generated
	 * @ordered
	 */
	public static final int PN_VALUE = 179;

	/**
	 * The '<em><b>Pr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Puerto Rico.
	 * <!-- end-model-doc -->
	 * @see #PR
	 * @model name="pr"
	 * @generated
	 * @ordered
	 */
	public static final int PR_VALUE = 180;

	/**
	 * The '<em><b>Ps</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Palestinian Territories.
	 * <!-- end-model-doc -->
	 * @see #PS
	 * @model name="ps"
	 * @generated
	 * @ordered
	 */
	public static final int PS_VALUE = 181;

	/**
	 * The '<em><b>Pt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Portugal.
	 * <!-- end-model-doc -->
	 * @see #PT
	 * @model name="pt"
	 * @generated
	 * @ordered
	 */
	public static final int PT_VALUE = 182;

	/**
	 * The '<em><b>Pw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Palau.
	 * <!-- end-model-doc -->
	 * @see #PW
	 * @model name="pw"
	 * @generated
	 * @ordered
	 */
	public static final int PW_VALUE = 183;

	/**
	 * The '<em><b>Py</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Paraguay.
	 * <!-- end-model-doc -->
	 * @see #PY
	 * @model name="py"
	 * @generated
	 * @ordered
	 */
	public static final int PY_VALUE = 184;

	/**
	 * The '<em><b>Qa</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Qatar.
	 * <!-- end-model-doc -->
	 * @see #QA
	 * @model name="qa"
	 * @generated
	 * @ordered
	 */
	public static final int QA_VALUE = 185;

	/**
	 * The '<em><b>Re</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reunion Island.
	 * <!-- end-model-doc -->
	 * @see #RE
	 * @model name="re"
	 * @generated
	 * @ordered
	 */
	public static final int RE_VALUE = 186;

	/**
	 * The '<em><b>Ro</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Romania.
	 * <!-- end-model-doc -->
	 * @see #RO
	 * @model name="ro"
	 * @generated
	 * @ordered
	 */
	public static final int RO_VALUE = 187;

	/**
	 * The '<em><b>Ru</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Russian Federation.
	 * <!-- end-model-doc -->
	 * @see #RU
	 * @model name="ru"
	 * @generated
	 * @ordered
	 */
	public static final int RU_VALUE = 188;

	/**
	 * The '<em><b>Rw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Rwanda.
	 * <!-- end-model-doc -->
	 * @see #RW
	 * @model name="rw"
	 * @generated
	 * @ordered
	 */
	public static final int RW_VALUE = 189;

	/**
	 * The '<em><b>Sa</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saudi Arabia.
	 * <!-- end-model-doc -->
	 * @see #SA
	 * @model name="sa"
	 * @generated
	 * @ordered
	 */
	public static final int SA_VALUE = 190;

	/**
	 * The '<em><b>Sb</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Solomon Islands.
	 * <!-- end-model-doc -->
	 * @see #SB
	 * @model name="sb"
	 * @generated
	 * @ordered
	 */
	public static final int SB_VALUE = 191;

	/**
	 * The '<em><b>Sc</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Seychelles.
	 * <!-- end-model-doc -->
	 * @see #SC
	 * @model name="sc"
	 * @generated
	 * @ordered
	 */
	public static final int SC_VALUE = 192;

	/**
	 * The '<em><b>Sd</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sudan.
	 * <!-- end-model-doc -->
	 * @see #SD
	 * @model name="sd"
	 * @generated
	 * @ordered
	 */
	public static final int SD_VALUE = 193;

	/**
	 * The '<em><b>Se</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sweden.
	 * <!-- end-model-doc -->
	 * @see #SE
	 * @model name="se"
	 * @generated
	 * @ordered
	 */
	public static final int SE_VALUE = 194;

	/**
	 * The '<em><b>Sg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Singapore.
	 * <!-- end-model-doc -->
	 * @see #SG
	 * @model name="sg"
	 * @generated
	 * @ordered
	 */
	public static final int SG_VALUE = 195;

	/**
	 * The '<em><b>Sh</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Helena.
	 * <!-- end-model-doc -->
	 * @see #SH
	 * @model name="sh"
	 * @generated
	 * @ordered
	 */
	public static final int SH_VALUE = 196;

	/**
	 * The '<em><b>Si</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Slovenia.
	 * <!-- end-model-doc -->
	 * @see #SI
	 * @model name="si"
	 * @generated
	 * @ordered
	 */
	public static final int SI_VALUE = 197;

	/**
	 * The '<em><b>Sj</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Svalbard and Jan Mayen Islands.
	 * <!-- end-model-doc -->
	 * @see #SJ
	 * @model name="sj"
	 * @generated
	 * @ordered
	 */
	public static final int SJ_VALUE = 198;

	/**
	 * The '<em><b>Sk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Slovak Republic.
	 * <!-- end-model-doc -->
	 * @see #SK
	 * @model name="sk"
	 * @generated
	 * @ordered
	 */
	public static final int SK_VALUE = 199;

	/**
	 * The '<em><b>Sl</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sierra Leone.
	 * <!-- end-model-doc -->
	 * @see #SL
	 * @model name="sl"
	 * @generated
	 * @ordered
	 */
	public static final int SL_VALUE = 200;

	/**
	 * The '<em><b>Sm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * San Marino.
	 * <!-- end-model-doc -->
	 * @see #SM
	 * @model name="sm"
	 * @generated
	 * @ordered
	 */
	public static final int SM_VALUE = 201;

	/**
	 * The '<em><b>Sn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Senegal.
	 * <!-- end-model-doc -->
	 * @see #SN
	 * @model name="sn"
	 * @generated
	 * @ordered
	 */
	public static final int SN_VALUE = 202;

	/**
	 * The '<em><b>So</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Somalia.
	 * <!-- end-model-doc -->
	 * @see #SO
	 * @model name="so"
	 * @generated
	 * @ordered
	 */
	public static final int SO_VALUE = 203;

	/**
	 * The '<em><b>Sr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Suriname.
	 * <!-- end-model-doc -->
	 * @see #SR
	 * @model name="sr"
	 * @generated
	 * @ordered
	 */
	public static final int SR_VALUE = 204;

	/**
	 * The '<em><b>St</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sao Tome and Principe.
	 * <!-- end-model-doc -->
	 * @see #ST
	 * @model name="st"
	 * @generated
	 * @ordered
	 */
	public static final int ST_VALUE = 205;

	/**
	 * The '<em><b>Sv</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * El Salvador.
	 * <!-- end-model-doc -->
	 * @see #SV
	 * @model name="sv"
	 * @generated
	 * @ordered
	 */
	public static final int SV_VALUE = 206;

	/**
	 * The '<em><b>Sy</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Syrian Arab Republic.
	 * <!-- end-model-doc -->
	 * @see #SY
	 * @model name="sy"
	 * @generated
	 * @ordered
	 */
	public static final int SY_VALUE = 207;

	/**
	 * The '<em><b>Sz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Swaziland.
	 * <!-- end-model-doc -->
	 * @see #SZ
	 * @model name="sz"
	 * @generated
	 * @ordered
	 */
	public static final int SZ_VALUE = 208;

	/**
	 * The '<em><b>Tc</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Turks and Caicos Islands.
	 * <!-- end-model-doc -->
	 * @see #TC
	 * @model name="tc"
	 * @generated
	 * @ordered
	 */
	public static final int TC_VALUE = 209;

	/**
	 * The '<em><b>Td</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Chad.
	 * <!-- end-model-doc -->
	 * @see #TD
	 * @model name="td"
	 * @generated
	 * @ordered
	 */
	public static final int TD_VALUE = 210;

	/**
	 * The '<em><b>Tf</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * French Southern Territories.
	 * <!-- end-model-doc -->
	 * @see #TF
	 * @model name="tf"
	 * @generated
	 * @ordered
	 */
	public static final int TF_VALUE = 211;

	/**
	 * The '<em><b>Tg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Togo.
	 * <!-- end-model-doc -->
	 * @see #TG
	 * @model name="tg"
	 * @generated
	 * @ordered
	 */
	public static final int TG_VALUE = 212;

	/**
	 * The '<em><b>Th</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Thailand.
	 * <!-- end-model-doc -->
	 * @see #TH
	 * @model name="th"
	 * @generated
	 * @ordered
	 */
	public static final int TH_VALUE = 213;

	/**
	 * The '<em><b>Tj</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tajikistan.
	 * <!-- end-model-doc -->
	 * @see #TJ
	 * @model name="tj"
	 * @generated
	 * @ordered
	 */
	public static final int TJ_VALUE = 214;

	/**
	 * The '<em><b>Tk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tokelau.
	 * <!-- end-model-doc -->
	 * @see #TK
	 * @model name="tk"
	 * @generated
	 * @ordered
	 */
	public static final int TK_VALUE = 215;

	/**
	 * The '<em><b>Tl</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Timor-Leste.
	 * <!-- end-model-doc -->
	 * @see #TL
	 * @model name="tl"
	 * @generated
	 * @ordered
	 */
	public static final int TL_VALUE = 216;

	/**
	 * The '<em><b>Tm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Turkmenistan.
	 * <!-- end-model-doc -->
	 * @see #TM
	 * @model name="tm"
	 * @generated
	 * @ordered
	 */
	public static final int TM_VALUE = 217;

	/**
	 * The '<em><b>Tn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tunisia.
	 * <!-- end-model-doc -->
	 * @see #TN
	 * @model name="tn"
	 * @generated
	 * @ordered
	 */
	public static final int TN_VALUE = 218;

	/**
	 * The '<em><b>To</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tonga.
	 * <!-- end-model-doc -->
	 * @see #TO
	 * @model name="to"
	 * @generated
	 * @ordered
	 */
	public static final int TO_VALUE = 219;

	/**
	 * The '<em><b>Tp</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * East Timor.
	 * <!-- end-model-doc -->
	 * @see #TP
	 * @model name="tp"
	 * @generated
	 * @ordered
	 */
	public static final int TP_VALUE = 220;

	/**
	 * The '<em><b>Tr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Turkey.
	 * <!-- end-model-doc -->
	 * @see #TR
	 * @model name="tr"
	 * @generated
	 * @ordered
	 */
	public static final int TR_VALUE = 221;

	/**
	 * The '<em><b>Tt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Trinidad and Tobago.
	 * <!-- end-model-doc -->
	 * @see #TT
	 * @model name="tt"
	 * @generated
	 * @ordered
	 */
	public static final int TT_VALUE = 222;

	/**
	 * The '<em><b>Tv</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tuvalu.
	 * <!-- end-model-doc -->
	 * @see #TV
	 * @model name="tv"
	 * @generated
	 * @ordered
	 */
	public static final int TV_VALUE = 223;

	/**
	 * The '<em><b>Tw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Taiwan.
	 * <!-- end-model-doc -->
	 * @see #TW
	 * @model name="tw"
	 * @generated
	 * @ordered
	 */
	public static final int TW_VALUE = 224;

	/**
	 * The '<em><b>Tz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Tanzania.
	 * <!-- end-model-doc -->
	 * @see #TZ
	 * @model name="tz"
	 * @generated
	 * @ordered
	 */
	public static final int TZ_VALUE = 225;

	/**
	 * The '<em><b>Ua</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ukraine.
	 * <!-- end-model-doc -->
	 * @see #UA
	 * @model name="ua"
	 * @generated
	 * @ordered
	 */
	public static final int UA_VALUE = 226;

	/**
	 * The '<em><b>Ug</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Uganda.
	 * <!-- end-model-doc -->
	 * @see #UG
	 * @model name="ug"
	 * @generated
	 * @ordered
	 */
	public static final int UG_VALUE = 227;

	/**
	 * The '<em><b>Uk</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United Kingdom.
	 * <!-- end-model-doc -->
	 * @see #UK
	 * @model name="uk"
	 * @generated
	 * @ordered
	 */
	public static final int UK_VALUE = 228;

	/**
	 * The '<em><b>Um</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United States Minor Outlying Islands.
	 * <!-- end-model-doc -->
	 * @see #UM
	 * @model name="um"
	 * @generated
	 * @ordered
	 */
	public static final int UM_VALUE = 229;

	/**
	 * The '<em><b>Us</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * United States.
	 * <!-- end-model-doc -->
	 * @see #US
	 * @model name="us"
	 * @generated
	 * @ordered
	 */
	public static final int US_VALUE = 230;

	/**
	 * The '<em><b>Uy</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Uruguay.
	 * <!-- end-model-doc -->
	 * @see #UY
	 * @model name="uy"
	 * @generated
	 * @ordered
	 */
	public static final int UY_VALUE = 231;

	/**
	 * The '<em><b>Uz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Uzbekistan.
	 * <!-- end-model-doc -->
	 * @see #UZ
	 * @model name="uz"
	 * @generated
	 * @ordered
	 */
	public static final int UZ_VALUE = 232;

	/**
	 * The '<em><b>Va</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Holy See (Vatican City State)
	 * <!-- end-model-doc -->
	 * @see #VA
	 * @model name="va"
	 * @generated
	 * @ordered
	 */
	public static final int VA_VALUE = 233;

	/**
	 * The '<em><b>Vc</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Saint Vincent and the Grenadines.
	 * <!-- end-model-doc -->
	 * @see #VC
	 * @model name="vc"
	 * @generated
	 * @ordered
	 */
	public static final int VC_VALUE = 234;

	/**
	 * The '<em><b>Ve</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Venezuela.
	 * <!-- end-model-doc -->
	 * @see #VE
	 * @model name="ve"
	 * @generated
	 * @ordered
	 */
	public static final int VE_VALUE = 235;

	/**
	 * The '<em><b>Vg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Virgin Islands, British.
	 * <!-- end-model-doc -->
	 * @see #VG
	 * @model name="vg"
	 * @generated
	 * @ordered
	 */
	public static final int VG_VALUE = 236;

	/**
	 * The '<em><b>Vi</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Virgin Islands, Us.
	 * <!-- end-model-doc -->
	 * @see #VI
	 * @model name="vi"
	 * @generated
	 * @ordered
	 */
	public static final int VI_VALUE = 237;

	/**
	 * The '<em><b>Vn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Vietnam.
	 * <!-- end-model-doc -->
	 * @see #VN
	 * @model name="vn"
	 * @generated
	 * @ordered
	 */
	public static final int VN_VALUE = 238;

	/**
	 * The '<em><b>Vu</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Vanuatu.
	 * <!-- end-model-doc -->
	 * @see #VU
	 * @model name="vu"
	 * @generated
	 * @ordered
	 */
	public static final int VU_VALUE = 239;

	/**
	 * The '<em><b>Wf</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Wallis and Futuna Islands.
	 * <!-- end-model-doc -->
	 * @see #WF
	 * @model name="wf"
	 * @generated
	 * @ordered
	 */
	public static final int WF_VALUE = 240;

	/**
	 * The '<em><b>Ws</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Samoa.
	 * <!-- end-model-doc -->
	 * @see #WS
	 * @model name="ws"
	 * @generated
	 * @ordered
	 */
	public static final int WS_VALUE = 241;

	/**
	 * The '<em><b>Ye</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Yemen.
	 * <!-- end-model-doc -->
	 * @see #YE
	 * @model name="ye"
	 * @generated
	 * @ordered
	 */
	public static final int YE_VALUE = 242;

	/**
	 * The '<em><b>Yt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Mayotte.
	 * <!-- end-model-doc -->
	 * @see #YT
	 * @model name="yt"
	 * @generated
	 * @ordered
	 */
	public static final int YT_VALUE = 243;

	/**
	 * The '<em><b>Yu</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Yugoslavia.
	 * <!-- end-model-doc -->
	 * @see #YU
	 * @model name="yu"
	 * @generated
	 * @ordered
	 */
	public static final int YU_VALUE = 244;

	/**
	 * The '<em><b>Za</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * South Africa.
	 * <!-- end-model-doc -->
	 * @see #ZA
	 * @model name="za"
	 * @generated
	 * @ordered
	 */
	public static final int ZA_VALUE = 245;

	/**
	 * The '<em><b>Zm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Zambia.
	 * <!-- end-model-doc -->
	 * @see #ZM
	 * @model name="zm"
	 * @generated
	 * @ordered
	 */
	public static final int ZM_VALUE = 246;

	/**
	 * The '<em><b>Zw</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Zimbabwe.
	 * <!-- end-model-doc -->
	 * @see #ZW
	 * @model name="zw"
	 * @generated
	 * @ordered
	 */
	public static final int ZW_VALUE = 247;

	/**
	 * An array of all the '<em><b>Iana Country Tld Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final IanaCountryTldEnumeration[] VALUES_ARRAY =
		new IanaCountryTldEnumeration[] {
			AC,
			AD,
			AE,
			AF,
			AG,
			AI,
			AL,
			AM,
			AN,
			AO,
			AQ,
			AR,
			AS,
			AT,
			AU,
			AW,
			AZ,
			AX,
			BA,
			BB,
			BD,
			BE,
			BF,
			BG,
			BH,
			BI,
			BJ,
			BM,
			BN,
			BO,
			BR,
			BS,
			BT,
			BV,
			BW,
			BY,
			BZ,
			CA,
			CC,
			CD,
			CF,
			CG,
			CH,
			CI,
			CK,
			CL,
			CM,
			CN,
			CO,
			CR,
			CS,
			CU,
			CV,
			CX,
			CY,
			CZ,
			DE,
			DJ,
			DK,
			DM,
			DO,
			DZ,
			EC,
			EE,
			EG,
			EH,
			ER,
			ES,
			ET,
			EU,
			FI,
			FJ,
			FK,
			FM,
			FO,
			FR,
			GA,
			GB,
			GD,
			GE,
			GF,
			GG,
			GH,
			GI,
			GL,
			GM,
			GN,
			GP,
			GQ,
			GR,
			GS,
			GT,
			GU,
			GW,
			GY,
			HK,
			HM,
			HN,
			HR,
			HT,
			HU,
			ID,
			IE,
			IL,
			IM,
			IN,
			IO,
			IQ,
			IR,
			IS,
			IT,
			JE,
			JM,
			JO,
			JP,
			KE,
			KG,
			KH,
			KI,
			KM,
			KN,
			KP,
			KR,
			KW,
			KY,
			KZ,
			LA,
			LB,
			LC,
			LI,
			LK,
			LR,
			LS,
			LT,
			LU,
			LV,
			LY,
			MA,
			MC,
			MD,
			MG,
			MH,
			MK,
			ML,
			MM,
			MN,
			MO,
			MP,
			MQ,
			MR,
			MS,
			MT,
			MU,
			MV,
			MW,
			MX,
			MY,
			MZ,
			NA,
			NC,
			NE,
			NF,
			NG,
			NI,
			NL,
			NO,
			NP,
			NR,
			NU,
			NZ,
			OM,
			PA,
			PE,
			PF,
			PG,
			PH,
			PK,
			PL,
			PM,
			PN,
			PR,
			PS,
			PT,
			PW,
			PY,
			QA,
			RE,
			RO,
			RU,
			RW,
			SA,
			SB,
			SC,
			SD,
			SE,
			SG,
			SH,
			SI,
			SJ,
			SK,
			SL,
			SM,
			SN,
			SO,
			SR,
			ST,
			SV,
			SY,
			SZ,
			TC,
			TD,
			TF,
			TG,
			TH,
			TJ,
			TK,
			TL,
			TM,
			TN,
			TO,
			TP,
			TR,
			TT,
			TV,
			TW,
			TZ,
			UA,
			UG,
			UK,
			UM,
			US,
			UY,
			UZ,
			VA,
			VC,
			VE,
			VG,
			VI,
			VN,
			VU,
			WF,
			WS,
			YE,
			YT,
			YU,
			ZA,
			ZM,
			ZW,
		};

	/**
	 * A public read-only list of all the '<em><b>Iana Country Tld Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<IanaCountryTldEnumeration> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Iana Country Tld Enumeration</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static IanaCountryTldEnumeration get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			IanaCountryTldEnumeration result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Iana Country Tld Enumeration</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static IanaCountryTldEnumeration getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			IanaCountryTldEnumeration result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Iana Country Tld Enumeration</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static IanaCountryTldEnumeration get(int value) {
		switch (value) {
			case AC_VALUE: return AC;
			case AD_VALUE: return AD;
			case AE_VALUE: return AE;
			case AF_VALUE: return AF;
			case AG_VALUE: return AG;
			case AI_VALUE: return AI;
			case AL_VALUE: return AL;
			case AM_VALUE: return AM;
			case AN_VALUE: return AN;
			case AO_VALUE: return AO;
			case AQ_VALUE: return AQ;
			case AR_VALUE: return AR;
			case AS_VALUE: return AS;
			case AT_VALUE: return AT;
			case AU_VALUE: return AU;
			case AW_VALUE: return AW;
			case AZ_VALUE: return AZ;
			case AX_VALUE: return AX;
			case BA_VALUE: return BA;
			case BB_VALUE: return BB;
			case BD_VALUE: return BD;
			case BE_VALUE: return BE;
			case BF_VALUE: return BF;
			case BG_VALUE: return BG;
			case BH_VALUE: return BH;
			case BI_VALUE: return BI;
			case BJ_VALUE: return BJ;
			case BM_VALUE: return BM;
			case BN_VALUE: return BN;
			case BO_VALUE: return BO;
			case BR_VALUE: return BR;
			case BS_VALUE: return BS;
			case BT_VALUE: return BT;
			case BV_VALUE: return BV;
			case BW_VALUE: return BW;
			case BY_VALUE: return BY;
			case BZ_VALUE: return BZ;
			case CA_VALUE: return CA;
			case CC_VALUE: return CC;
			case CD_VALUE: return CD;
			case CF_VALUE: return CF;
			case CG_VALUE: return CG;
			case CH_VALUE: return CH;
			case CI_VALUE: return CI;
			case CK_VALUE: return CK;
			case CL_VALUE: return CL;
			case CM_VALUE: return CM;
			case CN_VALUE: return CN;
			case CO_VALUE: return CO;
			case CR_VALUE: return CR;
			case CS_VALUE: return CS;
			case CU_VALUE: return CU;
			case CV_VALUE: return CV;
			case CX_VALUE: return CX;
			case CY_VALUE: return CY;
			case CZ_VALUE: return CZ;
			case DE_VALUE: return DE;
			case DJ_VALUE: return DJ;
			case DK_VALUE: return DK;
			case DM_VALUE: return DM;
			case DO_VALUE: return DO;
			case DZ_VALUE: return DZ;
			case EC_VALUE: return EC;
			case EE_VALUE: return EE;
			case EG_VALUE: return EG;
			case EH_VALUE: return EH;
			case ER_VALUE: return ER;
			case ES_VALUE: return ES;
			case ET_VALUE: return ET;
			case EU_VALUE: return EU;
			case FI_VALUE: return FI;
			case FJ_VALUE: return FJ;
			case FK_VALUE: return FK;
			case FM_VALUE: return FM;
			case FO_VALUE: return FO;
			case FR_VALUE: return FR;
			case GA_VALUE: return GA;
			case GB_VALUE: return GB;
			case GD_VALUE: return GD;
			case GE_VALUE: return GE;
			case GF_VALUE: return GF;
			case GG_VALUE: return GG;
			case GH_VALUE: return GH;
			case GI_VALUE: return GI;
			case GL_VALUE: return GL;
			case GM_VALUE: return GM;
			case GN_VALUE: return GN;
			case GP_VALUE: return GP;
			case GQ_VALUE: return GQ;
			case GR_VALUE: return GR;
			case GS_VALUE: return GS;
			case GT_VALUE: return GT;
			case GU_VALUE: return GU;
			case GW_VALUE: return GW;
			case GY_VALUE: return GY;
			case HK_VALUE: return HK;
			case HM_VALUE: return HM;
			case HN_VALUE: return HN;
			case HR_VALUE: return HR;
			case HT_VALUE: return HT;
			case HU_VALUE: return HU;
			case ID_VALUE: return ID;
			case IE_VALUE: return IE;
			case IL_VALUE: return IL;
			case IM_VALUE: return IM;
			case IN_VALUE: return IN;
			case IO_VALUE: return IO;
			case IQ_VALUE: return IQ;
			case IR_VALUE: return IR;
			case IS_VALUE: return IS;
			case IT_VALUE: return IT;
			case JE_VALUE: return JE;
			case JM_VALUE: return JM;
			case JO_VALUE: return JO;
			case JP_VALUE: return JP;
			case KE_VALUE: return KE;
			case KG_VALUE: return KG;
			case KH_VALUE: return KH;
			case KI_VALUE: return KI;
			case KM_VALUE: return KM;
			case KN_VALUE: return KN;
			case KP_VALUE: return KP;
			case KR_VALUE: return KR;
			case KW_VALUE: return KW;
			case KY_VALUE: return KY;
			case KZ_VALUE: return KZ;
			case LA_VALUE: return LA;
			case LB_VALUE: return LB;
			case LC_VALUE: return LC;
			case LI_VALUE: return LI;
			case LK_VALUE: return LK;
			case LR_VALUE: return LR;
			case LS_VALUE: return LS;
			case LT_VALUE: return LT;
			case LU_VALUE: return LU;
			case LV_VALUE: return LV;
			case LY_VALUE: return LY;
			case MA_VALUE: return MA;
			case MC_VALUE: return MC;
			case MD_VALUE: return MD;
			case MG_VALUE: return MG;
			case MH_VALUE: return MH;
			case MK_VALUE: return MK;
			case ML_VALUE: return ML;
			case MM_VALUE: return MM;
			case MN_VALUE: return MN;
			case MO_VALUE: return MO;
			case MP_VALUE: return MP;
			case MQ_VALUE: return MQ;
			case MR_VALUE: return MR;
			case MS_VALUE: return MS;
			case MT_VALUE: return MT;
			case MU_VALUE: return MU;
			case MV_VALUE: return MV;
			case MW_VALUE: return MW;
			case MX_VALUE: return MX;
			case MY_VALUE: return MY;
			case MZ_VALUE: return MZ;
			case NA_VALUE: return NA;
			case NC_VALUE: return NC;
			case NE_VALUE: return NE;
			case NF_VALUE: return NF;
			case NG_VALUE: return NG;
			case NI_VALUE: return NI;
			case NL_VALUE: return NL;
			case NO_VALUE: return NO;
			case NP_VALUE: return NP;
			case NR_VALUE: return NR;
			case NU_VALUE: return NU;
			case NZ_VALUE: return NZ;
			case OM_VALUE: return OM;
			case PA_VALUE: return PA;
			case PE_VALUE: return PE;
			case PF_VALUE: return PF;
			case PG_VALUE: return PG;
			case PH_VALUE: return PH;
			case PK_VALUE: return PK;
			case PL_VALUE: return PL;
			case PM_VALUE: return PM;
			case PN_VALUE: return PN;
			case PR_VALUE: return PR;
			case PS_VALUE: return PS;
			case PT_VALUE: return PT;
			case PW_VALUE: return PW;
			case PY_VALUE: return PY;
			case QA_VALUE: return QA;
			case RE_VALUE: return RE;
			case RO_VALUE: return RO;
			case RU_VALUE: return RU;
			case RW_VALUE: return RW;
			case SA_VALUE: return SA;
			case SB_VALUE: return SB;
			case SC_VALUE: return SC;
			case SD_VALUE: return SD;
			case SE_VALUE: return SE;
			case SG_VALUE: return SG;
			case SH_VALUE: return SH;
			case SI_VALUE: return SI;
			case SJ_VALUE: return SJ;
			case SK_VALUE: return SK;
			case SL_VALUE: return SL;
			case SM_VALUE: return SM;
			case SN_VALUE: return SN;
			case SO_VALUE: return SO;
			case SR_VALUE: return SR;
			case ST_VALUE: return ST;
			case SV_VALUE: return SV;
			case SY_VALUE: return SY;
			case SZ_VALUE: return SZ;
			case TC_VALUE: return TC;
			case TD_VALUE: return TD;
			case TF_VALUE: return TF;
			case TG_VALUE: return TG;
			case TH_VALUE: return TH;
			case TJ_VALUE: return TJ;
			case TK_VALUE: return TK;
			case TL_VALUE: return TL;
			case TM_VALUE: return TM;
			case TN_VALUE: return TN;
			case TO_VALUE: return TO;
			case TP_VALUE: return TP;
			case TR_VALUE: return TR;
			case TT_VALUE: return TT;
			case TV_VALUE: return TV;
			case TW_VALUE: return TW;
			case TZ_VALUE: return TZ;
			case UA_VALUE: return UA;
			case UG_VALUE: return UG;
			case UK_VALUE: return UK;
			case UM_VALUE: return UM;
			case US_VALUE: return US;
			case UY_VALUE: return UY;
			case UZ_VALUE: return UZ;
			case VA_VALUE: return VA;
			case VC_VALUE: return VC;
			case VE_VALUE: return VE;
			case VG_VALUE: return VG;
			case VI_VALUE: return VI;
			case VN_VALUE: return VN;
			case VU_VALUE: return VU;
			case WF_VALUE: return WF;
			case WS_VALUE: return WS;
			case YE_VALUE: return YE;
			case YT_VALUE: return YT;
			case YU_VALUE: return YU;
			case ZA_VALUE: return ZA;
			case ZM_VALUE: return ZM;
			case ZW_VALUE: return ZW;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private IanaCountryTldEnumeration(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //IanaCountryTldEnumeration
