/*
 */
package siri;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Miscellaneous Reason Enumeration</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Values for Miscellaneous incident reason types TPEG Pti18_1/TPEG Pti_19.
 * <!-- end-model-doc -->
 * @see siri.SiriPackage#getMiscellaneousReasonEnumeration()
 * @model extendedMetaData="name='MiscellaneousReasonEnumeration'"
 * @generated
 */
@ProviderType
public enum MiscellaneousReasonEnumeration implements Enumerator {
	/**
	 * The '<em><b>Pti190</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI190_VALUE
	 * @generated
	 * @ordered
	 */
	PTI190(0, "pti190", "pti19_0"),

	/**
	 * The '<em><b>Unknown</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_0 unknown.
	 * <!-- end-model-doc -->
	 * @see #UNKNOWN_VALUE
	 * @generated
	 * @ordered
	 */
	UNKNOWN(1, "unknown", "unknown"),

	/**
	 * The '<em><b>Pti1901</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1901_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1901(2, "pti1901", "pti19_0_1"),

	/**
	 * The '<em><b>Previous Disturbances</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:0_1 Previous disturbances - alias to TPEG Pti_19_0 unknown
	 * <!-- end-model-doc -->
	 * @see #PREVIOUS_DISTURBANCES_VALUE
	 * @generated
	 * @ordered
	 */
	PREVIOUS_DISTURBANCES(3, "previousDisturbances", "previousDisturbances"),

	/**
	 * The '<em><b>Pti191</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_VALUE
	 * @generated
	 * @ordered
	 */
	PTI191(4, "pti191", "pti19_1"),

	/**
	 * The '<em><b>Incident</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #INCIDENT_VALUE
	 * @generated
	 * @ordered
	 */
	INCIDENT(5, "incident", "incident"),

	/**
	 * The '<em><b>Pti191 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI191_ALIAS1(6, "pti191Alias1", "pti19_1_Alias_1"),

	/**
	 * The '<em><b>Near Miss</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Near Miss - alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #NEAR_MISS_VALUE
	 * @generated
	 * @ordered
	 */
	NEAR_MISS(7, "nearMiss", "nearMiss"),

	/**
	 * The '<em><b>Pti191 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI191_ALIAS2(8, "pti191Alias2", "pti19_1_Alias_2"),

	/**
	 * The '<em><b>Safety Violation</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Near Miss - alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #SAFETY_VIOLATION_VALUE
	 * @generated
	 * @ordered
	 */
	SAFETY_VIOLATION(9, "safetyViolation", "safetyViolation"),

	/**
	 * The '<em><b>Pti191 Alias3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS3_VALUE
	 * @generated
	 * @ordered
	 */
	PTI191_ALIAS3(10, "pti191Alias3", "pti19_1_Alias_3"),

	/**
	 * The '<em><b>Signal Passed At Danger</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Signal passed at danger - alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_PASSED_AT_DANGER_VALUE
	 * @generated
	 * @ordered
	 */
	SIGNAL_PASSED_AT_DANGER(11, "signalPassedAtDanger", "signalPassedAtDanger"),

	/**
	 * The '<em><b>Pti191 Alias4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS4_VALUE
	 * @generated
	 * @ordered
	 */
	PTI191_ALIAS4(12, "pti191Alias4", "pti19_1_Alias_4"),

	/**
	 * The '<em><b>Station Overrun</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Station overrun - alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #STATION_OVERRUN_VALUE
	 * @generated
	 * @ordered
	 */
	STATION_OVERRUN(13, "stationOverrun", "stationOverrun"),

	/**
	 * The '<em><b>Pti191 Alias5</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS5_VALUE
	 * @generated
	 * @ordered
	 */
	PTI191_ALIAS5(14, "pti191Alias5", "pti19_1_Alias_5"),

	/**
	 * The '<em><b>Train Door</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * trainDoor- alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #TRAIN_DOOR_VALUE
	 * @generated
	 * @ordered
	 */
	TRAIN_DOOR(15, "trainDoor", "trainDoor"),

	/**
	 * The '<em><b>Pti191 Alias6</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS6_VALUE
	 * @generated
	 * @ordered
	 */
	PTI191_ALIAS6(16, "pti191Alias6", "pti19_1_Alias_6"),

	/**
	 * The '<em><b>Emergency Services Call</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unspecified emergency service visit. Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #EMERGENCY_SERVICES_CALL_VALUE
	 * @generated
	 * @ordered
	 */
	EMERGENCY_SERVICES_CALL(17, "emergencyServicesCall", "emergencyServicesCall"),

	/**
	 * The '<em><b>Pti192</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI192_VALUE
	 * @generated
	 * @ordered
	 */
	PTI192(18, "pti192", "pti19_2"),

	/**
	 * The '<em><b>Bomb Explosion</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_2 bomb explosion.
	 * <!-- end-model-doc -->
	 * @see #BOMB_EXPLOSION_VALUE
	 * @generated
	 * @ordered
	 */
	BOMB_EXPLOSION(19, "bombExplosion", "bombExplosion"),

	/**
	 * The '<em><b>Pti193</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193(20, "pti193", "pti19_3"),

	/**
	 * The '<em><b>Security Alert</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #SECURITY_ALERT_VALUE
	 * @generated
	 * @ordered
	 */
	SECURITY_ALERT(21, "securityAlert", "securityAlert"),

	/**
	 * The '<em><b>Pti193 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS1(22, "pti193Alias1", "pti19_3_Alias_1"),

	/**
	 * The '<em><b>Police Request</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * pti19_3_1 request of the police Alias to TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #POLICE_REQUEST_VALUE
	 * @generated
	 * @ordered
	 */
	POLICE_REQUEST(23, "policeRequest", "policeRequest"),

	/**
	 * The '<em><b>Pti193 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS2(24, "pti193Alias2", "pti19_3_Alias_2"),

	/**
	 * The '<em><b>Fire Brigade Safety Checks</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * pti19_3_2 fire brigade safety checksAlias to TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #FIRE_BRIGADE_SAFETY_CHECKS_VALUE
	 * @generated
	 * @ordered
	 */
	FIRE_BRIGADE_SAFETY_CHECKS(25, "fireBrigadeSafetyChecks", "fireBrigadeSafetyChecks"),

	/**
	 * The '<em><b>Pti193 Alias3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS3_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS3(26, "pti193Alias3", "pti19_3_Alias_3"),

	/**
	 * The '<em><b>Unattended Bag</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * pti19_3_3 an unattended bag Talias to PEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #UNATTENDED_BAG_VALUE
	 * @generated
	 * @ordered
	 */
	UNATTENDED_BAG(27, "unattendedBag", "unattendedBag"),

	/**
	 * The '<em><b>Pti193 Alias4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS4_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS4(28, "pti193Alias4", "pti19_3_Alias_4"),

	/**
	 * The '<em><b>Telephoned Threat</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * telephoned threat TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #TELEPHONED_THREAT_VALUE
	 * @generated
	 * @ordered
	 */
	TELEPHONED_THREAT(29, "telephonedThreat", "telephonedThreat"),

	/**
	 * The '<em><b>Pti193 Alias5</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS5_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS5(30, "pti193Alias5", "pti19_3_Alias_5"),

	/**
	 * The '<em><b>Suspect Vehicle</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * telephoned threat TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #SUSPECT_VEHICLE_VALUE
	 * @generated
	 * @ordered
	 */
	SUSPECT_VEHICLE(31, "suspectVehicle", "suspectVehicle"),

	/**
	 * The '<em><b>Pti193 Alias6</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS6_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS6(32, "pti193Alias6", "pti19_3_Alias_6"),

	/**
	 * The '<em><b>Civil Emergency</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * civilEmergency alias to  TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #CIVIL_EMERGENCY_VALUE
	 * @generated
	 * @ordered
	 */
	CIVIL_EMERGENCY(33, "civilEmergency", "civilEmergency"),

	/**
	 * The '<em><b>Pti193 Alias7</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS7_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS7(34, "pti193Alias7", "pti19_3_Alias_7"),

	/**
	 * The '<em><b>Air Raid</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * civilEmergency alias to  TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #AIR_RAID_VALUE
	 * @generated
	 * @ordered
	 */
	AIR_RAID(35, "airRaid", "airRaid"),

	/**
	 * The '<em><b>Pti193 Alias8</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS8_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS8(36, "pti193Alias8", "pti19_3_Alias_8"),

	/**
	 * The '<em><b>Sabotage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * sabotage alias to TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #SABOTAGE_VALUE
	 * @generated
	 * @ordered
	 */
	SABOTAGE(37, "sabotage", "sabotage"),

	/**
	 * The '<em><b>Pti193 Alias9</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS9_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS9(38, "pti193Alias9", "pti19_3_Alias_9"),

	/**
	 * The '<em><b>Bomb Alert</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BOMB_ALERT_VALUE
	 * @generated
	 * @ordered
	 */
	BOMB_ALERT(39, "bombAlert", "bombAlert"),

	/**
	 * The '<em><b>Pti193 Alias10</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS10_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS10(40, "pti193Alias10", "pti19_3_Alias_10"),

	/**
	 * The '<em><b>Attack</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ATTACK_VALUE
	 * @generated
	 * @ordered
	 */
	ATTACK(41, "attack", "attack"),

	/**
	 * The '<em><b>Pti193 Alias11</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS11_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS11(42, "pti193Alias11", "pti19_3_Alias_11"),

	/**
	 * The '<em><b>Evacuation</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EVACUATION_VALUE
	 * @generated
	 * @ordered
	 */
	EVACUATION(43, "evacuation", "evacuation"),

	/**
	 * The '<em><b>Pti193 Alias12</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS12_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS12(44, "pti193Alias12", "pti19_3_Alias_12"),

	/**
	 * The '<em><b>Terrorist Incident</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TERRORIST_INCIDENT_VALUE
	 * @generated
	 * @ordered
	 */
	TERRORIST_INCIDENT(45, "terroristIncident", "terroristIncident"),

	/**
	 * The '<em><b>Pti193 Alias13</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS13_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS13(46, "pti193Alias13", "pti19_3_Alias_13"),

	/**
	 * The '<em><b>Gunfire On Roadway</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUNFIRE_ON_ROADWAY_VALUE
	 * @generated
	 * @ordered
	 */
	GUNFIRE_ON_ROADWAY(47, "gunfireOnRoadway", "gunfireOnRoadway"),

	/**
	 * The '<em><b>Pti193 Alias14</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS14_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS14(48, "pti193Alias14", "pti19_3_Alias_14"),

	/**
	 * The '<em><b>Explosion</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPLOSION_VALUE
	 * @generated
	 * @ordered
	 */
	EXPLOSION(49, "explosion", "explosion"),

	/**
	 * The '<em><b>Pti193 Alias15</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS15_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS15(50, "pti193Alias15", "pti19_3_Alias_15"),

	/**
	 * The '<em><b>Explosion Hazard</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPLOSION_HAZARD_VALUE
	 * @generated
	 * @ordered
	 */
	EXPLOSION_HAZARD(51, "explosionHazard", "explosionHazard"),

	/**
	 * The '<em><b>Pti193 Alias16</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS16_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS16(52, "pti193Alias16", "pti19_3_Alias_16"),

	/**
	 * The '<em><b>Security Incident</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SECURITY_INCIDENT_VALUE
	 * @generated
	 * @ordered
	 */
	SECURITY_INCIDENT(53, "securityIncident", "securityIncident"),

	/**
	 * The '<em><b>Pti193 Alias17</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS17_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS17(54, "pti193Alias17", "pti19_3_Alias_17"),

	/**
	 * The '<em><b>Fire Brigade Order</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FIRE_BRIGADE_ORDER_VALUE
	 * @generated
	 * @ordered
	 */
	FIRE_BRIGADE_ORDER(55, "fireBrigadeOrder", "fireBrigadeOrder"),

	/**
	 * The '<em><b>Pti193 Alias18</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS18_VALUE
	 * @generated
	 * @ordered
	 */
	PTI193_ALIAS18(56, "pti193Alias18", "pti19_3_Alias_18"),

	/**
	 * The '<em><b>Police Activity</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #POLICE_ACTIVITY_VALUE
	 * @generated
	 * @ordered
	 */
	POLICE_ACTIVITY(57, "policeActivity", "policeActivity"),

	/**
	 * The '<em><b>Pti194</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI194_VALUE
	 * @generated
	 * @ordered
	 */
	PTI194(58, "pti194", "pti19_4"),

	/**
	 * The '<em><b>Fire</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_4 fire.
	 * <!-- end-model-doc -->
	 * @see #FIRE_VALUE
	 * @generated
	 * @ordered
	 */
	FIRE(59, "fire", "fire"),

	/**
	 * The '<em><b>Pti194 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI194_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI194_ALIAS1(60, "pti194Alias1", "pti19_4_Alias_1"),

	/**
	 * The '<em><b>Lineside Fire</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * linesideFire alias to TPEG Pti_19_4 fire.
	 * <!-- end-model-doc -->
	 * @see #LINESIDE_FIRE_VALUE
	 * @generated
	 * @ordered
	 */
	LINESIDE_FIRE(61, "linesideFire", "linesideFire"),

	/**
	 * The '<em><b>Pti195</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_VALUE
	 * @generated
	 * @ordered
	 */
	PTI195(62, "pti195", "pti19_5"),

	/**
	 * The '<em><b>Vandalism</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_5 vandalism.
	 * <!-- end-model-doc -->
	 * @see #VANDALISM_VALUE
	 * @generated
	 * @ordered
	 */
	VANDALISM(63, "vandalism", "vandalism"),

	/**
	 * The '<em><b>Pti195 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI195_ALIAS1(64, "pti195Alias1", "pti19_5_Alias_1"),

	/**
	 * The '<em><b>Passenger Action</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * passengerActionAlias to pti19
	 * <!-- end-model-doc -->
	 * @see #PASSENGER_ACTION_VALUE
	 * @generated
	 * @ordered
	 */
	PASSENGER_ACTION(65, "passengerAction", "passengerAction"),

	/**
	 * The '<em><b>Pti195 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI195_ALIAS2(66, "pti195Alias2", "pti19_5_Alias_2"),

	/**
	 * The '<em><b>Staff Assault</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Assault on stafft.Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #STAFF_ASSAULT_VALUE
	 * @generated
	 * @ordered
	 */
	STAFF_ASSAULT(67, "staffAssault", "staffAssault"),

	/**
	 * The '<em><b>Pti195 Alias3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS3_VALUE
	 * @generated
	 * @ordered
	 */
	PTI195_ALIAS3(68, "pti195Alias3", "pti19_5_Alias_3"),

	/**
	 * The '<em><b>Railway Crime</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Railway Crime Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #RAILWAY_CRIME_VALUE
	 * @generated
	 * @ordered
	 */
	RAILWAY_CRIME(69, "railwayCrime", "railwayCrime"),

	/**
	 * The '<em><b>Pti195 Alias4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS4_VALUE
	 * @generated
	 * @ordered
	 */
	PTI195_ALIAS4(70, "pti195Alias4", "pti19_5_Alias_4"),

	/**
	 * The '<em><b>Assault</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Assault Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #ASSAULT_VALUE
	 * @generated
	 * @ordered
	 */
	ASSAULT(71, "assault", "assault"),

	/**
	 * The '<em><b>Pti195 Alias5</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS5_VALUE
	 * @generated
	 * @ordered
	 */
	PTI195_ALIAS5(72, "pti195Alias5", "pti19_5_Alias_5"),

	/**
	 * The '<em><b>Theft</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Theft Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #THEFT_VALUE
	 * @generated
	 * @ordered
	 */
	THEFT(73, "theft", "theft"),

	/**
	 * The '<em><b>Altercation</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * altercation . Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #ALTERCATION_VALUE
	 * @generated
	 * @ordered
	 */
	ALTERCATION(75, "altercation", "altercation"),

	/**
	 * The '<em><b>Pti191 Alias7</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS7_VALUE
	 * @generated
	 * @ordered
	 */
	PTI191_ALIAS7(76, "pti191Alias7", "pti19_1_Alias_7"),

	/**
	 * The '<em><b>Ill Vehicle Occupants</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * illVehicleOccupants . Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #ILL_VEHICLE_OCCUPANTS_VALUE
	 * @generated
	 * @ordered
	 */
	ILL_VEHICLE_OCCUPANTS(77, "illVehicleOccupants", "illVehicleOccupants"),

	/**
	 * The '<em><b>Pti196</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_VALUE
	 * @generated
	 * @ordered
	 */
	PTI196(78, "pti196", "pti19_6"),

	/**
	 * The '<em><b>Accident</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #ACCIDENT_VALUE
	 * @generated
	 * @ordered
	 */
	ACCIDENT(79, "accident", "accident"),

	/**
	 * The '<em><b>Pti196 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI196_ALIAS1(80, "pti196Alias1", "pti19_6_Alias_1"),

	/**
	 * The '<em><b>Fatality</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * fatality alias to TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #FATALITY_VALUE
	 * @generated
	 * @ordered
	 */
	FATALITY(81, "fatality", "fatality"),

	/**
	 * The '<em><b>Pti196 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI196_ALIAS2(82, "pti196Alias2", "pti19_6_Alias_2"),

	/**
	 * The '<em><b>Person Under Train</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * a person under a train - alias to TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #PERSON_UNDER_TRAIN_VALUE
	 * @generated
	 * @ordered
	 */
	PERSON_UNDER_TRAIN(83, "personUnderTrain", "personUnderTrain"),

	/**
	 * The '<em><b>Pti196 Alias3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS3_VALUE
	 * @generated
	 * @ordered
	 */
	PTI196_ALIAS3(84, "pti196Alias3", "pti19_6_Alias_3"),

	/**
	 * The '<em><b>Person Hit By Train</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * a person hit by a train - alias to TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #PERSON_HIT_BY_TRAIN_VALUE
	 * @generated
	 * @ordered
	 */
	PERSON_HIT_BY_TRAIN(85, "personHitByTrain", "personHitByTrain"),

	/**
	 * The '<em><b>Pti196 Alias4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS4_VALUE
	 * @generated
	 * @ordered
	 */
	PTI196_ALIAS4(86, "pti196Alias4", "pti19_6_Alias_4"),

	/**
	 * The '<em><b>Person Ill On Vehicle</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * person ill On Vehicle -Alias to pti19_6
	 * <!-- end-model-doc -->
	 * @see #PERSON_ILL_ON_VEHICLE_VALUE
	 * @generated
	 * @ordered
	 */
	PERSON_ILL_ON_VEHICLE(87, "personIllOnVehicle", "personIllOnVehicle"),

	/**
	 * The '<em><b>Pti196 Alias5</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS5_VALUE
	 * @generated
	 * @ordered
	 */
	PTI196_ALIAS5(88, "pti196Alias5", "pti19_6_Alias_5"),

	/**
	 * The '<em><b>Emergency Services</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * emergencyServices - alias to TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #EMERGENCY_SERVICES_VALUE
	 * @generated
	 * @ordered
	 */
	EMERGENCY_SERVICES(89, "emergencyServices", "emergencyServices"),

	/**
	 * The '<em><b>Pti196 Alias6</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS6_VALUE
	 * @generated
	 * @ordered
	 */
	PTI196_ALIAS6(90, "pti196Alias6", "pti19_6_Alias_6"),

	/**
	 * The '<em><b>Collision</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collision - Alias to pti19_6
	 * <!-- end-model-doc -->
	 * @see #COLLISION_VALUE
	 * @generated
	 * @ordered
	 */
	COLLISION(91, "collision", "collision"),

	/**
	 * The '<em><b>Pti197</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI197_VALUE
	 * @generated
	 * @ordered
	 */
	PTI197(92, "pti197", "pti19_7"),

	/**
	 * The '<em><b>Overcrowded</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_7 overcrowded.
	 * <!-- end-model-doc -->
	 * @see #OVERCROWDED_VALUE
	 * @generated
	 * @ordered
	 */
	OVERCROWDED(93, "overcrowded", "overcrowded"),

	/**
	 * The '<em><b>Pti198</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI198_VALUE
	 * @generated
	 * @ordered
	 */
	PTI198(94, "pti198", "pti19_8"),

	/**
	 * The '<em><b>Insufficient Demand</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_8 insufficient demand.
	 * <!-- end-model-doc -->
	 * @see #INSUFFICIENT_DEMAND_VALUE
	 * @generated
	 * @ordered
	 */
	INSUFFICIENT_DEMAND(95, "insufficientDemand", "insufficientDemand"),

	/**
	 * The '<em><b>Pti199</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI199_VALUE
	 * @generated
	 * @ordered
	 */
	PTI199(96, "pti199", "pti19_9"),

	/**
	 * The '<em><b>Lighting Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_9 lighting failure.
	 * <!-- end-model-doc -->
	 * @see #LIGHTING_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	LIGHTING_FAILURE(97, "lightingFailure", "lightingFailure"),

	/**
	 * The '<em><b>Pti1910</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1910_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1910(98, "pti1910", "pti19_10"),

	/**
	 * The '<em><b>Leader Board Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_10 leader board failure.
	 * <!-- end-model-doc -->
	 * @see #LEADER_BOARD_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	LEADER_BOARD_FAILURE(99, "leaderBoardFailure", "leaderBoardFailure"),

	/**
	 * The '<em><b>Pti1911</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1911_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1911(100, "pti1911", "pti19_11"),

	/**
	 * The '<em><b>Service Indicator Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_11 service indicator failure.
	 * <!-- end-model-doc -->
	 * @see #SERVICE_INDICATOR_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	SERVICE_INDICATOR_FAILURE(101, "serviceIndicatorFailure", "serviceIndicatorFailure"),

	/**
	 * The '<em><b>Pti1912</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1912_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1912(102, "pti1912", "pti19_12"),

	/**
	 * The '<em><b>Service Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_12 service failure.
	 * <!-- end-model-doc -->
	 * @see #SERVICE_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	SERVICE_FAILURE(103, "serviceFailure", "serviceFailure"),

	/**
	 * The '<em><b>Pti1913</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1913_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1913(104, "pti1913", "pti19_13"),

	/**
	 * The '<em><b>Operator Ceased Trading</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_13 OPERATOR ceased trading.
	 * <!-- end-model-doc -->
	 * @see #OPERATOR_CEASED_TRADING_VALUE
	 * @generated
	 * @ordered
	 */
	OPERATOR_CEASED_TRADING(105, "operatorCeasedTrading", "operatorCeasedTrading"),

	/**
	 * The '<em><b>Pti1914</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1914_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1914(106, "pti1914", "pti19_14"),

	/**
	 * The '<em><b>Operator Suspended</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_14 OPERATOR suspended.
	 * <!-- end-model-doc -->
	 * @see #OPERATOR_SUSPENDED_VALUE
	 * @generated
	 * @ordered
	 */
	OPERATOR_SUSPENDED(107, "operatorSuspended", "operatorSuspended"),

	/**
	 * The '<em><b>Pti1915</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1915_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1915(108, "pti1915", "pti19_15"),

	/**
	 * The '<em><b>Congestion</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_15 congestion.
	 * <!-- end-model-doc -->
	 * @see #CONGESTION_VALUE
	 * @generated
	 * @ordered
	 */
	CONGESTION(109, "congestion", "congestion"),

	/**
	 * The '<em><b>Pti1916</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1916_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1916(110, "pti1916", "pti19_16"),

	/**
	 * The '<em><b>Route Blockage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_16 route blockage.
	 * <!-- end-model-doc -->
	 * @see #ROUTE_BLOCKAGE_VALUE
	 * @generated
	 * @ordered
	 */
	ROUTE_BLOCKAGE(111, "routeBlockage", "routeBlockage"),

	/**
	 * The '<em><b>Pti1917</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1917_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1917(112, "pti1917", "pti19_17"),

	/**
	 * The '<em><b>Person On The Line</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_17 person on the line.
	 * <!-- end-model-doc -->
	 * @see #PERSON_ON_THE_LINE_VALUE
	 * @generated
	 * @ordered
	 */
	PERSON_ON_THE_LINE(113, "personOnTheLine", "personOnTheLine"),

	/**
	 * The '<em><b>Pti1918</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1918_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1918(114, "pti1918", "pti19_18"),

	/**
	 * The '<em><b>Vehicle On The Line</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_18 VEHICLE on the line.
	 * <!-- end-model-doc -->
	 * @see #VEHICLE_ON_THE_LINE_VALUE
	 * @generated
	 * @ordered
	 */
	VEHICLE_ON_THE_LINE(115, "vehicleOnTheLine", "vehicleOnTheLine"),

	/**
	 * The '<em><b>Pti1918 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1918_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1918_ALIAS1(116, "pti1918Alias1", "pti19_18_Alias_1"),

	/**
	 * The '<em><b>Level Crossing Incident</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Level Crossing Incident - alias to TPEG Pti_19_18 VEHICLE on the line.
	 * <!-- end-model-doc -->
	 * @see #LEVEL_CROSSING_INCIDENT_VALUE
	 * @generated
	 * @ordered
	 */
	LEVEL_CROSSING_INCIDENT(117, "levelCrossingIncident", "levelCrossingIncident"),

	/**
	 * The '<em><b>Pti1919</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1919(118, "pti1919", "pti19_19"),

	/**
	 * The '<em><b>Object On The Line</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #OBJECT_ON_THE_LINE_VALUE
	 * @generated
	 * @ordered
	 */
	OBJECT_ON_THE_LINE(119, "objectOnTheLine", "objectOnTheLine"),

	/**
	 * The '<em><b>Pti1919 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1919_ALIAS1(120, "pti1919Alias1", "pti19_19_Alias_1"),

	/**
	 * The '<em><b>Fallen Tree On The Line</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * fallen tree on line- alias to TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #FALLEN_TREE_ON_THE_LINE_VALUE
	 * @generated
	 * @ordered
	 */
	FALLEN_TREE_ON_THE_LINE(121, "fallenTreeOnTheLine", "fallenTreeOnTheLine"),

	/**
	 * The '<em><b>Pti1919 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1919_ALIAS2(122, "pti1919Alias2", "pti19_19_Alias_2"),

	/**
	 * The '<em><b>Vegetation</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * vegetation - alias to TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #VEGETATION_VALUE
	 * @generated
	 * @ordered
	 */
	VEGETATION(123, "vegetation", "vegetation"),

	/**
	 * The '<em><b>Pti1919 Alias3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919_ALIAS3_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1919_ALIAS3(124, "pti1919Alias3", "pti19_19_Alias_3"),

	/**
	 * The '<em><b>Train Struck Animal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Train struck animal alias to TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #TRAIN_STRUCK_ANIMAL_VALUE
	 * @generated
	 * @ordered
	 */
	TRAIN_STRUCK_ANIMAL(125, "trainStruckAnimal", "trainStruckAnimal"),

	/**
	 * The '<em><b>Pti1919 Alias4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919_ALIAS4_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1919_ALIAS4(126, "pti1919Alias4", "pti19_19_Alias_4"),

	/**
	 * The '<em><b>Train Struck Object</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Train struck object alias to TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #TRAIN_STRUCK_OBJECT_VALUE
	 * @generated
	 * @ordered
	 */
	TRAIN_STRUCK_OBJECT(127, "trainStruckObject", "trainStruckObject"),

	/**
	 * The '<em><b>Pti1920</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1920_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1920(128, "pti1920", "pti19_20"),

	/**
	 * The '<em><b>Animal On The Line</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_20 animal on the line.
	 * <!-- end-model-doc -->
	 * @see #ANIMAL_ON_THE_LINE_VALUE
	 * @generated
	 * @ordered
	 */
	ANIMAL_ON_THE_LINE(129, "animalOnTheLine", "animalOnTheLine"),

	/**
	 * The '<em><b>Pti1921</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1921_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1921(130, "pti1921", "pti19_21"),

	/**
	 * The '<em><b>Route Diversion</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_21 route diversion.
	 * <!-- end-model-doc -->
	 * @see #ROUTE_DIVERSION_VALUE
	 * @generated
	 * @ordered
	 */
	ROUTE_DIVERSION(131, "routeDiversion", "routeDiversion"),

	/**
	 * The '<em><b>Pti1922</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1922_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1922(132, "pti1922", "pti19_22"),

	/**
	 * The '<em><b>Road Closed</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_22 road closed.
	 * <!-- end-model-doc -->
	 * @see #ROAD_CLOSED_VALUE
	 * @generated
	 * @ordered
	 */
	ROAD_CLOSED(133, "roadClosed", "roadClosed"),

	/**
	 * The '<em><b>Pti1923</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1923(134, "pti1923", "pti19_23"),

	/**
	 * The '<em><b>Roadworks</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_23 roadworks.
	 * <!-- end-model-doc -->
	 * @see #ROADWORKS_VALUE
	 * @generated
	 * @ordered
	 */
	ROADWORKS(135, "roadworks", "roadworks"),

	/**
	 * The '<em><b>Pti1923 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1923_ALIAS1(136, "pti1923Alias1", "pti19_23_Alias_1"),

	/**
	 * The '<em><b>Sewerage Maintenance</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:23_1 sewerageMaintenance - alias to TPEG Pti_19_23 roadworks..
	 * <!-- end-model-doc -->
	 * @see #SEWERAGE_MAINTENANCE_VALUE
	 * @generated
	 * @ordered
	 */
	SEWERAGE_MAINTENANCE(137, "sewerageMaintenance", "sewerageMaintenance"),

	/**
	 * The '<em><b>Pti1923 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1923_ALIAS2(138, "pti1923Alias2", "pti19_23_Alias_2"),

	/**
	 * The '<em><b>Road Maintenance</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:23_2 roadMaintenance - alias to TPEG Pti_19_23 roadworks..
	 * <!-- end-model-doc -->
	 * @see #ROAD_MAINTENANCE_VALUE
	 * @generated
	 * @ordered
	 */
	ROAD_MAINTENANCE(139, "roadMaintenance", "roadMaintenance"),

	/**
	 * The '<em><b>Pti1923 Alias3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923_ALIAS3_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1923_ALIAS3(140, "pti1923Alias3", "pti19_23_Alias_3"),

	/**
	 * The '<em><b>Asphalting</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:23_3 asphalting - alias to TPEG Pti_19_23 roadworks..
	 * <!-- end-model-doc -->
	 * @see #ASPHALTING_VALUE
	 * @generated
	 * @ordered
	 */
	ASPHALTING(141, "asphalting", "asphalting"),

	/**
	 * The '<em><b>Pti1923 Alias4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923_ALIAS4_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1923_ALIAS4(142, "pti1923Alias4", "pti19_23_Alias_4"),

	/**
	 * The '<em><b>Paving</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:23_4 paving - alias to TPEG Pti_19_23 roadworks..
	 * <!-- end-model-doc -->
	 * @see #PAVING_VALUE
	 * @generated
	 * @ordered
	 */
	PAVING(143, "paving", "paving"),

	/**
	 * The '<em><b>Pti1924</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1924(144, "pti1924", "pti19_24"),

	/**
	 * The '<em><b>Special Event</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_24 special event.
	 * <!-- end-model-doc -->
	 * @see #SPECIAL_EVENT_VALUE
	 * @generated
	 * @ordered
	 */
	SPECIAL_EVENT(145, "specialEvent", "specialEvent"),

	/**
	 * The '<em><b>Pti1924 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1924_ALIAS1(146, "pti1924Alias1", "pti19_24_Alias_1"),

	/**
	 * The '<em><b>March</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MARCH_VALUE
	 * @generated
	 * @ordered
	 */
	MARCH(147, "march", "march"),

	/**
	 * The '<em><b>Pti1924 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1924_ALIAS2(148, "pti1924Alias2", "pti19_24_Alias_2"),

	/**
	 * The '<em><b>Procession</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROCESSION_VALUE
	 * @generated
	 * @ordered
	 */
	PROCESSION(149, "procession", "procession"),

	/**
	 * The '<em><b>Pti1924 Alias3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS3_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1924_ALIAS3(150, "pti1924Alias3", "pti19_24_Alias_3"),

	/**
	 * The '<em><b>Demonstration</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEMONSTRATION_VALUE
	 * @generated
	 * @ordered
	 */
	DEMONSTRATION(151, "demonstration", "demonstration"),

	/**
	 * The '<em><b>Pti1924 Alias4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS4_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1924_ALIAS4(152, "pti1924Alias4", "pti19_24_Alias_4"),

	/**
	 * The '<em><b>Public Disturbance</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PUBLIC_DISTURBANCE_VALUE
	 * @generated
	 * @ordered
	 */
	PUBLIC_DISTURBANCE(153, "publicDisturbance", "publicDisturbance"),

	/**
	 * The '<em><b>Pti1924 Alias5</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS5_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1924_ALIAS5(154, "pti1924Alias5", "pti19_24_Alias_5"),

	/**
	 * The '<em><b>Filter Blockade</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FILTER_BLOCKADE_VALUE
	 * @generated
	 * @ordered
	 */
	FILTER_BLOCKADE(155, "filterBlockade", "filterBlockade"),

	/**
	 * The '<em><b>Pti1924 Alias6</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS6_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1924_ALIAS6(156, "pti1924Alias6", "pti19_24_Alias_6"),

	/**
	 * The '<em><b>Sightseers Obstructing Access</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGHTSEERS_OBSTRUCTING_ACCESS_VALUE
	 * @generated
	 * @ordered
	 */
	SIGHTSEERS_OBSTRUCTING_ACCESS(157, "sightseersObstructingAccess", "sightseersObstructingAccess"),

	/**
	 * The '<em><b>Pti1924 Alias7</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS7_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1924_ALIAS7(158, "pti1924Alias7", "pti19_24_Alias_7"),

	/**
	 * The '<em><b>Holiday</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HOLIDAY_VALUE
	 * @generated
	 * @ordered
	 */
	HOLIDAY(159, "holiday", "holiday"),

	/**
	 * The '<em><b>Pti1925</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1925_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1925(160, "pti1925", "pti19_25"),

	/**
	 * The '<em><b>Bridge Strike</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_25 bridge strike.
	 * <!-- end-model-doc -->
	 * @see #BRIDGE_STRIKE_VALUE
	 * @generated
	 * @ordered
	 */
	BRIDGE_STRIKE(161, "bridgeStrike", "bridgeStrike"),

	/**
	 * The '<em><b>Pti1925 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1925_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1925_ALIAS1(162, "pti1925Alias1", "pti19_25_Alias_1"),

	/**
	 * The '<em><b>Viaduct Failure</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:25_1 viaductFailure - alias to TPEG Pti_19_24 bridgeStrike
	 * <!-- end-model-doc -->
	 * @see #VIADUCT_FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	VIADUCT_FAILURE(163, "viaductFailure", "viaductFailure"),

	/**
	 * The '<em><b>Pti1926</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1926_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1926(164, "pti1926", "pti19_26"),

	/**
	 * The '<em><b>Overhead Obstruction</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_26 overhead obstruction.
	 * <!-- end-model-doc -->
	 * @see #OVERHEAD_OBSTRUCTION_VALUE
	 * @generated
	 * @ordered
	 */
	OVERHEAD_OBSTRUCTION(165, "overheadObstruction", "overheadObstruction"),

	/**
	 * The '<em><b>Pti1927</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1927_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1927(166, "pti1927", "pti19_27"),

	/**
	 * The '<em><b>Undefined Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_255 undefined problem.
	 * <!-- end-model-doc -->
	 * @see #UNDEFINED_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	UNDEFINED_PROBLEM(167, "undefinedProblem", "undefinedProblem"),

	/**
	 * The '<em><b>Pti1915 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1915_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1915_ALIAS1(168, "pti1915Alias1", "pti19_15_Alias_1"),

	/**
	 * The '<em><b>Problems At Border Post</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROBLEMS_AT_BORDER_POST_VALUE
	 * @generated
	 * @ordered
	 */
	PROBLEMS_AT_BORDER_POST(169, "problemsAtBorderPost", "problemsAtBorderPost"),

	/**
	 * The '<em><b>Pti1915 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1915_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1915_ALIAS2(170, "pti1915Alias2", "pti19_15_Alias_2"),

	/**
	 * The '<em><b>Problems At Customs Post</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROBLEMS_AT_CUSTOMS_POST_VALUE
	 * @generated
	 * @ordered
	 */
	PROBLEMS_AT_CUSTOMS_POST(171, "problemsAtCustomsPost", "problemsAtCustomsPost"),

	/**
	 * The '<em><b>Pti1915 Alias3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1915_ALIAS3_VALUE
	 * @generated
	 * @ordered
	 */
	PTI1915_ALIAS3(172, "pti1915Alias3", "pti19_15_Alias_3"),

	/**
	 * The '<em><b>Speed Restrictions</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:255_1 speedRestrictions alias to TPEG Pti_19_15 unknown
	 * <!-- end-model-doc -->
	 * @see #SPEED_RESTRICTIONS_VALUE
	 * @generated
	 * @ordered
	 */
	SPEED_RESTRICTIONS(173, "speedRestrictions", "speedRestrictions"),

	/**
	 * The '<em><b>Pti19255 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI19255_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI19255_ALIAS1(174, "pti19255Alias1", "pti19_255_Alias_1"),

	/**
	 * The '<em><b>Logistic Problems</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:255_2 logisticProblems alias to TPEG Pti_19_15 unknown
	 * <!-- end-model-doc -->
	 * @see #LOGISTIC_PROBLEMS_VALUE
	 * @generated
	 * @ordered
	 */
	LOGISTIC_PROBLEMS(175, "logisticProblems", "logisticProblems"),

	/**
	 * The '<em><b>Pti19255 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI19255_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI19255_ALIAS2(176, "pti19255Alias2", "pti19_255_Alias_2"),

	/**
	 * The '<em><b>Problems On Local Road</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROBLEMS_ON_LOCAL_ROAD_VALUE
	 * @generated
	 * @ordered
	 */
	PROBLEMS_ON_LOCAL_ROAD(177, "problemsOnLocalRoad", "problemsOnLocalRoad");

	/**
	 * The '<em><b>Pti190</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI190
	 * @model name="pti190" literal="pti19_0"
	 * @generated
	 * @ordered
	 */
	public static final int PTI190_VALUE = 0;

	/**
	 * The '<em><b>Unknown</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_0 unknown.
	 * <!-- end-model-doc -->
	 * @see #UNKNOWN
	 * @model name="unknown"
	 * @generated
	 * @ordered
	 */
	public static final int UNKNOWN_VALUE = 1;

	/**
	 * The '<em><b>Pti1901</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1901
	 * @model name="pti1901" literal="pti19_0_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1901_VALUE = 2;

	/**
	 * The '<em><b>Previous Disturbances</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:0_1 Previous disturbances - alias to TPEG Pti_19_0 unknown
	 * <!-- end-model-doc -->
	 * @see #PREVIOUS_DISTURBANCES
	 * @model name="previousDisturbances"
	 * @generated
	 * @ordered
	 */
	public static final int PREVIOUS_DISTURBANCES_VALUE = 3;

	/**
	 * The '<em><b>Pti191</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191
	 * @model name="pti191" literal="pti19_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI191_VALUE = 4;

	/**
	 * The '<em><b>Incident</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #INCIDENT
	 * @model name="incident"
	 * @generated
	 * @ordered
	 */
	public static final int INCIDENT_VALUE = 5;

	/**
	 * The '<em><b>Pti191 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS1
	 * @model name="pti191Alias1" literal="pti19_1_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI191_ALIAS1_VALUE = 6;

	/**
	 * The '<em><b>Near Miss</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Near Miss - alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #NEAR_MISS
	 * @model name="nearMiss"
	 * @generated
	 * @ordered
	 */
	public static final int NEAR_MISS_VALUE = 7;

	/**
	 * The '<em><b>Pti191 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS2
	 * @model name="pti191Alias2" literal="pti19_1_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI191_ALIAS2_VALUE = 8;

	/**
	 * The '<em><b>Safety Violation</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Near Miss - alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #SAFETY_VIOLATION
	 * @model name="safetyViolation"
	 * @generated
	 * @ordered
	 */
	public static final int SAFETY_VIOLATION_VALUE = 9;

	/**
	 * The '<em><b>Pti191 Alias3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS3
	 * @model name="pti191Alias3" literal="pti19_1_Alias_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI191_ALIAS3_VALUE = 10;

	/**
	 * The '<em><b>Signal Passed At Danger</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Signal passed at danger - alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_PASSED_AT_DANGER
	 * @model name="signalPassedAtDanger"
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL_PASSED_AT_DANGER_VALUE = 11;

	/**
	 * The '<em><b>Pti191 Alias4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS4
	 * @model name="pti191Alias4" literal="pti19_1_Alias_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI191_ALIAS4_VALUE = 12;

	/**
	 * The '<em><b>Station Overrun</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Station overrun - alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #STATION_OVERRUN
	 * @model name="stationOverrun"
	 * @generated
	 * @ordered
	 */
	public static final int STATION_OVERRUN_VALUE = 13;

	/**
	 * The '<em><b>Pti191 Alias5</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS5
	 * @model name="pti191Alias5" literal="pti19_1_Alias_5"
	 * @generated
	 * @ordered
	 */
	public static final int PTI191_ALIAS5_VALUE = 14;

	/**
	 * The '<em><b>Train Door</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * trainDoor- alias to TPEG Pti_19_1 incident.
	 * <!-- end-model-doc -->
	 * @see #TRAIN_DOOR
	 * @model name="trainDoor"
	 * @generated
	 * @ordered
	 */
	public static final int TRAIN_DOOR_VALUE = 15;

	/**
	 * The '<em><b>Pti191 Alias6</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS6
	 * @model name="pti191Alias6" literal="pti19_1_Alias_6"
	 * @generated
	 * @ordered
	 */
	public static final int PTI191_ALIAS6_VALUE = 16;

	/**
	 * The '<em><b>Emergency Services Call</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unspecified emergency service visit. Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #EMERGENCY_SERVICES_CALL
	 * @model name="emergencyServicesCall"
	 * @generated
	 * @ordered
	 */
	public static final int EMERGENCY_SERVICES_CALL_VALUE = 17;

	/**
	 * The '<em><b>Pti192</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI192
	 * @model name="pti192" literal="pti19_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI192_VALUE = 18;

	/**
	 * The '<em><b>Bomb Explosion</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_2 bomb explosion.
	 * <!-- end-model-doc -->
	 * @see #BOMB_EXPLOSION
	 * @model name="bombExplosion"
	 * @generated
	 * @ordered
	 */
	public static final int BOMB_EXPLOSION_VALUE = 19;

	/**
	 * The '<em><b>Pti193</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193
	 * @model name="pti193" literal="pti19_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_VALUE = 20;

	/**
	 * The '<em><b>Security Alert</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #SECURITY_ALERT
	 * @model name="securityAlert"
	 * @generated
	 * @ordered
	 */
	public static final int SECURITY_ALERT_VALUE = 21;

	/**
	 * The '<em><b>Pti193 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS1
	 * @model name="pti193Alias1" literal="pti19_3_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS1_VALUE = 22;

	/**
	 * The '<em><b>Police Request</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * pti19_3_1 request of the police Alias to TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #POLICE_REQUEST
	 * @model name="policeRequest"
	 * @generated
	 * @ordered
	 */
	public static final int POLICE_REQUEST_VALUE = 23;

	/**
	 * The '<em><b>Pti193 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS2
	 * @model name="pti193Alias2" literal="pti19_3_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS2_VALUE = 24;

	/**
	 * The '<em><b>Fire Brigade Safety Checks</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * pti19_3_2 fire brigade safety checksAlias to TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #FIRE_BRIGADE_SAFETY_CHECKS
	 * @model name="fireBrigadeSafetyChecks"
	 * @generated
	 * @ordered
	 */
	public static final int FIRE_BRIGADE_SAFETY_CHECKS_VALUE = 25;

	/**
	 * The '<em><b>Pti193 Alias3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS3
	 * @model name="pti193Alias3" literal="pti19_3_Alias_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS3_VALUE = 26;

	/**
	 * The '<em><b>Unattended Bag</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * pti19_3_3 an unattended bag Talias to PEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #UNATTENDED_BAG
	 * @model name="unattendedBag"
	 * @generated
	 * @ordered
	 */
	public static final int UNATTENDED_BAG_VALUE = 27;

	/**
	 * The '<em><b>Pti193 Alias4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS4
	 * @model name="pti193Alias4" literal="pti19_3_Alias_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS4_VALUE = 28;

	/**
	 * The '<em><b>Telephoned Threat</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * telephoned threat TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #TELEPHONED_THREAT
	 * @model name="telephonedThreat"
	 * @generated
	 * @ordered
	 */
	public static final int TELEPHONED_THREAT_VALUE = 29;

	/**
	 * The '<em><b>Pti193 Alias5</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS5
	 * @model name="pti193Alias5" literal="pti19_3_Alias_5"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS5_VALUE = 30;

	/**
	 * The '<em><b>Suspect Vehicle</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * telephoned threat TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #SUSPECT_VEHICLE
	 * @model name="suspectVehicle"
	 * @generated
	 * @ordered
	 */
	public static final int SUSPECT_VEHICLE_VALUE = 31;

	/**
	 * The '<em><b>Pti193 Alias6</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS6
	 * @model name="pti193Alias6" literal="pti19_3_Alias_6"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS6_VALUE = 32;

	/**
	 * The '<em><b>Civil Emergency</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * civilEmergency alias to  TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #CIVIL_EMERGENCY
	 * @model name="civilEmergency"
	 * @generated
	 * @ordered
	 */
	public static final int CIVIL_EMERGENCY_VALUE = 33;

	/**
	 * The '<em><b>Pti193 Alias7</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS7
	 * @model name="pti193Alias7" literal="pti19_3_Alias_7"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS7_VALUE = 34;

	/**
	 * The '<em><b>Air Raid</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * civilEmergency alias to  TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #AIR_RAID
	 * @model name="airRaid"
	 * @generated
	 * @ordered
	 */
	public static final int AIR_RAID_VALUE = 35;

	/**
	 * The '<em><b>Pti193 Alias8</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS8
	 * @model name="pti193Alias8" literal="pti19_3_Alias_8"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS8_VALUE = 36;

	/**
	 * The '<em><b>Sabotage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * sabotage alias to TPEG Pti_19_3 security alert.
	 * <!-- end-model-doc -->
	 * @see #SABOTAGE
	 * @model name="sabotage"
	 * @generated
	 * @ordered
	 */
	public static final int SABOTAGE_VALUE = 37;

	/**
	 * The '<em><b>Pti193 Alias9</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS9
	 * @model name="pti193Alias9" literal="pti19_3_Alias_9"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS9_VALUE = 38;

	/**
	 * The '<em><b>Bomb Alert</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BOMB_ALERT
	 * @model name="bombAlert"
	 * @generated
	 * @ordered
	 */
	public static final int BOMB_ALERT_VALUE = 39;

	/**
	 * The '<em><b>Pti193 Alias10</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS10
	 * @model name="pti193Alias10" literal="pti19_3_Alias_10"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS10_VALUE = 40;

	/**
	 * The '<em><b>Attack</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ATTACK
	 * @model name="attack"
	 * @generated
	 * @ordered
	 */
	public static final int ATTACK_VALUE = 41;

	/**
	 * The '<em><b>Pti193 Alias11</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS11
	 * @model name="pti193Alias11" literal="pti19_3_Alias_11"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS11_VALUE = 42;

	/**
	 * The '<em><b>Evacuation</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EVACUATION
	 * @model name="evacuation"
	 * @generated
	 * @ordered
	 */
	public static final int EVACUATION_VALUE = 43;

	/**
	 * The '<em><b>Pti193 Alias12</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS12
	 * @model name="pti193Alias12" literal="pti19_3_Alias_12"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS12_VALUE = 44;

	/**
	 * The '<em><b>Terrorist Incident</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TERRORIST_INCIDENT
	 * @model name="terroristIncident"
	 * @generated
	 * @ordered
	 */
	public static final int TERRORIST_INCIDENT_VALUE = 45;

	/**
	 * The '<em><b>Pti193 Alias13</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS13
	 * @model name="pti193Alias13" literal="pti19_3_Alias_13"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS13_VALUE = 46;

	/**
	 * The '<em><b>Gunfire On Roadway</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUNFIRE_ON_ROADWAY
	 * @model name="gunfireOnRoadway"
	 * @generated
	 * @ordered
	 */
	public static final int GUNFIRE_ON_ROADWAY_VALUE = 47;

	/**
	 * The '<em><b>Pti193 Alias14</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS14
	 * @model name="pti193Alias14" literal="pti19_3_Alias_14"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS14_VALUE = 48;

	/**
	 * The '<em><b>Explosion</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPLOSION
	 * @model name="explosion"
	 * @generated
	 * @ordered
	 */
	public static final int EXPLOSION_VALUE = 49;

	/**
	 * The '<em><b>Pti193 Alias15</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS15
	 * @model name="pti193Alias15" literal="pti19_3_Alias_15"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS15_VALUE = 50;

	/**
	 * The '<em><b>Explosion Hazard</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPLOSION_HAZARD
	 * @model name="explosionHazard"
	 * @generated
	 * @ordered
	 */
	public static final int EXPLOSION_HAZARD_VALUE = 51;

	/**
	 * The '<em><b>Pti193 Alias16</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS16
	 * @model name="pti193Alias16" literal="pti19_3_Alias_16"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS16_VALUE = 52;

	/**
	 * The '<em><b>Security Incident</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SECURITY_INCIDENT
	 * @model name="securityIncident"
	 * @generated
	 * @ordered
	 */
	public static final int SECURITY_INCIDENT_VALUE = 53;

	/**
	 * The '<em><b>Pti193 Alias17</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS17
	 * @model name="pti193Alias17" literal="pti19_3_Alias_17"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS17_VALUE = 54;

	/**
	 * The '<em><b>Fire Brigade Order</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FIRE_BRIGADE_ORDER
	 * @model name="fireBrigadeOrder"
	 * @generated
	 * @ordered
	 */
	public static final int FIRE_BRIGADE_ORDER_VALUE = 55;

	/**
	 * The '<em><b>Pti193 Alias18</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI193_ALIAS18
	 * @model name="pti193Alias18" literal="pti19_3_Alias_18"
	 * @generated
	 * @ordered
	 */
	public static final int PTI193_ALIAS18_VALUE = 56;

	/**
	 * The '<em><b>Police Activity</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #POLICE_ACTIVITY
	 * @model name="policeActivity"
	 * @generated
	 * @ordered
	 */
	public static final int POLICE_ACTIVITY_VALUE = 57;

	/**
	 * The '<em><b>Pti194</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI194
	 * @model name="pti194" literal="pti19_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI194_VALUE = 58;

	/**
	 * The '<em><b>Fire</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_4 fire.
	 * <!-- end-model-doc -->
	 * @see #FIRE
	 * @model name="fire"
	 * @generated
	 * @ordered
	 */
	public static final int FIRE_VALUE = 59;

	/**
	 * The '<em><b>Pti194 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI194_ALIAS1
	 * @model name="pti194Alias1" literal="pti19_4_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI194_ALIAS1_VALUE = 60;

	/**
	 * The '<em><b>Lineside Fire</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * linesideFire alias to TPEG Pti_19_4 fire.
	 * <!-- end-model-doc -->
	 * @see #LINESIDE_FIRE
	 * @model name="linesideFire"
	 * @generated
	 * @ordered
	 */
	public static final int LINESIDE_FIRE_VALUE = 61;

	/**
	 * The '<em><b>Pti195</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195
	 * @model name="pti195" literal="pti19_5"
	 * @generated
	 * @ordered
	 */
	public static final int PTI195_VALUE = 62;

	/**
	 * The '<em><b>Vandalism</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_5 vandalism.
	 * <!-- end-model-doc -->
	 * @see #VANDALISM
	 * @model name="vandalism"
	 * @generated
	 * @ordered
	 */
	public static final int VANDALISM_VALUE = 63;

	/**
	 * The '<em><b>Pti195 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS1
	 * @model name="pti195Alias1" literal="pti19_5_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI195_ALIAS1_VALUE = 64;

	/**
	 * The '<em><b>Passenger Action</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * passengerActionAlias to pti19
	 * <!-- end-model-doc -->
	 * @see #PASSENGER_ACTION
	 * @model name="passengerAction"
	 * @generated
	 * @ordered
	 */
	public static final int PASSENGER_ACTION_VALUE = 65;

	/**
	 * The '<em><b>Pti195 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS2
	 * @model name="pti195Alias2" literal="pti19_5_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI195_ALIAS2_VALUE = 66;

	/**
	 * The '<em><b>Staff Assault</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Assault on stafft.Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #STAFF_ASSAULT
	 * @model name="staffAssault"
	 * @generated
	 * @ordered
	 */
	public static final int STAFF_ASSAULT_VALUE = 67;

	/**
	 * The '<em><b>Pti195 Alias3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS3
	 * @model name="pti195Alias3" literal="pti19_5_Alias_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI195_ALIAS3_VALUE = 68;

	/**
	 * The '<em><b>Railway Crime</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Railway Crime Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #RAILWAY_CRIME
	 * @model name="railwayCrime"
	 * @generated
	 * @ordered
	 */
	public static final int RAILWAY_CRIME_VALUE = 69;

	/**
	 * The '<em><b>Pti195 Alias4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS4
	 * @model name="pti195Alias4" literal="pti19_5_Alias_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI195_ALIAS4_VALUE = 70;

	/**
	 * The '<em><b>Assault</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Assault Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #ASSAULT
	 * @model name="assault"
	 * @generated
	 * @ordered
	 */
	public static final int ASSAULT_VALUE = 71;

	/**
	 * The '<em><b>Pti195 Alias5</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI195_ALIAS5
	 * @model name="pti195Alias5" literal="pti19_5_Alias_5"
	 * @generated
	 * @ordered
	 */
	public static final int PTI195_ALIAS5_VALUE = 72;

	/**
	 * The '<em><b>Theft</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Theft Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #THEFT
	 * @model name="theft"
	 * @generated
	 * @ordered
	 */
	public static final int THEFT_VALUE = 73;

	/**
	 * The '<em><b>Altercation</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * altercation . Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #ALTERCATION
	 * @model name="altercation"
	 * @generated
	 * @ordered
	 */
	public static final int ALTERCATION_VALUE = 75;

	/**
	 * The '<em><b>Pti191 Alias7</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI191_ALIAS7
	 * @model name="pti191Alias7" literal="pti19_1_Alias_7"
	 * @generated
	 * @ordered
	 */
	public static final int PTI191_ALIAS7_VALUE = 76;

	/**
	 * The '<em><b>Ill Vehicle Occupants</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * illVehicleOccupants . Alias to pti19
	 * <!-- end-model-doc -->
	 * @see #ILL_VEHICLE_OCCUPANTS
	 * @model name="illVehicleOccupants"
	 * @generated
	 * @ordered
	 */
	public static final int ILL_VEHICLE_OCCUPANTS_VALUE = 77;

	/**
	 * The '<em><b>Pti196</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196
	 * @model name="pti196" literal="pti19_6"
	 * @generated
	 * @ordered
	 */
	public static final int PTI196_VALUE = 78;

	/**
	 * The '<em><b>Accident</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #ACCIDENT
	 * @model name="accident"
	 * @generated
	 * @ordered
	 */
	public static final int ACCIDENT_VALUE = 79;

	/**
	 * The '<em><b>Pti196 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS1
	 * @model name="pti196Alias1" literal="pti19_6_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI196_ALIAS1_VALUE = 80;

	/**
	 * The '<em><b>Fatality</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * fatality alias to TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #FATALITY
	 * @model name="fatality"
	 * @generated
	 * @ordered
	 */
	public static final int FATALITY_VALUE = 81;

	/**
	 * The '<em><b>Pti196 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS2
	 * @model name="pti196Alias2" literal="pti19_6_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI196_ALIAS2_VALUE = 82;

	/**
	 * The '<em><b>Person Under Train</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * a person under a train - alias to TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #PERSON_UNDER_TRAIN
	 * @model name="personUnderTrain"
	 * @generated
	 * @ordered
	 */
	public static final int PERSON_UNDER_TRAIN_VALUE = 83;

	/**
	 * The '<em><b>Pti196 Alias3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS3
	 * @model name="pti196Alias3" literal="pti19_6_Alias_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI196_ALIAS3_VALUE = 84;

	/**
	 * The '<em><b>Person Hit By Train</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * a person hit by a train - alias to TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #PERSON_HIT_BY_TRAIN
	 * @model name="personHitByTrain"
	 * @generated
	 * @ordered
	 */
	public static final int PERSON_HIT_BY_TRAIN_VALUE = 85;

	/**
	 * The '<em><b>Pti196 Alias4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS4
	 * @model name="pti196Alias4" literal="pti19_6_Alias_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI196_ALIAS4_VALUE = 86;

	/**
	 * The '<em><b>Person Ill On Vehicle</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * person ill On Vehicle -Alias to pti19_6
	 * <!-- end-model-doc -->
	 * @see #PERSON_ILL_ON_VEHICLE
	 * @model name="personIllOnVehicle"
	 * @generated
	 * @ordered
	 */
	public static final int PERSON_ILL_ON_VEHICLE_VALUE = 87;

	/**
	 * The '<em><b>Pti196 Alias5</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS5
	 * @model name="pti196Alias5" literal="pti19_6_Alias_5"
	 * @generated
	 * @ordered
	 */
	public static final int PTI196_ALIAS5_VALUE = 88;

	/**
	 * The '<em><b>Emergency Services</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * emergencyServices - alias to TPEG Pti_19_6 accident.
	 * <!-- end-model-doc -->
	 * @see #EMERGENCY_SERVICES
	 * @model name="emergencyServices"
	 * @generated
	 * @ordered
	 */
	public static final int EMERGENCY_SERVICES_VALUE = 89;

	/**
	 * The '<em><b>Pti196 Alias6</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI196_ALIAS6
	 * @model name="pti196Alias6" literal="pti19_6_Alias_6"
	 * @generated
	 * @ordered
	 */
	public static final int PTI196_ALIAS6_VALUE = 90;

	/**
	 * The '<em><b>Collision</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collision - Alias to pti19_6
	 * <!-- end-model-doc -->
	 * @see #COLLISION
	 * @model name="collision"
	 * @generated
	 * @ordered
	 */
	public static final int COLLISION_VALUE = 91;

	/**
	 * The '<em><b>Pti197</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI197
	 * @model name="pti197" literal="pti19_7"
	 * @generated
	 * @ordered
	 */
	public static final int PTI197_VALUE = 92;

	/**
	 * The '<em><b>Overcrowded</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_7 overcrowded.
	 * <!-- end-model-doc -->
	 * @see #OVERCROWDED
	 * @model name="overcrowded"
	 * @generated
	 * @ordered
	 */
	public static final int OVERCROWDED_VALUE = 93;

	/**
	 * The '<em><b>Pti198</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI198
	 * @model name="pti198" literal="pti19_8"
	 * @generated
	 * @ordered
	 */
	public static final int PTI198_VALUE = 94;

	/**
	 * The '<em><b>Insufficient Demand</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_8 insufficient demand.
	 * <!-- end-model-doc -->
	 * @see #INSUFFICIENT_DEMAND
	 * @model name="insufficientDemand"
	 * @generated
	 * @ordered
	 */
	public static final int INSUFFICIENT_DEMAND_VALUE = 95;

	/**
	 * The '<em><b>Pti199</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI199
	 * @model name="pti199" literal="pti19_9"
	 * @generated
	 * @ordered
	 */
	public static final int PTI199_VALUE = 96;

	/**
	 * The '<em><b>Lighting Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_9 lighting failure.
	 * <!-- end-model-doc -->
	 * @see #LIGHTING_FAILURE
	 * @model name="lightingFailure"
	 * @generated
	 * @ordered
	 */
	public static final int LIGHTING_FAILURE_VALUE = 97;

	/**
	 * The '<em><b>Pti1910</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1910
	 * @model name="pti1910" literal="pti19_10"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1910_VALUE = 98;

	/**
	 * The '<em><b>Leader Board Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_10 leader board failure.
	 * <!-- end-model-doc -->
	 * @see #LEADER_BOARD_FAILURE
	 * @model name="leaderBoardFailure"
	 * @generated
	 * @ordered
	 */
	public static final int LEADER_BOARD_FAILURE_VALUE = 99;

	/**
	 * The '<em><b>Pti1911</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1911
	 * @model name="pti1911" literal="pti19_11"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1911_VALUE = 100;

	/**
	 * The '<em><b>Service Indicator Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_11 service indicator failure.
	 * <!-- end-model-doc -->
	 * @see #SERVICE_INDICATOR_FAILURE
	 * @model name="serviceIndicatorFailure"
	 * @generated
	 * @ordered
	 */
	public static final int SERVICE_INDICATOR_FAILURE_VALUE = 101;

	/**
	 * The '<em><b>Pti1912</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1912
	 * @model name="pti1912" literal="pti19_12"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1912_VALUE = 102;

	/**
	 * The '<em><b>Service Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_12 service failure.
	 * <!-- end-model-doc -->
	 * @see #SERVICE_FAILURE
	 * @model name="serviceFailure"
	 * @generated
	 * @ordered
	 */
	public static final int SERVICE_FAILURE_VALUE = 103;

	/**
	 * The '<em><b>Pti1913</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1913
	 * @model name="pti1913" literal="pti19_13"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1913_VALUE = 104;

	/**
	 * The '<em><b>Operator Ceased Trading</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_13 OPERATOR ceased trading.
	 * <!-- end-model-doc -->
	 * @see #OPERATOR_CEASED_TRADING
	 * @model name="operatorCeasedTrading"
	 * @generated
	 * @ordered
	 */
	public static final int OPERATOR_CEASED_TRADING_VALUE = 105;

	/**
	 * The '<em><b>Pti1914</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1914
	 * @model name="pti1914" literal="pti19_14"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1914_VALUE = 106;

	/**
	 * The '<em><b>Operator Suspended</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_14 OPERATOR suspended.
	 * <!-- end-model-doc -->
	 * @see #OPERATOR_SUSPENDED
	 * @model name="operatorSuspended"
	 * @generated
	 * @ordered
	 */
	public static final int OPERATOR_SUSPENDED_VALUE = 107;

	/**
	 * The '<em><b>Pti1915</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1915
	 * @model name="pti1915" literal="pti19_15"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1915_VALUE = 108;

	/**
	 * The '<em><b>Congestion</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_15 congestion.
	 * <!-- end-model-doc -->
	 * @see #CONGESTION
	 * @model name="congestion"
	 * @generated
	 * @ordered
	 */
	public static final int CONGESTION_VALUE = 109;

	/**
	 * The '<em><b>Pti1916</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1916
	 * @model name="pti1916" literal="pti19_16"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1916_VALUE = 110;

	/**
	 * The '<em><b>Route Blockage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_16 route blockage.
	 * <!-- end-model-doc -->
	 * @see #ROUTE_BLOCKAGE
	 * @model name="routeBlockage"
	 * @generated
	 * @ordered
	 */
	public static final int ROUTE_BLOCKAGE_VALUE = 111;

	/**
	 * The '<em><b>Pti1917</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1917
	 * @model name="pti1917" literal="pti19_17"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1917_VALUE = 112;

	/**
	 * The '<em><b>Person On The Line</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_17 person on the line.
	 * <!-- end-model-doc -->
	 * @see #PERSON_ON_THE_LINE
	 * @model name="personOnTheLine"
	 * @generated
	 * @ordered
	 */
	public static final int PERSON_ON_THE_LINE_VALUE = 113;

	/**
	 * The '<em><b>Pti1918</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1918
	 * @model name="pti1918" literal="pti19_18"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1918_VALUE = 114;

	/**
	 * The '<em><b>Vehicle On The Line</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_18 VEHICLE on the line.
	 * <!-- end-model-doc -->
	 * @see #VEHICLE_ON_THE_LINE
	 * @model name="vehicleOnTheLine"
	 * @generated
	 * @ordered
	 */
	public static final int VEHICLE_ON_THE_LINE_VALUE = 115;

	/**
	 * The '<em><b>Pti1918 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1918_ALIAS1
	 * @model name="pti1918Alias1" literal="pti19_18_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1918_ALIAS1_VALUE = 116;

	/**
	 * The '<em><b>Level Crossing Incident</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Level Crossing Incident - alias to TPEG Pti_19_18 VEHICLE on the line.
	 * <!-- end-model-doc -->
	 * @see #LEVEL_CROSSING_INCIDENT
	 * @model name="levelCrossingIncident"
	 * @generated
	 * @ordered
	 */
	public static final int LEVEL_CROSSING_INCIDENT_VALUE = 117;

	/**
	 * The '<em><b>Pti1919</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919
	 * @model name="pti1919" literal="pti19_19"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1919_VALUE = 118;

	/**
	 * The '<em><b>Object On The Line</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #OBJECT_ON_THE_LINE
	 * @model name="objectOnTheLine"
	 * @generated
	 * @ordered
	 */
	public static final int OBJECT_ON_THE_LINE_VALUE = 119;

	/**
	 * The '<em><b>Pti1919 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919_ALIAS1
	 * @model name="pti1919Alias1" literal="pti19_19_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1919_ALIAS1_VALUE = 120;

	/**
	 * The '<em><b>Fallen Tree On The Line</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * fallen tree on line- alias to TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #FALLEN_TREE_ON_THE_LINE
	 * @model name="fallenTreeOnTheLine"
	 * @generated
	 * @ordered
	 */
	public static final int FALLEN_TREE_ON_THE_LINE_VALUE = 121;

	/**
	 * The '<em><b>Pti1919 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919_ALIAS2
	 * @model name="pti1919Alias2" literal="pti19_19_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1919_ALIAS2_VALUE = 122;

	/**
	 * The '<em><b>Vegetation</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * vegetation - alias to TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #VEGETATION
	 * @model name="vegetation"
	 * @generated
	 * @ordered
	 */
	public static final int VEGETATION_VALUE = 123;

	/**
	 * The '<em><b>Pti1919 Alias3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919_ALIAS3
	 * @model name="pti1919Alias3" literal="pti19_19_Alias_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1919_ALIAS3_VALUE = 124;

	/**
	 * The '<em><b>Train Struck Animal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Train struck animal alias to TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #TRAIN_STRUCK_ANIMAL
	 * @model name="trainStruckAnimal"
	 * @generated
	 * @ordered
	 */
	public static final int TRAIN_STRUCK_ANIMAL_VALUE = 125;

	/**
	 * The '<em><b>Pti1919 Alias4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1919_ALIAS4
	 * @model name="pti1919Alias4" literal="pti19_19_Alias_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1919_ALIAS4_VALUE = 126;

	/**
	 * The '<em><b>Train Struck Object</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Train struck object alias to TPEG Pti_19_19 object on the line.
	 * <!-- end-model-doc -->
	 * @see #TRAIN_STRUCK_OBJECT
	 * @model name="trainStruckObject"
	 * @generated
	 * @ordered
	 */
	public static final int TRAIN_STRUCK_OBJECT_VALUE = 127;

	/**
	 * The '<em><b>Pti1920</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1920
	 * @model name="pti1920" literal="pti19_20"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1920_VALUE = 128;

	/**
	 * The '<em><b>Animal On The Line</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_20 animal on the line.
	 * <!-- end-model-doc -->
	 * @see #ANIMAL_ON_THE_LINE
	 * @model name="animalOnTheLine"
	 * @generated
	 * @ordered
	 */
	public static final int ANIMAL_ON_THE_LINE_VALUE = 129;

	/**
	 * The '<em><b>Pti1921</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1921
	 * @model name="pti1921" literal="pti19_21"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1921_VALUE = 130;

	/**
	 * The '<em><b>Route Diversion</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_21 route diversion.
	 * <!-- end-model-doc -->
	 * @see #ROUTE_DIVERSION
	 * @model name="routeDiversion"
	 * @generated
	 * @ordered
	 */
	public static final int ROUTE_DIVERSION_VALUE = 131;

	/**
	 * The '<em><b>Pti1922</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1922
	 * @model name="pti1922" literal="pti19_22"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1922_VALUE = 132;

	/**
	 * The '<em><b>Road Closed</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_22 road closed.
	 * <!-- end-model-doc -->
	 * @see #ROAD_CLOSED
	 * @model name="roadClosed"
	 * @generated
	 * @ordered
	 */
	public static final int ROAD_CLOSED_VALUE = 133;

	/**
	 * The '<em><b>Pti1923</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923
	 * @model name="pti1923" literal="pti19_23"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1923_VALUE = 134;

	/**
	 * The '<em><b>Roadworks</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_23 roadworks.
	 * <!-- end-model-doc -->
	 * @see #ROADWORKS
	 * @model name="roadworks"
	 * @generated
	 * @ordered
	 */
	public static final int ROADWORKS_VALUE = 135;

	/**
	 * The '<em><b>Pti1923 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923_ALIAS1
	 * @model name="pti1923Alias1" literal="pti19_23_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1923_ALIAS1_VALUE = 136;

	/**
	 * The '<em><b>Sewerage Maintenance</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:23_1 sewerageMaintenance - alias to TPEG Pti_19_23 roadworks..
	 * <!-- end-model-doc -->
	 * @see #SEWERAGE_MAINTENANCE
	 * @model name="sewerageMaintenance"
	 * @generated
	 * @ordered
	 */
	public static final int SEWERAGE_MAINTENANCE_VALUE = 137;

	/**
	 * The '<em><b>Pti1923 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923_ALIAS2
	 * @model name="pti1923Alias2" literal="pti19_23_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1923_ALIAS2_VALUE = 138;

	/**
	 * The '<em><b>Road Maintenance</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:23_2 roadMaintenance - alias to TPEG Pti_19_23 roadworks..
	 * <!-- end-model-doc -->
	 * @see #ROAD_MAINTENANCE
	 * @model name="roadMaintenance"
	 * @generated
	 * @ordered
	 */
	public static final int ROAD_MAINTENANCE_VALUE = 139;

	/**
	 * The '<em><b>Pti1923 Alias3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923_ALIAS3
	 * @model name="pti1923Alias3" literal="pti19_23_Alias_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1923_ALIAS3_VALUE = 140;

	/**
	 * The '<em><b>Asphalting</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:23_3 asphalting - alias to TPEG Pti_19_23 roadworks..
	 * <!-- end-model-doc -->
	 * @see #ASPHALTING
	 * @model name="asphalting"
	 * @generated
	 * @ordered
	 */
	public static final int ASPHALTING_VALUE = 141;

	/**
	 * The '<em><b>Pti1923 Alias4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1923_ALIAS4
	 * @model name="pti1923Alias4" literal="pti19_23_Alias_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1923_ALIAS4_VALUE = 142;

	/**
	 * The '<em><b>Paving</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:23_4 paving - alias to TPEG Pti_19_23 roadworks..
	 * <!-- end-model-doc -->
	 * @see #PAVING
	 * @model name="paving"
	 * @generated
	 * @ordered
	 */
	public static final int PAVING_VALUE = 143;

	/**
	 * The '<em><b>Pti1924</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924
	 * @model name="pti1924" literal="pti19_24"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1924_VALUE = 144;

	/**
	 * The '<em><b>Special Event</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_24 special event.
	 * <!-- end-model-doc -->
	 * @see #SPECIAL_EVENT
	 * @model name="specialEvent"
	 * @generated
	 * @ordered
	 */
	public static final int SPECIAL_EVENT_VALUE = 145;

	/**
	 * The '<em><b>Pti1924 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS1
	 * @model name="pti1924Alias1" literal="pti19_24_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1924_ALIAS1_VALUE = 146;

	/**
	 * The '<em><b>March</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MARCH
	 * @model name="march"
	 * @generated
	 * @ordered
	 */
	public static final int MARCH_VALUE = 147;

	/**
	 * The '<em><b>Pti1924 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS2
	 * @model name="pti1924Alias2" literal="pti19_24_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1924_ALIAS2_VALUE = 148;

	/**
	 * The '<em><b>Procession</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROCESSION
	 * @model name="procession"
	 * @generated
	 * @ordered
	 */
	public static final int PROCESSION_VALUE = 149;

	/**
	 * The '<em><b>Pti1924 Alias3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS3
	 * @model name="pti1924Alias3" literal="pti19_24_Alias_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1924_ALIAS3_VALUE = 150;

	/**
	 * The '<em><b>Demonstration</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEMONSTRATION
	 * @model name="demonstration"
	 * @generated
	 * @ordered
	 */
	public static final int DEMONSTRATION_VALUE = 151;

	/**
	 * The '<em><b>Pti1924 Alias4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS4
	 * @model name="pti1924Alias4" literal="pti19_24_Alias_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1924_ALIAS4_VALUE = 152;

	/**
	 * The '<em><b>Public Disturbance</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PUBLIC_DISTURBANCE
	 * @model name="publicDisturbance"
	 * @generated
	 * @ordered
	 */
	public static final int PUBLIC_DISTURBANCE_VALUE = 153;

	/**
	 * The '<em><b>Pti1924 Alias5</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS5
	 * @model name="pti1924Alias5" literal="pti19_24_Alias_5"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1924_ALIAS5_VALUE = 154;

	/**
	 * The '<em><b>Filter Blockade</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FILTER_BLOCKADE
	 * @model name="filterBlockade"
	 * @generated
	 * @ordered
	 */
	public static final int FILTER_BLOCKADE_VALUE = 155;

	/**
	 * The '<em><b>Pti1924 Alias6</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS6
	 * @model name="pti1924Alias6" literal="pti19_24_Alias_6"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1924_ALIAS6_VALUE = 156;

	/**
	 * The '<em><b>Sightseers Obstructing Access</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGHTSEERS_OBSTRUCTING_ACCESS
	 * @model name="sightseersObstructingAccess"
	 * @generated
	 * @ordered
	 */
	public static final int SIGHTSEERS_OBSTRUCTING_ACCESS_VALUE = 157;

	/**
	 * The '<em><b>Pti1924 Alias7</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1924_ALIAS7
	 * @model name="pti1924Alias7" literal="pti19_24_Alias_7"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1924_ALIAS7_VALUE = 158;

	/**
	 * The '<em><b>Holiday</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HOLIDAY
	 * @model name="holiday"
	 * @generated
	 * @ordered
	 */
	public static final int HOLIDAY_VALUE = 159;

	/**
	 * The '<em><b>Pti1925</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1925
	 * @model name="pti1925" literal="pti19_25"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1925_VALUE = 160;

	/**
	 * The '<em><b>Bridge Strike</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_25 bridge strike.
	 * <!-- end-model-doc -->
	 * @see #BRIDGE_STRIKE
	 * @model name="bridgeStrike"
	 * @generated
	 * @ordered
	 */
	public static final int BRIDGE_STRIKE_VALUE = 161;

	/**
	 * The '<em><b>Pti1925 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1925_ALIAS1
	 * @model name="pti1925Alias1" literal="pti19_25_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1925_ALIAS1_VALUE = 162;

	/**
	 * The '<em><b>Viaduct Failure</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:25_1 viaductFailure - alias to TPEG Pti_19_24 bridgeStrike
	 * <!-- end-model-doc -->
	 * @see #VIADUCT_FAILURE
	 * @model name="viaductFailure"
	 * @generated
	 * @ordered
	 */
	public static final int VIADUCT_FAILURE_VALUE = 163;

	/**
	 * The '<em><b>Pti1926</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1926
	 * @model name="pti1926" literal="pti19_26"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1926_VALUE = 164;

	/**
	 * The '<em><b>Overhead Obstruction</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_26 overhead obstruction.
	 * <!-- end-model-doc -->
	 * @see #OVERHEAD_OBSTRUCTION
	 * @model name="overheadObstruction"
	 * @generated
	 * @ordered
	 */
	public static final int OVERHEAD_OBSTRUCTION_VALUE = 165;

	/**
	 * The '<em><b>Pti1927</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1927
	 * @model name="pti1927" literal="pti19_27"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1927_VALUE = 166;

	/**
	 * The '<em><b>Undefined Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti_19_255 undefined problem.
	 * <!-- end-model-doc -->
	 * @see #UNDEFINED_PROBLEM
	 * @model name="undefinedProblem"
	 * @generated
	 * @ordered
	 */
	public static final int UNDEFINED_PROBLEM_VALUE = 167;

	/**
	 * The '<em><b>Pti1915 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1915_ALIAS1
	 * @model name="pti1915Alias1" literal="pti19_15_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1915_ALIAS1_VALUE = 168;

	/**
	 * The '<em><b>Problems At Border Post</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROBLEMS_AT_BORDER_POST
	 * @model name="problemsAtBorderPost"
	 * @generated
	 * @ordered
	 */
	public static final int PROBLEMS_AT_BORDER_POST_VALUE = 169;

	/**
	 * The '<em><b>Pti1915 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1915_ALIAS2
	 * @model name="pti1915Alias2" literal="pti19_15_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1915_ALIAS2_VALUE = 170;

	/**
	 * The '<em><b>Problems At Customs Post</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROBLEMS_AT_CUSTOMS_POST
	 * @model name="problemsAtCustomsPost"
	 * @generated
	 * @ordered
	 */
	public static final int PROBLEMS_AT_CUSTOMS_POST_VALUE = 171;

	/**
	 * The '<em><b>Pti1915 Alias3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI1915_ALIAS3
	 * @model name="pti1915Alias3" literal="pti19_15_Alias_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI1915_ALIAS3_VALUE = 172;

	/**
	 * The '<em><b>Speed Restrictions</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:255_1 speedRestrictions alias to TPEG Pti_19_15 unknown
	 * <!-- end-model-doc -->
	 * @see #SPEED_RESTRICTIONS
	 * @model name="speedRestrictions"
	 * @generated
	 * @ordered
	 */
	public static final int SPEED_RESTRICTIONS_VALUE = 173;

	/**
	 * The '<em><b>Pti19255 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI19255_ALIAS1
	 * @model name="pti19255Alias1" literal="pti19_255_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI19255_ALIAS1_VALUE = 174;

	/**
	 * The '<em><b>Logistic Problems</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 19:255_2 logisticProblems alias to TPEG Pti_19_15 unknown
	 * <!-- end-model-doc -->
	 * @see #LOGISTIC_PROBLEMS
	 * @model name="logisticProblems"
	 * @generated
	 * @ordered
	 */
	public static final int LOGISTIC_PROBLEMS_VALUE = 175;

	/**
	 * The '<em><b>Pti19255 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI19255_ALIAS2
	 * @model name="pti19255Alias2" literal="pti19_255_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI19255_ALIAS2_VALUE = 176;

	/**
	 * The '<em><b>Problems On Local Road</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROBLEMS_ON_LOCAL_ROAD
	 * @model name="problemsOnLocalRoad"
	 * @generated
	 * @ordered
	 */
	public static final int PROBLEMS_ON_LOCAL_ROAD_VALUE = 177;

	/**
	 * An array of all the '<em><b>Miscellaneous Reason Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final MiscellaneousReasonEnumeration[] VALUES_ARRAY =
		new MiscellaneousReasonEnumeration[] {
			PTI190,
			UNKNOWN,
			PTI1901,
			PREVIOUS_DISTURBANCES,
			PTI191,
			INCIDENT,
			PTI191_ALIAS1,
			NEAR_MISS,
			PTI191_ALIAS2,
			SAFETY_VIOLATION,
			PTI191_ALIAS3,
			SIGNAL_PASSED_AT_DANGER,
			PTI191_ALIAS4,
			STATION_OVERRUN,
			PTI191_ALIAS5,
			TRAIN_DOOR,
			PTI191_ALIAS6,
			EMERGENCY_SERVICES_CALL,
			PTI192,
			BOMB_EXPLOSION,
			PTI193,
			SECURITY_ALERT,
			PTI193_ALIAS1,
			POLICE_REQUEST,
			PTI193_ALIAS2,
			FIRE_BRIGADE_SAFETY_CHECKS,
			PTI193_ALIAS3,
			UNATTENDED_BAG,
			PTI193_ALIAS4,
			TELEPHONED_THREAT,
			PTI193_ALIAS5,
			SUSPECT_VEHICLE,
			PTI193_ALIAS6,
			CIVIL_EMERGENCY,
			PTI193_ALIAS7,
			AIR_RAID,
			PTI193_ALIAS8,
			SABOTAGE,
			PTI193_ALIAS9,
			BOMB_ALERT,
			PTI193_ALIAS10,
			ATTACK,
			PTI193_ALIAS11,
			EVACUATION,
			PTI193_ALIAS12,
			TERRORIST_INCIDENT,
			PTI193_ALIAS13,
			GUNFIRE_ON_ROADWAY,
			PTI193_ALIAS14,
			EXPLOSION,
			PTI193_ALIAS15,
			EXPLOSION_HAZARD,
			PTI193_ALIAS16,
			SECURITY_INCIDENT,
			PTI193_ALIAS17,
			FIRE_BRIGADE_ORDER,
			PTI193_ALIAS18,
			POLICE_ACTIVITY,
			PTI194,
			FIRE,
			PTI194_ALIAS1,
			LINESIDE_FIRE,
			PTI195,
			VANDALISM,
			PTI195_ALIAS1,
			PASSENGER_ACTION,
			PTI195_ALIAS2,
			STAFF_ASSAULT,
			PTI195_ALIAS3,
			RAILWAY_CRIME,
			PTI195_ALIAS4,
			ASSAULT,
			PTI195_ALIAS5,
			THEFT,
			ALTERCATION,
			PTI191_ALIAS7,
			ILL_VEHICLE_OCCUPANTS,
			PTI196,
			ACCIDENT,
			PTI196_ALIAS1,
			FATALITY,
			PTI196_ALIAS2,
			PERSON_UNDER_TRAIN,
			PTI196_ALIAS3,
			PERSON_HIT_BY_TRAIN,
			PTI196_ALIAS4,
			PERSON_ILL_ON_VEHICLE,
			PTI196_ALIAS5,
			EMERGENCY_SERVICES,
			PTI196_ALIAS6,
			COLLISION,
			PTI197,
			OVERCROWDED,
			PTI198,
			INSUFFICIENT_DEMAND,
			PTI199,
			LIGHTING_FAILURE,
			PTI1910,
			LEADER_BOARD_FAILURE,
			PTI1911,
			SERVICE_INDICATOR_FAILURE,
			PTI1912,
			SERVICE_FAILURE,
			PTI1913,
			OPERATOR_CEASED_TRADING,
			PTI1914,
			OPERATOR_SUSPENDED,
			PTI1915,
			CONGESTION,
			PTI1916,
			ROUTE_BLOCKAGE,
			PTI1917,
			PERSON_ON_THE_LINE,
			PTI1918,
			VEHICLE_ON_THE_LINE,
			PTI1918_ALIAS1,
			LEVEL_CROSSING_INCIDENT,
			PTI1919,
			OBJECT_ON_THE_LINE,
			PTI1919_ALIAS1,
			FALLEN_TREE_ON_THE_LINE,
			PTI1919_ALIAS2,
			VEGETATION,
			PTI1919_ALIAS3,
			TRAIN_STRUCK_ANIMAL,
			PTI1919_ALIAS4,
			TRAIN_STRUCK_OBJECT,
			PTI1920,
			ANIMAL_ON_THE_LINE,
			PTI1921,
			ROUTE_DIVERSION,
			PTI1922,
			ROAD_CLOSED,
			PTI1923,
			ROADWORKS,
			PTI1923_ALIAS1,
			SEWERAGE_MAINTENANCE,
			PTI1923_ALIAS2,
			ROAD_MAINTENANCE,
			PTI1923_ALIAS3,
			ASPHALTING,
			PTI1923_ALIAS4,
			PAVING,
			PTI1924,
			SPECIAL_EVENT,
			PTI1924_ALIAS1,
			MARCH,
			PTI1924_ALIAS2,
			PROCESSION,
			PTI1924_ALIAS3,
			DEMONSTRATION,
			PTI1924_ALIAS4,
			PUBLIC_DISTURBANCE,
			PTI1924_ALIAS5,
			FILTER_BLOCKADE,
			PTI1924_ALIAS6,
			SIGHTSEERS_OBSTRUCTING_ACCESS,
			PTI1924_ALIAS7,
			HOLIDAY,
			PTI1925,
			BRIDGE_STRIKE,
			PTI1925_ALIAS1,
			VIADUCT_FAILURE,
			PTI1926,
			OVERHEAD_OBSTRUCTION,
			PTI1927,
			UNDEFINED_PROBLEM,
			PTI1915_ALIAS1,
			PROBLEMS_AT_BORDER_POST,
			PTI1915_ALIAS2,
			PROBLEMS_AT_CUSTOMS_POST,
			PTI1915_ALIAS3,
			SPEED_RESTRICTIONS,
			PTI19255_ALIAS1,
			LOGISTIC_PROBLEMS,
			PTI19255_ALIAS2,
			PROBLEMS_ON_LOCAL_ROAD,
		};

	/**
	 * A public read-only list of all the '<em><b>Miscellaneous Reason Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<MiscellaneousReasonEnumeration> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Miscellaneous Reason Enumeration</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static MiscellaneousReasonEnumeration get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			MiscellaneousReasonEnumeration result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Miscellaneous Reason Enumeration</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static MiscellaneousReasonEnumeration getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			MiscellaneousReasonEnumeration result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Miscellaneous Reason Enumeration</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static MiscellaneousReasonEnumeration get(int value) {
		switch (value) {
			case PTI190_VALUE: return PTI190;
			case UNKNOWN_VALUE: return UNKNOWN;
			case PTI1901_VALUE: return PTI1901;
			case PREVIOUS_DISTURBANCES_VALUE: return PREVIOUS_DISTURBANCES;
			case PTI191_VALUE: return PTI191;
			case INCIDENT_VALUE: return INCIDENT;
			case PTI191_ALIAS1_VALUE: return PTI191_ALIAS1;
			case NEAR_MISS_VALUE: return NEAR_MISS;
			case PTI191_ALIAS2_VALUE: return PTI191_ALIAS2;
			case SAFETY_VIOLATION_VALUE: return SAFETY_VIOLATION;
			case PTI191_ALIAS3_VALUE: return PTI191_ALIAS3;
			case SIGNAL_PASSED_AT_DANGER_VALUE: return SIGNAL_PASSED_AT_DANGER;
			case PTI191_ALIAS4_VALUE: return PTI191_ALIAS4;
			case STATION_OVERRUN_VALUE: return STATION_OVERRUN;
			case PTI191_ALIAS5_VALUE: return PTI191_ALIAS5;
			case TRAIN_DOOR_VALUE: return TRAIN_DOOR;
			case PTI191_ALIAS6_VALUE: return PTI191_ALIAS6;
			case EMERGENCY_SERVICES_CALL_VALUE: return EMERGENCY_SERVICES_CALL;
			case PTI192_VALUE: return PTI192;
			case BOMB_EXPLOSION_VALUE: return BOMB_EXPLOSION;
			case PTI193_VALUE: return PTI193;
			case SECURITY_ALERT_VALUE: return SECURITY_ALERT;
			case PTI193_ALIAS1_VALUE: return PTI193_ALIAS1;
			case POLICE_REQUEST_VALUE: return POLICE_REQUEST;
			case PTI193_ALIAS2_VALUE: return PTI193_ALIAS2;
			case FIRE_BRIGADE_SAFETY_CHECKS_VALUE: return FIRE_BRIGADE_SAFETY_CHECKS;
			case PTI193_ALIAS3_VALUE: return PTI193_ALIAS3;
			case UNATTENDED_BAG_VALUE: return UNATTENDED_BAG;
			case PTI193_ALIAS4_VALUE: return PTI193_ALIAS4;
			case TELEPHONED_THREAT_VALUE: return TELEPHONED_THREAT;
			case PTI193_ALIAS5_VALUE: return PTI193_ALIAS5;
			case SUSPECT_VEHICLE_VALUE: return SUSPECT_VEHICLE;
			case PTI193_ALIAS6_VALUE: return PTI193_ALIAS6;
			case CIVIL_EMERGENCY_VALUE: return CIVIL_EMERGENCY;
			case PTI193_ALIAS7_VALUE: return PTI193_ALIAS7;
			case AIR_RAID_VALUE: return AIR_RAID;
			case PTI193_ALIAS8_VALUE: return PTI193_ALIAS8;
			case SABOTAGE_VALUE: return SABOTAGE;
			case PTI193_ALIAS9_VALUE: return PTI193_ALIAS9;
			case BOMB_ALERT_VALUE: return BOMB_ALERT;
			case PTI193_ALIAS10_VALUE: return PTI193_ALIAS10;
			case ATTACK_VALUE: return ATTACK;
			case PTI193_ALIAS11_VALUE: return PTI193_ALIAS11;
			case EVACUATION_VALUE: return EVACUATION;
			case PTI193_ALIAS12_VALUE: return PTI193_ALIAS12;
			case TERRORIST_INCIDENT_VALUE: return TERRORIST_INCIDENT;
			case PTI193_ALIAS13_VALUE: return PTI193_ALIAS13;
			case GUNFIRE_ON_ROADWAY_VALUE: return GUNFIRE_ON_ROADWAY;
			case PTI193_ALIAS14_VALUE: return PTI193_ALIAS14;
			case EXPLOSION_VALUE: return EXPLOSION;
			case PTI193_ALIAS15_VALUE: return PTI193_ALIAS15;
			case EXPLOSION_HAZARD_VALUE: return EXPLOSION_HAZARD;
			case PTI193_ALIAS16_VALUE: return PTI193_ALIAS16;
			case SECURITY_INCIDENT_VALUE: return SECURITY_INCIDENT;
			case PTI193_ALIAS17_VALUE: return PTI193_ALIAS17;
			case FIRE_BRIGADE_ORDER_VALUE: return FIRE_BRIGADE_ORDER;
			case PTI193_ALIAS18_VALUE: return PTI193_ALIAS18;
			case POLICE_ACTIVITY_VALUE: return POLICE_ACTIVITY;
			case PTI194_VALUE: return PTI194;
			case FIRE_VALUE: return FIRE;
			case PTI194_ALIAS1_VALUE: return PTI194_ALIAS1;
			case LINESIDE_FIRE_VALUE: return LINESIDE_FIRE;
			case PTI195_VALUE: return PTI195;
			case VANDALISM_VALUE: return VANDALISM;
			case PTI195_ALIAS1_VALUE: return PTI195_ALIAS1;
			case PASSENGER_ACTION_VALUE: return PASSENGER_ACTION;
			case PTI195_ALIAS2_VALUE: return PTI195_ALIAS2;
			case STAFF_ASSAULT_VALUE: return STAFF_ASSAULT;
			case PTI195_ALIAS3_VALUE: return PTI195_ALIAS3;
			case RAILWAY_CRIME_VALUE: return RAILWAY_CRIME;
			case PTI195_ALIAS4_VALUE: return PTI195_ALIAS4;
			case ASSAULT_VALUE: return ASSAULT;
			case PTI195_ALIAS5_VALUE: return PTI195_ALIAS5;
			case THEFT_VALUE: return THEFT;
			case ALTERCATION_VALUE: return ALTERCATION;
			case PTI191_ALIAS7_VALUE: return PTI191_ALIAS7;
			case ILL_VEHICLE_OCCUPANTS_VALUE: return ILL_VEHICLE_OCCUPANTS;
			case PTI196_VALUE: return PTI196;
			case ACCIDENT_VALUE: return ACCIDENT;
			case PTI196_ALIAS1_VALUE: return PTI196_ALIAS1;
			case FATALITY_VALUE: return FATALITY;
			case PTI196_ALIAS2_VALUE: return PTI196_ALIAS2;
			case PERSON_UNDER_TRAIN_VALUE: return PERSON_UNDER_TRAIN;
			case PTI196_ALIAS3_VALUE: return PTI196_ALIAS3;
			case PERSON_HIT_BY_TRAIN_VALUE: return PERSON_HIT_BY_TRAIN;
			case PTI196_ALIAS4_VALUE: return PTI196_ALIAS4;
			case PERSON_ILL_ON_VEHICLE_VALUE: return PERSON_ILL_ON_VEHICLE;
			case PTI196_ALIAS5_VALUE: return PTI196_ALIAS5;
			case EMERGENCY_SERVICES_VALUE: return EMERGENCY_SERVICES;
			case PTI196_ALIAS6_VALUE: return PTI196_ALIAS6;
			case COLLISION_VALUE: return COLLISION;
			case PTI197_VALUE: return PTI197;
			case OVERCROWDED_VALUE: return OVERCROWDED;
			case PTI198_VALUE: return PTI198;
			case INSUFFICIENT_DEMAND_VALUE: return INSUFFICIENT_DEMAND;
			case PTI199_VALUE: return PTI199;
			case LIGHTING_FAILURE_VALUE: return LIGHTING_FAILURE;
			case PTI1910_VALUE: return PTI1910;
			case LEADER_BOARD_FAILURE_VALUE: return LEADER_BOARD_FAILURE;
			case PTI1911_VALUE: return PTI1911;
			case SERVICE_INDICATOR_FAILURE_VALUE: return SERVICE_INDICATOR_FAILURE;
			case PTI1912_VALUE: return PTI1912;
			case SERVICE_FAILURE_VALUE: return SERVICE_FAILURE;
			case PTI1913_VALUE: return PTI1913;
			case OPERATOR_CEASED_TRADING_VALUE: return OPERATOR_CEASED_TRADING;
			case PTI1914_VALUE: return PTI1914;
			case OPERATOR_SUSPENDED_VALUE: return OPERATOR_SUSPENDED;
			case PTI1915_VALUE: return PTI1915;
			case CONGESTION_VALUE: return CONGESTION;
			case PTI1916_VALUE: return PTI1916;
			case ROUTE_BLOCKAGE_VALUE: return ROUTE_BLOCKAGE;
			case PTI1917_VALUE: return PTI1917;
			case PERSON_ON_THE_LINE_VALUE: return PERSON_ON_THE_LINE;
			case PTI1918_VALUE: return PTI1918;
			case VEHICLE_ON_THE_LINE_VALUE: return VEHICLE_ON_THE_LINE;
			case PTI1918_ALIAS1_VALUE: return PTI1918_ALIAS1;
			case LEVEL_CROSSING_INCIDENT_VALUE: return LEVEL_CROSSING_INCIDENT;
			case PTI1919_VALUE: return PTI1919;
			case OBJECT_ON_THE_LINE_VALUE: return OBJECT_ON_THE_LINE;
			case PTI1919_ALIAS1_VALUE: return PTI1919_ALIAS1;
			case FALLEN_TREE_ON_THE_LINE_VALUE: return FALLEN_TREE_ON_THE_LINE;
			case PTI1919_ALIAS2_VALUE: return PTI1919_ALIAS2;
			case VEGETATION_VALUE: return VEGETATION;
			case PTI1919_ALIAS3_VALUE: return PTI1919_ALIAS3;
			case TRAIN_STRUCK_ANIMAL_VALUE: return TRAIN_STRUCK_ANIMAL;
			case PTI1919_ALIAS4_VALUE: return PTI1919_ALIAS4;
			case TRAIN_STRUCK_OBJECT_VALUE: return TRAIN_STRUCK_OBJECT;
			case PTI1920_VALUE: return PTI1920;
			case ANIMAL_ON_THE_LINE_VALUE: return ANIMAL_ON_THE_LINE;
			case PTI1921_VALUE: return PTI1921;
			case ROUTE_DIVERSION_VALUE: return ROUTE_DIVERSION;
			case PTI1922_VALUE: return PTI1922;
			case ROAD_CLOSED_VALUE: return ROAD_CLOSED;
			case PTI1923_VALUE: return PTI1923;
			case ROADWORKS_VALUE: return ROADWORKS;
			case PTI1923_ALIAS1_VALUE: return PTI1923_ALIAS1;
			case SEWERAGE_MAINTENANCE_VALUE: return SEWERAGE_MAINTENANCE;
			case PTI1923_ALIAS2_VALUE: return PTI1923_ALIAS2;
			case ROAD_MAINTENANCE_VALUE: return ROAD_MAINTENANCE;
			case PTI1923_ALIAS3_VALUE: return PTI1923_ALIAS3;
			case ASPHALTING_VALUE: return ASPHALTING;
			case PTI1923_ALIAS4_VALUE: return PTI1923_ALIAS4;
			case PAVING_VALUE: return PAVING;
			case PTI1924_VALUE: return PTI1924;
			case SPECIAL_EVENT_VALUE: return SPECIAL_EVENT;
			case PTI1924_ALIAS1_VALUE: return PTI1924_ALIAS1;
			case MARCH_VALUE: return MARCH;
			case PTI1924_ALIAS2_VALUE: return PTI1924_ALIAS2;
			case PROCESSION_VALUE: return PROCESSION;
			case PTI1924_ALIAS3_VALUE: return PTI1924_ALIAS3;
			case DEMONSTRATION_VALUE: return DEMONSTRATION;
			case PTI1924_ALIAS4_VALUE: return PTI1924_ALIAS4;
			case PUBLIC_DISTURBANCE_VALUE: return PUBLIC_DISTURBANCE;
			case PTI1924_ALIAS5_VALUE: return PTI1924_ALIAS5;
			case FILTER_BLOCKADE_VALUE: return FILTER_BLOCKADE;
			case PTI1924_ALIAS6_VALUE: return PTI1924_ALIAS6;
			case SIGHTSEERS_OBSTRUCTING_ACCESS_VALUE: return SIGHTSEERS_OBSTRUCTING_ACCESS;
			case PTI1924_ALIAS7_VALUE: return PTI1924_ALIAS7;
			case HOLIDAY_VALUE: return HOLIDAY;
			case PTI1925_VALUE: return PTI1925;
			case BRIDGE_STRIKE_VALUE: return BRIDGE_STRIKE;
			case PTI1925_ALIAS1_VALUE: return PTI1925_ALIAS1;
			case VIADUCT_FAILURE_VALUE: return VIADUCT_FAILURE;
			case PTI1926_VALUE: return PTI1926;
			case OVERHEAD_OBSTRUCTION_VALUE: return OVERHEAD_OBSTRUCTION;
			case PTI1927_VALUE: return PTI1927;
			case UNDEFINED_PROBLEM_VALUE: return UNDEFINED_PROBLEM;
			case PTI1915_ALIAS1_VALUE: return PTI1915_ALIAS1;
			case PROBLEMS_AT_BORDER_POST_VALUE: return PROBLEMS_AT_BORDER_POST;
			case PTI1915_ALIAS2_VALUE: return PTI1915_ALIAS2;
			case PROBLEMS_AT_CUSTOMS_POST_VALUE: return PROBLEMS_AT_CUSTOMS_POST;
			case PTI1915_ALIAS3_VALUE: return PTI1915_ALIAS3;
			case SPEED_RESTRICTIONS_VALUE: return SPEED_RESTRICTIONS;
			case PTI19255_ALIAS1_VALUE: return PTI19255_ALIAS1;
			case LOGISTIC_PROBLEMS_VALUE: return LOGISTIC_PROBLEMS;
			case PTI19255_ALIAS2_VALUE: return PTI19255_ALIAS2;
			case PROBLEMS_ON_LOCAL_ROAD_VALUE: return PROBLEMS_ON_LOCAL_ROAD;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private MiscellaneousReasonEnumeration(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //MiscellaneousReasonEnumeration
