/*
 */
package siri;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Personnel Reason Enumeration</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Values for Personnel incident reason types TPEG Pti18_2/TPEG Pti_20.
 * <!-- end-model-doc -->
 * @see siri.SiriPackage#getPersonnelReasonEnumeration()
 * @model extendedMetaData="name='PersonnelReasonEnumeration'"
 * @generated
 */
@ProviderType
public enum PersonnelReasonEnumeration implements Enumerator {
	/**
	 * The '<em><b>Pti200</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI200_VALUE
	 * @generated
	 * @ordered
	 */
	PTI200(0, "pti200", "pti20_0"),

	/**
	 * The '<em><b>Unknown</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_0 unknown.
	 * <!-- end-model-doc -->
	 * @see #UNKNOWN_VALUE
	 * @generated
	 * @ordered
	 */
	UNKNOWN(1, "unknown", "unknown"),

	/**
	 * The '<em><b>Pti201</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI201_VALUE
	 * @generated
	 * @ordered
	 */
	PTI201(2, "pti201", "pti20_1"),

	/**
	 * The '<em><b>Staff Sickness</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_1 staff sickness.
	 * <!-- end-model-doc -->
	 * @see #STAFF_SICKNESS_VALUE
	 * @generated
	 * @ordered
	 */
	STAFF_SICKNESS(3, "staffSickness", "staffSickness"),

	/**
	 * The '<em><b>Pti201 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI201_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI201_ALIAS1(4, "pti201Alias1", "pti20_1_Alias_1"),

	/**
	 * The '<em><b>Staff Injury</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 *  staff injury alias to TPEG Pti20_1 staff sickness.
	 * <!-- end-model-doc -->
	 * @see #STAFF_INJURY_VALUE
	 * @generated
	 * @ordered
	 */
	STAFF_INJURY(5, "staffInjury", "staffInjury"),

	/**
	 * The '<em><b>Pti201 Alias2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI201_ALIAS2_VALUE
	 * @generated
	 * @ordered
	 */
	PTI201_ALIAS2(6, "pti201Alias2", "pti20_1_Alias_2"),

	/**
	 * The '<em><b>Contractor Staff Injury</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * contractor staff injury alias to TPEG Pti20_1 staff sickness.
	 * <!-- end-model-doc -->
	 * @see #CONTRACTOR_STAFF_INJURY_VALUE
	 * @generated
	 * @ordered
	 */
	CONTRACTOR_STAFF_INJURY(7, "contractorStaffInjury", "contractorStaffInjury"),

	/**
	 * The '<em><b>Pti202</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI202_VALUE
	 * @generated
	 * @ordered
	 */
	PTI202(8, "pti202", "pti20_2"),

	/**
	 * The '<em><b>Staff Absence</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_2 staff absence.
	 * <!-- end-model-doc -->
	 * @see #STAFF_ABSENCE_VALUE
	 * @generated
	 * @ordered
	 */
	STAFF_ABSENCE(9, "staffAbsence", "staffAbsence"),

	/**
	 * The '<em><b>Pti203</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI203_VALUE
	 * @generated
	 * @ordered
	 */
	PTI203(10, "pti203", "pti20_3"),

	/**
	 * The '<em><b>Staff In Wrong Place</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_3 staff in wrong place.
	 * <!-- end-model-doc -->
	 * @see #STAFF_IN_WRONG_PLACE_VALUE
	 * @generated
	 * @ordered
	 */
	STAFF_IN_WRONG_PLACE(11, "staffInWrongPlace", "staffInWrongPlace"),

	/**
	 * The '<em><b>Pti204</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI204_VALUE
	 * @generated
	 * @ordered
	 */
	PTI204(12, "pti204", "pti20_4"),

	/**
	 * The '<em><b>Staff Shortage</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_4 staff shortage.
	 * <!-- end-model-doc -->
	 * @see #STAFF_SHORTAGE_VALUE
	 * @generated
	 * @ordered
	 */
	STAFF_SHORTAGE(13, "staffShortage", "staffShortage"),

	/**
	 * The '<em><b>Pti205</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI205_VALUE
	 * @generated
	 * @ordered
	 */
	PTI205(14, "pti205", "pti20_5"),

	/**
	 * The '<em><b>Industrial Action</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_5 industrial action.
	 * <!-- end-model-doc -->
	 * @see #INDUSTRIAL_ACTION_VALUE
	 * @generated
	 * @ordered
	 */
	INDUSTRIAL_ACTION(15, "industrialAction", "industrialAction"),

	/**
	 * The '<em><b>Pti205 Alias1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI205_ALIAS1_VALUE
	 * @generated
	 * @ordered
	 */
	PTI205_ALIAS1(16, "pti205Alias1", "pti20_5_Alias_1"),

	/**
	 * The '<em><b>Unofficial Industrial Action</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unofffical action - alias to TPEG Pti20_5 industrial action.
	 * <!-- end-model-doc -->
	 * @see #UNOFFICIAL_INDUSTRIAL_ACTION_VALUE
	 * @generated
	 * @ordered
	 */
	UNOFFICIAL_INDUSTRIAL_ACTION(17, "unofficialIndustrialAction", "unofficialIndustrialAction"),

	/**
	 * The '<em><b>Pti206</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI206_VALUE
	 * @generated
	 * @ordered
	 */
	PTI206(18, "pti206", "pti20_6"),

	/**
	 * The '<em><b>Work To Rule</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_6 work to rule.
	 * <!-- end-model-doc -->
	 * @see #WORK_TO_RULE_VALUE
	 * @generated
	 * @ordered
	 */
	WORK_TO_RULE(19, "workToRule", "workToRule"),

	/**
	 * The '<em><b>Pti20255</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI20255_VALUE
	 * @generated
	 * @ordered
	 */
	PTI20255(20, "pti20255", "pti20_255"),

	/**
	 * The '<em><b>Undefined Personnel Problem</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_255 undefined personnel problem.
	 * <!-- end-model-doc -->
	 * @see #UNDEFINED_PERSONNEL_PROBLEM_VALUE
	 * @generated
	 * @ordered
	 */
	UNDEFINED_PERSONNEL_PROBLEM(21, "undefinedPersonnelProblem", "undefinedPersonnelProblem");

	/**
	 * The '<em><b>Pti200</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI200
	 * @model name="pti200" literal="pti20_0"
	 * @generated
	 * @ordered
	 */
	public static final int PTI200_VALUE = 0;

	/**
	 * The '<em><b>Unknown</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_0 unknown.
	 * <!-- end-model-doc -->
	 * @see #UNKNOWN
	 * @model name="unknown"
	 * @generated
	 * @ordered
	 */
	public static final int UNKNOWN_VALUE = 1;

	/**
	 * The '<em><b>Pti201</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI201
	 * @model name="pti201" literal="pti20_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI201_VALUE = 2;

	/**
	 * The '<em><b>Staff Sickness</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_1 staff sickness.
	 * <!-- end-model-doc -->
	 * @see #STAFF_SICKNESS
	 * @model name="staffSickness"
	 * @generated
	 * @ordered
	 */
	public static final int STAFF_SICKNESS_VALUE = 3;

	/**
	 * The '<em><b>Pti201 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI201_ALIAS1
	 * @model name="pti201Alias1" literal="pti20_1_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI201_ALIAS1_VALUE = 4;

	/**
	 * The '<em><b>Staff Injury</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 *  staff injury alias to TPEG Pti20_1 staff sickness.
	 * <!-- end-model-doc -->
	 * @see #STAFF_INJURY
	 * @model name="staffInjury"
	 * @generated
	 * @ordered
	 */
	public static final int STAFF_INJURY_VALUE = 5;

	/**
	 * The '<em><b>Pti201 Alias2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI201_ALIAS2
	 * @model name="pti201Alias2" literal="pti20_1_Alias_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI201_ALIAS2_VALUE = 6;

	/**
	 * The '<em><b>Contractor Staff Injury</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * contractor staff injury alias to TPEG Pti20_1 staff sickness.
	 * <!-- end-model-doc -->
	 * @see #CONTRACTOR_STAFF_INJURY
	 * @model name="contractorStaffInjury"
	 * @generated
	 * @ordered
	 */
	public static final int CONTRACTOR_STAFF_INJURY_VALUE = 7;

	/**
	 * The '<em><b>Pti202</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI202
	 * @model name="pti202" literal="pti20_2"
	 * @generated
	 * @ordered
	 */
	public static final int PTI202_VALUE = 8;

	/**
	 * The '<em><b>Staff Absence</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_2 staff absence.
	 * <!-- end-model-doc -->
	 * @see #STAFF_ABSENCE
	 * @model name="staffAbsence"
	 * @generated
	 * @ordered
	 */
	public static final int STAFF_ABSENCE_VALUE = 9;

	/**
	 * The '<em><b>Pti203</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI203
	 * @model name="pti203" literal="pti20_3"
	 * @generated
	 * @ordered
	 */
	public static final int PTI203_VALUE = 10;

	/**
	 * The '<em><b>Staff In Wrong Place</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_3 staff in wrong place.
	 * <!-- end-model-doc -->
	 * @see #STAFF_IN_WRONG_PLACE
	 * @model name="staffInWrongPlace"
	 * @generated
	 * @ordered
	 */
	public static final int STAFF_IN_WRONG_PLACE_VALUE = 11;

	/**
	 * The '<em><b>Pti204</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI204
	 * @model name="pti204" literal="pti20_4"
	 * @generated
	 * @ordered
	 */
	public static final int PTI204_VALUE = 12;

	/**
	 * The '<em><b>Staff Shortage</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_4 staff shortage.
	 * <!-- end-model-doc -->
	 * @see #STAFF_SHORTAGE
	 * @model name="staffShortage"
	 * @generated
	 * @ordered
	 */
	public static final int STAFF_SHORTAGE_VALUE = 13;

	/**
	 * The '<em><b>Pti205</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI205
	 * @model name="pti205" literal="pti20_5"
	 * @generated
	 * @ordered
	 */
	public static final int PTI205_VALUE = 14;

	/**
	 * The '<em><b>Industrial Action</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_5 industrial action.
	 * <!-- end-model-doc -->
	 * @see #INDUSTRIAL_ACTION
	 * @model name="industrialAction"
	 * @generated
	 * @ordered
	 */
	public static final int INDUSTRIAL_ACTION_VALUE = 15;

	/**
	 * The '<em><b>Pti205 Alias1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI205_ALIAS1
	 * @model name="pti205Alias1" literal="pti20_5_Alias_1"
	 * @generated
	 * @ordered
	 */
	public static final int PTI205_ALIAS1_VALUE = 16;

	/**
	 * The '<em><b>Unofficial Industrial Action</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unofffical action - alias to TPEG Pti20_5 industrial action.
	 * <!-- end-model-doc -->
	 * @see #UNOFFICIAL_INDUSTRIAL_ACTION
	 * @model name="unofficialIndustrialAction"
	 * @generated
	 * @ordered
	 */
	public static final int UNOFFICIAL_INDUSTRIAL_ACTION_VALUE = 17;

	/**
	 * The '<em><b>Pti206</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI206
	 * @model name="pti206" literal="pti20_6"
	 * @generated
	 * @ordered
	 */
	public static final int PTI206_VALUE = 18;

	/**
	 * The '<em><b>Work To Rule</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_6 work to rule.
	 * <!-- end-model-doc -->
	 * @see #WORK_TO_RULE
	 * @model name="workToRule"
	 * @generated
	 * @ordered
	 */
	public static final int WORK_TO_RULE_VALUE = 19;

	/**
	 * The '<em><b>Pti20255</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PTI20255
	 * @model name="pti20255" literal="pti20_255"
	 * @generated
	 * @ordered
	 */
	public static final int PTI20255_VALUE = 20;

	/**
	 * The '<em><b>Undefined Personnel Problem</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TPEG Pti20_255 undefined personnel problem.
	 * <!-- end-model-doc -->
	 * @see #UNDEFINED_PERSONNEL_PROBLEM
	 * @model name="undefinedPersonnelProblem"
	 * @generated
	 * @ordered
	 */
	public static final int UNDEFINED_PERSONNEL_PROBLEM_VALUE = 21;

	/**
	 * An array of all the '<em><b>Personnel Reason Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final PersonnelReasonEnumeration[] VALUES_ARRAY =
		new PersonnelReasonEnumeration[] {
			PTI200,
			UNKNOWN,
			PTI201,
			STAFF_SICKNESS,
			PTI201_ALIAS1,
			STAFF_INJURY,
			PTI201_ALIAS2,
			CONTRACTOR_STAFF_INJURY,
			PTI202,
			STAFF_ABSENCE,
			PTI203,
			STAFF_IN_WRONG_PLACE,
			PTI204,
			STAFF_SHORTAGE,
			PTI205,
			INDUSTRIAL_ACTION,
			PTI205_ALIAS1,
			UNOFFICIAL_INDUSTRIAL_ACTION,
			PTI206,
			WORK_TO_RULE,
			PTI20255,
			UNDEFINED_PERSONNEL_PROBLEM,
		};

	/**
	 * A public read-only list of all the '<em><b>Personnel Reason Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<PersonnelReasonEnumeration> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Personnel Reason Enumeration</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static PersonnelReasonEnumeration get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			PersonnelReasonEnumeration result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Personnel Reason Enumeration</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static PersonnelReasonEnumeration getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			PersonnelReasonEnumeration result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Personnel Reason Enumeration</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static PersonnelReasonEnumeration get(int value) {
		switch (value) {
			case PTI200_VALUE: return PTI200;
			case UNKNOWN_VALUE: return UNKNOWN;
			case PTI201_VALUE: return PTI201;
			case STAFF_SICKNESS_VALUE: return STAFF_SICKNESS;
			case PTI201_ALIAS1_VALUE: return PTI201_ALIAS1;
			case STAFF_INJURY_VALUE: return STAFF_INJURY;
			case PTI201_ALIAS2_VALUE: return PTI201_ALIAS2;
			case CONTRACTOR_STAFF_INJURY_VALUE: return CONTRACTOR_STAFF_INJURY;
			case PTI202_VALUE: return PTI202;
			case STAFF_ABSENCE_VALUE: return STAFF_ABSENCE;
			case PTI203_VALUE: return PTI203;
			case STAFF_IN_WRONG_PLACE_VALUE: return STAFF_IN_WRONG_PLACE;
			case PTI204_VALUE: return PTI204;
			case STAFF_SHORTAGE_VALUE: return STAFF_SHORTAGE;
			case PTI205_VALUE: return PTI205;
			case INDUSTRIAL_ACTION_VALUE: return INDUSTRIAL_ACTION;
			case PTI205_ALIAS1_VALUE: return PTI205_ALIAS1;
			case UNOFFICIAL_INDUSTRIAL_ACTION_VALUE: return UNOFFICIAL_INDUSTRIAL_ACTION;
			case PTI206_VALUE: return PTI206;
			case WORK_TO_RULE_VALUE: return WORK_TO_RULE;
			case PTI20255_VALUE: return PTI20255;
			case UNDEFINED_PERSONNEL_PROBLEM_VALUE: return UNDEFINED_PERSONNEL_PROBLEM;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private PersonnelReasonEnumeration(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //PersonnelReasonEnumeration
