/*
 */
package siri;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see siri.SiriFactory
 * @model kind="package"
 * @generated
 */
@ProviderType
@EPackage(uri = SiriPackage.eNS_URI, genModel = "/model/vdv454.genmodel", genModelSourceLocations = {"model/vdv454.genmodel","de.jena.vdv454.model/model/vdv454.genmodel"}, ecore="/model/siri.ecore", ecoreSourceLocations="/model/siri.ecore")
public interface SiriPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "siri";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.siri.org.uk/siri";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "siri";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SiriPackage eINSTANCE = siri.impl.SiriPackageImpl.init();

	/**
	 * The meta object id for the '{@link siri.impl.CountryRefStructureImpl <em>Country Ref Structure</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.impl.CountryRefStructureImpl
	 * @see siri.impl.SiriPackageImpl#getCountryRefStructure()
	 * @generated
	 */
	int COUNTRY_REF_STRUCTURE = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_REF_STRUCTURE__VALUE = 0;

	/**
	 * The number of structural features of the '<em>Country Ref Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_REF_STRUCTURE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link siri.impl.EntryQualifierStructureImpl <em>Entry Qualifier Structure</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.impl.EntryQualifierStructureImpl
	 * @see siri.impl.SiriPackageImpl#getEntryQualifierStructure()
	 * @generated
	 */
	int ENTRY_QUALIFIER_STRUCTURE = 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTRY_QUALIFIER_STRUCTURE__VALUE = 0;

	/**
	 * The number of structural features of the '<em>Entry Qualifier Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTRY_QUALIFIER_STRUCTURE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link siri.impl.ParticipantRefStructureImpl <em>Participant Ref Structure</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.impl.ParticipantRefStructureImpl
	 * @see siri.impl.SiriPackageImpl#getParticipantRefStructure()
	 * @generated
	 */
	int PARTICIPANT_REF_STRUCTURE = 2;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_REF_STRUCTURE__VALUE = 0;

	/**
	 * The number of structural features of the '<em>Participant Ref Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_REF_STRUCTURE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link siri.impl.DocumentRootImpl <em>Document Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.impl.DocumentRootImpl
	 * @see siri.impl.SiriPackageImpl#getDocumentRoot()
	 * @generated
	 */
	int DOCUMENT_ROOT = 3;

	/**
	 * The feature id for the '<em><b>Mixed</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MIXED = 0;

	/**
	 * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XMLNS_PREFIX_MAP = 1;

	/**
	 * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = 2;

	/**
	 * The feature id for the '<em><b>Environment Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ENVIRONMENT_REASON = 3;

	/**
	 * The feature id for the '<em><b>Equipment Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EQUIPMENT_REASON = 4;

	/**
	 * The feature id for the '<em><b>Miscellaneous Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MISCELLANEOUS_REASON = 5;

	/**
	 * The feature id for the '<em><b>Personnel Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PERSONNEL_REASON = 6;

	/**
	 * The feature id for the '<em><b>Situation Number</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SITUATION_NUMBER = 7;

	/**
	 * The feature id for the '<em><b>Undefined Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__UNDEFINED_REASON = 8;

	/**
	 * The feature id for the '<em><b>Unknown Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__UNKNOWN_REASON = 9;

	/**
	 * The number of structural features of the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT_FEATURE_COUNT = 10;

	/**
	 * The meta object id for the '{@link siri.EnvironmentReasonEnumeration <em>Environment Reason Enumeration</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.EnvironmentReasonEnumeration
	 * @see siri.impl.SiriPackageImpl#getEnvironmentReasonEnumeration()
	 * @generated
	 */
	int ENVIRONMENT_REASON_ENUMERATION = 4;

	/**
	 * The meta object id for the '{@link siri.EquipmentReasonEnumeration <em>Equipment Reason Enumeration</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.EquipmentReasonEnumeration
	 * @see siri.impl.SiriPackageImpl#getEquipmentReasonEnumeration()
	 * @generated
	 */
	int EQUIPMENT_REASON_ENUMERATION = 5;

	/**
	 * The meta object id for the '{@link siri.IanaCountryTldEnumeration <em>Iana Country Tld Enumeration</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.IanaCountryTldEnumeration
	 * @see siri.impl.SiriPackageImpl#getIanaCountryTldEnumeration()
	 * @generated
	 */
	int IANA_COUNTRY_TLD_ENUMERATION = 6;

	/**
	 * The meta object id for the '{@link siri.MiscellaneousReasonEnumeration <em>Miscellaneous Reason Enumeration</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.MiscellaneousReasonEnumeration
	 * @see siri.impl.SiriPackageImpl#getMiscellaneousReasonEnumeration()
	 * @generated
	 */
	int MISCELLANEOUS_REASON_ENUMERATION = 7;

	/**
	 * The meta object id for the '{@link siri.PersonnelReasonEnumeration <em>Personnel Reason Enumeration</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.PersonnelReasonEnumeration
	 * @see siri.impl.SiriPackageImpl#getPersonnelReasonEnumeration()
	 * @generated
	 */
	int PERSONNEL_REASON_ENUMERATION = 8;

	/**
	 * The meta object id for the '<em>Country Code Type</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.IanaCountryTldEnumeration
	 * @see siri.impl.SiriPackageImpl#getCountryCodeType()
	 * @generated
	 */
	int COUNTRY_CODE_TYPE = 9;

	/**
	 * The meta object id for the '<em>Environment Reason Enumeration Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.EnvironmentReasonEnumeration
	 * @see siri.impl.SiriPackageImpl#getEnvironmentReasonEnumerationObject()
	 * @generated
	 */
	int ENVIRONMENT_REASON_ENUMERATION_OBJECT = 10;

	/**
	 * The meta object id for the '<em>Equipment Reason Enumeration Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.EquipmentReasonEnumeration
	 * @see siri.impl.SiriPackageImpl#getEquipmentReasonEnumerationObject()
	 * @generated
	 */
	int EQUIPMENT_REASON_ENUMERATION_OBJECT = 11;

	/**
	 * The meta object id for the '<em>Iana Country Tld Enumeration Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.IanaCountryTldEnumeration
	 * @see siri.impl.SiriPackageImpl#getIanaCountryTldEnumerationObject()
	 * @generated
	 */
	int IANA_COUNTRY_TLD_ENUMERATION_OBJECT = 12;

	/**
	 * The meta object id for the '<em>Miscellaneous Reason Enumeration Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.MiscellaneousReasonEnumeration
	 * @see siri.impl.SiriPackageImpl#getMiscellaneousReasonEnumerationObject()
	 * @generated
	 */
	int MISCELLANEOUS_REASON_ENUMERATION_OBJECT = 13;

	/**
	 * The meta object id for the '<em>Participant Code Type</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.lang.String
	 * @see siri.impl.SiriPackageImpl#getParticipantCodeType()
	 * @generated
	 */
	int PARTICIPANT_CODE_TYPE = 14;

	/**
	 * The meta object id for the '<em>Personnel Reason Enumeration Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see siri.PersonnelReasonEnumeration
	 * @see siri.impl.SiriPackageImpl#getPersonnelReasonEnumerationObject()
	 * @generated
	 */
	int PERSONNEL_REASON_ENUMERATION_OBJECT = 15;


	/**
	 * Returns the meta object for class '{@link siri.CountryRefStructure <em>Country Ref Structure</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Country Ref Structure</em>'.
	 * @see siri.CountryRefStructure
	 * @generated
	 */
	EClass getCountryRefStructure();

	/**
	 * Returns the meta object for the attribute '{@link siri.CountryRefStructure#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see siri.CountryRefStructure#getValue()
	 * @see #getCountryRefStructure()
	 * @generated
	 */
	EAttribute getCountryRefStructure_Value();

	/**
	 * Returns the meta object for class '{@link siri.EntryQualifierStructure <em>Entry Qualifier Structure</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entry Qualifier Structure</em>'.
	 * @see siri.EntryQualifierStructure
	 * @generated
	 */
	EClass getEntryQualifierStructure();

	/**
	 * Returns the meta object for the attribute '{@link siri.EntryQualifierStructure#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see siri.EntryQualifierStructure#getValue()
	 * @see #getEntryQualifierStructure()
	 * @generated
	 */
	EAttribute getEntryQualifierStructure_Value();

	/**
	 * Returns the meta object for class '{@link siri.ParticipantRefStructure <em>Participant Ref Structure</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Participant Ref Structure</em>'.
	 * @see siri.ParticipantRefStructure
	 * @generated
	 */
	EClass getParticipantRefStructure();

	/**
	 * Returns the meta object for the attribute '{@link siri.ParticipantRefStructure#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see siri.ParticipantRefStructure#getValue()
	 * @see #getParticipantRefStructure()
	 * @generated
	 */
	EAttribute getParticipantRefStructure_Value();

	/**
	 * Returns the meta object for class '{@link siri.DocumentRoot <em>Document Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Root</em>'.
	 * @see siri.DocumentRoot
	 * @generated
	 */
	EClass getDocumentRoot();

	/**
	 * Returns the meta object for the attribute list '{@link siri.DocumentRoot#getMixed <em>Mixed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mixed</em>'.
	 * @see siri.DocumentRoot#getMixed()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_Mixed();

	/**
	 * Returns the meta object for the map '{@link siri.DocumentRoot#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>XMLNS Prefix Map</em>'.
	 * @see siri.DocumentRoot#getXMLNSPrefixMap()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_XMLNSPrefixMap();

	/**
	 * Returns the meta object for the map '{@link siri.DocumentRoot#getXSISchemaLocation <em>XSI Schema Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>XSI Schema Location</em>'.
	 * @see siri.DocumentRoot#getXSISchemaLocation()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_XSISchemaLocation();

	/**
	 * Returns the meta object for the attribute '{@link siri.DocumentRoot#getEnvironmentReason <em>Environment Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Environment Reason</em>'.
	 * @see siri.DocumentRoot#getEnvironmentReason()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_EnvironmentReason();

	/**
	 * Returns the meta object for the attribute '{@link siri.DocumentRoot#getEquipmentReason <em>Equipment Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Equipment Reason</em>'.
	 * @see siri.DocumentRoot#getEquipmentReason()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_EquipmentReason();

	/**
	 * Returns the meta object for the attribute '{@link siri.DocumentRoot#getMiscellaneousReason <em>Miscellaneous Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Miscellaneous Reason</em>'.
	 * @see siri.DocumentRoot#getMiscellaneousReason()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_MiscellaneousReason();

	/**
	 * Returns the meta object for the attribute '{@link siri.DocumentRoot#getPersonnelReason <em>Personnel Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Personnel Reason</em>'.
	 * @see siri.DocumentRoot#getPersonnelReason()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_PersonnelReason();

	/**
	 * Returns the meta object for the containment reference '{@link siri.DocumentRoot#getSituationNumber <em>Situation Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Situation Number</em>'.
	 * @see siri.DocumentRoot#getSituationNumber()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_SituationNumber();

	/**
	 * Returns the meta object for the attribute '{@link siri.DocumentRoot#getUndefinedReason <em>Undefined Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Undefined Reason</em>'.
	 * @see siri.DocumentRoot#getUndefinedReason()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_UndefinedReason();

	/**
	 * Returns the meta object for the attribute '{@link siri.DocumentRoot#getUnknownReason <em>Unknown Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unknown Reason</em>'.
	 * @see siri.DocumentRoot#getUnknownReason()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_UnknownReason();

	/**
	 * Returns the meta object for enum '{@link siri.EnvironmentReasonEnumeration <em>Environment Reason Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Environment Reason Enumeration</em>'.
	 * @see siri.EnvironmentReasonEnumeration
	 * @generated
	 */
	EEnum getEnvironmentReasonEnumeration();

	/**
	 * Returns the meta object for enum '{@link siri.EquipmentReasonEnumeration <em>Equipment Reason Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Equipment Reason Enumeration</em>'.
	 * @see siri.EquipmentReasonEnumeration
	 * @generated
	 */
	EEnum getEquipmentReasonEnumeration();

	/**
	 * Returns the meta object for enum '{@link siri.IanaCountryTldEnumeration <em>Iana Country Tld Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Iana Country Tld Enumeration</em>'.
	 * @see siri.IanaCountryTldEnumeration
	 * @generated
	 */
	EEnum getIanaCountryTldEnumeration();

	/**
	 * Returns the meta object for enum '{@link siri.MiscellaneousReasonEnumeration <em>Miscellaneous Reason Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Miscellaneous Reason Enumeration</em>'.
	 * @see siri.MiscellaneousReasonEnumeration
	 * @generated
	 */
	EEnum getMiscellaneousReasonEnumeration();

	/**
	 * Returns the meta object for enum '{@link siri.PersonnelReasonEnumeration <em>Personnel Reason Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Personnel Reason Enumeration</em>'.
	 * @see siri.PersonnelReasonEnumeration
	 * @generated
	 */
	EEnum getPersonnelReasonEnumeration();

	/**
	 * Returns the meta object for data type '{@link siri.IanaCountryTldEnumeration <em>Country Code Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * <!-- begin-model-doc -->
     * Type for Country identifier.
     * <!-- end-model-doc -->
	 * @return the meta object for data type '<em>Country Code Type</em>'.
	 * @see siri.IanaCountryTldEnumeration
	 * @model instanceClass="siri.IanaCountryTldEnumeration"
	 *        extendedMetaData="name='CountryCodeType' baseType='IanaCountryTldEnumeration'"
	 * @generated
	 */
	EDataType getCountryCodeType();

	/**
	 * Returns the meta object for data type '{@link siri.EnvironmentReasonEnumeration <em>Environment Reason Enumeration Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Environment Reason Enumeration Object</em>'.
	 * @see siri.EnvironmentReasonEnumeration
	 * @model instanceClass="siri.EnvironmentReasonEnumeration"
	 *        extendedMetaData="name='EnvironmentReasonEnumeration:Object' baseType='EnvironmentReasonEnumeration'"
	 * @generated
	 */
	EDataType getEnvironmentReasonEnumerationObject();

	/**
	 * Returns the meta object for data type '{@link siri.EquipmentReasonEnumeration <em>Equipment Reason Enumeration Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Equipment Reason Enumeration Object</em>'.
	 * @see siri.EquipmentReasonEnumeration
	 * @model instanceClass="siri.EquipmentReasonEnumeration"
	 *        extendedMetaData="name='EquipmentReasonEnumeration:Object' baseType='EquipmentReasonEnumeration'"
	 * @generated
	 */
	EDataType getEquipmentReasonEnumerationObject();

	/**
	 * Returns the meta object for data type '{@link siri.IanaCountryTldEnumeration <em>Iana Country Tld Enumeration Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Iana Country Tld Enumeration Object</em>'.
	 * @see siri.IanaCountryTldEnumeration
	 * @model instanceClass="siri.IanaCountryTldEnumeration"
	 *        extendedMetaData="name='IanaCountryTldEnumeration:Object' baseType='IanaCountryTldEnumeration'"
	 * @generated
	 */
	EDataType getIanaCountryTldEnumerationObject();

	/**
	 * Returns the meta object for data type '{@link siri.MiscellaneousReasonEnumeration <em>Miscellaneous Reason Enumeration Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Miscellaneous Reason Enumeration Object</em>'.
	 * @see siri.MiscellaneousReasonEnumeration
	 * @model instanceClass="siri.MiscellaneousReasonEnumeration"
	 *        extendedMetaData="name='MiscellaneousReasonEnumeration:Object' baseType='MiscellaneousReasonEnumeration'"
	 * @generated
	 */
	EDataType getMiscellaneousReasonEnumerationObject();

	/**
	 * Returns the meta object for data type '{@link java.lang.String <em>Participant Code Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * <!-- begin-model-doc -->
     * Type for Unique identifier of participant.
     * <!-- end-model-doc -->
	 * @return the meta object for data type '<em>Participant Code Type</em>'.
	 * @see java.lang.String
	 * @model instanceClass="java.lang.String"
	 *        extendedMetaData="name='ParticipantCodeType' baseType='http://www.eclipse.org/emf/2003/XMLType#NMTOKEN'"
	 * @generated
	 */
	EDataType getParticipantCodeType();

	/**
	 * Returns the meta object for data type '{@link siri.PersonnelReasonEnumeration <em>Personnel Reason Enumeration Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Personnel Reason Enumeration Object</em>'.
	 * @see siri.PersonnelReasonEnumeration
	 * @model instanceClass="siri.PersonnelReasonEnumeration"
	 *        extendedMetaData="name='PersonnelReasonEnumeration:Object' baseType='PersonnelReasonEnumeration'"
	 * @generated
	 */
	EDataType getPersonnelReasonEnumerationObject();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	SiriFactory getSiriFactory();

} //SiriPackage
