/*
 */
package siri.impl;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

import siri.DocumentRoot;
import siri.EntryQualifierStructure;
import siri.EnvironmentReasonEnumeration;
import siri.EquipmentReasonEnumeration;
import siri.MiscellaneousReasonEnumeration;
import siri.PersonnelReasonEnumeration;
import siri.SiriPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Document Root</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link siri.impl.DocumentRootImpl#getMixed <em>Mixed</em>}</li>
 *   <li>{@link siri.impl.DocumentRootImpl#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}</li>
 *   <li>{@link siri.impl.DocumentRootImpl#getXSISchemaLocation <em>XSI Schema Location</em>}</li>
 *   <li>{@link siri.impl.DocumentRootImpl#getEnvironmentReason <em>Environment Reason</em>}</li>
 *   <li>{@link siri.impl.DocumentRootImpl#getEquipmentReason <em>Equipment Reason</em>}</li>
 *   <li>{@link siri.impl.DocumentRootImpl#getMiscellaneousReason <em>Miscellaneous Reason</em>}</li>
 *   <li>{@link siri.impl.DocumentRootImpl#getPersonnelReason <em>Personnel Reason</em>}</li>
 *   <li>{@link siri.impl.DocumentRootImpl#getSituationNumber <em>Situation Number</em>}</li>
 *   <li>{@link siri.impl.DocumentRootImpl#getUndefinedReason <em>Undefined Reason</em>}</li>
 *   <li>{@link siri.impl.DocumentRootImpl#getUnknownReason <em>Unknown Reason</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DocumentRootImpl extends MinimalEObjectImpl.Container implements DocumentRoot {
	/**
	 * The cached value of the '{@link #getMixed() <em>Mixed</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMixed()
	 * @generated
	 * @ordered
	 */
	protected FeatureMap mixed;

	/**
	 * The cached value of the '{@link #getXMLNSPrefixMap() <em>XMLNS Prefix Map</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXMLNSPrefixMap()
	 * @generated
	 * @ordered
	 */
	protected EMap<String, String> xMLNSPrefixMap;

	/**
	 * The cached value of the '{@link #getXSISchemaLocation() <em>XSI Schema Location</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXSISchemaLocation()
	 * @generated
	 * @ordered
	 */
	protected EMap<String, String> xSISchemaLocation;

	/**
	 * The default value of the '{@link #getEnvironmentReason() <em>Environment Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnvironmentReason()
	 * @generated
	 * @ordered
	 */
	protected static final EnvironmentReasonEnumeration ENVIRONMENT_REASON_EDEFAULT = EnvironmentReasonEnumeration.PTI220;

	/**
	 * The default value of the '{@link #getEquipmentReason() <em>Equipment Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEquipmentReason()
	 * @generated
	 * @ordered
	 */
	protected static final EquipmentReasonEnumeration EQUIPMENT_REASON_EDEFAULT = EquipmentReasonEnumeration.PTI210;

	/**
	 * The default value of the '{@link #getMiscellaneousReason() <em>Miscellaneous Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMiscellaneousReason()
	 * @generated
	 * @ordered
	 */
	protected static final MiscellaneousReasonEnumeration MISCELLANEOUS_REASON_EDEFAULT = MiscellaneousReasonEnumeration.PTI190;

	/**
	 * The default value of the '{@link #getPersonnelReason() <em>Personnel Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPersonnelReason()
	 * @generated
	 * @ordered
	 */
	protected static final PersonnelReasonEnumeration PERSONNEL_REASON_EDEFAULT = PersonnelReasonEnumeration.PTI200;

	/**
	 * The default value of the '{@link #getUndefinedReason() <em>Undefined Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUndefinedReason()
	 * @generated
	 * @ordered
	 */
	protected static final String UNDEFINED_REASON_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getUnknownReason() <em>Unknown Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnknownReason()
	 * @generated
	 * @ordered
	 */
	protected static final String UNKNOWN_REASON_EDEFAULT = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentRootImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SiriPackage.eINSTANCE.getDocumentRoot();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeatureMap getMixed() {
		if (mixed == null) {
			mixed = new BasicFeatureMap(this, SiriPackage.DOCUMENT_ROOT__MIXED);
		}
		return mixed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EMap<String, String> getXMLNSPrefixMap() {
		if (xMLNSPrefixMap == null) {
			xMLNSPrefixMap = new EcoreEMap<String,String>(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, this, SiriPackage.DOCUMENT_ROOT__XMLNS_PREFIX_MAP);
		}
		return xMLNSPrefixMap;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EMap<String, String> getXSISchemaLocation() {
		if (xSISchemaLocation == null) {
			xSISchemaLocation = new EcoreEMap<String,String>(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, this, SiriPackage.DOCUMENT_ROOT__XSI_SCHEMA_LOCATION);
		}
		return xSISchemaLocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EnvironmentReasonEnumeration getEnvironmentReason() {
		return (EnvironmentReasonEnumeration)getMixed().get(SiriPackage.eINSTANCE.getDocumentRoot_EnvironmentReason(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEnvironmentReason(EnvironmentReasonEnumeration newEnvironmentReason) {
		((FeatureMap.Internal)getMixed()).set(SiriPackage.eINSTANCE.getDocumentRoot_EnvironmentReason(), newEnvironmentReason);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EquipmentReasonEnumeration getEquipmentReason() {
		return (EquipmentReasonEnumeration)getMixed().get(SiriPackage.eINSTANCE.getDocumentRoot_EquipmentReason(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEquipmentReason(EquipmentReasonEnumeration newEquipmentReason) {
		((FeatureMap.Internal)getMixed()).set(SiriPackage.eINSTANCE.getDocumentRoot_EquipmentReason(), newEquipmentReason);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MiscellaneousReasonEnumeration getMiscellaneousReason() {
		return (MiscellaneousReasonEnumeration)getMixed().get(SiriPackage.eINSTANCE.getDocumentRoot_MiscellaneousReason(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMiscellaneousReason(MiscellaneousReasonEnumeration newMiscellaneousReason) {
		((FeatureMap.Internal)getMixed()).set(SiriPackage.eINSTANCE.getDocumentRoot_MiscellaneousReason(), newMiscellaneousReason);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PersonnelReasonEnumeration getPersonnelReason() {
		return (PersonnelReasonEnumeration)getMixed().get(SiriPackage.eINSTANCE.getDocumentRoot_PersonnelReason(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPersonnelReason(PersonnelReasonEnumeration newPersonnelReason) {
		((FeatureMap.Internal)getMixed()).set(SiriPackage.eINSTANCE.getDocumentRoot_PersonnelReason(), newPersonnelReason);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EntryQualifierStructure getSituationNumber() {
		return (EntryQualifierStructure)getMixed().get(SiriPackage.eINSTANCE.getDocumentRoot_SituationNumber(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSituationNumber(EntryQualifierStructure newSituationNumber, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(SiriPackage.eINSTANCE.getDocumentRoot_SituationNumber(), newSituationNumber, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSituationNumber(EntryQualifierStructure newSituationNumber) {
		((FeatureMap.Internal)getMixed()).set(SiriPackage.eINSTANCE.getDocumentRoot_SituationNumber(), newSituationNumber);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUndefinedReason() {
		return (String)getMixed().get(SiriPackage.eINSTANCE.getDocumentRoot_UndefinedReason(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUndefinedReason(String newUndefinedReason) {
		((FeatureMap.Internal)getMixed()).set(SiriPackage.eINSTANCE.getDocumentRoot_UndefinedReason(), newUndefinedReason);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUnknownReason() {
		return (String)getMixed().get(SiriPackage.eINSTANCE.getDocumentRoot_UnknownReason(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUnknownReason(String newUnknownReason) {
		((FeatureMap.Internal)getMixed()).set(SiriPackage.eINSTANCE.getDocumentRoot_UnknownReason(), newUnknownReason);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SiriPackage.DOCUMENT_ROOT__MIXED:
				return ((InternalEList<?>)getMixed()).basicRemove(otherEnd, msgs);
			case SiriPackage.DOCUMENT_ROOT__XMLNS_PREFIX_MAP:
				return ((InternalEList<?>)getXMLNSPrefixMap()).basicRemove(otherEnd, msgs);
			case SiriPackage.DOCUMENT_ROOT__XSI_SCHEMA_LOCATION:
				return ((InternalEList<?>)getXSISchemaLocation()).basicRemove(otherEnd, msgs);
			case SiriPackage.DOCUMENT_ROOT__SITUATION_NUMBER:
				return basicSetSituationNumber(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SiriPackage.DOCUMENT_ROOT__MIXED:
				if (coreType) return getMixed();
				return ((FeatureMap.Internal)getMixed()).getWrapper();
			case SiriPackage.DOCUMENT_ROOT__XMLNS_PREFIX_MAP:
				if (coreType) return getXMLNSPrefixMap();
				else return getXMLNSPrefixMap().map();
			case SiriPackage.DOCUMENT_ROOT__XSI_SCHEMA_LOCATION:
				if (coreType) return getXSISchemaLocation();
				else return getXSISchemaLocation().map();
			case SiriPackage.DOCUMENT_ROOT__ENVIRONMENT_REASON:
				return getEnvironmentReason();
			case SiriPackage.DOCUMENT_ROOT__EQUIPMENT_REASON:
				return getEquipmentReason();
			case SiriPackage.DOCUMENT_ROOT__MISCELLANEOUS_REASON:
				return getMiscellaneousReason();
			case SiriPackage.DOCUMENT_ROOT__PERSONNEL_REASON:
				return getPersonnelReason();
			case SiriPackage.DOCUMENT_ROOT__SITUATION_NUMBER:
				return getSituationNumber();
			case SiriPackage.DOCUMENT_ROOT__UNDEFINED_REASON:
				return getUndefinedReason();
			case SiriPackage.DOCUMENT_ROOT__UNKNOWN_REASON:
				return getUnknownReason();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SiriPackage.DOCUMENT_ROOT__MIXED:
				((FeatureMap.Internal)getMixed()).set(newValue);
				return;
			case SiriPackage.DOCUMENT_ROOT__XMLNS_PREFIX_MAP:
				((EStructuralFeature.Setting)getXMLNSPrefixMap()).set(newValue);
				return;
			case SiriPackage.DOCUMENT_ROOT__XSI_SCHEMA_LOCATION:
				((EStructuralFeature.Setting)getXSISchemaLocation()).set(newValue);
				return;
			case SiriPackage.DOCUMENT_ROOT__ENVIRONMENT_REASON:
				setEnvironmentReason((EnvironmentReasonEnumeration)newValue);
				return;
			case SiriPackage.DOCUMENT_ROOT__EQUIPMENT_REASON:
				setEquipmentReason((EquipmentReasonEnumeration)newValue);
				return;
			case SiriPackage.DOCUMENT_ROOT__MISCELLANEOUS_REASON:
				setMiscellaneousReason((MiscellaneousReasonEnumeration)newValue);
				return;
			case SiriPackage.DOCUMENT_ROOT__PERSONNEL_REASON:
				setPersonnelReason((PersonnelReasonEnumeration)newValue);
				return;
			case SiriPackage.DOCUMENT_ROOT__SITUATION_NUMBER:
				setSituationNumber((EntryQualifierStructure)newValue);
				return;
			case SiriPackage.DOCUMENT_ROOT__UNDEFINED_REASON:
				setUndefinedReason((String)newValue);
				return;
			case SiriPackage.DOCUMENT_ROOT__UNKNOWN_REASON:
				setUnknownReason((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SiriPackage.DOCUMENT_ROOT__MIXED:
				getMixed().clear();
				return;
			case SiriPackage.DOCUMENT_ROOT__XMLNS_PREFIX_MAP:
				getXMLNSPrefixMap().clear();
				return;
			case SiriPackage.DOCUMENT_ROOT__XSI_SCHEMA_LOCATION:
				getXSISchemaLocation().clear();
				return;
			case SiriPackage.DOCUMENT_ROOT__ENVIRONMENT_REASON:
				setEnvironmentReason(ENVIRONMENT_REASON_EDEFAULT);
				return;
			case SiriPackage.DOCUMENT_ROOT__EQUIPMENT_REASON:
				setEquipmentReason(EQUIPMENT_REASON_EDEFAULT);
				return;
			case SiriPackage.DOCUMENT_ROOT__MISCELLANEOUS_REASON:
				setMiscellaneousReason(MISCELLANEOUS_REASON_EDEFAULT);
				return;
			case SiriPackage.DOCUMENT_ROOT__PERSONNEL_REASON:
				setPersonnelReason(PERSONNEL_REASON_EDEFAULT);
				return;
			case SiriPackage.DOCUMENT_ROOT__SITUATION_NUMBER:
				setSituationNumber((EntryQualifierStructure)null);
				return;
			case SiriPackage.DOCUMENT_ROOT__UNDEFINED_REASON:
				setUndefinedReason(UNDEFINED_REASON_EDEFAULT);
				return;
			case SiriPackage.DOCUMENT_ROOT__UNKNOWN_REASON:
				setUnknownReason(UNKNOWN_REASON_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SiriPackage.DOCUMENT_ROOT__MIXED:
				return mixed != null && !mixed.isEmpty();
			case SiriPackage.DOCUMENT_ROOT__XMLNS_PREFIX_MAP:
				return xMLNSPrefixMap != null && !xMLNSPrefixMap.isEmpty();
			case SiriPackage.DOCUMENT_ROOT__XSI_SCHEMA_LOCATION:
				return xSISchemaLocation != null && !xSISchemaLocation.isEmpty();
			case SiriPackage.DOCUMENT_ROOT__ENVIRONMENT_REASON:
				return getEnvironmentReason() != ENVIRONMENT_REASON_EDEFAULT;
			case SiriPackage.DOCUMENT_ROOT__EQUIPMENT_REASON:
				return getEquipmentReason() != EQUIPMENT_REASON_EDEFAULT;
			case SiriPackage.DOCUMENT_ROOT__MISCELLANEOUS_REASON:
				return getMiscellaneousReason() != MISCELLANEOUS_REASON_EDEFAULT;
			case SiriPackage.DOCUMENT_ROOT__PERSONNEL_REASON:
				return getPersonnelReason() != PERSONNEL_REASON_EDEFAULT;
			case SiriPackage.DOCUMENT_ROOT__SITUATION_NUMBER:
				return getSituationNumber() != null;
			case SiriPackage.DOCUMENT_ROOT__UNDEFINED_REASON:
				return UNDEFINED_REASON_EDEFAULT == null ? getUndefinedReason() != null : !UNDEFINED_REASON_EDEFAULT.equals(getUndefinedReason());
			case SiriPackage.DOCUMENT_ROOT__UNKNOWN_REASON:
				return UNKNOWN_REASON_EDEFAULT == null ? getUnknownReason() != null : !UNKNOWN_REASON_EDEFAULT.equals(getUnknownReason());
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (mixed: ");
		result.append(mixed);
		result.append(')');
		return result.toString();
	}

} //DocumentRootImpl
